/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Document represents the canonical document resource in Document AI. It is an
 * interchange format that provides insights into documents and allows for
 * collaboration between users and Document AI to iterate and optimize for
 * quality.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.Document}
 */
public final class Document extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document)
    DocumentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Document.newBuilder() to construct.
  private Document(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Document() {
    mimeType_ = "";
    text_ = "";
    textStyles_ = java.util.Collections.emptyList();
    pages_ = java.util.Collections.emptyList();
    entities_ = java.util.Collections.emptyList();
    entityRelations_ = java.util.Collections.emptyList();
    textChanges_ = java.util.Collections.emptyList();
    revisions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Document();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentProto
        .internal_static_google_cloud_documentai_v1beta3_Document_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentProto
        .internal_static_google_cloud_documentai_v1beta3_Document_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.Document.class,
            com.google.cloud.documentai.v1beta3.Document.Builder.class);
  }

  public interface ShardInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.ShardInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The 0-based index of this shard.
     * </pre>
     *
     * <code>int64 shard_index = 1;</code>
     *
     * @return The shardIndex.
     */
    long getShardIndex();

    /**
     *
     *
     * <pre>
     * Total number of shards.
     * </pre>
     *
     * <code>int64 shard_count = 2;</code>
     *
     * @return The shardCount.
     */
    long getShardCount();

    /**
     *
     *
     * <pre>
     * The index of the first character in
     * [Document.text][google.cloud.documentai.v1beta3.Document.text] in the
     * overall document global text.
     * </pre>
     *
     * <code>int64 text_offset = 3;</code>
     *
     * @return The textOffset.
     */
    long getTextOffset();
  }
  /**
   *
   *
   * <pre>
   * For a large document, sharding may be performed to produce several
   * document shards. Each document shard contains this field to detail which
   * shard it is.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Document.ShardInfo}
   */
  public static final class ShardInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.ShardInfo)
      ShardInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ShardInfo.newBuilder() to construct.
    private ShardInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ShardInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ShardInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_ShardInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_ShardInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Document.ShardInfo.class,
              com.google.cloud.documentai.v1beta3.Document.ShardInfo.Builder.class);
    }

    public static final int SHARD_INDEX_FIELD_NUMBER = 1;
    private long shardIndex_ = 0L;
    /**
     *
     *
     * <pre>
     * The 0-based index of this shard.
     * </pre>
     *
     * <code>int64 shard_index = 1;</code>
     *
     * @return The shardIndex.
     */
    @java.lang.Override
    public long getShardIndex() {
      return shardIndex_;
    }

    public static final int SHARD_COUNT_FIELD_NUMBER = 2;
    private long shardCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Total number of shards.
     * </pre>
     *
     * <code>int64 shard_count = 2;</code>
     *
     * @return The shardCount.
     */
    @java.lang.Override
    public long getShardCount() {
      return shardCount_;
    }

    public static final int TEXT_OFFSET_FIELD_NUMBER = 3;
    private long textOffset_ = 0L;
    /**
     *
     *
     * <pre>
     * The index of the first character in
     * [Document.text][google.cloud.documentai.v1beta3.Document.text] in the
     * overall document global text.
     * </pre>
     *
     * <code>int64 text_offset = 3;</code>
     *
     * @return The textOffset.
     */
    @java.lang.Override
    public long getTextOffset() {
      return textOffset_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (shardIndex_ != 0L) {
        output.writeInt64(1, shardIndex_);
      }
      if (shardCount_ != 0L) {
        output.writeInt64(2, shardCount_);
      }
      if (textOffset_ != 0L) {
        output.writeInt64(3, textOffset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (shardIndex_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, shardIndex_);
      }
      if (shardCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, shardCount_);
      }
      if (textOffset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, textOffset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.ShardInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Document.ShardInfo other =
          (com.google.cloud.documentai.v1beta3.Document.ShardInfo) obj;

      if (getShardIndex() != other.getShardIndex()) return false;
      if (getShardCount() != other.getShardCount()) return false;
      if (getTextOffset() != other.getTextOffset()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SHARD_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShardIndex());
      hash = (37 * hash) + SHARD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShardCount());
      hash = (37 * hash) + TEXT_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTextOffset());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.Document.ShardInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * For a large document, sharding may be performed to produce several
     * document shards. Each document shard contains this field to detail which
     * shard it is.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.ShardInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.ShardInfo)
        com.google.cloud.documentai.v1beta3.Document.ShardInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_ShardInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_ShardInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.ShardInfo.class,
                com.google.cloud.documentai.v1beta3.Document.ShardInfo.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.Document.ShardInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        shardIndex_ = 0L;
        shardCount_ = 0L;
        textOffset_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_ShardInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.ShardInfo getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Document.ShardInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.ShardInfo build() {
        com.google.cloud.documentai.v1beta3.Document.ShardInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.ShardInfo buildPartial() {
        com.google.cloud.documentai.v1beta3.Document.ShardInfo result =
            new com.google.cloud.documentai.v1beta3.Document.ShardInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.ShardInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.shardIndex_ = shardIndex_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.shardCount_ = shardCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.textOffset_ = textOffset_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Document.ShardInfo) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.Document.ShardInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.ShardInfo other) {
        if (other == com.google.cloud.documentai.v1beta3.Document.ShardInfo.getDefaultInstance())
          return this;
        if (other.getShardIndex() != 0L) {
          setShardIndex(other.getShardIndex());
        }
        if (other.getShardCount() != 0L) {
          setShardCount(other.getShardCount());
        }
        if (other.getTextOffset() != 0L) {
          setTextOffset(other.getTextOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  shardIndex_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  shardCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  textOffset_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long shardIndex_;
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @return The shardIndex.
       */
      @java.lang.Override
      public long getShardIndex() {
        return shardIndex_;
      }
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @param value The shardIndex to set.
       * @return This builder for chaining.
       */
      public Builder setShardIndex(long value) {

        shardIndex_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The 0-based index of this shard.
       * </pre>
       *
       * <code>int64 shard_index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        shardIndex_ = 0L;
        onChanged();
        return this;
      }

      private long shardCount_;
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @return The shardCount.
       */
      @java.lang.Override
      public long getShardCount() {
        return shardCount_;
      }
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @param value The shardCount to set.
       * @return This builder for chaining.
       */
      public Builder setShardCount(long value) {

        shardCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of shards.
       * </pre>
       *
       * <code>int64 shard_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearShardCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        shardCount_ = 0L;
        onChanged();
        return this;
      }

      private long textOffset_;
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta3.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @return The textOffset.
       */
      @java.lang.Override
      public long getTextOffset() {
        return textOffset_;
      }
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta3.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @param value The textOffset to set.
       * @return This builder for chaining.
       */
      public Builder setTextOffset(long value) {

        textOffset_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index of the first character in
       * [Document.text][google.cloud.documentai.v1beta3.Document.text] in the
       * overall document global text.
       * </pre>
       *
       * <code>int64 text_offset = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextOffset() {
        bitField0_ = (bitField0_ & ~0x00000004);
        textOffset_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.ShardInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.ShardInfo)
    private static final com.google.cloud.documentai.v1beta3.Document.ShardInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.ShardInfo();
    }

    public static com.google.cloud.documentai.v1beta3.Document.ShardInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ShardInfo> PARSER =
        new com.google.protobuf.AbstractParser<ShardInfo>() {
          @java.lang.Override
          public ShardInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ShardInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ShardInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.ShardInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StyleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Style)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return Whether the textAnchor field is set.
     */
    boolean hasTextAnchor();
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return The textAnchor.
     */
    com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor();
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder getTextAnchorOrBuilder();

    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return Whether the color field is set.
     */
    boolean hasColor();
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return The color.
     */
    com.google.type.Color getColor();
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     */
    com.google.type.ColorOrBuilder getColorOrBuilder();

    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return Whether the backgroundColor field is set.
     */
    boolean hasBackgroundColor();
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return The backgroundColor.
     */
    com.google.type.Color getBackgroundColor();
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     */
    com.google.type.ColorOrBuilder getBackgroundColorOrBuilder();

    /**
     *
     *
     * <pre>
     * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
     * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The fontWeight.
     */
    java.lang.String getFontWeight();
    /**
     *
     *
     * <pre>
     * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
     * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The bytes for fontWeight.
     */
    com.google.protobuf.ByteString getFontWeightBytes();

    /**
     *
     *
     * <pre>
     * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
     * Possible values are `normal`, `italic`, and `oblique`.
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The textStyle.
     */
    java.lang.String getTextStyle();
    /**
     *
     *
     * <pre>
     * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
     * Possible values are `normal`, `italic`, and `oblique`.
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The bytes for textStyle.
     */
    com.google.protobuf.ByteString getTextStyleBytes();

    /**
     *
     *
     * <pre>
     * [Text
     * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
     * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
     * &lt;text-decoration-style&gt;
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The textDecoration.
     */
    java.lang.String getTextDecoration();
    /**
     *
     *
     * <pre>
     * [Text
     * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
     * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
     * &lt;text-decoration-style&gt;
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The bytes for textDecoration.
     */
    com.google.protobuf.ByteString getTextDecorationBytes();

    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     *
     * @return Whether the fontSize field is set.
     */
    boolean hasFontSize();
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     *
     * @return The fontSize.
     */
    com.google.cloud.documentai.v1beta3.Document.Style.FontSize getFontSize();
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder getFontSizeOrBuilder();

    /**
     *
     *
     * <pre>
     * Font family such as `Arial`, `Times New Roman`.
     * https://www.w3schools.com/cssref/pr_font_font-family.asp
     * </pre>
     *
     * <code>string font_family = 8;</code>
     *
     * @return The fontFamily.
     */
    java.lang.String getFontFamily();
    /**
     *
     *
     * <pre>
     * Font family such as `Arial`, `Times New Roman`.
     * https://www.w3schools.com/cssref/pr_font_font-family.asp
     * </pre>
     *
     * <code>string font_family = 8;</code>
     *
     * @return The bytes for fontFamily.
     */
    com.google.protobuf.ByteString getFontFamilyBytes();
  }
  /**
   *
   *
   * <pre>
   * Annotation for common text style attributes. This adheres to CSS
   * conventions as much as possible.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Style}
   */
  public static final class Style extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Style)
      StyleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Style.newBuilder() to construct.
    private Style(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Style() {
      fontWeight_ = "";
      textStyle_ = "";
      textDecoration_ = "";
      fontFamily_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Style();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_Style_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_Style_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Document.Style.class,
              com.google.cloud.documentai.v1beta3.Document.Style.Builder.class);
    }

    public interface FontSizeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Style.FontSize)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Font size for the text.
       * </pre>
       *
       * <code>float size = 1;</code>
       *
       * @return The size.
       */
      float getSize();

      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
       * `pt`).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The unit.
       */
      java.lang.String getUnit();
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
       * `pt`).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The bytes for unit.
       */
      com.google.protobuf.ByteString getUnitBytes();
    }
    /**
     *
     *
     * <pre>
     * Font size with unit.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Style.FontSize}
     */
    public static final class FontSize extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Style.FontSize)
        FontSizeOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use FontSize.newBuilder() to construct.
      private FontSize(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private FontSize() {
        unit_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new FontSize();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Style_FontSize_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Style_FontSize_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Style.FontSize.class,
                com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder.class);
      }

      public static final int SIZE_FIELD_NUMBER = 1;
      private float size_ = 0F;
      /**
       *
       *
       * <pre>
       * Font size for the text.
       * </pre>
       *
       * <code>float size = 1;</code>
       *
       * @return The size.
       */
      @java.lang.Override
      public float getSize() {
        return size_;
      }

      public static final int UNIT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object unit_ = "";
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
       * `pt`).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The unit.
       */
      @java.lang.Override
      public java.lang.String getUnit() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          unit_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
       * `pt`).
       * </pre>
       *
       * <code>string unit = 2;</code>
       *
       * @return The bytes for unit.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUnitBytes() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          unit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(size_) != 0) {
          output.writeFloat(1, size_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, unit_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(size_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, size_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, unit_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Style.FontSize)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Style.FontSize other =
            (com.google.cloud.documentai.v1beta3.Document.Style.FontSize) obj;

        if (java.lang.Float.floatToIntBits(getSize())
            != java.lang.Float.floatToIntBits(other.getSize())) return false;
        if (!getUnit().equals(other.getUnit())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SIZE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getSize());
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + getUnit().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Font size with unit.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Style.FontSize}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Style.FontSize)
          com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Style_FontSize_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Style_FontSize_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Style.FontSize.class,
                  com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Style.FontSize.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          size_ = 0F;
          unit_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Style_FontSize_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Style.FontSize
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Style.FontSize build() {
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Style.FontSize buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize result =
              new com.google.cloud.documentai.v1beta3.Document.Style.FontSize(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Style.FontSize result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.size_ = size_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.unit_ = unit_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Style.FontSize) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Style.FontSize) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.Document.Style.FontSize other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance())
            return this;
          if (other.getSize() != 0F) {
            setSize(other.getSize());
          }
          if (!other.getUnit().isEmpty()) {
            unit_ = other.unit_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    size_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                case 18:
                  {
                    unit_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float size_;
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @return The size.
         */
        @java.lang.Override
        public float getSize() {
          return size_;
        }
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @param value The size to set.
         * @return This builder for chaining.
         */
        public Builder setSize(float value) {

          size_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Font size for the text.
         * </pre>
         *
         * <code>float size = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSize() {
          bitField0_ = (bitField0_ & ~0x00000001);
          size_ = 0F;
          onChanged();
          return this;
        }

        private java.lang.Object unit_ = "";
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
         * `pt`).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return The unit.
         */
        public java.lang.String getUnit() {
          java.lang.Object ref = unit_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            unit_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
         * `pt`).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return The bytes for unit.
         */
        public com.google.protobuf.ByteString getUnitBytes() {
          java.lang.Object ref = unit_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            unit_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
         * `pt`).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @param value The unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnit(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          unit_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
         * `pt`).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUnit() {
          unit_ = getDefaultInstance().getUnit();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Unit for the font size. Follows CSS naming (such as `in`, `px`, and
         * `pt`).
         * </pre>
         *
         * <code>string unit = 2;</code>
         *
         * @param value The bytes for unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnitBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          unit_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Style.FontSize)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Style.FontSize)
      private static final com.google.cloud.documentai.v1beta3.Document.Style.FontSize
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Style.FontSize();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Style.FontSize
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<FontSize> PARSER =
          new com.google.protobuf.AbstractParser<FontSize>() {
            @java.lang.Override
            public FontSize parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<FontSize> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<FontSize> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Style.FontSize
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int TEXT_ANCHOR_FIELD_NUMBER = 1;
    private com.google.cloud.documentai.v1beta3.Document.TextAnchor textAnchor_;
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return Whether the textAnchor field is set.
     */
    @java.lang.Override
    public boolean hasTextAnchor() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     *
     * @return The textAnchor.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor() {
      return textAnchor_ == null
          ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
          : textAnchor_;
    }
    /**
     *
     *
     * <pre>
     * Text anchor indexing into the
     * [Document.text][google.cloud.documentai.v1beta3.Document.text].
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder
        getTextAnchorOrBuilder() {
      return textAnchor_ == null
          ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
          : textAnchor_;
    }

    public static final int COLOR_FIELD_NUMBER = 2;
    private com.google.type.Color color_;
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return Whether the color field is set.
     */
    @java.lang.Override
    public boolean hasColor() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     *
     * @return The color.
     */
    @java.lang.Override
    public com.google.type.Color getColor() {
      return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
    }
    /**
     *
     *
     * <pre>
     * Text color.
     * </pre>
     *
     * <code>.google.type.Color color = 2;</code>
     */
    @java.lang.Override
    public com.google.type.ColorOrBuilder getColorOrBuilder() {
      return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
    }

    public static final int BACKGROUND_COLOR_FIELD_NUMBER = 3;
    private com.google.type.Color backgroundColor_;
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return Whether the backgroundColor field is set.
     */
    @java.lang.Override
    public boolean hasBackgroundColor() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     *
     * @return The backgroundColor.
     */
    @java.lang.Override
    public com.google.type.Color getBackgroundColor() {
      return backgroundColor_ == null
          ? com.google.type.Color.getDefaultInstance()
          : backgroundColor_;
    }
    /**
     *
     *
     * <pre>
     * Text background color.
     * </pre>
     *
     * <code>.google.type.Color background_color = 3;</code>
     */
    @java.lang.Override
    public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
      return backgroundColor_ == null
          ? com.google.type.Color.getDefaultInstance()
          : backgroundColor_;
    }

    public static final int FONT_WEIGHT_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fontWeight_ = "";
    /**
     *
     *
     * <pre>
     * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
     * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The fontWeight.
     */
    @java.lang.Override
    public java.lang.String getFontWeight() {
      java.lang.Object ref = fontWeight_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fontWeight_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
     * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
     * </pre>
     *
     * <code>string font_weight = 4;</code>
     *
     * @return The bytes for fontWeight.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFontWeightBytes() {
      java.lang.Object ref = fontWeight_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fontWeight_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_STYLE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object textStyle_ = "";
    /**
     *
     *
     * <pre>
     * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
     * Possible values are `normal`, `italic`, and `oblique`.
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The textStyle.
     */
    @java.lang.Override
    public java.lang.String getTextStyle() {
      java.lang.Object ref = textStyle_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        textStyle_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
     * Possible values are `normal`, `italic`, and `oblique`.
     * </pre>
     *
     * <code>string text_style = 5;</code>
     *
     * @return The bytes for textStyle.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextStyleBytes() {
      java.lang.Object ref = textStyle_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        textStyle_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_DECORATION_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object textDecoration_ = "";
    /**
     *
     *
     * <pre>
     * [Text
     * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
     * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
     * &lt;text-decoration-style&gt;
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The textDecoration.
     */
    @java.lang.Override
    public java.lang.String getTextDecoration() {
      java.lang.Object ref = textDecoration_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        textDecoration_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * [Text
     * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
     * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
     * &lt;text-decoration-style&gt;
     * </pre>
     *
     * <code>string text_decoration = 6;</code>
     *
     * @return The bytes for textDecoration.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextDecorationBytes() {
      java.lang.Object ref = textDecoration_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        textDecoration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FONT_SIZE_FIELD_NUMBER = 7;
    private com.google.cloud.documentai.v1beta3.Document.Style.FontSize fontSize_;
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     *
     * @return Whether the fontSize field is set.
     */
    @java.lang.Override
    public boolean hasFontSize() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     *
     * @return The fontSize.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.Style.FontSize getFontSize() {
      return fontSize_ == null
          ? com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance()
          : fontSize_;
    }
    /**
     *
     *
     * <pre>
     * Font size.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder
        getFontSizeOrBuilder() {
      return fontSize_ == null
          ? com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance()
          : fontSize_;
    }

    public static final int FONT_FAMILY_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object fontFamily_ = "";
    /**
     *
     *
     * <pre>
     * Font family such as `Arial`, `Times New Roman`.
     * https://www.w3schools.com/cssref/pr_font_font-family.asp
     * </pre>
     *
     * <code>string font_family = 8;</code>
     *
     * @return The fontFamily.
     */
    @java.lang.Override
    public java.lang.String getFontFamily() {
      java.lang.Object ref = fontFamily_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fontFamily_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Font family such as `Arial`, `Times New Roman`.
     * https://www.w3schools.com/cssref/pr_font_font-family.asp
     * </pre>
     *
     * <code>string font_family = 8;</code>
     *
     * @return The bytes for fontFamily.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFontFamilyBytes() {
      java.lang.Object ref = fontFamily_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fontFamily_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTextAnchor());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getColor());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getBackgroundColor());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontWeight_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fontWeight_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textStyle_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, textStyle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textDecoration_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, textDecoration_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(7, getFontSize());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontFamily_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, fontFamily_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTextAnchor());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getColor());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBackgroundColor());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontWeight_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fontWeight_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textStyle_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, textStyle_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(textDecoration_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, textDecoration_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getFontSize());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontFamily_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, fontFamily_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Style)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.Document.Style other =
          (com.google.cloud.documentai.v1beta3.Document.Style) obj;

      if (hasTextAnchor() != other.hasTextAnchor()) return false;
      if (hasTextAnchor()) {
        if (!getTextAnchor().equals(other.getTextAnchor())) return false;
      }
      if (hasColor() != other.hasColor()) return false;
      if (hasColor()) {
        if (!getColor().equals(other.getColor())) return false;
      }
      if (hasBackgroundColor() != other.hasBackgroundColor()) return false;
      if (hasBackgroundColor()) {
        if (!getBackgroundColor().equals(other.getBackgroundColor())) return false;
      }
      if (!getFontWeight().equals(other.getFontWeight())) return false;
      if (!getTextStyle().equals(other.getTextStyle())) return false;
      if (!getTextDecoration().equals(other.getTextDecoration())) return false;
      if (hasFontSize() != other.hasFontSize()) return false;
      if (hasFontSize()) {
        if (!getFontSize().equals(other.getFontSize())) return false;
      }
      if (!getFontFamily().equals(other.getFontFamily())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTextAnchor()) {
        hash = (37 * hash) + TEXT_ANCHOR_FIELD_NUMBER;
        hash = (53 * hash) + getTextAnchor().hashCode();
      }
      if (hasColor()) {
        hash = (37 * hash) + COLOR_FIELD_NUMBER;
        hash = (53 * hash) + getColor().hashCode();
      }
      if (hasBackgroundColor()) {
        hash = (37 * hash) + BACKGROUND_COLOR_FIELD_NUMBER;
        hash = (53 * hash) + getBackgroundColor().hashCode();
      }
      hash = (37 * hash) + FONT_WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getFontWeight().hashCode();
      hash = (37 * hash) + TEXT_STYLE_FIELD_NUMBER;
      hash = (53 * hash) + getTextStyle().hashCode();
      hash = (37 * hash) + TEXT_DECORATION_FIELD_NUMBER;
      hash = (53 * hash) + getTextDecoration().hashCode();
      if (hasFontSize()) {
        hash = (37 * hash) + FONT_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getFontSize().hashCode();
      }
      hash = (37 * hash) + FONT_FAMILY_FIELD_NUMBER;
      hash = (53 * hash) + getFontFamily().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.documentai.v1beta3.Document.Style prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Annotation for common text style attributes. This adheres to CSS
     * conventions as much as possible.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Style}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Style)
        com.google.cloud.documentai.v1beta3.Document.StyleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Style_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Style_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Style.class,
                com.google.cloud.documentai.v1beta3.Document.Style.Builder.class);
      }

      // Construct using com.google.cloud.documentai.v1beta3.Document.Style.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTextAnchorFieldBuilder();
          getColorFieldBuilder();
          getBackgroundColorFieldBuilder();
          getFontSizeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        textAnchor_ = null;
        if (textAnchorBuilder_ != null) {
          textAnchorBuilder_.dispose();
          textAnchorBuilder_ = null;
        }
        color_ = null;
        if (colorBuilder_ != null) {
          colorBuilder_.dispose();
          colorBuilder_ = null;
        }
        backgroundColor_ = null;
        if (backgroundColorBuilder_ != null) {
          backgroundColorBuilder_.dispose();
          backgroundColorBuilder_ = null;
        }
        fontWeight_ = "";
        textStyle_ = "";
        textDecoration_ = "";
        fontSize_ = null;
        if (fontSizeBuilder_ != null) {
          fontSizeBuilder_.dispose();
          fontSizeBuilder_ = null;
        }
        fontFamily_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Style_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Style getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.Document.Style.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Style build() {
        com.google.cloud.documentai.v1beta3.Document.Style result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Style buildPartial() {
        com.google.cloud.documentai.v1beta3.Document.Style result =
            new com.google.cloud.documentai.v1beta3.Document.Style(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Style result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.textAnchor_ =
              textAnchorBuilder_ == null ? textAnchor_ : textAnchorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.color_ = colorBuilder_ == null ? color_ : colorBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.backgroundColor_ =
              backgroundColorBuilder_ == null ? backgroundColor_ : backgroundColorBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.fontWeight_ = fontWeight_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.textStyle_ = textStyle_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.textDecoration_ = textDecoration_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.fontSize_ = fontSizeBuilder_ == null ? fontSize_ : fontSizeBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.fontFamily_ = fontFamily_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.Document.Style) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Style) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Style other) {
        if (other == com.google.cloud.documentai.v1beta3.Document.Style.getDefaultInstance())
          return this;
        if (other.hasTextAnchor()) {
          mergeTextAnchor(other.getTextAnchor());
        }
        if (other.hasColor()) {
          mergeColor(other.getColor());
        }
        if (other.hasBackgroundColor()) {
          mergeBackgroundColor(other.getBackgroundColor());
        }
        if (!other.getFontWeight().isEmpty()) {
          fontWeight_ = other.fontWeight_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (!other.getTextStyle().isEmpty()) {
          textStyle_ = other.textStyle_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (!other.getTextDecoration().isEmpty()) {
          textDecoration_ = other.textDecoration_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        if (other.hasFontSize()) {
          mergeFontSize(other.getFontSize());
        }
        if (!other.getFontFamily().isEmpty()) {
          fontFamily_ = other.fontFamily_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTextAnchorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getColorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getBackgroundColorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  fontWeight_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  textStyle_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  textDecoration_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(getFontSizeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              case 66:
                {
                  fontFamily_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.documentai.v1beta3.Document.TextAnchor textAnchor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Document.TextAnchor,
              com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
              com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>
          textAnchorBuilder_;
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      public boolean hasTextAnchor() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      public com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor() {
        if (textAnchorBuilder_ == null) {
          return textAnchor_ == null
              ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
              : textAnchor_;
        } else {
          return textAnchorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder setTextAnchor(com.google.cloud.documentai.v1beta3.Document.TextAnchor value) {
        if (textAnchorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          textAnchor_ = value;
        } else {
          textAnchorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder setTextAnchor(
          com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder builderForValue) {
        if (textAnchorBuilder_ == null) {
          textAnchor_ = builderForValue.build();
        } else {
          textAnchorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder mergeTextAnchor(
          com.google.cloud.documentai.v1beta3.Document.TextAnchor value) {
        if (textAnchorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && textAnchor_ != null
              && textAnchor_
                  != com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()) {
            getTextAnchorBuilder().mergeFrom(value);
          } else {
            textAnchor_ = value;
          }
        } else {
          textAnchorBuilder_.mergeFrom(value);
        }
        if (textAnchor_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public Builder clearTextAnchor() {
        bitField0_ = (bitField0_ & ~0x00000001);
        textAnchor_ = null;
        if (textAnchorBuilder_ != null) {
          textAnchorBuilder_.dispose();
          textAnchorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder
          getTextAnchorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTextAnchorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      public com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder
          getTextAnchorOrBuilder() {
        if (textAnchorBuilder_ != null) {
          return textAnchorBuilder_.getMessageOrBuilder();
        } else {
          return textAnchor_ == null
              ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
              : textAnchor_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Document.TextAnchor,
              com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
              com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>
          getTextAnchorFieldBuilder() {
        if (textAnchorBuilder_ == null) {
          textAnchorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.TextAnchor,
                  com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
                  com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>(
                  getTextAnchor(), getParentForChildren(), isClean());
          textAnchor_ = null;
        }
        return textAnchorBuilder_;
      }

      private com.google.type.Color color_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          colorBuilder_;
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       *
       * @return Whether the color field is set.
       */
      public boolean hasColor() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       *
       * @return The color.
       */
      public com.google.type.Color getColor() {
        if (colorBuilder_ == null) {
          return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
        } else {
          return colorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder setColor(com.google.type.Color value) {
        if (colorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          color_ = value;
        } else {
          colorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder setColor(com.google.type.Color.Builder builderForValue) {
        if (colorBuilder_ == null) {
          color_ = builderForValue.build();
        } else {
          colorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder mergeColor(com.google.type.Color value) {
        if (colorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && color_ != null
              && color_ != com.google.type.Color.getDefaultInstance()) {
            getColorBuilder().mergeFrom(value);
          } else {
            color_ = value;
          }
        } else {
          colorBuilder_.mergeFrom(value);
        }
        if (color_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public Builder clearColor() {
        bitField0_ = (bitField0_ & ~0x00000002);
        color_ = null;
        if (colorBuilder_ != null) {
          colorBuilder_.dispose();
          colorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public com.google.type.Color.Builder getColorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getColorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      public com.google.type.ColorOrBuilder getColorOrBuilder() {
        if (colorBuilder_ != null) {
          return colorBuilder_.getMessageOrBuilder();
        } else {
          return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text color.
       * </pre>
       *
       * <code>.google.type.Color color = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          getColorFieldBuilder() {
        if (colorBuilder_ == null) {
          colorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>(getColor(), getParentForChildren(), isClean());
          color_ = null;
        }
        return colorBuilder_;
      }

      private com.google.type.Color backgroundColor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          backgroundColorBuilder_;
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       *
       * @return Whether the backgroundColor field is set.
       */
      public boolean hasBackgroundColor() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       *
       * @return The backgroundColor.
       */
      public com.google.type.Color getBackgroundColor() {
        if (backgroundColorBuilder_ == null) {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        } else {
          return backgroundColorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder setBackgroundColor(com.google.type.Color value) {
        if (backgroundColorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backgroundColor_ = value;
        } else {
          backgroundColorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder setBackgroundColor(com.google.type.Color.Builder builderForValue) {
        if (backgroundColorBuilder_ == null) {
          backgroundColor_ = builderForValue.build();
        } else {
          backgroundColorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder mergeBackgroundColor(com.google.type.Color value) {
        if (backgroundColorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && backgroundColor_ != null
              && backgroundColor_ != com.google.type.Color.getDefaultInstance()) {
            getBackgroundColorBuilder().mergeFrom(value);
          } else {
            backgroundColor_ = value;
          }
        } else {
          backgroundColorBuilder_.mergeFrom(value);
        }
        if (backgroundColor_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public Builder clearBackgroundColor() {
        bitField0_ = (bitField0_ & ~0x00000004);
        backgroundColor_ = null;
        if (backgroundColorBuilder_ != null) {
          backgroundColorBuilder_.dispose();
          backgroundColorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public com.google.type.Color.Builder getBackgroundColorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBackgroundColorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
        if (backgroundColorBuilder_ != null) {
          return backgroundColorBuilder_.getMessageOrBuilder();
        } else {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        }
      }
      /**
       *
       *
       * <pre>
       * Text background color.
       * </pre>
       *
       * <code>.google.type.Color background_color = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
          getBackgroundColorFieldBuilder() {
        if (backgroundColorBuilder_ == null) {
          backgroundColorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>(
                  getBackgroundColor(), getParentForChildren(), isClean());
          backgroundColor_ = null;
        }
        return backgroundColorBuilder_;
      }

      private java.lang.Object fontWeight_ = "";
      /**
       *
       *
       * <pre>
       * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
       * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return The fontWeight.
       */
      public java.lang.String getFontWeight() {
        java.lang.Object ref = fontWeight_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fontWeight_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
       * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return The bytes for fontWeight.
       */
      public com.google.protobuf.ByteString getFontWeightBytes() {
        java.lang.Object ref = fontWeight_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fontWeight_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
       * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @param value The fontWeight to set.
       * @return This builder for chaining.
       */
      public Builder setFontWeight(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fontWeight_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
       * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFontWeight() {
        fontWeight_ = getDefaultInstance().getFontWeight();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
       * Possible values are `normal`, `bold`, `bolder`, and `lighter`.
       * </pre>
       *
       * <code>string font_weight = 4;</code>
       *
       * @param value The bytes for fontWeight to set.
       * @return This builder for chaining.
       */
      public Builder setFontWeightBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fontWeight_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object textStyle_ = "";
      /**
       *
       *
       * <pre>
       * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
       * Possible values are `normal`, `italic`, and `oblique`.
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return The textStyle.
       */
      public java.lang.String getTextStyle() {
        java.lang.Object ref = textStyle_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          textStyle_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
       * Possible values are `normal`, `italic`, and `oblique`.
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return The bytes for textStyle.
       */
      public com.google.protobuf.ByteString getTextStyleBytes() {
        java.lang.Object ref = textStyle_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          textStyle_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
       * Possible values are `normal`, `italic`, and `oblique`.
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @param value The textStyle to set.
       * @return This builder for chaining.
       */
      public Builder setTextStyle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        textStyle_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
       * Possible values are `normal`, `italic`, and `oblique`.
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextStyle() {
        textStyle_ = getDefaultInstance().getTextStyle();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
       * Possible values are `normal`, `italic`, and `oblique`.
       * </pre>
       *
       * <code>string text_style = 5;</code>
       *
       * @param value The bytes for textStyle to set.
       * @return This builder for chaining.
       */
      public Builder setTextStyleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        textStyle_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.lang.Object textDecoration_ = "";
      /**
       *
       *
       * <pre>
       * [Text
       * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
       * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
       * &lt;text-decoration-style&gt;
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return The textDecoration.
       */
      public java.lang.String getTextDecoration() {
        java.lang.Object ref = textDecoration_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          textDecoration_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Text
       * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
       * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
       * &lt;text-decoration-style&gt;
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return The bytes for textDecoration.
       */
      public com.google.protobuf.ByteString getTextDecorationBytes() {
        java.lang.Object ref = textDecoration_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          textDecoration_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * [Text
       * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
       * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
       * &lt;text-decoration-style&gt;
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @param value The textDecoration to set.
       * @return This builder for chaining.
       */
      public Builder setTextDecoration(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        textDecoration_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Text
       * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
       * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
       * &lt;text-decoration-style&gt;
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTextDecoration() {
        textDecoration_ = getDefaultInstance().getTextDecoration();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * [Text
       * decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
       * Follows CSS standard. &lt;text-decoration-line&gt; &lt;text-decoration-color&gt;
       * &lt;text-decoration-style&gt;
       * </pre>
       *
       * <code>string text_decoration = 6;</code>
       *
       * @param value The bytes for textDecoration to set.
       * @return This builder for chaining.
       */
      public Builder setTextDecorationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        textDecoration_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      private com.google.cloud.documentai.v1beta3.Document.Style.FontSize fontSize_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Document.Style.FontSize,
              com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder,
              com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder>
          fontSizeBuilder_;
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       *
       * @return Whether the fontSize field is set.
       */
      public boolean hasFontSize() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       *
       * @return The fontSize.
       */
      public com.google.cloud.documentai.v1beta3.Document.Style.FontSize getFontSize() {
        if (fontSizeBuilder_ == null) {
          return fontSize_ == null
              ? com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance()
              : fontSize_;
        } else {
          return fontSizeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder setFontSize(
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize value) {
        if (fontSizeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          fontSize_ = value;
        } else {
          fontSizeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder setFontSize(
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder builderForValue) {
        if (fontSizeBuilder_ == null) {
          fontSize_ = builderForValue.build();
        } else {
          fontSizeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder mergeFontSize(
          com.google.cloud.documentai.v1beta3.Document.Style.FontSize value) {
        if (fontSizeBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && fontSize_ != null
              && fontSize_
                  != com.google.cloud.documentai.v1beta3.Document.Style.FontSize
                      .getDefaultInstance()) {
            getFontSizeBuilder().mergeFrom(value);
          } else {
            fontSize_ = value;
          }
        } else {
          fontSizeBuilder_.mergeFrom(value);
        }
        if (fontSize_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public Builder clearFontSize() {
        bitField0_ = (bitField0_ & ~0x00000040);
        fontSize_ = null;
        if (fontSizeBuilder_ != null) {
          fontSizeBuilder_.dispose();
          fontSizeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder
          getFontSizeBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getFontSizeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      public com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder
          getFontSizeOrBuilder() {
        if (fontSizeBuilder_ != null) {
          return fontSizeBuilder_.getMessageOrBuilder();
        } else {
          return fontSize_ == null
              ? com.google.cloud.documentai.v1beta3.Document.Style.FontSize.getDefaultInstance()
              : fontSize_;
        }
      }
      /**
       *
       *
       * <pre>
       * Font size.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Style.FontSize font_size = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.Document.Style.FontSize,
              com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder,
              com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder>
          getFontSizeFieldBuilder() {
        if (fontSizeBuilder_ == null) {
          fontSizeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Style.FontSize,
                  com.google.cloud.documentai.v1beta3.Document.Style.FontSize.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Style.FontSizeOrBuilder>(
                  getFontSize(), getParentForChildren(), isClean());
          fontSize_ = null;
        }
        return fontSizeBuilder_;
      }

      private java.lang.Object fontFamily_ = "";
      /**
       *
       *
       * <pre>
       * Font family such as `Arial`, `Times New Roman`.
       * https://www.w3schools.com/cssref/pr_font_font-family.asp
       * </pre>
       *
       * <code>string font_family = 8;</code>
       *
       * @return The fontFamily.
       */
      public java.lang.String getFontFamily() {
        java.lang.Object ref = fontFamily_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fontFamily_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Font family such as `Arial`, `Times New Roman`.
       * https://www.w3schools.com/cssref/pr_font_font-family.asp
       * </pre>
       *
       * <code>string font_family = 8;</code>
       *
       * @return The bytes for fontFamily.
       */
      public com.google.protobuf.ByteString getFontFamilyBytes() {
        java.lang.Object ref = fontFamily_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fontFamily_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Font family such as `Arial`, `Times New Roman`.
       * https://www.w3schools.com/cssref/pr_font_font-family.asp
       * </pre>
       *
       * <code>string font_family = 8;</code>
       *
       * @param value The fontFamily to set.
       * @return This builder for chaining.
       */
      public Builder setFontFamily(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        fontFamily_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font family such as `Arial`, `Times New Roman`.
       * https://www.w3schools.com/cssref/pr_font_font-family.asp
       * </pre>
       *
       * <code>string font_family = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFontFamily() {
        fontFamily_ = getDefaultInstance().getFontFamily();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Font family such as `Arial`, `Times New Roman`.
       * https://www.w3schools.com/cssref/pr_font_font-family.asp
       * </pre>
       *
       * <code>string font_family = 8;</code>
       *
       * @param value The bytes for fontFamily to set.
       * @return This builder for chaining.
       */
      public Builder setFontFamilyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        fontFamily_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Style)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Style)
    private static final com.google.cloud.documentai.v1beta3.Document.Style DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Style();
    }

    public static com.google.cloud.documentai.v1beta3.Document.Style getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Style> PARSER =
        new com.google.protobuf.AbstractParser<Style>() {
          @java.lang.Override
          public Style parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Style> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Style> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document.Style getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * 1-based index for current
     * [Page][google.cloud.documentai.v1beta3.Document.Page] in a parent
     * [Document][google.cloud.documentai.v1beta3.Document]. Useful when a page
     * is taken out of a [Document][google.cloud.documentai.v1beta3.Document]
     * for individual processing.
     * </pre>
     *
     * <code>int32 page_number = 1;</code>
     *
     * @return The pageNumber.
     */
    int getPageNumber();

    /**
     *
     *
     * <pre>
     * Rendered image for this page. This image is preprocessed to remove any
     * skew, rotation, and distortions such that the annotation bounding boxes
     * can be upright and axis-aligned.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Image image = 13;</code>
     *
     * @return Whether the image field is set.
     */
    boolean hasImage();
    /**
     *
     *
     * <pre>
     * Rendered image for this page. This image is preprocessed to remove any
     * skew, rotation, and distortions such that the annotation bounding boxes
     * can be upright and axis-aligned.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Image image = 13;</code>
     *
     * @return The image.
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Image getImage();
    /**
     *
     *
     * <pre>
     * Rendered image for this page. This image is preprocessed to remove any
     * skew, rotation, and distortions such that the annotation bounding boxes
     * can be upright and axis-aligned.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Image image = 13;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.ImageOrBuilder getImageOrBuilder();

    /**
     *
     *
     * <pre>
     * Transformation matrices that were applied to the original document image
     * to produce
     * [Page.image][google.cloud.documentai.v1beta3.Document.Page.image].
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Matrix transforms = 14;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Matrix> getTransformsList();
    /**
     *
     *
     * <pre>
     * Transformation matrices that were applied to the original document image
     * to produce
     * [Page.image][google.cloud.documentai.v1beta3.Document.Page.image].
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Matrix transforms = 14;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Matrix getTransforms(int index);
    /**
     *
     *
     * <pre>
     * Transformation matrices that were applied to the original document image
     * to produce
     * [Page.image][google.cloud.documentai.v1beta3.Document.Page.image].
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Matrix transforms = 14;</code>
     */
    int getTransformsCount();
    /**
     *
     *
     * <pre>
     * Transformation matrices that were applied to the original document image
     * to produce
     * [Page.image][google.cloud.documentai.v1beta3.Document.Page.image].
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Matrix transforms = 14;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.MatrixOrBuilder>
        getTransformsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Transformation matrices that were applied to the original document image
     * to produce
     * [Page.image][google.cloud.documentai.v1beta3.Document.Page.image].
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Matrix transforms = 14;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.MatrixOrBuilder getTransformsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Dimension dimension = 2;</code>
     *
     * @return Whether the dimension field is set.
     */
    boolean hasDimension();
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Dimension dimension = 2;</code>
     *
     * @return The dimension.
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Dimension getDimension();
    /**
     *
     *
     * <pre>
     * Physical dimension of the page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Dimension dimension = 2;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.DimensionOrBuilder getDimensionOrBuilder();

    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 3;</code>
     *
     * @return Whether the layout field is set.
     */
    boolean hasLayout();
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 3;</code>
     *
     * @return The layout.
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
    /**
     *
     *
     * <pre>
     * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for the
     * page.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 3;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
        getDetectedLanguagesList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
        int index);
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    int getDetectedLanguagesCount();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
        getDetectedLanguagesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected languages together with confidence.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
        getDetectedLanguagesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Block blocks = 5;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Block> getBlocksList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Block blocks = 5;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Block getBlocks(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Block blocks = 5;</code>
     */
    int getBlocksCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Block blocks = 5;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.BlockOrBuilder>
        getBlocksOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text blocks on the page.
     * A block has a set of lines (collected into paragraphs) that have a common
     * line-spacing and orientation.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Block blocks = 5;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.BlockOrBuilder getBlocksOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Paragraph> getParagraphsList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Paragraph getParagraphs(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    int getParagraphsCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.ParagraphOrBuilder>
        getParagraphsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text paragraphs on the page.
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Paragraph paragraphs = 6;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.ParagraphOrBuilder getParagraphsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Line lines = 7;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Line> getLinesList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Line lines = 7;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Line getLines(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Line lines = 7;</code>
     */
    int getLinesCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Line lines = 7;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.LineOrBuilder>
        getLinesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected text lines on the page.
     * A collection of tokens that a human would perceive as a line.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Line lines = 7;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.LineOrBuilder getLinesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Token tokens = 8;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Token> getTokensList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Token tokens = 8;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Token getTokens(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Token tokens = 8;</code>
     */
    int getTokensCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Token tokens = 8;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.TokenOrBuilder>
        getTokensOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tokens on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Token tokens = 8;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.TokenOrBuilder getTokensOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.VisualElement>
        getVisualElementsList();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.VisualElement getVisualElements(int index);
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    int getVisualElementsCount();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.Document.Page.VisualElementOrBuilder>
        getVisualElementsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected non-text visual elements e.g. checkbox,
     * signature etc. on the page.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.VisualElement visual_elements = 9;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.VisualElementOrBuilder
        getVisualElementsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table tables = 10;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table> getTablesList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table tables = 10;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Table getTables(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table tables = 10;</code>
     */
    int getTablesCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table tables = 10;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.TableOrBuilder>
        getTablesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected tables on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table tables = 10;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.TableOrBuilder getTablesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.FormField form_fields = 11;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.FormField> getFormFieldsList();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.FormField form_fields = 11;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.FormField getFormFields(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.FormField form_fields = 11;
     * </code>
     */
    int getFormFieldsCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.FormField form_fields = 11;
     * </code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.FormFieldOrBuilder>
        getFormFieldsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected form fields on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.FormField form_fields = 11;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.FormFieldOrBuilder getFormFieldsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * A list of visually detected symbols on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Symbol symbols = 12;</code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Symbol> getSymbolsList();
    /**
     *
     *
     * <pre>
     * A list of visually detected symbols on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Symbol symbols = 12;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.Symbol getSymbols(int index);
    /**
     *
     *
     * <pre>
     * A list of visually detected symbols on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Symbol symbols = 12;</code>
     */
    int getSymbolsCount();
    /**
     *
     *
     * <pre>
     * A list of visually detected symbols on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Symbol symbols = 12;</code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.Document.Page.SymbolOrBuilder>
        getSymbolsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of visually detected symbols on the page.
     * </pre>
     *
     * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Symbol symbols = 12;</code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.SymbolOrBuilder getSymbolsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * A list of detected barcodes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode detected_barcodes = 15;
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode>
        getDetectedBarcodesList();
    /**
     *
     *
     * <pre>
     * A list of detected barcodes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode detected_barcodes = 15;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode getDetectedBarcodes(
        int index);
    /**
     *
     *
     * <pre>
     * A list of detected barcodes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode detected_barcodes = 15;
     * </code>
     */
    int getDetectedBarcodesCount();
    /**
     *
     *
     * <pre>
     * A list of detected barcodes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode detected_barcodes = 15;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedBarcodeOrBuilder>
        getDetectedBarcodesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of detected barcodes.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedBarcode detected_barcodes = 15;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.DetectedBarcodeOrBuilder
        getDetectedBarcodesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Image quality scores.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Page.ImageQualityScores image_quality_scores = 17;
     * </code>
     *
     * @return Whether the imageQualityScores field is set.
     */
    boolean hasImageQualityScores();
    /**
     *
     *
     * <pre>
     * Image quality scores.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Page.ImageQualityScores image_quality_scores = 17;
     * </code>
     *
     * @return The imageQualityScores.
     */
    com.google.cloud.documentai.v1beta3.Document.Page.ImageQualityScores getImageQualityScores();
    /**
     *
     *
     * <pre>
     * Image quality scores.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Page.ImageQualityScores image_quality_scores = 17;
     * </code>
     */
    com.google.cloud.documentai.v1beta3.Document.Page.ImageQualityScoresOrBuilder
        getImageQualityScoresOrBuilder();

    /**
     *
     *
     * <pre>
     * The history of this page.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.Document.Page.provenance is deprecated. See
     *     google/cloud/documentai/v1beta3/document.proto;l=551
     * @return Whether the provenance field is set.
     */
    @java.lang.Deprecated
    boolean hasProvenance();
    /**
     *
     *
     * <pre>
     * The history of this page.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 16 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.documentai.v1beta3.Document.Page.provenance is deprecated. See
     *     google/cloud/documentai/v1beta3/document.proto;l=551
     * @return The provenance.
     */
    @java.lang.Deprecated
    com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
    /**
     *
     *
     * <pre>
     * The history of this page.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 16 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A page in a [Document][google.cloud.documentai.v1beta3.Document].
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page}
   */
  public static final class Page extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page)
      PageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Page.newBuilder() to construct.
    private Page(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Page() {
      transforms_ = java.util.Collections.emptyList();
      detectedLanguages_ = java.util.Collections.emptyList();
      blocks_ = java.util.Collections.emptyList();
      paragraphs_ = java.util.Collections.emptyList();
      lines_ = java.util.Collections.emptyList();
      tokens_ = java.util.Collections.emptyList();
      visualElements_ = java.util.Collections.emptyList();
      tables_ = java.util.Collections.emptyList();
      formFields_ = java.util.Collections.emptyList();
      symbols_ = java.util.Collections.emptyList();
      detectedBarcodes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Page();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_Page_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentProto
          .internal_static_google_cloud_documentai_v1beta3_Document_Page_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.Document.Page.class,
              com.google.cloud.documentai.v1beta3.Document.Page.Builder.class);
    }

    public interface DimensionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Dimension)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Page width.
       * </pre>
       *
       * <code>float width = 1;</code>
       *
       * @return The width.
       */
      float getWidth();

      /**
       *
       *
       * <pre>
       * Page height.
       * </pre>
       *
       * <code>float height = 2;</code>
       *
       * @return The height.
       */
      float getHeight();

      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The unit.
       */
      java.lang.String getUnit();
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The bytes for unit.
       */
      com.google.protobuf.ByteString getUnitBytes();
    }
    /**
     *
     *
     * <pre>
     * Dimension for the page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Dimension}
     */
    public static final class Dimension extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Dimension)
        DimensionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Dimension.newBuilder() to construct.
      private Dimension(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Dimension() {
        unit_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Dimension();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Dimension_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Dimension_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Dimension.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Dimension.Builder.class);
      }

      public static final int WIDTH_FIELD_NUMBER = 1;
      private float width_ = 0F;
      /**
       *
       *
       * <pre>
       * Page width.
       * </pre>
       *
       * <code>float width = 1;</code>
       *
       * @return The width.
       */
      @java.lang.Override
      public float getWidth() {
        return width_;
      }

      public static final int HEIGHT_FIELD_NUMBER = 2;
      private float height_ = 0F;
      /**
       *
       *
       * <pre>
       * Page height.
       * </pre>
       *
       * <code>float height = 2;</code>
       *
       * @return The height.
       */
      @java.lang.Override
      public float getHeight() {
        return height_;
      }

      public static final int UNIT_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object unit_ = "";
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The unit.
       */
      @java.lang.Override
      public java.lang.String getUnit() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          unit_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Dimension unit.
       * </pre>
       *
       * <code>string unit = 3;</code>
       *
       * @return The bytes for unit.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUnitBytes() {
        java.lang.Object ref = unit_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          unit_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Float.floatToRawIntBits(width_) != 0) {
          output.writeFloat(1, width_);
        }
        if (java.lang.Float.floatToRawIntBits(height_) != 0) {
          output.writeFloat(2, height_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unit_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Float.floatToRawIntBits(width_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, width_);
        }
        if (java.lang.Float.floatToRawIntBits(height_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, height_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, unit_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Dimension)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Dimension other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Dimension) obj;

        if (java.lang.Float.floatToIntBits(getWidth())
            != java.lang.Float.floatToIntBits(other.getWidth())) return false;
        if (java.lang.Float.floatToIntBits(getHeight())
            != java.lang.Float.floatToIntBits(other.getHeight())) return false;
        if (!getUnit().equals(other.getUnit())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getWidth());
        hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getHeight());
        hash = (37 * hash) + UNIT_FIELD_NUMBER;
        hash = (53 * hash) + getUnit().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Dimension prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dimension for the page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Dimension}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Dimension)
          com.google.cloud.documentai.v1beta3.Document.Page.DimensionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Dimension_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Dimension_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Dimension.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Dimension.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Dimension.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          width_ = 0F;
          height_ = 0F;
          unit_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Dimension_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Dimension
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Dimension.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Dimension build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Dimension result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Dimension buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Dimension result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Dimension(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.Dimension result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.width_ = width_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.height_ = height_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.unit_ = unit_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Dimension) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Dimension) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.Document.Page.Dimension other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.Dimension.getDefaultInstance())
            return this;
          if (other.getWidth() != 0F) {
            setWidth(other.getWidth());
          }
          if (other.getHeight() != 0F) {
            setHeight(other.getHeight());
          }
          if (!other.getUnit().isEmpty()) {
            unit_ = other.unit_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 13:
                  {
                    width_ = input.readFloat();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 13
                case 21:
                  {
                    height_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    unit_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private float width_;
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @return The width.
         */
        @java.lang.Override
        public float getWidth() {
          return width_;
        }
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @param value The width to set.
         * @return This builder for chaining.
         */
        public Builder setWidth(float value) {

          width_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Page width.
         * </pre>
         *
         * <code>float width = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWidth() {
          bitField0_ = (bitField0_ & ~0x00000001);
          width_ = 0F;
          onChanged();
          return this;
        }

        private float height_;
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @return The height.
         */
        @java.lang.Override
        public float getHeight() {
          return height_;
        }
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @param value The height to set.
         * @return This builder for chaining.
         */
        public Builder setHeight(float value) {

          height_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Page height.
         * </pre>
         *
         * <code>float height = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearHeight() {
          bitField0_ = (bitField0_ & ~0x00000002);
          height_ = 0F;
          onChanged();
          return this;
        }

        private java.lang.Object unit_ = "";
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return The unit.
         */
        public java.lang.String getUnit() {
          java.lang.Object ref = unit_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            unit_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return The bytes for unit.
         */
        public com.google.protobuf.ByteString getUnitBytes() {
          java.lang.Object ref = unit_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            unit_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @param value The unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnit(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          unit_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUnit() {
          unit_ = getDefaultInstance().getUnit();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Dimension unit.
         * </pre>
         *
         * <code>string unit = 3;</code>
         *
         * @param value The bytes for unit to set.
         * @return This builder for chaining.
         */
        public Builder setUnitBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          unit_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Dimension)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Dimension)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Dimension
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Dimension();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Dimension
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Dimension> PARSER =
          new com.google.protobuf.AbstractParser<Dimension>() {
            @java.lang.Override
            public Dimension parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Dimension> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Dimension> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Dimension
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ImageOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Image)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Raw byte content of the image.
       * </pre>
       *
       * <code>bytes content = 1;</code>
       *
       * @return The content.
       */
      com.google.protobuf.ByteString getContent();

      /**
       *
       *
       * <pre>
       * Encoding [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
       * for the image.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      java.lang.String getMimeType();
      /**
       *
       *
       * <pre>
       * Encoding [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
       * for the image.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      com.google.protobuf.ByteString getMimeTypeBytes();

      /**
       *
       *
       * <pre>
       * Width of the image in pixels.
       * </pre>
       *
       * <code>int32 width = 3;</code>
       *
       * @return The width.
       */
      int getWidth();

      /**
       *
       *
       * <pre>
       * Height of the image in pixels.
       * </pre>
       *
       * <code>int32 height = 4;</code>
       *
       * @return The height.
       */
      int getHeight();
    }
    /**
     *
     *
     * <pre>
     * Rendered image contents for this page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Image}
     */
    public static final class Image extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Image)
        ImageOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Image.newBuilder() to construct.
      private Image(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Image() {
        content_ = com.google.protobuf.ByteString.EMPTY;
        mimeType_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Image();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Image_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Image_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Image.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Image.Builder.class);
      }

      public static final int CONTENT_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * Raw byte content of the image.
       * </pre>
       *
       * <code>bytes content = 1;</code>
       *
       * @return The content.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getContent() {
        return content_;
      }

      public static final int MIME_TYPE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object mimeType_ = "";
      /**
       *
       *
       * <pre>
       * Encoding [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
       * for the image.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The mimeType.
       */
      @java.lang.Override
      public java.lang.String getMimeType() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mimeType_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Encoding [media type (MIME
       * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
       * for the image.
       * </pre>
       *
       * <code>string mime_type = 2;</code>
       *
       * @return The bytes for mimeType.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getMimeTypeBytes() {
        java.lang.Object ref = mimeType_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mimeType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int WIDTH_FIELD_NUMBER = 3;
      private int width_ = 0;
      /**
       *
       *
       * <pre>
       * Width of the image in pixels.
       * </pre>
       *
       * <code>int32 width = 3;</code>
       *
       * @return The width.
       */
      @java.lang.Override
      public int getWidth() {
        return width_;
      }

      public static final int HEIGHT_FIELD_NUMBER = 4;
      private int height_ = 0;
      /**
       *
       *
       * <pre>
       * Height of the image in pixels.
       * </pre>
       *
       * <code>int32 height = 4;</code>
       *
       * @return The height.
       */
      @java.lang.Override
      public int getHeight() {
        return height_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!content_.isEmpty()) {
          output.writeBytes(1, content_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, mimeType_);
        }
        if (width_ != 0) {
          output.writeInt32(3, width_);
        }
        if (height_ != 0) {
          output.writeInt32(4, height_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!content_.isEmpty()) {
          size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, content_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, mimeType_);
        }
        if (width_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, width_);
        }
        if (height_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, height_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Image)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Image other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Image) obj;

        if (!getContent().equals(other.getContent())) return false;
        if (!getMimeType().equals(other.getMimeType())) return false;
        if (getWidth() != other.getWidth()) return false;
        if (getHeight() != other.getHeight()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
        hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMimeType().hashCode();
        hash = (37 * hash) + WIDTH_FIELD_NUMBER;
        hash = (53 * hash) + getWidth();
        hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
        hash = (53 * hash) + getHeight();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Image prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Rendered image contents for this page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Image}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Image)
          com.google.cloud.documentai.v1beta3.Document.Page.ImageOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Image_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Image_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Image.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Image.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Image.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          content_ = com.google.protobuf.ByteString.EMPTY;
          mimeType_ = "";
          width_ = 0;
          height_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Image_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Image getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Image.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Image build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Image result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Image buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Image result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Image(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Page.Image result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.content_ = content_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.mimeType_ = mimeType_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.width_ = width_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.height_ = height_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Image) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Image) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Image other) {
          if (other == com.google.cloud.documentai.v1beta3.Document.Page.Image.getDefaultInstance())
            return this;
          if (other.getContent() != com.google.protobuf.ByteString.EMPTY) {
            setContent(other.getContent());
          }
          if (!other.getMimeType().isEmpty()) {
            mimeType_ = other.mimeType_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.getWidth() != 0) {
            setWidth(other.getWidth());
          }
          if (other.getHeight() != 0) {
            setHeight(other.getHeight());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    content_ = input.readBytes();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    mimeType_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 24:
                  {
                    width_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    height_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * Raw byte content of the image.
         * </pre>
         *
         * <code>bytes content = 1;</code>
         *
         * @return The content.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getContent() {
          return content_;
        }
        /**
         *
         *
         * <pre>
         * Raw byte content of the image.
         * </pre>
         *
         * <code>bytes content = 1;</code>
         *
         * @param value The content to set.
         * @return This builder for chaining.
         */
        public Builder setContent(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Raw byte content of the image.
         * </pre>
         *
         * <code>bytes content = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearContent() {
          bitField0_ = (bitField0_ & ~0x00000001);
          content_ = getDefaultInstance().getContent();
          onChanged();
          return this;
        }

        private java.lang.Object mimeType_ = "";
        /**
         *
         *
         * <pre>
         * Encoding [media type (MIME
         * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
         * for the image.
         * </pre>
         *
         * <code>string mime_type = 2;</code>
         *
         * @return The mimeType.
         */
        public java.lang.String getMimeType() {
          java.lang.Object ref = mimeType_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            mimeType_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Encoding [media type (MIME
         * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
         * for the image.
         * </pre>
         *
         * <code>string mime_type = 2;</code>
         *
         * @return The bytes for mimeType.
         */
        public com.google.protobuf.ByteString getMimeTypeBytes() {
          java.lang.Object ref = mimeType_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            mimeType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Encoding [media type (MIME
         * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
         * for the image.
         * </pre>
         *
         * <code>string mime_type = 2;</code>
         *
         * @param value The mimeType to set.
         * @return This builder for chaining.
         */
        public Builder setMimeType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          mimeType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encoding [media type (MIME
         * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
         * for the image.
         * </pre>
         *
         * <code>string mime_type = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMimeType() {
          mimeType_ = getDefaultInstance().getMimeType();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Encoding [media type (MIME
         * type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
         * for the image.
         * </pre>
         *
         * <code>string mime_type = 2;</code>
         *
         * @param value The bytes for mimeType to set.
         * @return This builder for chaining.
         */
        public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          mimeType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private int width_;
        /**
         *
         *
         * <pre>
         * Width of the image in pixels.
         * </pre>
         *
         * <code>int32 width = 3;</code>
         *
         * @return The width.
         */
        @java.lang.Override
        public int getWidth() {
          return width_;
        }
        /**
         *
         *
         * <pre>
         * Width of the image in pixels.
         * </pre>
         *
         * <code>int32 width = 3;</code>
         *
         * @param value The width to set.
         * @return This builder for chaining.
         */
        public Builder setWidth(int value) {

          width_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Width of the image in pixels.
         * </pre>
         *
         * <code>int32 width = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWidth() {
          bitField0_ = (bitField0_ & ~0x00000004);
          width_ = 0;
          onChanged();
          return this;
        }

        private int height_;
        /**
         *
         *
         * <pre>
         * Height of the image in pixels.
         * </pre>
         *
         * <code>int32 height = 4;</code>
         *
         * @return The height.
         */
        @java.lang.Override
        public int getHeight() {
          return height_;
        }
        /**
         *
         *
         * <pre>
         * Height of the image in pixels.
         * </pre>
         *
         * <code>int32 height = 4;</code>
         *
         * @param value The height to set.
         * @return This builder for chaining.
         */
        public Builder setHeight(int value) {

          height_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Height of the image in pixels.
         * </pre>
         *
         * <code>int32 height = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearHeight() {
          bitField0_ = (bitField0_ & ~0x00000008);
          height_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Image)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Image)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Image DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Image();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Image getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Image> PARSER =
          new com.google.protobuf.AbstractParser<Image>() {
            @java.lang.Override
            public Image parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Image> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Image> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Image getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MatrixOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Matrix)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Number of rows in the matrix.
       * </pre>
       *
       * <code>int32 rows = 1;</code>
       *
       * @return The rows.
       */
      int getRows();

      /**
       *
       *
       * <pre>
       * Number of columns in the matrix.
       * </pre>
       *
       * <code>int32 cols = 2;</code>
       *
       * @return The cols.
       */
      int getCols();

      /**
       *
       *
       * <pre>
       * This encodes information about what data type the matrix uses.
       * For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
       * of OpenCV primitive data types, please refer to
       * https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
       * </pre>
       *
       * <code>int32 type = 3;</code>
       *
       * @return The type.
       */
      int getType();

      /**
       *
       *
       * <pre>
       * The matrix data.
       * </pre>
       *
       * <code>bytes data = 4;</code>
       *
       * @return The data.
       */
      com.google.protobuf.ByteString getData();
    }
    /**
     *
     *
     * <pre>
     * Representation for transformation matrix, intended to be compatible and
     * used with OpenCV format for image manipulation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Matrix}
     */
    public static final class Matrix extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Matrix)
        MatrixOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Matrix.newBuilder() to construct.
      private Matrix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Matrix() {
        data_ = com.google.protobuf.ByteString.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Matrix();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Matrix_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Matrix_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Matrix.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Matrix.Builder.class);
      }

      public static final int ROWS_FIELD_NUMBER = 1;
      private int rows_ = 0;
      /**
       *
       *
       * <pre>
       * Number of rows in the matrix.
       * </pre>
       *
       * <code>int32 rows = 1;</code>
       *
       * @return The rows.
       */
      @java.lang.Override
      public int getRows() {
        return rows_;
      }

      public static final int COLS_FIELD_NUMBER = 2;
      private int cols_ = 0;
      /**
       *
       *
       * <pre>
       * Number of columns in the matrix.
       * </pre>
       *
       * <code>int32 cols = 2;</code>
       *
       * @return The cols.
       */
      @java.lang.Override
      public int getCols() {
        return cols_;
      }

      public static final int TYPE_FIELD_NUMBER = 3;
      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * This encodes information about what data type the matrix uses.
       * For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
       * of OpenCV primitive data types, please refer to
       * https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
       * </pre>
       *
       * <code>int32 type = 3;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public int getType() {
        return type_;
      }

      public static final int DATA_FIELD_NUMBER = 4;
      private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The matrix data.
       * </pre>
       *
       * <code>bytes data = 4;</code>
       *
       * @return The data.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getData() {
        return data_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (rows_ != 0) {
          output.writeInt32(1, rows_);
        }
        if (cols_ != 0) {
          output.writeInt32(2, cols_);
        }
        if (type_ != 0) {
          output.writeInt32(3, type_);
        }
        if (!data_.isEmpty()) {
          output.writeBytes(4, data_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (rows_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, rows_);
        }
        if (cols_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, cols_);
        }
        if (type_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, type_);
        }
        if (!data_.isEmpty()) {
          size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, data_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Matrix)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Matrix other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Matrix) obj;

        if (getRows() != other.getRows()) return false;
        if (getCols() != other.getCols()) return false;
        if (getType() != other.getType()) return false;
        if (!getData().equals(other.getData())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getRows();
        hash = (37 * hash) + COLS_FIELD_NUMBER;
        hash = (53 * hash) + getCols();
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType();
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + getData().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Matrix prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Representation for transformation matrix, intended to be compatible and
       * used with OpenCV format for image manipulation.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Matrix}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Matrix)
          com.google.cloud.documentai.v1beta3.Document.Page.MatrixOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Matrix_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Matrix_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Matrix.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Matrix.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Matrix.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          rows_ = 0;
          cols_ = 0;
          type_ = 0;
          data_ = com.google.protobuf.ByteString.EMPTY;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Matrix_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Matrix
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Matrix.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Matrix build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Matrix result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Matrix buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Matrix result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Matrix(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.Matrix result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.rows_ = rows_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.cols_ = cols_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.type_ = type_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.data_ = data_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Matrix) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Matrix) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Matrix other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.Matrix.getDefaultInstance())
            return this;
          if (other.getRows() != 0) {
            setRows(other.getRows());
          }
          if (other.getCols() != 0) {
            setCols(other.getCols());
          }
          if (other.getType() != 0) {
            setType(other.getType());
          }
          if (other.getData() != com.google.protobuf.ByteString.EMPTY) {
            setData(other.getData());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    rows_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    cols_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    type_ = input.readInt32();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 34:
                  {
                    data_ = input.readBytes();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int rows_;
        /**
         *
         *
         * <pre>
         * Number of rows in the matrix.
         * </pre>
         *
         * <code>int32 rows = 1;</code>
         *
         * @return The rows.
         */
        @java.lang.Override
        public int getRows() {
          return rows_;
        }
        /**
         *
         *
         * <pre>
         * Number of rows in the matrix.
         * </pre>
         *
         * <code>int32 rows = 1;</code>
         *
         * @param value The rows to set.
         * @return This builder for chaining.
         */
        public Builder setRows(int value) {

          rows_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of rows in the matrix.
         * </pre>
         *
         * <code>int32 rows = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRows() {
          bitField0_ = (bitField0_ & ~0x00000001);
          rows_ = 0;
          onChanged();
          return this;
        }

        private int cols_;
        /**
         *
         *
         * <pre>
         * Number of columns in the matrix.
         * </pre>
         *
         * <code>int32 cols = 2;</code>
         *
         * @return The cols.
         */
        @java.lang.Override
        public int getCols() {
          return cols_;
        }
        /**
         *
         *
         * <pre>
         * Number of columns in the matrix.
         * </pre>
         *
         * <code>int32 cols = 2;</code>
         *
         * @param value The cols to set.
         * @return This builder for chaining.
         */
        public Builder setCols(int value) {

          cols_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Number of columns in the matrix.
         * </pre>
         *
         * <code>int32 cols = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCols() {
          bitField0_ = (bitField0_ & ~0x00000002);
          cols_ = 0;
          onChanged();
          return this;
        }

        private int type_;
        /**
         *
         *
         * <pre>
         * This encodes information about what data type the matrix uses.
         * For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
         * of OpenCV primitive data types, please refer to
         * https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
         * </pre>
         *
         * <code>int32 type = 3;</code>
         *
         * @return The type.
         */
        @java.lang.Override
        public int getType() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * This encodes information about what data type the matrix uses.
         * For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
         * of OpenCV primitive data types, please refer to
         * https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
         * </pre>
         *
         * <code>int32 type = 3;</code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(int value) {

          type_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * This encodes information about what data type the matrix uses.
         * For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
         * of OpenCV primitive data types, please refer to
         * https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
         * </pre>
         *
         * <code>int32 type = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000004);
          type_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * The matrix data.
         * </pre>
         *
         * <code>bytes data = 4;</code>
         *
         * @return The data.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getData() {
          return data_;
        }
        /**
         *
         *
         * <pre>
         * The matrix data.
         * </pre>
         *
         * <code>bytes data = 4;</code>
         *
         * @param value The data to set.
         * @return This builder for chaining.
         */
        public Builder setData(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The matrix data.
         * </pre>
         *
         * <code>bytes data = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearData() {
          bitField0_ = (bitField0_ & ~0x00000008);
          data_ = getDefaultInstance().getData();
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Matrix)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Matrix)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Matrix
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Matrix();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Matrix getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Matrix> PARSER =
          new com.google.protobuf.AbstractParser<Matrix>() {
            @java.lang.Override
            public Matrix parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Matrix> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Matrix> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Matrix getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LayoutOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Layout)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      boolean hasTextAnchor();
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor();
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder getTextAnchorOrBuilder();

      /**
       *
       *
       * <pre>
       * Confidence of the current
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] within
       * context of the object this layout is for. e.g. confidence can be for a
       * single token, a table, a visual element, etc. depending on context.
       * Range `[0, 1]`.
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      float getConfidence();

      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      boolean hasBoundingPoly();
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       *
       * @return The boundingPoly.
       */
      com.google.cloud.documentai.v1beta3.BoundingPoly getBoundingPoly();
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       */
      com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder getBoundingPolyOrBuilder();

      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for orientation.
       */
      int getOrientationValue();
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The orientation.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation getOrientation();
    }
    /**
     *
     *
     * <pre>
     * Visual element describing a layout unit on a page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Layout}
     */
    public static final class Layout extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Layout)
        LayoutOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Layout.newBuilder() to construct.
      private Layout(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Layout() {
        orientation_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Layout();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Layout_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Layout_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Detected human reading orientation.
       * </pre>
       *
       * Protobuf enum {@code google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation}
       */
      public enum Orientation implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Unspecified orientation.
         * </pre>
         *
         * <code>ORIENTATION_UNSPECIFIED = 0;</code>
         */
        ORIENTATION_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page up.
         * </pre>
         *
         * <code>PAGE_UP = 1;</code>
         */
        PAGE_UP(1),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page right.
         * Turn the head 90 degrees clockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_RIGHT = 2;</code>
         */
        PAGE_RIGHT(2),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page down.
         * Turn the head 180 degrees from upright to read.
         * </pre>
         *
         * <code>PAGE_DOWN = 3;</code>
         */
        PAGE_DOWN(3),
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page left.
         * Turn the head 90 degrees counterclockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_LEFT = 4;</code>
         */
        PAGE_LEFT(4),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Unspecified orientation.
         * </pre>
         *
         * <code>ORIENTATION_UNSPECIFIED = 0;</code>
         */
        public static final int ORIENTATION_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page up.
         * </pre>
         *
         * <code>PAGE_UP = 1;</code>
         */
        public static final int PAGE_UP_VALUE = 1;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page right.
         * Turn the head 90 degrees clockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_RIGHT = 2;</code>
         */
        public static final int PAGE_RIGHT_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page down.
         * Turn the head 180 degrees from upright to read.
         * </pre>
         *
         * <code>PAGE_DOWN = 3;</code>
         */
        public static final int PAGE_DOWN_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Orientation is aligned with page left.
         * Turn the head 90 degrees counterclockwise from upright to read.
         * </pre>
         *
         * <code>PAGE_LEFT = 4;</code>
         */
        public static final int PAGE_LEFT_VALUE = 4;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Orientation valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Orientation forNumber(int value) {
          switch (value) {
            case 0:
              return ORIENTATION_UNSPECIFIED;
            case 1:
              return PAGE_UP;
            case 2:
              return PAGE_RIGHT;
            case 3:
              return PAGE_DOWN;
            case 4:
              return PAGE_LEFT;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Orientation> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<Orientation>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<Orientation>() {
                  public Orientation findValueByNumber(int number) {
                    return Orientation.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final Orientation[] VALUES = values();

        public static Orientation valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Orientation(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation)
      }

      private int bitField0_;
      public static final int TEXT_ANCHOR_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.TextAnchor textAnchor_;
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return Whether the textAnchor field is set.
       */
      @java.lang.Override
      public boolean hasTextAnchor() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       *
       * @return The textAnchor.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor() {
        return textAnchor_ == null
            ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
            : textAnchor_;
      }
      /**
       *
       *
       * <pre>
       * Text anchor indexing into the
       * [Document.text][google.cloud.documentai.v1beta3.Document.text].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder
          getTextAnchorOrBuilder() {
        return textAnchor_ == null
            ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
            : textAnchor_;
      }

      public static final int CONFIDENCE_FIELD_NUMBER = 2;
      private float confidence_ = 0F;
      /**
       *
       *
       * <pre>
       * Confidence of the current
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] within
       * context of the object this layout is for. e.g. confidence can be for a
       * single token, a table, a visual element, etc. depending on context.
       * Range `[0, 1]`.
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }

      public static final int BOUNDING_POLY_FIELD_NUMBER = 3;
      private com.google.cloud.documentai.v1beta3.BoundingPoly boundingPoly_;
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       *
       * @return Whether the boundingPoly field is set.
       */
      @java.lang.Override
      public boolean hasBoundingPoly() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       *
       * @return The boundingPoly.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BoundingPoly getBoundingPoly() {
        return boundingPoly_ == null
            ? com.google.cloud.documentai.v1beta3.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }
      /**
       *
       *
       * <pre>
       * The bounding polygon for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
        return boundingPoly_ == null
            ? com.google.cloud.documentai.v1beta3.BoundingPoly.getDefaultInstance()
            : boundingPoly_;
      }

      public static final int ORIENTATION_FIELD_NUMBER = 4;
      private int orientation_ = 0;
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for orientation.
       */
      @java.lang.Override
      public int getOrientationValue() {
        return orientation_;
      }
      /**
       *
       *
       * <pre>
       * Detected orientation for the
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
       * </code>
       *
       * @return The orientation.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation getOrientation() {
        com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation result =
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation.forNumber(
                orientation_);
        return result == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getTextAnchor());
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          output.writeFloat(2, confidence_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getBoundingPoly());
        }
        if (orientation_
            != com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation
                .ORIENTATION_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(4, orientation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTextAnchor());
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBoundingPoly());
        }
        if (orientation_
            != com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation
                .ORIENTATION_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, orientation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Layout)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Layout other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Layout) obj;

        if (hasTextAnchor() != other.hasTextAnchor()) return false;
        if (hasTextAnchor()) {
          if (!getTextAnchor().equals(other.getTextAnchor())) return false;
        }
        if (java.lang.Float.floatToIntBits(getConfidence())
            != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
        if (hasBoundingPoly() != other.hasBoundingPoly()) return false;
        if (hasBoundingPoly()) {
          if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
        }
        if (orientation_ != other.orientation_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTextAnchor()) {
          hash = (37 * hash) + TEXT_ANCHOR_FIELD_NUMBER;
          hash = (53 * hash) + getTextAnchor().hashCode();
        }
        hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
        if (hasBoundingPoly()) {
          hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
          hash = (53 * hash) + getBoundingPoly().hashCode();
        }
        hash = (37 * hash) + ORIENTATION_FIELD_NUMBER;
        hash = (53 * hash) + orientation_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Layout prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Visual element describing a layout unit on a page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Layout}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Layout)
          com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Layout_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Layout_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Layout.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTextAnchorFieldBuilder();
            getBoundingPolyFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          textAnchor_ = null;
          if (textAnchorBuilder_ != null) {
            textAnchorBuilder_.dispose();
            textAnchorBuilder_ = null;
          }
          confidence_ = 0F;
          boundingPoly_ = null;
          if (boundingPolyBuilder_ != null) {
            boundingPolyBuilder_.dispose();
            boundingPolyBuilder_ = null;
          }
          orientation_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Layout_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Layout result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Layout result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Layout(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.textAnchor_ =
                textAnchorBuilder_ == null ? textAnchor_ : textAnchorBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.confidence_ = confidence_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.boundingPoly_ =
                boundingPolyBuilder_ == null ? boundingPoly_ : boundingPolyBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.orientation_ = orientation_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Layout) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Layout) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Layout other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance())
            return this;
          if (other.hasTextAnchor()) {
            mergeTextAnchor(other.getTextAnchor());
          }
          if (other.getConfidence() != 0F) {
            setConfidence(other.getConfidence());
          }
          if (other.hasBoundingPoly()) {
            mergeBoundingPoly(other.getBoundingPoly());
          }
          if (other.orientation_ != 0) {
            setOrientationValue(other.getOrientationValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getTextAnchorFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 21:
                  {
                    confidence_ = input.readFloat();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 21
                case 26:
                  {
                    input.readMessage(
                        getBoundingPolyFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 32:
                  {
                    orientation_ = input.readEnum();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.TextAnchor textAnchor_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.TextAnchor,
                com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
                com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>
            textAnchorBuilder_;
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         *
         * @return Whether the textAnchor field is set.
         */
        public boolean hasTextAnchor() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         *
         * @return The textAnchor.
         */
        public com.google.cloud.documentai.v1beta3.Document.TextAnchor getTextAnchor() {
          if (textAnchorBuilder_ == null) {
            return textAnchor_ == null
                ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
                : textAnchor_;
          } else {
            return textAnchorBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder setTextAnchor(
            com.google.cloud.documentai.v1beta3.Document.TextAnchor value) {
          if (textAnchorBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            textAnchor_ = value;
          } else {
            textAnchorBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder setTextAnchor(
            com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder builderForValue) {
          if (textAnchorBuilder_ == null) {
            textAnchor_ = builderForValue.build();
          } else {
            textAnchorBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder mergeTextAnchor(
            com.google.cloud.documentai.v1beta3.Document.TextAnchor value) {
          if (textAnchorBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && textAnchor_ != null
                && textAnchor_
                    != com.google.cloud.documentai.v1beta3.Document.TextAnchor
                        .getDefaultInstance()) {
              getTextAnchorBuilder().mergeFrom(value);
            } else {
              textAnchor_ = value;
            }
          } else {
            textAnchorBuilder_.mergeFrom(value);
          }
          if (textAnchor_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public Builder clearTextAnchor() {
          bitField0_ = (bitField0_ & ~0x00000001);
          textAnchor_ = null;
          if (textAnchorBuilder_ != null) {
            textAnchorBuilder_.dispose();
            textAnchorBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder
            getTextAnchorBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTextAnchorFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder
            getTextAnchorOrBuilder() {
          if (textAnchorBuilder_ != null) {
            return textAnchorBuilder_.getMessageOrBuilder();
          } else {
            return textAnchor_ == null
                ? com.google.cloud.documentai.v1beta3.Document.TextAnchor.getDefaultInstance()
                : textAnchor_;
          }
        }
        /**
         *
         *
         * <pre>
         * Text anchor indexing into the
         * [Document.text][google.cloud.documentai.v1beta3.Document.text].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.TextAnchor text_anchor = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.TextAnchor,
                com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
                com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>
            getTextAnchorFieldBuilder() {
          if (textAnchorBuilder_ == null) {
            textAnchorBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.TextAnchor,
                    com.google.cloud.documentai.v1beta3.Document.TextAnchor.Builder,
                    com.google.cloud.documentai.v1beta3.Document.TextAnchorOrBuilder>(
                    getTextAnchor(), getParentForChildren(), isClean());
            textAnchor_ = null;
          }
          return textAnchorBuilder_;
        }

        private float confidence_;
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range `[0, 1]`.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return The confidence.
         */
        @java.lang.Override
        public float getConfidence() {
          return confidence_;
        }
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range `[0, 1]`.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @param value The confidence to set.
         * @return This builder for chaining.
         */
        public Builder setConfidence(float value) {

          confidence_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Confidence of the current
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] within
         * context of the object this layout is for. e.g. confidence can be for a
         * single token, a table, a visual element, etc. depending on context.
         * Range `[0, 1]`.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidence() {
          bitField0_ = (bitField0_ & ~0x00000002);
          confidence_ = 0F;
          onChanged();
          return this;
        }

        private com.google.cloud.documentai.v1beta3.BoundingPoly boundingPoly_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BoundingPoly,
                com.google.cloud.documentai.v1beta3.BoundingPoly.Builder,
                com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder>
            boundingPolyBuilder_;
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         *
         * @return Whether the boundingPoly field is set.
         */
        public boolean hasBoundingPoly() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         *
         * @return The boundingPoly.
         */
        public com.google.cloud.documentai.v1beta3.BoundingPoly getBoundingPoly() {
          if (boundingPolyBuilder_ == null) {
            return boundingPoly_ == null
                ? com.google.cloud.documentai.v1beta3.BoundingPoly.getDefaultInstance()
                : boundingPoly_;
          } else {
            return boundingPolyBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder setBoundingPoly(com.google.cloud.documentai.v1beta3.BoundingPoly value) {
          if (boundingPolyBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            boundingPoly_ = value;
          } else {
            boundingPolyBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder setBoundingPoly(
            com.google.cloud.documentai.v1beta3.BoundingPoly.Builder builderForValue) {
          if (boundingPolyBuilder_ == null) {
            boundingPoly_ = builderForValue.build();
          } else {
            boundingPolyBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder mergeBoundingPoly(com.google.cloud.documentai.v1beta3.BoundingPoly value) {
          if (boundingPolyBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && boundingPoly_ != null
                && boundingPoly_
                    != com.google.cloud.documentai.v1beta3.BoundingPoly.getDefaultInstance()) {
              getBoundingPolyBuilder().mergeFrom(value);
            } else {
              boundingPoly_ = value;
            }
          } else {
            boundingPolyBuilder_.mergeFrom(value);
          }
          if (boundingPoly_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public Builder clearBoundingPoly() {
          bitField0_ = (bitField0_ & ~0x00000004);
          boundingPoly_ = null;
          if (boundingPolyBuilder_ != null) {
            boundingPolyBuilder_.dispose();
            boundingPolyBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public com.google.cloud.documentai.v1beta3.BoundingPoly.Builder getBoundingPolyBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getBoundingPolyFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        public com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder
            getBoundingPolyOrBuilder() {
          if (boundingPolyBuilder_ != null) {
            return boundingPolyBuilder_.getMessageOrBuilder();
          } else {
            return boundingPoly_ == null
                ? com.google.cloud.documentai.v1beta3.BoundingPoly.getDefaultInstance()
                : boundingPoly_;
          }
        }
        /**
         *
         *
         * <pre>
         * The bounding polygon for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.BoundingPoly bounding_poly = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BoundingPoly,
                com.google.cloud.documentai.v1beta3.BoundingPoly.Builder,
                com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder>
            getBoundingPolyFieldBuilder() {
          if (boundingPolyBuilder_ == null) {
            boundingPolyBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.BoundingPoly,
                    com.google.cloud.documentai.v1beta3.BoundingPoly.Builder,
                    com.google.cloud.documentai.v1beta3.BoundingPolyOrBuilder>(
                    getBoundingPoly(), getParentForChildren(), isClean());
            boundingPoly_ = null;
          }
          return boundingPolyBuilder_;
        }

        private int orientation_ = 0;
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return The enum numeric value on the wire for orientation.
         */
        @java.lang.Override
        public int getOrientationValue() {
          return orientation_;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @param value The enum numeric value on the wire for orientation to set.
         * @return This builder for chaining.
         */
        public Builder setOrientationValue(int value) {
          orientation_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return The orientation.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation
            getOrientation() {
          com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation result =
              com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation.forNumber(
                  orientation_);
          return result == null
              ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @param value The orientation to set.
         * @return This builder for chaining.
         */
        public Builder setOrientation(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000008;
          orientation_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected orientation for the
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout.Orientation orientation = 4;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrientation() {
          bitField0_ = (bitField0_ & ~0x00000008);
          orientation_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Layout)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Layout)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Layout
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Layout();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Layout getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Layout> PARSER =
          new com.google.protobuf.AbstractParser<Layout>() {
            @java.lang.Override
            public Layout parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Layout> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Layout> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface BlockOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Block)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=207
       * @return Whether the provenance field is set.
       */
      @java.lang.Deprecated
      boolean hasProvenance();
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=207
       * @return The provenance.
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A block has a set of lines (collected into paragraphs) that have a
     * common line-spacing and orientation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Block}
     */
    public static final class Block extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Block)
        BlockOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Block.newBuilder() to construct.
      private Block(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Block() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Block();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Block_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Block_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Block.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Block.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      public static final int PROVENANCE_FIELD_NUMBER = 3;
      private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=207
       * @return Whether the provenance field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasProvenance() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=207
       * @return The provenance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
          getProvenanceOrBuilder() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getProvenance());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProvenance());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Block)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Block other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Block) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (hasProvenance() != other.hasProvenance()) return false;
        if (hasProvenance()) {
          if (!getProvenance().equals(other.getProvenance())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        if (hasProvenance()) {
          hash = (37 * hash) + PROVENANCE_FIELD_NUMBER;
          hash = (53 * hash) + getProvenance().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Block prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A block has a set of lines (collected into paragraphs) that have a
       * common line-spacing and orientation.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Block}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Block)
          com.google.cloud.documentai.v1beta3.Document.Page.BlockOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Block_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Block_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Block.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Block.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Block.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
            getProvenanceFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Block_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Block getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Block.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Block build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Block result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Block buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Block result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Block(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Block result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Page.Block result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.provenance_ =
                provenanceBuilder_ == null ? provenance_ : provenanceBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Block) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Block) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Block other) {
          if (other == com.google.cloud.documentai.v1beta3.Document.Page.Block.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          if (other.hasProvenance()) {
            mergeProvenance(other.getProvenance());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Block][google.cloud.documentai.v1beta3.Document.Page.Block].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            provenanceBuilder_;
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=207
         * @return Whether the provenance field is set.
         */
        @java.lang.Deprecated
        public boolean hasProvenance() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Block.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=207
         * @return The provenance.
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
          if (provenanceBuilder_ == null) {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          } else {
            return provenanceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            provenance_ = value;
          } else {
            provenanceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance.Builder builderForValue) {
          if (provenanceBuilder_ == null) {
            provenance_ = builderForValue.build();
          } else {
            provenanceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder mergeProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && provenance_ != null
                && provenance_
                    != com.google.cloud.documentai.v1beta3.Document.Provenance
                        .getDefaultInstance()) {
              getProvenanceBuilder().mergeFrom(value);
            } else {
              provenance_ = value;
            }
          } else {
            provenanceBuilder_.mergeFrom(value);
          }
          if (provenance_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder clearProvenance() {
          bitField0_ = (bitField0_ & ~0x00000004);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance.Builder
            getProvenanceBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getProvenanceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
            getProvenanceOrBuilder() {
          if (provenanceBuilder_ != null) {
            return provenanceBuilder_.getMessageOrBuilder();
          } else {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          }
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            getProvenanceFieldBuilder() {
          if (provenanceBuilder_ == null) {
            provenanceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Provenance,
                    com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                    com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>(
                    getProvenance(), getParentForChildren(), isClean());
            provenance_ = null;
          }
          return provenanceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Block)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Block)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Block DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Block();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Block getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Block> PARSER =
          new com.google.protobuf.AbstractParser<Block>() {
            @java.lang.Override
            public Block parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Block> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Block> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Block getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ParagraphOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Paragraph)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
       *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
       * @return Whether the provenance field is set.
       */
      @java.lang.Deprecated
      boolean hasProvenance();
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
       *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
       * @return The provenance.
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A collection of lines that a human would perceive as a paragraph.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Paragraph}
     */
    public static final class Paragraph extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Paragraph)
        ParagraphOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Paragraph.newBuilder() to construct.
      private Paragraph(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Paragraph() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Paragraph();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Paragraph_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Paragraph_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      public static final int PROVENANCE_FIELD_NUMBER = 3;
      private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
       *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
       * @return Whether the provenance field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasProvenance() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
       *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
       * @return The provenance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
          getProvenanceOrBuilder() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getProvenance());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProvenance());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Paragraph)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Paragraph other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Paragraph) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (hasProvenance() != other.hasProvenance()) return false;
        if (hasProvenance()) {
          if (!getProvenance().equals(other.getProvenance())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        if (hasProvenance()) {
          hash = (37 * hash) + PROVENANCE_FIELD_NUMBER;
          hash = (53 * hash) + getProvenance().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Paragraph prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A collection of lines that a human would perceive as a paragraph.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Paragraph}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Paragraph)
          com.google.cloud.documentai.v1beta3.Document.Page.ParagraphOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Paragraph_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Paragraph_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
            getProvenanceFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Paragraph_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Paragraph
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Paragraph build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Paragraph result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Paragraph buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Paragraph result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Paragraph(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Paragraph result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.Paragraph result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.provenance_ =
                provenanceBuilder_ == null ? provenance_ : provenanceBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Paragraph) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Paragraph) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.Document.Page.Paragraph other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.Paragraph.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          if (other.hasProvenance()) {
            mergeProvenance(other.getProvenance());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Paragraph][google.cloud.documentai.v1beta3.Document.Page.Paragraph].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            provenanceBuilder_;
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
         *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
         * @return Whether the provenance field is set.
         */
        @java.lang.Deprecated
        public boolean hasProvenance() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Paragraph.provenance is
         *     deprecated. See google/cloud/documentai/v1beta3/document.proto;l=220
         * @return The provenance.
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
          if (provenanceBuilder_ == null) {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          } else {
            return provenanceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            provenance_ = value;
          } else {
            provenanceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance.Builder builderForValue) {
          if (provenanceBuilder_ == null) {
            provenance_ = builderForValue.build();
          } else {
            provenanceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder mergeProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && provenance_ != null
                && provenance_
                    != com.google.cloud.documentai.v1beta3.Document.Provenance
                        .getDefaultInstance()) {
              getProvenanceBuilder().mergeFrom(value);
            } else {
              provenance_ = value;
            }
          } else {
            provenanceBuilder_.mergeFrom(value);
          }
          if (provenance_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder clearProvenance() {
          bitField0_ = (bitField0_ & ~0x00000004);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance.Builder
            getProvenanceBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getProvenanceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
            getProvenanceOrBuilder() {
          if (provenanceBuilder_ != null) {
            return provenanceBuilder_.getMessageOrBuilder();
          } else {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          }
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            getProvenanceFieldBuilder() {
          if (provenanceBuilder_ == null) {
            provenanceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Provenance,
                    com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                    com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>(
                    getProvenance(), getParentForChildren(), isClean());
            provenance_ = null;
          }
          return provenanceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Paragraph)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Paragraph)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Paragraph
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Paragraph();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Paragraph
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Paragraph> PARSER =
          new com.google.protobuf.AbstractParser<Paragraph>() {
            @java.lang.Override
            public Paragraph parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Paragraph> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Paragraph> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Paragraph
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface LineOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Line)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=234
       * @return Whether the provenance field is set.
       */
      @java.lang.Deprecated
      boolean hasProvenance();
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=234
       * @return The provenance.
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A collection of tokens that a human would perceive as a line.
     * Does not cross column boundaries, can be horizontal, vertical, etc.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Line}
     */
    public static final class Line extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Line)
        LineOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Line.newBuilder() to construct.
      private Line(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Line() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Line();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Line_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Line_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Line.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Line.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      public static final int PROVENANCE_FIELD_NUMBER = 3;
      private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=234
       * @return Whether the provenance field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasProvenance() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=234
       * @return The provenance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }
      /**
       *
       *
       * <pre>
       * The  history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
          getProvenanceOrBuilder() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getProvenance());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProvenance());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Line)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Line other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Line) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (hasProvenance() != other.hasProvenance()) return false;
        if (hasProvenance()) {
          if (!getProvenance().equals(other.getProvenance())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        if (hasProvenance()) {
          hash = (37 * hash) + PROVENANCE_FIELD_NUMBER;
          hash = (53 * hash) + getProvenance().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Line prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A collection of tokens that a human would perceive as a line.
       * Does not cross column boundaries, can be horizontal, vertical, etc.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Line}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Line)
          com.google.cloud.documentai.v1beta3.Document.Page.LineOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Line_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Line_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Line.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Line.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Line.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
            getProvenanceFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Line_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Line getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Line.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Line build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Line result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Line buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Line result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Line(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Line result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Page.Line result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.provenance_ =
                provenanceBuilder_ == null ? provenance_ : provenanceBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Line) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Line) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Line other) {
          if (other == com.google.cloud.documentai.v1beta3.Document.Page.Line.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          if (other.hasProvenance()) {
            mergeProvenance(other.getProvenance());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(getProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Line][google.cloud.documentai.v1beta3.Document.Page.Line].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            provenanceBuilder_;
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=234
         * @return Whether the provenance field is set.
         */
        @java.lang.Deprecated
        public boolean hasProvenance() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Line.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=234
         * @return The provenance.
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
          if (provenanceBuilder_ == null) {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          } else {
            return provenanceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            provenance_ = value;
          } else {
            provenanceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance.Builder builderForValue) {
          if (provenanceBuilder_ == null) {
            provenance_ = builderForValue.build();
          } else {
            provenanceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder mergeProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)
                && provenance_ != null
                && provenance_
                    != com.google.cloud.documentai.v1beta3.Document.Provenance
                        .getDefaultInstance()) {
              getProvenanceBuilder().mergeFrom(value);
            } else {
              provenance_ = value;
            }
          } else {
            provenanceBuilder_.mergeFrom(value);
          }
          if (provenance_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder clearProvenance() {
          bitField0_ = (bitField0_ & ~0x00000004);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance.Builder
            getProvenanceBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getProvenanceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
            getProvenanceOrBuilder() {
          if (provenanceBuilder_ != null) {
            return provenanceBuilder_.getMessageOrBuilder();
          } else {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          }
        }
        /**
         *
         *
         * <pre>
         * The  history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 3 [deprecated = true];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            getProvenanceFieldBuilder() {
          if (provenanceBuilder_ == null) {
            provenanceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Provenance,
                    com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                    com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>(
                    getProvenance(), getParentForChildren(), isClean());
            provenance_ = null;
          }
          return provenanceBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Line)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Line)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Line DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Line();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Line getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Line> PARSER =
          new com.google.protobuf.AbstractParser<Line>() {
            @java.lang.Override
            public Line parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Line> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Line> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Line getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TokenOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Token)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return Whether the detectedBreak field is set.
       */
      boolean hasDetectedBreak();
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return The detectedBreak.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak getDetectedBreak();
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder
          getDetectedBreakOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=326
       * @return Whether the provenance field is set.
       */
      @java.lang.Deprecated
      boolean hasProvenance();
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=326
       * @return The provenance.
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();

      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       *
       * @return Whether the styleInfo field is set.
       */
      boolean hasStyleInfo();
      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       *
       * @return The styleInfo.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo getStyleInfo();
      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder
          getStyleInfoOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A detected token.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token}
     */
    public static final class Token extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Token)
        TokenOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Token.newBuilder() to construct.
      private Token(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Token() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Token();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Token.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.Builder.class);
      }

      public interface DetectedBreakOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        int getTypeValue();
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type getType();
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak}
       */
      public static final class DetectedBreak extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)
          DetectedBreakOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DetectedBreak.newBuilder() to construct.
        private DetectedBreak(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DetectedBreak() {
          type_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DetectedBreak();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_DetectedBreak_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_DetectedBreak_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder
                      .class);
        }

        /**
         *
         *
         * <pre>
         * Enum to denote the type of break found.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type}
         */
        public enum Type implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified break type.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          TYPE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * A single whitespace.
           * </pre>
           *
           * <code>SPACE = 1;</code>
           */
          SPACE(1),
          /**
           *
           *
           * <pre>
           * A wider whitespace.
           * </pre>
           *
           * <code>WIDE_SPACE = 2;</code>
           */
          WIDE_SPACE(2),
          /**
           *
           *
           * <pre>
           * A hyphen that indicates that a token has been split across lines.
           * </pre>
           *
           * <code>HYPHEN = 3;</code>
           */
          HYPHEN(3),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified break type.
           * </pre>
           *
           * <code>TYPE_UNSPECIFIED = 0;</code>
           */
          public static final int TYPE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * A single whitespace.
           * </pre>
           *
           * <code>SPACE = 1;</code>
           */
          public static final int SPACE_VALUE = 1;
          /**
           *
           *
           * <pre>
           * A wider whitespace.
           * </pre>
           *
           * <code>WIDE_SPACE = 2;</code>
           */
          public static final int WIDE_SPACE_VALUE = 2;
          /**
           *
           *
           * <pre>
           * A hyphen that indicates that a token has been split across lines.
           * </pre>
           *
           * <code>HYPHEN = 3;</code>
           */
          public static final int HYPHEN_VALUE = 3;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Type valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Type forNumber(int value) {
            switch (value) {
              case 0:
                return TYPE_UNSPECIFIED;
              case 1:
                return SPACE;
              case 2:
                return WIDE_SPACE;
              case 3:
                return HYPHEN;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                public Type findValueByNumber(int number) {
                  return Type.forNumber(number);
                }
              };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                .getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Type[] VALUES = values();

          public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Type(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type)
        }

        public static final int TYPE_FIELD_NUMBER = 1;
        private int type_ = 0;
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }
        /**
         *
         *
         * <pre>
         * Detected break type.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
            getType() {
          com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type result =
              com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type.forNumber(
                  type_);
          return result == null
              ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
                  .UNRECOGNIZED
              : result;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (type_
              != com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
                  .TYPE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, type_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (type_
              != com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
                  .TYPE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak other =
              (com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak) obj;

          if (type_ != other.type_) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + type_;
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_DetectedBreak_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_DetectedBreak_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.class,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            type_ = 0;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_DetectedBreak_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak build() {
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
              buildPartial() {
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak result =
                new com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.type_ = type_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak other) {
            if (other
                == com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()) return this;
            if (other.type_ != 0) {
              setTypeValue(other.getTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      type_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int type_ = 0;
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return The enum numeric value on the wire for type.
           */
          @java.lang.Override
          public int getTypeValue() {
            return type_;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @param value The enum numeric value on the wire for type to set.
           * @return This builder for chaining.
           */
          public Builder setTypeValue(int value) {
            type_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return The type.
           */
          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
              getType() {
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type result =
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
                    .forNumber(type_);
            return result == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type
                    .UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @param value The type to set.
           * @return This builder for chaining.
           */
          public Builder setType(
              com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            type_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Detected break type.
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Type type = 1;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearType() {
            bitField0_ = (bitField0_ & ~0x00000001);
            type_ = 0;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak)
        private static final com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak();
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DetectedBreak> PARSER =
            new com.google.protobuf.AbstractParser<DetectedBreak>() {
              @java.lang.Override
              public DetectedBreak parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DetectedBreak> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DetectedBreak> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface StyleInfoOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Font size in points (`1` point is `¹⁄₇₂` inches).
         * </pre>
         *
         * <code>int32 font_size = 1;</code>
         *
         * @return The fontSize.
         */
        int getFontSize();

        /**
         *
         *
         * <pre>
         * Font size in pixels, equal to _unrounded
         * [font_size][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_size]_
         * * _resolution_ ÷ `72.0`.
         * </pre>
         *
         * <code>double pixel_font_size = 2;</code>
         *
         * @return The pixelFontSize.
         */
        double getPixelFontSize();

        /**
         *
         *
         * <pre>
         * Letter spacing in points.
         * </pre>
         *
         * <code>double letter_spacing = 3;</code>
         *
         * @return The letterSpacing.
         */
        double getLetterSpacing();

        /**
         *
         *
         * <pre>
         * Name or style of the font.
         * </pre>
         *
         * <code>string font_type = 4;</code>
         *
         * @return The fontType.
         */
        java.lang.String getFontType();
        /**
         *
         *
         * <pre>
         * Name or style of the font.
         * </pre>
         *
         * <code>string font_type = 4;</code>
         *
         * @return The bytes for fontType.
         */
        com.google.protobuf.ByteString getFontTypeBytes();

        /**
         *
         *
         * <pre>
         * Whether the text is bold (equivalent to
         * [font_weight][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_weight]
         * is at least `700`).
         * </pre>
         *
         * <code>bool bold = 5;</code>
         *
         * @return The bold.
         */
        boolean getBold();

        /**
         *
         *
         * <pre>
         * Whether the text is italic.
         * </pre>
         *
         * <code>bool italic = 6;</code>
         *
         * @return The italic.
         */
        boolean getItalic();

        /**
         *
         *
         * <pre>
         * Whether the text is underlined.
         * </pre>
         *
         * <code>bool underlined = 7;</code>
         *
         * @return The underlined.
         */
        boolean getUnderlined();

        /**
         *
         *
         * <pre>
         * Whether the text is strikethrough. This feature is not supported yet.
         * </pre>
         *
         * <code>bool strikeout = 8;</code>
         *
         * @return The strikeout.
         */
        boolean getStrikeout();

        /**
         *
         *
         * <pre>
         * Whether the text is a subscript. This feature is not supported yet.
         * </pre>
         *
         * <code>bool subscript = 9;</code>
         *
         * @return The subscript.
         */
        boolean getSubscript();

        /**
         *
         *
         * <pre>
         * Whether the text is a superscript. This feature is not supported yet.
         * </pre>
         *
         * <code>bool superscript = 10;</code>
         *
         * @return The superscript.
         */
        boolean getSuperscript();

        /**
         *
         *
         * <pre>
         * Whether the text is in small caps. This feature is not supported yet.
         * </pre>
         *
         * <code>bool smallcaps = 11;</code>
         *
         * @return The smallcaps.
         */
        boolean getSmallcaps();

        /**
         *
         *
         * <pre>
         * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
         * Normal is `400`, bold is `700`.
         * </pre>
         *
         * <code>int32 font_weight = 12;</code>
         *
         * @return The fontWeight.
         */
        int getFontWeight();

        /**
         *
         *
         * <pre>
         * Whether the text is handwritten.
         * </pre>
         *
         * <code>bool handwritten = 13;</code>
         *
         * @return The handwritten.
         */
        boolean getHandwritten();

        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         *
         * @return Whether the textColor field is set.
         */
        boolean hasTextColor();
        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         *
         * @return The textColor.
         */
        com.google.type.Color getTextColor();
        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         */
        com.google.type.ColorOrBuilder getTextColorOrBuilder();

        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         *
         * @return Whether the backgroundColor field is set.
         */
        boolean hasBackgroundColor();
        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         *
         * @return The backgroundColor.
         */
        com.google.type.Color getBackgroundColor();
        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         */
        com.google.type.ColorOrBuilder getBackgroundColorOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Font and other text style attributes.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo}
       */
      public static final class StyleInfo extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)
          StyleInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use StyleInfo.newBuilder() to construct.
        private StyleInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private StyleInfo() {
          fontType_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new StyleInfo();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_StyleInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_StyleInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder.class);
        }

        private int bitField0_;
        public static final int FONT_SIZE_FIELD_NUMBER = 1;
        private int fontSize_ = 0;
        /**
         *
         *
         * <pre>
         * Font size in points (`1` point is `¹⁄₇₂` inches).
         * </pre>
         *
         * <code>int32 font_size = 1;</code>
         *
         * @return The fontSize.
         */
        @java.lang.Override
        public int getFontSize() {
          return fontSize_;
        }

        public static final int PIXEL_FONT_SIZE_FIELD_NUMBER = 2;
        private double pixelFontSize_ = 0D;
        /**
         *
         *
         * <pre>
         * Font size in pixels, equal to _unrounded
         * [font_size][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_size]_
         * * _resolution_ ÷ `72.0`.
         * </pre>
         *
         * <code>double pixel_font_size = 2;</code>
         *
         * @return The pixelFontSize.
         */
        @java.lang.Override
        public double getPixelFontSize() {
          return pixelFontSize_;
        }

        public static final int LETTER_SPACING_FIELD_NUMBER = 3;
        private double letterSpacing_ = 0D;
        /**
         *
         *
         * <pre>
         * Letter spacing in points.
         * </pre>
         *
         * <code>double letter_spacing = 3;</code>
         *
         * @return The letterSpacing.
         */
        @java.lang.Override
        public double getLetterSpacing() {
          return letterSpacing_;
        }

        public static final int FONT_TYPE_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private volatile java.lang.Object fontType_ = "";
        /**
         *
         *
         * <pre>
         * Name or style of the font.
         * </pre>
         *
         * <code>string font_type = 4;</code>
         *
         * @return The fontType.
         */
        @java.lang.Override
        public java.lang.String getFontType() {
          java.lang.Object ref = fontType_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            fontType_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Name or style of the font.
         * </pre>
         *
         * <code>string font_type = 4;</code>
         *
         * @return The bytes for fontType.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getFontTypeBytes() {
          java.lang.Object ref = fontType_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            fontType_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int BOLD_FIELD_NUMBER = 5;
        private boolean bold_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is bold (equivalent to
         * [font_weight][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_weight]
         * is at least `700`).
         * </pre>
         *
         * <code>bool bold = 5;</code>
         *
         * @return The bold.
         */
        @java.lang.Override
        public boolean getBold() {
          return bold_;
        }

        public static final int ITALIC_FIELD_NUMBER = 6;
        private boolean italic_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is italic.
         * </pre>
         *
         * <code>bool italic = 6;</code>
         *
         * @return The italic.
         */
        @java.lang.Override
        public boolean getItalic() {
          return italic_;
        }

        public static final int UNDERLINED_FIELD_NUMBER = 7;
        private boolean underlined_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is underlined.
         * </pre>
         *
         * <code>bool underlined = 7;</code>
         *
         * @return The underlined.
         */
        @java.lang.Override
        public boolean getUnderlined() {
          return underlined_;
        }

        public static final int STRIKEOUT_FIELD_NUMBER = 8;
        private boolean strikeout_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is strikethrough. This feature is not supported yet.
         * </pre>
         *
         * <code>bool strikeout = 8;</code>
         *
         * @return The strikeout.
         */
        @java.lang.Override
        public boolean getStrikeout() {
          return strikeout_;
        }

        public static final int SUBSCRIPT_FIELD_NUMBER = 9;
        private boolean subscript_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is a subscript. This feature is not supported yet.
         * </pre>
         *
         * <code>bool subscript = 9;</code>
         *
         * @return The subscript.
         */
        @java.lang.Override
        public boolean getSubscript() {
          return subscript_;
        }

        public static final int SUPERSCRIPT_FIELD_NUMBER = 10;
        private boolean superscript_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is a superscript. This feature is not supported yet.
         * </pre>
         *
         * <code>bool superscript = 10;</code>
         *
         * @return The superscript.
         */
        @java.lang.Override
        public boolean getSuperscript() {
          return superscript_;
        }

        public static final int SMALLCAPS_FIELD_NUMBER = 11;
        private boolean smallcaps_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is in small caps. This feature is not supported yet.
         * </pre>
         *
         * <code>bool smallcaps = 11;</code>
         *
         * @return The smallcaps.
         */
        @java.lang.Override
        public boolean getSmallcaps() {
          return smallcaps_;
        }

        public static final int FONT_WEIGHT_FIELD_NUMBER = 12;
        private int fontWeight_ = 0;
        /**
         *
         *
         * <pre>
         * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
         * Normal is `400`, bold is `700`.
         * </pre>
         *
         * <code>int32 font_weight = 12;</code>
         *
         * @return The fontWeight.
         */
        @java.lang.Override
        public int getFontWeight() {
          return fontWeight_;
        }

        public static final int HANDWRITTEN_FIELD_NUMBER = 13;
        private boolean handwritten_ = false;
        /**
         *
         *
         * <pre>
         * Whether the text is handwritten.
         * </pre>
         *
         * <code>bool handwritten = 13;</code>
         *
         * @return The handwritten.
         */
        @java.lang.Override
        public boolean getHandwritten() {
          return handwritten_;
        }

        public static final int TEXT_COLOR_FIELD_NUMBER = 14;
        private com.google.type.Color textColor_;
        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         *
         * @return Whether the textColor field is set.
         */
        @java.lang.Override
        public boolean hasTextColor() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         *
         * @return The textColor.
         */
        @java.lang.Override
        public com.google.type.Color getTextColor() {
          return textColor_ == null ? com.google.type.Color.getDefaultInstance() : textColor_;
        }
        /**
         *
         *
         * <pre>
         * Color of the text.
         * </pre>
         *
         * <code>.google.type.Color text_color = 14;</code>
         */
        @java.lang.Override
        public com.google.type.ColorOrBuilder getTextColorOrBuilder() {
          return textColor_ == null ? com.google.type.Color.getDefaultInstance() : textColor_;
        }

        public static final int BACKGROUND_COLOR_FIELD_NUMBER = 15;
        private com.google.type.Color backgroundColor_;
        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         *
         * @return Whether the backgroundColor field is set.
         */
        @java.lang.Override
        public boolean hasBackgroundColor() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         *
         * @return The backgroundColor.
         */
        @java.lang.Override
        public com.google.type.Color getBackgroundColor() {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        }
        /**
         *
         *
         * <pre>
         * Color of the background.
         * </pre>
         *
         * <code>.google.type.Color background_color = 15;</code>
         */
        @java.lang.Override
        public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
          return backgroundColor_ == null
              ? com.google.type.Color.getDefaultInstance()
              : backgroundColor_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (fontSize_ != 0) {
            output.writeInt32(1, fontSize_);
          }
          if (java.lang.Double.doubleToRawLongBits(pixelFontSize_) != 0) {
            output.writeDouble(2, pixelFontSize_);
          }
          if (java.lang.Double.doubleToRawLongBits(letterSpacing_) != 0) {
            output.writeDouble(3, letterSpacing_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontType_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fontType_);
          }
          if (bold_ != false) {
            output.writeBool(5, bold_);
          }
          if (italic_ != false) {
            output.writeBool(6, italic_);
          }
          if (underlined_ != false) {
            output.writeBool(7, underlined_);
          }
          if (strikeout_ != false) {
            output.writeBool(8, strikeout_);
          }
          if (subscript_ != false) {
            output.writeBool(9, subscript_);
          }
          if (superscript_ != false) {
            output.writeBool(10, superscript_);
          }
          if (smallcaps_ != false) {
            output.writeBool(11, smallcaps_);
          }
          if (fontWeight_ != 0) {
            output.writeInt32(12, fontWeight_);
          }
          if (handwritten_ != false) {
            output.writeBool(13, handwritten_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(14, getTextColor());
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeMessage(15, getBackgroundColor());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (fontSize_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, fontSize_);
          }
          if (java.lang.Double.doubleToRawLongBits(pixelFontSize_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, pixelFontSize_);
          }
          if (java.lang.Double.doubleToRawLongBits(letterSpacing_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, letterSpacing_);
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fontType_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fontType_);
          }
          if (bold_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, bold_);
          }
          if (italic_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, italic_);
          }
          if (underlined_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, underlined_);
          }
          if (strikeout_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, strikeout_);
          }
          if (subscript_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, subscript_);
          }
          if (superscript_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, superscript_);
          }
          if (smallcaps_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, smallcaps_);
          }
          if (fontWeight_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, fontWeight_);
          }
          if (handwritten_ != false) {
            size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, handwritten_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getTextColor());
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(15, getBackgroundColor());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo other =
              (com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo) obj;

          if (getFontSize() != other.getFontSize()) return false;
          if (java.lang.Double.doubleToLongBits(getPixelFontSize())
              != java.lang.Double.doubleToLongBits(other.getPixelFontSize())) return false;
          if (java.lang.Double.doubleToLongBits(getLetterSpacing())
              != java.lang.Double.doubleToLongBits(other.getLetterSpacing())) return false;
          if (!getFontType().equals(other.getFontType())) return false;
          if (getBold() != other.getBold()) return false;
          if (getItalic() != other.getItalic()) return false;
          if (getUnderlined() != other.getUnderlined()) return false;
          if (getStrikeout() != other.getStrikeout()) return false;
          if (getSubscript() != other.getSubscript()) return false;
          if (getSuperscript() != other.getSuperscript()) return false;
          if (getSmallcaps() != other.getSmallcaps()) return false;
          if (getFontWeight() != other.getFontWeight()) return false;
          if (getHandwritten() != other.getHandwritten()) return false;
          if (hasTextColor() != other.hasTextColor()) return false;
          if (hasTextColor()) {
            if (!getTextColor().equals(other.getTextColor())) return false;
          }
          if (hasBackgroundColor() != other.hasBackgroundColor()) return false;
          if (hasBackgroundColor()) {
            if (!getBackgroundColor().equals(other.getBackgroundColor())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + FONT_SIZE_FIELD_NUMBER;
          hash = (53 * hash) + getFontSize();
          hash = (37 * hash) + PIXEL_FONT_SIZE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getPixelFontSize()));
          hash = (37 * hash) + LETTER_SPACING_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getLetterSpacing()));
          hash = (37 * hash) + FONT_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getFontType().hashCode();
          hash = (37 * hash) + BOLD_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBold());
          hash = (37 * hash) + ITALIC_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getItalic());
          hash = (37 * hash) + UNDERLINED_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnderlined());
          hash = (37 * hash) + STRIKEOUT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStrikeout());
          hash = (37 * hash) + SUBSCRIPT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSubscript());
          hash = (37 * hash) + SUPERSCRIPT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuperscript());
          hash = (37 * hash) + SMALLCAPS_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSmallcaps());
          hash = (37 * hash) + FONT_WEIGHT_FIELD_NUMBER;
          hash = (53 * hash) + getFontWeight();
          hash = (37 * hash) + HANDWRITTEN_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHandwritten());
          if (hasTextColor()) {
            hash = (37 * hash) + TEXT_COLOR_FIELD_NUMBER;
            hash = (53 * hash) + getTextColor().hashCode();
          }
          if (hasBackgroundColor()) {
            hash = (37 * hash) + BACKGROUND_COLOR_FIELD_NUMBER;
            hash = (53 * hash) + getBackgroundColor().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Font and other text style attributes.
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_StyleInfo_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_StyleInfo_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.class,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getTextColorFieldBuilder();
              getBackgroundColorFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            fontSize_ = 0;
            pixelFontSize_ = 0D;
            letterSpacing_ = 0D;
            fontType_ = "";
            bold_ = false;
            italic_ = false;
            underlined_ = false;
            strikeout_ = false;
            subscript_ = false;
            superscript_ = false;
            smallcaps_ = false;
            fontWeight_ = 0;
            handwritten_ = false;
            textColor_ = null;
            if (textColorBuilder_ != null) {
              textColorBuilder_.dispose();
              textColorBuilder_ = null;
            }
            backgroundColor_ = null;
            if (backgroundColorBuilder_ != null) {
              backgroundColorBuilder_.dispose();
              backgroundColorBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_StyleInfo_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo build() {
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo buildPartial() {
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo result =
                new com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.fontSize_ = fontSize_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.pixelFontSize_ = pixelFontSize_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.letterSpacing_ = letterSpacing_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.fontType_ = fontType_;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.bold_ = bold_;
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.italic_ = italic_;
            }
            if (((from_bitField0_ & 0x00000040) != 0)) {
              result.underlined_ = underlined_;
            }
            if (((from_bitField0_ & 0x00000080) != 0)) {
              result.strikeout_ = strikeout_;
            }
            if (((from_bitField0_ & 0x00000100) != 0)) {
              result.subscript_ = subscript_;
            }
            if (((from_bitField0_ & 0x00000200) != 0)) {
              result.superscript_ = superscript_;
            }
            if (((from_bitField0_ & 0x00000400) != 0)) {
              result.smallcaps_ = smallcaps_;
            }
            if (((from_bitField0_ & 0x00000800) != 0)) {
              result.fontWeight_ = fontWeight_;
            }
            if (((from_bitField0_ & 0x00001000) != 0)) {
              result.handwritten_ = handwritten_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00002000) != 0)) {
              result.textColor_ =
                  textColorBuilder_ == null ? textColor_ : textColorBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00004000) != 0)) {
              result.backgroundColor_ =
                  backgroundColorBuilder_ == null
                      ? backgroundColor_
                      : backgroundColorBuilder_.build();
              to_bitField0_ |= 0x00000002;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo other) {
            if (other
                == com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
                    .getDefaultInstance()) return this;
            if (other.getFontSize() != 0) {
              setFontSize(other.getFontSize());
            }
            if (other.getPixelFontSize() != 0D) {
              setPixelFontSize(other.getPixelFontSize());
            }
            if (other.getLetterSpacing() != 0D) {
              setLetterSpacing(other.getLetterSpacing());
            }
            if (!other.getFontType().isEmpty()) {
              fontType_ = other.fontType_;
              bitField0_ |= 0x00000008;
              onChanged();
            }
            if (other.getBold() != false) {
              setBold(other.getBold());
            }
            if (other.getItalic() != false) {
              setItalic(other.getItalic());
            }
            if (other.getUnderlined() != false) {
              setUnderlined(other.getUnderlined());
            }
            if (other.getStrikeout() != false) {
              setStrikeout(other.getStrikeout());
            }
            if (other.getSubscript() != false) {
              setSubscript(other.getSubscript());
            }
            if (other.getSuperscript() != false) {
              setSuperscript(other.getSuperscript());
            }
            if (other.getSmallcaps() != false) {
              setSmallcaps(other.getSmallcaps());
            }
            if (other.getFontWeight() != 0) {
              setFontWeight(other.getFontWeight());
            }
            if (other.getHandwritten() != false) {
              setHandwritten(other.getHandwritten());
            }
            if (other.hasTextColor()) {
              mergeTextColor(other.getTextColor());
            }
            if (other.hasBackgroundColor()) {
              mergeBackgroundColor(other.getBackgroundColor());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      fontSize_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 17:
                    {
                      pixelFontSize_ = input.readDouble();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 17
                  case 25:
                    {
                      letterSpacing_ = input.readDouble();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 25
                  case 34:
                    {
                      fontType_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 34
                  case 40:
                    {
                      bold_ = input.readBool();
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 40
                  case 48:
                    {
                      italic_ = input.readBool();
                      bitField0_ |= 0x00000020;
                      break;
                    } // case 48
                  case 56:
                    {
                      underlined_ = input.readBool();
                      bitField0_ |= 0x00000040;
                      break;
                    } // case 56
                  case 64:
                    {
                      strikeout_ = input.readBool();
                      bitField0_ |= 0x00000080;
                      break;
                    } // case 64
                  case 72:
                    {
                      subscript_ = input.readBool();
                      bitField0_ |= 0x00000100;
                      break;
                    } // case 72
                  case 80:
                    {
                      superscript_ = input.readBool();
                      bitField0_ |= 0x00000200;
                      break;
                    } // case 80
                  case 88:
                    {
                      smallcaps_ = input.readBool();
                      bitField0_ |= 0x00000400;
                      break;
                    } // case 88
                  case 96:
                    {
                      fontWeight_ = input.readInt32();
                      bitField0_ |= 0x00000800;
                      break;
                    } // case 96
                  case 104:
                    {
                      handwritten_ = input.readBool();
                      bitField0_ |= 0x00001000;
                      break;
                    } // case 104
                  case 114:
                    {
                      input.readMessage(getTextColorFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00002000;
                      break;
                    } // case 114
                  case 122:
                    {
                      input.readMessage(
                          getBackgroundColorFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00004000;
                      break;
                    } // case 122
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int fontSize_;
          /**
           *
           *
           * <pre>
           * Font size in points (`1` point is `¹⁄₇₂` inches).
           * </pre>
           *
           * <code>int32 font_size = 1;</code>
           *
           * @return The fontSize.
           */
          @java.lang.Override
          public int getFontSize() {
            return fontSize_;
          }
          /**
           *
           *
           * <pre>
           * Font size in points (`1` point is `¹⁄₇₂` inches).
           * </pre>
           *
           * <code>int32 font_size = 1;</code>
           *
           * @param value The fontSize to set.
           * @return This builder for chaining.
           */
          public Builder setFontSize(int value) {

            fontSize_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Font size in points (`1` point is `¹⁄₇₂` inches).
           * </pre>
           *
           * <code>int32 font_size = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFontSize() {
            bitField0_ = (bitField0_ & ~0x00000001);
            fontSize_ = 0;
            onChanged();
            return this;
          }

          private double pixelFontSize_;
          /**
           *
           *
           * <pre>
           * Font size in pixels, equal to _unrounded
           * [font_size][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_size]_
           * * _resolution_ ÷ `72.0`.
           * </pre>
           *
           * <code>double pixel_font_size = 2;</code>
           *
           * @return The pixelFontSize.
           */
          @java.lang.Override
          public double getPixelFontSize() {
            return pixelFontSize_;
          }
          /**
           *
           *
           * <pre>
           * Font size in pixels, equal to _unrounded
           * [font_size][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_size]_
           * * _resolution_ ÷ `72.0`.
           * </pre>
           *
           * <code>double pixel_font_size = 2;</code>
           *
           * @param value The pixelFontSize to set.
           * @return This builder for chaining.
           */
          public Builder setPixelFontSize(double value) {

            pixelFontSize_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Font size in pixels, equal to _unrounded
           * [font_size][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_size]_
           * * _resolution_ ÷ `72.0`.
           * </pre>
           *
           * <code>double pixel_font_size = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPixelFontSize() {
            bitField0_ = (bitField0_ & ~0x00000002);
            pixelFontSize_ = 0D;
            onChanged();
            return this;
          }

          private double letterSpacing_;
          /**
           *
           *
           * <pre>
           * Letter spacing in points.
           * </pre>
           *
           * <code>double letter_spacing = 3;</code>
           *
           * @return The letterSpacing.
           */
          @java.lang.Override
          public double getLetterSpacing() {
            return letterSpacing_;
          }
          /**
           *
           *
           * <pre>
           * Letter spacing in points.
           * </pre>
           *
           * <code>double letter_spacing = 3;</code>
           *
           * @param value The letterSpacing to set.
           * @return This builder for chaining.
           */
          public Builder setLetterSpacing(double value) {

            letterSpacing_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Letter spacing in points.
           * </pre>
           *
           * <code>double letter_spacing = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearLetterSpacing() {
            bitField0_ = (bitField0_ & ~0x00000004);
            letterSpacing_ = 0D;
            onChanged();
            return this;
          }

          private java.lang.Object fontType_ = "";
          /**
           *
           *
           * <pre>
           * Name or style of the font.
           * </pre>
           *
           * <code>string font_type = 4;</code>
           *
           * @return The fontType.
           */
          public java.lang.String getFontType() {
            java.lang.Object ref = fontType_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              fontType_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name or style of the font.
           * </pre>
           *
           * <code>string font_type = 4;</code>
           *
           * @return The bytes for fontType.
           */
          public com.google.protobuf.ByteString getFontTypeBytes() {
            java.lang.Object ref = fontType_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              fontType_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Name or style of the font.
           * </pre>
           *
           * <code>string font_type = 4;</code>
           *
           * @param value The fontType to set.
           * @return This builder for chaining.
           */
          public Builder setFontType(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            fontType_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name or style of the font.
           * </pre>
           *
           * <code>string font_type = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFontType() {
            fontType_ = getDefaultInstance().getFontType();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Name or style of the font.
           * </pre>
           *
           * <code>string font_type = 4;</code>
           *
           * @param value The bytes for fontType to set.
           * @return This builder for chaining.
           */
          public Builder setFontTypeBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            fontType_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }

          private boolean bold_;
          /**
           *
           *
           * <pre>
           * Whether the text is bold (equivalent to
           * [font_weight][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_weight]
           * is at least `700`).
           * </pre>
           *
           * <code>bool bold = 5;</code>
           *
           * @return The bold.
           */
          @java.lang.Override
          public boolean getBold() {
            return bold_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is bold (equivalent to
           * [font_weight][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_weight]
           * is at least `700`).
           * </pre>
           *
           * <code>bool bold = 5;</code>
           *
           * @param value The bold to set.
           * @return This builder for chaining.
           */
          public Builder setBold(boolean value) {

            bold_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is bold (equivalent to
           * [font_weight][google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.font_weight]
           * is at least `700`).
           * </pre>
           *
           * <code>bool bold = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearBold() {
            bitField0_ = (bitField0_ & ~0x00000010);
            bold_ = false;
            onChanged();
            return this;
          }

          private boolean italic_;
          /**
           *
           *
           * <pre>
           * Whether the text is italic.
           * </pre>
           *
           * <code>bool italic = 6;</code>
           *
           * @return The italic.
           */
          @java.lang.Override
          public boolean getItalic() {
            return italic_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is italic.
           * </pre>
           *
           * <code>bool italic = 6;</code>
           *
           * @param value The italic to set.
           * @return This builder for chaining.
           */
          public Builder setItalic(boolean value) {

            italic_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is italic.
           * </pre>
           *
           * <code>bool italic = 6;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearItalic() {
            bitField0_ = (bitField0_ & ~0x00000020);
            italic_ = false;
            onChanged();
            return this;
          }

          private boolean underlined_;
          /**
           *
           *
           * <pre>
           * Whether the text is underlined.
           * </pre>
           *
           * <code>bool underlined = 7;</code>
           *
           * @return The underlined.
           */
          @java.lang.Override
          public boolean getUnderlined() {
            return underlined_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is underlined.
           * </pre>
           *
           * <code>bool underlined = 7;</code>
           *
           * @param value The underlined to set.
           * @return This builder for chaining.
           */
          public Builder setUnderlined(boolean value) {

            underlined_ = value;
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is underlined.
           * </pre>
           *
           * <code>bool underlined = 7;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearUnderlined() {
            bitField0_ = (bitField0_ & ~0x00000040);
            underlined_ = false;
            onChanged();
            return this;
          }

          private boolean strikeout_;
          /**
           *
           *
           * <pre>
           * Whether the text is strikethrough. This feature is not supported yet.
           * </pre>
           *
           * <code>bool strikeout = 8;</code>
           *
           * @return The strikeout.
           */
          @java.lang.Override
          public boolean getStrikeout() {
            return strikeout_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is strikethrough. This feature is not supported yet.
           * </pre>
           *
           * <code>bool strikeout = 8;</code>
           *
           * @param value The strikeout to set.
           * @return This builder for chaining.
           */
          public Builder setStrikeout(boolean value) {

            strikeout_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is strikethrough. This feature is not supported yet.
           * </pre>
           *
           * <code>bool strikeout = 8;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearStrikeout() {
            bitField0_ = (bitField0_ & ~0x00000080);
            strikeout_ = false;
            onChanged();
            return this;
          }

          private boolean subscript_;
          /**
           *
           *
           * <pre>
           * Whether the text is a subscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool subscript = 9;</code>
           *
           * @return The subscript.
           */
          @java.lang.Override
          public boolean getSubscript() {
            return subscript_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is a subscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool subscript = 9;</code>
           *
           * @param value The subscript to set.
           * @return This builder for chaining.
           */
          public Builder setSubscript(boolean value) {

            subscript_ = value;
            bitField0_ |= 0x00000100;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is a subscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool subscript = 9;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSubscript() {
            bitField0_ = (bitField0_ & ~0x00000100);
            subscript_ = false;
            onChanged();
            return this;
          }

          private boolean superscript_;
          /**
           *
           *
           * <pre>
           * Whether the text is a superscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool superscript = 10;</code>
           *
           * @return The superscript.
           */
          @java.lang.Override
          public boolean getSuperscript() {
            return superscript_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is a superscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool superscript = 10;</code>
           *
           * @param value The superscript to set.
           * @return This builder for chaining.
           */
          public Builder setSuperscript(boolean value) {

            superscript_ = value;
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is a superscript. This feature is not supported yet.
           * </pre>
           *
           * <code>bool superscript = 10;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSuperscript() {
            bitField0_ = (bitField0_ & ~0x00000200);
            superscript_ = false;
            onChanged();
            return this;
          }

          private boolean smallcaps_;
          /**
           *
           *
           * <pre>
           * Whether the text is in small caps. This feature is not supported yet.
           * </pre>
           *
           * <code>bool smallcaps = 11;</code>
           *
           * @return The smallcaps.
           */
          @java.lang.Override
          public boolean getSmallcaps() {
            return smallcaps_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is in small caps. This feature is not supported yet.
           * </pre>
           *
           * <code>bool smallcaps = 11;</code>
           *
           * @param value The smallcaps to set.
           * @return This builder for chaining.
           */
          public Builder setSmallcaps(boolean value) {

            smallcaps_ = value;
            bitField0_ |= 0x00000400;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is in small caps. This feature is not supported yet.
           * </pre>
           *
           * <code>bool smallcaps = 11;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSmallcaps() {
            bitField0_ = (bitField0_ & ~0x00000400);
            smallcaps_ = false;
            onChanged();
            return this;
          }

          private int fontWeight_;
          /**
           *
           *
           * <pre>
           * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
           * Normal is `400`, bold is `700`.
           * </pre>
           *
           * <code>int32 font_weight = 12;</code>
           *
           * @return The fontWeight.
           */
          @java.lang.Override
          public int getFontWeight() {
            return fontWeight_;
          }
          /**
           *
           *
           * <pre>
           * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
           * Normal is `400`, bold is `700`.
           * </pre>
           *
           * <code>int32 font_weight = 12;</code>
           *
           * @param value The fontWeight to set.
           * @return This builder for chaining.
           */
          public Builder setFontWeight(int value) {

            fontWeight_ = value;
            bitField0_ |= 0x00000800;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
           * Normal is `400`, bold is `700`.
           * </pre>
           *
           * <code>int32 font_weight = 12;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearFontWeight() {
            bitField0_ = (bitField0_ & ~0x00000800);
            fontWeight_ = 0;
            onChanged();
            return this;
          }

          private boolean handwritten_;
          /**
           *
           *
           * <pre>
           * Whether the text is handwritten.
           * </pre>
           *
           * <code>bool handwritten = 13;</code>
           *
           * @return The handwritten.
           */
          @java.lang.Override
          public boolean getHandwritten() {
            return handwritten_;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is handwritten.
           * </pre>
           *
           * <code>bool handwritten = 13;</code>
           *
           * @param value The handwritten to set.
           * @return This builder for chaining.
           */
          public Builder setHandwritten(boolean value) {

            handwritten_ = value;
            bitField0_ |= 0x00001000;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the text is handwritten.
           * </pre>
           *
           * <code>bool handwritten = 13;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearHandwritten() {
            bitField0_ = (bitField0_ & ~0x00001000);
            handwritten_ = false;
            onChanged();
            return this;
          }

          private com.google.type.Color textColor_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>
              textColorBuilder_;
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           *
           * @return Whether the textColor field is set.
           */
          public boolean hasTextColor() {
            return ((bitField0_ & 0x00002000) != 0);
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           *
           * @return The textColor.
           */
          public com.google.type.Color getTextColor() {
            if (textColorBuilder_ == null) {
              return textColor_ == null ? com.google.type.Color.getDefaultInstance() : textColor_;
            } else {
              return textColorBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public Builder setTextColor(com.google.type.Color value) {
            if (textColorBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              textColor_ = value;
            } else {
              textColorBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00002000;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public Builder setTextColor(com.google.type.Color.Builder builderForValue) {
            if (textColorBuilder_ == null) {
              textColor_ = builderForValue.build();
            } else {
              textColorBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00002000;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public Builder mergeTextColor(com.google.type.Color value) {
            if (textColorBuilder_ == null) {
              if (((bitField0_ & 0x00002000) != 0)
                  && textColor_ != null
                  && textColor_ != com.google.type.Color.getDefaultInstance()) {
                getTextColorBuilder().mergeFrom(value);
              } else {
                textColor_ = value;
              }
            } else {
              textColorBuilder_.mergeFrom(value);
            }
            if (textColor_ != null) {
              bitField0_ |= 0x00002000;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public Builder clearTextColor() {
            bitField0_ = (bitField0_ & ~0x00002000);
            textColor_ = null;
            if (textColorBuilder_ != null) {
              textColorBuilder_.dispose();
              textColorBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public com.google.type.Color.Builder getTextColorBuilder() {
            bitField0_ |= 0x00002000;
            onChanged();
            return getTextColorFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          public com.google.type.ColorOrBuilder getTextColorOrBuilder() {
            if (textColorBuilder_ != null) {
              return textColorBuilder_.getMessageOrBuilder();
            } else {
              return textColor_ == null ? com.google.type.Color.getDefaultInstance() : textColor_;
            }
          }
          /**
           *
           *
           * <pre>
           * Color of the text.
           * </pre>
           *
           * <code>.google.type.Color text_color = 14;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>
              getTextColorFieldBuilder() {
            if (textColorBuilder_ == null) {
              textColorBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Color,
                      com.google.type.Color.Builder,
                      com.google.type.ColorOrBuilder>(
                      getTextColor(), getParentForChildren(), isClean());
              textColor_ = null;
            }
            return textColorBuilder_;
          }

          private com.google.type.Color backgroundColor_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>
              backgroundColorBuilder_;
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           *
           * @return Whether the backgroundColor field is set.
           */
          public boolean hasBackgroundColor() {
            return ((bitField0_ & 0x00004000) != 0);
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           *
           * @return The backgroundColor.
           */
          public com.google.type.Color getBackgroundColor() {
            if (backgroundColorBuilder_ == null) {
              return backgroundColor_ == null
                  ? com.google.type.Color.getDefaultInstance()
                  : backgroundColor_;
            } else {
              return backgroundColorBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public Builder setBackgroundColor(com.google.type.Color value) {
            if (backgroundColorBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              backgroundColor_ = value;
            } else {
              backgroundColorBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00004000;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public Builder setBackgroundColor(com.google.type.Color.Builder builderForValue) {
            if (backgroundColorBuilder_ == null) {
              backgroundColor_ = builderForValue.build();
            } else {
              backgroundColorBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00004000;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public Builder mergeBackgroundColor(com.google.type.Color value) {
            if (backgroundColorBuilder_ == null) {
              if (((bitField0_ & 0x00004000) != 0)
                  && backgroundColor_ != null
                  && backgroundColor_ != com.google.type.Color.getDefaultInstance()) {
                getBackgroundColorBuilder().mergeFrom(value);
              } else {
                backgroundColor_ = value;
              }
            } else {
              backgroundColorBuilder_.mergeFrom(value);
            }
            if (backgroundColor_ != null) {
              bitField0_ |= 0x00004000;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public Builder clearBackgroundColor() {
            bitField0_ = (bitField0_ & ~0x00004000);
            backgroundColor_ = null;
            if (backgroundColorBuilder_ != null) {
              backgroundColorBuilder_.dispose();
              backgroundColorBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public com.google.type.Color.Builder getBackgroundColorBuilder() {
            bitField0_ |= 0x00004000;
            onChanged();
            return getBackgroundColorFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          public com.google.type.ColorOrBuilder getBackgroundColorOrBuilder() {
            if (backgroundColorBuilder_ != null) {
              return backgroundColorBuilder_.getMessageOrBuilder();
            } else {
              return backgroundColor_ == null
                  ? com.google.type.Color.getDefaultInstance()
                  : backgroundColor_;
            }
          }
          /**
           *
           *
           * <pre>
           * Color of the background.
           * </pre>
           *
           * <code>.google.type.Color background_color = 15;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Color,
                  com.google.type.Color.Builder,
                  com.google.type.ColorOrBuilder>
              getBackgroundColorFieldBuilder() {
            if (backgroundColorBuilder_ == null) {
              backgroundColorBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.type.Color,
                      com.google.type.Color.Builder,
                      com.google.type.ColorOrBuilder>(
                      getBackgroundColor(), getParentForChildren(), isClean());
              backgroundColor_ = null;
            }
            return backgroundColorBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo)
        private static final com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo();
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<StyleInfo> PARSER =
            new com.google.protobuf.AbstractParser<StyleInfo>() {
              @java.lang.Override
              public StyleInfo parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<StyleInfo> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<StyleInfo> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_BREAK_FIELD_NUMBER = 2;
      private com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detectedBreak_;
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return Whether the detectedBreak field is set.
       */
      @java.lang.Override
      public boolean hasDetectedBreak() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       *
       * @return The detectedBreak.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
          getDetectedBreak() {
        return detectedBreak_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                .getDefaultInstance()
            : detectedBreak_;
      }
      /**
       *
       *
       * <pre>
       * Detected break at the end of a
       * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder
          getDetectedBreakOrBuilder() {
        return detectedBreak_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                .getDefaultInstance()
            : detectedBreak_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      public static final int PROVENANCE_FIELD_NUMBER = 4;
      private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=326
       * @return Whether the provenance field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasProvenance() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=326
       * @return The provenance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }
      /**
       *
       *
       * <pre>
       * The history of this annotation.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
          getProvenanceOrBuilder() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }

      public static final int STYLE_INFO_FIELD_NUMBER = 5;
      private com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo styleInfo_;
      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       *
       * @return Whether the styleInfo field is set.
       */
      @java.lang.Override
      public boolean hasStyleInfo() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       *
       * @return The styleInfo.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo getStyleInfo() {
        return styleInfo_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.getDefaultInstance()
            : styleInfo_;
      }
      /**
       *
       *
       * <pre>
       * Text style attributes.
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder
          getStyleInfoOrBuilder() {
        return styleInfo_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.getDefaultInstance()
            : styleInfo_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getDetectedBreak());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(3, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(4, getProvenance());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeMessage(5, getStyleInfo());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDetectedBreak());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProvenance());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStyleInfo());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Token other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Token) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (hasDetectedBreak() != other.hasDetectedBreak()) return false;
        if (hasDetectedBreak()) {
          if (!getDetectedBreak().equals(other.getDetectedBreak())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (hasProvenance() != other.hasProvenance()) return false;
        if (hasProvenance()) {
          if (!getProvenance().equals(other.getProvenance())) return false;
        }
        if (hasStyleInfo() != other.hasStyleInfo()) return false;
        if (hasStyleInfo()) {
          if (!getStyleInfo().equals(other.getStyleInfo())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (hasDetectedBreak()) {
          hash = (37 * hash) + DETECTED_BREAK_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedBreak().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        if (hasProvenance()) {
          hash = (37 * hash) + PROVENANCE_FIELD_NUMBER;
          hash = (53 * hash) + getProvenance().hashCode();
        }
        if (hasStyleInfo()) {
          hash = (37 * hash) + STYLE_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getStyleInfo().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Token prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A detected token.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Token}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Token)
          com.google.cloud.documentai.v1beta3.Document.Page.TokenOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Token.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Token.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedBreakFieldBuilder();
            getDetectedLanguagesFieldBuilder();
            getProvenanceFieldBuilder();
            getStyleInfoFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          detectedBreak_ = null;
          if (detectedBreakBuilder_ != null) {
            detectedBreakBuilder_.dispose();
            detectedBreakBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          styleInfo_ = null;
          if (styleInfoBuilder_ != null) {
            styleInfoBuilder_.dispose();
            styleInfoBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Token_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Token.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Token result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Token buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Token result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Token(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Token result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Page.Token result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.detectedBreak_ =
                detectedBreakBuilder_ == null ? detectedBreak_ : detectedBreakBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.provenance_ =
                provenanceBuilder_ == null ? provenance_ : provenanceBuilder_.build();
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.styleInfo_ = styleInfoBuilder_ == null ? styleInfo_ : styleInfoBuilder_.build();
            to_bitField0_ |= 0x00000008;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Token) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Token) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Token other) {
          if (other == com.google.cloud.documentai.v1beta3.Document.Page.Token.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (other.hasDetectedBreak()) {
            mergeDetectedBreak(other.getDetectedBreak());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          if (other.hasProvenance()) {
            mergeProvenance(other.getProvenance());
          }
          if (other.hasStyleInfo()) {
            mergeStyleInfo(other.getStyleInfo());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getDetectedBreakFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(getProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(getStyleInfoFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            detectedBreak_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder>
            detectedBreakBuilder_;
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         *
         * @return Whether the detectedBreak field is set.
         */
        public boolean hasDetectedBreak() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         *
         * @return The detectedBreak.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
            getDetectedBreak() {
          if (detectedBreakBuilder_ == null) {
            return detectedBreak_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()
                : detectedBreak_;
          } else {
            return detectedBreakBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder setDetectedBreak(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak value) {
          if (detectedBreakBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            detectedBreak_ = value;
          } else {
            detectedBreakBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder setDetectedBreak(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder
                builderForValue) {
          if (detectedBreakBuilder_ == null) {
            detectedBreak_ = builderForValue.build();
          } else {
            detectedBreakBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder mergeDetectedBreak(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak value) {
          if (detectedBreakBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && detectedBreak_ != null
                && detectedBreak_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                        .getDefaultInstance()) {
              getDetectedBreakBuilder().mergeFrom(value);
            } else {
              detectedBreak_ = value;
            }
          } else {
            detectedBreakBuilder_.mergeFrom(value);
          }
          if (detectedBreak_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public Builder clearDetectedBreak() {
          bitField0_ = (bitField0_ & ~0x00000002);
          detectedBreak_ = null;
          if (detectedBreakBuilder_ != null) {
            detectedBreakBuilder_.dispose();
            detectedBreakBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder
            getDetectedBreakBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getDetectedBreakFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder
            getDetectedBreakOrBuilder() {
          if (detectedBreakBuilder_ != null) {
            return detectedBreakBuilder_.getMessageOrBuilder();
          } else {
            return detectedBreak_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak
                    .getDefaultInstance()
                : detectedBreak_;
          }
        }
        /**
         *
         *
         * <pre>
         * Detected break at the end of a
         * [Token][google.cloud.documentai.v1beta3.Document.Page.Token].
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak detected_break = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder>
            getDetectedBreakFieldBuilder() {
          if (detectedBreakBuilder_ == null) {
            detectedBreakBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreak.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.DetectedBreakOrBuilder>(
                    getDetectedBreak(), getParentForChildren(), isClean());
            detectedBreak_ = null;
          }
          return detectedBreakBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            provenanceBuilder_;
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=326
         * @return Whether the provenance field is set.
         */
        @java.lang.Deprecated
        public boolean hasProvenance() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         *
         * @deprecated google.cloud.documentai.v1beta3.Document.Page.Token.provenance is deprecated.
         *     See google/cloud/documentai/v1beta3/document.proto;l=326
         * @return The provenance.
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
          if (provenanceBuilder_ == null) {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          } else {
            return provenanceBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            provenance_ = value;
          } else {
            provenanceBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder setProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance.Builder builderForValue) {
          if (provenanceBuilder_ == null) {
            provenance_ = builderForValue.build();
          } else {
            provenanceBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder mergeProvenance(
            com.google.cloud.documentai.v1beta3.Document.Provenance value) {
          if (provenanceBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && provenance_ != null
                && provenance_
                    != com.google.cloud.documentai.v1beta3.Document.Provenance
                        .getDefaultInstance()) {
              getProvenanceBuilder().mergeFrom(value);
            } else {
              provenance_ = value;
            }
          } else {
            provenanceBuilder_.mergeFrom(value);
          }
          if (provenance_ != null) {
            bitField0_ |= 0x00000008;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public Builder clearProvenance() {
          bitField0_ = (bitField0_ & ~0x00000008);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.Provenance.Builder
            getProvenanceBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getProvenanceFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        @java.lang.Deprecated
        public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
            getProvenanceOrBuilder() {
          if (provenanceBuilder_ != null) {
            return provenanceBuilder_.getMessageOrBuilder();
          } else {
            return provenance_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
                : provenance_;
          }
        }
        /**
         *
         *
         * <pre>
         * The history of this annotation.
         * </pre>
         *
         * <code>
         * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 4 [deprecated = true];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Provenance,
                com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>
            getProvenanceFieldBuilder() {
          if (provenanceBuilder_ == null) {
            provenanceBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Provenance,
                    com.google.cloud.documentai.v1beta3.Document.Provenance.Builder,
                    com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder>(
                    getProvenance(), getParentForChildren(), isClean());
            provenance_ = null;
          }
          return provenanceBuilder_;
        }

        private com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo styleInfo_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder>
            styleInfoBuilder_;
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         *
         * @return Whether the styleInfo field is set.
         */
        public boolean hasStyleInfo() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         *
         * @return The styleInfo.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo getStyleInfo() {
          if (styleInfoBuilder_ == null) {
            return styleInfo_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
                    .getDefaultInstance()
                : styleInfo_;
          } else {
            return styleInfoBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public Builder setStyleInfo(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo value) {
          if (styleInfoBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            styleInfo_ = value;
          } else {
            styleInfoBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public Builder setStyleInfo(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder
                builderForValue) {
          if (styleInfoBuilder_ == null) {
            styleInfo_ = builderForValue.build();
          } else {
            styleInfoBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public Builder mergeStyleInfo(
            com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo value) {
          if (styleInfoBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)
                && styleInfo_ != null
                && styleInfo_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
                        .getDefaultInstance()) {
              getStyleInfoBuilder().mergeFrom(value);
            } else {
              styleInfo_ = value;
            }
          } else {
            styleInfoBuilder_.mergeFrom(value);
          }
          if (styleInfo_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public Builder clearStyleInfo() {
          bitField0_ = (bitField0_ & ~0x00000010);
          styleInfo_ = null;
          if (styleInfoBuilder_ != null) {
            styleInfoBuilder_.dispose();
            styleInfoBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder
            getStyleInfoBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getStyleInfoFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder
            getStyleInfoOrBuilder() {
          if (styleInfoBuilder_ != null) {
            return styleInfoBuilder_.getMessageOrBuilder();
          } else {
            return styleInfo_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo
                    .getDefaultInstance()
                : styleInfo_;
          }
        }
        /**
         *
         *
         * <pre>
         * Text style attributes.
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo style_info = 5;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder>
            getStyleInfoFieldBuilder() {
          if (styleInfoBuilder_ == null) {
            styleInfoBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfo.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.Token.StyleInfoOrBuilder>(
                    getStyleInfo(), getParentForChildren(), isClean());
            styleInfo_ = null;
          }
          return styleInfoBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Token)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Token)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Token DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Token();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Token getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Token> PARSER =
          new com.google.protobuf.AbstractParser<Token>() {
            @java.lang.Override
            public Token parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Token> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Token> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Token getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SymbolOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Symbol)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A detected symbol.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Symbol}
     */
    public static final class Symbol extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Symbol)
        SymbolOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Symbol.newBuilder() to construct.
      private Symbol(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Symbol() {
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Symbol();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Symbol_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Symbol_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Symbol.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Symbol.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(2, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Symbol)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Symbol other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Symbol) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Symbol prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A detected symbol.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Symbol}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Symbol)
          com.google.cloud.documentai.v1beta3.Document.Page.SymbolOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Symbol_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Symbol_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Symbol.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Symbol.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Symbol.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Symbol_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Symbol
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Symbol.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Symbol build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Symbol result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Symbol buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Symbol result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Symbol(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Symbol result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.Symbol result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Symbol) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Symbol) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Symbol other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.Symbol.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000002);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Symbol][google.cloud.documentai.v1beta3.Document.Page.Symbol].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Symbol)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Symbol)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.Symbol
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Symbol();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Symbol getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Symbol> PARSER =
          new com.google.protobuf.AbstractParser<Symbol>() {
            @java.lang.Override
            public Symbol parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Symbol> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Symbol> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Symbol getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface VisualElementOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.VisualElement)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The type.
       */
      java.lang.String getType();
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The bytes for type.
       */
      com.google.protobuf.ByteString getTypeBytes();

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Detected non-text visual elements e.g. checkbox, signature etc. on the
     * page.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.VisualElement}
     */
    public static final class VisualElement extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.VisualElement)
        VisualElementOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use VisualElement.newBuilder() to construct.
      private VisualElement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private VisualElement() {
        type_ = "";
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new VisualElement();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_VisualElement_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_VisualElement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.VisualElement.class,
                com.google.cloud.documentai.v1beta3.Document.Page.VisualElement.Builder.class);
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int TYPE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the
       * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
       * </pre>
       *
       * <code>string type = 2;</code>
       *
       * @return The bytes for type.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, type_);
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(3, detectedLanguages_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, type_);
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, detectedLanguages_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.VisualElement)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.VisualElement other =
            (com.google.cloud.documentai.v1beta3.Document.Page.VisualElement) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getType().equals(other.getType())) return false;
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.VisualElement prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Detected non-text visual elements e.g. checkbox, signature etc. on the
       * page.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.VisualElement}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.VisualElement)
          com.google.cloud.documentai.v1beta3.Document.Page.VisualElementOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_VisualElement_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_VisualElement_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.VisualElement.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.VisualElement.Builder.class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta3.Document.Page.VisualElement.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getDetectedLanguagesFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          type_ = "";
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_VisualElement_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.VisualElement build() {
          com.google.cloud.documentai.v1beta3.Document.Page.VisualElement result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.VisualElement buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.VisualElement result =
              new com.google.cloud.documentai.v1beta3.Document.Page.VisualElement(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.VisualElement result) {
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.Document.Page.VisualElement result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.type_ = type_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.VisualElement) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta3.Document.Page.VisualElement) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.Document.Page.VisualElement other) {
          if (other
              == com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
                  .getDefaultInstance()) return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (!other.getType().isEmpty()) {
            type_ = other.type_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000004);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    type_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.lang.Object type_ = "";
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return The type.
         */
        public java.lang.String getType() {
          java.lang.Object ref = type_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            type_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return The bytes for type.
         */
        public com.google.protobuf.ByteString getTypeBytes() {
          java.lang.Object ref = type_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            type_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          type_ = getDefaultInstance().getType();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of the
         * [VisualElement][google.cloud.documentai.v1beta3.Document.Page.VisualElement].
         * </pre>
         *
         * <code>string type = 2;</code>
         *
         * @param value The bytes for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          type_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.add(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder addAllDetectedLanguages(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                values) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
            onChanged();
          } else {
            detectedLanguagesBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder clearDetectedLanguages() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            detectedLanguagesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public Builder removeDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.remove(index);
            onChanged();
          } else {
            detectedLanguagesBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            getDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          if (detectedLanguagesBuilder_ != null) {
            return detectedLanguagesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder() {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
            addDetectedLanguagesBuilder(int index) {
          return getDetectedLanguagesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
            getDetectedLanguagesBuilderList() {
          return getDetectedLanguagesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesFieldBuilder() {
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguagesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                    detectedLanguages_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            detectedLanguages_ = null;
          }
          return detectedLanguagesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.VisualElement)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.VisualElement)
      private static final com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.VisualElement();
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VisualElement> PARSER =
          new com.google.protobuf.AbstractParser<VisualElement>() {
            @java.lang.Override
            public VisualElement parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VisualElement> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VisualElement> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.VisualElement
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TableOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Table)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      boolean hasLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          getHeaderRowsList();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getHeaderRows(int index);
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      int getHeaderRowsCount();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
          getHeaderRowsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
          getHeaderRowsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          getBodyRowsList();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getBodyRows(int index);
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      int getBodyRowsCount();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
          getBodyRowsOrBuilderList();
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
          getBodyRowsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
          int index);
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      int getDetectedLanguagesCount();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Table.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=395
       * @return Whether the provenance field is set.
       */
      @java.lang.Deprecated
      boolean hasProvenance();
      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Table.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=395
       * @return The provenance.
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance();
      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Deprecated
      com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder getProvenanceOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A table representation similar to HTML table structure.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table}
     */
    public static final class Table extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Table)
        TableOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Table.newBuilder() to construct.
      private Table(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Table() {
        headerRows_ = java.util.Collections.emptyList();
        bodyRows_ = java.util.Collections.emptyList();
        detectedLanguages_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Table();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentProto
            .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.Document.Page.Table.class,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.Builder.class);
      }

      public interface TableRowOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
            getCellsList();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell getCells(int index);
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        int getCellsCount();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>
            getCellsOrBuilderList();
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder
            getCellsOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * A row of table cells.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table.TableRow}
       */
      public static final class TableRow extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)
          TableRowOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use TableRow.newBuilder() to construct.
        private TableRow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private TableRow() {
          cells_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new TableRow();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableRow_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableRow_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder.class);
        }

        public static final int CELLS_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
            cells_;
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
            getCellsList() {
          return cells_;
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>
            getCellsOrBuilderList() {
          return cells_;
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public int getCellsCount() {
          return cells_.size();
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell getCells(
            int index) {
          return cells_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Cells that make up this row.
         * </pre>
         *
         * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder
            getCellsOrBuilder(int index) {
          return cells_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < cells_.size(); i++) {
            output.writeMessage(1, cells_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          for (int i = 0; i < cells_.size(); i++) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, cells_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow other =
              (com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow) obj;

          if (!getCellsList().equals(other.getCellsList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getCellsCount() > 0) {
            hash = (37 * hash) + CELLS_FIELD_NUMBER;
            hash = (53 * hash) + getCellsList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A row of table cells.
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table.TableRow}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableRow_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableRow_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.class,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder.class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            if (cellsBuilder_ == null) {
              cells_ = java.util.Collections.emptyList();
            } else {
              cells_ = null;
              cellsBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableRow_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow build() {
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow buildPartial() {
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow result =
                new com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow result) {
            if (cellsBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)) {
                cells_ = java.util.Collections.unmodifiableList(cells_);
                bitField0_ = (bitField0_ & ~0x00000001);
              }
              result.cells_ = cells_;
            } else {
              result.cells_ = cellsBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow other) {
            if (other
                == com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                    .getDefaultInstance()) return this;
            if (cellsBuilder_ == null) {
              if (!other.cells_.isEmpty()) {
                if (cells_.isEmpty()) {
                  cells_ = other.cells_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                  ensureCellsIsMutable();
                  cells_.addAll(other.cells_);
                }
                onChanged();
              }
            } else {
              if (!other.cells_.isEmpty()) {
                if (cellsBuilder_.isEmpty()) {
                  cellsBuilder_.dispose();
                  cellsBuilder_ = null;
                  cells_ = other.cells_;
                  bitField0_ = (bitField0_ & ~0x00000001);
                  cellsBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getCellsFieldBuilder()
                          : null;
                } else {
                  cellsBuilder_.addAllMessages(other.cells_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell m =
                          input.readMessage(
                              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
                                  .parser(),
                              extensionRegistry);
                      if (cellsBuilder_ == null) {
                        ensureCellsIsMutable();
                        cells_.add(m);
                      } else {
                        cellsBuilder_.addMessage(m);
                      }
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
              cells_ = java.util.Collections.emptyList();

          private void ensureCellsIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              cells_ =
                  new java.util.ArrayList<
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>(cells_);
              bitField0_ |= 0x00000001;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>
              cellsBuilder_;

          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
              getCellsList() {
            if (cellsBuilder_ == null) {
              return java.util.Collections.unmodifiableList(cells_);
            } else {
              return cellsBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public int getCellsCount() {
            if (cellsBuilder_ == null) {
              return cells_.size();
            } else {
              return cellsBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell getCells(
              int index) {
            if (cellsBuilder_ == null) {
              return cells_.get(index);
            } else {
              return cellsBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder setCells(
              int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.set(index, value);
              onChanged();
            } else {
              cellsBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder setCells(
              int index,
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.set(index, builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.add(value);
              onChanged();
            } else {
              cellsBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell value) {
            if (cellsBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureCellsIsMutable();
              cells_.add(index, value);
              onChanged();
            } else {
              cellsBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.add(builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addCells(
              int index,
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
                  builderForValue) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.add(index, builderForValue.build());
              onChanged();
            } else {
              cellsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder addAllCells(
              java.lang.Iterable<
                      ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell>
                  values) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, cells_);
              onChanged();
            } else {
              cellsBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder clearCells() {
            if (cellsBuilder_ == null) {
              cells_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
            } else {
              cellsBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public Builder removeCells(int index) {
            if (cellsBuilder_ == null) {
              ensureCellsIsMutable();
              cells_.remove(index);
              onChanged();
            } else {
              cellsBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
              getCellsBuilder(int index) {
            return getCellsFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder
              getCellsOrBuilder(int index) {
            if (cellsBuilder_ == null) {
              return cells_.get(index);
            } else {
              return cellsBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>
              getCellsOrBuilderList() {
            if (cellsBuilder_ != null) {
              return cellsBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(cells_);
            }
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
              addCellsBuilder() {
            return getCellsFieldBuilder()
                .addBuilder(
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
              addCellsBuilder(int index) {
            return getCellsFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Cells that make up this row.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableCell cells = 1;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder>
              getCellsBuilderList() {
            return getCellsFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>
              getCellsFieldBuilder() {
            if (cellsBuilder_ == null) {
              cellsBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell,
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder,
                      com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder>(
                      cells_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
              cells_ = null;
            }
            return cellsBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Table.TableRow)
        private static final com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow();
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<TableRow> PARSER =
            new com.google.protobuf.AbstractParser<TableRow>() {
              @java.lang.Override
              public TableRow parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<TableRow> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<TableRow> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface TableCellOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        boolean hasLayout();
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout();
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder getLayoutOrBuilder();

        /**
         *
         *
         * <pre>
         * How many rows this cell spans.
         * </pre>
         *
         * <code>int32 row_span = 2;</code>
         *
         * @return The rowSpan.
         */
        int getRowSpan();

        /**
         *
         *
         * <pre>
         * How many columns this cell spans.
         * </pre>
         *
         * <code>int32 col_span = 3;</code>
         *
         * @return The colSpan.
         */
        int getColSpan();

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage getDetectedLanguages(
            int index);
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        int getDetectedLanguagesCount();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList();
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index);
      }
      /**
       *
       *
       * <pre>
       * A cell representation inside the table.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table.TableCell}
       */
      public static final class TableCell extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)
          TableCellOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use TableCell.newBuilder() to construct.
        private TableCell(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private TableCell() {
          detectedLanguages_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new TableCell();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableCell_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableCell_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder.class);
        }

        private int bitField0_;
        public static final int LAYOUT_FIELD_NUMBER = 1;
        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        @java.lang.Override
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
              : layout_;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          return layout_ == null
              ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
              : layout_;
        }

        public static final int ROW_SPAN_FIELD_NUMBER = 2;
        private int rowSpan_ = 0;
        /**
         *
         *
         * <pre>
         * How many rows this cell spans.
         * </pre>
         *
         * <code>int32 row_span = 2;</code>
         *
         * @return The rowSpan.
         */
        @java.lang.Override
        public int getRowSpan() {
          return rowSpan_;
        }

        public static final int COL_SPAN_FIELD_NUMBER = 3;
        private int colSpan_ = 0;
        /**
         *
         *
         * <pre>
         * How many columns this cell spans.
         * </pre>
         *
         * <code>int32 col_span = 3;</code>
         *
         * @return The colSpan.
         */
        @java.lang.Override
        public int getColSpan() {
          return colSpan_;
        }

        public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 4;

        @SuppressWarnings("serial")
        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_;
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          return detectedLanguages_;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            getDetectedLanguagesOrBuilderList() {
          return detectedLanguages_;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public int getDetectedLanguagesCount() {
          return detectedLanguages_.size();
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          return detectedLanguages_.get(index);
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
            getDetectedLanguagesOrBuilder(int index) {
          return detectedLanguages_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getLayout());
          }
          if (rowSpan_ != 0) {
            output.writeInt32(2, rowSpan_);
          }
          if (colSpan_ != 0) {
            output.writeInt32(3, colSpan_);
          }
          for (int i = 0; i < detectedLanguages_.size(); i++) {
            output.writeMessage(4, detectedLanguages_.get(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
          }
          if (rowSpan_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, rowSpan_);
          }
          if (colSpan_ != 0) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, colSpan_);
          }
          for (int i = 0; i < detectedLanguages_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    4, detectedLanguages_.get(i));
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)) {
            return super.equals(obj);
          }
          com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell other =
              (com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell) obj;

          if (hasLayout() != other.hasLayout()) return false;
          if (hasLayout()) {
            if (!getLayout().equals(other.getLayout())) return false;
          }
          if (getRowSpan() != other.getRowSpan()) return false;
          if (getColSpan() != other.getColSpan()) return false;
          if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasLayout()) {
            hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
            hash = (53 * hash) + getLayout().hashCode();
          }
          hash = (37 * hash) + ROW_SPAN_FIELD_NUMBER;
          hash = (53 * hash) + getRowSpan();
          hash = (37 * hash) + COL_SPAN_FIELD_NUMBER;
          hash = (53 * hash) + getColSpan();
          if (getDetectedLanguagesCount() > 0) {
            hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
            hash = (53 * hash) + getDetectedLanguagesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * A cell representation inside the table.
         * </pre>
         *
         * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table.TableCell}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCellOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableCell_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableCell_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.class,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getLayoutFieldBuilder();
              getDetectedLanguagesFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            layout_ = null;
            if (layoutBuilder_ != null) {
              layoutBuilder_.dispose();
              layoutBuilder_ = null;
            }
            rowSpan_ = 0;
            colSpan_ = 0;
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguages_ = java.util.Collections.emptyList();
            } else {
              detectedLanguages_ = null;
              detectedLanguagesBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000008);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.documentai.v1beta3.DocumentProto
                .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_TableCell_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
              getDefaultInstanceForType() {
            return com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell build() {
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell result =
                buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell buildPartial() {
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell result =
                new com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell result) {
            if (detectedLanguagesBuilder_ == null) {
              if (((bitField0_ & 0x00000008) != 0)) {
                detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
                bitField0_ = (bitField0_ & ~0x00000008);
              }
              result.detectedLanguages_ = detectedLanguages_;
            } else {
              result.detectedLanguages_ = detectedLanguagesBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.rowSpan_ = rowSpan_;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.colSpan_ = colSpan_;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell) {
              return mergeFrom(
                  (com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell) other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell other) {
            if (other
                == com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
                    .getDefaultInstance()) return this;
            if (other.hasLayout()) {
              mergeLayout(other.getLayout());
            }
            if (other.getRowSpan() != 0) {
              setRowSpan(other.getRowSpan());
            }
            if (other.getColSpan() != 0) {
              setColSpan(other.getColSpan());
            }
            if (detectedLanguagesBuilder_ == null) {
              if (!other.detectedLanguages_.isEmpty()) {
                if (detectedLanguages_.isEmpty()) {
                  detectedLanguages_ = other.detectedLanguages_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                } else {
                  ensureDetectedLanguagesIsMutable();
                  detectedLanguages_.addAll(other.detectedLanguages_);
                }
                onChanged();
              }
            } else {
              if (!other.detectedLanguages_.isEmpty()) {
                if (detectedLanguagesBuilder_.isEmpty()) {
                  detectedLanguagesBuilder_.dispose();
                  detectedLanguagesBuilder_ = null;
                  detectedLanguages_ = other.detectedLanguages_;
                  bitField0_ = (bitField0_ & ~0x00000008);
                  detectedLanguagesBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getDetectedLanguagesFieldBuilder()
                          : null;
                } else {
                  detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
                }
              }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 16:
                    {
                      rowSpan_ = input.readInt32();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 16
                  case 24:
                    {
                      colSpan_ = input.readInt32();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 24
                  case 34:
                    {
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                          input.readMessage(
                              com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                  .parser(),
                              extensionRegistry);
                      if (detectedLanguagesBuilder_ == null) {
                        ensureDetectedLanguagesIsMutable();
                        detectedLanguages_.add(m);
                      } else {
                        detectedLanguagesBuilder_.addMessage(m);
                      }
                      break;
                    } // case 34
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
              layoutBuilder_;
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           *
           * @return Whether the layout field is set.
           */
          public boolean hasLayout() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           *
           * @return The layout.
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
            if (layoutBuilder_ == null) {
              return layout_ == null
                  ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                  : layout_;
            } else {
              return layoutBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
            if (layoutBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              layout_ = value;
            } else {
              layoutBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public Builder setLayout(
              com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
            if (layoutBuilder_ == null) {
              layout_ = builderForValue.build();
            } else {
              layoutBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public Builder mergeLayout(
              com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
            if (layoutBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && layout_ != null
                  && layout_
                      != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                          .getDefaultInstance()) {
                getLayoutBuilder().mergeFrom(value);
              } else {
                layout_ = value;
              }
            } else {
              layoutBuilder_.mergeFrom(value);
            }
            if (layout_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public Builder clearLayout() {
            bitField0_ = (bitField0_ & ~0x00000001);
            layout_ = null;
            if (layoutBuilder_ != null) {
              layoutBuilder_.dispose();
              layoutBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder
              getLayoutBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getLayoutFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
              getLayoutOrBuilder() {
            if (layoutBuilder_ != null) {
              return layoutBuilder_.getMessageOrBuilder();
            } else {
              return layout_ == null
                  ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                  : layout_;
            }
          }
          /**
           *
           *
           * <pre>
           * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
           * [TableCell][google.cloud.documentai.v1beta3.Document.Page.Table.TableCell].
           * </pre>
           *
           * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                  com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
              getLayoutFieldBuilder() {
            if (layoutBuilder_ == null) {
              layoutBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                      com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                      com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                      getLayout(), getParentForChildren(), isClean());
              layout_ = null;
            }
            return layoutBuilder_;
          }

          private int rowSpan_;
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @return The rowSpan.
           */
          @java.lang.Override
          public int getRowSpan() {
            return rowSpan_;
          }
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @param value The rowSpan to set.
           * @return This builder for chaining.
           */
          public Builder setRowSpan(int value) {

            rowSpan_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * How many rows this cell spans.
           * </pre>
           *
           * <code>int32 row_span = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRowSpan() {
            bitField0_ = (bitField0_ & ~0x00000002);
            rowSpan_ = 0;
            onChanged();
            return this;
          }

          private int colSpan_;
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @return The colSpan.
           */
          @java.lang.Override
          public int getColSpan() {
            return colSpan_;
          }
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @param value The colSpan to set.
           * @return This builder for chaining.
           */
          public Builder setColSpan(int value) {

            colSpan_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * How many columns this cell spans.
           * </pre>
           *
           * <code>int32 col_span = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearColSpan() {
            bitField0_ = (bitField0_ & ~0x00000004);
            colSpan_ = 0;
            onChanged();
            return this;
          }

          private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
              detectedLanguages_ = java.util.Collections.emptyList();

          private void ensureDetectedLanguagesIsMutable() {
            if (!((bitField0_ & 0x00000008) != 0)) {
              detectedLanguages_ =
                  new java.util.ArrayList<
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                      detectedLanguages_);
              bitField0_ |= 0x00000008;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
              detectedLanguagesBuilder_;

          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
              getDetectedLanguagesList() {
            if (detectedLanguagesBuilder_ == null) {
              return java.util.Collections.unmodifiableList(detectedLanguages_);
            } else {
              return detectedLanguagesBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public int getDetectedLanguagesCount() {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.size();
            } else {
              return detectedLanguagesBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
              getDetectedLanguages(int index) {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.get(index);
            } else {
              return detectedLanguagesBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder setDetectedLanguages(
              int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.set(index, value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder setDetectedLanguages(
              int index,
              com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.set(index, builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
            if (detectedLanguagesBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(index, value);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addDetectedLanguages(
              int index,
              com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                  builderForValue) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.add(index, builderForValue.build());
              onChanged();
            } else {
              detectedLanguagesBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder addAllDetectedLanguages(
              java.lang.Iterable<
                      ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
                  values) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, detectedLanguages_);
              onChanged();
            } else {
              detectedLanguagesBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder clearDetectedLanguages() {
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguages_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000008);
              onChanged();
            } else {
              detectedLanguagesBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public Builder removeDetectedLanguages(int index) {
            if (detectedLanguagesBuilder_ == null) {
              ensureDetectedLanguagesIsMutable();
              detectedLanguages_.remove(index);
              onChanged();
            } else {
              detectedLanguagesBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
              getDetectedLanguagesBuilder(int index) {
            return getDetectedLanguagesFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
              getDetectedLanguagesOrBuilder(int index) {
            if (detectedLanguagesBuilder_ == null) {
              return detectedLanguages_.get(index);
            } else {
              return detectedLanguagesBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
              getDetectedLanguagesOrBuilderList() {
            if (detectedLanguagesBuilder_ != null) {
              return detectedLanguagesBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(detectedLanguages_);
            }
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
              addDetectedLanguagesBuilder() {
            return getDetectedLanguagesFieldBuilder()
                .addBuilder(
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
              addDetectedLanguagesBuilder(int index) {
            return getDetectedLanguagesFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                        .getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * A list of detected languages together with confidence.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder>
              getDetectedLanguagesBuilderList() {
            return getDetectedLanguagesFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                  com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
              getDetectedLanguagesFieldBuilder() {
            if (detectedLanguagesBuilder_ == null) {
              detectedLanguagesBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                      com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>(
                      detectedLanguages_,
                      ((bitField0_ & 0x00000008) != 0),
                      getParentForChildren(),
                      isClean());
              detectedLanguages_ = null;
            }
            return detectedLanguagesBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.Document.Page.Table.TableCell)
        private static final com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell();
        }

        public static com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<TableCell> PARSER =
            new com.google.protobuf.AbstractParser<TableCell>() {
              @java.lang.Override
              public TableCell parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<TableCell> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<TableCell> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableCell
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int LAYOUT_FIELD_NUMBER = 1;
      private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return Whether the layout field is set.
       */
      @java.lang.Override
      public boolean hasLayout() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       *
       * @return The layout.
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }
      /**
       *
       *
       * <pre>
       * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
       * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
       * </pre>
       *
       * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
          getLayoutOrBuilder() {
        return layout_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
            : layout_;
      }

      public static final int HEADER_ROWS_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          headerRows_;
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          getHeaderRowsList() {
        return headerRows_;
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
          getHeaderRowsOrBuilderList() {
        return headerRows_;
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public int getHeaderRowsCount() {
        return headerRows_.size();
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getHeaderRows(
          int index) {
        return headerRows_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Header rows of the table.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
          getHeaderRowsOrBuilder(int index) {
        return headerRows_.get(index);
      }

      public static final int BODY_ROWS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          bodyRows_;
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
          getBodyRowsList() {
        return bodyRows_;
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
          getBodyRowsOrBuilderList() {
        return bodyRows_;
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public int getBodyRowsCount() {
        return bodyRows_.size();
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getBodyRows(
          int index) {
        return bodyRows_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Body rows of the table.
       * </pre>
       *
       * <code>repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
          getBodyRowsOrBuilder(int index) {
        return bodyRows_.get(index);
      }

      public static final int DETECTED_LANGUAGES_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          detectedLanguages_;
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
          getDetectedLanguagesList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
          getDetectedLanguagesOrBuilderList() {
        return detectedLanguages_;
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public int getDetectedLanguagesCount() {
        return detectedLanguages_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
          getDetectedLanguages(int index) {
        return detectedLanguages_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of detected languages together with confidence.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder
          getDetectedLanguagesOrBuilder(int index) {
        return detectedLanguages_.get(index);
      }

      public static final int PROVENANCE_FIELD_NUMBER = 5;
      private com.google.cloud.documentai.v1beta3.Document.Provenance provenance_;
      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Table.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=395
       * @return Whether the provenance field is set.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean hasProvenance() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.documentai.v1beta3.Document.Page.Table.provenance is deprecated.
       *     See google/cloud/documentai/v1beta3/document.proto;l=395
       * @return The provenance.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.Provenance getProvenance() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }
      /**
       *
       *
       * <pre>
       * The history of this table.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.Document.Provenance provenance = 5 [deprecated = true];
       * </code>
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.documentai.v1beta3.Document.ProvenanceOrBuilder
          getProvenanceOrBuilder() {
        return provenance_ == null
            ? com.google.cloud.documentai.v1beta3.Document.Provenance.getDefaultInstance()
            : provenance_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getLayout());
        }
        for (int i = 0; i < headerRows_.size(); i++) {
          output.writeMessage(2, headerRows_.get(i));
        }
        for (int i = 0; i < bodyRows_.size(); i++) {
          output.writeMessage(3, bodyRows_.get(i));
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          output.writeMessage(4, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(5, getProvenance());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLayout());
        }
        for (int i = 0; i < headerRows_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, headerRows_.get(i));
        }
        for (int i = 0; i < bodyRows_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, bodyRows_.get(i));
        }
        for (int i = 0; i < detectedLanguages_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4, detectedLanguages_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProvenance());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.Document.Page.Table other =
            (com.google.cloud.documentai.v1beta3.Document.Page.Table) obj;

        if (hasLayout() != other.hasLayout()) return false;
        if (hasLayout()) {
          if (!getLayout().equals(other.getLayout())) return false;
        }
        if (!getHeaderRowsList().equals(other.getHeaderRowsList())) return false;
        if (!getBodyRowsList().equals(other.getBodyRowsList())) return false;
        if (!getDetectedLanguagesList().equals(other.getDetectedLanguagesList())) return false;
        if (hasProvenance() != other.hasProvenance()) return false;
        if (hasProvenance()) {
          if (!getProvenance().equals(other.getProvenance())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasLayout()) {
          hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
          hash = (53 * hash) + getLayout().hashCode();
        }
        if (getHeaderRowsCount() > 0) {
          hash = (37 * hash) + HEADER_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getHeaderRowsList().hashCode();
        }
        if (getBodyRowsCount() > 0) {
          hash = (37 * hash) + BODY_ROWS_FIELD_NUMBER;
          hash = (53 * hash) + getBodyRowsList().hashCode();
        }
        if (getDetectedLanguagesCount() > 0) {
          hash = (37 * hash) + DETECTED_LANGUAGES_FIELD_NUMBER;
          hash = (53 * hash) + getDetectedLanguagesList().hashCode();
        }
        if (hasProvenance()) {
          hash = (37 * hash) + PROVENANCE_FIELD_NUMBER;
          hash = (53 * hash) + getProvenance().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.Document.Page.Table parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.Document.Page.Table prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A table representation similar to HTML table structure.
       * </pre>
       *
       * Protobuf type {@code google.cloud.documentai.v1beta3.Document.Page.Table}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.Document.Page.Table)
          com.google.cloud.documentai.v1beta3.Document.Page.TableOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.class,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.Builder.class);
        }

        // Construct using com.google.cloud.documentai.v1beta3.Document.Page.Table.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getLayoutFieldBuilder();
            getHeaderRowsFieldBuilder();
            getBodyRowsFieldBuilder();
            getDetectedLanguagesFieldBuilder();
            getProvenanceFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          if (headerRowsBuilder_ == null) {
            headerRows_ = java.util.Collections.emptyList();
          } else {
            headerRows_ = null;
            headerRowsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          if (bodyRowsBuilder_ == null) {
            bodyRows_ = java.util.Collections.emptyList();
          } else {
            bodyRows_ = null;
            bodyRowsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          if (detectedLanguagesBuilder_ == null) {
            detectedLanguages_ = java.util.Collections.emptyList();
          } else {
            detectedLanguages_ = null;
            detectedLanguagesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          provenance_ = null;
          if (provenanceBuilder_ != null) {
            provenanceBuilder_.dispose();
            provenanceBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentProto
              .internal_static_google_cloud_documentai_v1beta3_Document_Page_Table_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.Document.Page.Table.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table build() {
          com.google.cloud.documentai.v1beta3.Document.Page.Table result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.Document.Page.Table buildPartial() {
          com.google.cloud.documentai.v1beta3.Document.Page.Table result =
              new com.google.cloud.documentai.v1beta3.Document.Page.Table(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.documentai.v1beta3.Document.Page.Table result) {
          if (headerRowsBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              headerRows_ = java.util.Collections.unmodifiableList(headerRows_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.headerRows_ = headerRows_;
          } else {
            result.headerRows_ = headerRowsBuilder_.build();
          }
          if (bodyRowsBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              bodyRows_ = java.util.Collections.unmodifiableList(bodyRows_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.bodyRows_ = bodyRows_;
          } else {
            result.bodyRows_ = bodyRowsBuilder_.build();
          }
          if (detectedLanguagesBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              detectedLanguages_ = java.util.Collections.unmodifiableList(detectedLanguages_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.detectedLanguages_ = detectedLanguages_;
          } else {
            result.detectedLanguages_ = detectedLanguagesBuilder_.build();
          }
        }

        private void buildPartial0(com.google.cloud.documentai.v1beta3.Document.Page.Table result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.layout_ = layoutBuilder_ == null ? layout_ : layoutBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.provenance_ =
                provenanceBuilder_ == null ? provenance_ : provenanceBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.documentai.v1beta3.Document.Page.Table) {
            return mergeFrom((com.google.cloud.documentai.v1beta3.Document.Page.Table) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.cloud.documentai.v1beta3.Document.Page.Table other) {
          if (other == com.google.cloud.documentai.v1beta3.Document.Page.Table.getDefaultInstance())
            return this;
          if (other.hasLayout()) {
            mergeLayout(other.getLayout());
          }
          if (headerRowsBuilder_ == null) {
            if (!other.headerRows_.isEmpty()) {
              if (headerRows_.isEmpty()) {
                headerRows_ = other.headerRows_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureHeaderRowsIsMutable();
                headerRows_.addAll(other.headerRows_);
              }
              onChanged();
            }
          } else {
            if (!other.headerRows_.isEmpty()) {
              if (headerRowsBuilder_.isEmpty()) {
                headerRowsBuilder_.dispose();
                headerRowsBuilder_ = null;
                headerRows_ = other.headerRows_;
                bitField0_ = (bitField0_ & ~0x00000002);
                headerRowsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getHeaderRowsFieldBuilder()
                        : null;
              } else {
                headerRowsBuilder_.addAllMessages(other.headerRows_);
              }
            }
          }
          if (bodyRowsBuilder_ == null) {
            if (!other.bodyRows_.isEmpty()) {
              if (bodyRows_.isEmpty()) {
                bodyRows_ = other.bodyRows_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureBodyRowsIsMutable();
                bodyRows_.addAll(other.bodyRows_);
              }
              onChanged();
            }
          } else {
            if (!other.bodyRows_.isEmpty()) {
              if (bodyRowsBuilder_.isEmpty()) {
                bodyRowsBuilder_.dispose();
                bodyRowsBuilder_ = null;
                bodyRows_ = other.bodyRows_;
                bitField0_ = (bitField0_ & ~0x00000004);
                bodyRowsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getBodyRowsFieldBuilder()
                        : null;
              } else {
                bodyRowsBuilder_.addAllMessages(other.bodyRows_);
              }
            }
          }
          if (detectedLanguagesBuilder_ == null) {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguages_.isEmpty()) {
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureDetectedLanguagesIsMutable();
                detectedLanguages_.addAll(other.detectedLanguages_);
              }
              onChanged();
            }
          } else {
            if (!other.detectedLanguages_.isEmpty()) {
              if (detectedLanguagesBuilder_.isEmpty()) {
                detectedLanguagesBuilder_.dispose();
                detectedLanguagesBuilder_ = null;
                detectedLanguages_ = other.detectedLanguages_;
                bitField0_ = (bitField0_ & ~0x00000008);
                detectedLanguagesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDetectedLanguagesFieldBuilder()
                        : null;
              } else {
                detectedLanguagesBuilder_.addAllMessages(other.detectedLanguages_);
              }
            }
          }
          if (other.hasProvenance()) {
            mergeProvenance(other.getProvenance());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getLayoutFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                                .parser(),
                            extensionRegistry);
                    if (headerRowsBuilder_ == null) {
                      ensureHeaderRowsIsMutable();
                      headerRows_.add(m);
                    } else {
                      headerRowsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                                .parser(),
                            extensionRegistry);
                    if (bodyRowsBuilder_ == null) {
                      ensureBodyRowsIsMutable();
                      bodyRows_.add(m);
                    } else {
                      bodyRowsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage m =
                        input.readMessage(
                            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
                                .parser(),
                            extensionRegistry);
                    if (detectedLanguagesBuilder_ == null) {
                      ensureDetectedLanguagesIsMutable();
                      detectedLanguages_.add(m);
                    } else {
                      detectedLanguagesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                case 42:
                  {
                    input.readMessage(getProvenanceFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.documentai.v1beta3.Document.Page.Layout layout_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            layoutBuilder_;
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return Whether the layout field is set.
         */
        public boolean hasLayout() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         *
         * @return The layout.
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout getLayout() {
          if (layoutBuilder_ == null) {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          } else {
            return layoutBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            layout_ = value;
          } else {
            layoutBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder setLayout(
            com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder builderForValue) {
          if (layoutBuilder_ == null) {
            layout_ = builderForValue.build();
          } else {
            layoutBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder mergeLayout(com.google.cloud.documentai.v1beta3.Document.Page.Layout value) {
          if (layoutBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && layout_ != null
                && layout_
                    != com.google.cloud.documentai.v1beta3.Document.Page.Layout
                        .getDefaultInstance()) {
              getLayoutBuilder().mergeFrom(value);
            } else {
              layout_ = value;
            }
          } else {
            layoutBuilder_.mergeFrom(value);
          }
          if (layout_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public Builder clearLayout() {
          bitField0_ = (bitField0_ & ~0x00000001);
          layout_ = null;
          if (layoutBuilder_ != null) {
            layoutBuilder_.dispose();
            layoutBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder getLayoutBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getLayoutFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder
            getLayoutOrBuilder() {
          if (layoutBuilder_ != null) {
            return layoutBuilder_.getMessageOrBuilder();
          } else {
            return layout_ == null
                ? com.google.cloud.documentai.v1beta3.Document.Page.Layout.getDefaultInstance()
                : layout_;
          }
        }
        /**
         *
         *
         * <pre>
         * [Layout][google.cloud.documentai.v1beta3.Document.Page.Layout] for
         * [Table][google.cloud.documentai.v1beta3.Document.Page.Table].
         * </pre>
         *
         * <code>.google.cloud.documentai.v1beta3.Document.Page.Layout layout = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>
            getLayoutFieldBuilder() {
          if (layoutBuilder_ == null) {
            layoutBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout,
                    com.google.cloud.documentai.v1beta3.Document.Page.Layout.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.LayoutOrBuilder>(
                    getLayout(), getParentForChildren(), isClean());
            layout_ = null;
          }
          return layoutBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
            headerRows_ = java.util.Collections.emptyList();

        private void ensureHeaderRowsIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            headerRows_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>(headerRows_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            headerRowsBuilder_;

        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
            getHeaderRowsList() {
          if (headerRowsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(headerRows_);
          } else {
            return headerRowsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public int getHeaderRowsCount() {
          if (headerRowsBuilder_ == null) {
            return headerRows_.size();
          } else {
            return headerRowsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getHeaderRows(
            int index) {
          if (headerRowsBuilder_ == null) {
            return headerRows_.get(index);
          } else {
            return headerRowsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder setHeaderRows(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.set(index, value);
            onChanged();
          } else {
            headerRowsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder setHeaderRows(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.set(index, builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.add(value);
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (headerRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureHeaderRowsIsMutable();
            headerRows_.add(index, value);
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.add(builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addHeaderRows(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.add(index, builderForValue.build());
            onChanged();
          } else {
            headerRowsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder addAllHeaderRows(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
                values) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, headerRows_);
            onChanged();
          } else {
            headerRowsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder clearHeaderRows() {
          if (headerRowsBuilder_ == null) {
            headerRows_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            headerRowsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public Builder removeHeaderRows(int index) {
          if (headerRowsBuilder_ == null) {
            ensureHeaderRowsIsMutable();
            headerRows_.remove(index);
            onChanged();
          } else {
            headerRowsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            getHeaderRowsBuilder(int index) {
          return getHeaderRowsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
            getHeaderRowsOrBuilder(int index) {
          if (headerRowsBuilder_ == null) {
            return headerRows_.get(index);
          } else {
            return headerRowsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            getHeaderRowsOrBuilderList() {
          if (headerRowsBuilder_ != null) {
            return headerRowsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(headerRows_);
          }
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            addHeaderRowsBuilder() {
          return getHeaderRowsFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            addHeaderRowsBuilder(int index) {
          return getHeaderRowsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Header rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow header_rows = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder>
            getHeaderRowsBuilderList() {
          return getHeaderRowsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            getHeaderRowsFieldBuilder() {
          if (headerRowsBuilder_ == null) {
            headerRowsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>(
                    headerRows_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            headerRows_ = null;
          }
          return headerRowsBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
            bodyRows_ = java.util.Collections.emptyList();

        private void ensureBodyRowsIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            bodyRows_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>(bodyRows_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            bodyRowsBuilder_;

        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
            getBodyRowsList() {
          if (bodyRowsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(bodyRows_);
          } else {
            return bodyRowsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public int getBodyRowsCount() {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.size();
          } else {
            return bodyRowsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow getBodyRows(
            int index) {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.get(index);
          } else {
            return bodyRowsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder setBodyRows(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.set(index, value);
            onChanged();
          } else {
            bodyRowsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder setBodyRows(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.set(index, builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.add(value);
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow value) {
          if (bodyRowsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureBodyRowsIsMutable();
            bodyRows_.add(index, value);
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.add(builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addBodyRows(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
                builderForValue) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.add(index, builderForValue.build());
            onChanged();
          } else {
            bodyRowsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder addAllBodyRows(
            java.lang.Iterable<
                    ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow>
                values) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bodyRows_);
            onChanged();
          } else {
            bodyRowsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder clearBodyRows() {
          if (bodyRowsBuilder_ == null) {
            bodyRows_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            bodyRowsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public Builder removeBodyRows(int index) {
          if (bodyRowsBuilder_ == null) {
            ensureBodyRowsIsMutable();
            bodyRows_.remove(index);
            onChanged();
          } else {
            bodyRowsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            getBodyRowsBuilder(int index) {
          return getBodyRowsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder
            getBodyRowsOrBuilder(int index) {
          if (bodyRowsBuilder_ == null) {
            return bodyRows_.get(index);
          } else {
            return bodyRowsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<
                ? extends com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            getBodyRowsOrBuilderList() {
          if (bodyRowsBuilder_ != null) {
            return bodyRowsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(bodyRows_);
          }
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            addBodyRowsBuilder() {
          return getBodyRowsFieldBuilder()
              .addBuilder(
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder
            addBodyRowsBuilder(int index) {
          return getBodyRowsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Body rows of the table.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.Table.TableRow body_rows = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder>
            getBodyRowsBuilderList() {
          return getBodyRowsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>
            getBodyRowsFieldBuilder() {
          if (bodyRowsBuilder_ == null) {
            bodyRowsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRow.Builder,
                    com.google.cloud.documentai.v1beta3.Document.Page.Table.TableRowOrBuilder>(
                    bodyRows_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
            bodyRows_ = null;
          }
          return bodyRowsBuilder_;
        }

        private java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            detectedLanguages_ = java.util.Collections.emptyList();

        private void ensureDetectedLanguagesIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            detectedLanguages_ =
                new java.util.ArrayList<
                    com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>(
                    detectedLanguages_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder,
                com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguageOrBuilder>
            detectedLanguagesBuilder_;

        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public java.util.List<com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage>
            getDetectedLanguagesList() {
          if (detectedLanguagesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(detectedLanguages_);
          } else {
            return detectedLanguagesBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public int getDetectedLanguagesCount() {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.size();
          } else {
            return detectedLanguagesBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage
            getDetectedLanguages(int index) {
          if (detectedLanguagesBuilder_ == null) {
            return detectedLanguages_.get(index);
          } else {
            return detectedLanguagesBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index, com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, value);
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder setDetectedLanguages(
            int index,
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage.Builder
                builderForValue) {
          if (detectedLanguagesBuilder_ == null) {
            ensureDetectedLanguagesIsMutable();
            detectedLanguages_.set(index, builderForValue.build());
            onChanged();
          } else {
            detectedLanguagesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of detected languages together with confidence.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage detected_languages = 4;
         * </code>
         */
        public Builder addDetectedLanguages(
            com.google.cloud.documentai.v1beta3.Document.Page.DetectedLanguage value) {
          if (detectedLanguagesBuilder_ == null) {
            if (value == null) {
              throw new NullPoi