/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/dataset.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Document Identifier.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId}
 */
public final class DocumentId extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentId)
    DocumentIdOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DocumentId.newBuilder() to construct.
  private DocumentId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentId() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentId();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_DocumentId_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_DocumentId_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.DocumentId.class,
            com.google.cloud.documentai.v1beta3.DocumentId.Builder.class);
  }

  public interface GCSManagedDocumentIdOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI where the actual document is stored.
     * </pre>
     *
     * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsUri.
     */
    java.lang.String getGcsUri();
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI where the actual document is stored.
     * </pre>
     *
     * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsUri.
     */
    com.google.protobuf.ByteString getGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Id of the document (indexed) managed by Content Warehouse.
     * </pre>
     *
     * <code>string cw_doc_id = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
     *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
     * @return The cwDocId.
     */
    @java.lang.Deprecated
    java.lang.String getCwDocId();
    /**
     *
     *
     * <pre>
     * Id of the document (indexed) managed by Content Warehouse.
     * </pre>
     *
     * <code>string cw_doc_id = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
     *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
     * @return The bytes for cwDocId.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getCwDocIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Identifies a document uniquely within the scope of a dataset in the
   * user-managed Cloud Storage option.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId}
   */
  public static final class GCSManagedDocumentId extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)
      GCSManagedDocumentIdOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GCSManagedDocumentId.newBuilder() to construct.
    private GCSManagedDocumentId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GCSManagedDocumentId() {
      gcsUri_ = "";
      cwDocId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GCSManagedDocumentId();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_GCSManagedDocumentId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_GCSManagedDocumentId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.class,
              com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder.class);
    }

    public static final int GCS_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object gcsUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI where the actual document is stored.
     * </pre>
     *
     * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The gcsUri.
     */
    @java.lang.Override
    public java.lang.String getGcsUri() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gcsUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage URI where the actual document is stored.
     * </pre>
     *
     * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for gcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGcsUriBytes() {
      java.lang.Object ref = gcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CW_DOC_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object cwDocId_ = "";
    /**
     *
     *
     * <pre>
     * Id of the document (indexed) managed by Content Warehouse.
     * </pre>
     *
     * <code>string cw_doc_id = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
     *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
     * @return The cwDocId.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getCwDocId() {
      java.lang.Object ref = cwDocId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cwDocId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Id of the document (indexed) managed by Content Warehouse.
     * </pre>
     *
     * <code>string cw_doc_id = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
     *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
     * @return The bytes for cwDocId.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getCwDocIdBytes() {
      java.lang.Object ref = cwDocId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cwDocId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cwDocId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, cwDocId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cwDocId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, cwDocId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId other =
          (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) obj;

      if (!getGcsUri().equals(other.getGcsUri())) return false;
      if (!getCwDocId().equals(other.getCwDocId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getGcsUri().hashCode();
      hash = (37 * hash) + CW_DOC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCwDocId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Identifies a document uniquely within the scope of a dataset in the
     * user-managed Cloud Storage option.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_GCSManagedDocumentId_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_GCSManagedDocumentId_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.class,
                com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        gcsUri_ = "";
        cwDocId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_GCSManagedDocumentId_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId build() {
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId buildPartial() {
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId result =
            new com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.gcsUri_ = gcsUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.cwDocId_ = cwDocId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId other) {
        if (other
            == com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
                .getDefaultInstance()) return this;
        if (!other.getGcsUri().isEmpty()) {
          gcsUri_ = other.gcsUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getCwDocId().isEmpty()) {
          cwDocId_ = other.cwDocId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  gcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  cwDocId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object gcsUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI where the actual document is stored.
       * </pre>
       *
       * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The gcsUri.
       */
      public java.lang.String getGcsUri() {
        java.lang.Object ref = gcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          gcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI where the actual document is stored.
       * </pre>
       *
       * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for gcsUri.
       */
      public com.google.protobuf.ByteString getGcsUriBytes() {
        java.lang.Object ref = gcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          gcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI where the actual document is stored.
       * </pre>
       *
       * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        gcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI where the actual document is stored.
       * </pre>
       *
       * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGcsUri() {
        gcsUri_ = getDefaultInstance().getGcsUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage URI where the actual document is stored.
       * </pre>
       *
       * <code>string gcs_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for gcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        gcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object cwDocId_ = "";
      /**
       *
       *
       * <pre>
       * Id of the document (indexed) managed by Content Warehouse.
       * </pre>
       *
       * <code>string cw_doc_id = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
       *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
       * @return The cwDocId.
       */
      @java.lang.Deprecated
      public java.lang.String getCwDocId() {
        java.lang.Object ref = cwDocId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cwDocId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Id of the document (indexed) managed by Content Warehouse.
       * </pre>
       *
       * <code>string cw_doc_id = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
       *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
       * @return The bytes for cwDocId.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getCwDocIdBytes() {
        java.lang.Object ref = cwDocId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cwDocId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Id of the document (indexed) managed by Content Warehouse.
       * </pre>
       *
       * <code>string cw_doc_id = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
       *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
       * @param value The cwDocId to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setCwDocId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        cwDocId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Id of the document (indexed) managed by Content Warehouse.
       * </pre>
       *
       * <code>string cw_doc_id = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
       *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearCwDocId() {
        cwDocId_ = getDefaultInstance().getCwDocId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Id of the document (indexed) managed by Content Warehouse.
       * </pre>
       *
       * <code>string cw_doc_id = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.cw_doc_id is
       *     deprecated. See google/cloud/documentai/v1beta3/dataset.proto;l=140
       * @param value The bytes for cwDocId to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setCwDocIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        cwDocId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId)
    private static final com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId();
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GCSManagedDocumentId> PARSER =
        new com.google.protobuf.AbstractParser<GCSManagedDocumentId>() {
          @java.lang.Override
          public GCSManagedDocumentId parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GCSManagedDocumentId> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GCSManagedDocumentId> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UnmanagedDocumentIdOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The id of the document.
     * </pre>
     *
     * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The docId.
     */
    java.lang.String getDocId();
    /**
     *
     *
     * <pre>
     * Required. The id of the document.
     * </pre>
     *
     * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for docId.
     */
    com.google.protobuf.ByteString getDocIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Identifies a document uniquely within the scope of a dataset in unmanaged
   * option.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId}
   */
  public static final class UnmanagedDocumentId extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)
      UnmanagedDocumentIdOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UnmanagedDocumentId.newBuilder() to construct.
    private UnmanagedDocumentId(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UnmanagedDocumentId() {
      docId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UnmanagedDocumentId();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_UnmanagedDocumentId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_UnmanagedDocumentId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.class,
              com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder.class);
    }

    public static final int DOC_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object docId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The id of the document.
     * </pre>
     *
     * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The docId.
     */
    @java.lang.Override
    public java.lang.String getDocId() {
      java.lang.Object ref = docId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        docId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the document.
     * </pre>
     *
     * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for docId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDocIdBytes() {
      java.lang.Object ref = docId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        docId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(docId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, docId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(docId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, docId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId other =
          (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) obj;

      if (!getDocId().equals(other.getDocId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDocId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Identifies a document uniquely within the scope of a dataset in unmanaged
     * option.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_UnmanagedDocumentId_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_UnmanagedDocumentId_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.class,
                com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        docId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_DocumentId_UnmanagedDocumentId_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId build() {
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId buildPartial() {
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId result =
            new com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.docId_ = docId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId other) {
        if (other
            == com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
                .getDefaultInstance()) return this;
        if (!other.getDocId().isEmpty()) {
          docId_ = other.docId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  docId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object docId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The id of the document.
       * </pre>
       *
       * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The docId.
       */
      public java.lang.String getDocId() {
        java.lang.Object ref = docId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          docId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the document.
       * </pre>
       *
       * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for docId.
       */
      public com.google.protobuf.ByteString getDocIdBytes() {
        java.lang.Object ref = docId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          docId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the document.
       * </pre>
       *
       * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The docId to set.
       * @return This builder for chaining.
       */
      public Builder setDocId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        docId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the document.
       * </pre>
       *
       * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocId() {
        docId_ = getDefaultInstance().getDocId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The id of the document.
       * </pre>
       *
       * <code>string doc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for docId to set.
       * @return This builder for chaining.
       */
      public Builder setDocIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        docId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId)
    private static final com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId();
    }

    public static com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UnmanagedDocumentId> PARSER =
        new com.google.protobuf.AbstractParser<UnmanagedDocumentId>() {
          @java.lang.Override
          public UnmanagedDocumentId parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UnmanagedDocumentId> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UnmanagedDocumentId> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_MANAGED_DOC_ID(1),
    UNMANAGED_DOC_ID(4),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_MANAGED_DOC_ID;
        case 4:
          return UNMANAGED_DOC_ID;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int GCS_MANAGED_DOC_ID_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * A document id within user-managed Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
   * </code>
   *
   * @return Whether the gcsManagedDocId field is set.
   */
  @java.lang.Override
  public boolean hasGcsManagedDocId() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * A document id within user-managed Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
   * </code>
   *
   * @return The gcsManagedDocId.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId getGcsManagedDocId() {
    if (typeCase_ == 1) {
      return (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_;
    }
    return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A document id within user-managed Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder
      getGcsManagedDocIdOrBuilder() {
    if (typeCase_ == 1) {
      return (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_;
    }
    return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.getDefaultInstance();
  }

  public static final int UNMANAGED_DOC_ID_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A document id within unmanaged dataset.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
   * </code>
   *
   * @return Whether the unmanagedDocId field is set.
   */
  @java.lang.Override
  public boolean hasUnmanagedDocId() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A document id within unmanaged dataset.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
   * </code>
   *
   * @return The unmanagedDocId.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId getUnmanagedDocId() {
    if (typeCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_;
    }
    return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A document id within unmanaged dataset.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder
      getUnmanagedDocIdOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_;
    }
    return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.getDefaultInstance();
  }

  public static final int REVISION_REF_FIELD_NUMBER = 3;
  private com.google.cloud.documentai.v1beta3.RevisionRef revisionRef_;
  /**
   *
   *
   * <pre>
   * Points to a specific revision of the document if set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
   *
   * @return Whether the revisionRef field is set.
   */
  @java.lang.Override
  public boolean hasRevisionRef() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Points to a specific revision of the document if set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
   *
   * @return The revisionRef.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RevisionRef getRevisionRef() {
    return revisionRef_ == null
        ? com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance()
        : revisionRef_;
  }
  /**
   *
   *
   * <pre>
   * Points to a specific revision of the document if set.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder getRevisionRefOrBuilder() {
    return revisionRef_ == null
        ? com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance()
        : revisionRef_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getRevisionRef());
    }
    if (typeCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRevisionRef());
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.DocumentId)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.DocumentId other =
        (com.google.cloud.documentai.v1beta3.DocumentId) obj;

    if (hasRevisionRef() != other.hasRevisionRef()) return false;
    if (hasRevisionRef()) {
      if (!getRevisionRef().equals(other.getRevisionRef())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 1:
        if (!getGcsManagedDocId().equals(other.getGcsManagedDocId())) return false;
        break;
      case 4:
        if (!getUnmanagedDocId().equals(other.getUnmanagedDocId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasRevisionRef()) {
      hash = (37 * hash) + REVISION_REF_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionRef().hashCode();
    }
    switch (typeCase_) {
      case 1:
        hash = (37 * hash) + GCS_MANAGED_DOC_ID_FIELD_NUMBER;
        hash = (53 * hash) + getGcsManagedDocId().hashCode();
        break;
      case 4:
        hash = (37 * hash) + UNMANAGED_DOC_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUnmanagedDocId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.DocumentId prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Document Identifier.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.DocumentId}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.DocumentId)
      com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.DocumentId.class,
              com.google.cloud.documentai.v1beta3.DocumentId.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.DocumentId.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRevisionRefFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsManagedDocIdBuilder_ != null) {
        gcsManagedDocIdBuilder_.clear();
      }
      if (unmanagedDocIdBuilder_ != null) {
        unmanagedDocIdBuilder_.clear();
      }
      revisionRef_ = null;
      if (revisionRefBuilder_ != null) {
        revisionRefBuilder_.dispose();
        revisionRefBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_DocumentId_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId build() {
      com.google.cloud.documentai.v1beta3.DocumentId result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId buildPartial() {
      com.google.cloud.documentai.v1beta3.DocumentId result =
          new com.google.cloud.documentai.v1beta3.DocumentId(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.DocumentId result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.revisionRef_ =
            revisionRefBuilder_ == null ? revisionRef_ : revisionRefBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.documentai.v1beta3.DocumentId result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 1 && gcsManagedDocIdBuilder_ != null) {
        result.type_ = gcsManagedDocIdBuilder_.build();
      }
      if (typeCase_ == 4 && unmanagedDocIdBuilder_ != null) {
        result.type_ = unmanagedDocIdBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.DocumentId) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.DocumentId) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.DocumentId other) {
      if (other == com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance()) return this;
      if (other.hasRevisionRef()) {
        mergeRevisionRef(other.getRevisionRef());
      }
      switch (other.getTypeCase()) {
        case GCS_MANAGED_DOC_ID:
          {
            mergeGcsManagedDocId(other.getGcsManagedDocId());
            break;
          }
        case UNMANAGED_DOC_ID:
          {
            mergeUnmanagedDocId(other.getUnmanagedDocId());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsManagedDocIdFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getRevisionRefFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUnmanagedDocIdFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder>
        gcsManagedDocIdBuilder_;
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     *
     * @return Whether the gcsManagedDocId field is set.
     */
    @java.lang.Override
    public boolean hasGcsManagedDocId() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     *
     * @return The gcsManagedDocId.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
        getGcsManagedDocId() {
      if (gcsManagedDocIdBuilder_ == null) {
        if (typeCase_ == 1) {
          return (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_;
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
            .getDefaultInstance();
      } else {
        if (typeCase_ == 1) {
          return gcsManagedDocIdBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    public Builder setGcsManagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId value) {
      if (gcsManagedDocIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        gcsManagedDocIdBuilder_.setMessage(value);
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    public Builder setGcsManagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder
            builderForValue) {
      if (gcsManagedDocIdBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        gcsManagedDocIdBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    public Builder mergeGcsManagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId value) {
      if (gcsManagedDocIdBuilder_ == null) {
        if (typeCase_ == 1
            && type_
                != com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
                    .getDefaultInstance()) {
          type_ =
              com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.newBuilder(
                      (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 1) {
          gcsManagedDocIdBuilder_.mergeFrom(value);
        } else {
          gcsManagedDocIdBuilder_.setMessage(value);
        }
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    public Builder clearGcsManagedDocId() {
      if (gcsManagedDocIdBuilder_ == null) {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
        }
        gcsManagedDocIdBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder
        getGcsManagedDocIdBuilder() {
      return getGcsManagedDocIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder
        getGcsManagedDocIdOrBuilder() {
      if ((typeCase_ == 1) && (gcsManagedDocIdBuilder_ != null)) {
        return gcsManagedDocIdBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 1) {
          return (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_;
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document id within user-managed Cloud Storage.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId gcs_managed_doc_id = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder>
        getGcsManagedDocIdFieldBuilder() {
      if (gcsManagedDocIdBuilder_ == null) {
        if (!(typeCase_ == 1)) {
          type_ =
              com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
                  .getDefaultInstance();
        }
        gcsManagedDocIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId,
                com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId.Builder,
                com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentIdOrBuilder>(
                (com.google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 1;
      onChanged();
      return gcsManagedDocIdBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder>
        unmanagedDocIdBuilder_;
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     *
     * @return Whether the unmanagedDocId field is set.
     */
    @java.lang.Override
    public boolean hasUnmanagedDocId() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     *
     * @return The unmanagedDocId.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId getUnmanagedDocId() {
      if (unmanagedDocIdBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_;
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
            .getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return unmanagedDocIdBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    public Builder setUnmanagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId value) {
      if (unmanagedDocIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        unmanagedDocIdBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    public Builder setUnmanagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder
            builderForValue) {
      if (unmanagedDocIdBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        unmanagedDocIdBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    public Builder mergeUnmanagedDocId(
        com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId value) {
      if (unmanagedDocIdBuilder_ == null) {
        if (typeCase_ == 4
            && type_
                != com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
                    .getDefaultInstance()) {
          type_ =
              com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.newBuilder(
                      (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          unmanagedDocIdBuilder_.mergeFrom(value);
        } else {
          unmanagedDocIdBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    public Builder clearUnmanagedDocId() {
      if (unmanagedDocIdBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        unmanagedDocIdBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder
        getUnmanagedDocIdBuilder() {
      return getUnmanagedDocIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder
        getUnmanagedDocIdOrBuilder() {
      if ((typeCase_ == 4) && (unmanagedDocIdBuilder_ != null)) {
        return unmanagedDocIdBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_;
        }
        return com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A document id within unmanaged dataset.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId unmanaged_doc_id = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId,
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder,
            com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder>
        getUnmanagedDocIdFieldBuilder() {
      if (unmanagedDocIdBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ =
              com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
                  .getDefaultInstance();
        }
        unmanagedDocIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId,
                com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId.Builder,
                com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentIdOrBuilder>(
                (com.google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return unmanagedDocIdBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.RevisionRef revisionRef_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RevisionRef,
            com.google.cloud.documentai.v1beta3.RevisionRef.Builder,
            com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder>
        revisionRefBuilder_;
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     *
     * @return Whether the revisionRef field is set.
     */
    public boolean hasRevisionRef() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     *
     * @return The revisionRef.
     */
    public com.google.cloud.documentai.v1beta3.RevisionRef getRevisionRef() {
      if (revisionRefBuilder_ == null) {
        return revisionRef_ == null
            ? com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance()
            : revisionRef_;
      } else {
        return revisionRefBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public Builder setRevisionRef(com.google.cloud.documentai.v1beta3.RevisionRef value) {
      if (revisionRefBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        revisionRef_ = value;
      } else {
        revisionRefBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public Builder setRevisionRef(
        com.google.cloud.documentai.v1beta3.RevisionRef.Builder builderForValue) {
      if (revisionRefBuilder_ == null) {
        revisionRef_ = builderForValue.build();
      } else {
        revisionRefBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public Builder mergeRevisionRef(com.google.cloud.documentai.v1beta3.RevisionRef value) {
      if (revisionRefBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && revisionRef_ != null
            && revisionRef_
                != com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance()) {
          getRevisionRefBuilder().mergeFrom(value);
        } else {
          revisionRef_ = value;
        }
      } else {
        revisionRefBuilder_.mergeFrom(value);
      }
      if (revisionRef_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public Builder clearRevisionRef() {
      bitField0_ = (bitField0_ & ~0x00000004);
      revisionRef_ = null;
      if (revisionRefBuilder_ != null) {
        revisionRefBuilder_.dispose();
        revisionRefBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public com.google.cloud.documentai.v1beta3.RevisionRef.Builder getRevisionRefBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRevisionRefFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    public com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder getRevisionRefOrBuilder() {
      if (revisionRefBuilder_ != null) {
        return revisionRefBuilder_.getMessageOrBuilder();
      } else {
        return revisionRef_ == null
            ? com.google.cloud.documentai.v1beta3.RevisionRef.getDefaultInstance()
            : revisionRef_;
      }
    }
    /**
     *
     *
     * <pre>
     * Points to a specific revision of the document if set.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.RevisionRef revision_ref = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.RevisionRef,
            com.google.cloud.documentai.v1beta3.RevisionRef.Builder,
            com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder>
        getRevisionRefFieldBuilder() {
      if (revisionRefBuilder_ == null) {
        revisionRefBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.RevisionRef,
                com.google.cloud.documentai.v1beta3.RevisionRef.Builder,
                com.google.cloud.documentai.v1beta3.RevisionRefOrBuilder>(
                getRevisionRef(), getParentForChildren(), isClean());
        revisionRef_ = null;
      }
      return revisionRefBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.DocumentId)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.DocumentId)
  private static final com.google.cloud.documentai.v1beta3.DocumentId DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.DocumentId();
  }

  public static com.google.cloud.documentai.v1beta3.DocumentId getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentId> PARSER =
      new com.google.protobuf.AbstractParser<DocumentId>() {
        @java.lang.Override
        public DocumentId parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentId> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentId> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentId getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
