/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Options for Process API
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions}
 */
public final class ProcessOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessOptions)
    ProcessOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ProcessOptions.newBuilder() to construct.
  private ProcessOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ProcessOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ProcessOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ProcessOptions.class,
            com.google.cloud.documentai.v1beta3.ProcessOptions.Builder.class);
  }

  public interface LayoutConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the chunkingConfig field is set.
     */
    boolean hasChunkingConfig();
    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The chunkingConfig.
     */
    com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
        getChunkingConfig();
    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfigOrBuilder
        getChunkingConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Serving config for layout parser processor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig}
   */
  public static final class LayoutConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)
      LayoutConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LayoutConfig.newBuilder() to construct.
    private LayoutConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LayoutConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LayoutConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.class,
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder.class);
    }

    public interface ChunkingConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The chunk sizes to use when splitting documents, in order of
       * level.
       * </pre>
       *
       * <code>int32 chunk_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The chunkSize.
       */
      int getChunkSize();

      /**
       *
       *
       * <pre>
       * Optional. Whether or not to include ancestor headings when splitting.
       * </pre>
       *
       * <code>bool include_ancestor_headings = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The includeAncestorHeadings.
       */
      boolean getIncludeAncestorHeadings();

      /**
       *
       *
       * <pre>
       * Optional. The number of tokens to group together when evaluating
       * semantic similarity.
       * </pre>
       *
       * <code>bool semantic_chunking_group_size = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The semanticChunkingGroupSize.
       */
      boolean getSemanticChunkingGroupSize();

      /**
       *
       *
       * <pre>
       * Optional. The percentile of cosine dissimilarity that must be exceeded
       * between a group of tokens and the next. The smaller this number is, the
       * more chunks will be generated.
       * </pre>
       *
       * <code>int32 breakpoint_percentile_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The breakpointPercentileThreshold.
       */
      int getBreakpointPercentileThreshold();
    }
    /**
     *
     *
     * <pre>
     * Serving config for chunking.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig}
     */
    public static final class ChunkingConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
        ChunkingConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ChunkingConfig.newBuilder() to construct.
      private ChunkingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ChunkingConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ChunkingConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_ChunkingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_ChunkingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                    .class,
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                    .Builder.class);
      }

      public static final int CHUNK_SIZE_FIELD_NUMBER = 1;
      private int chunkSize_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The chunk sizes to use when splitting documents, in order of
       * level.
       * </pre>
       *
       * <code>int32 chunk_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The chunkSize.
       */
      @java.lang.Override
      public int getChunkSize() {
        return chunkSize_;
      }

      public static final int INCLUDE_ANCESTOR_HEADINGS_FIELD_NUMBER = 2;
      private boolean includeAncestorHeadings_ = false;
      /**
       *
       *
       * <pre>
       * Optional. Whether or not to include ancestor headings when splitting.
       * </pre>
       *
       * <code>bool include_ancestor_headings = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The includeAncestorHeadings.
       */
      @java.lang.Override
      public boolean getIncludeAncestorHeadings() {
        return includeAncestorHeadings_;
      }

      public static final int SEMANTIC_CHUNKING_GROUP_SIZE_FIELD_NUMBER = 3;
      private boolean semanticChunkingGroupSize_ = false;
      /**
       *
       *
       * <pre>
       * Optional. The number of tokens to group together when evaluating
       * semantic similarity.
       * </pre>
       *
       * <code>bool semantic_chunking_group_size = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The semanticChunkingGroupSize.
       */
      @java.lang.Override
      public boolean getSemanticChunkingGroupSize() {
        return semanticChunkingGroupSize_;
      }

      public static final int BREAKPOINT_PERCENTILE_THRESHOLD_FIELD_NUMBER = 4;
      private int breakpointPercentileThreshold_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. The percentile of cosine dissimilarity that must be exceeded
       * between a group of tokens and the next. The smaller this number is, the
       * more chunks will be generated.
       * </pre>
       *
       * <code>int32 breakpoint_percentile_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The breakpointPercentileThreshold.
       */
      @java.lang.Override
      public int getBreakpointPercentileThreshold() {
        return breakpointPercentileThreshold_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (chunkSize_ != 0) {
          output.writeInt32(1, chunkSize_);
        }
        if (includeAncestorHeadings_ != false) {
          output.writeBool(2, includeAncestorHeadings_);
        }
        if (semanticChunkingGroupSize_ != false) {
          output.writeBool(3, semanticChunkingGroupSize_);
        }
        if (breakpointPercentileThreshold_ != 0) {
          output.writeInt32(4, breakpointPercentileThreshold_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (chunkSize_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, chunkSize_);
        }
        if (includeAncestorHeadings_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(2, includeAncestorHeadings_);
        }
        if (semanticChunkingGroupSize_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(3, semanticChunkingGroupSize_);
        }
        if (breakpointPercentileThreshold_ != 0) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  4, breakpointPercentileThreshold_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig other =
            (com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig) obj;

        if (getChunkSize() != other.getChunkSize()) return false;
        if (getIncludeAncestorHeadings() != other.getIncludeAncestorHeadings()) return false;
        if (getSemanticChunkingGroupSize() != other.getSemanticChunkingGroupSize()) return false;
        if (getBreakpointPercentileThreshold() != other.getBreakpointPercentileThreshold())
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + CHUNK_SIZE_FIELD_NUMBER;
        hash = (53 * hash) + getChunkSize();
        hash = (37 * hash) + INCLUDE_ANCESTOR_HEADINGS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeAncestorHeadings());
        hash = (37 * hash) + SEMANTIC_CHUNKING_GROUP_SIZE_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSemanticChunkingGroupSize());
        hash = (37 * hash) + BREAKPOINT_PERCENTILE_THRESHOLD_FIELD_NUMBER;
        hash = (53 * hash) + getBreakpointPercentileThreshold();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Serving config for chunking.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
              .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_ChunkingConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
              .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_ChunkingConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                      .class,
                  com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          chunkSize_ = 0;
          includeAncestorHeadings_ = false;
          semanticChunkingGroupSize_ = false;
          breakpointPercentileThreshold_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
              .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_ChunkingConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
            getDefaultInstanceForType() {
          return com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
            build() {
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
            buildPartial() {
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig result =
              new com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.chunkSize_ = chunkSize_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.includeAncestorHeadings_ = includeAncestorHeadings_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.semanticChunkingGroupSize_ = semanticChunkingGroupSize_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.breakpointPercentileThreshold_ = breakpointPercentileThreshold_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig) {
            return mergeFrom(
                (com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig other) {
          if (other
              == com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                  .getDefaultInstance()) return this;
          if (other.getChunkSize() != 0) {
            setChunkSize(other.getChunkSize());
          }
          if (other.getIncludeAncestorHeadings() != false) {
            setIncludeAncestorHeadings(other.getIncludeAncestorHeadings());
          }
          if (other.getSemanticChunkingGroupSize() != false) {
            setSemanticChunkingGroupSize(other.getSemanticChunkingGroupSize());
          }
          if (other.getBreakpointPercentileThreshold() != 0) {
            setBreakpointPercentileThreshold(other.getBreakpointPercentileThreshold());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    chunkSize_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    includeAncestorHeadings_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    semanticChunkingGroupSize_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    breakpointPercentileThreshold_ = input.readInt32();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int chunkSize_;
        /**
         *
         *
         * <pre>
         * Optional. The chunk sizes to use when splitting documents, in order of
         * level.
         * </pre>
         *
         * <code>int32 chunk_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The chunkSize.
         */
        @java.lang.Override
        public int getChunkSize() {
          return chunkSize_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The chunk sizes to use when splitting documents, in order of
         * level.
         * </pre>
         *
         * <code>int32 chunk_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The chunkSize to set.
         * @return This builder for chaining.
         */
        public Builder setChunkSize(int value) {

          chunkSize_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The chunk sizes to use when splitting documents, in order of
         * level.
         * </pre>
         *
         * <code>int32 chunk_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChunkSize() {
          bitField0_ = (bitField0_ & ~0x00000001);
          chunkSize_ = 0;
          onChanged();
          return this;
        }

        private boolean includeAncestorHeadings_;
        /**
         *
         *
         * <pre>
         * Optional. Whether or not to include ancestor headings when splitting.
         * </pre>
         *
         * <code>bool include_ancestor_headings = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The includeAncestorHeadings.
         */
        @java.lang.Override
        public boolean getIncludeAncestorHeadings() {
          return includeAncestorHeadings_;
        }
        /**
         *
         *
         * <pre>
         * Optional. Whether or not to include ancestor headings when splitting.
         * </pre>
         *
         * <code>bool include_ancestor_headings = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The includeAncestorHeadings to set.
         * @return This builder for chaining.
         */
        public Builder setIncludeAncestorHeadings(boolean value) {

          includeAncestorHeadings_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Whether or not to include ancestor headings when splitting.
         * </pre>
         *
         * <code>bool include_ancestor_headings = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIncludeAncestorHeadings() {
          bitField0_ = (bitField0_ & ~0x00000002);
          includeAncestorHeadings_ = false;
          onChanged();
          return this;
        }

        private boolean semanticChunkingGroupSize_;
        /**
         *
         *
         * <pre>
         * Optional. The number of tokens to group together when evaluating
         * semantic similarity.
         * </pre>
         *
         * <code>bool semantic_chunking_group_size = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The semanticChunkingGroupSize.
         */
        @java.lang.Override
        public boolean getSemanticChunkingGroupSize() {
          return semanticChunkingGroupSize_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The number of tokens to group together when evaluating
         * semantic similarity.
         * </pre>
         *
         * <code>bool semantic_chunking_group_size = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The semanticChunkingGroupSize to set.
         * @return This builder for chaining.
         */
        public Builder setSemanticChunkingGroupSize(boolean value) {

          semanticChunkingGroupSize_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The number of tokens to group together when evaluating
         * semantic similarity.
         * </pre>
         *
         * <code>bool semantic_chunking_group_size = 3 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSemanticChunkingGroupSize() {
          bitField0_ = (bitField0_ & ~0x00000004);
          semanticChunkingGroupSize_ = false;
          onChanged();
          return this;
        }

        private int breakpointPercentileThreshold_;
        /**
         *
         *
         * <pre>
         * Optional. The percentile of cosine dissimilarity that must be exceeded
         * between a group of tokens and the next. The smaller this number is, the
         * more chunks will be generated.
         * </pre>
         *
         * <code>
         * int32 breakpoint_percentile_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The breakpointPercentileThreshold.
         */
        @java.lang.Override
        public int getBreakpointPercentileThreshold() {
          return breakpointPercentileThreshold_;
        }
        /**
         *
         *
         * <pre>
         * Optional. The percentile of cosine dissimilarity that must be exceeded
         * between a group of tokens and the next. The smaller this number is, the
         * more chunks will be generated.
         * </pre>
         *
         * <code>
         * int32 breakpoint_percentile_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The breakpointPercentileThreshold to set.
         * @return This builder for chaining.
         */
        public Builder setBreakpointPercentileThreshold(int value) {

          breakpointPercentileThreshold_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The percentile of cosine dissimilarity that must be exceeded
         * between a group of tokens and the next. The smaller this number is, the
         * more chunks will be generated.
         * </pre>
         *
         * <code>
         * int32 breakpoint_percentile_threshold = 4 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearBreakpointPercentileThreshold() {
          bitField0_ = (bitField0_ & ~0x00000008);
          breakpointPercentileThreshold_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig)
      private static final com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
              .ChunkingConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig();
      }

      public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ChunkingConfig> PARSER =
          new com.google.protobuf.AbstractParser<ChunkingConfig>() {
            @java.lang.Override
            public ChunkingConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ChunkingConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ChunkingConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int CHUNKING_CONFIG_FIELD_NUMBER = 1;
    private com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
        chunkingConfig_;
    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the chunkingConfig field is set.
     */
    @java.lang.Override
    public boolean hasChunkingConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The chunkingConfig.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
        getChunkingConfig() {
      return chunkingConfig_ == null
          ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
              .getDefaultInstance()
          : chunkingConfig_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Config for chunking in layout parser processor.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfigOrBuilder
        getChunkingConfigOrBuilder() {
      return chunkingConfig_ == null
          ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
              .getDefaultInstance()
          : chunkingConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getChunkingConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getChunkingConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig other =
          (com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig) obj;

      if (hasChunkingConfig() != other.hasChunkingConfig()) return false;
      if (hasChunkingConfig()) {
        if (!getChunkingConfig().equals(other.getChunkingConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasChunkingConfig()) {
        hash = (37 * hash) + CHUNKING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getChunkingConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Serving config for layout parser processor.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.class,
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getChunkingConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        chunkingConfig_ = null;
        if (chunkingConfigBuilder_ != null) {
          chunkingConfigBuilder_.dispose();
          chunkingConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_LayoutConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig build() {
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig buildPartial() {
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig result =
            new com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.chunkingConfig_ =
              chunkingConfigBuilder_ == null ? chunkingConfig_ : chunkingConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig) {
          return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance())
          return this;
        if (other.hasChunkingConfig()) {
          mergeChunkingConfig(other.getChunkingConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getChunkingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          chunkingConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig,
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                  .Builder,
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
                  .ChunkingConfigOrBuilder>
          chunkingConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the chunkingConfig field is set.
       */
      public boolean hasChunkingConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The chunkingConfig.
       */
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
          getChunkingConfig() {
        if (chunkingConfigBuilder_ == null) {
          return chunkingConfig_ == null
              ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                  .getDefaultInstance()
              : chunkingConfig_;
        } else {
          return chunkingConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setChunkingConfig(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig value) {
        if (chunkingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          chunkingConfig_ = value;
        } else {
          chunkingConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setChunkingConfig(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig.Builder
              builderForValue) {
        if (chunkingConfigBuilder_ == null) {
          chunkingConfig_ = builderForValue.build();
        } else {
          chunkingConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeChunkingConfig(
          com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig value) {
        if (chunkingConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && chunkingConfig_ != null
              && chunkingConfig_
                  != com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                      .getDefaultInstance()) {
            getChunkingConfigBuilder().mergeFrom(value);
          } else {
            chunkingConfig_ = value;
          }
        } else {
          chunkingConfigBuilder_.mergeFrom(value);
        }
        if (chunkingConfig_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearChunkingConfig() {
        bitField0_ = (bitField0_ & ~0x00000001);
        chunkingConfig_ = null;
        if (chunkingConfigBuilder_ != null) {
          chunkingConfigBuilder_.dispose();
          chunkingConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig.Builder
          getChunkingConfigBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getChunkingConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfigOrBuilder
          getChunkingConfigOrBuilder() {
        if (chunkingConfigBuilder_ != null) {
          return chunkingConfigBuilder_.getMessageOrBuilder();
        } else {
          return chunkingConfig_ == null
              ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                  .getDefaultInstance()
              : chunkingConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Config for chunking in layout parser processor.
       * </pre>
       *
       * <code>
       * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig chunking_config = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig,
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                  .Builder,
              com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
                  .ChunkingConfigOrBuilder>
          getChunkingConfigFieldBuilder() {
        if (chunkingConfigBuilder_ == null) {
          chunkingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig,
                  com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.ChunkingConfig
                      .Builder,
                  com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
                      .ChunkingConfigOrBuilder>(
                  getChunkingConfig(), getParentForChildren(), isClean());
          chunkingConfig_ = null;
        }
        return chunkingConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig)
    private static final com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig();
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LayoutConfig> PARSER =
        new com.google.protobuf.AbstractParser<LayoutConfig>() {
          @java.lang.Override
          public LayoutConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LayoutConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LayoutConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IndividualPageSelectorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the pages.
     */
    java.util.List<java.lang.Integer> getPagesList();
    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of pages.
     */
    int getPagesCount();
    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The pages at the given index.
     */
    int getPages(int index);
  }
  /**
   *
   *
   * <pre>
   * A list of individual page numbers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector}
   */
  public static final class IndividualPageSelector extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
      IndividualPageSelectorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndividualPageSelector.newBuilder() to construct.
    private IndividualPageSelector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndividualPageSelector() {
      pages_ = emptyIntList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndividualPageSelector();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_IndividualPageSelector_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_IndividualPageSelector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.class,
              com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder
                  .class);
    }

    public static final int PAGES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.IntList pages_ = emptyIntList();
    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the pages.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getPagesList() {
      return pages_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of pages.
     */
    public int getPagesCount() {
      return pages_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Indices of the pages (starting from 1).
     * </pre>
     *
     * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The pages at the given index.
     */
    public int getPages(int index) {
      return pages_.getInt(index);
    }

    private int pagesMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getPagesList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(pagesMemoizedSerializedSize);
      }
      for (int i = 0; i < pages_.size(); i++) {
        output.writeInt32NoTag(pages_.getInt(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < pages_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(pages_.getInt(i));
        }
        size += dataSize;
        if (!getPagesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        pagesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector other =
          (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) obj;

      if (!getPagesList().equals(other.getPagesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPagesCount() > 0) {
        hash = (37 * hash) + PAGES_FIELD_NUMBER;
        hash = (53 * hash) + getPagesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A list of individual page numbers.
     * </pre>
     *
     * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_IndividualPageSelector_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_IndividualPageSelector_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.class,
                com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pages_ = emptyIntList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_IndividualPageSelector_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector build() {
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
          buildPartial() {
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector result =
            new com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          pages_.makeImmutable();
          result.pages_ = pages_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector other) {
        if (other
            == com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
                .getDefaultInstance()) return this;
        if (!other.pages_.isEmpty()) {
          if (pages_.isEmpty()) {
            pages_ = other.pages_;
            pages_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensurePagesIsMutable();
            pages_.addAll(other.pages_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int v = input.readInt32();
                  ensurePagesIsMutable();
                  pages_.addInt(v);
                  break;
                } // case 8
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensurePagesIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    pages_.addInt(input.readInt32());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.IntList pages_ = emptyIntList();

      private void ensurePagesIsMutable() {
        if (!pages_.isModifiable()) {
          pages_ = makeMutableCopy(pages_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the pages.
       */
      public java.util.List<java.lang.Integer> getPagesList() {
        pages_.makeImmutable();
        return pages_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of pages.
       */
      public int getPagesCount() {
        return pages_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The pages at the given index.
       */
      public int getPages(int index) {
        return pages_.getInt(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The pages to set.
       * @return This builder for chaining.
       */
      public Builder setPages(int index, int value) {

        ensurePagesIsMutable();
        pages_.setInt(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pages to add.
       * @return This builder for chaining.
       */
      public Builder addPages(int value) {

        ensurePagesIsMutable();
        pages_.addInt(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The pages to add.
       * @return This builder for chaining.
       */
      public Builder addAllPages(java.lang.Iterable<? extends java.lang.Integer> values) {
        ensurePagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pages_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indices of the pages (starting from 1).
       * </pre>
       *
       * <code>repeated int32 pages = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPages() {
        pages_ = emptyIntList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
    private static final com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector();
    }

    public static com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndividualPageSelector> PARSER =
        new com.google.protobuf.AbstractParser<IndividualPageSelector>() {
          @java.lang.Override
          public IndividualPageSelector parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndividualPageSelector> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndividualPageSelector> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int pageRangeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object pageRange_;

  public enum PageRangeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INDIVIDUAL_PAGE_SELECTOR(5),
    FROM_START(6),
    FROM_END(7),
    PAGERANGE_NOT_SET(0);
    private final int value;

    private PageRangeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PageRangeCase valueOf(int value) {
      return forNumber(value);
    }

    public static PageRangeCase forNumber(int value) {
      switch (value) {
        case 5:
          return INDIVIDUAL_PAGE_SELECTOR;
        case 6:
          return FROM_START;
        case 7:
          return FROM_END;
        case 0:
          return PAGERANGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PageRangeCase getPageRangeCase() {
    return PageRangeCase.forNumber(pageRangeCase_);
  }

  public static final int INDIVIDUAL_PAGE_SELECTOR_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Which pages to process (1-indexed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
   * </code>
   *
   * @return Whether the individualPageSelector field is set.
   */
  @java.lang.Override
  public boolean hasIndividualPageSelector() {
    return pageRangeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Which pages to process (1-indexed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
   * </code>
   *
   * @return The individualPageSelector.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
      getIndividualPageSelector() {
    if (pageRangeCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) pageRange_;
    }
    return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Which pages to process (1-indexed).
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder
      getIndividualPageSelectorOrBuilder() {
    if (pageRangeCase_ == 5) {
      return (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) pageRange_;
    }
    return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        .getDefaultInstance();
  }

  public static final int FROM_START_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Only process certain pages from the start. Process all if the document
   * has fewer pages.
   * </pre>
   *
   * <code>int32 from_start = 6;</code>
   *
   * @return Whether the fromStart field is set.
   */
  @java.lang.Override
  public boolean hasFromStart() {
    return pageRangeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Only process certain pages from the start. Process all if the document
   * has fewer pages.
   * </pre>
   *
   * <code>int32 from_start = 6;</code>
   *
   * @return The fromStart.
   */
  @java.lang.Override
  public int getFromStart() {
    if (pageRangeCase_ == 6) {
      return (java.lang.Integer) pageRange_;
    }
    return 0;
  }

  public static final int FROM_END_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Only process certain pages from the end, same as above.
   * </pre>
   *
   * <code>int32 from_end = 7;</code>
   *
   * @return Whether the fromEnd field is set.
   */
  @java.lang.Override
  public boolean hasFromEnd() {
    return pageRangeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Only process certain pages from the end, same as above.
   * </pre>
   *
   * <code>int32 from_end = 7;</code>
   *
   * @return The fromEnd.
   */
  @java.lang.Override
  public int getFromEnd() {
    if (pageRangeCase_ == 7) {
      return (java.lang.Integer) pageRange_;
    }
    return 0;
  }

  public static final int OCR_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta3.OcrConfig ocrConfig_;
  /**
   *
   *
   * <pre>
   * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
   *
   * @return Whether the ocrConfig field is set.
   */
  @java.lang.Override
  public boolean hasOcrConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
   *
   * @return The ocrConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfig getOcrConfig() {
    return ocrConfig_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()
        : ocrConfig_;
  }
  /**
   *
   *
   * <pre>
   * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder getOcrConfigOrBuilder() {
    return ocrConfig_ == null
        ? com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()
        : ocrConfig_;
  }

  public static final int LAYOUT_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layoutConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the layoutConfig field is set.
   */
  @java.lang.Override
  public boolean hasLayoutConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The layoutConfig.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig getLayoutConfig() {
    return layoutConfig_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance()
        : layoutConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
   * Returns error if set on other processor types.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder
      getLayoutConfigOrBuilder() {
    return layoutConfig_ == null
        ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance()
        : layoutConfig_;
  }

  public static final int SCHEMA_OVERRIDE_FIELD_NUMBER = 8;
  private com.google.cloud.documentai.v1beta3.DocumentSchema schemaOverride_;
  /**
   *
   *
   * <pre>
   * Optional. Override the schema of the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
   * return an Invalid Argument error if this field is set when the underlying
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * doesn't support schema override.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the schemaOverride field is set.
   */
  @java.lang.Override
  public boolean hasSchemaOverride() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Override the schema of the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
   * return an Invalid Argument error if this field is set when the underlying
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * doesn't support schema override.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The schemaOverride.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema getSchemaOverride() {
    return schemaOverride_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : schemaOverride_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Override the schema of the
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
   * return an Invalid Argument error if this field is set when the underlying
   * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
   * doesn't support schema override.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder getSchemaOverrideOrBuilder() {
    return schemaOverride_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : schemaOverride_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getOcrConfig());
    }
    if (pageRangeCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector) pageRange_);
    }
    if (pageRangeCase_ == 6) {
      output.writeInt32(6, (int) ((java.lang.Integer) pageRange_));
    }
    if (pageRangeCase_ == 7) {
      output.writeInt32(7, (int) ((java.lang.Integer) pageRange_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getSchemaOverride());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getLayoutConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOcrConfig());
    }
    if (pageRangeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
                  pageRange_);
    }
    if (pageRangeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              6, (int) ((java.lang.Integer) pageRange_));
    }
    if (pageRangeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              7, (int) ((java.lang.Integer) pageRange_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSchemaOverride());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLayoutConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ProcessOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ProcessOptions other =
        (com.google.cloud.documentai.v1beta3.ProcessOptions) obj;

    if (hasOcrConfig() != other.hasOcrConfig()) return false;
    if (hasOcrConfig()) {
      if (!getOcrConfig().equals(other.getOcrConfig())) return false;
    }
    if (hasLayoutConfig() != other.hasLayoutConfig()) return false;
    if (hasLayoutConfig()) {
      if (!getLayoutConfig().equals(other.getLayoutConfig())) return false;
    }
    if (hasSchemaOverride() != other.hasSchemaOverride()) return false;
    if (hasSchemaOverride()) {
      if (!getSchemaOverride().equals(other.getSchemaOverride())) return false;
    }
    if (!getPageRangeCase().equals(other.getPageRangeCase())) return false;
    switch (pageRangeCase_) {
      case 5:
        if (!getIndividualPageSelector().equals(other.getIndividualPageSelector())) return false;
        break;
      case 6:
        if (getFromStart() != other.getFromStart()) return false;
        break;
      case 7:
        if (getFromEnd() != other.getFromEnd()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOcrConfig()) {
      hash = (37 * hash) + OCR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOcrConfig().hashCode();
    }
    if (hasLayoutConfig()) {
      hash = (37 * hash) + LAYOUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLayoutConfig().hashCode();
    }
    if (hasSchemaOverride()) {
      hash = (37 * hash) + SCHEMA_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getSchemaOverride().hashCode();
    }
    switch (pageRangeCase_) {
      case 5:
        hash = (37 * hash) + INDIVIDUAL_PAGE_SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getIndividualPageSelector().hashCode();
        break;
      case 6:
        hash = (37 * hash) + FROM_START_FIELD_NUMBER;
        hash = (53 * hash) + getFromStart();
        break;
      case 7:
        hash = (37 * hash) + FROM_END_FIELD_NUMBER;
        hash = (53 * hash) + getFromEnd();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.documentai.v1beta3.ProcessOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options for Process API
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ProcessOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ProcessOptions)
      com.google.cloud.documentai.v1beta3.ProcessOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ProcessOptions.class,
              com.google.cloud.documentai.v1beta3.ProcessOptions.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ProcessOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getOcrConfigFieldBuilder();
        getLayoutConfigFieldBuilder();
        getSchemaOverrideFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (individualPageSelectorBuilder_ != null) {
        individualPageSelectorBuilder_.clear();
      }
      ocrConfig_ = null;
      if (ocrConfigBuilder_ != null) {
        ocrConfigBuilder_.dispose();
        ocrConfigBuilder_ = null;
      }
      layoutConfig_ = null;
      if (layoutConfigBuilder_ != null) {
        layoutConfigBuilder_.dispose();
        layoutConfigBuilder_ = null;
      }
      schemaOverride_ = null;
      if (schemaOverrideBuilder_ != null) {
        schemaOverrideBuilder_.dispose();
        schemaOverrideBuilder_ = null;
      }
      pageRangeCase_ = 0;
      pageRange_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ProcessOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions build() {
      com.google.cloud.documentai.v1beta3.ProcessOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions buildPartial() {
      com.google.cloud.documentai.v1beta3.ProcessOptions result =
          new com.google.cloud.documentai.v1beta3.ProcessOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ProcessOptions result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ocrConfig_ = ocrConfigBuilder_ == null ? ocrConfig_ : ocrConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.layoutConfig_ =
            layoutConfigBuilder_ == null ? layoutConfig_ : layoutConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.schemaOverride_ =
            schemaOverrideBuilder_ == null ? schemaOverride_ : schemaOverrideBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.documentai.v1beta3.ProcessOptions result) {
      result.pageRangeCase_ = pageRangeCase_;
      result.pageRange_ = this.pageRange_;
      if (pageRangeCase_ == 5 && individualPageSelectorBuilder_ != null) {
        result.pageRange_ = individualPageSelectorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ProcessOptions) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ProcessOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ProcessOptions other) {
      if (other == com.google.cloud.documentai.v1beta3.ProcessOptions.getDefaultInstance())
        return this;
      if (other.hasOcrConfig()) {
        mergeOcrConfig(other.getOcrConfig());
      }
      if (other.hasLayoutConfig()) {
        mergeLayoutConfig(other.getLayoutConfig());
      }
      if (other.hasSchemaOverride()) {
        mergeSchemaOverride(other.getSchemaOverride());
      }
      switch (other.getPageRangeCase()) {
        case INDIVIDUAL_PAGE_SELECTOR:
          {
            mergeIndividualPageSelector(other.getIndividualPageSelector());
            break;
          }
        case FROM_START:
          {
            setFromStart(other.getFromStart());
            break;
          }
        case FROM_END:
          {
            setFromEnd(other.getFromEnd());
            break;
          }
        case PAGERANGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOcrConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 42:
              {
                input.readMessage(
                    getIndividualPageSelectorFieldBuilder().getBuilder(), extensionRegistry);
                pageRangeCase_ = 5;
                break;
              } // case 42
            case 48:
              {
                pageRange_ = input.readInt32();
                pageRangeCase_ = 6;
                break;
              } // case 48
            case 56:
              {
                pageRange_ = input.readInt32();
                pageRangeCase_ = 7;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getSchemaOverrideFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getLayoutConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int pageRangeCase_ = 0;
    private java.lang.Object pageRange_;

    public PageRangeCase getPageRangeCase() {
      return PageRangeCase.forNumber(pageRangeCase_);
    }

    public Builder clearPageRange() {
      pageRangeCase_ = 0;
      pageRange_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector,
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder>
        individualPageSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     *
     * @return Whether the individualPageSelector field is set.
     */
    @java.lang.Override
    public boolean hasIndividualPageSelector() {
      return pageRangeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     *
     * @return The individualPageSelector.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
        getIndividualPageSelector() {
      if (individualPageSelectorBuilder_ == null) {
        if (pageRangeCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
              pageRange_;
        }
        return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
            .getDefaultInstance();
      } else {
        if (pageRangeCase_ == 5) {
          return individualPageSelectorBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    public Builder setIndividualPageSelector(
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector value) {
      if (individualPageSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageRange_ = value;
        onChanged();
      } else {
        individualPageSelectorBuilder_.setMessage(value);
      }
      pageRangeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    public Builder setIndividualPageSelector(
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder
            builderForValue) {
      if (individualPageSelectorBuilder_ == null) {
        pageRange_ = builderForValue.build();
        onChanged();
      } else {
        individualPageSelectorBuilder_.setMessage(builderForValue.build());
      }
      pageRangeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    public Builder mergeIndividualPageSelector(
        com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector value) {
      if (individualPageSelectorBuilder_ == null) {
        if (pageRangeCase_ == 5
            && pageRange_
                != com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
                    .getDefaultInstance()) {
          pageRange_ =
              com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.newBuilder(
                      (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
                          pageRange_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pageRange_ = value;
        }
        onChanged();
      } else {
        if (pageRangeCase_ == 5) {
          individualPageSelectorBuilder_.mergeFrom(value);
        } else {
          individualPageSelectorBuilder_.setMessage(value);
        }
      }
      pageRangeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    public Builder clearIndividualPageSelector() {
      if (individualPageSelectorBuilder_ == null) {
        if (pageRangeCase_ == 5) {
          pageRangeCase_ = 0;
          pageRange_ = null;
          onChanged();
        }
      } else {
        if (pageRangeCase_ == 5) {
          pageRangeCase_ = 0;
          pageRange_ = null;
        }
        individualPageSelectorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder
        getIndividualPageSelectorBuilder() {
      return getIndividualPageSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder
        getIndividualPageSelectorOrBuilder() {
      if ((pageRangeCase_ == 5) && (individualPageSelectorBuilder_ != null)) {
        return individualPageSelectorBuilder_.getMessageOrBuilder();
      } else {
        if (pageRangeCase_ == 5) {
          return (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
              pageRange_;
        }
        return com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Which pages to process (1-indexed).
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector individual_page_selector = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector,
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder>
        getIndividualPageSelectorFieldBuilder() {
      if (individualPageSelectorBuilder_ == null) {
        if (!(pageRangeCase_ == 5)) {
          pageRange_ =
              com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector
                  .getDefaultInstance();
        }
        individualPageSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector,
                com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector.Builder,
                com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelectorOrBuilder>(
                (com.google.cloud.documentai.v1beta3.ProcessOptions.IndividualPageSelector)
                    pageRange_,
                getParentForChildren(),
                isClean());
        pageRange_ = null;
      }
      pageRangeCase_ = 5;
      onChanged();
      return individualPageSelectorBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Only process certain pages from the start. Process all if the document
     * has fewer pages.
     * </pre>
     *
     * <code>int32 from_start = 6;</code>
     *
     * @return Whether the fromStart field is set.
     */
    public boolean hasFromStart() {
      return pageRangeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the start. Process all if the document
     * has fewer pages.
     * </pre>
     *
     * <code>int32 from_start = 6;</code>
     *
     * @return The fromStart.
     */
    public int getFromStart() {
      if (pageRangeCase_ == 6) {
        return (java.lang.Integer) pageRange_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the start. Process all if the document
     * has fewer pages.
     * </pre>
     *
     * <code>int32 from_start = 6;</code>
     *
     * @param value The fromStart to set.
     * @return This builder for chaining.
     */
    public Builder setFromStart(int value) {

      pageRangeCase_ = 6;
      pageRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the start. Process all if the document
     * has fewer pages.
     * </pre>
     *
     * <code>int32 from_start = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFromStart() {
      if (pageRangeCase_ == 6) {
        pageRangeCase_ = 0;
        pageRange_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Only process certain pages from the end, same as above.
     * </pre>
     *
     * <code>int32 from_end = 7;</code>
     *
     * @return Whether the fromEnd field is set.
     */
    public boolean hasFromEnd() {
      return pageRangeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the end, same as above.
     * </pre>
     *
     * <code>int32 from_end = 7;</code>
     *
     * @return The fromEnd.
     */
    public int getFromEnd() {
      if (pageRangeCase_ == 7) {
        return (java.lang.Integer) pageRange_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the end, same as above.
     * </pre>
     *
     * <code>int32 from_end = 7;</code>
     *
     * @param value The fromEnd to set.
     * @return This builder for chaining.
     */
    public Builder setFromEnd(int value) {

      pageRangeCase_ = 7;
      pageRange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only process certain pages from the end, same as above.
     * </pre>
     *
     * <code>int32 from_end = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFromEnd() {
      if (pageRangeCase_ == 7) {
        pageRangeCase_ = 0;
        pageRange_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.cloud.documentai.v1beta3.OcrConfig ocrConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig,
            com.google.cloud.documentai.v1beta3.OcrConfig.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder>
        ocrConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     *
     * @return Whether the ocrConfig field is set.
     */
    public boolean hasOcrConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     *
     * @return The ocrConfig.
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig getOcrConfig() {
      if (ocrConfigBuilder_ == null) {
        return ocrConfig_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()
            : ocrConfig_;
      } else {
        return ocrConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public Builder setOcrConfig(com.google.cloud.documentai.v1beta3.OcrConfig value) {
      if (ocrConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ocrConfig_ = value;
      } else {
        ocrConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public Builder setOcrConfig(
        com.google.cloud.documentai.v1beta3.OcrConfig.Builder builderForValue) {
      if (ocrConfigBuilder_ == null) {
        ocrConfig_ = builderForValue.build();
      } else {
        ocrConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public Builder mergeOcrConfig(com.google.cloud.documentai.v1beta3.OcrConfig value) {
      if (ocrConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ocrConfig_ != null
            && ocrConfig_ != com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()) {
          getOcrConfigBuilder().mergeFrom(value);
        } else {
          ocrConfig_ = value;
        }
      } else {
        ocrConfigBuilder_.mergeFrom(value);
      }
      if (ocrConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public Builder clearOcrConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ocrConfig_ = null;
      if (ocrConfigBuilder_ != null) {
        ocrConfigBuilder_.dispose();
        ocrConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfig.Builder getOcrConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOcrConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder getOcrConfigOrBuilder() {
      if (ocrConfigBuilder_ != null) {
        return ocrConfigBuilder_.getMessageOrBuilder();
      } else {
        return ocrConfig_ == null
            ? com.google.cloud.documentai.v1beta3.OcrConfig.getDefaultInstance()
            : ocrConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.OcrConfig ocr_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.OcrConfig,
            com.google.cloud.documentai.v1beta3.OcrConfig.Builder,
            com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder>
        getOcrConfigFieldBuilder() {
      if (ocrConfigBuilder_ == null) {
        ocrConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.OcrConfig,
                com.google.cloud.documentai.v1beta3.OcrConfig.Builder,
                com.google.cloud.documentai.v1beta3.OcrConfigOrBuilder>(
                getOcrConfig(), getParentForChildren(), isClean());
        ocrConfig_ = null;
      }
      return ocrConfigBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layoutConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig,
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder>
        layoutConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the layoutConfig field is set.
     */
    public boolean hasLayoutConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The layoutConfig.
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig getLayoutConfig() {
      if (layoutConfigBuilder_ == null) {
        return layoutConfig_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance()
            : layoutConfig_;
      } else {
        return layoutConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLayoutConfig(
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig value) {
      if (layoutConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        layoutConfig_ = value;
      } else {
        layoutConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLayoutConfig(
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder builderForValue) {
      if (layoutConfigBuilder_ == null) {
        layoutConfig_ = builderForValue.build();
      } else {
        layoutConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLayoutConfig(
        com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig value) {
      if (layoutConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && layoutConfig_ != null
            && layoutConfig_
                != com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig
                    .getDefaultInstance()) {
          getLayoutConfigBuilder().mergeFrom(value);
        } else {
          layoutConfig_ = value;
        }
      } else {
        layoutConfigBuilder_.mergeFrom(value);
      }
      if (layoutConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLayoutConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      layoutConfig_ = null;
      if (layoutConfigBuilder_ != null) {
        layoutConfigBuilder_.dispose();
        layoutConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder
        getLayoutConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLayoutConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder
        getLayoutConfigOrBuilder() {
      if (layoutConfigBuilder_ != null) {
        return layoutConfigBuilder_.getMessageOrBuilder();
      } else {
        return layoutConfig_ == null
            ? com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.getDefaultInstance()
            : layoutConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
     * Returns error if set on other processor types.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig layout_config = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig,
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder,
            com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder>
        getLayoutConfigFieldBuilder() {
      if (layoutConfigBuilder_ == null) {
        layoutConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig,
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfig.Builder,
                com.google.cloud.documentai.v1beta3.ProcessOptions.LayoutConfigOrBuilder>(
                getLayoutConfig(), getParentForChildren(), isClean());
        layoutConfig_ = null;
      }
      return layoutConfigBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.DocumentSchema schemaOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        schemaOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the schemaOverride field is set.
     */
    public boolean hasSchemaOverride() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The schemaOverride.
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema getSchemaOverride() {
      if (schemaOverrideBuilder_ == null) {
        return schemaOverride_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : schemaOverride_;
      } else {
        return schemaOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSchemaOverride(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (schemaOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schemaOverride_ = value;
      } else {
        schemaOverrideBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSchemaOverride(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Builder builderForValue) {
      if (schemaOverrideBuilder_ == null) {
        schemaOverride_ = builderForValue.build();
      } else {
        schemaOverrideBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSchemaOverride(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (schemaOverrideBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && schemaOverride_ != null
            && schemaOverride_
                != com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()) {
          getSchemaOverrideBuilder().mergeFrom(value);
        } else {
          schemaOverride_ = value;
        }
      } else {
        schemaOverrideBuilder_.mergeFrom(value);
      }
      if (schemaOverride_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSchemaOverride() {
      bitField0_ = (bitField0_ & ~0x00000020);
      schemaOverride_ = null;
      if (schemaOverrideBuilder_ != null) {
        schemaOverrideBuilder_.dispose();
        schemaOverrideBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Builder getSchemaOverrideBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSchemaOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder
        getSchemaOverrideOrBuilder() {
      if (schemaOverrideBuilder_ != null) {
        return schemaOverrideBuilder_.getMessageOrBuilder();
      } else {
        return schemaOverride_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : schemaOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Override the schema of the
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]. Will
     * return an Invalid Argument error if this field is set when the underlying
     * [ProcessorVersion][google.cloud.documentai.v1beta3.ProcessorVersion]
     * doesn't support schema override.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.DocumentSchema schema_override = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        getSchemaOverrideFieldBuilder() {
      if (schemaOverrideBuilder_ == null) {
        schemaOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentSchema,
                com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
                com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>(
                getSchemaOverride(), getParentForChildren(), isClean());
        schemaOverride_ = null;
      }
      return schemaOverrideBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ProcessOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ProcessOptions)
  private static final com.google.cloud.documentai.v1beta3.ProcessOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ProcessOptions();
  }

  public static com.google.cloud.documentai.v1beta3.ProcessOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProcessOptions> PARSER =
      new com.google.protobuf.AbstractParser<ProcessOptions>() {
        @java.lang.Override
        public ProcessOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ProcessOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProcessOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ProcessOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
