/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * The metadata that represents a processor version being created.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata}
 */
public final class TrainProcessorVersionMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata)
    TrainProcessorVersionMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TrainProcessorVersionMetadata.newBuilder() to construct.
  private TrainProcessorVersionMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TrainProcessorVersionMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TrainProcessorVersionMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.class,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.Builder.class);
  }

  public interface DatasetValidationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The total number of document errors.
     * </pre>
     *
     * <code>int32 document_error_count = 3;</code>
     *
     * @return The documentErrorCount.
     */
    int getDocumentErrorCount();

    /**
     *
     *
     * <pre>
     * The total number of dataset errors.
     * </pre>
     *
     * <code>int32 dataset_error_count = 4;</code>
     *
     * @return The datasetErrorCount.
     */
    int getDatasetErrorCount();

    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    java.util.List<com.google.rpc.Status> getDocumentErrorsList();
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    com.google.rpc.Status getDocumentErrors(int index);
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    int getDocumentErrorsCount();
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    java.util.List<? extends com.google.rpc.StatusOrBuilder> getDocumentErrorsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    com.google.rpc.StatusOrBuilder getDocumentErrorsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    java.util.List<com.google.rpc.Status> getDatasetErrorsList();
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    com.google.rpc.Status getDatasetErrors(int index);
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    int getDatasetErrorsCount();
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    java.util.List<? extends com.google.rpc.StatusOrBuilder> getDatasetErrorsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getDatasetErrorsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The dataset validation information.
   * This includes any and all errors with documents and the dataset.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation}
   */
  public static final class DatasetValidation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
      DatasetValidationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DatasetValidation.newBuilder() to construct.
    private DatasetValidation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DatasetValidation() {
      documentErrors_ = java.util.Collections.emptyList();
      datasetErrors_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DatasetValidation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_DatasetValidation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_DatasetValidation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                  .class,
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                  .Builder.class);
    }

    public static final int DOCUMENT_ERROR_COUNT_FIELD_NUMBER = 3;
    private int documentErrorCount_ = 0;
    /**
     *
     *
     * <pre>
     * The total number of document errors.
     * </pre>
     *
     * <code>int32 document_error_count = 3;</code>
     *
     * @return The documentErrorCount.
     */
    @java.lang.Override
    public int getDocumentErrorCount() {
      return documentErrorCount_;
    }

    public static final int DATASET_ERROR_COUNT_FIELD_NUMBER = 4;
    private int datasetErrorCount_ = 0;
    /**
     *
     *
     * <pre>
     * The total number of dataset errors.
     * </pre>
     *
     * <code>int32 dataset_error_count = 4;</code>
     *
     * @return The datasetErrorCount.
     */
    @java.lang.Override
    public int getDatasetErrorCount() {
      return datasetErrorCount_;
    }

    public static final int DOCUMENT_ERRORS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.rpc.Status> documentErrors_;
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.rpc.Status> getDocumentErrorsList() {
      return documentErrors_;
    }
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getDocumentErrorsOrBuilderList() {
      return documentErrors_;
    }
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    @java.lang.Override
    public int getDocumentErrorsCount() {
      return documentErrors_.size();
    }
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    @java.lang.Override
    public com.google.rpc.Status getDocumentErrors(int index) {
      return documentErrors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Error information pertaining to specific documents. A maximum of 10
     * document errors will be returned.
     * Any document with errors will not be used throughout training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status document_errors = 1;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getDocumentErrorsOrBuilder(int index) {
      return documentErrors_.get(index);
    }

    public static final int DATASET_ERRORS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.rpc.Status> datasetErrors_;
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.rpc.Status> getDatasetErrorsList() {
      return datasetErrors_;
    }
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getDatasetErrorsOrBuilderList() {
      return datasetErrors_;
    }
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    @java.lang.Override
    public int getDatasetErrorsCount() {
      return datasetErrors_.size();
    }
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.Status getDatasetErrors(int index) {
      return datasetErrors_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Error information for the dataset as a whole. A maximum of 10 dataset
     * errors will be returned.
     * A single dataset error is terminal for training.
     * </pre>
     *
     * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getDatasetErrorsOrBuilder(int index) {
      return datasetErrors_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < documentErrors_.size(); i++) {
        output.writeMessage(1, documentErrors_.get(i));
      }
      for (int i = 0; i < datasetErrors_.size(); i++) {
        output.writeMessage(2, datasetErrors_.get(i));
      }
      if (documentErrorCount_ != 0) {
        output.writeInt32(3, documentErrorCount_);
      }
      if (datasetErrorCount_ != 0) {
        output.writeInt32(4, datasetErrorCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documentErrors_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, documentErrors_.get(i));
      }
      for (int i = 0; i < datasetErrors_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, datasetErrors_.get(i));
      }
      if (documentErrorCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, documentErrorCount_);
      }
      if (datasetErrorCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, datasetErrorCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation other =
          (com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation) obj;

      if (getDocumentErrorCount() != other.getDocumentErrorCount()) return false;
      if (getDatasetErrorCount() != other.getDatasetErrorCount()) return false;
      if (!getDocumentErrorsList().equals(other.getDocumentErrorsList())) return false;
      if (!getDatasetErrorsList().equals(other.getDatasetErrorsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOCUMENT_ERROR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentErrorCount();
      hash = (37 * hash) + DATASET_ERROR_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetErrorCount();
      if (getDocumentErrorsCount() > 0) {
        hash = (37 * hash) + DOCUMENT_ERRORS_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentErrorsList().hashCode();
      }
      if (getDatasetErrorsCount() > 0) {
        hash = (37 * hash) + DATASET_ERRORS_FIELD_NUMBER;
        hash = (53 * hash) + getDatasetErrorsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The dataset validation information.
     * This includes any and all errors with documents and the dataset.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_DatasetValidation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_DatasetValidation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                    .class,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        documentErrorCount_ = 0;
        datasetErrorCount_ = 0;
        if (documentErrorsBuilder_ == null) {
          documentErrors_ = java.util.Collections.emptyList();
        } else {
          documentErrors_ = null;
          documentErrorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (datasetErrorsBuilder_ == null) {
          datasetErrors_ = java.util.Collections.emptyList();
        } else {
          datasetErrors_ = null;
          datasetErrorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
            .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_DatasetValidation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
          build() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
          buildPartial() {
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation result =
            new com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
              result) {
        if (documentErrorsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            documentErrors_ = java.util.Collections.unmodifiableList(documentErrors_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.documentErrors_ = documentErrors_;
        } else {
          result.documentErrors_ = documentErrorsBuilder_.build();
        }
        if (datasetErrorsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            datasetErrors_ = java.util.Collections.unmodifiableList(datasetErrors_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.datasetErrors_ = datasetErrors_;
        } else {
          result.datasetErrors_ = datasetErrorsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.documentErrorCount_ = documentErrorCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datasetErrorCount_ = datasetErrorCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
              other) {
        if (other
            == com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .getDefaultInstance()) return this;
        if (other.getDocumentErrorCount() != 0) {
          setDocumentErrorCount(other.getDocumentErrorCount());
        }
        if (other.getDatasetErrorCount() != 0) {
          setDatasetErrorCount(other.getDatasetErrorCount());
        }
        if (documentErrorsBuilder_ == null) {
          if (!other.documentErrors_.isEmpty()) {
            if (documentErrors_.isEmpty()) {
              documentErrors_ = other.documentErrors_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDocumentErrorsIsMutable();
              documentErrors_.addAll(other.documentErrors_);
            }
            onChanged();
          }
        } else {
          if (!other.documentErrors_.isEmpty()) {
            if (documentErrorsBuilder_.isEmpty()) {
              documentErrorsBuilder_.dispose();
              documentErrorsBuilder_ = null;
              documentErrors_ = other.documentErrors_;
              bitField0_ = (bitField0_ & ~0x00000004);
              documentErrorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDocumentErrorsFieldBuilder()
                      : null;
            } else {
              documentErrorsBuilder_.addAllMessages(other.documentErrors_);
            }
          }
        }
        if (datasetErrorsBuilder_ == null) {
          if (!other.datasetErrors_.isEmpty()) {
            if (datasetErrors_.isEmpty()) {
              datasetErrors_ = other.datasetErrors_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureDatasetErrorsIsMutable();
              datasetErrors_.addAll(other.datasetErrors_);
            }
            onChanged();
          }
        } else {
          if (!other.datasetErrors_.isEmpty()) {
            if (datasetErrorsBuilder_.isEmpty()) {
              datasetErrorsBuilder_.dispose();
              datasetErrorsBuilder_ = null;
              datasetErrors_ = other.datasetErrors_;
              bitField0_ = (bitField0_ & ~0x00000008);
              datasetErrorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDatasetErrorsFieldBuilder()
                      : null;
            } else {
              datasetErrorsBuilder_.addAllMessages(other.datasetErrors_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.rpc.Status m =
                      input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                  if (documentErrorsBuilder_ == null) {
                    ensureDocumentErrorsIsMutable();
                    documentErrors_.add(m);
                  } else {
                    documentErrorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.rpc.Status m =
                      input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                  if (datasetErrorsBuilder_ == null) {
                    ensureDatasetErrorsIsMutable();
                    datasetErrors_.add(m);
                  } else {
                    datasetErrorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  documentErrorCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 24
              case 32:
                {
                  datasetErrorCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int documentErrorCount_;
      /**
       *
       *
       * <pre>
       * The total number of document errors.
       * </pre>
       *
       * <code>int32 document_error_count = 3;</code>
       *
       * @return The documentErrorCount.
       */
      @java.lang.Override
      public int getDocumentErrorCount() {
        return documentErrorCount_;
      }
      /**
       *
       *
       * <pre>
       * The total number of document errors.
       * </pre>
       *
       * <code>int32 document_error_count = 3;</code>
       *
       * @param value The documentErrorCount to set.
       * @return This builder for chaining.
       */
      public Builder setDocumentErrorCount(int value) {

        documentErrorCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of document errors.
       * </pre>
       *
       * <code>int32 document_error_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocumentErrorCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        documentErrorCount_ = 0;
        onChanged();
        return this;
      }

      private int datasetErrorCount_;
      /**
       *
       *
       * <pre>
       * The total number of dataset errors.
       * </pre>
       *
       * <code>int32 dataset_error_count = 4;</code>
       *
       * @return The datasetErrorCount.
       */
      @java.lang.Override
      public int getDatasetErrorCount() {
        return datasetErrorCount_;
      }
      /**
       *
       *
       * <pre>
       * The total number of dataset errors.
       * </pre>
       *
       * <code>int32 dataset_error_count = 4;</code>
       *
       * @param value The datasetErrorCount to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetErrorCount(int value) {

        datasetErrorCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total number of dataset errors.
       * </pre>
       *
       * <code>int32 dataset_error_count = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetErrorCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        datasetErrorCount_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.rpc.Status> documentErrors_ =
          java.util.Collections.emptyList();

      private void ensureDocumentErrorsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          documentErrors_ = new java.util.ArrayList<com.google.rpc.Status>(documentErrors_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          documentErrorsBuilder_;

      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public java.util.List<com.google.rpc.Status> getDocumentErrorsList() {
        if (documentErrorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documentErrors_);
        } else {
          return documentErrorsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public int getDocumentErrorsCount() {
        if (documentErrorsBuilder_ == null) {
          return documentErrors_.size();
        } else {
          return documentErrorsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public com.google.rpc.Status getDocumentErrors(int index) {
        if (documentErrorsBuilder_ == null) {
          return documentErrors_.get(index);
        } else {
          return documentErrorsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder setDocumentErrors(int index, com.google.rpc.Status value) {
        if (documentErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentErrorsIsMutable();
          documentErrors_.set(index, value);
          onChanged();
        } else {
          documentErrorsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder setDocumentErrors(int index, com.google.rpc.Status.Builder builderForValue) {
        if (documentErrorsBuilder_ == null) {
          ensureDocumentErrorsIsMutable();
          documentErrors_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentErrorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder addDocumentErrors(com.google.rpc.Status value) {
        if (documentErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentErrorsIsMutable();
          documentErrors_.add(value);
          onChanged();
        } else {
          documentErrorsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder addDocumentErrors(int index, com.google.rpc.Status value) {
        if (documentErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentErrorsIsMutable();
          documentErrors_.add(index, value);
          onChanged();
        } else {
          documentErrorsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder addDocumentErrors(com.google.rpc.Status.Builder builderForValue) {
        if (documentErrorsBuilder_ == null) {
          ensureDocumentErrorsIsMutable();
          documentErrors_.add(builderForValue.build());
          onChanged();
        } else {
          documentErrorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder addDocumentErrors(int index, com.google.rpc.Status.Builder builderForValue) {
        if (documentErrorsBuilder_ == null) {
          ensureDocumentErrorsIsMutable();
          documentErrors_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentErrorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder addAllDocumentErrors(
          java.lang.Iterable<? extends com.google.rpc.Status> values) {
        if (documentErrorsBuilder_ == null) {
          ensureDocumentErrorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentErrors_);
          onChanged();
        } else {
          documentErrorsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder clearDocumentErrors() {
        if (documentErrorsBuilder_ == null) {
          documentErrors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          documentErrorsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public Builder removeDocumentErrors(int index) {
        if (documentErrorsBuilder_ == null) {
          ensureDocumentErrorsIsMutable();
          documentErrors_.remove(index);
          onChanged();
        } else {
          documentErrorsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public com.google.rpc.Status.Builder getDocumentErrorsBuilder(int index) {
        return getDocumentErrorsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public com.google.rpc.StatusOrBuilder getDocumentErrorsOrBuilder(int index) {
        if (documentErrorsBuilder_ == null) {
          return documentErrors_.get(index);
        } else {
          return documentErrorsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public java.util.List<? extends com.google.rpc.StatusOrBuilder>
          getDocumentErrorsOrBuilderList() {
        if (documentErrorsBuilder_ != null) {
          return documentErrorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documentErrors_);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public com.google.rpc.Status.Builder addDocumentErrorsBuilder() {
        return getDocumentErrorsFieldBuilder()
            .addBuilder(com.google.rpc.Status.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public com.google.rpc.Status.Builder addDocumentErrorsBuilder(int index) {
        return getDocumentErrorsFieldBuilder()
            .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Error information pertaining to specific documents. A maximum of 10
       * document errors will be returned.
       * Any document with errors will not be used throughout training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status document_errors = 1;</code>
       */
      public java.util.List<com.google.rpc.Status.Builder> getDocumentErrorsBuilderList() {
        return getDocumentErrorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getDocumentErrorsFieldBuilder() {
        if (documentErrorsBuilder_ == null) {
          documentErrorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  documentErrors_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          documentErrors_ = null;
        }
        return documentErrorsBuilder_;
      }

      private java.util.List<com.google.rpc.Status> datasetErrors_ =
          java.util.Collections.emptyList();

      private void ensureDatasetErrorsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          datasetErrors_ = new java.util.ArrayList<com.google.rpc.Status>(datasetErrors_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          datasetErrorsBuilder_;

      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public java.util.List<com.google.rpc.Status> getDatasetErrorsList() {
        if (datasetErrorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(datasetErrors_);
        } else {
          return datasetErrorsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public int getDatasetErrorsCount() {
        if (datasetErrorsBuilder_ == null) {
          return datasetErrors_.size();
        } else {
          return datasetErrorsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public com.google.rpc.Status getDatasetErrors(int index) {
        if (datasetErrorsBuilder_ == null) {
          return datasetErrors_.get(index);
        } else {
          return datasetErrorsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder setDatasetErrors(int index, com.google.rpc.Status value) {
        if (datasetErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDatasetErrorsIsMutable();
          datasetErrors_.set(index, value);
          onChanged();
        } else {
          datasetErrorsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder setDatasetErrors(int index, com.google.rpc.Status.Builder builderForValue) {
        if (datasetErrorsBuilder_ == null) {
          ensureDatasetErrorsIsMutable();
          datasetErrors_.set(index, builderForValue.build());
          onChanged();
        } else {
          datasetErrorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder addDatasetErrors(com.google.rpc.Status value) {
        if (datasetErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDatasetErrorsIsMutable();
          datasetErrors_.add(value);
          onChanged();
        } else {
          datasetErrorsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder addDatasetErrors(int index, com.google.rpc.Status value) {
        if (datasetErrorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDatasetErrorsIsMutable();
          datasetErrors_.add(index, value);
          onChanged();
        } else {
          datasetErrorsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder addDatasetErrors(com.google.rpc.Status.Builder builderForValue) {
        if (datasetErrorsBuilder_ == null) {
          ensureDatasetErrorsIsMutable();
          datasetErrors_.add(builderForValue.build());
          onChanged();
        } else {
          datasetErrorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder addDatasetErrors(int index, com.google.rpc.Status.Builder builderForValue) {
        if (datasetErrorsBuilder_ == null) {
          ensureDatasetErrorsIsMutable();
          datasetErrors_.add(index, builderForValue.build());
          onChanged();
        } else {
          datasetErrorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder addAllDatasetErrors(
          java.lang.Iterable<? extends com.google.rpc.Status> values) {
        if (datasetErrorsBuilder_ == null) {
          ensureDatasetErrorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, datasetErrors_);
          onChanged();
        } else {
          datasetErrorsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder clearDatasetErrors() {
        if (datasetErrorsBuilder_ == null) {
          datasetErrors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          datasetErrorsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public Builder removeDatasetErrors(int index) {
        if (datasetErrorsBuilder_ == null) {
          ensureDatasetErrorsIsMutable();
          datasetErrors_.remove(index);
          onChanged();
        } else {
          datasetErrorsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public com.google.rpc.Status.Builder getDatasetErrorsBuilder(int index) {
        return getDatasetErrorsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getDatasetErrorsOrBuilder(int index) {
        if (datasetErrorsBuilder_ == null) {
          return datasetErrors_.get(index);
        } else {
          return datasetErrorsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public java.util.List<? extends com.google.rpc.StatusOrBuilder>
          getDatasetErrorsOrBuilderList() {
        if (datasetErrorsBuilder_ != null) {
          return datasetErrorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(datasetErrors_);
        }
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public com.google.rpc.Status.Builder addDatasetErrorsBuilder() {
        return getDatasetErrorsFieldBuilder()
            .addBuilder(com.google.rpc.Status.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public com.google.rpc.Status.Builder addDatasetErrorsBuilder(int index) {
        return getDatasetErrorsFieldBuilder()
            .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Error information for the dataset as a whole. A maximum of 10 dataset
       * errors will be returned.
       * A single dataset error is terminal for training.
       * </pre>
       *
       * <code>repeated .google.rpc.Status dataset_errors = 2;</code>
       */
      public java.util.List<com.google.rpc.Status.Builder> getDatasetErrorsBuilderList() {
        return getDatasetErrorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getDatasetErrorsFieldBuilder() {
        if (datasetErrorsBuilder_ == null) {
          datasetErrorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(
                  datasetErrors_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          datasetErrors_ = null;
        }
        return datasetErrorsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation)
    private static final com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation();
    }

    public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatasetValidation> PARSER =
        new com.google.protobuf.AbstractParser<DatasetValidation>() {
          @java.lang.Override
          public DatasetValidation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DatasetValidation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatasetValidation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int COMMON_METADATA_FIELD_NUMBER = 1;
  private com.google.cloud.documentai.v1beta3.CommonOperationMetadata commonMetadata_;
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   *
   * @return Whether the commonMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCommonMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   *
   * @return The commonMetadata.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.CommonOperationMetadata getCommonMetadata() {
    return commonMetadata_ == null
        ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }
  /**
   *
   *
   * <pre>
   * The basic metadata of the long-running operation.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder
      getCommonMetadataOrBuilder() {
    return commonMetadata_ == null
        ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
        : commonMetadata_;
  }

  public static final int TRAINING_DATASET_VALIDATION_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
      trainingDatasetValidation_;
  /**
   *
   *
   * <pre>
   * The training dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
   * </code>
   *
   * @return Whether the trainingDatasetValidation field is set.
   */
  @java.lang.Override
  public boolean hasTrainingDatasetValidation() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The training dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
   * </code>
   *
   * @return The trainingDatasetValidation.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
      getTrainingDatasetValidation() {
    return trainingDatasetValidation_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .getDefaultInstance()
        : trainingDatasetValidation_;
  }
  /**
   *
   *
   * <pre>
   * The training dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
          .DatasetValidationOrBuilder
      getTrainingDatasetValidationOrBuilder() {
    return trainingDatasetValidation_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .getDefaultInstance()
        : trainingDatasetValidation_;
  }

  public static final int TEST_DATASET_VALIDATION_FIELD_NUMBER = 3;
  private com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
      testDatasetValidation_;
  /**
   *
   *
   * <pre>
   * The test dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
   * </code>
   *
   * @return Whether the testDatasetValidation field is set.
   */
  @java.lang.Override
  public boolean hasTestDatasetValidation() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The test dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
   * </code>
   *
   * @return The testDatasetValidation.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
      getTestDatasetValidation() {
    return testDatasetValidation_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .getDefaultInstance()
        : testDatasetValidation_;
  }
  /**
   *
   *
   * <pre>
   * The test dataset validation information.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
          .DatasetValidationOrBuilder
      getTestDatasetValidationOrBuilder() {
    return testDatasetValidation_ == null
        ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .getDefaultInstance()
        : testDatasetValidation_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCommonMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getTrainingDatasetValidation());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getTestDatasetValidation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommonMetadata());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getTrainingDatasetValidation());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTestDatasetValidation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata other =
        (com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata) obj;

    if (hasCommonMetadata() != other.hasCommonMetadata()) return false;
    if (hasCommonMetadata()) {
      if (!getCommonMetadata().equals(other.getCommonMetadata())) return false;
    }
    if (hasTrainingDatasetValidation() != other.hasTrainingDatasetValidation()) return false;
    if (hasTrainingDatasetValidation()) {
      if (!getTrainingDatasetValidation().equals(other.getTrainingDatasetValidation()))
        return false;
    }
    if (hasTestDatasetValidation() != other.hasTestDatasetValidation()) return false;
    if (hasTestDatasetValidation()) {
      if (!getTestDatasetValidation().equals(other.getTestDatasetValidation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCommonMetadata()) {
      hash = (37 * hash) + COMMON_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getCommonMetadata().hashCode();
    }
    if (hasTrainingDatasetValidation()) {
      hash = (37 * hash) + TRAINING_DATASET_VALIDATION_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingDatasetValidation().hashCode();
    }
    if (hasTestDatasetValidation()) {
      hash = (37 * hash) + TEST_DATASET_VALIDATION_FIELD_NUMBER;
      hash = (53 * hash) + getTestDatasetValidation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metadata that represents a processor version being created.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata)
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.class,
              com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.Builder.class);
    }

    // Construct using
    // com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCommonMetadataFieldBuilder();
        getTrainingDatasetValidationFieldBuilder();
        getTestDatasetValidationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      trainingDatasetValidation_ = null;
      if (trainingDatasetValidationBuilder_ != null) {
        trainingDatasetValidationBuilder_.dispose();
        trainingDatasetValidationBuilder_ = null;
      }
      testDatasetValidation_ = null;
      if (testDatasetValidationBuilder_ != null) {
        testDatasetValidationBuilder_.dispose();
        testDatasetValidationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_TrainProcessorVersionMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata build() {
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata buildPartial() {
      com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata result =
          new com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commonMetadata_ =
            commonMetadataBuilder_ == null ? commonMetadata_ : commonMetadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trainingDatasetValidation_ =
            trainingDatasetValidationBuilder_ == null
                ? trainingDatasetValidation_
                : trainingDatasetValidationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.testDatasetValidation_ =
            testDatasetValidationBuilder_ == null
                ? testDatasetValidation_
                : testDatasetValidationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata other) {
      if (other
          == com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.getDefaultInstance())
        return this;
      if (other.hasCommonMetadata()) {
        mergeCommonMetadata(other.getCommonMetadata());
      }
      if (other.hasTrainingDatasetValidation()) {
        mergeTrainingDatasetValidation(other.getTrainingDatasetValidation());
      }
      if (other.hasTestDatasetValidation()) {
        mergeTestDatasetValidation(other.getTestDatasetValidation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCommonMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getTrainingDatasetValidationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTestDatasetValidationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.documentai.v1beta3.CommonOperationMetadata commonMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>
        commonMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     *
     * @return Whether the commonMetadata field is set.
     */
    public boolean hasCommonMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     *
     * @return The commonMetadata.
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadata getCommonMetadata() {
      if (commonMetadataBuilder_ == null) {
        return commonMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      } else {
        return commonMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder setCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commonMetadata_ = value;
      } else {
        commonMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder setCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder builderForValue) {
      if (commonMetadataBuilder_ == null) {
        commonMetadata_ = builderForValue.build();
      } else {
        commonMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder mergeCommonMetadata(
        com.google.cloud.documentai.v1beta3.CommonOperationMetadata value) {
      if (commonMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && commonMetadata_ != null
            && commonMetadata_
                != com.google.cloud.documentai.v1beta3.CommonOperationMetadata
                    .getDefaultInstance()) {
          getCommonMetadataBuilder().mergeFrom(value);
        } else {
          commonMetadata_ = value;
        }
      } else {
        commonMetadataBuilder_.mergeFrom(value);
      }
      if (commonMetadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public Builder clearCommonMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commonMetadata_ = null;
      if (commonMetadataBuilder_ != null) {
        commonMetadataBuilder_.dispose();
        commonMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder
        getCommonMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCommonMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    public com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder
        getCommonMetadataOrBuilder() {
      if (commonMetadataBuilder_ != null) {
        return commonMetadataBuilder_.getMessageOrBuilder();
      } else {
        return commonMetadata_ == null
            ? com.google.cloud.documentai.v1beta3.CommonOperationMetadata.getDefaultInstance()
            : commonMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The basic metadata of the long-running operation.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.CommonOperationMetadata common_metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
            com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>
        getCommonMetadataFieldBuilder() {
      if (commonMetadataBuilder_ == null) {
        commonMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.CommonOperationMetadata,
                com.google.cloud.documentai.v1beta3.CommonOperationMetadata.Builder,
                com.google.cloud.documentai.v1beta3.CommonOperationMetadataOrBuilder>(
                getCommonMetadata(), getParentForChildren(), isClean());
        commonMetadata_ = null;
      }
      return commonMetadataBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
        trainingDatasetValidation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                .DatasetValidationOrBuilder>
        trainingDatasetValidationBuilder_;
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     *
     * @return Whether the trainingDatasetValidation field is set.
     */
    public boolean hasTrainingDatasetValidation() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     *
     * @return The trainingDatasetValidation.
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
        getTrainingDatasetValidation() {
      if (trainingDatasetValidationBuilder_ == null) {
        return trainingDatasetValidation_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .getDefaultInstance()
            : trainingDatasetValidation_;
      } else {
        return trainingDatasetValidationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public Builder setTrainingDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation value) {
      if (trainingDatasetValidationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingDatasetValidation_ = value;
      } else {
        trainingDatasetValidationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public Builder setTrainingDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation.Builder
            builderForValue) {
      if (trainingDatasetValidationBuilder_ == null) {
        trainingDatasetValidation_ = builderForValue.build();
      } else {
        trainingDatasetValidationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public Builder mergeTrainingDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation value) {
      if (trainingDatasetValidationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && trainingDatasetValidation_ != null
            && trainingDatasetValidation_
                != com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                    .DatasetValidation.getDefaultInstance()) {
          getTrainingDatasetValidationBuilder().mergeFrom(value);
        } else {
          trainingDatasetValidation_ = value;
        }
      } else {
        trainingDatasetValidationBuilder_.mergeFrom(value);
      }
      if (trainingDatasetValidation_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public Builder clearTrainingDatasetValidation() {
      bitField0_ = (bitField0_ & ~0x00000002);
      trainingDatasetValidation_ = null;
      if (trainingDatasetValidationBuilder_ != null) {
        trainingDatasetValidationBuilder_.dispose();
        trainingDatasetValidationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .Builder
        getTrainingDatasetValidationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTrainingDatasetValidationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidationOrBuilder
        getTrainingDatasetValidationOrBuilder() {
      if (trainingDatasetValidationBuilder_ != null) {
        return trainingDatasetValidationBuilder_.getMessageOrBuilder();
      } else {
        return trainingDatasetValidation_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .getDefaultInstance()
            : trainingDatasetValidation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The training dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation training_dataset_validation = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                .DatasetValidationOrBuilder>
        getTrainingDatasetValidationFieldBuilder() {
      if (trainingDatasetValidationBuilder_ == null) {
        trainingDatasetValidationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                    .Builder,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                    .DatasetValidationOrBuilder>(
                getTrainingDatasetValidation(), getParentForChildren(), isClean());
        trainingDatasetValidation_ = null;
      }
      return trainingDatasetValidationBuilder_;
    }

    private com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
        testDatasetValidation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                .DatasetValidationOrBuilder>
        testDatasetValidationBuilder_;
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     *
     * @return Whether the testDatasetValidation field is set.
     */
    public boolean hasTestDatasetValidation() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     *
     * @return The testDatasetValidation.
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
        getTestDatasetValidation() {
      if (testDatasetValidationBuilder_ == null) {
        return testDatasetValidation_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .getDefaultInstance()
            : testDatasetValidation_;
      } else {
        return testDatasetValidationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public Builder setTestDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation value) {
      if (testDatasetValidationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        testDatasetValidation_ = value;
      } else {
        testDatasetValidationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public Builder setTestDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation.Builder
            builderForValue) {
      if (testDatasetValidationBuilder_ == null) {
        testDatasetValidation_ = builderForValue.build();
      } else {
        testDatasetValidationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public Builder mergeTestDatasetValidation(
        com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation value) {
      if (testDatasetValidationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && testDatasetValidation_ != null
            && testDatasetValidation_
                != com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                    .DatasetValidation.getDefaultInstance()) {
          getTestDatasetValidationBuilder().mergeFrom(value);
        } else {
          testDatasetValidation_ = value;
        }
      } else {
        testDatasetValidationBuilder_.mergeFrom(value);
      }
      if (testDatasetValidation_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public Builder clearTestDatasetValidation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      testDatasetValidation_ = null;
      if (testDatasetValidationBuilder_ != null) {
        testDatasetValidationBuilder_.dispose();
        testDatasetValidationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
            .Builder
        getTestDatasetValidationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTestDatasetValidationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
            .DatasetValidationOrBuilder
        getTestDatasetValidationOrBuilder() {
      if (testDatasetValidationBuilder_ != null) {
        return testDatasetValidationBuilder_.getMessageOrBuilder();
      } else {
        return testDatasetValidation_ == null
            ? com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .getDefaultInstance()
            : testDatasetValidation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The test dataset validation information.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation test_dataset_validation = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                .Builder,
            com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                .DatasetValidationOrBuilder>
        getTestDatasetValidationFieldBuilder() {
      if (testDatasetValidationBuilder_ == null) {
        testDatasetValidationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata.DatasetValidation
                    .Builder,
                com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
                    .DatasetValidationOrBuilder>(
                getTestDatasetValidation(), getParentForChildren(), isClean());
        testDatasetValidation_ = null;
      }
      return testDatasetValidationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata)
  private static final com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata();
  }

  public static com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TrainProcessorVersionMetadata> PARSER =
      new com.google.protobuf.AbstractParser<TrainProcessorVersionMetadata>() {
        @java.lang.Override
        public TrainProcessorVersionMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TrainProcessorVersionMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TrainProcessorVersionMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.TrainProcessorVersionMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
