/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/dataset.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Dataset documents that the batch operation will be applied to.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.BatchDatasetDocuments}
 */
public final class BatchDatasetDocuments extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchDatasetDocuments)
    BatchDatasetDocumentsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchDatasetDocuments.newBuilder() to construct.
  private BatchDatasetDocuments(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchDatasetDocuments() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchDatasetDocuments();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DatasetProto
        .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.class,
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.Builder.class);
  }

  public interface IndividualDocumentIdsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.documentai.v1beta3.DocumentId> getDocumentIdsList();
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.documentai.v1beta3.DocumentId getDocumentIds(int index);
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getDocumentIdsCount();
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        getDocumentIdsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * List of individual DocumentIds.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds}
   */
  public static final class IndividualDocumentIds extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
      IndividualDocumentIdsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndividualDocumentIds.newBuilder() to construct.
    private IndividualDocumentIds(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndividualDocumentIds() {
      documentIds_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndividualDocumentIds();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_IndividualDocumentIds_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_IndividualDocumentIds_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.class,
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                  .Builder.class);
    }

    public static final int DOCUMENT_IDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.documentai.v1beta3.DocumentId> documentIds_;
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.documentai.v1beta3.DocumentId> getDocumentIdsList() {
      return documentIds_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
        getDocumentIdsOrBuilderList() {
      return documentIds_;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getDocumentIdsCount() {
      return documentIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentId getDocumentIds(int index) {
      return documentIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of Document IDs indicating where the actual documents are
     * stored.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdsOrBuilder(
        int index) {
      return documentIds_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < documentIds_.size(); i++) {
        output.writeMessage(1, documentIds_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < documentIds_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, documentIds_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)) {
        return super.equals(obj);
      }
      com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds other =
          (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds) obj;

      if (!getDocumentIdsList().equals(other.getDocumentIdsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDocumentIdsCount() > 0) {
        hash = (37 * hash) + DOCUMENT_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentIdsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * List of individual DocumentIds.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIdsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_IndividualDocumentIds_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_IndividualDocumentIds_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                    .class,
                com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (documentIdsBuilder_ == null) {
          documentIds_ = java.util.Collections.emptyList();
        } else {
          documentIds_ = null;
          documentIdsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.documentai.v1beta3.DatasetProto
            .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_IndividualDocumentIds_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
          getDefaultInstanceForType() {
        return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
          build() {
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
          buildPartial() {
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds result =
            new com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds result) {
        if (documentIdsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            documentIds_ = java.util.Collections.unmodifiableList(documentIds_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.documentIds_ = documentIds_;
        } else {
          result.documentIds_ = documentIdsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds) {
          return mergeFrom(
              (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds other) {
        if (other
            == com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                .getDefaultInstance()) return this;
        if (documentIdsBuilder_ == null) {
          if (!other.documentIds_.isEmpty()) {
            if (documentIds_.isEmpty()) {
              documentIds_ = other.documentIds_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDocumentIdsIsMutable();
              documentIds_.addAll(other.documentIds_);
            }
            onChanged();
          }
        } else {
          if (!other.documentIds_.isEmpty()) {
            if (documentIdsBuilder_.isEmpty()) {
              documentIdsBuilder_.dispose();
              documentIdsBuilder_ = null;
              documentIds_ = other.documentIds_;
              bitField0_ = (bitField0_ & ~0x00000001);
              documentIdsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDocumentIdsFieldBuilder()
                      : null;
            } else {
              documentIdsBuilder_.addAllMessages(other.documentIds_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.documentai.v1beta3.DocumentId m =
                      input.readMessage(
                          com.google.cloud.documentai.v1beta3.DocumentId.parser(),
                          extensionRegistry);
                  if (documentIdsBuilder_ == null) {
                    ensureDocumentIdsIsMutable();
                    documentIds_.add(m);
                  } else {
                    documentIdsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.documentai.v1beta3.DocumentId> documentIds_ =
          java.util.Collections.emptyList();

      private void ensureDocumentIdsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          documentIds_ =
              new java.util.ArrayList<com.google.cloud.documentai.v1beta3.DocumentId>(documentIds_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentId,
              com.google.cloud.documentai.v1beta3.DocumentId.Builder,
              com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
          documentIdsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta3.DocumentId> getDocumentIdsList() {
        if (documentIdsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(documentIds_);
        } else {
          return documentIdsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getDocumentIdsCount() {
        if (documentIdsBuilder_ == null) {
          return documentIds_.size();
        } else {
          return documentIdsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentId getDocumentIds(int index) {
        if (documentIdsBuilder_ == null) {
          return documentIds_.get(index);
        } else {
          return documentIdsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocumentIds(
          int index, com.google.cloud.documentai.v1beta3.DocumentId value) {
        if (documentIdsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentIdsIsMutable();
          documentIds_.set(index, value);
          onChanged();
        } else {
          documentIdsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setDocumentIds(
          int index, com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
        if (documentIdsBuilder_ == null) {
          ensureDocumentIdsIsMutable();
          documentIds_.set(index, builderForValue.build());
          onChanged();
        } else {
          documentIdsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocumentIds(com.google.cloud.documentai.v1beta3.DocumentId value) {
        if (documentIdsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentIdsIsMutable();
          documentIds_.add(value);
          onChanged();
        } else {
          documentIdsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocumentIds(
          int index, com.google.cloud.documentai.v1beta3.DocumentId value) {
        if (documentIdsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentIdsIsMutable();
          documentIds_.add(index, value);
          onChanged();
        } else {
          documentIdsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocumentIds(
          com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
        if (documentIdsBuilder_ == null) {
          ensureDocumentIdsIsMutable();
          documentIds_.add(builderForValue.build());
          onChanged();
        } else {
          documentIdsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addDocumentIds(
          int index, com.google.cloud.documentai.v1beta3.DocumentId.Builder builderForValue) {
        if (documentIdsBuilder_ == null) {
          ensureDocumentIdsIsMutable();
          documentIds_.add(index, builderForValue.build());
          onChanged();
        } else {
          documentIdsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllDocumentIds(
          java.lang.Iterable<? extends com.google.cloud.documentai.v1beta3.DocumentId> values) {
        if (documentIdsBuilder_ == null) {
          ensureDocumentIdsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documentIds_);
          onChanged();
        } else {
          documentIdsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearDocumentIds() {
        if (documentIdsBuilder_ == null) {
          documentIds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          documentIdsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeDocumentIds(int index) {
        if (documentIdsBuilder_ == null) {
          ensureDocumentIdsIsMutable();
          documentIds_.remove(index);
          onChanged();
        } else {
          documentIdsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentId.Builder getDocumentIdsBuilder(
          int index) {
        return getDocumentIdsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder getDocumentIdsOrBuilder(
          int index) {
        if (documentIdsBuilder_ == null) {
          return documentIds_.get(index);
        } else {
          return documentIdsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
          getDocumentIdsOrBuilderList() {
        if (documentIdsBuilder_ != null) {
          return documentIdsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(documentIds_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentId.Builder addDocumentIdsBuilder() {
        return getDocumentIdsFieldBuilder()
            .addBuilder(com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.documentai.v1beta3.DocumentId.Builder addDocumentIdsBuilder(
          int index) {
        return getDocumentIdsFieldBuilder()
            .addBuilder(index, com.google.cloud.documentai.v1beta3.DocumentId.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. List of Document IDs indicating where the actual documents are
       * stored.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.documentai.v1beta3.DocumentId document_ids = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.documentai.v1beta3.DocumentId.Builder>
          getDocumentIdsBuilderList() {
        return getDocumentIdsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.documentai.v1beta3.DocumentId,
              com.google.cloud.documentai.v1beta3.DocumentId.Builder,
              com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>
          getDocumentIdsFieldBuilder() {
        if (documentIdsBuilder_ == null) {
          documentIdsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.documentai.v1beta3.DocumentId,
                  com.google.cloud.documentai.v1beta3.DocumentId.Builder,
                  com.google.cloud.documentai.v1beta3.DocumentIdOrBuilder>(
                  documentIds_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          documentIds_ = null;
        }
        return documentIdsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
    private static final com.google.cloud.documentai.v1beta3.BatchDatasetDocuments
            .IndividualDocumentIds
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds();
    }

    public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndividualDocumentIds> PARSER =
        new com.google.protobuf.AbstractParser<IndividualDocumentIds>() {
          @java.lang.Override
          public IndividualDocumentIds parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IndividualDocumentIds> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndividualDocumentIds> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int criteriaCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object criteria_;

  public enum CriteriaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INDIVIDUAL_DOCUMENT_IDS(1),
    FILTER(2),
    CRITERIA_NOT_SET(0);
    private final int value;

    private CriteriaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CriteriaCase valueOf(int value) {
      return forNumber(value);
    }

    public static CriteriaCase forNumber(int value) {
      switch (value) {
        case 1:
          return INDIVIDUAL_DOCUMENT_IDS;
        case 2:
          return FILTER;
        case 0:
          return CRITERIA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CriteriaCase getCriteriaCase() {
    return CriteriaCase.forNumber(criteriaCase_);
  }

  public static final int INDIVIDUAL_DOCUMENT_IDS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Document identifiers.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
   * </code>
   *
   * @return Whether the individualDocumentIds field is set.
   */
  @java.lang.Override
  public boolean hasIndividualDocumentIds() {
    return criteriaCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Document identifiers.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
   * </code>
   *
   * @return The individualDocumentIds.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
      getIndividualDocumentIds() {
    if (criteriaCase_ == 1) {
      return (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
          criteria_;
    }
    return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Document identifiers.
   * </pre>
   *
   * <code>
   * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIdsOrBuilder
      getIndividualDocumentIdsOrBuilder() {
    if (criteriaCase_ == 1) {
      return (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
          criteria_;
    }
    return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        .getDefaultInstance();
  }

  public static final int FILTER_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A filter matching the documents.
   * Follows the same format and restriction as
   * [google.cloud.documentai.master.ListDocumentsRequest.filter].
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return Whether the filter field is set.
   */
  public boolean hasFilter() {
    return criteriaCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A filter matching the documents.
   * Follows the same format and restriction as
   * [google.cloud.documentai.master.ListDocumentsRequest.filter].
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The filter.
   */
  public java.lang.String getFilter() {
    java.lang.Object ref = "";
    if (criteriaCase_ == 2) {
      ref = criteria_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (criteriaCase_ == 2) {
        criteria_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A filter matching the documents.
   * Follows the same format and restriction as
   * [google.cloud.documentai.master.ListDocumentsRequest.filter].
   * </pre>
   *
   * <code>string filter = 2;</code>
   *
   * @return The bytes for filter.
   */
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = "";
    if (criteriaCase_ == 2) {
      ref = criteria_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (criteriaCase_ == 2) {
        criteria_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (criteriaCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
              criteria_);
    }
    if (criteriaCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, criteria_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (criteriaCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
                  criteria_);
    }
    if (criteriaCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, criteria_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.BatchDatasetDocuments)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.BatchDatasetDocuments other =
        (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments) obj;

    if (!getCriteriaCase().equals(other.getCriteriaCase())) return false;
    switch (criteriaCase_) {
      case 1:
        if (!getIndividualDocumentIds().equals(other.getIndividualDocumentIds())) return false;
        break;
      case 2:
        if (!getFilter().equals(other.getFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (criteriaCase_) {
      case 1:
        hash = (37 * hash) + INDIVIDUAL_DOCUMENT_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getIndividualDocumentIds().hashCode();
        break;
      case 2:
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.BatchDatasetDocuments prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Dataset documents that the batch operation will be applied to.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.BatchDatasetDocuments}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.BatchDatasetDocuments)
      com.google.cloud.documentai.v1beta3.BatchDatasetDocumentsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.class,
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (individualDocumentIdsBuilder_ != null) {
        individualDocumentIdsBuilder_.clear();
      }
      criteriaCase_ = 0;
      criteria_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DatasetProto
          .internal_static_google_cloud_documentai_v1beta3_BatchDatasetDocuments_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments build() {
      com.google.cloud.documentai.v1beta3.BatchDatasetDocuments result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments buildPartial() {
      com.google.cloud.documentai.v1beta3.BatchDatasetDocuments result =
          new com.google.cloud.documentai.v1beta3.BatchDatasetDocuments(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.BatchDatasetDocuments result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments result) {
      result.criteriaCase_ = criteriaCase_;
      result.criteria_ = this.criteria_;
      if (criteriaCase_ == 1 && individualDocumentIdsBuilder_ != null) {
        result.criteria_ = individualDocumentIdsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.BatchDatasetDocuments) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.BatchDatasetDocuments) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.BatchDatasetDocuments other) {
      if (other == com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.getDefaultInstance())
        return this;
      switch (other.getCriteriaCase()) {
        case INDIVIDUAL_DOCUMENT_IDS:
          {
            mergeIndividualDocumentIds(other.getIndividualDocumentIds());
            break;
          }
        case FILTER:
          {
            criteriaCase_ = 2;
            criteria_ = other.criteria_;
            onChanged();
            break;
          }
        case CRITERIA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getIndividualDocumentIdsFieldBuilder().getBuilder(), extensionRegistry);
                criteriaCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                criteriaCase_ = 2;
                criteria_ = s;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int criteriaCase_ = 0;
    private java.lang.Object criteria_;

    public CriteriaCase getCriteriaCase() {
      return CriteriaCase.forNumber(criteriaCase_);
    }

    public Builder clearCriteria() {
      criteriaCase_ = 0;
      criteria_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds,
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.Builder,
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments
                .IndividualDocumentIdsOrBuilder>
        individualDocumentIdsBuilder_;
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     *
     * @return Whether the individualDocumentIds field is set.
     */
    @java.lang.Override
    public boolean hasIndividualDocumentIds() {
      return criteriaCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     *
     * @return The individualDocumentIds.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
        getIndividualDocumentIds() {
      if (individualDocumentIdsBuilder_ == null) {
        if (criteriaCase_ == 1) {
          return (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
              criteria_;
        }
        return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
            .getDefaultInstance();
      } else {
        if (criteriaCase_ == 1) {
          return individualDocumentIdsBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    public Builder setIndividualDocumentIds(
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds value) {
      if (individualDocumentIdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        criteria_ = value;
        onChanged();
      } else {
        individualDocumentIdsBuilder_.setMessage(value);
      }
      criteriaCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    public Builder setIndividualDocumentIds(
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.Builder
            builderForValue) {
      if (individualDocumentIdsBuilder_ == null) {
        criteria_ = builderForValue.build();
        onChanged();
      } else {
        individualDocumentIdsBuilder_.setMessage(builderForValue.build());
      }
      criteriaCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    public Builder mergeIndividualDocumentIds(
        com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds value) {
      if (individualDocumentIdsBuilder_ == null) {
        if (criteriaCase_ == 1
            && criteria_
                != com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                    .getDefaultInstance()) {
          criteria_ =
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                  .newBuilder(
                      (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments
                              .IndividualDocumentIds)
                          criteria_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          criteria_ = value;
        }
        onChanged();
      } else {
        if (criteriaCase_ == 1) {
          individualDocumentIdsBuilder_.mergeFrom(value);
        } else {
          individualDocumentIdsBuilder_.setMessage(value);
        }
      }
      criteriaCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    public Builder clearIndividualDocumentIds() {
      if (individualDocumentIdsBuilder_ == null) {
        if (criteriaCase_ == 1) {
          criteriaCase_ = 0;
          criteria_ = null;
          onChanged();
        }
      } else {
        if (criteriaCase_ == 1) {
          criteriaCase_ = 0;
          criteria_ = null;
        }
        individualDocumentIdsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.Builder
        getIndividualDocumentIdsBuilder() {
      return getIndividualDocumentIdsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIdsOrBuilder
        getIndividualDocumentIdsOrBuilder() {
      if ((criteriaCase_ == 1) && (individualDocumentIdsBuilder_ != null)) {
        return individualDocumentIdsBuilder_.getMessageOrBuilder();
      } else {
        if (criteriaCase_ == 1) {
          return (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
              criteria_;
        }
        return com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Document identifiers.
     * </pre>
     *
     * <code>
     * .google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds individual_document_ids = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds,
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.Builder,
            com.google.cloud.documentai.v1beta3.BatchDatasetDocuments
                .IndividualDocumentIdsOrBuilder>
        getIndividualDocumentIdsFieldBuilder() {
      if (individualDocumentIdsBuilder_ == null) {
        if (!(criteriaCase_ == 1)) {
          criteria_ =
              com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                  .getDefaultInstance();
        }
        individualDocumentIdsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds,
                com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
                    .Builder,
                com.google.cloud.documentai.v1beta3.BatchDatasetDocuments
                    .IndividualDocumentIdsOrBuilder>(
                (com.google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds)
                    criteria_,
                getParentForChildren(),
                isClean());
        criteria_ = null;
      }
      criteriaCase_ = 1;
      onChanged();
      return individualDocumentIdsBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return Whether the filter field is set.
     */
    @java.lang.Override
    public boolean hasFilter() {
      return criteriaCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = "";
      if (criteriaCase_ == 2) {
        ref = criteria_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (criteriaCase_ == 2) {
          criteria_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = "";
      if (criteriaCase_ == 2) {
        ref = criteria_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (criteriaCase_ == 2) {
          criteria_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      criteriaCase_ = 2;
      criteria_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      if (criteriaCase_ == 2) {
        criteriaCase_ = 0;
        criteria_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter matching the documents.
     * Follows the same format and restriction as
     * [google.cloud.documentai.master.ListDocumentsRequest.filter].
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      criteriaCase_ = 2;
      criteria_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.BatchDatasetDocuments)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.BatchDatasetDocuments)
  private static final com.google.cloud.documentai.v1beta3.BatchDatasetDocuments DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.BatchDatasetDocuments();
  }

  public static com.google.cloud.documentai.v1beta3.BatchDatasetDocuments getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchDatasetDocuments> PARSER =
      new com.google.protobuf.AbstractParser<BatchDatasetDocuments>() {
        @java.lang.Override
        public BatchDatasetDocuments parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchDatasetDocuments> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchDatasetDocuments> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.BatchDatasetDocuments getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
