/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/documentai/v1beta3/document_processor_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.documentai.v1beta3;

/**
 *
 *
 * <pre>
 * Request message for the
 * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.documentai.v1beta3.ReviewDocumentRequest}
 */
public final class ReviewDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.documentai.v1beta3.ReviewDocumentRequest)
    ReviewDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReviewDocumentRequest.newBuilder() to construct.
  private ReviewDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReviewDocumentRequest() {
    humanReviewConfig_ = "";
    priority_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReviewDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ReviewDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
        .internal_static_google_cloud_documentai_v1beta3_ReviewDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.class,
            com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The priority level of the human review task.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority}
   */
  public enum Priority implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default priority level.
     * </pre>
     *
     * <code>DEFAULT = 0;</code>
     */
    DEFAULT(0),
    /**
     *
     *
     * <pre>
     * The urgent priority level. The labeling manager should allocate labeler
     * resource to the urgent task queue to respect this priority level.
     * </pre>
     *
     * <code>URGENT = 1;</code>
     */
    URGENT(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default priority level.
     * </pre>
     *
     * <code>DEFAULT = 0;</code>
     */
    public static final int DEFAULT_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The urgent priority level. The labeling manager should allocate labeler
     * resource to the urgent task queue to respect this priority level.
     * </pre>
     *
     * <code>URGENT = 1;</code>
     */
    public static final int URGENT_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Priority valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Priority forNumber(int value) {
      switch (value) {
        case 0:
          return DEFAULT;
        case 1:
          return URGENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Priority> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Priority> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Priority>() {
          public Priority findValueByNumber(int number) {
            return Priority.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Priority[] VALUES = values();

    public static Priority valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Priority(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority)
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_DOCUMENT(4),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 4:
          return INLINE_DOCUMENT;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_DOCUMENT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return Whether the inlineDocument field is set.
   */
  @java.lang.Override
  public boolean hasInlineDocument() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   *
   * @return The inlineDocument.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An inline document proto.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.documentai.v1beta3.Document) source_;
    }
    return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
  }

  public static final int HUMAN_REVIEW_CONFIG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object humanReviewConfig_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
   * the document will be reviewed with.
   * </pre>
   *
   * <code>
   * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The humanReviewConfig.
   */
  @java.lang.Override
  public java.lang.String getHumanReviewConfig() {
    java.lang.Object ref = humanReviewConfig_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      humanReviewConfig_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
   * the document will be reviewed with.
   * </pre>
   *
   * <code>
   * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for humanReviewConfig.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHumanReviewConfigBytes() {
    java.lang.Object ref = humanReviewConfig_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      humanReviewConfig_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENT_FIELD_NUMBER = 2;
  private com.google.cloud.documentai.v1beta3.Document document_;
  /**
   *
   *
   * <pre>
   * The document that needs human review.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ReviewDocumentRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=1202
   * @return Whether the document field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasDocument() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The document that needs human review.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   *
   * @deprecated google.cloud.documentai.v1beta3.ReviewDocumentRequest.document is deprecated. See
   *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=1202
   * @return The document.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.Document getDocument() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }
  /**
   *
   *
   * <pre>
   * The document that needs human review.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null
        ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
        : document_;
  }

  public static final int ENABLE_SCHEMA_VALIDATION_FIELD_NUMBER = 3;
  private boolean enableSchemaValidation_ = false;
  /**
   *
   *
   * <pre>
   * Whether the validation should be performed on the ad-hoc review request.
   * </pre>
   *
   * <code>bool enable_schema_validation = 3;</code>
   *
   * @return The enableSchemaValidation.
   */
  @java.lang.Override
  public boolean getEnableSchemaValidation() {
    return enableSchemaValidation_;
  }

  public static final int PRIORITY_FIELD_NUMBER = 5;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * The priority of the human review task.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
   *
   * @return The enum numeric value on the wire for priority.
   */
  @java.lang.Override
  public int getPriorityValue() {
    return priority_;
  }
  /**
   *
   *
   * <pre>
   * The priority of the human review task.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority getPriority() {
    com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority result =
        com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.forNumber(priority_);
    return result == null
        ? com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.UNRECOGNIZED
        : result;
  }

  public static final int DOCUMENT_SCHEMA_FIELD_NUMBER = 6;
  private com.google.cloud.documentai.v1beta3.DocumentSchema documentSchema_;
  /**
   *
   *
   * <pre>
   * The document schema of the human review task.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
   *
   * @return Whether the documentSchema field is set.
   */
  @java.lang.Override
  public boolean hasDocumentSchema() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The document schema of the human review task.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
   *
   * @return The documentSchema.
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchema getDocumentSchema() {
    return documentSchema_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : documentSchema_;
  }
  /**
   *
   *
   * <pre>
   * The document schema of the human review task.
   * </pre>
   *
   * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder getDocumentSchemaOrBuilder() {
    return documentSchema_ == null
        ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
        : documentSchema_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(humanReviewConfig_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, humanReviewConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDocument());
    }
    if (enableSchemaValidation_ != false) {
      output.writeBool(3, enableSchemaValidation_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (priority_
        != com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.DEFAULT.getNumber()) {
      output.writeEnum(5, priority_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getDocumentSchema());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(humanReviewConfig_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, humanReviewConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDocument());
    }
    if (enableSchemaValidation_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableSchemaValidation_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.documentai.v1beta3.Document) source_);
    }
    if (priority_
        != com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, priority_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDocumentSchema());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.documentai.v1beta3.ReviewDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.documentai.v1beta3.ReviewDocumentRequest other =
        (com.google.cloud.documentai.v1beta3.ReviewDocumentRequest) obj;

    if (!getHumanReviewConfig().equals(other.getHumanReviewConfig())) return false;
    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (getEnableSchemaValidation() != other.getEnableSchemaValidation()) return false;
    if (priority_ != other.priority_) return false;
    if (hasDocumentSchema() != other.hasDocumentSchema()) return false;
    if (hasDocumentSchema()) {
      if (!getDocumentSchema().equals(other.getDocumentSchema())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 4:
        if (!getInlineDocument().equals(other.getInlineDocument())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HUMAN_REVIEW_CONFIG_FIELD_NUMBER;
    hash = (53 * hash) + getHumanReviewConfig().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    hash = (37 * hash) + ENABLE_SCHEMA_VALIDATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSchemaValidation());
    hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
    hash = (53 * hash) + priority_;
    if (hasDocumentSchema()) {
      hash = (37 * hash) + DOCUMENT_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentSchema().hashCode();
    }
    switch (sourceCase_) {
      case 4:
        hash = (37 * hash) + INLINE_DOCUMENT_FIELD_NUMBER;
        hash = (53 * hash) + getInlineDocument().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.documentai.v1beta3.ReviewDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the
   * [ReviewDocument][google.cloud.documentai.v1beta3.DocumentProcessorService.ReviewDocument]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.documentai.v1beta3.ReviewDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.documentai.v1beta3.ReviewDocumentRequest)
      com.google.cloud.documentai.v1beta3.ReviewDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ReviewDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ReviewDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.class,
              com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentFieldBuilder();
        getDocumentSchemaFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineDocumentBuilder_ != null) {
        inlineDocumentBuilder_.clear();
      }
      humanReviewConfig_ = "";
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      enableSchemaValidation_ = false;
      priority_ = 0;
      documentSchema_ = null;
      if (documentSchemaBuilder_ != null) {
        documentSchemaBuilder_.dispose();
        documentSchemaBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.documentai.v1beta3.DocumentAiProcessorService
          .internal_static_google_cloud_documentai_v1beta3_ReviewDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest build() {
      com.google.cloud.documentai.v1beta3.ReviewDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest buildPartial() {
      com.google.cloud.documentai.v1beta3.ReviewDocumentRequest result =
          new com.google.cloud.documentai.v1beta3.ReviewDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.documentai.v1beta3.ReviewDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.humanReviewConfig_ = humanReviewConfig_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enableSchemaValidation_ = enableSchemaValidation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.priority_ = priority_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.documentSchema_ =
            documentSchemaBuilder_ == null ? documentSchema_ : documentSchemaBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.documentai.v1beta3.ReviewDocumentRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 4 && inlineDocumentBuilder_ != null) {
        result.source_ = inlineDocumentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.documentai.v1beta3.ReviewDocumentRequest) {
        return mergeFrom((com.google.cloud.documentai.v1beta3.ReviewDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.documentai.v1beta3.ReviewDocumentRequest other) {
      if (other == com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getHumanReviewConfig().isEmpty()) {
        humanReviewConfig_ = other.humanReviewConfig_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.getEnableSchemaValidation() != false) {
        setEnableSchemaValidation(other.getEnableSchemaValidation());
      }
      if (other.priority_ != 0) {
        setPriorityValue(other.getPriorityValue());
      }
      if (other.hasDocumentSchema()) {
        mergeDocumentSchema(other.getDocumentSchema());
      }
      switch (other.getSourceCase()) {
        case INLINE_DOCUMENT:
          {
            mergeInlineDocument(other.getInlineDocument());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                humanReviewConfig_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 24:
              {
                enableSchemaValidation_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getInlineDocumentFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 40:
              {
                priority_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getDocumentSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        inlineDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return Whether the inlineDocument field is set.
     */
    @java.lang.Override
    public boolean hasInlineDocument() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     *
     * @return The inlineDocument.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.Document getInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return inlineDocumentBuilder_.getMessage();
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder setInlineDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (inlineDocumentBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineDocumentBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder mergeInlineDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4
            && source_ != com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()) {
          source_ =
              com.google.cloud.documentai.v1beta3.Document.newBuilder(
                      (com.google.cloud.documentai.v1beta3.Document) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          inlineDocumentBuilder_.mergeFrom(value);
        } else {
          inlineDocumentBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public Builder clearInlineDocument() {
      if (inlineDocumentBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineDocumentBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    public com.google.cloud.documentai.v1beta3.Document.Builder getInlineDocumentBuilder() {
      return getInlineDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getInlineDocumentOrBuilder() {
      if ((sourceCase_ == 4) && (inlineDocumentBuilder_ != null)) {
        return inlineDocumentBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.documentai.v1beta3.Document) source_;
        }
        return com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An inline document proto.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document inline_document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getInlineDocumentFieldBuilder() {
      if (inlineDocumentBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.documentai.v1beta3.Document.getDefaultInstance();
        }
        inlineDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                (com.google.cloud.documentai.v1beta3.Document) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      return inlineDocumentBuilder_;
    }

    private java.lang.Object humanReviewConfig_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
     * the document will be reviewed with.
     * </pre>
     *
     * <code>
     * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The humanReviewConfig.
     */
    public java.lang.String getHumanReviewConfig() {
      java.lang.Object ref = humanReviewConfig_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        humanReviewConfig_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
     * the document will be reviewed with.
     * </pre>
     *
     * <code>
     * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for humanReviewConfig.
     */
    public com.google.protobuf.ByteString getHumanReviewConfigBytes() {
      java.lang.Object ref = humanReviewConfig_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        humanReviewConfig_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
     * the document will be reviewed with.
     * </pre>
     *
     * <code>
     * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The humanReviewConfig to set.
     * @return This builder for chaining.
     */
    public Builder setHumanReviewConfig(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      humanReviewConfig_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
     * the document will be reviewed with.
     * </pre>
     *
     * <code>
     * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHumanReviewConfig() {
      humanReviewConfig_ = getDefaultInstance().getHumanReviewConfig();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
     * the document will be reviewed with.
     * </pre>
     *
     * <code>
     * string human_review_config = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for humanReviewConfig to set.
     * @return This builder for chaining.
     */
    public Builder setHumanReviewConfigBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      humanReviewConfig_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ReviewDocumentRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=1202
     * @return Whether the document field is set.
     */
    @java.lang.Deprecated
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.documentai.v1beta3.ReviewDocumentRequest.document is deprecated. See
     *     google/cloud/documentai/v1beta3/document_processor_service.proto;l=1202
     * @return The document.
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder setDocument(
        com.google.cloud.documentai.v1beta3.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder mergeDocument(com.google.cloud.documentai.v1beta3.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && document_ != null
            && document_ != com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      if (document_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000004);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public com.google.cloud.documentai.v1beta3.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.cloud.documentai.v1beta3.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * The document that needs human review.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.Document document = 2 [deprecated = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.Document,
            com.google.cloud.documentai.v1beta3.Document.Builder,
            com.google.cloud.documentai.v1beta3.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.Document,
                com.google.cloud.documentai.v1beta3.Document.Builder,
                com.google.cloud.documentai.v1beta3.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private boolean enableSchemaValidation_;
    /**
     *
     *
     * <pre>
     * Whether the validation should be performed on the ad-hoc review request.
     * </pre>
     *
     * <code>bool enable_schema_validation = 3;</code>
     *
     * @return The enableSchemaValidation.
     */
    @java.lang.Override
    public boolean getEnableSchemaValidation() {
      return enableSchemaValidation_;
    }
    /**
     *
     *
     * <pre>
     * Whether the validation should be performed on the ad-hoc review request.
     * </pre>
     *
     * <code>bool enable_schema_validation = 3;</code>
     *
     * @param value The enableSchemaValidation to set.
     * @return This builder for chaining.
     */
    public Builder setEnableSchemaValidation(boolean value) {

      enableSchemaValidation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the validation should be performed on the ad-hoc review request.
     * </pre>
     *
     * <code>bool enable_schema_validation = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableSchemaValidation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enableSchemaValidation_ = false;
      onChanged();
      return this;
    }

    private int priority_ = 0;
    /**
     *
     *
     * <pre>
     * The priority of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
     *
     * @return The enum numeric value on the wire for priority.
     */
    @java.lang.Override
    public int getPriorityValue() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * The priority of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
     *
     * @param value The enum numeric value on the wire for priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriorityValue(int value) {
      priority_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority getPriority() {
      com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority result =
          com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.forNumber(priority_);
      return result == null
          ? com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The priority of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(
        com.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      priority_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The priority of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.ReviewDocumentRequest.Priority priority = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000010);
      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.documentai.v1beta3.DocumentSchema documentSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        documentSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     *
     * @return Whether the documentSchema field is set.
     */
    public boolean hasDocumentSchema() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     *
     * @return The documentSchema.
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema getDocumentSchema() {
      if (documentSchemaBuilder_ == null) {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      } else {
        return documentSchemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public Builder setDocumentSchema(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentSchema_ = value;
      } else {
        documentSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public Builder setDocumentSchema(
        com.google.cloud.documentai.v1beta3.DocumentSchema.Builder builderForValue) {
      if (documentSchemaBuilder_ == null) {
        documentSchema_ = builderForValue.build();
      } else {
        documentSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public Builder mergeDocumentSchema(com.google.cloud.documentai.v1beta3.DocumentSchema value) {
      if (documentSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && documentSchema_ != null
            && documentSchema_
                != com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()) {
          getDocumentSchemaBuilder().mergeFrom(value);
        } else {
          documentSchema_ = value;
        }
      } else {
        documentSchemaBuilder_.mergeFrom(value);
      }
      if (documentSchema_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public Builder clearDocumentSchema() {
      bitField0_ = (bitField0_ & ~0x00000020);
      documentSchema_ = null;
      if (documentSchemaBuilder_ != null) {
        documentSchemaBuilder_.dispose();
        documentSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchema.Builder getDocumentSchemaBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDocumentSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    public com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder
        getDocumentSchemaOrBuilder() {
      if (documentSchemaBuilder_ != null) {
        return documentSchemaBuilder_.getMessageOrBuilder();
      } else {
        return documentSchema_ == null
            ? com.google.cloud.documentai.v1beta3.DocumentSchema.getDefaultInstance()
            : documentSchema_;
      }
    }
    /**
     *
     *
     * <pre>
     * The document schema of the human review task.
     * </pre>
     *
     * <code>.google.cloud.documentai.v1beta3.DocumentSchema document_schema = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.documentai.v1beta3.DocumentSchema,
            com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
            com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>
        getDocumentSchemaFieldBuilder() {
      if (documentSchemaBuilder_ == null) {
        documentSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.documentai.v1beta3.DocumentSchema,
                com.google.cloud.documentai.v1beta3.DocumentSchema.Builder,
                com.google.cloud.documentai.v1beta3.DocumentSchemaOrBuilder>(
                getDocumentSchema(), getParentForChildren(), isClean());
        documentSchema_ = null;
      }
      return documentSchemaBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.documentai.v1beta3.ReviewDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.documentai.v1beta3.ReviewDocumentRequest)
  private static final com.google.cloud.documentai.v1beta3.ReviewDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.documentai.v1beta3.ReviewDocumentRequest();
  }

  public static com.google.cloud.documentai.v1beta3.ReviewDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReviewDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReviewDocumentRequest>() {
        @java.lang.Override
        public ReviewDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReviewDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReviewDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.documentai.v1beta3.ReviewDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
