/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Request for the `ConfigureContactSettings` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest}
 */
public final class ConfigureContactSettingsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest)
    ConfigureContactSettingsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConfigureContactSettingsRequest.newBuilder() to construct.
  private ConfigureContactSettingsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConfigureContactSettingsRequest() {
    registration_ = "";
    contactNotices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConfigureContactSettingsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ConfigureContactSettingsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ConfigureContactSettingsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.class,
            com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.Builder.class);
  }

  public static final int REGISTRATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object registration_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the `Registration` whose contact settings are being updated,
   * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
   * </pre>
   *
   * <code>
   * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The registration.
   */
  @java.lang.Override
  public java.lang.String getRegistration() {
    java.lang.Object ref = registration_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      registration_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the `Registration` whose contact settings are being updated,
   * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
   * </pre>
   *
   * <code>
   * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for registration.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegistrationBytes() {
    java.lang.Object ref = registration_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      registration_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTACT_SETTINGS_FIELD_NUMBER = 2;
  private com.google.cloud.domains.v1alpha2.ContactSettings contactSettings_;
  /**
   *
   *
   * <pre>
   * Fields of the `ContactSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
   *
   * @return Whether the contactSettings field is set.
   */
  @java.lang.Override
  public boolean hasContactSettings() {
    return contactSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Fields of the `ContactSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
   *
   * @return The contactSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings getContactSettings() {
    return contactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : contactSettings_;
  }
  /**
   *
   *
   * <pre>
   * Fields of the `ContactSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder getContactSettingsOrBuilder() {
    return contactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : contactSettings_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the registrant contact is being updated, the
   * `update_mask` is `"registrant_contact"`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the registrant contact is being updated, the
   * `update_mask` is `"registrant_contact"`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the registrant contact is being updated, the
   * `update_mask` is `"registrant_contact"`.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int CONTACT_NOTICES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> contactNotices_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>
      contactNotices_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>() {
            public com.google.cloud.domains.v1alpha2.ContactNotice convert(java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.ContactNotice result =
                  com.google.cloud.domains.v1alpha2.ContactNotice.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.ContactNotice.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in `contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return A list containing the contactNotices.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.ContactNotice> getContactNoticesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>(
        contactNotices_, contactNotices_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in `contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return The count of contactNotices.
   */
  @java.lang.Override
  public int getContactNoticesCount() {
    return contactNotices_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in `contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The contactNotices at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactNotice getContactNotices(int index) {
    return contactNotices_converter_.convert(contactNotices_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in `contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for contactNotices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getContactNoticesValueList() {
    return contactNotices_;
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in `contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of contactNotices at the given index.
   */
  @java.lang.Override
  public int getContactNoticesValue(int index) {
    return contactNotices_.get(index);
  }

  private int contactNoticesMemoizedSerializedSize;

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 5;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Validate the request without actually updating the contact settings.
   * </pre>
   *
   * <code>bool validate_only = 5;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registration_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, registration_);
    }
    if (contactSettings_ != null) {
      output.writeMessage(2, getContactSettings());
    }
    if (updateMask_ != null) {
      output.writeMessage(3, getUpdateMask());
    }
    if (getContactNoticesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(contactNoticesMemoizedSerializedSize);
    }
    for (int i = 0; i < contactNotices_.size(); i++) {
      output.writeEnumNoTag(contactNotices_.get(i));
    }
    if (validateOnly_ != false) {
      output.writeBool(5, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registration_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, registration_);
    }
    if (contactSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContactSettings());
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < contactNotices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(contactNotices_.get(i));
      }
      size += dataSize;
      if (!getContactNoticesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      contactNoticesMemoizedSerializedSize = dataSize;
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest other =
        (com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest) obj;

    if (!getRegistration().equals(other.getRegistration())) return false;
    if (hasContactSettings() != other.hasContactSettings()) return false;
    if (hasContactSettings()) {
      if (!getContactSettings().equals(other.getContactSettings())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!contactNotices_.equals(other.contactNotices_)) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REGISTRATION_FIELD_NUMBER;
    hash = (53 * hash) + getRegistration().hashCode();
    if (hasContactSettings()) {
      hash = (37 * hash) + CONTACT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getContactSettings().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (getContactNoticesCount() > 0) {
      hash = (37 * hash) + CONTACT_NOTICES_FIELD_NUMBER;
      hash = (53 * hash) + contactNotices_.hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the `ConfigureContactSettings` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest)
      com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureContactSettingsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureContactSettingsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.class,
              com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      registration_ = "";
      contactSettings_ = null;
      if (contactSettingsBuilder_ != null) {
        contactSettingsBuilder_.dispose();
        contactSettingsBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      contactNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureContactSettingsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest build() {
      com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest buildPartial() {
      com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest result =
          new com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        contactNotices_ = java.util.Collections.unmodifiableList(contactNotices_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.contactNotices_ = contactNotices_;
    }

    private void buildPartial0(
        com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.registration_ = registration_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.contactSettings_ =
            contactSettingsBuilder_ == null ? contactSettings_ : contactSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest other) {
      if (other
          == com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest.getDefaultInstance())
        return this;
      if (!other.getRegistration().isEmpty()) {
        registration_ = other.registration_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasContactSettings()) {
        mergeContactSettings(other.getContactSettings());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (!other.contactNotices_.isEmpty()) {
        if (contactNotices_.isEmpty()) {
          contactNotices_ = other.contactNotices_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureContactNoticesIsMutable();
          contactNotices_.addAll(other.contactNotices_);
        }
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                registration_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getContactSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureContactNoticesIsMutable();
                contactNotices_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureContactNoticesIsMutable();
                  contactNotices_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 40:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object registration_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose contact settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The registration.
     */
    public java.lang.String getRegistration() {
      java.lang.Object ref = registration_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        registration_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose contact settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for registration.
     */
    public com.google.protobuf.ByteString getRegistrationBytes() {
      java.lang.Object ref = registration_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        registration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose contact settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The registration to set.
     * @return This builder for chaining.
     */
    public Builder setRegistration(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      registration_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose contact settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegistration() {
      registration_ = getDefaultInstance().getRegistration();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose contact settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for registration to set.
     * @return This builder for chaining.
     */
    public Builder setRegistrationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      registration_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings contactSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        contactSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     *
     * @return Whether the contactSettings field is set.
     */
    public boolean hasContactSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     *
     * @return The contactSettings.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings getContactSettings() {
      if (contactSettingsBuilder_ == null) {
        return contactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : contactSettings_;
      } else {
        return contactSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public Builder setContactSettings(com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (contactSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contactSettings_ = value;
      } else {
        contactSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public Builder setContactSettings(
        com.google.cloud.domains.v1alpha2.ContactSettings.Builder builderForValue) {
      if (contactSettingsBuilder_ == null) {
        contactSettings_ = builderForValue.build();
      } else {
        contactSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public Builder mergeContactSettings(com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (contactSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && contactSettings_ != null
            && contactSettings_
                != com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()) {
          getContactSettingsBuilder().mergeFrom(value);
        } else {
          contactSettings_ = value;
        }
      } else {
        contactSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public Builder clearContactSettings() {
      bitField0_ = (bitField0_ & ~0x00000002);
      contactSettings_ = null;
      if (contactSettingsBuilder_ != null) {
        contactSettingsBuilder_.dispose();
        contactSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Builder getContactSettingsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getContactSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder
        getContactSettingsOrBuilder() {
      if (contactSettingsBuilder_ != null) {
        return contactSettingsBuilder_.getMessageOrBuilder();
      } else {
        return contactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : contactSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Fields of the `ContactSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ContactSettings contact_settings = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        getContactSettingsFieldBuilder() {
      if (contactSettingsBuilder_ == null) {
        contactSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings,
                com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>(
                getContactSettings(), getParentForChildren(), isClean());
        contactSettings_ = null;
      }
      return contactSettingsBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the registrant contact is being updated, the
     * `update_mask` is `"registrant_contact"`.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private java.util.List<java.lang.Integer> contactNotices_ = java.util.Collections.emptyList();

    private void ensureContactNoticesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        contactNotices_ = new java.util.ArrayList<java.lang.Integer>(contactNotices_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return A list containing the contactNotices.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.ContactNotice> getContactNoticesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>(
          contactNotices_, contactNotices_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return The count of contactNotices.
     */
    public int getContactNoticesCount() {
      return contactNotices_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The contactNotices at the given index.
     */
    public com.google.cloud.domains.v1alpha2.ContactNotice getContactNotices(int index) {
      return contactNotices_converter_.convert(contactNotices_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The contactNotices to set.
     * @return This builder for chaining.
     */
    public Builder setContactNotices(
        int index, com.google.cloud.domains.v1alpha2.ContactNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContactNoticesIsMutable();
      contactNotices_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param value The contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addContactNotices(com.google.cloud.domains.v1alpha2.ContactNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContactNoticesIsMutable();
      contactNotices_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param values The contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllContactNotices(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.ContactNotice> values) {
      ensureContactNoticesIsMutable();
      for (com.google.cloud.domains.v1alpha2.ContactNotice value : values) {
        contactNotices_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContactNotices() {
      contactNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return A list containing the enum numeric values on the wire for contactNotices.
     */
    public java.util.List<java.lang.Integer> getContactNoticesValueList() {
      return java.util.Collections.unmodifiableList(contactNotices_);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of contactNotices at the given index.
     */
    public int getContactNoticesValue(int index) {
      return contactNotices_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for contactNotices to set.
     * @return This builder for chaining.
     */
    public Builder setContactNoticesValue(int index, int value) {
      ensureContactNoticesIsMutable();
      contactNotices_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param value The enum numeric value on the wire for contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addContactNoticesValue(int value) {
      ensureContactNoticesIsMutable();
      contactNotices_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in `contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param values The enum numeric values on the wire for contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllContactNoticesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureContactNoticesIsMutable();
      for (int value : values) {
        contactNotices_.add(value);
      }
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the contact settings.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the contact settings.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the contact settings.
     * </pre>
     *
     * <code>bool validate_only = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000010);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest)
  private static final com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest();
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConfigureContactSettingsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ConfigureContactSettingsRequest>() {
        @java.lang.Override
        public ConfigureContactSettingsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConfigureContactSettingsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConfigureContactSettingsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ConfigureContactSettingsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
