/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Request for the `ConfigureDnsSettings` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest}
 */
public final class ConfigureDnsSettingsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest)
    ConfigureDnsSettingsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConfigureDnsSettingsRequest.newBuilder() to construct.
  private ConfigureDnsSettingsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConfigureDnsSettingsRequest() {
    registration_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConfigureDnsSettingsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ConfigureDnsSettingsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ConfigureDnsSettingsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.class,
            com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.Builder.class);
  }

  public static final int REGISTRATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object registration_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the `Registration` whose DNS settings are being updated,
   * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
   * </pre>
   *
   * <code>
   * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The registration.
   */
  @java.lang.Override
  public java.lang.String getRegistration() {
    java.lang.Object ref = registration_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      registration_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the `Registration` whose DNS settings are being updated,
   * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
   * </pre>
   *
   * <code>
   * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for registration.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegistrationBytes() {
    java.lang.Object ref = registration_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      registration_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DNS_SETTINGS_FIELD_NUMBER = 2;
  private com.google.cloud.domains.v1alpha2.DnsSettings dnsSettings_;
  /**
   *
   *
   * <pre>
   * Fields of the `DnsSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
   *
   * @return Whether the dnsSettings field is set.
   */
  @java.lang.Override
  public boolean hasDnsSettings() {
    return dnsSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Fields of the `DnsSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
   *
   * @return The dnsSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings getDnsSettings() {
    return dnsSettings_ == null
        ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
        : dnsSettings_;
  }
  /**
   *
   *
   * <pre>
   * Fields of the `DnsSettings` to update.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder getDnsSettingsOrBuilder() {
    return dnsSettings_ == null
        ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
        : dnsSettings_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the name servers are being updated for an existing
   * Custom DNS configuration, the `update_mask` is
   * `"custom_dns.name_servers"`.
   *
   * When changing the DNS provider from one type to another, pass the new
   * provider's field name as part of the field mask. For example, when changing
   * from a Google Domains DNS configuration to a Custom DNS configuration, the
   * `update_mask` is `"custom_dns"`. //
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the name servers are being updated for an existing
   * Custom DNS configuration, the `update_mask` is
   * `"custom_dns.name_servers"`.
   *
   * When changing the DNS provider from one type to another, pass the new
   * provider's field name as part of the field mask. For example, when changing
   * from a Google Domains DNS configuration to a Custom DNS configuration, the
   * `update_mask` is `"custom_dns"`. //
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. The field mask describing which fields to update as a comma-separated list.
   * For example, if only the name servers are being updated for an existing
   * Custom DNS configuration, the `update_mask` is
   * `"custom_dns.name_servers"`.
   *
   * When changing the DNS provider from one type to another, pass the new
   * provider's field name as part of the field mask. For example, when changing
   * from a Google Domains DNS configuration to a Custom DNS configuration, the
   * `update_mask` is `"custom_dns"`. //
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 4;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Validate the request without actually updating the DNS settings.
   * </pre>
   *
   * <code>bool validate_only = 4;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registration_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, registration_);
    }
    if (dnsSettings_ != null) {
      output.writeMessage(2, getDnsSettings());
    }
    if (updateMask_ != null) {
      output.writeMessage(3, getUpdateMask());
    }
    if (validateOnly_ != false) {
      output.writeBool(4, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(registration_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, registration_);
    }
    if (dnsSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDnsSettings());
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateMask());
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest other =
        (com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest) obj;

    if (!getRegistration().equals(other.getRegistration())) return false;
    if (hasDnsSettings() != other.hasDnsSettings()) return false;
    if (hasDnsSettings()) {
      if (!getDnsSettings().equals(other.getDnsSettings())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REGISTRATION_FIELD_NUMBER;
    hash = (53 * hash) + getRegistration().hashCode();
    if (hasDnsSettings()) {
      hash = (37 * hash) + DNS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getDnsSettings().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the `ConfigureDnsSettings` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest)
      com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureDnsSettingsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureDnsSettingsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.class,
              com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      registration_ = "";
      dnsSettings_ = null;
      if (dnsSettingsBuilder_ != null) {
        dnsSettingsBuilder_.dispose();
        dnsSettingsBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ConfigureDnsSettingsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest build() {
      com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest buildPartial() {
      com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest result =
          new com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.registration_ = registration_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dnsSettings_ =
            dnsSettingsBuilder_ == null ? dnsSettings_ : dnsSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest other) {
      if (other
          == com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest.getDefaultInstance())
        return this;
      if (!other.getRegistration().isEmpty()) {
        registration_ = other.registration_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDnsSettings()) {
        mergeDnsSettings(other.getDnsSettings());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                registration_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDnsSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object registration_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose DNS settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The registration.
     */
    public java.lang.String getRegistration() {
      java.lang.Object ref = registration_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        registration_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose DNS settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for registration.
     */
    public com.google.protobuf.ByteString getRegistrationBytes() {
      java.lang.Object ref = registration_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        registration_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose DNS settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The registration to set.
     * @return This builder for chaining.
     */
    public Builder setRegistration(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      registration_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose DNS settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegistration() {
      registration_ = getDefaultInstance().getRegistration();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the `Registration` whose DNS settings are being updated,
     * in the format `projects/&#42;&#47;locations/&#42;&#47;registrations/&#42;`.
     * </pre>
     *
     * <code>
     * string registration = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for registration to set.
     * @return This builder for chaining.
     */
    public Builder setRegistrationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      registration_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.domains.v1alpha2.DnsSettings dnsSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings,
            com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>
        dnsSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     *
     * @return Whether the dnsSettings field is set.
     */
    public boolean hasDnsSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     *
     * @return The dnsSettings.
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings getDnsSettings() {
      if (dnsSettingsBuilder_ == null) {
        return dnsSettings_ == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
            : dnsSettings_;
      } else {
        return dnsSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public Builder setDnsSettings(com.google.cloud.domains.v1alpha2.DnsSettings value) {
      if (dnsSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsSettings_ = value;
      } else {
        dnsSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public Builder setDnsSettings(
        com.google.cloud.domains.v1alpha2.DnsSettings.Builder builderForValue) {
      if (dnsSettingsBuilder_ == null) {
        dnsSettings_ = builderForValue.build();
      } else {
        dnsSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public Builder mergeDnsSettings(com.google.cloud.domains.v1alpha2.DnsSettings value) {
      if (dnsSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dnsSettings_ != null
            && dnsSettings_ != com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()) {
          getDnsSettingsBuilder().mergeFrom(value);
        } else {
          dnsSettings_ = value;
        }
      } else {
        dnsSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public Builder clearDnsSettings() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dnsSettings_ = null;
      if (dnsSettingsBuilder_ != null) {
        dnsSettingsBuilder_.dispose();
        dnsSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.Builder getDnsSettingsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDnsSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder getDnsSettingsOrBuilder() {
      if (dnsSettingsBuilder_ != null) {
        return dnsSettingsBuilder_.getMessageOrBuilder();
      } else {
        return dnsSettings_ == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
            : dnsSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Fields of the `DnsSettings` to update.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings,
            com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>
        getDnsSettingsFieldBuilder() {
      if (dnsSettingsBuilder_ == null) {
        dnsSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.DnsSettings,
                com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
                com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>(
                getDnsSettings(), getParentForChildren(), isClean());
        dnsSettings_ = null;
      }
      return dnsSettingsBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The field mask describing which fields to update as a comma-separated list.
     * For example, if only the name servers are being updated for an existing
     * Custom DNS configuration, the `update_mask` is
     * `"custom_dns.name_servers"`.
     *
     * When changing the DNS provider from one type to another, pass the new
     * provider's field name as part of the field mask. For example, when changing
     * from a Google Domains DNS configuration to a Custom DNS configuration, the
     * `update_mask` is `"custom_dns"`. //
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the DNS settings.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the DNS settings.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validate the request without actually updating the DNS settings.
     * </pre>
     *
     * <code>bool validate_only = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000008);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest)
  private static final com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest();
  }

  public static com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConfigureDnsSettingsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ConfigureDnsSettingsRequest>() {
        @java.lang.Override
        public ConfigureDnsSettingsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConfigureDnsSettingsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConfigureDnsSettingsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ConfigureDnsSettingsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
