/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Defines the contact information associated with a `Registration`.
 *
 * [ICANN](https://icann.org/) requires all domain names to have associated
 * contact information. The `registrant_contact` is considered the
 * domain's legal owner, and often the other contacts are identical.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.ContactSettings}
 */
public final class ContactSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.ContactSettings)
    ContactSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ContactSettings.newBuilder() to construct.
  private ContactSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContactSettings() {
    privacy_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContactSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ContactSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_ContactSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.ContactSettings.class,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder.class);
  }

  public interface ContactOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.domains.v1alpha2.ContactSettings.Contact)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the postalAddress field is set.
     */
    boolean hasPostalAddress();
    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The postalAddress.
     */
    com.google.type.PostalAddress getPostalAddress();
    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. Email address of the contact.
     * </pre>
     *
     * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The email.
     */
    java.lang.String getEmail();
    /**
     *
     *
     * <pre>
     * Required. Email address of the contact.
     * </pre>
     *
     * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for email.
     */
    com.google.protobuf.ByteString getEmailBytes();

    /**
     *
     *
     * <pre>
     * Required. Phone number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The phoneNumber.
     */
    java.lang.String getPhoneNumber();
    /**
     *
     *
     * <pre>
     * Required. Phone number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for phoneNumber.
     */
    com.google.protobuf.ByteString getPhoneNumberBytes();

    /**
     *
     *
     * <pre>
     * Fax number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string fax_number = 4;</code>
     *
     * @return The faxNumber.
     */
    java.lang.String getFaxNumber();
    /**
     *
     *
     * <pre>
     * Fax number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string fax_number = 4;</code>
     *
     * @return The bytes for faxNumber.
     */
    com.google.protobuf.ByteString getFaxNumberBytes();
  }
  /**
   *
   *
   * <pre>
   * Details required for a contact associated with a `Registration`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.ContactSettings.Contact}
   */
  public static final class Contact extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.ContactSettings.Contact)
      ContactOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Contact.newBuilder() to construct.
    private Contact(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Contact() {
      email_ = "";
      phoneNumber_ = "";
      faxNumber_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Contact();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ContactSettings_Contact_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ContactSettings_Contact_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.ContactSettings.Contact.class,
              com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder.class);
    }

    public static final int POSTAL_ADDRESS_FIELD_NUMBER = 1;
    private com.google.type.PostalAddress postalAddress_;
    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the postalAddress field is set.
     */
    @java.lang.Override
    public boolean hasPostalAddress() {
      return postalAddress_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The postalAddress.
     */
    @java.lang.Override
    public com.google.type.PostalAddress getPostalAddress() {
      return postalAddress_ == null
          ? com.google.type.PostalAddress.getDefaultInstance()
          : postalAddress_;
    }
    /**
     *
     *
     * <pre>
     * Required. Postal address of the contact.
     * </pre>
     *
     * <code>
     * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder() {
      return postalAddress_ == null
          ? com.google.type.PostalAddress.getDefaultInstance()
          : postalAddress_;
    }

    public static final int EMAIL_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object email_ = "";
    /**
     *
     *
     * <pre>
     * Required. Email address of the contact.
     * </pre>
     *
     * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The email.
     */
    @java.lang.Override
    public java.lang.String getEmail() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        email_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Email address of the contact.
     * </pre>
     *
     * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for email.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEmailBytes() {
      java.lang.Object ref = email_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        email_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PHONE_NUMBER_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object phoneNumber_ = "";
    /**
     *
     *
     * <pre>
     * Required. Phone number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The phoneNumber.
     */
    @java.lang.Override
    public java.lang.String getPhoneNumber() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phoneNumber_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Phone number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for phoneNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPhoneNumberBytes() {
      java.lang.Object ref = phoneNumber_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phoneNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FAX_NUMBER_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object faxNumber_ = "";
    /**
     *
     *
     * <pre>
     * Fax number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string fax_number = 4;</code>
     *
     * @return The faxNumber.
     */
    @java.lang.Override
    public java.lang.String getFaxNumber() {
      java.lang.Object ref = faxNumber_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        faxNumber_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Fax number of the contact in international format. For example,
     * `"+1-800-555-0123"`.
     * </pre>
     *
     * <code>string fax_number = 4;</code>
     *
     * @return The bytes for faxNumber.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFaxNumberBytes() {
      java.lang.Object ref = faxNumber_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        faxNumber_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (postalAddress_ != null) {
        output.writeMessage(1, getPostalAddress());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, email_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, phoneNumber_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(faxNumber_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, faxNumber_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (postalAddress_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPostalAddress());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(email_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, email_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(phoneNumber_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, phoneNumber_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(faxNumber_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, faxNumber_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.domains.v1alpha2.ContactSettings.Contact)) {
        return super.equals(obj);
      }
      com.google.cloud.domains.v1alpha2.ContactSettings.Contact other =
          (com.google.cloud.domains.v1alpha2.ContactSettings.Contact) obj;

      if (hasPostalAddress() != other.hasPostalAddress()) return false;
      if (hasPostalAddress()) {
        if (!getPostalAddress().equals(other.getPostalAddress())) return false;
      }
      if (!getEmail().equals(other.getEmail())) return false;
      if (!getPhoneNumber().equals(other.getPhoneNumber())) return false;
      if (!getFaxNumber().equals(other.getFaxNumber())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPostalAddress()) {
        hash = (37 * hash) + POSTAL_ADDRESS_FIELD_NUMBER;
        hash = (53 * hash) + getPostalAddress().hashCode();
      }
      hash = (37 * hash) + EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getEmail().hashCode();
      hash = (37 * hash) + PHONE_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPhoneNumber().hashCode();
      hash = (37 * hash) + FAX_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getFaxNumber().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details required for a contact associated with a `Registration`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.domains.v1alpha2.ContactSettings.Contact}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.ContactSettings.Contact)
        com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_ContactSettings_Contact_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_ContactSettings_Contact_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact.class,
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder.class);
      }

      // Construct using com.google.cloud.domains.v1alpha2.ContactSettings.Contact.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        postalAddress_ = null;
        if (postalAddressBuilder_ != null) {
          postalAddressBuilder_.dispose();
          postalAddressBuilder_ = null;
        }
        email_ = "";
        phoneNumber_ = "";
        faxNumber_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_ContactSettings_Contact_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getDefaultInstanceForType() {
        return com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.ContactSettings.Contact build() {
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.ContactSettings.Contact buildPartial() {
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact result =
            new com.google.cloud.domains.v1alpha2.ContactSettings.Contact(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.domains.v1alpha2.ContactSettings.Contact result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.postalAddress_ =
              postalAddressBuilder_ == null ? postalAddress_ : postalAddressBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.email_ = email_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.phoneNumber_ = phoneNumber_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.faxNumber_ = faxNumber_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.domains.v1alpha2.ContactSettings.Contact) {
          return mergeFrom((com.google.cloud.domains.v1alpha2.ContactSettings.Contact) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.domains.v1alpha2.ContactSettings.Contact other) {
        if (other == com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance())
          return this;
        if (other.hasPostalAddress()) {
          mergePostalAddress(other.getPostalAddress());
        }
        if (!other.getEmail().isEmpty()) {
          email_ = other.email_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPhoneNumber().isEmpty()) {
          phoneNumber_ = other.phoneNumber_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getFaxNumber().isEmpty()) {
          faxNumber_ = other.faxNumber_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPostalAddressFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  email_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  phoneNumber_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  faxNumber_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.type.PostalAddress postalAddress_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.PostalAddress,
              com.google.type.PostalAddress.Builder,
              com.google.type.PostalAddressOrBuilder>
          postalAddressBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the postalAddress field is set.
       */
      public boolean hasPostalAddress() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The postalAddress.
       */
      public com.google.type.PostalAddress getPostalAddress() {
        if (postalAddressBuilder_ == null) {
          return postalAddress_ == null
              ? com.google.type.PostalAddress.getDefaultInstance()
              : postalAddress_;
        } else {
          return postalAddressBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPostalAddress(com.google.type.PostalAddress value) {
        if (postalAddressBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          postalAddress_ = value;
        } else {
          postalAddressBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setPostalAddress(com.google.type.PostalAddress.Builder builderForValue) {
        if (postalAddressBuilder_ == null) {
          postalAddress_ = builderForValue.build();
        } else {
          postalAddressBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergePostalAddress(com.google.type.PostalAddress value) {
        if (postalAddressBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && postalAddress_ != null
              && postalAddress_ != com.google.type.PostalAddress.getDefaultInstance()) {
            getPostalAddressBuilder().mergeFrom(value);
          } else {
            postalAddress_ = value;
          }
        } else {
          postalAddressBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearPostalAddress() {
        bitField0_ = (bitField0_ & ~0x00000001);
        postalAddress_ = null;
        if (postalAddressBuilder_ != null) {
          postalAddressBuilder_.dispose();
          postalAddressBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.PostalAddress.Builder getPostalAddressBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPostalAddressFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.type.PostalAddressOrBuilder getPostalAddressOrBuilder() {
        if (postalAddressBuilder_ != null) {
          return postalAddressBuilder_.getMessageOrBuilder();
        } else {
          return postalAddress_ == null
              ? com.google.type.PostalAddress.getDefaultInstance()
              : postalAddress_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Postal address of the contact.
       * </pre>
       *
       * <code>
       * .google.type.PostalAddress postal_address = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.PostalAddress,
              com.google.type.PostalAddress.Builder,
              com.google.type.PostalAddressOrBuilder>
          getPostalAddressFieldBuilder() {
        if (postalAddressBuilder_ == null) {
          postalAddressBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.PostalAddress,
                  com.google.type.PostalAddress.Builder,
                  com.google.type.PostalAddressOrBuilder>(
                  getPostalAddress(), getParentForChildren(), isClean());
          postalAddress_ = null;
        }
        return postalAddressBuilder_;
      }

      private java.lang.Object email_ = "";
      /**
       *
       *
       * <pre>
       * Required. Email address of the contact.
       * </pre>
       *
       * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The email.
       */
      public java.lang.String getEmail() {
        java.lang.Object ref = email_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          email_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Email address of the contact.
       * </pre>
       *
       * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for email.
       */
      public com.google.protobuf.ByteString getEmailBytes() {
        java.lang.Object ref = email_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          email_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Email address of the contact.
       * </pre>
       *
       * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The email to set.
       * @return This builder for chaining.
       */
      public Builder setEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        email_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Email address of the contact.
       * </pre>
       *
       * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmail() {
        email_ = getDefaultInstance().getEmail();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Email address of the contact.
       * </pre>
       *
       * <code>string email = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for email to set.
       * @return This builder for chaining.
       */
      public Builder setEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        email_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object phoneNumber_ = "";
      /**
       *
       *
       * <pre>
       * Required. Phone number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The phoneNumber.
       */
      public java.lang.String getPhoneNumber() {
        java.lang.Object ref = phoneNumber_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          phoneNumber_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Phone number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for phoneNumber.
       */
      public com.google.protobuf.ByteString getPhoneNumberBytes() {
        java.lang.Object ref = phoneNumber_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          phoneNumber_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Phone number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        phoneNumber_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Phone number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPhoneNumber() {
        phoneNumber_ = getDefaultInstance().getPhoneNumber();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Phone number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string phone_number = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for phoneNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPhoneNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        phoneNumber_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object faxNumber_ = "";
      /**
       *
       *
       * <pre>
       * Fax number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string fax_number = 4;</code>
       *
       * @return The faxNumber.
       */
      public java.lang.String getFaxNumber() {
        java.lang.Object ref = faxNumber_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          faxNumber_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Fax number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string fax_number = 4;</code>
       *
       * @return The bytes for faxNumber.
       */
      public com.google.protobuf.ByteString getFaxNumberBytes() {
        java.lang.Object ref = faxNumber_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          faxNumber_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Fax number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string fax_number = 4;</code>
       *
       * @param value The faxNumber to set.
       * @return This builder for chaining.
       */
      public Builder setFaxNumber(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        faxNumber_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fax number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string fax_number = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFaxNumber() {
        faxNumber_ = getDefaultInstance().getFaxNumber();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Fax number of the contact in international format. For example,
       * `"+1-800-555-0123"`.
       * </pre>
       *
       * <code>string fax_number = 4;</code>
       *
       * @param value The bytes for faxNumber to set.
       * @return This builder for chaining.
       */
      public Builder setFaxNumberBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        faxNumber_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.ContactSettings.Contact)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.ContactSettings.Contact)
    private static final com.google.cloud.domains.v1alpha2.ContactSettings.Contact DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.ContactSettings.Contact();
    }

    public static com.google.cloud.domains.v1alpha2.ContactSettings.Contact getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Contact> PARSER =
        new com.google.protobuf.AbstractParser<Contact>() {
          @java.lang.Override
          public Contact parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Contact> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Contact> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PRIVACY_FIELD_NUMBER = 1;
  private int privacy_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Privacy setting for the contacts associated with the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for privacy.
   */
  @java.lang.Override
  public int getPrivacyValue() {
    return privacy_;
  }
  /**
   *
   *
   * <pre>
   * Required. Privacy setting for the contacts associated with the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The privacy.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactPrivacy getPrivacy() {
    com.google.cloud.domains.v1alpha2.ContactPrivacy result =
        com.google.cloud.domains.v1alpha2.ContactPrivacy.forNumber(privacy_);
    return result == null ? com.google.cloud.domains.v1alpha2.ContactPrivacy.UNRECOGNIZED : result;
  }

  public static final int REGISTRANT_CONTACT_FIELD_NUMBER = 2;
  private com.google.cloud.domains.v1alpha2.ContactSettings.Contact registrantContact_;
  /**
   *
   *
   * <pre>
   * Required. The registrant contact for the `Registration`.
   *
   * *Caution: Anyone with access to this email address, phone number,
   * and/or postal address can take control of the domain.*
   *
   * *Warning: For new `Registration`s, the registrant receives an email
   * confirmation that they must complete within 15 days to avoid domain
   * suspension.*
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the registrantContact field is set.
   */
  @java.lang.Override
  public boolean hasRegistrantContact() {
    return registrantContact_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The registrant contact for the `Registration`.
   *
   * *Caution: Anyone with access to this email address, phone number,
   * and/or postal address can take control of the domain.*
   *
   * *Warning: For new `Registration`s, the registrant receives an email
   * confirmation that they must complete within 15 days to avoid domain
   * suspension.*
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The registrantContact.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getRegistrantContact() {
    return registrantContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : registrantContact_;
  }
  /**
   *
   *
   * <pre>
   * Required. The registrant contact for the `Registration`.
   *
   * *Caution: Anyone with access to this email address, phone number,
   * and/or postal address can take control of the domain.*
   *
   * *Warning: For new `Registration`s, the registrant receives an email
   * confirmation that they must complete within 15 days to avoid domain
   * suspension.*
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
      getRegistrantContactOrBuilder() {
    return registrantContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : registrantContact_;
  }

  public static final int ADMIN_CONTACT_FIELD_NUMBER = 3;
  private com.google.cloud.domains.v1alpha2.ContactSettings.Contact adminContact_;
  /**
   *
   *
   * <pre>
   * Required. The administrative contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the adminContact field is set.
   */
  @java.lang.Override
  public boolean hasAdminContact() {
    return adminContact_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The administrative contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The adminContact.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getAdminContact() {
    return adminContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : adminContact_;
  }
  /**
   *
   *
   * <pre>
   * Required. The administrative contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
      getAdminContactOrBuilder() {
    return adminContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : adminContact_;
  }

  public static final int TECHNICAL_CONTACT_FIELD_NUMBER = 4;
  private com.google.cloud.domains.v1alpha2.ContactSettings.Contact technicalContact_;
  /**
   *
   *
   * <pre>
   * Required. The technical contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the technicalContact field is set.
   */
  @java.lang.Override
  public boolean hasTechnicalContact() {
    return technicalContact_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The technical contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The technicalContact.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getTechnicalContact() {
    return technicalContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : technicalContact_;
  }
  /**
   *
   *
   * <pre>
   * Required. The technical contact for the `Registration`.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
      getTechnicalContactOrBuilder() {
    return technicalContact_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
        : technicalContact_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (privacy_
        != com.google.cloud.domains.v1alpha2.ContactPrivacy.CONTACT_PRIVACY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, privacy_);
    }
    if (registrantContact_ != null) {
      output.writeMessage(2, getRegistrantContact());
    }
    if (adminContact_ != null) {
      output.writeMessage(3, getAdminContact());
    }
    if (technicalContact_ != null) {
      output.writeMessage(4, getTechnicalContact());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (privacy_
        != com.google.cloud.domains.v1alpha2.ContactPrivacy.CONTACT_PRIVACY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, privacy_);
    }
    if (registrantContact_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRegistrantContact());
    }
    if (adminContact_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAdminContact());
    }
    if (technicalContact_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTechnicalContact());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.ContactSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.ContactSettings other =
        (com.google.cloud.domains.v1alpha2.ContactSettings) obj;

    if (privacy_ != other.privacy_) return false;
    if (hasRegistrantContact() != other.hasRegistrantContact()) return false;
    if (hasRegistrantContact()) {
      if (!getRegistrantContact().equals(other.getRegistrantContact())) return false;
    }
    if (hasAdminContact() != other.hasAdminContact()) return false;
    if (hasAdminContact()) {
      if (!getAdminContact().equals(other.getAdminContact())) return false;
    }
    if (hasTechnicalContact() != other.hasTechnicalContact()) return false;
    if (hasTechnicalContact()) {
      if (!getTechnicalContact().equals(other.getTechnicalContact())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRIVACY_FIELD_NUMBER;
    hash = (53 * hash) + privacy_;
    if (hasRegistrantContact()) {
      hash = (37 * hash) + REGISTRANT_CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getRegistrantContact().hashCode();
    }
    if (hasAdminContact()) {
      hash = (37 * hash) + ADMIN_CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getAdminContact().hashCode();
    }
    if (hasTechnicalContact()) {
      hash = (37 * hash) + TECHNICAL_CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getTechnicalContact().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.domains.v1alpha2.ContactSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the contact information associated with a `Registration`.
   *
   * [ICANN](https://icann.org/) requires all domain names to have associated
   * contact information. The `registrant_contact` is considered the
   * domain's legal owner, and often the other contacts are identical.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.ContactSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.ContactSettings)
      com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ContactSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ContactSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.ContactSettings.class,
              com.google.cloud.domains.v1alpha2.ContactSettings.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.ContactSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      privacy_ = 0;
      registrantContact_ = null;
      if (registrantContactBuilder_ != null) {
        registrantContactBuilder_.dispose();
        registrantContactBuilder_ = null;
      }
      adminContact_ = null;
      if (adminContactBuilder_ != null) {
        adminContactBuilder_.dispose();
        adminContactBuilder_ = null;
      }
      technicalContact_ = null;
      if (technicalContactBuilder_ != null) {
        technicalContactBuilder_.dispose();
        technicalContactBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_ContactSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ContactSettings getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ContactSettings build() {
      com.google.cloud.domains.v1alpha2.ContactSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ContactSettings buildPartial() {
      com.google.cloud.domains.v1alpha2.ContactSettings result =
          new com.google.cloud.domains.v1alpha2.ContactSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.ContactSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.privacy_ = privacy_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.registrantContact_ =
            registrantContactBuilder_ == null
                ? registrantContact_
                : registrantContactBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.adminContact_ =
            adminContactBuilder_ == null ? adminContact_ : adminContactBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.technicalContact_ =
            technicalContactBuilder_ == null ? technicalContact_ : technicalContactBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.ContactSettings) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.ContactSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.ContactSettings other) {
      if (other == com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance())
        return this;
      if (other.privacy_ != 0) {
        setPrivacyValue(other.getPrivacyValue());
      }
      if (other.hasRegistrantContact()) {
        mergeRegistrantContact(other.getRegistrantContact());
      }
      if (other.hasAdminContact()) {
        mergeAdminContact(other.getAdminContact());
      }
      if (other.hasTechnicalContact()) {
        mergeTechnicalContact(other.getTechnicalContact());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                privacy_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getRegistrantContactFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAdminContactFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getTechnicalContactFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int privacy_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Privacy setting for the contacts associated with the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for privacy.
     */
    @java.lang.Override
    public int getPrivacyValue() {
      return privacy_;
    }
    /**
     *
     *
     * <pre>
     * Required. Privacy setting for the contacts associated with the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for privacy to set.
     * @return This builder for chaining.
     */
    public Builder setPrivacyValue(int value) {
      privacy_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Privacy setting for the contacts associated with the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The privacy.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.ContactPrivacy getPrivacy() {
      com.google.cloud.domains.v1alpha2.ContactPrivacy result =
          com.google.cloud.domains.v1alpha2.ContactPrivacy.forNumber(privacy_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.ContactPrivacy.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Privacy setting for the contacts associated with the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The privacy to set.
     * @return This builder for chaining.
     */
    public Builder setPrivacy(com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      privacy_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Privacy setting for the contacts associated with the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactPrivacy privacy = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivacy() {
      bitField0_ = (bitField0_ & ~0x00000001);
      privacy_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings.Contact registrantContact_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        registrantContactBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the registrantContact field is set.
     */
    public boolean hasRegistrantContact() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The registrantContact.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getRegistrantContact() {
      if (registrantContactBuilder_ == null) {
        return registrantContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : registrantContact_;
      } else {
        return registrantContactBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegistrantContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (registrantContactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        registrantContact_ = value;
      } else {
        registrantContactBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegistrantContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder builderForValue) {
      if (registrantContactBuilder_ == null) {
        registrantContact_ = builderForValue.build();
      } else {
        registrantContactBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRegistrantContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (registrantContactBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && registrantContact_ != null
            && registrantContact_
                != com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()) {
          getRegistrantContactBuilder().mergeFrom(value);
        } else {
          registrantContact_ = value;
        }
      } else {
        registrantContactBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRegistrantContact() {
      bitField0_ = (bitField0_ & ~0x00000002);
      registrantContact_ = null;
      if (registrantContactBuilder_ != null) {
        registrantContactBuilder_.dispose();
        registrantContactBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder
        getRegistrantContactBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRegistrantContactFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
        getRegistrantContactOrBuilder() {
      if (registrantContactBuilder_ != null) {
        return registrantContactBuilder_.getMessageOrBuilder();
      } else {
        return registrantContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : registrantContact_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The registrant contact for the `Registration`.
     *
     * *Caution: Anyone with access to this email address, phone number,
     * and/or postal address can take control of the domain.*
     *
     * *Warning: For new `Registration`s, the registrant receives an email
     * confirmation that they must complete within 15 days to avoid domain
     * suspension.*
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact registrant_contact = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        getRegistrantContactFieldBuilder() {
      if (registrantContactBuilder_ == null) {
        registrantContactBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>(
                getRegistrantContact(), getParentForChildren(), isClean());
        registrantContact_ = null;
      }
      return registrantContactBuilder_;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings.Contact adminContact_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        adminContactBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the adminContact field is set.
     */
    public boolean hasAdminContact() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The adminContact.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getAdminContact() {
      if (adminContactBuilder_ == null) {
        return adminContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : adminContact_;
      } else {
        return adminContactBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAdminContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (adminContactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adminContact_ = value;
      } else {
        adminContactBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAdminContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder builderForValue) {
      if (adminContactBuilder_ == null) {
        adminContact_ = builderForValue.build();
      } else {
        adminContactBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAdminContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (adminContactBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && adminContact_ != null
            && adminContact_
                != com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()) {
          getAdminContactBuilder().mergeFrom(value);
        } else {
          adminContact_ = value;
        }
      } else {
        adminContactBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAdminContact() {
      bitField0_ = (bitField0_ & ~0x00000004);
      adminContact_ = null;
      if (adminContactBuilder_ != null) {
        adminContactBuilder_.dispose();
        adminContactBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder
        getAdminContactBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAdminContactFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
        getAdminContactOrBuilder() {
      if (adminContactBuilder_ != null) {
        return adminContactBuilder_.getMessageOrBuilder();
      } else {
        return adminContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : adminContact_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The administrative contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact admin_contact = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        getAdminContactFieldBuilder() {
      if (adminContactBuilder_ == null) {
        adminContactBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>(
                getAdminContact(), getParentForChildren(), isClean());
        adminContact_ = null;
      }
      return adminContactBuilder_;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings.Contact technicalContact_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        technicalContactBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the technicalContact field is set.
     */
    public boolean hasTechnicalContact() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The technicalContact.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact getTechnicalContact() {
      if (technicalContactBuilder_ == null) {
        return technicalContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : technicalContact_;
      } else {
        return technicalContactBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTechnicalContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (technicalContactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        technicalContact_ = value;
      } else {
        technicalContactBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTechnicalContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder builderForValue) {
      if (technicalContactBuilder_ == null) {
        technicalContact_ = builderForValue.build();
      } else {
        technicalContactBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTechnicalContact(
        com.google.cloud.domains.v1alpha2.ContactSettings.Contact value) {
      if (technicalContactBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && technicalContact_ != null
            && technicalContact_
                != com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()) {
          getTechnicalContactBuilder().mergeFrom(value);
        } else {
          technicalContact_ = value;
        }
      } else {
        technicalContactBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTechnicalContact() {
      bitField0_ = (bitField0_ & ~0x00000008);
      technicalContact_ = null;
      if (technicalContactBuilder_ != null) {
        technicalContactBuilder_.dispose();
        technicalContactBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder
        getTechnicalContactBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getTechnicalContactFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder
        getTechnicalContactOrBuilder() {
      if (technicalContactBuilder_ != null) {
        return technicalContactBuilder_.getMessageOrBuilder();
      } else {
        return technicalContact_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.Contact.getDefaultInstance()
            : technicalContact_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The technical contact for the `Registration`.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings.Contact technical_contact = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
            com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>
        getTechnicalContactFieldBuilder() {
      if (technicalContactBuilder_ == null) {
        technicalContactBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact,
                com.google.cloud.domains.v1alpha2.ContactSettings.Contact.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettings.ContactOrBuilder>(
                getTechnicalContact(), getParentForChildren(), isClean());
        technicalContact_ = null;
      }
      return technicalContactBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.ContactSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.ContactSettings)
  private static final com.google.cloud.domains.v1alpha2.ContactSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.ContactSettings();
  }

  public static com.google.cloud.domains.v1alpha2.ContactSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContactSettings> PARSER =
      new com.google.protobuf.AbstractParser<ContactSettings>() {
        @java.lang.Override
        public ContactSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContactSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContactSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
