/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Defines the DNS configuration of a `Registration`, including name servers,
 * DNSSEC, and glue records.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings}
 */
public final class DnsSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.DnsSettings)
    DnsSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DnsSettings.newBuilder() to construct.
  private DnsSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DnsSettings() {
    glueRecords_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DnsSettings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_DnsSettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_DnsSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.DnsSettings.class,
            com.google.cloud.domains.v1alpha2.DnsSettings.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The publication state of DS records for a `Registration`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.domains.v1alpha2.DnsSettings.DsState}
   */
  public enum DsState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * DS state is unspecified.
     * </pre>
     *
     * <code>DS_STATE_UNSPECIFIED = 0;</code>
     */
    DS_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * DNSSEC is disabled for this domain. No DS records for this domain are
     * published in the parent DNS zone.
     * </pre>
     *
     * <code>DS_RECORDS_UNPUBLISHED = 1;</code>
     */
    DS_RECORDS_UNPUBLISHED(1),
    /**
     *
     *
     * <pre>
     * DNSSEC is enabled for this domain. Appropriate DS records for this domain
     * are published in the parent DNS zone. This option is valid only if the
     * DNS zone referenced in the `Registration`'s `dns_provider` field is
     * already DNSSEC-signed.
     * </pre>
     *
     * <code>DS_RECORDS_PUBLISHED = 2;</code>
     */
    DS_RECORDS_PUBLISHED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * DS state is unspecified.
     * </pre>
     *
     * <code>DS_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DS_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * DNSSEC is disabled for this domain. No DS records for this domain are
     * published in the parent DNS zone.
     * </pre>
     *
     * <code>DS_RECORDS_UNPUBLISHED = 1;</code>
     */
    public static final int DS_RECORDS_UNPUBLISHED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * DNSSEC is enabled for this domain. Appropriate DS records for this domain
     * are published in the parent DNS zone. This option is valid only if the
     * DNS zone referenced in the `Registration`'s `dns_provider` field is
     * already DNSSEC-signed.
     * </pre>
     *
     * <code>DS_RECORDS_PUBLISHED = 2;</code>
     */
    public static final int DS_RECORDS_PUBLISHED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DsState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DsState forNumber(int value) {
      switch (value) {
        case 0:
          return DS_STATE_UNSPECIFIED;
        case 1:
          return DS_RECORDS_UNPUBLISHED;
        case 2:
          return DS_RECORDS_PUBLISHED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DsState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DsState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DsState>() {
          public DsState findValueByNumber(int number) {
            return DsState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DnsSettings.getDescriptor().getEnumTypes().get(0);
    }

    private static final DsState[] VALUES = values();

    public static DsState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DsState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.DnsSettings.DsState)
  }

  public interface CustomDnsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.domains.v1alpha2.DnsSettings.CustomDns)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the nameServers.
     */
    java.util.List<java.lang.String> getNameServersList();
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of nameServers.
     */
    int getNameServersCount();
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The nameServers at the given index.
     */
    java.lang.String getNameServers(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the nameServers at the given index.
     */
    com.google.protobuf.ByteString getNameServersBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> getDsRecordsList();
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index);
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    int getDsRecordsCount();
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    java.util.List<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
        getDsRecordsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for an arbitrary DNS provider.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.CustomDns}
   */
  public static final class CustomDns extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.DnsSettings.CustomDns)
      CustomDnsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomDns.newBuilder() to construct.
    private CustomDns(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomDns() {
      nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dsRecords_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomDns();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_CustomDns_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_CustomDns_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.class,
              com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder.class);
    }

    public static final int NAME_SERVERS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList nameServers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the nameServers.
     */
    public com.google.protobuf.ProtocolStringList getNameServersList() {
      return nameServers_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of nameServers.
     */
    public int getNameServersCount() {
      return nameServers_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The nameServers at the given index.
     */
    public java.lang.String getNameServers(int index) {
      return nameServers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the nameServers at the given index.
     */
    public com.google.protobuf.ByteString getNameServersBytes(int index) {
      return nameServers_.getByteString(index);
    }

    public static final int DS_RECORDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> dsRecords_;
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
        getDsRecordsList() {
      return dsRecords_;
    }
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
        getDsRecordsOrBuilderList() {
      return dsRecords_;
    }
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    @java.lang.Override
    public int getDsRecordsCount() {
      return dsRecords_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index) {
      return dsRecords_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of DS records for this domain, which are used to enable DNSSEC.
     * The domain's DNS provider can provide the values to set here. If this
     * field is empty, DNSSEC is disabled.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
        int index) {
      return dsRecords_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < nameServers_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, nameServers_.getRaw(i));
      }
      for (int i = 0; i < dsRecords_.size(); i++) {
        output.writeMessage(2, dsRecords_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < nameServers_.size(); i++) {
          dataSize += computeStringSizeNoTag(nameServers_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getNameServersList().size();
      }
      for (int i = 0; i < dsRecords_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, dsRecords_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns)) {
        return super.equals(obj);
      }
      com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns other =
          (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) obj;

      if (!getNameServersList().equals(other.getNameServersList())) return false;
      if (!getDsRecordsList().equals(other.getDsRecordsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getNameServersCount() > 0) {
        hash = (37 * hash) + NAME_SERVERS_FIELD_NUMBER;
        hash = (53 * hash) + getNameServersList().hashCode();
      }
      if (getDsRecordsCount() > 0) {
        hash = (37 * hash) + DS_RECORDS_FIELD_NUMBER;
        hash = (53 * hash) + getDsRecordsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for an arbitrary DNS provider.
     * </pre>
     *
     * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.CustomDns}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.DnsSettings.CustomDns)
        com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_CustomDns_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_CustomDns_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.class,
                com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder.class);
      }

      // Construct using com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        if (dsRecordsBuilder_ == null) {
          dsRecords_ = java.util.Collections.emptyList();
        } else {
          dsRecords_ = null;
          dsRecordsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_CustomDns_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns getDefaultInstanceForType() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns build() {
        com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns buildPartial() {
        com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns result =
            new com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns result) {
        if (dsRecordsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            dsRecords_ = java.util.Collections.unmodifiableList(dsRecords_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.dsRecords_ = dsRecords_;
        } else {
          result.dsRecords_ = dsRecordsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          nameServers_.makeImmutable();
          result.nameServers_ = nameServers_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) {
          return mergeFrom((com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns other) {
        if (other == com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance())
          return this;
        if (!other.nameServers_.isEmpty()) {
          if (nameServers_.isEmpty()) {
            nameServers_ = other.nameServers_;
            bitField0_ |= 0x00000001;
          } else {
            ensureNameServersIsMutable();
            nameServers_.addAll(other.nameServers_);
          }
          onChanged();
        }
        if (dsRecordsBuilder_ == null) {
          if (!other.dsRecords_.isEmpty()) {
            if (dsRecords_.isEmpty()) {
              dsRecords_ = other.dsRecords_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureDsRecordsIsMutable();
              dsRecords_.addAll(other.dsRecords_);
            }
            onChanged();
          }
        } else {
          if (!other.dsRecords_.isEmpty()) {
            if (dsRecordsBuilder_.isEmpty()) {
              dsRecordsBuilder_.dispose();
              dsRecordsBuilder_ = null;
              dsRecords_ = other.dsRecords_;
              bitField0_ = (bitField0_ & ~0x00000002);
              dsRecordsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDsRecordsFieldBuilder()
                      : null;
            } else {
              dsRecordsBuilder_.addAllMessages(other.dsRecords_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureNameServersIsMutable();
                  nameServers_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord m =
                      input.readMessage(
                          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.parser(),
                          extensionRegistry);
                  if (dsRecordsBuilder_ == null) {
                    ensureDsRecordsIsMutable();
                    dsRecords_.add(m);
                  } else {
                    dsRecordsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList nameServers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureNameServersIsMutable() {
        if (!nameServers_.isModifiable()) {
          nameServers_ = new com.google.protobuf.LazyStringArrayList(nameServers_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the nameServers.
       */
      public com.google.protobuf.ProtocolStringList getNameServersList() {
        nameServers_.makeImmutable();
        return nameServers_;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of nameServers.
       */
      public int getNameServersCount() {
        return nameServers_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The nameServers at the given index.
       */
      public java.lang.String getNameServers(int index) {
        return nameServers_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the nameServers at the given index.
       */
      public com.google.protobuf.ByteString getNameServersBytes(int index) {
        return nameServers_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The nameServers to set.
       * @return This builder for chaining.
       */
      public Builder setNameServers(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNameServersIsMutable();
        nameServers_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addNameServers(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNameServersIsMutable();
        nameServers_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addAllNameServers(java.lang.Iterable<java.lang.String> values) {
        ensureNameServersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nameServers_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNameServers() {
        nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes of the nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addNameServersBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureNameServersIsMutable();
        nameServers_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> dsRecords_ =
          java.util.Collections.emptyList();

      private void ensureDsRecordsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          dsRecords_ =
              new java.util.ArrayList<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>(
                  dsRecords_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          dsRecordsBuilder_;

      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
          getDsRecordsList() {
        if (dsRecordsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dsRecords_);
        } else {
          return dsRecordsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public int getDsRecordsCount() {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.size();
        } else {
          return dsRecordsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index) {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.get(index);
        } else {
          return dsRecordsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder setDsRecords(
          int index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.set(index, value);
          onChanged();
        } else {
          dsRecordsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder setDsRecords(
          int index,
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.set(index, builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder addDsRecords(com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.add(value);
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder addDsRecords(
          int index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.add(index, value);
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder addDsRecords(
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.add(builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder addDsRecords(
          int index,
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.add(index, builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder addAllDsRecords(
          java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
              values) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dsRecords_);
          onChanged();
        } else {
          dsRecordsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder clearDsRecords() {
        if (dsRecordsBuilder_ == null) {
          dsRecords_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          dsRecordsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public Builder removeDsRecords(int index) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.remove(index);
          onChanged();
        } else {
          dsRecordsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder getDsRecordsBuilder(
          int index) {
        return getDsRecordsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
          int index) {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.get(index);
        } else {
          return dsRecordsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          getDsRecordsOrBuilderList() {
        if (dsRecordsBuilder_ != null) {
          return dsRecordsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dsRecords_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder addDsRecordsBuilder() {
        return getDsRecordsFieldBuilder()
            .addBuilder(
                com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder addDsRecordsBuilder(
          int index) {
        return getDsRecordsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of DS records for this domain, which are used to enable DNSSEC.
       * The domain's DNS provider can provide the values to set here. If this
       * field is empty, DNSSEC is disabled.
       * </pre>
       *
       * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 2;</code>
       */
      public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder>
          getDsRecordsBuilderList() {
        return getDsRecordsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          getDsRecordsFieldBuilder() {
        if (dsRecordsBuilder_ == null) {
          dsRecordsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>(
                  dsRecords_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          dsRecords_ = null;
        }
        return dsRecordsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.DnsSettings.CustomDns)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.DnsSettings.CustomDns)
    private static final com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns();
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomDns> PARSER =
        new com.google.protobuf.AbstractParser<CustomDns>() {
          @java.lang.Override
          public CustomDns parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomDns> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomDns> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GoogleDomainsDnsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the nameServers.
     */
    java.util.List<java.lang.String> getNameServersList();
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of nameServers.
     */
    int getNameServersCount();
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The nameServers at the given index.
     */
    java.lang.String getNameServers(int index);
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the nameServers at the given index.
     */
    com.google.protobuf.ByteString getNameServersBytes(int index);

    /**
     *
     *
     * <pre>
     * Required. The state of DS records for this domain. Used to enable or disable
     * automatic DNSSEC.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dsState.
     */
    int getDsStateValue();
    /**
     *
     *
     * <pre>
     * Required. The state of DS records for this domain. Used to enable or disable
     * automatic DNSSEC.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dsState.
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsState getDsState();

    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> getDsRecordsList();
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index);
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    int getDsRecordsCount();
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    java.util.List<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
        getDsRecordsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for using the free DNS zone provided by Google Domains as a
   * `Registration`'s `dns_provider`. You cannot configure the DNS zone itself
   * using the API. To configure the DNS zone, go to
   * [Google Domains](https://domains.google/).
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns}
   */
  public static final class GoogleDomainsDns extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)
      GoogleDomainsDnsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GoogleDomainsDns.newBuilder() to construct.
    private GoogleDomainsDns(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GoogleDomainsDns() {
      nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dsState_ = 0;
      dsRecords_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GoogleDomainsDns();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GoogleDomainsDns_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GoogleDomainsDns_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.class,
              com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder.class);
    }

    public static final int NAME_SERVERS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList nameServers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the nameServers.
     */
    public com.google.protobuf.ProtocolStringList getNameServersList() {
      return nameServers_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of nameServers.
     */
    public int getNameServersCount() {
      return nameServers_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The nameServers at the given index.
     */
    public java.lang.String getNameServers(int index) {
      return nameServers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of name servers that store the DNS zone for this domain. Each name
     * server is a domain name, with Unicode domain names expressed in
     * Punycode format. This field is automatically populated with the name
     * servers assigned to the Google Domains DNS zone.
     * </pre>
     *
     * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the nameServers at the given index.
     */
    public com.google.protobuf.ByteString getNameServersBytes(int index) {
      return nameServers_.getByteString(index);
    }

    public static final int DS_STATE_FIELD_NUMBER = 2;
    private int dsState_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The state of DS records for this domain. Used to enable or disable
     * automatic DNSSEC.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for dsState.
     */
    @java.lang.Override
    public int getDsStateValue() {
      return dsState_;
    }
    /**
     *
     *
     * <pre>
     * Required. The state of DS records for this domain. Used to enable or disable
     * automatic DNSSEC.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The dsState.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsState getDsState() {
      com.google.cloud.domains.v1alpha2.DnsSettings.DsState result =
          com.google.cloud.domains.v1alpha2.DnsSettings.DsState.forNumber(dsState_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.DnsSettings.DsState.UNRECOGNIZED
          : result;
    }

    public static final int DS_RECORDS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> dsRecords_;
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
        getDsRecordsList() {
      return dsRecords_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
        getDsRecordsOrBuilderList() {
      return dsRecords_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public int getDsRecordsCount() {
      return dsRecords_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index) {
      return dsRecords_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of DS records published for this domain. The list is
     * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
     * otherwise it remains empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
        int index) {
      return dsRecords_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < nameServers_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, nameServers_.getRaw(i));
      }
      if (dsState_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsState.DS_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, dsState_);
      }
      for (int i = 0; i < dsRecords_.size(); i++) {
        output.writeMessage(3, dsRecords_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < nameServers_.size(); i++) {
          dataSize += computeStringSizeNoTag(nameServers_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getNameServersList().size();
      }
      if (dsState_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsState.DS_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, dsState_);
      }
      for (int i = 0; i < dsRecords_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, dsRecords_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)) {
        return super.equals(obj);
      }
      com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns other =
          (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) obj;

      if (!getNameServersList().equals(other.getNameServersList())) return false;
      if (dsState_ != other.dsState_) return false;
      if (!getDsRecordsList().equals(other.getDsRecordsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getNameServersCount() > 0) {
        hash = (37 * hash) + NAME_SERVERS_FIELD_NUMBER;
        hash = (53 * hash) + getNameServersList().hashCode();
      }
      hash = (37 * hash) + DS_STATE_FIELD_NUMBER;
      hash = (53 * hash) + dsState_;
      if (getDsRecordsCount() > 0) {
        hash = (37 * hash) + DS_RECORDS_FIELD_NUMBER;
        hash = (53 * hash) + getDsRecordsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for using the free DNS zone provided by Google Domains as a
     * `Registration`'s `dns_provider`. You cannot configure the DNS zone itself
     * using the API. To configure the DNS zone, go to
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GoogleDomainsDns_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GoogleDomainsDns_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.class,
                com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder.class);
      }

      // Construct using com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        dsState_ = 0;
        if (dsRecordsBuilder_ == null) {
          dsRecords_ = java.util.Collections.emptyList();
        } else {
          dsRecords_ = null;
          dsRecordsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GoogleDomainsDns_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns
          getDefaultInstanceForType() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns build() {
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns buildPartial() {
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns result =
            new com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns result) {
        if (dsRecordsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            dsRecords_ = java.util.Collections.unmodifiableList(dsRecords_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.dsRecords_ = dsRecords_;
        } else {
          result.dsRecords_ = dsRecordsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          nameServers_.makeImmutable();
          result.nameServers_ = nameServers_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dsState_ = dsState_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) {
          return mergeFrom((com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns other) {
        if (other
            == com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance())
          return this;
        if (!other.nameServers_.isEmpty()) {
          if (nameServers_.isEmpty()) {
            nameServers_ = other.nameServers_;
            bitField0_ |= 0x00000001;
          } else {
            ensureNameServersIsMutable();
            nameServers_.addAll(other.nameServers_);
          }
          onChanged();
        }
        if (other.dsState_ != 0) {
          setDsStateValue(other.getDsStateValue());
        }
        if (dsRecordsBuilder_ == null) {
          if (!other.dsRecords_.isEmpty()) {
            if (dsRecords_.isEmpty()) {
              dsRecords_ = other.dsRecords_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDsRecordsIsMutable();
              dsRecords_.addAll(other.dsRecords_);
            }
            onChanged();
          }
        } else {
          if (!other.dsRecords_.isEmpty()) {
            if (dsRecordsBuilder_.isEmpty()) {
              dsRecordsBuilder_.dispose();
              dsRecordsBuilder_ = null;
              dsRecords_ = other.dsRecords_;
              bitField0_ = (bitField0_ & ~0x00000004);
              dsRecordsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDsRecordsFieldBuilder()
                      : null;
            } else {
              dsRecordsBuilder_.addAllMessages(other.dsRecords_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureNameServersIsMutable();
                  nameServers_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  dsState_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord m =
                      input.readMessage(
                          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.parser(),
                          extensionRegistry);
                  if (dsRecordsBuilder_ == null) {
                    ensureDsRecordsIsMutable();
                    dsRecords_.add(m);
                  } else {
                    dsRecordsBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList nameServers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureNameServersIsMutable() {
        if (!nameServers_.isModifiable()) {
          nameServers_ = new com.google.protobuf.LazyStringArrayList(nameServers_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return A list containing the nameServers.
       */
      public com.google.protobuf.ProtocolStringList getNameServersList() {
        nameServers_.makeImmutable();
        return nameServers_;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count of nameServers.
       */
      public int getNameServersCount() {
        return nameServers_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the element to return.
       * @return The nameServers at the given index.
       */
      public java.lang.String getNameServers(int index) {
        return nameServers_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the nameServers at the given index.
       */
      public com.google.protobuf.ByteString getNameServersBytes(int index) {
        return nameServers_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index to set the value at.
       * @param value The nameServers to set.
       * @return This builder for chaining.
       */
      public Builder setNameServers(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNameServersIsMutable();
        nameServers_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addNameServers(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNameServersIsMutable();
        nameServers_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param values The nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addAllNameServers(java.lang.Iterable<java.lang.String> values) {
        ensureNameServersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nameServers_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNameServers() {
        nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A list of name servers that store the DNS zone for this domain. Each name
       * server is a domain name, with Unicode domain names expressed in
       * Punycode format. This field is automatically populated with the name
       * servers assigned to the Google Domains DNS zone.
       * </pre>
       *
       * <code>repeated string name_servers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes of the nameServers to add.
       * @return This builder for chaining.
       */
      public Builder addNameServersBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureNameServersIsMutable();
        nameServers_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int dsState_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The state of DS records for this domain. Used to enable or disable
       * automatic DNSSEC.
       * </pre>
       *
       * <code>
       * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for dsState.
       */
      @java.lang.Override
      public int getDsStateValue() {
        return dsState_;
      }
      /**
       *
       *
       * <pre>
       * Required. The state of DS records for this domain. Used to enable or disable
       * automatic DNSSEC.
       * </pre>
       *
       * <code>
       * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for dsState to set.
       * @return This builder for chaining.
       */
      public Builder setDsStateValue(int value) {
        dsState_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The state of DS records for this domain. Used to enable or disable
       * automatic DNSSEC.
       * </pre>
       *
       * <code>
       * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The dsState.
       */
      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsState getDsState() {
        com.google.cloud.domains.v1alpha2.DnsSettings.DsState result =
            com.google.cloud.domains.v1alpha2.DnsSettings.DsState.forNumber(dsState_);
        return result == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.DsState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The state of DS records for this domain. Used to enable or disable
       * automatic DNSSEC.
       * </pre>
       *
       * <code>
       * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The dsState to set.
       * @return This builder for chaining.
       */
      public Builder setDsState(com.google.cloud.domains.v1alpha2.DnsSettings.DsState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        dsState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The state of DS records for this domain. Used to enable or disable
       * automatic DNSSEC.
       * </pre>
       *
       * <code>
       * .google.cloud.domains.v1alpha2.DnsSettings.DsState ds_state = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDsState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        dsState_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord> dsRecords_ =
          java.util.Collections.emptyList();

      private void ensureDsRecordsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          dsRecords_ =
              new java.util.ArrayList<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>(
                  dsRecords_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          dsRecordsBuilder_;

      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
          getDsRecordsList() {
        if (dsRecordsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dsRecords_);
        } else {
          return dsRecordsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public int getDsRecordsCount() {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.size();
        } else {
          return dsRecordsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDsRecords(int index) {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.get(index);
        } else {
          return dsRecordsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setDsRecords(
          int index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.set(index, value);
          onChanged();
        } else {
          dsRecordsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setDsRecords(
          int index,
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.set(index, builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDsRecords(com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.add(value);
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDsRecords(
          int index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord value) {
        if (dsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDsRecordsIsMutable();
          dsRecords_.add(index, value);
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDsRecords(
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.add(builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addDsRecords(
          int index,
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder builderForValue) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.add(index, builderForValue.build());
          onChanged();
        } else {
          dsRecordsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder addAllDsRecords(
          java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord>
              values) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dsRecords_);
          onChanged();
        } else {
          dsRecordsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearDsRecords() {
        if (dsRecordsBuilder_ == null) {
          dsRecords_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          dsRecordsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder removeDsRecords(int index) {
        if (dsRecordsBuilder_ == null) {
          ensureDsRecordsIsMutable();
          dsRecords_.remove(index);
          onChanged();
        } else {
          dsRecordsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder getDsRecordsBuilder(
          int index) {
        return getDsRecordsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder getDsRecordsOrBuilder(
          int index) {
        if (dsRecordsBuilder_ == null) {
          return dsRecords_.get(index);
        } else {
          return dsRecordsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          getDsRecordsOrBuilderList() {
        if (dsRecordsBuilder_ != null) {
          return dsRecordsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dsRecords_);
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder addDsRecordsBuilder() {
        return getDsRecordsFieldBuilder()
            .addBuilder(
                com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder addDsRecordsBuilder(
          int index) {
        return getDsRecordsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Output only. The list of DS records published for this domain. The list is
       * automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
       * otherwise it remains empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.domains.v1alpha2.DnsSettings.DsRecord ds_records = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder>
          getDsRecordsBuilderList() {
        return getDsRecordsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>
          getDsRecordsFieldBuilder() {
        if (dsRecordsBuilder_ == null) {
          dsRecordsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord,
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder,
                  com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder>(
                  dsRecords_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          dsRecords_ = null;
        }
        return dsRecordsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns)
    private static final com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns();
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GoogleDomainsDns> PARSER =
        new com.google.protobuf.AbstractParser<GoogleDomainsDns>() {
          @java.lang.Override
          public GoogleDomainsDns parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GoogleDomainsDns> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GoogleDomainsDns> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DsRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.domains.v1alpha2.DnsSettings.DsRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key tag of the record. Must be set in range 0 -- 65535.
     * </pre>
     *
     * <code>int32 key_tag = 1;</code>
     *
     * @return The keyTag.
     */
    int getKeyTag();

    /**
     *
     *
     * <pre>
     * The algorithm used to generate the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    int getAlgorithmValue();
    /**
     *
     *
     * <pre>
     * The algorithm used to generate the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
     *
     * @return The algorithm.
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm getAlgorithm();

    /**
     *
     *
     * <pre>
     * The hash function used to generate the digest of the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;</code>
     *
     * @return The enum numeric value on the wire for digestType.
     */
    int getDigestTypeValue();
    /**
     *
     *
     * <pre>
     * The hash function used to generate the digest of the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;</code>
     *
     * @return The digestType.
     */
    com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType getDigestType();

    /**
     *
     *
     * <pre>
     * The digest generated from the referenced DNSKEY.
     * </pre>
     *
     * <code>string digest = 4;</code>
     *
     * @return The digest.
     */
    java.lang.String getDigest();
    /**
     *
     *
     * <pre>
     * The digest generated from the referenced DNSKEY.
     * </pre>
     *
     * <code>string digest = 4;</code>
     *
     * @return The bytes for digest.
     */
    com.google.protobuf.ByteString getDigestBytes();
  }
  /**
   *
   *
   * <pre>
   * Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC
   * for a domain. It contains a digest (hash) of a DNSKEY record that must be
   * present in the domain's DNS zone.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.DsRecord}
   */
  public static final class DsRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.DnsSettings.DsRecord)
      DsRecordOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DsRecord.newBuilder() to construct.
    private DsRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DsRecord() {
      algorithm_ = 0;
      digestType_ = 0;
      digest_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DsRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_DsRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_DsRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.class,
              com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * List of algorithms used to create a DNSKEY. Certain
     * algorithms are not supported for particular domains.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm}
     */
    public enum Algorithm implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The algorithm is unspecified.
       * </pre>
       *
       * <code>ALGORITHM_UNSPECIFIED = 0;</code>
       */
      ALGORITHM_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * RSA/MD5. Cannot be used for new deployments.
       * </pre>
       *
       * <code>RSAMD5 = 1;</code>
       */
      RSAMD5(1),
      /**
       *
       *
       * <pre>
       * Diffie-Hellman. Cannot be used for new deployments.
       * </pre>
       *
       * <code>DH = 2;</code>
       */
      DH(2),
      /**
       *
       *
       * <pre>
       * DSA/SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>DSA = 3;</code>
       */
      DSA(3),
      /**
       *
       *
       * <pre>
       * ECC. Not recommended for new deployments.
       * </pre>
       *
       * <code>ECC = 4;</code>
       */
      ECC(4),
      /**
       *
       *
       * <pre>
       * RSA/SHA-1. Not recommended for new deployments.
       * </pre>
       *
       * <code>RSASHA1 = 5;</code>
       */
      RSASHA1(5),
      /**
       *
       *
       * <pre>
       * DSA-NSEC3-SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>DSANSEC3SHA1 = 6;</code>
       */
      DSANSEC3SHA1(6),
      /**
       *
       *
       * <pre>
       * RSA/SHA1-NSEC3-SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>RSASHA1NSEC3SHA1 = 7;</code>
       */
      RSASHA1NSEC3SHA1(7),
      /**
       *
       *
       * <pre>
       * RSA/SHA-256.
       * </pre>
       *
       * <code>RSASHA256 = 8;</code>
       */
      RSASHA256(8),
      /**
       *
       *
       * <pre>
       * RSA/SHA-512.
       * </pre>
       *
       * <code>RSASHA512 = 10;</code>
       */
      RSASHA512(10),
      /**
       *
       *
       * <pre>
       * GOST R 34.10-2001.
       * </pre>
       *
       * <code>ECCGOST = 12;</code>
       */
      ECCGOST(12),
      /**
       *
       *
       * <pre>
       * ECDSA Curve P-256 with SHA-256.
       * </pre>
       *
       * <code>ECDSAP256SHA256 = 13;</code>
       */
      ECDSAP256SHA256(13),
      /**
       *
       *
       * <pre>
       * ECDSA Curve P-384 with SHA-384.
       * </pre>
       *
       * <code>ECDSAP384SHA384 = 14;</code>
       */
      ECDSAP384SHA384(14),
      /**
       *
       *
       * <pre>
       * Ed25519.
       * </pre>
       *
       * <code>ED25519 = 15;</code>
       */
      ED25519(15),
      /**
       *
       *
       * <pre>
       * Ed448.
       * </pre>
       *
       * <code>ED448 = 16;</code>
       */
      ED448(16),
      /**
       *
       *
       * <pre>
       * Reserved for Indirect Keys. Cannot be used for new deployments.
       * </pre>
       *
       * <code>INDIRECT = 252;</code>
       */
      INDIRECT(252),
      /**
       *
       *
       * <pre>
       * Private algorithm. Cannot be used for new deployments.
       * </pre>
       *
       * <code>PRIVATEDNS = 253;</code>
       */
      PRIVATEDNS(253),
      /**
       *
       *
       * <pre>
       * Private algorithm OID. Cannot be used for new deployments.
       * </pre>
       *
       * <code>PRIVATEOID = 254;</code>
       */
      PRIVATEOID(254),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The algorithm is unspecified.
       * </pre>
       *
       * <code>ALGORITHM_UNSPECIFIED = 0;</code>
       */
      public static final int ALGORITHM_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * RSA/MD5. Cannot be used for new deployments.
       * </pre>
       *
       * <code>RSAMD5 = 1;</code>
       */
      public static final int RSAMD5_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Diffie-Hellman. Cannot be used for new deployments.
       * </pre>
       *
       * <code>DH = 2;</code>
       */
      public static final int DH_VALUE = 2;
      /**
       *
       *
       * <pre>
       * DSA/SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>DSA = 3;</code>
       */
      public static final int DSA_VALUE = 3;
      /**
       *
       *
       * <pre>
       * ECC. Not recommended for new deployments.
       * </pre>
       *
       * <code>ECC = 4;</code>
       */
      public static final int ECC_VALUE = 4;
      /**
       *
       *
       * <pre>
       * RSA/SHA-1. Not recommended for new deployments.
       * </pre>
       *
       * <code>RSASHA1 = 5;</code>
       */
      public static final int RSASHA1_VALUE = 5;
      /**
       *
       *
       * <pre>
       * DSA-NSEC3-SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>DSANSEC3SHA1 = 6;</code>
       */
      public static final int DSANSEC3SHA1_VALUE = 6;
      /**
       *
       *
       * <pre>
       * RSA/SHA1-NSEC3-SHA1. Not recommended for new deployments.
       * </pre>
       *
       * <code>RSASHA1NSEC3SHA1 = 7;</code>
       */
      public static final int RSASHA1NSEC3SHA1_VALUE = 7;
      /**
       *
       *
       * <pre>
       * RSA/SHA-256.
       * </pre>
       *
       * <code>RSASHA256 = 8;</code>
       */
      public static final int RSASHA256_VALUE = 8;
      /**
       *
       *
       * <pre>
       * RSA/SHA-512.
       * </pre>
       *
       * <code>RSASHA512 = 10;</code>
       */
      public static final int RSASHA512_VALUE = 10;
      /**
       *
       *
       * <pre>
       * GOST R 34.10-2001.
       * </pre>
       *
       * <code>ECCGOST = 12;</code>
       */
      public static final int ECCGOST_VALUE = 12;
      /**
       *
       *
       * <pre>
       * ECDSA Curve P-256 with SHA-256.
       * </pre>
       *
       * <code>ECDSAP256SHA256 = 13;</code>
       */
      public static final int ECDSAP256SHA256_VALUE = 13;
      /**
       *
       *
       * <pre>
       * ECDSA Curve P-384 with SHA-384.
       * </pre>
       *
       * <code>ECDSAP384SHA384 = 14;</code>
       */
      public static final int ECDSAP384SHA384_VALUE = 14;
      /**
       *
       *
       * <pre>
       * Ed25519.
       * </pre>
       *
       * <code>ED25519 = 15;</code>
       */
      public static final int ED25519_VALUE = 15;
      /**
       *
       *
       * <pre>
       * Ed448.
       * </pre>
       *
       * <code>ED448 = 16;</code>
       */
      public static final int ED448_VALUE = 16;
      /**
       *
       *
       * <pre>
       * Reserved for Indirect Keys. Cannot be used for new deployments.
       * </pre>
       *
       * <code>INDIRECT = 252;</code>
       */
      public static final int INDIRECT_VALUE = 252;
      /**
       *
       *
       * <pre>
       * Private algorithm. Cannot be used for new deployments.
       * </pre>
       *
       * <code>PRIVATEDNS = 253;</code>
       */
      public static final int PRIVATEDNS_VALUE = 253;
      /**
       *
       *
       * <pre>
       * Private algorithm OID. Cannot be used for new deployments.
       * </pre>
       *
       * <code>PRIVATEOID = 254;</code>
       */
      public static final int PRIVATEOID_VALUE = 254;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Algorithm valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Algorithm forNumber(int value) {
        switch (value) {
          case 0:
            return ALGORITHM_UNSPECIFIED;
          case 1:
            return RSAMD5;
          case 2:
            return DH;
          case 3:
            return DSA;
          case 4:
            return ECC;
          case 5:
            return RSASHA1;
          case 6:
            return DSANSEC3SHA1;
          case 7:
            return RSASHA1NSEC3SHA1;
          case 8:
            return RSASHA256;
          case 10:
            return RSASHA512;
          case 12:
            return ECCGOST;
          case 13:
            return ECDSAP256SHA256;
          case 14:
            return ECDSAP384SHA384;
          case 15:
            return ED25519;
          case 16:
            return ED448;
          case 252:
            return INDIRECT;
          case 253:
            return PRIVATEDNS;
          case 254:
            return PRIVATEOID;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Algorithm>() {
            public Algorithm findValueByNumber(int number) {
              return Algorithm.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Algorithm[] VALUES = values();

      public static Algorithm valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Algorithm(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm)
    }

    /**
     *
     *
     * <pre>
     * List of hash functions that may have been used to generate a digest of a
     * DNSKEY.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType}
     */
    public enum DigestType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The DigestType is unspecified.
       * </pre>
       *
       * <code>DIGEST_TYPE_UNSPECIFIED = 0;</code>
       */
      DIGEST_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * SHA-1. Not recommended for new deployments.
       * </pre>
       *
       * <code>SHA1 = 1;</code>
       */
      SHA1(1),
      /**
       *
       *
       * <pre>
       * SHA-256.
       * </pre>
       *
       * <code>SHA256 = 2;</code>
       */
      SHA256(2),
      /**
       *
       *
       * <pre>
       * GOST R 34.11-94.
       * </pre>
       *
       * <code>GOST3411 = 3;</code>
       */
      GOST3411(3),
      /**
       *
       *
       * <pre>
       * SHA-384.
       * </pre>
       *
       * <code>SHA384 = 4;</code>
       */
      SHA384(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The DigestType is unspecified.
       * </pre>
       *
       * <code>DIGEST_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int DIGEST_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * SHA-1. Not recommended for new deployments.
       * </pre>
       *
       * <code>SHA1 = 1;</code>
       */
      public static final int SHA1_VALUE = 1;
      /**
       *
       *
       * <pre>
       * SHA-256.
       * </pre>
       *
       * <code>SHA256 = 2;</code>
       */
      public static final int SHA256_VALUE = 2;
      /**
       *
       *
       * <pre>
       * GOST R 34.11-94.
       * </pre>
       *
       * <code>GOST3411 = 3;</code>
       */
      public static final int GOST3411_VALUE = 3;
      /**
       *
       *
       * <pre>
       * SHA-384.
       * </pre>
       *
       * <code>SHA384 = 4;</code>
       */
      public static final int SHA384_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DigestType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DigestType forNumber(int value) {
        switch (value) {
          case 0:
            return DIGEST_TYPE_UNSPECIFIED;
          case 1:
            return SHA1;
          case 2:
            return SHA256;
          case 3:
            return GOST3411;
          case 4:
            return SHA384;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DigestType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DigestType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DigestType>() {
            public DigestType findValueByNumber(int number) {
              return DigestType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final DigestType[] VALUES = values();

      public static DigestType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DigestType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType)
    }

    public static final int KEY_TAG_FIELD_NUMBER = 1;
    private int keyTag_ = 0;
    /**
     *
     *
     * <pre>
     * The key tag of the record. Must be set in range 0 -- 65535.
     * </pre>
     *
     * <code>int32 key_tag = 1;</code>
     *
     * @return The keyTag.
     */
    @java.lang.Override
    public int getKeyTag() {
      return keyTag_;
    }

    public static final int ALGORITHM_FIELD_NUMBER = 2;
    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The algorithm used to generate the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * The algorithm used to generate the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm getAlgorithm() {
      com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm result =
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.forNumber(algorithm_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.UNRECOGNIZED
          : result;
    }

    public static final int DIGEST_TYPE_FIELD_NUMBER = 3;
    private int digestType_ = 0;
    /**
     *
     *
     * <pre>
     * The hash function used to generate the digest of the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;</code>
     *
     * @return The enum numeric value on the wire for digestType.
     */
    @java.lang.Override
    public int getDigestTypeValue() {
      return digestType_;
    }
    /**
     *
     *
     * <pre>
     * The hash function used to generate the digest of the referenced DNSKEY.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;</code>
     *
     * @return The digestType.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType getDigestType() {
      com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType result =
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType.forNumber(digestType_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType.UNRECOGNIZED
          : result;
    }

    public static final int DIGEST_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object digest_ = "";
    /**
     *
     *
     * <pre>
     * The digest generated from the referenced DNSKEY.
     * </pre>
     *
     * <code>string digest = 4;</code>
     *
     * @return The digest.
     */
    @java.lang.Override
    public java.lang.String getDigest() {
      java.lang.Object ref = digest_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        digest_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The digest generated from the referenced DNSKEY.
     * </pre>
     *
     * <code>string digest = 4;</code>
     *
     * @return The bytes for digest.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDigestBytes() {
      java.lang.Object ref = digest_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        digest_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (keyTag_ != 0) {
        output.writeInt32(1, keyTag_);
      }
      if (algorithm_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.ALGORITHM_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, algorithm_);
      }
      if (digestType_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType
              .DIGEST_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, digestType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(digest_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, digest_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (keyTag_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, keyTag_);
      }
      if (algorithm_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.ALGORITHM_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, algorithm_);
      }
      if (digestType_
          != com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType
              .DIGEST_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, digestType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(digest_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, digest_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord)) {
        return super.equals(obj);
      }
      com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord other =
          (com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord) obj;

      if (getKeyTag() != other.getKeyTag()) return false;
      if (algorithm_ != other.algorithm_) return false;
      if (digestType_ != other.digestType_) return false;
      if (!getDigest().equals(other.getDigest())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_TAG_FIELD_NUMBER;
      hash = (53 * hash) + getKeyTag();
      hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
      hash = (53 * hash) + algorithm_;
      hash = (37 * hash) + DIGEST_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + digestType_;
      hash = (37 * hash) + DIGEST_FIELD_NUMBER;
      hash = (53 * hash) + getDigest().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC
     * for a domain. It contains a digest (hash) of a DNSKEY record that must be
     * present in the domain's DNS zone.
     * </pre>
     *
     * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.DsRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.DnsSettings.DsRecord)
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_DsRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_DsRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.class,
                com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Builder.class);
      }

      // Construct using com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        keyTag_ = 0;
        algorithm_ = 0;
        digestType_ = 0;
        digest_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_DsRecord_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDefaultInstanceForType() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord build() {
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord buildPartial() {
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord result =
            new com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.keyTag_ = keyTag_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.algorithm_ = algorithm_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.digestType_ = digestType_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.digest_ = digest_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord) {
          return mergeFrom((com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord other) {
        if (other == com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.getDefaultInstance())
          return this;
        if (other.getKeyTag() != 0) {
          setKeyTag(other.getKeyTag());
        }
        if (other.algorithm_ != 0) {
          setAlgorithmValue(other.getAlgorithmValue());
        }
        if (other.digestType_ != 0) {
          setDigestTypeValue(other.getDigestTypeValue());
        }
        if (!other.getDigest().isEmpty()) {
          digest_ = other.digest_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  keyTag_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  algorithm_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  digestType_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  digest_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int keyTag_;
      /**
       *
       *
       * <pre>
       * The key tag of the record. Must be set in range 0 -- 65535.
       * </pre>
       *
       * <code>int32 key_tag = 1;</code>
       *
       * @return The keyTag.
       */
      @java.lang.Override
      public int getKeyTag() {
        return keyTag_;
      }
      /**
       *
       *
       * <pre>
       * The key tag of the record. Must be set in range 0 -- 65535.
       * </pre>
       *
       * <code>int32 key_tag = 1;</code>
       *
       * @param value The keyTag to set.
       * @return This builder for chaining.
       */
      public Builder setKeyTag(int value) {

        keyTag_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key tag of the record. Must be set in range 0 -- 65535.
       * </pre>
       *
       * <code>int32 key_tag = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKeyTag() {
        bitField0_ = (bitField0_ & ~0x00000001);
        keyTag_ = 0;
        onChanged();
        return this;
      }

      private int algorithm_ = 0;
      /**
       *
       *
       * <pre>
       * The algorithm used to generate the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
       *
       * @return The enum numeric value on the wire for algorithm.
       */
      @java.lang.Override
      public int getAlgorithmValue() {
        return algorithm_;
      }
      /**
       *
       *
       * <pre>
       * The algorithm used to generate the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
       *
       * @param value The enum numeric value on the wire for algorithm to set.
       * @return This builder for chaining.
       */
      public Builder setAlgorithmValue(int value) {
        algorithm_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The algorithm used to generate the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
       *
       * @return The algorithm.
       */
      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm getAlgorithm() {
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm result =
            com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.forNumber(algorithm_);
        return result == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The algorithm used to generate the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
       *
       * @param value The algorithm to set.
       * @return This builder for chaining.
       */
      public Builder setAlgorithm(
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        algorithm_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The algorithm used to generate the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.Algorithm algorithm = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlgorithm() {
        bitField0_ = (bitField0_ & ~0x00000002);
        algorithm_ = 0;
        onChanged();
        return this;
      }

      private int digestType_ = 0;
      /**
       *
       *
       * <pre>
       * The hash function used to generate the digest of the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for digestType.
       */
      @java.lang.Override
      public int getDigestTypeValue() {
        return digestType_;
      }
      /**
       *
       *
       * <pre>
       * The hash function used to generate the digest of the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for digestType to set.
       * @return This builder for chaining.
       */
      public Builder setDigestTypeValue(int value) {
        digestType_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hash function used to generate the digest of the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;
       * </code>
       *
       * @return The digestType.
       */
      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType getDigestType() {
        com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType result =
            com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType.forNumber(
                digestType_);
        return result == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The hash function used to generate the digest of the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;
       * </code>
       *
       * @param value The digestType to set.
       * @return This builder for chaining.
       */
      public Builder setDigestType(
          com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        digestType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hash function used to generate the digest of the referenced DNSKEY.
       * </pre>
       *
       * <code>.google.cloud.domains.v1alpha2.DnsSettings.DsRecord.DigestType digest_type = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDigestType() {
        bitField0_ = (bitField0_ & ~0x00000004);
        digestType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object digest_ = "";
      /**
       *
       *
       * <pre>
       * The digest generated from the referenced DNSKEY.
       * </pre>
       *
       * <code>string digest = 4;</code>
       *
       * @return The digest.
       */
      public java.lang.String getDigest() {
        java.lang.Object ref = digest_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          digest_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digest generated from the referenced DNSKEY.
       * </pre>
       *
       * <code>string digest = 4;</code>
       *
       * @return The bytes for digest.
       */
      public com.google.protobuf.ByteString getDigestBytes() {
        java.lang.Object ref = digest_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          digest_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The digest generated from the referenced DNSKEY.
       * </pre>
       *
       * <code>string digest = 4;</code>
       *
       * @param value The digest to set.
       * @return This builder for chaining.
       */
      public Builder setDigest(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        digest_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digest generated from the referenced DNSKEY.
       * </pre>
       *
       * <code>string digest = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDigest() {
        digest_ = getDefaultInstance().getDigest();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The digest generated from the referenced DNSKEY.
       * </pre>
       *
       * <code>string digest = 4;</code>
       *
       * @param value The bytes for digest to set.
       * @return This builder for chaining.
       */
      public Builder setDigestBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        digest_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.DnsSettings.DsRecord)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.DnsSettings.DsRecord)
    private static final com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord();
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DsRecord> PARSER =
        new com.google.protobuf.AbstractParser<DsRecord>() {
          @java.lang.Override
          public DsRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DsRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DsRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.DsRecord getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GlueRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Domain name of the host in Punycode format.
     * </pre>
     *
     * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostName.
     */
    java.lang.String getHostName();
    /**
     *
     *
     * <pre>
     * Required. Domain name of the host in Punycode format.
     * </pre>
     *
     * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostName.
     */
    com.google.protobuf.ByteString getHostNameBytes();

    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @return A list containing the ipv4Addresses.
     */
    java.util.List<java.lang.String> getIpv4AddressesList();
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @return The count of ipv4Addresses.
     */
    int getIpv4AddressesCount();
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The ipv4Addresses at the given index.
     */
    java.lang.String getIpv4Addresses(int index);
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipv4Addresses at the given index.
     */
    com.google.protobuf.ByteString getIpv4AddressesBytes(int index);

    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @return A list containing the ipv6Addresses.
     */
    java.util.List<java.lang.String> getIpv6AddressesList();
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @return The count of ipv6Addresses.
     */
    int getIpv6AddressesCount();
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The ipv6Addresses at the given index.
     */
    java.lang.String getIpv6Addresses(int index);
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipv6Addresses at the given index.
     */
    com.google.protobuf.ByteString getIpv6AddressesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Defines a host on your domain that is a DNS name server for your domain
   * and/or other domains. Glue records are a way of making the IP address of a
   * name server known, even when it serves DNS queries for its parent domain.
   * For example, when `ns.example.com` is a name server for `example.com`, the
   * host `ns.example.com` must have a glue record to break the circular DNS
   * reference.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.GlueRecord}
   */
  public static final class GlueRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)
      GlueRecordOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GlueRecord.newBuilder() to construct.
    private GlueRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GlueRecord() {
      hostName_ = "";
      ipv4Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      ipv6Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GlueRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GlueRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GlueRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.class,
              com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder.class);
    }

    public static final int HOST_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object hostName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Domain name of the host in Punycode format.
     * </pre>
     *
     * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostName.
     */
    @java.lang.Override
    public java.lang.String getHostName() {
      java.lang.Object ref = hostName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Domain name of the host in Punycode format.
     * </pre>
     *
     * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostNameBytes() {
      java.lang.Object ref = hostName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IPV4_ADDRESSES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList ipv4Addresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @return A list containing the ipv4Addresses.
     */
    public com.google.protobuf.ProtocolStringList getIpv4AddressesList() {
      return ipv4Addresses_;
    }
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @return The count of ipv4Addresses.
     */
    public int getIpv4AddressesCount() {
      return ipv4Addresses_.size();
    }
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The ipv4Addresses at the given index.
     */
    public java.lang.String getIpv4Addresses(int index) {
      return ipv4Addresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of IPv4 addresses corresponding to this host in the standard decimal
     * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
     * `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv4_addresses = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipv4Addresses at the given index.
     */
    public com.google.protobuf.ByteString getIpv4AddressesBytes(int index) {
      return ipv4Addresses_.getByteString(index);
    }

    public static final int IPV6_ADDRESSES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList ipv6Addresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @return A list containing the ipv6Addresses.
     */
    public com.google.protobuf.ProtocolStringList getIpv6AddressesList() {
      return ipv6Addresses_;
    }
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @return The count of ipv6Addresses.
     */
    public int getIpv6AddressesCount() {
      return ipv6Addresses_.size();
    }
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The ipv6Addresses at the given index.
     */
    public java.lang.String getIpv6Addresses(int index) {
      return ipv6Addresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of IPv6 addresses corresponding to this host in the standard
     * hexadecimal format (e.g. `2001:db8::`). At least one of
     * `ipv4_address` and `ipv6_address` must be set.
     * </pre>
     *
     * <code>repeated string ipv6_addresses = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipv6Addresses at the given index.
     */
    public com.google.protobuf.ByteString getIpv6AddressesBytes(int index) {
      return ipv6Addresses_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostName_);
      }
      for (int i = 0; i < ipv4Addresses_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ipv4Addresses_.getRaw(i));
      }
      for (int i = 0; i < ipv6Addresses_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ipv6Addresses_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostName_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < ipv4Addresses_.size(); i++) {
          dataSize += computeStringSizeNoTag(ipv4Addresses_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIpv4AddressesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < ipv6Addresses_.size(); i++) {
          dataSize += computeStringSizeNoTag(ipv6Addresses_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIpv6AddressesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)) {
        return super.equals(obj);
      }
      com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord other =
          (com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord) obj;

      if (!getHostName().equals(other.getHostName())) return false;
      if (!getIpv4AddressesList().equals(other.getIpv4AddressesList())) return false;
      if (!getIpv6AddressesList().equals(other.getIpv6AddressesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HOST_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getHostName().hashCode();
      if (getIpv4AddressesCount() > 0) {
        hash = (37 * hash) + IPV4_ADDRESSES_FIELD_NUMBER;
        hash = (53 * hash) + getIpv4AddressesList().hashCode();
      }
      if (getIpv6AddressesCount() > 0) {
        hash = (37 * hash) + IPV6_ADDRESSES_FIELD_NUMBER;
        hash = (53 * hash) + getIpv6AddressesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines a host on your domain that is a DNS name server for your domain
     * and/or other domains. Glue records are a way of making the IP address of a
     * name server known, even when it serves DNS queries for its parent domain.
     * For example, when `ns.example.com` is a name server for `example.com`, the
     * host `ns.example.com` must have a glue record to break the circular DNS
     * reference.
     * </pre>
     *
     * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings.GlueRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GlueRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GlueRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.class,
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder.class);
      }

      // Construct using com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        hostName_ = "";
        ipv4Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
        ipv6Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.domains.v1alpha2.DomainsProto
            .internal_static_google_cloud_domains_v1alpha2_DnsSettings_GlueRecord_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord getDefaultInstanceForType() {
        return com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord build() {
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord buildPartial() {
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord result =
            new com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.hostName_ = hostName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          ipv4Addresses_.makeImmutable();
          result.ipv4Addresses_ = ipv4Addresses_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          ipv6Addresses_.makeImmutable();
          result.ipv6Addresses_ = ipv6Addresses_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord) {
          return mergeFrom((com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord other) {
        if (other == com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.getDefaultInstance())
          return this;
        if (!other.getHostName().isEmpty()) {
          hostName_ = other.hostName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.ipv4Addresses_.isEmpty()) {
          if (ipv4Addresses_.isEmpty()) {
            ipv4Addresses_ = other.ipv4Addresses_;
            bitField0_ |= 0x00000002;
          } else {
            ensureIpv4AddressesIsMutable();
            ipv4Addresses_.addAll(other.ipv4Addresses_);
          }
          onChanged();
        }
        if (!other.ipv6Addresses_.isEmpty()) {
          if (ipv6Addresses_.isEmpty()) {
            ipv6Addresses_ = other.ipv6Addresses_;
            bitField0_ |= 0x00000004;
          } else {
            ensureIpv6AddressesIsMutable();
            ipv6Addresses_.addAll(other.ipv6Addresses_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  hostName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIpv4AddressesIsMutable();
                  ipv4Addresses_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIpv6AddressesIsMutable();
                  ipv6Addresses_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object hostName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Domain name of the host in Punycode format.
       * </pre>
       *
       * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The hostName.
       */
      public java.lang.String getHostName() {
        java.lang.Object ref = hostName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Domain name of the host in Punycode format.
       * </pre>
       *
       * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for hostName.
       */
      public com.google.protobuf.ByteString getHostNameBytes() {
        java.lang.Object ref = hostName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          hostName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Domain name of the host in Punycode format.
       * </pre>
       *
       * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The hostName to set.
       * @return This builder for chaining.
       */
      public Builder setHostName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        hostName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Domain name of the host in Punycode format.
       * </pre>
       *
       * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHostName() {
        hostName_ = getDefaultInstance().getHostName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Domain name of the host in Punycode format.
       * </pre>
       *
       * <code>string host_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for hostName to set.
       * @return This builder for chaining.
       */
      public Builder setHostNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        hostName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList ipv4Addresses_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureIpv4AddressesIsMutable() {
        if (!ipv4Addresses_.isModifiable()) {
          ipv4Addresses_ = new com.google.protobuf.LazyStringArrayList(ipv4Addresses_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @return A list containing the ipv4Addresses.
       */
      public com.google.protobuf.ProtocolStringList getIpv4AddressesList() {
        ipv4Addresses_.makeImmutable();
        return ipv4Addresses_;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @return The count of ipv4Addresses.
       */
      public int getIpv4AddressesCount() {
        return ipv4Addresses_.size();
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The ipv4Addresses at the given index.
       */
      public java.lang.String getIpv4Addresses(int index) {
        return ipv4Addresses_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ipv4Addresses at the given index.
       */
      public com.google.protobuf.ByteString getIpv4AddressesBytes(int index) {
        return ipv4Addresses_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The ipv4Addresses to set.
       * @return This builder for chaining.
       */
      public Builder setIpv4Addresses(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv4AddressesIsMutable();
        ipv4Addresses_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param value The ipv4Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addIpv4Addresses(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv4AddressesIsMutable();
        ipv4Addresses_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param values The ipv4Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addAllIpv4Addresses(java.lang.Iterable<java.lang.String> values) {
        ensureIpv4AddressesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipv4Addresses_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIpv4Addresses() {
        ipv4Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv4 addresses corresponding to this host in the standard decimal
       * format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
       * `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv4_addresses = 2;</code>
       *
       * @param value The bytes of the ipv4Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addIpv4AddressesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIpv4AddressesIsMutable();
        ipv4Addresses_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList ipv6Addresses_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureIpv6AddressesIsMutable() {
        if (!ipv6Addresses_.isModifiable()) {
          ipv6Addresses_ = new com.google.protobuf.LazyStringArrayList(ipv6Addresses_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @return A list containing the ipv6Addresses.
       */
      public com.google.protobuf.ProtocolStringList getIpv6AddressesList() {
        ipv6Addresses_.makeImmutable();
        return ipv6Addresses_;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @return The count of ipv6Addresses.
       */
      public int getIpv6AddressesCount() {
        return ipv6Addresses_.size();
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The ipv6Addresses at the given index.
       */
      public java.lang.String getIpv6Addresses(int index) {
        return ipv6Addresses_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the ipv6Addresses at the given index.
       */
      public com.google.protobuf.ByteString getIpv6AddressesBytes(int index) {
        return ipv6Addresses_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The ipv6Addresses to set.
       * @return This builder for chaining.
       */
      public Builder setIpv6Addresses(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv6AddressesIsMutable();
        ipv6Addresses_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param value The ipv6Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addIpv6Addresses(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIpv6AddressesIsMutable();
        ipv6Addresses_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param values The ipv6Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addAllIpv6Addresses(java.lang.Iterable<java.lang.String> values) {
        ensureIpv6AddressesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipv6Addresses_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIpv6Addresses() {
        ipv6Addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of IPv6 addresses corresponding to this host in the standard
       * hexadecimal format (e.g. `2001:db8::`). At least one of
       * `ipv4_address` and `ipv6_address` must be set.
       * </pre>
       *
       * <code>repeated string ipv6_addresses = 3;</code>
       *
       * @param value The bytes of the ipv6Addresses to add.
       * @return This builder for chaining.
       */
      public Builder addIpv6AddressesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIpv6AddressesIsMutable();
        ipv6Addresses_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.DnsSettings.GlueRecord)
    private static final com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord();
    }

    public static com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GlueRecord> PARSER =
        new com.google.protobuf.AbstractParser<GlueRecord>() {
          @java.lang.Override
          public GlueRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GlueRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GlueRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int dnsProviderCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dnsProvider_;

  public enum DnsProviderCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CUSTOM_DNS(1),
    GOOGLE_DOMAINS_DNS(2),
    DNSPROVIDER_NOT_SET(0);
    private final int value;

    private DnsProviderCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DnsProviderCase valueOf(int value) {
      return forNumber(value);
    }

    public static DnsProviderCase forNumber(int value) {
      switch (value) {
        case 1:
          return CUSTOM_DNS;
        case 2:
          return GOOGLE_DOMAINS_DNS;
        case 0:
          return DNSPROVIDER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DnsProviderCase getDnsProviderCase() {
    return DnsProviderCase.forNumber(dnsProviderCase_);
  }

  public static final int CUSTOM_DNS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * An arbitrary DNS provider identified by its name servers.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
   *
   * @return Whether the customDns field is set.
   */
  @java.lang.Override
  public boolean hasCustomDns() {
    return dnsProviderCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * An arbitrary DNS provider identified by its name servers.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
   *
   * @return The customDns.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns getCustomDns() {
    if (dnsProviderCase_ == 1) {
      return (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_;
    }
    return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An arbitrary DNS provider identified by its name servers.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder getCustomDnsOrBuilder() {
    if (dnsProviderCase_ == 1) {
      return (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_;
    }
    return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
  }

  public static final int GOOGLE_DOMAINS_DNS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The free DNS zone provided by
   * [Google Domains](https://domains.google/).
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
   * </code>
   *
   * @return Whether the googleDomainsDns field is set.
   */
  @java.lang.Override
  public boolean hasGoogleDomainsDns() {
    return dnsProviderCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The free DNS zone provided by
   * [Google Domains](https://domains.google/).
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
   * </code>
   *
   * @return The googleDomainsDns.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns getGoogleDomainsDns() {
    if (dnsProviderCase_ == 2) {
      return (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_;
    }
    return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The free DNS zone provided by
   * [Google Domains](https://domains.google/).
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder
      getGoogleDomainsDnsOrBuilder() {
    if (dnsProviderCase_ == 2) {
      return (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_;
    }
    return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
  }

  public static final int GLUE_RECORDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord> glueRecords_;
  /**
   *
   *
   * <pre>
   * The list of glue records for this `Registration`. Commonly empty.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord>
      getGlueRecordsList() {
    return glueRecords_;
  }
  /**
   *
   *
   * <pre>
   * The list of glue records for this `Registration`. Commonly empty.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder>
      getGlueRecordsOrBuilderList() {
    return glueRecords_;
  }
  /**
   *
   *
   * <pre>
   * The list of glue records for this `Registration`. Commonly empty.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
   */
  @java.lang.Override
  public int getGlueRecordsCount() {
    return glueRecords_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of glue records for this `Registration`. Commonly empty.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord getGlueRecords(int index) {
    return glueRecords_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of glue records for this `Registration`. Commonly empty.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder getGlueRecordsOrBuilder(
      int index) {
    return glueRecords_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dnsProviderCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_);
    }
    if (dnsProviderCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_);
    }
    for (int i = 0; i < glueRecords_.size(); i++) {
      output.writeMessage(4, glueRecords_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dnsProviderCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_);
    }
    if (dnsProviderCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_);
    }
    for (int i = 0; i < glueRecords_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, glueRecords_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.DnsSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.DnsSettings other =
        (com.google.cloud.domains.v1alpha2.DnsSettings) obj;

    if (!getGlueRecordsList().equals(other.getGlueRecordsList())) return false;
    if (!getDnsProviderCase().equals(other.getDnsProviderCase())) return false;
    switch (dnsProviderCase_) {
      case 1:
        if (!getCustomDns().equals(other.getCustomDns())) return false;
        break;
      case 2:
        if (!getGoogleDomainsDns().equals(other.getGoogleDomainsDns())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getGlueRecordsCount() > 0) {
      hash = (37 * hash) + GLUE_RECORDS_FIELD_NUMBER;
      hash = (53 * hash) + getGlueRecordsList().hashCode();
    }
    switch (dnsProviderCase_) {
      case 1:
        hash = (37 * hash) + CUSTOM_DNS_FIELD_NUMBER;
        hash = (53 * hash) + getCustomDns().hashCode();
        break;
      case 2:
        hash = (37 * hash) + GOOGLE_DOMAINS_DNS_FIELD_NUMBER;
        hash = (53 * hash) + getGoogleDomainsDns().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.domains.v1alpha2.DnsSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the DNS configuration of a `Registration`, including name servers,
   * DNSSEC, and glue records.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.DnsSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.DnsSettings)
      com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.DnsSettings.class,
              com.google.cloud.domains.v1alpha2.DnsSettings.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.DnsSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (customDnsBuilder_ != null) {
        customDnsBuilder_.clear();
      }
      if (googleDomainsDnsBuilder_ != null) {
        googleDomainsDnsBuilder_.clear();
      }
      if (glueRecordsBuilder_ == null) {
        glueRecords_ = java.util.Collections.emptyList();
      } else {
        glueRecords_ = null;
        glueRecordsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      dnsProviderCase_ = 0;
      dnsProvider_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_DnsSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings build() {
      com.google.cloud.domains.v1alpha2.DnsSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings buildPartial() {
      com.google.cloud.domains.v1alpha2.DnsSettings result =
          new com.google.cloud.domains.v1alpha2.DnsSettings(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.domains.v1alpha2.DnsSettings result) {
      if (glueRecordsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          glueRecords_ = java.util.Collections.unmodifiableList(glueRecords_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.glueRecords_ = glueRecords_;
      } else {
        result.glueRecords_ = glueRecordsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.DnsSettings result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.domains.v1alpha2.DnsSettings result) {
      result.dnsProviderCase_ = dnsProviderCase_;
      result.dnsProvider_ = this.dnsProvider_;
      if (dnsProviderCase_ == 1 && customDnsBuilder_ != null) {
        result.dnsProvider_ = customDnsBuilder_.build();
      }
      if (dnsProviderCase_ == 2 && googleDomainsDnsBuilder_ != null) {
        result.dnsProvider_ = googleDomainsDnsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.DnsSettings) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.DnsSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.DnsSettings other) {
      if (other == com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()) return this;
      if (glueRecordsBuilder_ == null) {
        if (!other.glueRecords_.isEmpty()) {
          if (glueRecords_.isEmpty()) {
            glueRecords_ = other.glueRecords_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureGlueRecordsIsMutable();
            glueRecords_.addAll(other.glueRecords_);
          }
          onChanged();
        }
      } else {
        if (!other.glueRecords_.isEmpty()) {
          if (glueRecordsBuilder_.isEmpty()) {
            glueRecordsBuilder_.dispose();
            glueRecordsBuilder_ = null;
            glueRecords_ = other.glueRecords_;
            bitField0_ = (bitField0_ & ~0x00000004);
            glueRecordsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGlueRecordsFieldBuilder()
                    : null;
          } else {
            glueRecordsBuilder_.addAllMessages(other.glueRecords_);
          }
        }
      }
      switch (other.getDnsProviderCase()) {
        case CUSTOM_DNS:
          {
            mergeCustomDns(other.getCustomDns());
            break;
          }
        case GOOGLE_DOMAINS_DNS:
          {
            mergeGoogleDomainsDns(other.getGoogleDomainsDns());
            break;
          }
        case DNSPROVIDER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCustomDnsFieldBuilder().getBuilder(), extensionRegistry);
                dnsProviderCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getGoogleDomainsDnsFieldBuilder().getBuilder(), extensionRegistry);
                dnsProviderCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord m =
                    input.readMessage(
                        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.parser(),
                        extensionRegistry);
                if (glueRecordsBuilder_ == null) {
                  ensureGlueRecordsIsMutable();
                  glueRecords_.add(m);
                } else {
                  glueRecordsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dnsProviderCase_ = 0;
    private java.lang.Object dnsProvider_;

    public DnsProviderCase getDnsProviderCase() {
      return DnsProviderCase.forNumber(dnsProviderCase_);
    }

    public Builder clearDnsProvider() {
      dnsProviderCase_ = 0;
      dnsProvider_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns,
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder>
        customDnsBuilder_;
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     *
     * @return Whether the customDns field is set.
     */
    @java.lang.Override
    public boolean hasCustomDns() {
      return dnsProviderCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     *
     * @return The customDns.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns getCustomDns() {
      if (customDnsBuilder_ == null) {
        if (dnsProviderCase_ == 1) {
          return (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_;
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
      } else {
        if (dnsProviderCase_ == 1) {
          return customDnsBuilder_.getMessage();
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    public Builder setCustomDns(com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns value) {
      if (customDnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsProvider_ = value;
        onChanged();
      } else {
        customDnsBuilder_.setMessage(value);
      }
      dnsProviderCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    public Builder setCustomDns(
        com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder builderForValue) {
      if (customDnsBuilder_ == null) {
        dnsProvider_ = builderForValue.build();
        onChanged();
      } else {
        customDnsBuilder_.setMessage(builderForValue.build());
      }
      dnsProviderCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    public Builder mergeCustomDns(com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns value) {
      if (customDnsBuilder_ == null) {
        if (dnsProviderCase_ == 1
            && dnsProvider_
                != com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance()) {
          dnsProvider_ =
              com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.newBuilder(
                      (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dnsProvider_ = value;
        }
        onChanged();
      } else {
        if (dnsProviderCase_ == 1) {
          customDnsBuilder_.mergeFrom(value);
        } else {
          customDnsBuilder_.setMessage(value);
        }
      }
      dnsProviderCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    public Builder clearCustomDns() {
      if (customDnsBuilder_ == null) {
        if (dnsProviderCase_ == 1) {
          dnsProviderCase_ = 0;
          dnsProvider_ = null;
          onChanged();
        }
      } else {
        if (dnsProviderCase_ == 1) {
          dnsProviderCase_ = 0;
          dnsProvider_ = null;
        }
        customDnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder getCustomDnsBuilder() {
      return getCustomDnsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder
        getCustomDnsOrBuilder() {
      if ((dnsProviderCase_ == 1) && (customDnsBuilder_ != null)) {
        return customDnsBuilder_.getMessageOrBuilder();
      } else {
        if (dnsProviderCase_ == 1) {
          return (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_;
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An arbitrary DNS provider identified by its name servers.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.CustomDns custom_dns = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns,
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder>
        getCustomDnsFieldBuilder() {
      if (customDnsBuilder_ == null) {
        if (!(dnsProviderCase_ == 1)) {
          dnsProvider_ =
              com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.getDefaultInstance();
        }
        customDnsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns,
                com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns.Builder,
                com.google.cloud.domains.v1alpha2.DnsSettings.CustomDnsOrBuilder>(
                (com.google.cloud.domains.v1alpha2.DnsSettings.CustomDns) dnsProvider_,
                getParentForChildren(),
                isClean());
        dnsProvider_ = null;
      }
      dnsProviderCase_ = 1;
      onChanged();
      return customDnsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns,
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder>
        googleDomainsDnsBuilder_;
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     *
     * @return Whether the googleDomainsDns field is set.
     */
    @java.lang.Override
    public boolean hasGoogleDomainsDns() {
      return dnsProviderCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     *
     * @return The googleDomainsDns.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns getGoogleDomainsDns() {
      if (googleDomainsDnsBuilder_ == null) {
        if (dnsProviderCase_ == 2) {
          return (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_;
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
      } else {
        if (dnsProviderCase_ == 2) {
          return googleDomainsDnsBuilder_.getMessage();
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    public Builder setGoogleDomainsDns(
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns value) {
      if (googleDomainsDnsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsProvider_ = value;
        onChanged();
      } else {
        googleDomainsDnsBuilder_.setMessage(value);
      }
      dnsProviderCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    public Builder setGoogleDomainsDns(
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder builderForValue) {
      if (googleDomainsDnsBuilder_ == null) {
        dnsProvider_ = builderForValue.build();
        onChanged();
      } else {
        googleDomainsDnsBuilder_.setMessage(builderForValue.build());
      }
      dnsProviderCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    public Builder mergeGoogleDomainsDns(
        com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns value) {
      if (googleDomainsDnsBuilder_ == null) {
        if (dnsProviderCase_ == 2
            && dnsProvider_
                != com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns
                    .getDefaultInstance()) {
          dnsProvider_ =
              com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.newBuilder(
                      (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dnsProvider_ = value;
        }
        onChanged();
      } else {
        if (dnsProviderCase_ == 2) {
          googleDomainsDnsBuilder_.mergeFrom(value);
        } else {
          googleDomainsDnsBuilder_.setMessage(value);
        }
      }
      dnsProviderCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    public Builder clearGoogleDomainsDns() {
      if (googleDomainsDnsBuilder_ == null) {
        if (dnsProviderCase_ == 2) {
          dnsProviderCase_ = 0;
          dnsProvider_ = null;
          onChanged();
        }
      } else {
        if (dnsProviderCase_ == 2) {
          dnsProviderCase_ = 0;
          dnsProvider_ = null;
        }
        googleDomainsDnsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder
        getGoogleDomainsDnsBuilder() {
      return getGoogleDomainsDnsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder
        getGoogleDomainsDnsOrBuilder() {
      if ((dnsProviderCase_ == 2) && (googleDomainsDnsBuilder_ != null)) {
        return googleDomainsDnsBuilder_.getMessageOrBuilder();
      } else {
        if (dnsProviderCase_ == 2) {
          return (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_;
        }
        return com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The free DNS zone provided by
     * [Google Domains](https://domains.google/).
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns google_domains_dns = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns,
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder>
        getGoogleDomainsDnsFieldBuilder() {
      if (googleDomainsDnsBuilder_ == null) {
        if (!(dnsProviderCase_ == 2)) {
          dnsProvider_ =
              com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.getDefaultInstance();
        }
        googleDomainsDnsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns,
                com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns.Builder,
                com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDnsOrBuilder>(
                (com.google.cloud.domains.v1alpha2.DnsSettings.GoogleDomainsDns) dnsProvider_,
                getParentForChildren(),
                isClean());
        dnsProvider_ = null;
      }
      dnsProviderCase_ = 2;
      onChanged();
      return googleDomainsDnsBuilder_;
    }

    private java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord> glueRecords_ =
        java.util.Collections.emptyList();

    private void ensureGlueRecordsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        glueRecords_ =
            new java.util.ArrayList<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord>(
                glueRecords_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord,
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder>
        glueRecordsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord>
        getGlueRecordsList() {
      if (glueRecordsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(glueRecords_);
      } else {
        return glueRecordsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public int getGlueRecordsCount() {
      if (glueRecordsBuilder_ == null) {
        return glueRecords_.size();
      } else {
        return glueRecordsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord getGlueRecords(int index) {
      if (glueRecordsBuilder_ == null) {
        return glueRecords_.get(index);
      } else {
        return glueRecordsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder setGlueRecords(
        int index, com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord value) {
      if (glueRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlueRecordsIsMutable();
        glueRecords_.set(index, value);
        onChanged();
      } else {
        glueRecordsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder setGlueRecords(
        int index,
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder builderForValue) {
      if (glueRecordsBuilder_ == null) {
        ensureGlueRecordsIsMutable();
        glueRecords_.set(index, builderForValue.build());
        onChanged();
      } else {
        glueRecordsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder addGlueRecords(com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord value) {
      if (glueRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlueRecordsIsMutable();
        glueRecords_.add(value);
        onChanged();
      } else {
        glueRecordsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder addGlueRecords(
        int index, com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord value) {
      if (glueRecordsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlueRecordsIsMutable();
        glueRecords_.add(index, value);
        onChanged();
      } else {
        glueRecordsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder addGlueRecords(
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder builderForValue) {
      if (glueRecordsBuilder_ == null) {
        ensureGlueRecordsIsMutable();
        glueRecords_.add(builderForValue.build());
        onChanged();
      } else {
        glueRecordsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder addGlueRecords(
        int index,
        com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder builderForValue) {
      if (glueRecordsBuilder_ == null) {
        ensureGlueRecordsIsMutable();
        glueRecords_.add(index, builderForValue.build());
        onChanged();
      } else {
        glueRecordsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder addAllGlueRecords(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord>
            values) {
      if (glueRecordsBuilder_ == null) {
        ensureGlueRecordsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, glueRecords_);
        onChanged();
      } else {
        glueRecordsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder clearGlueRecords() {
      if (glueRecordsBuilder_ == null) {
        glueRecords_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        glueRecordsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public Builder removeGlueRecords(int index) {
      if (glueRecordsBuilder_ == null) {
        ensureGlueRecordsIsMutable();
        glueRecords_.remove(index);
        onChanged();
      } else {
        glueRecordsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder getGlueRecordsBuilder(
        int index) {
      return getGlueRecordsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder
        getGlueRecordsOrBuilder(int index) {
      if (glueRecordsBuilder_ == null) {
        return glueRecords_.get(index);
      } else {
        return glueRecordsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder>
        getGlueRecordsOrBuilderList() {
      if (glueRecordsBuilder_ != null) {
        return glueRecordsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(glueRecords_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder
        addGlueRecordsBuilder() {
      return getGlueRecordsFieldBuilder()
          .addBuilder(
              com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder addGlueRecordsBuilder(
        int index) {
      return getGlueRecordsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of glue records for this `Registration`. Commonly empty.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DnsSettings.GlueRecord glue_records = 4;</code>
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder>
        getGlueRecordsBuilderList() {
      return getGlueRecordsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord,
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder>
        getGlueRecordsFieldBuilder() {
      if (glueRecordsBuilder_ == null) {
        glueRecordsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord,
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecord.Builder,
                com.google.cloud.domains.v1alpha2.DnsSettings.GlueRecordOrBuilder>(
                glueRecords_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        glueRecords_ = null;
      }
      return glueRecordsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.DnsSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.DnsSettings)
  private static final com.google.cloud.domains.v1alpha2.DnsSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.DnsSettings();
  }

  public static com.google.cloud.domains.v1alpha2.DnsSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DnsSettings> PARSER =
      new com.google.protobuf.AbstractParser<DnsSettings>() {
        @java.lang.Override
        public DnsSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DnsSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DnsSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
