/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Request for the `RegisterDomain` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.RegisterDomainRequest}
 */
public final class RegisterDomainRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.RegisterDomainRequest)
    RegisterDomainRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RegisterDomainRequest.newBuilder() to construct.
  private RegisterDomainRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RegisterDomainRequest() {
    parent_ = "";
    domainNotices_ = java.util.Collections.emptyList();
    contactNotices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RegisterDomainRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_RegisterDomainRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_RegisterDomainRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.RegisterDomainRequest.class,
            com.google.cloud.domains.v1alpha2.RegisterDomainRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource of the `Registration`. Must be in the
   * format `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource of the `Registration`. Must be in the
   * format `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGISTRATION_FIELD_NUMBER = 2;
  private com.google.cloud.domains.v1alpha2.Registration registration_;
  /**
   *
   *
   * <pre>
   * Required. The complete `Registration` resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the registration field is set.
   */
  @java.lang.Override
  public boolean hasRegistration() {
    return registration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The complete `Registration` resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The registration.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.Registration getRegistration() {
    return registration_ == null
        ? com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()
        : registration_;
  }
  /**
   *
   *
   * <pre>
   * Required. The complete `Registration` resource to be created.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.RegistrationOrBuilder getRegistrationOrBuilder() {
    return registration_ == null
        ? com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()
        : registration_;
  }

  public static final int DOMAIN_NOTICES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> domainNotices_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>
      domainNotices_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>() {
            public com.google.cloud.domains.v1alpha2.DomainNotice convert(java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.DomainNotice result =
                  com.google.cloud.domains.v1alpha2.DomainNotice.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.DomainNotice.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of domain notices that you acknowledge. Call
   * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
   *
   * @return A list containing the domainNotices.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.DomainNotice> getDomainNoticesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>(
        domainNotices_, domainNotices_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of domain notices that you acknowledge. Call
   * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
   *
   * @return The count of domainNotices.
   */
  @java.lang.Override
  public int getDomainNoticesCount() {
    return domainNotices_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of domain notices that you acknowledge. Call
   * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The domainNotices at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DomainNotice getDomainNotices(int index) {
    return domainNotices_converter_.convert(domainNotices_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of domain notices that you acknowledge. Call
   * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
   *
   * @return A list containing the enum numeric values on the wire for domainNotices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDomainNoticesValueList() {
    return domainNotices_;
  }
  /**
   *
   *
   * <pre>
   * The list of domain notices that you acknowledge. Call
   * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of domainNotices at the given index.
   */
  @java.lang.Override
  public int getDomainNoticesValue(int index) {
    return domainNotices_.get(index);
  }

  private int domainNoticesMemoizedSerializedSize;

  public static final int CONTACT_NOTICES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> contactNotices_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>
      contactNotices_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>() {
            public com.google.cloud.domains.v1alpha2.ContactNotice convert(java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.ContactNotice result =
                  com.google.cloud.domains.v1alpha2.ContactNotice.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.ContactNotice.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in
   * `registration.contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return A list containing the contactNotices.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.ContactNotice> getContactNoticesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>(
        contactNotices_, contactNotices_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in
   * `registration.contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return The count of contactNotices.
   */
  @java.lang.Override
  public int getContactNoticesCount() {
    return contactNotices_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in
   * `registration.contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The contactNotices at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactNotice getContactNotices(int index) {
    return contactNotices_converter_.convert(contactNotices_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in
   * `registration.contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for contactNotices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getContactNoticesValueList() {
    return contactNotices_;
  }
  /**
   *
   *
   * <pre>
   * The list of contact notices that the caller acknowledges. The notices
   * needed here depend on the values specified in
   * `registration.contact_settings`.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of contactNotices at the given index.
   */
  @java.lang.Override
  public int getContactNoticesValue(int index) {
    return contactNotices_.get(index);
  }

  private int contactNoticesMemoizedSerializedSize;

  public static final int YEARLY_PRICE_FIELD_NUMBER = 5;
  private com.google.type.Money yearlyPrice_;
  /**
   *
   *
   * <pre>
   * Required. Yearly price to register or renew the domain.
   * The value that should be put here can be obtained from
   * RetrieveRegisterParameters or SearchDomains calls.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the yearlyPrice field is set.
   */
  @java.lang.Override
  public boolean hasYearlyPrice() {
    return yearlyPrice_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Yearly price to register or renew the domain.
   * The value that should be put here can be obtained from
   * RetrieveRegisterParameters or SearchDomains calls.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The yearlyPrice.
   */
  @java.lang.Override
  public com.google.type.Money getYearlyPrice() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }
  /**
   *
   *
   * <pre>
   * Required. Yearly price to register or renew the domain.
   * The value that should be put here can be obtained from
   * RetrieveRegisterParameters or SearchDomains calls.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 6;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * When true, only validation is performed, without actually registering
   * the domain. Follows:
   * https://cloud.google.com/apis/design/design_patterns#request_validation
   * </pre>
   *
   * <code>bool validate_only = 6;</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (registration_ != null) {
      output.writeMessage(2, getRegistration());
    }
    if (getDomainNoticesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(domainNoticesMemoizedSerializedSize);
    }
    for (int i = 0; i < domainNotices_.size(); i++) {
      output.writeEnumNoTag(domainNotices_.get(i));
    }
    if (getContactNoticesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(contactNoticesMemoizedSerializedSize);
    }
    for (int i = 0; i < contactNotices_.size(); i++) {
      output.writeEnumNoTag(contactNotices_.get(i));
    }
    if (yearlyPrice_ != null) {
      output.writeMessage(5, getYearlyPrice());
    }
    if (validateOnly_ != false) {
      output.writeBool(6, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (registration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRegistration());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domainNotices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(domainNotices_.get(i));
      }
      size += dataSize;
      if (!getDomainNoticesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      domainNoticesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < contactNotices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(contactNotices_.get(i));
      }
      size += dataSize;
      if (!getContactNoticesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      contactNoticesMemoizedSerializedSize = dataSize;
    }
    if (yearlyPrice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getYearlyPrice());
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.RegisterDomainRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.RegisterDomainRequest other =
        (com.google.cloud.domains.v1alpha2.RegisterDomainRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasRegistration() != other.hasRegistration()) return false;
    if (hasRegistration()) {
      if (!getRegistration().equals(other.getRegistration())) return false;
    }
    if (!domainNotices_.equals(other.domainNotices_)) return false;
    if (!contactNotices_.equals(other.contactNotices_)) return false;
    if (hasYearlyPrice() != other.hasYearlyPrice()) return false;
    if (hasYearlyPrice()) {
      if (!getYearlyPrice().equals(other.getYearlyPrice())) return false;
    }
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasRegistration()) {
      hash = (37 * hash) + REGISTRATION_FIELD_NUMBER;
      hash = (53 * hash) + getRegistration().hashCode();
    }
    if (getDomainNoticesCount() > 0) {
      hash = (37 * hash) + DOMAIN_NOTICES_FIELD_NUMBER;
      hash = (53 * hash) + domainNotices_.hashCode();
    }
    if (getContactNoticesCount() > 0) {
      hash = (37 * hash) + CONTACT_NOTICES_FIELD_NUMBER;
      hash = (53 * hash) + contactNotices_.hashCode();
    }
    if (hasYearlyPrice()) {
      hash = (37 * hash) + YEARLY_PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getYearlyPrice().hashCode();
    }
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.domains.v1alpha2.RegisterDomainRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the `RegisterDomain` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.RegisterDomainRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.RegisterDomainRequest)
      com.google.cloud.domains.v1alpha2.RegisterDomainRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterDomainRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterDomainRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.RegisterDomainRequest.class,
              com.google.cloud.domains.v1alpha2.RegisterDomainRequest.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.RegisterDomainRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      registration_ = null;
      if (registrationBuilder_ != null) {
        registrationBuilder_.dispose();
        registrationBuilder_ = null;
      }
      domainNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      contactNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      validateOnly_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterDomainRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterDomainRequest getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.RegisterDomainRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterDomainRequest build() {
      com.google.cloud.domains.v1alpha2.RegisterDomainRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterDomainRequest buildPartial() {
      com.google.cloud.domains.v1alpha2.RegisterDomainRequest result =
          new com.google.cloud.domains.v1alpha2.RegisterDomainRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.domains.v1alpha2.RegisterDomainRequest result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        domainNotices_ = java.util.Collections.unmodifiableList(domainNotices_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.domainNotices_ = domainNotices_;
      if (((bitField0_ & 0x00000008) != 0)) {
        contactNotices_ = java.util.Collections.unmodifiableList(contactNotices_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.contactNotices_ = contactNotices_;
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.RegisterDomainRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.registration_ =
            registrationBuilder_ == null ? registration_ : registrationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.yearlyPrice_ =
            yearlyPriceBuilder_ == null ? yearlyPrice_ : yearlyPriceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.RegisterDomainRequest) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.RegisterDomainRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.RegisterDomainRequest other) {
      if (other == com.google.cloud.domains.v1alpha2.RegisterDomainRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRegistration()) {
        mergeRegistration(other.getRegistration());
      }
      if (!other.domainNotices_.isEmpty()) {
        if (domainNotices_.isEmpty()) {
          domainNotices_ = other.domainNotices_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureDomainNoticesIsMutable();
          domainNotices_.addAll(other.domainNotices_);
        }
        onChanged();
      }
      if (!other.contactNotices_.isEmpty()) {
        if (contactNotices_.isEmpty()) {
          contactNotices_ = other.contactNotices_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureContactNoticesIsMutable();
          contactNotices_.addAll(other.contactNotices_);
        }
        onChanged();
      }
      if (other.hasYearlyPrice()) {
        mergeYearlyPrice(other.getYearlyPrice());
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRegistrationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureDomainNoticesIsMutable();
                domainNotices_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDomainNoticesIsMutable();
                  domainNotices_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureContactNoticesIsMutable();
                contactNotices_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureContactNoticesIsMutable();
                  contactNotices_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getYearlyPriceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the `Registration`. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the `Registration`. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the `Registration`. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the `Registration`. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the `Registration`. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.domains.v1alpha2.Registration registration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.Registration,
            com.google.cloud.domains.v1alpha2.Registration.Builder,
            com.google.cloud.domains.v1alpha2.RegistrationOrBuilder>
        registrationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the registration field is set.
     */
    public boolean hasRegistration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The registration.
     */
    public com.google.cloud.domains.v1alpha2.Registration getRegistration() {
      if (registrationBuilder_ == null) {
        return registration_ == null
            ? com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()
            : registration_;
      } else {
        return registrationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegistration(com.google.cloud.domains.v1alpha2.Registration value) {
      if (registrationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        registration_ = value;
      } else {
        registrationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRegistration(
        com.google.cloud.domains.v1alpha2.Registration.Builder builderForValue) {
      if (registrationBuilder_ == null) {
        registration_ = builderForValue.build();
      } else {
        registrationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRegistration(com.google.cloud.domains.v1alpha2.Registration value) {
      if (registrationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && registration_ != null
            && registration_
                != com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()) {
          getRegistrationBuilder().mergeFrom(value);
        } else {
          registration_ = value;
        }
      } else {
        registrationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRegistration() {
      bitField0_ = (bitField0_ & ~0x00000002);
      registration_ = null;
      if (registrationBuilder_ != null) {
        registrationBuilder_.dispose();
        registrationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.Registration.Builder getRegistrationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRegistrationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.RegistrationOrBuilder getRegistrationOrBuilder() {
      if (registrationBuilder_ != null) {
        return registrationBuilder_.getMessageOrBuilder();
      } else {
        return registration_ == null
            ? com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()
            : registration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The complete `Registration` resource to be created.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration registration = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.Registration,
            com.google.cloud.domains.v1alpha2.Registration.Builder,
            com.google.cloud.domains.v1alpha2.RegistrationOrBuilder>
        getRegistrationFieldBuilder() {
      if (registrationBuilder_ == null) {
        registrationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.Registration,
                com.google.cloud.domains.v1alpha2.Registration.Builder,
                com.google.cloud.domains.v1alpha2.RegistrationOrBuilder>(
                getRegistration(), getParentForChildren(), isClean());
        registration_ = null;
      }
      return registrationBuilder_;
    }

    private java.util.List<java.lang.Integer> domainNotices_ = java.util.Collections.emptyList();

    private void ensureDomainNoticesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        domainNotices_ = new java.util.ArrayList<java.lang.Integer>(domainNotices_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @return A list containing the domainNotices.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.DomainNotice> getDomainNoticesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>(
          domainNotices_, domainNotices_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @return The count of domainNotices.
     */
    public int getDomainNoticesCount() {
      return domainNotices_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The domainNotices at the given index.
     */
    public com.google.cloud.domains.v1alpha2.DomainNotice getDomainNotices(int index) {
      return domainNotices_converter_.convert(domainNotices_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The domainNotices to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNotices(
        int index, com.google.cloud.domains.v1alpha2.DomainNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNoticesIsMutable();
      domainNotices_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param value The domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNotices(com.google.cloud.domains.v1alpha2.DomainNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNoticesIsMutable();
      domainNotices_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param values The domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomainNotices(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.DomainNotice> values) {
      ensureDomainNoticesIsMutable();
      for (com.google.cloud.domains.v1alpha2.DomainNotice value : values) {
        domainNotices_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainNotices() {
      domainNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for domainNotices.
     */
    public java.util.List<java.lang.Integer> getDomainNoticesValueList() {
      return java.util.Collections.unmodifiableList(domainNotices_);
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of domainNotices at the given index.
     */
    public int getDomainNoticesValue(int index) {
      return domainNotices_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for domainNotices to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNoticesValue(int index, int value) {
      ensureDomainNoticesIsMutable();
      domainNotices_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param value The enum numeric value on the wire for domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNoticesValue(int value) {
      ensureDomainNoticesIsMutable();
      domainNotices_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of domain notices that you acknowledge. Call
     * `RetrieveRegisterParameters` to see the notices that need acknowledgement.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 3;</code>
     *
     * @param values The enum numeric values on the wire for domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomainNoticesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDomainNoticesIsMutable();
      for (int value : values) {
        domainNotices_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> contactNotices_ = java.util.Collections.emptyList();

    private void ensureContactNoticesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        contactNotices_ = new java.util.ArrayList<java.lang.Integer>(contactNotices_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return A list containing the contactNotices.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.ContactNotice> getContactNoticesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactNotice>(
          contactNotices_, contactNotices_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return The count of contactNotices.
     */
    public int getContactNoticesCount() {
      return contactNotices_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The contactNotices at the given index.
     */
    public com.google.cloud.domains.v1alpha2.ContactNotice getContactNotices(int index) {
      return contactNotices_converter_.convert(contactNotices_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The contactNotices to set.
     * @return This builder for chaining.
     */
    public Builder setContactNotices(
        int index, com.google.cloud.domains.v1alpha2.ContactNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContactNoticesIsMutable();
      contactNotices_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param value The contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addContactNotices(com.google.cloud.domains.v1alpha2.ContactNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContactNoticesIsMutable();
      contactNotices_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param values The contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllContactNotices(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.ContactNotice> values) {
      ensureContactNoticesIsMutable();
      for (com.google.cloud.domains.v1alpha2.ContactNotice value : values) {
        contactNotices_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContactNotices() {
      contactNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @return A list containing the enum numeric values on the wire for contactNotices.
     */
    public java.util.List<java.lang.Integer> getContactNoticesValueList() {
      return java.util.Collections.unmodifiableList(contactNotices_);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of contactNotices at the given index.
     */
    public int getContactNoticesValue(int index) {
      return contactNotices_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for contactNotices to set.
     * @return This builder for chaining.
     */
    public Builder setContactNoticesValue(int index, int value) {
      ensureContactNoticesIsMutable();
      contactNotices_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param value The enum numeric value on the wire for contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addContactNoticesValue(int value) {
      ensureContactNoticesIsMutable();
      contactNotices_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of contact notices that the caller acknowledges. The notices
     * needed here depend on the values specified in
     * `registration.contact_settings`.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactNotice contact_notices = 4;</code>
     *
     * @param values The enum numeric values on the wire for contactNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllContactNoticesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureContactNoticesIsMutable();
      for (int value : values) {
        contactNotices_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.type.Money yearlyPrice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        yearlyPriceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the yearlyPrice field is set.
     */
    public boolean hasYearlyPrice() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The yearlyPrice.
     */
    public com.google.type.Money getYearlyPrice() {
      if (yearlyPriceBuilder_ == null) {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      } else {
        return yearlyPriceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        yearlyPrice_ = value;
      } else {
        yearlyPriceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setYearlyPrice(com.google.type.Money.Builder builderForValue) {
      if (yearlyPriceBuilder_ == null) {
        yearlyPrice_ = builderForValue.build();
      } else {
        yearlyPriceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && yearlyPrice_ != null
            && yearlyPrice_ != com.google.type.Money.getDefaultInstance()) {
          getYearlyPriceBuilder().mergeFrom(value);
        } else {
          yearlyPrice_ = value;
        }
      } else {
        yearlyPriceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearYearlyPrice() {
      bitField0_ = (bitField0_ & ~0x00000010);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.type.Money.Builder getYearlyPriceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getYearlyPriceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
      if (yearlyPriceBuilder_ != null) {
        return yearlyPriceBuilder_.getMessageOrBuilder();
      } else {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Yearly price to register or renew the domain.
     * The value that should be put here can be obtained from
     * RetrieveRegisterParameters or SearchDomains calls.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getYearlyPriceFieldBuilder() {
      if (yearlyPriceBuilder_ == null) {
        yearlyPriceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                getYearlyPrice(), getParentForChildren(), isClean());
        yearlyPrice_ = null;
      }
      return yearlyPriceBuilder_;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * When true, only validation is performed, without actually registering
     * the domain. Follows:
     * https://cloud.google.com/apis/design/design_patterns#request_validation
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * When true, only validation is performed, without actually registering
     * the domain. Follows:
     * https://cloud.google.com/apis/design/design_patterns#request_validation
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When true, only validation is performed, without actually registering
     * the domain. Follows:
     * https://cloud.google.com/apis/design/design_patterns#request_validation
     * </pre>
     *
     * <code>bool validate_only = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000020);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.RegisterDomainRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.RegisterDomainRequest)
  private static final com.google.cloud.domains.v1alpha2.RegisterDomainRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.RegisterDomainRequest();
  }

  public static com.google.cloud.domains.v1alpha2.RegisterDomainRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RegisterDomainRequest> PARSER =
      new com.google.protobuf.AbstractParser<RegisterDomainRequest>() {
        @java.lang.Override
        public RegisterDomainRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RegisterDomainRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RegisterDomainRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.RegisterDomainRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
