/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Parameters required to register a new domain.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.RegisterParameters}
 */
public final class RegisterParameters extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.RegisterParameters)
    RegisterParametersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RegisterParameters.newBuilder() to construct.
  private RegisterParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RegisterParameters() {
    domainName_ = "";
    availability_ = 0;
    supportedPrivacy_ = java.util.Collections.emptyList();
    domainNotices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RegisterParameters();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_RegisterParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_RegisterParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.RegisterParameters.class,
            com.google.cloud.domains.v1alpha2.RegisterParameters.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible availability states of a domain name.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.domains.v1alpha2.RegisterParameters.Availability}
   */
  public enum Availability implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The availability is unspecified.
     * </pre>
     *
     * <code>AVAILABILITY_UNSPECIFIED = 0;</code>
     */
    AVAILABILITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The domain is available for registration.
     * </pre>
     *
     * <code>AVAILABLE = 1;</code>
     */
    AVAILABLE(1),
    /**
     *
     *
     * <pre>
     * The domain is not available for registration. Generally this means it is
     * already registered to another party.
     * </pre>
     *
     * <code>UNAVAILABLE = 2;</code>
     */
    UNAVAILABLE(2),
    /**
     *
     *
     * <pre>
     * The domain is not currently supported by Cloud Domains, but may
     * be available elsewhere.
     * </pre>
     *
     * <code>UNSUPPORTED = 3;</code>
     */
    UNSUPPORTED(3),
    /**
     *
     *
     * <pre>
     * Cloud Domains is unable to determine domain availability, generally
     * due to system maintenance at the domain name registry.
     * </pre>
     *
     * <code>UNKNOWN = 4;</code>
     */
    UNKNOWN(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The availability is unspecified.
     * </pre>
     *
     * <code>AVAILABILITY_UNSPECIFIED = 0;</code>
     */
    public static final int AVAILABILITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The domain is available for registration.
     * </pre>
     *
     * <code>AVAILABLE = 1;</code>
     */
    public static final int AVAILABLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The domain is not available for registration. Generally this means it is
     * already registered to another party.
     * </pre>
     *
     * <code>UNAVAILABLE = 2;</code>
     */
    public static final int UNAVAILABLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The domain is not currently supported by Cloud Domains, but may
     * be available elsewhere.
     * </pre>
     *
     * <code>UNSUPPORTED = 3;</code>
     */
    public static final int UNSUPPORTED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Cloud Domains is unable to determine domain availability, generally
     * due to system maintenance at the domain name registry.
     * </pre>
     *
     * <code>UNKNOWN = 4;</code>
     */
    public static final int UNKNOWN_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Availability valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Availability forNumber(int value) {
      switch (value) {
        case 0:
          return AVAILABILITY_UNSPECIFIED;
        case 1:
          return AVAILABLE;
        case 2:
          return UNAVAILABLE;
        case 3:
          return UNSUPPORTED;
        case 4:
          return UNKNOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Availability> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Availability> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Availability>() {
          public Availability findValueByNumber(int number) {
            return Availability.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.RegisterParameters.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Availability[] VALUES = values();

    public static Availability valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Availability(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.RegisterParameters.Availability)
  }

  public static final int DOMAIN_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domainName_ = "";
  /**
   *
   *
   * <pre>
   * The domain name. Unicode domain names are expressed in Punycode format.
   * </pre>
   *
   * <code>string domain_name = 1;</code>
   *
   * @return The domainName.
   */
  @java.lang.Override
  public java.lang.String getDomainName() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domainName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The domain name. Unicode domain names are expressed in Punycode format.
   * </pre>
   *
   * <code>string domain_name = 1;</code>
   *
   * @return The bytes for domainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainNameBytes() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABILITY_FIELD_NUMBER = 2;
  private int availability_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates whether the domain is available for registration. This value is
   * accurate when obtained by calling `RetrieveRegisterParameters`, but is
   * approximate when obtained by calling `SearchDomains`.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
   *
   * @return The enum numeric value on the wire for availability.
   */
  @java.lang.Override
  public int getAvailabilityValue() {
    return availability_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether the domain is available for registration. This value is
   * accurate when obtained by calling `RetrieveRegisterParameters`, but is
   * approximate when obtained by calling `SearchDomains`.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
   *
   * @return The availability.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.RegisterParameters.Availability getAvailability() {
    com.google.cloud.domains.v1alpha2.RegisterParameters.Availability result =
        com.google.cloud.domains.v1alpha2.RegisterParameters.Availability.forNumber(availability_);
    return result == null
        ? com.google.cloud.domains.v1alpha2.RegisterParameters.Availability.UNRECOGNIZED
        : result;
  }

  public static final int SUPPORTED_PRIVACY_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> supportedPrivacy_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>
      supportedPrivacy_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>() {
            public com.google.cloud.domains.v1alpha2.ContactPrivacy convert(
                java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.ContactPrivacy result =
                  com.google.cloud.domains.v1alpha2.ContactPrivacy.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.ContactPrivacy.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
   *
   * @return A list containing the supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
      getSupportedPrivacyList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
        supportedPrivacy_, supportedPrivacy_converter_);
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
   *
   * @return The count of supportedPrivacy.
   */
  @java.lang.Override
  public int getSupportedPrivacyCount() {
    return supportedPrivacy_.size();
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedPrivacy at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
    return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
   *
   * @return A list containing the enum numeric values on the wire for supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
    return supportedPrivacy_;
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedPrivacy at the given index.
   */
  @java.lang.Override
  public int getSupportedPrivacyValue(int index) {
    return supportedPrivacy_.get(index);
  }

  private int supportedPrivacyMemoizedSerializedSize;

  public static final int DOMAIN_NOTICES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> domainNotices_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>
      domainNotices_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>() {
            public com.google.cloud.domains.v1alpha2.DomainNotice convert(java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.DomainNotice result =
                  com.google.cloud.domains.v1alpha2.DomainNotice.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.DomainNotice.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Notices about special properties of the domain.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
   *
   * @return A list containing the domainNotices.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.DomainNotice> getDomainNoticesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>(
        domainNotices_, domainNotices_converter_);
  }
  /**
   *
   *
   * <pre>
   * Notices about special properties of the domain.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
   *
   * @return The count of domainNotices.
   */
  @java.lang.Override
  public int getDomainNoticesCount() {
    return domainNotices_.size();
  }
  /**
   *
   *
   * <pre>
   * Notices about special properties of the domain.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The domainNotices at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DomainNotice getDomainNotices(int index) {
    return domainNotices_converter_.convert(domainNotices_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Notices about special properties of the domain.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for domainNotices.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDomainNoticesValueList() {
    return domainNotices_;
  }
  /**
   *
   *
   * <pre>
   * Notices about special properties of the domain.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of domainNotices at the given index.
   */
  @java.lang.Override
  public int getDomainNoticesValue(int index) {
    return domainNotices_.get(index);
  }

  private int domainNoticesMemoizedSerializedSize;

  public static final int YEARLY_PRICE_FIELD_NUMBER = 5;
  private com.google.type.Money yearlyPrice_;
  /**
   *
   *
   * <pre>
   * Price to register or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5;</code>
   *
   * @return Whether the yearlyPrice field is set.
   */
  @java.lang.Override
  public boolean hasYearlyPrice() {
    return yearlyPrice_ != null;
  }
  /**
   *
   *
   * <pre>
   * Price to register or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5;</code>
   *
   * @return The yearlyPrice.
   */
  @java.lang.Override
  public com.google.type.Money getYearlyPrice() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }
  /**
   *
   *
   * <pre>
   * Price to register or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 5;</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domainName_);
    }
    if (availability_
        != com.google.cloud.domains.v1alpha2.RegisterParameters.Availability
            .AVAILABILITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, availability_);
    }
    if (getSupportedPrivacyList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(supportedPrivacyMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedPrivacy_.size(); i++) {
      output.writeEnumNoTag(supportedPrivacy_.get(i));
    }
    if (getDomainNoticesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(domainNoticesMemoizedSerializedSize);
    }
    for (int i = 0; i < domainNotices_.size(); i++) {
      output.writeEnumNoTag(domainNotices_.get(i));
    }
    if (yearlyPrice_ != null) {
      output.writeMessage(5, getYearlyPrice());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domainName_);
    }
    if (availability_
        != com.google.cloud.domains.v1alpha2.RegisterParameters.Availability
            .AVAILABILITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, availability_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedPrivacy_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(supportedPrivacy_.get(i));
      }
      size += dataSize;
      if (!getSupportedPrivacyList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedPrivacyMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domainNotices_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(domainNotices_.get(i));
      }
      size += dataSize;
      if (!getDomainNoticesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      domainNoticesMemoizedSerializedSize = dataSize;
    }
    if (yearlyPrice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getYearlyPrice());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.RegisterParameters)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.RegisterParameters other =
        (com.google.cloud.domains.v1alpha2.RegisterParameters) obj;

    if (!getDomainName().equals(other.getDomainName())) return false;
    if (availability_ != other.availability_) return false;
    if (!supportedPrivacy_.equals(other.supportedPrivacy_)) return false;
    if (!domainNotices_.equals(other.domainNotices_)) return false;
    if (hasYearlyPrice() != other.hasYearlyPrice()) return false;
    if (hasYearlyPrice()) {
      if (!getYearlyPrice().equals(other.getYearlyPrice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DOMAIN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDomainName().hashCode();
    hash = (37 * hash) + AVAILABILITY_FIELD_NUMBER;
    hash = (53 * hash) + availability_;
    if (getSupportedPrivacyCount() > 0) {
      hash = (37 * hash) + SUPPORTED_PRIVACY_FIELD_NUMBER;
      hash = (53 * hash) + supportedPrivacy_.hashCode();
    }
    if (getDomainNoticesCount() > 0) {
      hash = (37 * hash) + DOMAIN_NOTICES_FIELD_NUMBER;
      hash = (53 * hash) + domainNotices_.hashCode();
    }
    if (hasYearlyPrice()) {
      hash = (37 * hash) + YEARLY_PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getYearlyPrice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.domains.v1alpha2.RegisterParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters required to register a new domain.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.RegisterParameters}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.RegisterParameters)
      com.google.cloud.domains.v1alpha2.RegisterParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.RegisterParameters.class,
              com.google.cloud.domains.v1alpha2.RegisterParameters.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.RegisterParameters.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      domainName_ = "";
      availability_ = 0;
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      domainNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_RegisterParameters_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterParameters getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.RegisterParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterParameters build() {
      com.google.cloud.domains.v1alpha2.RegisterParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterParameters buildPartial() {
      com.google.cloud.domains.v1alpha2.RegisterParameters result =
          new com.google.cloud.domains.v1alpha2.RegisterParameters(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.domains.v1alpha2.RegisterParameters result) {
      if (((bitField0_ & 0x00000004) != 0)) {
        supportedPrivacy_ = java.util.Collections.unmodifiableList(supportedPrivacy_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.supportedPrivacy_ = supportedPrivacy_;
      if (((bitField0_ & 0x00000008) != 0)) {
        domainNotices_ = java.util.Collections.unmodifiableList(domainNotices_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.domainNotices_ = domainNotices_;
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.RegisterParameters result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.domainName_ = domainName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.availability_ = availability_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.yearlyPrice_ =
            yearlyPriceBuilder_ == null ? yearlyPrice_ : yearlyPriceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.RegisterParameters) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.RegisterParameters) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.RegisterParameters other) {
      if (other == com.google.cloud.domains.v1alpha2.RegisterParameters.getDefaultInstance())
        return this;
      if (!other.getDomainName().isEmpty()) {
        domainName_ = other.domainName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.availability_ != 0) {
        setAvailabilityValue(other.getAvailabilityValue());
      }
      if (!other.supportedPrivacy_.isEmpty()) {
        if (supportedPrivacy_.isEmpty()) {
          supportedPrivacy_ = other.supportedPrivacy_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureSupportedPrivacyIsMutable();
          supportedPrivacy_.addAll(other.supportedPrivacy_);
        }
        onChanged();
      }
      if (!other.domainNotices_.isEmpty()) {
        if (domainNotices_.isEmpty()) {
          domainNotices_ = other.domainNotices_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureDomainNoticesIsMutable();
          domainNotices_.addAll(other.domainNotices_);
        }
        onChanged();
      }
      if (other.hasYearlyPrice()) {
        mergeYearlyPrice(other.getYearlyPrice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                domainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                availability_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureSupportedPrivacyIsMutable();
                supportedPrivacy_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSupportedPrivacyIsMutable();
                  supportedPrivacy_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureDomainNoticesIsMutable();
                domainNotices_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDomainNoticesIsMutable();
                  domainNotices_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getYearlyPriceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object domainName_ = "";
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return The domainName.
     */
    public java.lang.String getDomainName() {
      java.lang.Object ref = domainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return The bytes for domainName.
     */
    public com.google.protobuf.ByteString getDomainNameBytes() {
      java.lang.Object ref = domainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @param value The domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainName() {
      domainName_ = getDefaultInstance().getDomainName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @param value The bytes for domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int availability_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is available for registration. This value is
     * accurate when obtained by calling `RetrieveRegisterParameters`, but is
     * approximate when obtained by calling `SearchDomains`.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
     *
     * @return The enum numeric value on the wire for availability.
     */
    @java.lang.Override
    public int getAvailabilityValue() {
      return availability_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is available for registration. This value is
     * accurate when obtained by calling `RetrieveRegisterParameters`, but is
     * approximate when obtained by calling `SearchDomains`.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
     *
     * @param value The enum numeric value on the wire for availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailabilityValue(int value) {
      availability_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is available for registration. This value is
     * accurate when obtained by calling `RetrieveRegisterParameters`, but is
     * approximate when obtained by calling `SearchDomains`.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
     *
     * @return The availability.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.RegisterParameters.Availability getAvailability() {
      com.google.cloud.domains.v1alpha2.RegisterParameters.Availability result =
          com.google.cloud.domains.v1alpha2.RegisterParameters.Availability.forNumber(
              availability_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.RegisterParameters.Availability.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is available for registration. This value is
     * accurate when obtained by calling `RetrieveRegisterParameters`, but is
     * approximate when obtained by calling `SearchDomains`.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
     *
     * @param value The availability to set.
     * @return This builder for chaining.
     */
    public Builder setAvailability(
        com.google.cloud.domains.v1alpha2.RegisterParameters.Availability value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      availability_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is available for registration. This value is
     * accurate when obtained by calling `RetrieveRegisterParameters`, but is
     * approximate when obtained by calling `SearchDomains`.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.RegisterParameters.Availability availability = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailability() {
      bitField0_ = (bitField0_ & ~0x00000002);
      availability_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> supportedPrivacy_ = java.util.Collections.emptyList();

    private void ensureSupportedPrivacyIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        supportedPrivacy_ = new java.util.ArrayList<java.lang.Integer>(supportedPrivacy_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @return A list containing the supportedPrivacy.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
        getSupportedPrivacyList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
          supportedPrivacy_, supportedPrivacy_converter_);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @return The count of supportedPrivacy.
     */
    public int getSupportedPrivacyCount() {
      return supportedPrivacy_.size();
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedPrivacy at the given index.
     */
    public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
      return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacy(
        int index, com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param value The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacy(com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param values The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacy(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.ContactPrivacy> values) {
      ensureSupportedPrivacyIsMutable();
      for (com.google.cloud.domains.v1alpha2.ContactPrivacy value : values) {
        supportedPrivacy_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedPrivacy() {
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for supportedPrivacy.
     */
    public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
      return java.util.Collections.unmodifiableList(supportedPrivacy_);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedPrivacy at the given index.
     */
    public int getSupportedPrivacyValue(int index) {
      return supportedPrivacy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacyValue(int index, int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param value The enum numeric value on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacyValue(int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 3;</code>
     *
     * @param values The enum numeric values on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacyValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedPrivacyIsMutable();
      for (int value : values) {
        supportedPrivacy_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> domainNotices_ = java.util.Collections.emptyList();

    private void ensureDomainNoticesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        domainNotices_ = new java.util.ArrayList<java.lang.Integer>(domainNotices_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @return A list containing the domainNotices.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.DomainNotice> getDomainNoticesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.DomainNotice>(
          domainNotices_, domainNotices_converter_);
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @return The count of domainNotices.
     */
    public int getDomainNoticesCount() {
      return domainNotices_.size();
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The domainNotices at the given index.
     */
    public com.google.cloud.domains.v1alpha2.DomainNotice getDomainNotices(int index) {
      return domainNotices_converter_.convert(domainNotices_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The domainNotices to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNotices(
        int index, com.google.cloud.domains.v1alpha2.DomainNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNoticesIsMutable();
      domainNotices_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param value The domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNotices(com.google.cloud.domains.v1alpha2.DomainNotice value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDomainNoticesIsMutable();
      domainNotices_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param values The domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomainNotices(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.DomainNotice> values) {
      ensureDomainNoticesIsMutable();
      for (com.google.cloud.domains.v1alpha2.DomainNotice value : values) {
        domainNotices_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainNotices() {
      domainNotices_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @return A list containing the enum numeric values on the wire for domainNotices.
     */
    public java.util.List<java.lang.Integer> getDomainNoticesValueList() {
      return java.util.Collections.unmodifiableList(domainNotices_);
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of domainNotices at the given index.
     */
    public int getDomainNoticesValue(int index) {
      return domainNotices_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for domainNotices to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNoticesValue(int index, int value) {
      ensureDomainNoticesIsMutable();
      domainNotices_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param value The enum numeric value on the wire for domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addDomainNoticesValue(int value) {
      ensureDomainNoticesIsMutable();
      domainNotices_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notices about special properties of the domain.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.DomainNotice domain_notices = 4;</code>
     *
     * @param values The enum numeric values on the wire for domainNotices to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomainNoticesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDomainNoticesIsMutable();
      for (int value : values) {
        domainNotices_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.type.Money yearlyPrice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        yearlyPriceBuilder_;
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     *
     * @return Whether the yearlyPrice field is set.
     */
    public boolean hasYearlyPrice() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     *
     * @return The yearlyPrice.
     */
    public com.google.type.Money getYearlyPrice() {
      if (yearlyPriceBuilder_ == null) {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      } else {
        return yearlyPriceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public Builder setYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        yearlyPrice_ = value;
      } else {
        yearlyPriceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public Builder setYearlyPrice(com.google.type.Money.Builder builderForValue) {
      if (yearlyPriceBuilder_ == null) {
        yearlyPrice_ = builderForValue.build();
      } else {
        yearlyPriceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public Builder mergeYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && yearlyPrice_ != null
            && yearlyPrice_ != com.google.type.Money.getDefaultInstance()) {
          getYearlyPriceBuilder().mergeFrom(value);
        } else {
          yearlyPrice_ = value;
        }
      } else {
        yearlyPriceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public Builder clearYearlyPrice() {
      bitField0_ = (bitField0_ & ~0x00000010);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public com.google.type.Money.Builder getYearlyPriceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getYearlyPriceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
      if (yearlyPriceBuilder_ != null) {
        return yearlyPriceBuilder_.getMessageOrBuilder();
      } else {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Price to register or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getYearlyPriceFieldBuilder() {
      if (yearlyPriceBuilder_ == null) {
        yearlyPriceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                getYearlyPrice(), getParentForChildren(), isClean());
        yearlyPrice_ = null;
      }
      return yearlyPriceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.RegisterParameters)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.RegisterParameters)
  private static final com.google.cloud.domains.v1alpha2.RegisterParameters DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.RegisterParameters();
  }

  public static com.google.cloud.domains.v1alpha2.RegisterParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RegisterParameters> PARSER =
      new com.google.protobuf.AbstractParser<RegisterParameters>() {
        @java.lang.Override
        public RegisterParameters parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RegisterParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RegisterParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.RegisterParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
