/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * The `Registration` resource facilitates managing and configuring domain name
 * registrations.
 *
 * There are several ways to create a new `Registration` resource:
 *
 * To create a new `Registration` resource, find a suitable domain name by
 * calling the `SearchDomains` method with a query to see available domain name
 * options. After choosing a name, call `RetrieveRegisterParameters` to
 * ensure availability and obtain information like pricing, which is needed to
 * build a call to `RegisterDomain`.
 *
 * Another way to create a new `Registration` is to transfer an existing
 * domain from another registrar. First, go to the current registrar to unlock
 * the domain for transfer and retrieve the domain's transfer authorization
 * code. Then call `RetrieveTransferParameters` to confirm that the domain is
 * unlocked and to get values needed to build a call to `TransferDomain`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.Registration}
 */
public final class Registration extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.Registration)
    RegistrationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Registration.newBuilder() to construct.
  private Registration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Registration() {
    name_ = "";
    domainName_ = "";
    state_ = 0;
    issues_ = java.util.Collections.emptyList();
    supportedPrivacy_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Registration();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_Registration_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_Registration_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.Registration.class,
            com.google.cloud.domains.v1alpha2.Registration.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a `Registration`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.domains.v1alpha2.Registration.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state is undefined.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The domain is being registered.
     * </pre>
     *
     * <code>REGISTRATION_PENDING = 1;</code>
     */
    REGISTRATION_PENDING(1),
    /**
     *
     *
     * <pre>
     * The domain registration failed. You can delete resources in this state
     * to allow registration to be retried.
     * </pre>
     *
     * <code>REGISTRATION_FAILED = 2;</code>
     */
    REGISTRATION_FAILED(2),
    /**
     *
     *
     * <pre>
     * The domain is being transferred from another registrar to Cloud Domains.
     * </pre>
     *
     * <code>TRANSFER_PENDING = 3;</code>
     */
    TRANSFER_PENDING(3),
    /**
     *
     *
     * <pre>
     * The attempt to transfer the domain from another registrar to
     * Cloud Domains failed. You can delete resources in this state and retry
     * the transfer.
     * </pre>
     *
     * <code>TRANSFER_FAILED = 4;</code>
     */
    TRANSFER_FAILED(4),
    /**
     *
     *
     * <pre>
     * The domain is registered and operational. The domain renews automatically
     * as long as it remains in this state.
     * </pre>
     *
     * <code>ACTIVE = 6;</code>
     */
    ACTIVE(6),
    /**
     *
     *
     * <pre>
     * The domain is suspended and inoperative. For more details, see the
     * `issues` field.
     * </pre>
     *
     * <code>SUSPENDED = 7;</code>
     */
    SUSPENDED(7),
    /**
     *
     *
     * <pre>
     * The domain is no longer managed with Cloud Domains. It may have been
     * transferred to another registrar or exported for management in
     * [Google Domains](https://domains.google/). You can no longer update it
     * with this API, and information shown about it may be stale. Domains in
     * this state are not automatically renewed by Cloud Domains.
     * </pre>
     *
     * <code>EXPORTED = 8;</code>
     */
    EXPORTED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state is undefined.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The domain is being registered.
     * </pre>
     *
     * <code>REGISTRATION_PENDING = 1;</code>
     */
    public static final int REGISTRATION_PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The domain registration failed. You can delete resources in this state
     * to allow registration to be retried.
     * </pre>
     *
     * <code>REGISTRATION_FAILED = 2;</code>
     */
    public static final int REGISTRATION_FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The domain is being transferred from another registrar to Cloud Domains.
     * </pre>
     *
     * <code>TRANSFER_PENDING = 3;</code>
     */
    public static final int TRANSFER_PENDING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The attempt to transfer the domain from another registrar to
     * Cloud Domains failed. You can delete resources in this state and retry
     * the transfer.
     * </pre>
     *
     * <code>TRANSFER_FAILED = 4;</code>
     */
    public static final int TRANSFER_FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The domain is registered and operational. The domain renews automatically
     * as long as it remains in this state.
     * </pre>
     *
     * <code>ACTIVE = 6;</code>
     */
    public static final int ACTIVE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The domain is suspended and inoperative. For more details, see the
     * `issues` field.
     * </pre>
     *
     * <code>SUSPENDED = 7;</code>
     */
    public static final int SUSPENDED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The domain is no longer managed with Cloud Domains. It may have been
     * transferred to another registrar or exported for management in
     * [Google Domains](https://domains.google/). You can no longer update it
     * with this API, and information shown about it may be stale. Domains in
     * this state are not automatically renewed by Cloud Domains.
     * </pre>
     *
     * <code>EXPORTED = 8;</code>
     */
    public static final int EXPORTED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return REGISTRATION_PENDING;
        case 2:
          return REGISTRATION_FAILED;
        case 3:
          return TRANSFER_PENDING;
        case 4:
          return TRANSFER_FAILED;
        case 6:
          return ACTIVE;
        case 7:
          return SUSPENDED;
        case 8:
          return EXPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.Registration.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.Registration.State)
  }

  /**
   *
   *
   * <pre>
   * Possible issues with a `Registration` that require attention.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.domains.v1alpha2.Registration.Issue}
   */
  public enum Issue implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The issue is undefined.
     * </pre>
     *
     * <code>ISSUE_UNSPECIFIED = 0;</code>
     */
    ISSUE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Contact the Cloud Support team to resolve a problem with this domain.
     * </pre>
     *
     * <code>CONTACT_SUPPORT = 1;</code>
     */
    CONTACT_SUPPORT(1),
    /**
     *
     *
     * <pre>
     * [ICANN](https://icann.org/) requires verification of the email address
     * in the `Registration`'s `contact_settings.registrant_contact` field. To
     * verify the email address, follow the
     * instructions in the email the `registrant_contact` receives following
     * registration. If you do not complete email verification within
     * 15 days of registration, the domain is suspended. To resend the
     * verification email, call ConfigureContactSettings and provide the current
     * `registrant_contact.email`.
     * </pre>
     *
     * <code>UNVERIFIED_EMAIL = 2;</code>
     */
    UNVERIFIED_EMAIL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The issue is undefined.
     * </pre>
     *
     * <code>ISSUE_UNSPECIFIED = 0;</code>
     */
    public static final int ISSUE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Contact the Cloud Support team to resolve a problem with this domain.
     * </pre>
     *
     * <code>CONTACT_SUPPORT = 1;</code>
     */
    public static final int CONTACT_SUPPORT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * [ICANN](https://icann.org/) requires verification of the email address
     * in the `Registration`'s `contact_settings.registrant_contact` field. To
     * verify the email address, follow the
     * instructions in the email the `registrant_contact` receives following
     * registration. If you do not complete email verification within
     * 15 days of registration, the domain is suspended. To resend the
     * verification email, call ConfigureContactSettings and provide the current
     * `registrant_contact.email`.
     * </pre>
     *
     * <code>UNVERIFIED_EMAIL = 2;</code>
     */
    public static final int UNVERIFIED_EMAIL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Issue valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Issue forNumber(int value) {
      switch (value) {
        case 0:
          return ISSUE_UNSPECIFIED;
        case 1:
          return CONTACT_SUPPORT;
        case 2:
          return UNVERIFIED_EMAIL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Issue> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Issue> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Issue>() {
          public Issue findValueByNumber(int number) {
            return Issue.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.Registration.getDescriptor().getEnumTypes().get(1);
    }

    private static final Issue[] VALUES = values();

    public static Issue valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Issue(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.domains.v1alpha2.Registration.Issue)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Registration` resource, in the format
   * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Registration` resource, in the format
   * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAIN_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domainName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
   * </pre>
   *
   * <code>
   * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The domainName.
   */
  @java.lang.Override
  public java.lang.String getDomainName() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domainName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
   * </pre>
   *
   * <code>
   * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The bytes for domainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainNameBytes() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the `Registration` resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the `Registration` resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the `Registration` resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. The expiration timestamp of the `Registration`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The expiration timestamp of the `Registration`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The expiration timestamp of the `Registration`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the `Registration`
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the `Registration`
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.Registration.State getState() {
    com.google.cloud.domains.v1alpha2.Registration.State result =
        com.google.cloud.domains.v1alpha2.Registration.State.forNumber(state_);
    return result == null
        ? com.google.cloud.domains.v1alpha2.Registration.State.UNRECOGNIZED
        : result;
  }

  public static final int ISSUES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> issues_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.Registration.Issue>
      issues_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.Registration.Issue>() {
            public com.google.cloud.domains.v1alpha2.Registration.Issue convert(
                java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.Registration.Issue result =
                  com.google.cloud.domains.v1alpha2.Registration.Issue.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.Registration.Issue.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. The set of issues with the `Registration` that require attention.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the issues.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.Registration.Issue> getIssuesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.Registration.Issue>(
        issues_, issues_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. The set of issues with the `Registration` that require attention.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of issues.
   */
  @java.lang.Override
  public int getIssuesCount() {
    return issues_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The set of issues with the `Registration` that require attention.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The issues at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.Registration.Issue getIssues(int index) {
    return issues_converter_.convert(issues_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. The set of issues with the `Registration` that require attention.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for issues.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getIssuesValueList() {
    return issues_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The set of issues with the `Registration` that require attention.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of issues at the given index.
   */
  @java.lang.Override
  public int getIssuesValue(int index) {
    return issues_.get(index);
  }

  private int issuesMemoizedSerializedSize;

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.domains.v1alpha2.DomainsProto
                .internal_static_google_cloud_domains_v1alpha2_Registration_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with the `Registration`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with the `Registration`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with the `Registration`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Set of labels associated with the `Registration`.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MANAGEMENT_SETTINGS_FIELD_NUMBER = 10;
  private com.google.cloud.domains.v1alpha2.ManagementSettings managementSettings_;
  /**
   *
   *
   * <pre>
   * Settings for management of the `Registration`, including renewal, billing,
   * and transfer. You cannot update these with the `UpdateRegistration`
   * method. To update these settings, use the `ConfigureManagementSettings`
   * method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
   *
   * @return Whether the managementSettings field is set.
   */
  @java.lang.Override
  public boolean hasManagementSettings() {
    return managementSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for management of the `Registration`, including renewal, billing,
   * and transfer. You cannot update these with the `UpdateRegistration`
   * method. To update these settings, use the `ConfigureManagementSettings`
   * method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
   *
   * @return The managementSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ManagementSettings getManagementSettings() {
    return managementSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ManagementSettings.getDefaultInstance()
        : managementSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for management of the `Registration`, including renewal, billing,
   * and transfer. You cannot update these with the `UpdateRegistration`
   * method. To update these settings, use the `ConfigureManagementSettings`
   * method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ManagementSettingsOrBuilder
      getManagementSettingsOrBuilder() {
    return managementSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ManagementSettings.getDefaultInstance()
        : managementSettings_;
  }

  public static final int DNS_SETTINGS_FIELD_NUMBER = 11;
  private com.google.cloud.domains.v1alpha2.DnsSettings dnsSettings_;
  /**
   *
   *
   * <pre>
   * Settings controlling the DNS configuration of the `Registration`. You
   * cannot update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureDnsSettings` method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
   *
   * @return Whether the dnsSettings field is set.
   */
  @java.lang.Override
  public boolean hasDnsSettings() {
    return dnsSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings controlling the DNS configuration of the `Registration`. You
   * cannot update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureDnsSettings` method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
   *
   * @return The dnsSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettings getDnsSettings() {
    return dnsSettings_ == null
        ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
        : dnsSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings controlling the DNS configuration of the `Registration`. You
   * cannot update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureDnsSettings` method.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder getDnsSettingsOrBuilder() {
    return dnsSettings_ == null
        ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
        : dnsSettings_;
  }

  public static final int CONTACT_SETTINGS_FIELD_NUMBER = 12;
  private com.google.cloud.domains.v1alpha2.ContactSettings contactSettings_;
  /**
   *
   *
   * <pre>
   * Required. Settings for contact information linked to the `Registration`. You cannot
   * update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureContactSettings` method.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the contactSettings field is set.
   */
  @java.lang.Override
  public boolean hasContactSettings() {
    return contactSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Settings for contact information linked to the `Registration`. You cannot
   * update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureContactSettings` method.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The contactSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings getContactSettings() {
    return contactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : contactSettings_;
  }
  /**
   *
   *
   * <pre>
   * Required. Settings for contact information linked to the `Registration`. You cannot
   * update these with the `UpdateRegistration` method. To update these
   * settings, use the `ConfigureContactSettings` method.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder getContactSettingsOrBuilder() {
    return contactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : contactSettings_;
  }

  public static final int PENDING_CONTACT_SETTINGS_FIELD_NUMBER = 13;
  private com.google.cloud.domains.v1alpha2.ContactSettings pendingContactSettings_;
  /**
   *
   *
   * <pre>
   * Output only. Pending contact settings for the `Registration`. Updates to the
   * `contact_settings` field that change its `registrant_contact` or `privacy`
   * fields require email confirmation by the `registrant_contact`
   * before taking effect. This field is set only if there are pending updates
   * to the `contact_settings` that have not been confirmed. To confirm the
   * changes, the `registrant_contact` must follow the instructions in the
   * email they receive.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the pendingContactSettings field is set.
   */
  @java.lang.Override
  public boolean hasPendingContactSettings() {
    return pendingContactSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pending contact settings for the `Registration`. Updates to the
   * `contact_settings` field that change its `registrant_contact` or `privacy`
   * fields require email confirmation by the `registrant_contact`
   * before taking effect. This field is set only if there are pending updates
   * to the `contact_settings` that have not been confirmed. To confirm the
   * changes, the `registrant_contact` must follow the instructions in the
   * email they receive.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The pendingContactSettings.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettings getPendingContactSettings() {
    return pendingContactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : pendingContactSettings_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Pending contact settings for the `Registration`. Updates to the
   * `contact_settings` field that change its `registrant_contact` or `privacy`
   * fields require email confirmation by the `registrant_contact`
   * before taking effect. This field is set only if there are pending updates
   * to the `contact_settings` that have not been confirmed. To confirm the
   * changes, the `registrant_contact` must follow the instructions in the
   * email they receive.
   * </pre>
   *
   * <code>
   * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder
      getPendingContactSettingsOrBuilder() {
    return pendingContactSettings_ == null
        ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
        : pendingContactSettings_;
  }

  public static final int SUPPORTED_PRIVACY_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> supportedPrivacy_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>
      supportedPrivacy_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>() {
            public com.google.cloud.domains.v1alpha2.ContactPrivacy convert(
                java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.ContactPrivacy result =
                  com.google.cloud.domains.v1alpha2.ContactPrivacy.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.ContactPrivacy.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. Set of options for the `contact_settings.privacy` field that this
   * `Registration` supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
      getSupportedPrivacyList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
        supportedPrivacy_, supportedPrivacy_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. Set of options for the `contact_settings.privacy` field that this
   * `Registration` supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedPrivacy.
   */
  @java.lang.Override
  public int getSupportedPrivacyCount() {
    return supportedPrivacy_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Set of options for the `contact_settings.privacy` field that this
   * `Registration` supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedPrivacy at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
    return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. Set of options for the `contact_settings.privacy` field that this
   * `Registration` supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
    return supportedPrivacy_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Set of options for the `contact_settings.privacy` field that this
   * `Registration` supports.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedPrivacy at the given index.
   */
  @java.lang.Override
  public int getSupportedPrivacyValue(int index) {
    return supportedPrivacy_.get(index);
  }

  private int supportedPrivacyMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, domainName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (expireTime_ != null) {
      output.writeMessage(6, getExpireTime());
    }
    if (state_
        != com.google.cloud.domains.v1alpha2.Registration.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (getIssuesList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(issuesMemoizedSerializedSize);
    }
    for (int i = 0; i < issues_.size(); i++) {
      output.writeEnumNoTag(issues_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (managementSettings_ != null) {
      output.writeMessage(10, getManagementSettings());
    }
    if (dnsSettings_ != null) {
      output.writeMessage(11, getDnsSettings());
    }
    if (contactSettings_ != null) {
      output.writeMessage(12, getContactSettings());
    }
    if (pendingContactSettings_ != null) {
      output.writeMessage(13, getPendingContactSettings());
    }
    if (getSupportedPrivacyList().size() > 0) {
      output.writeUInt32NoTag(114);
      output.writeUInt32NoTag(supportedPrivacyMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedPrivacy_.size(); i++) {
      output.writeEnumNoTag(supportedPrivacy_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, domainName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getExpireTime());
    }
    if (state_
        != com.google.cloud.domains.v1alpha2.Registration.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < issues_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(issues_.get(i));
      }
      size += dataSize;
      if (!getIssuesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      issuesMemoizedSerializedSize = dataSize;
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (managementSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getManagementSettings());
    }
    if (dnsSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getDnsSettings());
    }
    if (contactSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getContactSettings());
    }
    if (pendingContactSettings_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getPendingContactSettings());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedPrivacy_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(supportedPrivacy_.get(i));
      }
      size += dataSize;
      if (!getSupportedPrivacyList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedPrivacyMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.Registration)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.Registration other =
        (com.google.cloud.domains.v1alpha2.Registration) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDomainName().equals(other.getDomainName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!issues_.equals(other.issues_)) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasManagementSettings() != other.hasManagementSettings()) return false;
    if (hasManagementSettings()) {
      if (!getManagementSettings().equals(other.getManagementSettings())) return false;
    }
    if (hasDnsSettings() != other.hasDnsSettings()) return false;
    if (hasDnsSettings()) {
      if (!getDnsSettings().equals(other.getDnsSettings())) return false;
    }
    if (hasContactSettings() != other.hasContactSettings()) return false;
    if (hasContactSettings()) {
      if (!getContactSettings().equals(other.getContactSettings())) return false;
    }
    if (hasPendingContactSettings() != other.hasPendingContactSettings()) return false;
    if (hasPendingContactSettings()) {
      if (!getPendingContactSettings().equals(other.getPendingContactSettings())) return false;
    }
    if (!supportedPrivacy_.equals(other.supportedPrivacy_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DOMAIN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDomainName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getIssuesCount() > 0) {
      hash = (37 * hash) + ISSUES_FIELD_NUMBER;
      hash = (53 * hash) + issues_.hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasManagementSettings()) {
      hash = (37 * hash) + MANAGEMENT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getManagementSettings().hashCode();
    }
    if (hasDnsSettings()) {
      hash = (37 * hash) + DNS_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getDnsSettings().hashCode();
    }
    if (hasContactSettings()) {
      hash = (37 * hash) + CONTACT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getContactSettings().hashCode();
    }
    if (hasPendingContactSettings()) {
      hash = (37 * hash) + PENDING_CONTACT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPendingContactSettings().hashCode();
    }
    if (getSupportedPrivacyCount() > 0) {
      hash = (37 * hash) + SUPPORTED_PRIVACY_FIELD_NUMBER;
      hash = (53 * hash) + supportedPrivacy_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.Registration parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.domains.v1alpha2.Registration prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `Registration` resource facilitates managing and configuring domain name
   * registrations.
   *
   * There are several ways to create a new `Registration` resource:
   *
   * To create a new `Registration` resource, find a suitable domain name by
   * calling the `SearchDomains` method with a query to see available domain name
   * options. After choosing a name, call `RetrieveRegisterParameters` to
   * ensure availability and obtain information like pricing, which is needed to
   * build a call to `RegisterDomain`.
   *
   * Another way to create a new `Registration` is to transfer an existing
   * domain from another registrar. First, go to the current registrar to unlock
   * the domain for transfer and retrieve the domain's transfer authorization
   * code. Then call `RetrieveTransferParameters` to confirm that the domain is
   * unlocked and to get values needed to build a call to `TransferDomain`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.Registration}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.Registration)
      com.google.cloud.domains.v1alpha2.RegistrationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_Registration_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_Registration_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.Registration.class,
              com.google.cloud.domains.v1alpha2.Registration.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.Registration.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      domainName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      state_ = 0;
      issues_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().clear();
      managementSettings_ = null;
      if (managementSettingsBuilder_ != null) {
        managementSettingsBuilder_.dispose();
        managementSettingsBuilder_ = null;
      }
      dnsSettings_ = null;
      if (dnsSettingsBuilder_ != null) {
        dnsSettingsBuilder_.dispose();
        dnsSettingsBuilder_ = null;
      }
      contactSettings_ = null;
      if (contactSettingsBuilder_ != null) {
        contactSettingsBuilder_.dispose();
        contactSettingsBuilder_ = null;
      }
      pendingContactSettings_ = null;
      if (pendingContactSettingsBuilder_ != null) {
        pendingContactSettingsBuilder_.dispose();
        pendingContactSettingsBuilder_ = null;
      }
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_Registration_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.Registration getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.Registration build() {
      com.google.cloud.domains.v1alpha2.Registration result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.Registration buildPartial() {
      com.google.cloud.domains.v1alpha2.Registration result =
          new com.google.cloud.domains.v1alpha2.Registration(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.domains.v1alpha2.Registration result) {
      if (((bitField0_ & 0x00000020) != 0)) {
        issues_ = java.util.Collections.unmodifiableList(issues_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.issues_ = issues_;
      if (((bitField0_ & 0x00000800) != 0)) {
        supportedPrivacy_ = java.util.Collections.unmodifiableList(supportedPrivacy_);
        bitField0_ = (bitField0_ & ~0x00000800);
      }
      result.supportedPrivacy_ = supportedPrivacy_;
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.Registration result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.domainName_ = domainName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.managementSettings_ =
            managementSettingsBuilder_ == null
                ? managementSettings_
                : managementSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.dnsSettings_ =
            dnsSettingsBuilder_ == null ? dnsSettings_ : dnsSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.contactSettings_ =
            contactSettingsBuilder_ == null ? contactSettings_ : contactSettingsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pendingContactSettings_ =
            pendingContactSettingsBuilder_ == null
                ? pendingContactSettings_
                : pendingContactSettingsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.Registration) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.Registration) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.Registration other) {
      if (other == com.google.cloud.domains.v1alpha2.Registration.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDomainName().isEmpty()) {
        domainName_ = other.domainName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.issues_.isEmpty()) {
        if (issues_.isEmpty()) {
          issues_ = other.issues_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureIssuesIsMutable();
          issues_.addAll(other.issues_);
        }
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasManagementSettings()) {
        mergeManagementSettings(other.getManagementSettings());
      }
      if (other.hasDnsSettings()) {
        mergeDnsSettings(other.getDnsSettings());
      }
      if (other.hasContactSettings()) {
        mergeContactSettings(other.getContactSettings());
      }
      if (other.hasPendingContactSettings()) {
        mergePendingContactSettings(other.getPendingContactSettings());
      }
      if (!other.supportedPrivacy_.isEmpty()) {
        if (supportedPrivacy_.isEmpty()) {
          supportedPrivacy_ = other.supportedPrivacy_;
          bitField0_ = (bitField0_ & ~0x00000800);
        } else {
          ensureSupportedPrivacyIsMutable();
          supportedPrivacy_.addAll(other.supportedPrivacy_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                domainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 56
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureIssuesIsMutable();
                issues_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureIssuesIsMutable();
                  issues_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getManagementSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getDnsSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getContactSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getPendingContactSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 112:
              {
                int tmpRaw = input.readEnum();
                ensureSupportedPrivacyIsMutable();
                supportedPrivacy_.add(tmpRaw);
                break;
              } // case 112
            case 114:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSupportedPrivacyIsMutable();
                  supportedPrivacy_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Registration` resource, in the format
     * `projects/&#42;&#47;locations/&#42;&#47;registrations/&lt;domain_name&gt;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object domainName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     * </pre>
     *
     * <code>
     * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The domainName.
     */
    public java.lang.String getDomainName() {
      java.lang.Object ref = domainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     * </pre>
     *
     * <code>
     * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The bytes for domainName.
     */
    public com.google.protobuf.ByteString getDomainNameBytes() {
      java.lang.Object ref = domainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     * </pre>
     *
     * <code>
     * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domainName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     * </pre>
     *
     * <code>
     * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainName() {
      domainName_ = getDefaultInstance().getDomainName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
     * </pre>
     *
     * <code>
     * string domain_name = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The bytes for domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domainName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the `Registration` resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The expiration timestamp of the `Registration`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the `Registration`
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `Registration`
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `Registration`
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.Registration.State getState() {
      com.google.cloud.domains.v1alpha2.Registration.State result =
          com.google.cloud.domains.v1alpha2.Registration.State.forNumber(state_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.Registration.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `Registration`
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.domains.v1alpha2.Registration.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the `Registration`
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.Registration.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> issues_ = java.util.Collections.emptyList();

    private void ensureIssuesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        issues_ = new java.util.ArrayList<java.lang.Integer>(issues_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the issues.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.Registration.Issue> getIssuesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.Registration.Issue>(
          issues_, issues_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of issues.
     */
    public int getIssuesCount() {
      return issues_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The issues at the given index.
     */
    public com.google.cloud.domains.v1alpha2.Registration.Issue getIssues(int index) {
      return issues_converter_.convert(issues_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The issues to set.
     * @return This builder for chaining.
     */
    public Builder setIssues(
        int index, com.google.cloud.domains.v1alpha2.Registration.Issue value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssuesIsMutable();
      issues_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The issues to add.
     * @return This builder for chaining.
     */
    public Builder addIssues(com.google.cloud.domains.v1alpha2.Registration.Issue value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssuesIsMutable();
      issues_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The issues to add.
     * @return This builder for chaining.
     */
    public Builder addAllIssues(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.Registration.Issue> values) {
      ensureIssuesIsMutable();
      for (com.google.cloud.domains.v1alpha2.Registration.Issue value : values) {
        issues_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssues() {
      issues_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for issues.
     */
    public java.util.List<java.lang.Integer> getIssuesValueList() {
      return java.util.Collections.unmodifiableList(issues_);
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of issues at the given index.
     */
    public int getIssuesValue(int index) {
      return issues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for issues to set.
     * @return This builder for chaining.
     */
    public Builder setIssuesValue(int index, int value) {
      ensureIssuesIsMutable();
      issues_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for issues to add.
     * @return This builder for chaining.
     */
    public Builder addIssuesValue(int value) {
      ensureIssuesIsMutable();
      issues_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The set of issues with the `Registration` that require attention.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.Registration.Issue issues = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for issues to add.
     * @return This builder for chaining.
     */
    public Builder addAllIssuesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureIssuesIsMutable();
      for (int value : values) {
        issues_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of labels associated with the `Registration`.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.domains.v1alpha2.ManagementSettings managementSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ManagementSettings,
            com.google.cloud.domains.v1alpha2.ManagementSettings.Builder,
            com.google.cloud.domains.v1alpha2.ManagementSettingsOrBuilder>
        managementSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     *
     * @return Whether the managementSettings field is set.
     */
    public boolean hasManagementSettings() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     *
     * @return The managementSettings.
     */
    public com.google.cloud.domains.v1alpha2.ManagementSettings getManagementSettings() {
      if (managementSettingsBuilder_ == null) {
        return managementSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ManagementSettings.getDefaultInstance()
            : managementSettings_;
      } else {
        return managementSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public Builder setManagementSettings(
        com.google.cloud.domains.v1alpha2.ManagementSettings value) {
      if (managementSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        managementSettings_ = value;
      } else {
        managementSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public Builder setManagementSettings(
        com.google.cloud.domains.v1alpha2.ManagementSettings.Builder builderForValue) {
      if (managementSettingsBuilder_ == null) {
        managementSettings_ = builderForValue.build();
      } else {
        managementSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public Builder mergeManagementSettings(
        com.google.cloud.domains.v1alpha2.ManagementSettings value) {
      if (managementSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && managementSettings_ != null
            && managementSettings_
                != com.google.cloud.domains.v1alpha2.ManagementSettings.getDefaultInstance()) {
          getManagementSettingsBuilder().mergeFrom(value);
        } else {
          managementSettings_ = value;
        }
      } else {
        managementSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public Builder clearManagementSettings() {
      bitField0_ = (bitField0_ & ~0x00000080);
      managementSettings_ = null;
      if (managementSettingsBuilder_ != null) {
        managementSettingsBuilder_.dispose();
        managementSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public com.google.cloud.domains.v1alpha2.ManagementSettings.Builder
        getManagementSettingsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getManagementSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    public com.google.cloud.domains.v1alpha2.ManagementSettingsOrBuilder
        getManagementSettingsOrBuilder() {
      if (managementSettingsBuilder_ != null) {
        return managementSettingsBuilder_.getMessageOrBuilder();
      } else {
        return managementSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ManagementSettings.getDefaultInstance()
            : managementSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for management of the `Registration`, including renewal, billing,
     * and transfer. You cannot update these with the `UpdateRegistration`
     * method. To update these settings, use the `ConfigureManagementSettings`
     * method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.ManagementSettings management_settings = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ManagementSettings,
            com.google.cloud.domains.v1alpha2.ManagementSettings.Builder,
            com.google.cloud.domains.v1alpha2.ManagementSettingsOrBuilder>
        getManagementSettingsFieldBuilder() {
      if (managementSettingsBuilder_ == null) {
        managementSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ManagementSettings,
                com.google.cloud.domains.v1alpha2.ManagementSettings.Builder,
                com.google.cloud.domains.v1alpha2.ManagementSettingsOrBuilder>(
                getManagementSettings(), getParentForChildren(), isClean());
        managementSettings_ = null;
      }
      return managementSettingsBuilder_;
    }

    private com.google.cloud.domains.v1alpha2.DnsSettings dnsSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings,
            com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>
        dnsSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     *
     * @return Whether the dnsSettings field is set.
     */
    public boolean hasDnsSettings() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     *
     * @return The dnsSettings.
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings getDnsSettings() {
      if (dnsSettingsBuilder_ == null) {
        return dnsSettings_ == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
            : dnsSettings_;
      } else {
        return dnsSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public Builder setDnsSettings(com.google.cloud.domains.v1alpha2.DnsSettings value) {
      if (dnsSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dnsSettings_ = value;
      } else {
        dnsSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public Builder setDnsSettings(
        com.google.cloud.domains.v1alpha2.DnsSettings.Builder builderForValue) {
      if (dnsSettingsBuilder_ == null) {
        dnsSettings_ = builderForValue.build();
      } else {
        dnsSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public Builder mergeDnsSettings(com.google.cloud.domains.v1alpha2.DnsSettings value) {
      if (dnsSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && dnsSettings_ != null
            && dnsSettings_ != com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()) {
          getDnsSettingsBuilder().mergeFrom(value);
        } else {
          dnsSettings_ = value;
        }
      } else {
        dnsSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public Builder clearDnsSettings() {
      bitField0_ = (bitField0_ & ~0x00000100);
      dnsSettings_ = null;
      if (dnsSettingsBuilder_ != null) {
        dnsSettingsBuilder_.dispose();
        dnsSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettings.Builder getDnsSettingsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getDnsSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    public com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder getDnsSettingsOrBuilder() {
      if (dnsSettingsBuilder_ != null) {
        return dnsSettingsBuilder_.getMessageOrBuilder();
      } else {
        return dnsSettings_ == null
            ? com.google.cloud.domains.v1alpha2.DnsSettings.getDefaultInstance()
            : dnsSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings controlling the DNS configuration of the `Registration`. You
     * cannot update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureDnsSettings` method.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.DnsSettings dns_settings = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.DnsSettings,
            com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
            com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>
        getDnsSettingsFieldBuilder() {
      if (dnsSettingsBuilder_ == null) {
        dnsSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.DnsSettings,
                com.google.cloud.domains.v1alpha2.DnsSettings.Builder,
                com.google.cloud.domains.v1alpha2.DnsSettingsOrBuilder>(
                getDnsSettings(), getParentForChildren(), isClean());
        dnsSettings_ = null;
      }
      return dnsSettingsBuilder_;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings contactSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        contactSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the contactSettings field is set.
     */
    public boolean hasContactSettings() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The contactSettings.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings getContactSettings() {
      if (contactSettingsBuilder_ == null) {
        return contactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : contactSettings_;
      } else {
        return contactSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContactSettings(com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (contactSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contactSettings_ = value;
      } else {
        contactSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setContactSettings(
        com.google.cloud.domains.v1alpha2.ContactSettings.Builder builderForValue) {
      if (contactSettingsBuilder_ == null) {
        contactSettings_ = builderForValue.build();
      } else {
        contactSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeContactSettings(com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (contactSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && contactSettings_ != null
            && contactSettings_
                != com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()) {
          getContactSettingsBuilder().mergeFrom(value);
        } else {
          contactSettings_ = value;
        }
      } else {
        contactSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearContactSettings() {
      bitField0_ = (bitField0_ & ~0x00000200);
      contactSettings_ = null;
      if (contactSettingsBuilder_ != null) {
        contactSettingsBuilder_.dispose();
        contactSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Builder getContactSettingsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getContactSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder
        getContactSettingsOrBuilder() {
      if (contactSettingsBuilder_ != null) {
        return contactSettingsBuilder_.getMessageOrBuilder();
      } else {
        return contactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : contactSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Settings for contact information linked to the `Registration`. You cannot
     * update these with the `UpdateRegistration` method. To update these
     * settings, use the `ConfigureContactSettings` method.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings contact_settings = 12 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        getContactSettingsFieldBuilder() {
      if (contactSettingsBuilder_ == null) {
        contactSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings,
                com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>(
                getContactSettings(), getParentForChildren(), isClean());
        contactSettings_ = null;
      }
      return contactSettingsBuilder_;
    }

    private com.google.cloud.domains.v1alpha2.ContactSettings pendingContactSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        pendingContactSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the pendingContactSettings field is set.
     */
    public boolean hasPendingContactSettings() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The pendingContactSettings.
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings getPendingContactSettings() {
      if (pendingContactSettingsBuilder_ == null) {
        return pendingContactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : pendingContactSettings_;
      } else {
        return pendingContactSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPendingContactSettings(
        com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (pendingContactSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pendingContactSettings_ = value;
      } else {
        pendingContactSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPendingContactSettings(
        com.google.cloud.domains.v1alpha2.ContactSettings.Builder builderForValue) {
      if (pendingContactSettingsBuilder_ == null) {
        pendingContactSettings_ = builderForValue.build();
      } else {
        pendingContactSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePendingContactSettings(
        com.google.cloud.domains.v1alpha2.ContactSettings value) {
      if (pendingContactSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && pendingContactSettings_ != null
            && pendingContactSettings_
                != com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()) {
          getPendingContactSettingsBuilder().mergeFrom(value);
        } else {
          pendingContactSettings_ = value;
        }
      } else {
        pendingContactSettingsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPendingContactSettings() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pendingContactSettings_ = null;
      if (pendingContactSettingsBuilder_ != null) {
        pendingContactSettingsBuilder_.dispose();
        pendingContactSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettings.Builder
        getPendingContactSettingsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPendingContactSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder
        getPendingContactSettingsOrBuilder() {
      if (pendingContactSettingsBuilder_ != null) {
        return pendingContactSettingsBuilder_.getMessageOrBuilder();
      } else {
        return pendingContactSettings_ == null
            ? com.google.cloud.domains.v1alpha2.ContactSettings.getDefaultInstance()
            : pendingContactSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Pending contact settings for the `Registration`. Updates to the
     * `contact_settings` field that change its `registrant_contact` or `privacy`
     * fields require email confirmation by the `registrant_contact`
     * before taking effect. This field is set only if there are pending updates
     * to the `contact_settings` that have not been confirmed. To confirm the
     * changes, the `registrant_contact` must follow the instructions in the
     * email they receive.
     * </pre>
     *
     * <code>
     * .google.cloud.domains.v1alpha2.ContactSettings pending_contact_settings = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.domains.v1alpha2.ContactSettings,
            com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
            com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>
        getPendingContactSettingsFieldBuilder() {
      if (pendingContactSettingsBuilder_ == null) {
        pendingContactSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.domains.v1alpha2.ContactSettings,
                com.google.cloud.domains.v1alpha2.ContactSettings.Builder,
                com.google.cloud.domains.v1alpha2.ContactSettingsOrBuilder>(
                getPendingContactSettings(), getParentForChildren(), isClean());
        pendingContactSettings_ = null;
      }
      return pendingContactSettingsBuilder_;
    }

    private java.util.List<java.lang.Integer> supportedPrivacy_ = java.util.Collections.emptyList();

    private void ensureSupportedPrivacyIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        supportedPrivacy_ = new java.util.ArrayList<java.lang.Integer>(supportedPrivacy_);
        bitField0_ |= 0x00000800;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the supportedPrivacy.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
        getSupportedPrivacyList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
          supportedPrivacy_, supportedPrivacy_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of supportedPrivacy.
     */
    public int getSupportedPrivacyCount() {
      return supportedPrivacy_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The supportedPrivacy at the given index.
     */
    public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
      return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacy(
        int index, com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacy(com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacy(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.ContactPrivacy> values) {
      ensureSupportedPrivacyIsMutable();
      for (com.google.cloud.domains.v1alpha2.ContactPrivacy value : values) {
        supportedPrivacy_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedPrivacy() {
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for supportedPrivacy.
     */
    public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
      return java.util.Collections.unmodifiableList(supportedPrivacy_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedPrivacy at the given index.
     */
    public int getSupportedPrivacyValue(int index) {
      return supportedPrivacy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacyValue(int index, int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacyValue(int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Set of options for the `contact_settings.privacy` field that this
     * `Registration` supports.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacyValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedPrivacyIsMutable();
      for (int value : values) {
        supportedPrivacy_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.Registration)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.Registration)
  private static final com.google.cloud.domains.v1alpha2.Registration DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.Registration();
  }

  public static com.google.cloud.domains.v1alpha2.Registration getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Registration> PARSER =
      new com.google.protobuf.AbstractParser<Registration>() {
        @java.lang.Override
        public Registration parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Registration> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Registration> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.Registration getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
