/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/domains/v1alpha2/domains.proto

package com.google.cloud.domains.v1alpha2;

/**
 *
 *
 * <pre>
 * Parameters required to transfer a domain from another registrar.
 * </pre>
 *
 * Protobuf type {@code google.cloud.domains.v1alpha2.TransferParameters}
 */
public final class TransferParameters extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.domains.v1alpha2.TransferParameters)
    TransferParametersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransferParameters.newBuilder() to construct.
  private TransferParameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransferParameters() {
    domainName_ = "";
    currentRegistrar_ = "";
    nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
    transferLockState_ = 0;
    supportedPrivacy_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransferParameters();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_TransferParameters_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.domains.v1alpha2.DomainsProto
        .internal_static_google_cloud_domains_v1alpha2_TransferParameters_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.domains.v1alpha2.TransferParameters.class,
            com.google.cloud.domains.v1alpha2.TransferParameters.Builder.class);
  }

  public static final int DOMAIN_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domainName_ = "";
  /**
   *
   *
   * <pre>
   * The domain name. Unicode domain names are expressed in Punycode format.
   * </pre>
   *
   * <code>string domain_name = 1;</code>
   *
   * @return The domainName.
   */
  @java.lang.Override
  public java.lang.String getDomainName() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domainName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The domain name. Unicode domain names are expressed in Punycode format.
   * </pre>
   *
   * <code>string domain_name = 1;</code>
   *
   * @return The bytes for domainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainNameBytes() {
    java.lang.Object ref = domainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_REGISTRAR_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object currentRegistrar_ = "";
  /**
   *
   *
   * <pre>
   * The registrar that currently manages the domain.
   * </pre>
   *
   * <code>string current_registrar = 2;</code>
   *
   * @return The currentRegistrar.
   */
  @java.lang.Override
  public java.lang.String getCurrentRegistrar() {
    java.lang.Object ref = currentRegistrar_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currentRegistrar_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The registrar that currently manages the domain.
   * </pre>
   *
   * <code>string current_registrar = 2;</code>
   *
   * @return The bytes for currentRegistrar.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCurrentRegistrarBytes() {
    java.lang.Object ref = currentRegistrar_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      currentRegistrar_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_SERVERS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList nameServers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The name servers that currently store the configuration of the domain.
   * </pre>
   *
   * <code>repeated string name_servers = 3;</code>
   *
   * @return A list containing the nameServers.
   */
  public com.google.protobuf.ProtocolStringList getNameServersList() {
    return nameServers_;
  }
  /**
   *
   *
   * <pre>
   * The name servers that currently store the configuration of the domain.
   * </pre>
   *
   * <code>repeated string name_servers = 3;</code>
   *
   * @return The count of nameServers.
   */
  public int getNameServersCount() {
    return nameServers_.size();
  }
  /**
   *
   *
   * <pre>
   * The name servers that currently store the configuration of the domain.
   * </pre>
   *
   * <code>repeated string name_servers = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The nameServers at the given index.
   */
  public java.lang.String getNameServers(int index) {
    return nameServers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The name servers that currently store the configuration of the domain.
   * </pre>
   *
   * <code>repeated string name_servers = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the nameServers at the given index.
   */
  public com.google.protobuf.ByteString getNameServersBytes(int index) {
    return nameServers_.getByteString(index);
  }

  public static final int TRANSFER_LOCK_STATE_FIELD_NUMBER = 4;
  private int transferLockState_ = 0;
  /**
   *
   *
   * <pre>
   * Indicates whether the domain is protected by a transfer lock. For a
   * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
   * go to its current registrar.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
   *
   * @return The enum numeric value on the wire for transferLockState.
   */
  @java.lang.Override
  public int getTransferLockStateValue() {
    return transferLockState_;
  }
  /**
   *
   *
   * <pre>
   * Indicates whether the domain is protected by a transfer lock. For a
   * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
   * go to its current registrar.
   * </pre>
   *
   * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
   *
   * @return The transferLockState.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.TransferLockState getTransferLockState() {
    com.google.cloud.domains.v1alpha2.TransferLockState result =
        com.google.cloud.domains.v1alpha2.TransferLockState.forNumber(transferLockState_);
    return result == null
        ? com.google.cloud.domains.v1alpha2.TransferLockState.UNRECOGNIZED
        : result;
  }

  public static final int SUPPORTED_PRIVACY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> supportedPrivacy_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>
      supportedPrivacy_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>() {
            public com.google.cloud.domains.v1alpha2.ContactPrivacy convert(
                java.lang.Integer from) {
              com.google.cloud.domains.v1alpha2.ContactPrivacy result =
                  com.google.cloud.domains.v1alpha2.ContactPrivacy.forNumber(from);
              return result == null
                  ? com.google.cloud.domains.v1alpha2.ContactPrivacy.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
   *
   * @return A list containing the supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
      getSupportedPrivacyList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
        supportedPrivacy_, supportedPrivacy_converter_);
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
   *
   * @return The count of supportedPrivacy.
   */
  @java.lang.Override
  public int getSupportedPrivacyCount() {
    return supportedPrivacy_.size();
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedPrivacy at the given index.
   */
  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
    return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
   *
   * @return A list containing the enum numeric values on the wire for supportedPrivacy.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
    return supportedPrivacy_;
  }
  /**
   *
   *
   * <pre>
   * Contact privacy options that the domain supports.
   * </pre>
   *
   * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedPrivacy at the given index.
   */
  @java.lang.Override
  public int getSupportedPrivacyValue(int index) {
    return supportedPrivacy_.get(index);
  }

  private int supportedPrivacyMemoizedSerializedSize;

  public static final int YEARLY_PRICE_FIELD_NUMBER = 6;
  private com.google.type.Money yearlyPrice_;
  /**
   *
   *
   * <pre>
   * Price to transfer or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 6;</code>
   *
   * @return Whether the yearlyPrice field is set.
   */
  @java.lang.Override
  public boolean hasYearlyPrice() {
    return yearlyPrice_ != null;
  }
  /**
   *
   *
   * <pre>
   * Price to transfer or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 6;</code>
   *
   * @return The yearlyPrice.
   */
  @java.lang.Override
  public com.google.type.Money getYearlyPrice() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }
  /**
   *
   *
   * <pre>
   * Price to transfer or renew the domain for one year.
   * </pre>
   *
   * <code>.google.type.Money yearly_price = 6;</code>
   */
  @java.lang.Override
  public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
    return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domainName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentRegistrar_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, currentRegistrar_);
    }
    for (int i = 0; i < nameServers_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nameServers_.getRaw(i));
    }
    if (transferLockState_
        != com.google.cloud.domains.v1alpha2.TransferLockState.TRANSFER_LOCK_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, transferLockState_);
    }
    if (getSupportedPrivacyList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(supportedPrivacyMemoizedSerializedSize);
    }
    for (int i = 0; i < supportedPrivacy_.size(); i++) {
      output.writeEnumNoTag(supportedPrivacy_.get(i));
    }
    if (yearlyPrice_ != null) {
      output.writeMessage(6, getYearlyPrice());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domainName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domainName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(currentRegistrar_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, currentRegistrar_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < nameServers_.size(); i++) {
        dataSize += computeStringSizeNoTag(nameServers_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNameServersList().size();
    }
    if (transferLockState_
        != com.google.cloud.domains.v1alpha2.TransferLockState.TRANSFER_LOCK_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, transferLockState_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedPrivacy_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(supportedPrivacy_.get(i));
      }
      size += dataSize;
      if (!getSupportedPrivacyList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      supportedPrivacyMemoizedSerializedSize = dataSize;
    }
    if (yearlyPrice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getYearlyPrice());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.domains.v1alpha2.TransferParameters)) {
      return super.equals(obj);
    }
    com.google.cloud.domains.v1alpha2.TransferParameters other =
        (com.google.cloud.domains.v1alpha2.TransferParameters) obj;

    if (!getDomainName().equals(other.getDomainName())) return false;
    if (!getCurrentRegistrar().equals(other.getCurrentRegistrar())) return false;
    if (!getNameServersList().equals(other.getNameServersList())) return false;
    if (transferLockState_ != other.transferLockState_) return false;
    if (!supportedPrivacy_.equals(other.supportedPrivacy_)) return false;
    if (hasYearlyPrice() != other.hasYearlyPrice()) return false;
    if (hasYearlyPrice()) {
      if (!getYearlyPrice().equals(other.getYearlyPrice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DOMAIN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDomainName().hashCode();
    hash = (37 * hash) + CURRENT_REGISTRAR_FIELD_NUMBER;
    hash = (53 * hash) + getCurrentRegistrar().hashCode();
    if (getNameServersCount() > 0) {
      hash = (37 * hash) + NAME_SERVERS_FIELD_NUMBER;
      hash = (53 * hash) + getNameServersList().hashCode();
    }
    hash = (37 * hash) + TRANSFER_LOCK_STATE_FIELD_NUMBER;
    hash = (53 * hash) + transferLockState_;
    if (getSupportedPrivacyCount() > 0) {
      hash = (37 * hash) + SUPPORTED_PRIVACY_FIELD_NUMBER;
      hash = (53 * hash) + supportedPrivacy_.hashCode();
    }
    if (hasYearlyPrice()) {
      hash = (37 * hash) + YEARLY_PRICE_FIELD_NUMBER;
      hash = (53 * hash) + getYearlyPrice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.domains.v1alpha2.TransferParameters prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters required to transfer a domain from another registrar.
   * </pre>
   *
   * Protobuf type {@code google.cloud.domains.v1alpha2.TransferParameters}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.domains.v1alpha2.TransferParameters)
      com.google.cloud.domains.v1alpha2.TransferParametersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_TransferParameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_TransferParameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.domains.v1alpha2.TransferParameters.class,
              com.google.cloud.domains.v1alpha2.TransferParameters.Builder.class);
    }

    // Construct using com.google.cloud.domains.v1alpha2.TransferParameters.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      domainName_ = "";
      currentRegistrar_ = "";
      nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      transferLockState_ = 0;
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.domains.v1alpha2.DomainsProto
          .internal_static_google_cloud_domains_v1alpha2_TransferParameters_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.TransferParameters getDefaultInstanceForType() {
      return com.google.cloud.domains.v1alpha2.TransferParameters.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.TransferParameters build() {
      com.google.cloud.domains.v1alpha2.TransferParameters result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.TransferParameters buildPartial() {
      com.google.cloud.domains.v1alpha2.TransferParameters result =
          new com.google.cloud.domains.v1alpha2.TransferParameters(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.domains.v1alpha2.TransferParameters result) {
      if (((bitField0_ & 0x00000010) != 0)) {
        supportedPrivacy_ = java.util.Collections.unmodifiableList(supportedPrivacy_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.supportedPrivacy_ = supportedPrivacy_;
    }

    private void buildPartial0(com.google.cloud.domains.v1alpha2.TransferParameters result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.domainName_ = domainName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.currentRegistrar_ = currentRegistrar_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        nameServers_.makeImmutable();
        result.nameServers_ = nameServers_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.transferLockState_ = transferLockState_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.yearlyPrice_ =
            yearlyPriceBuilder_ == null ? yearlyPrice_ : yearlyPriceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.domains.v1alpha2.TransferParameters) {
        return mergeFrom((com.google.cloud.domains.v1alpha2.TransferParameters) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.domains.v1alpha2.TransferParameters other) {
      if (other == com.google.cloud.domains.v1alpha2.TransferParameters.getDefaultInstance())
        return this;
      if (!other.getDomainName().isEmpty()) {
        domainName_ = other.domainName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCurrentRegistrar().isEmpty()) {
        currentRegistrar_ = other.currentRegistrar_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.nameServers_.isEmpty()) {
        if (nameServers_.isEmpty()) {
          nameServers_ = other.nameServers_;
          bitField0_ |= 0x00000004;
        } else {
          ensureNameServersIsMutable();
          nameServers_.addAll(other.nameServers_);
        }
        onChanged();
      }
      if (other.transferLockState_ != 0) {
        setTransferLockStateValue(other.getTransferLockStateValue());
      }
      if (!other.supportedPrivacy_.isEmpty()) {
        if (supportedPrivacy_.isEmpty()) {
          supportedPrivacy_ = other.supportedPrivacy_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureSupportedPrivacyIsMutable();
          supportedPrivacy_.addAll(other.supportedPrivacy_);
        }
        onChanged();
      }
      if (other.hasYearlyPrice()) {
        mergeYearlyPrice(other.getYearlyPrice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                domainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                currentRegistrar_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNameServersIsMutable();
                nameServers_.add(s);
                break;
              } // case 26
            case 32:
              {
                transferLockState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                int tmpRaw = input.readEnum();
                ensureSupportedPrivacyIsMutable();
                supportedPrivacy_.add(tmpRaw);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSupportedPrivacyIsMutable();
                  supportedPrivacy_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getYearlyPriceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object domainName_ = "";
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return The domainName.
     */
    public java.lang.String getDomainName() {
      java.lang.Object ref = domainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return The bytes for domainName.
     */
    public com.google.protobuf.ByteString getDomainNameBytes() {
      java.lang.Object ref = domainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @param value The domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomainName() {
      domainName_ = getDefaultInstance().getDomainName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The domain name. Unicode domain names are expressed in Punycode format.
     * </pre>
     *
     * <code>string domain_name = 1;</code>
     *
     * @param value The bytes for domainName to set.
     * @return This builder for chaining.
     */
    public Builder setDomainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object currentRegistrar_ = "";
    /**
     *
     *
     * <pre>
     * The registrar that currently manages the domain.
     * </pre>
     *
     * <code>string current_registrar = 2;</code>
     *
     * @return The currentRegistrar.
     */
    public java.lang.String getCurrentRegistrar() {
      java.lang.Object ref = currentRegistrar_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currentRegistrar_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The registrar that currently manages the domain.
     * </pre>
     *
     * <code>string current_registrar = 2;</code>
     *
     * @return The bytes for currentRegistrar.
     */
    public com.google.protobuf.ByteString getCurrentRegistrarBytes() {
      java.lang.Object ref = currentRegistrar_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentRegistrar_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The registrar that currently manages the domain.
     * </pre>
     *
     * <code>string current_registrar = 2;</code>
     *
     * @param value The currentRegistrar to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentRegistrar(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      currentRegistrar_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The registrar that currently manages the domain.
     * </pre>
     *
     * <code>string current_registrar = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentRegistrar() {
      currentRegistrar_ = getDefaultInstance().getCurrentRegistrar();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The registrar that currently manages the domain.
     * </pre>
     *
     * <code>string current_registrar = 2;</code>
     *
     * @param value The bytes for currentRegistrar to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentRegistrarBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      currentRegistrar_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList nameServers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNameServersIsMutable() {
      if (!nameServers_.isModifiable()) {
        nameServers_ = new com.google.protobuf.LazyStringArrayList(nameServers_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @return A list containing the nameServers.
     */
    public com.google.protobuf.ProtocolStringList getNameServersList() {
      nameServers_.makeImmutable();
      return nameServers_;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @return The count of nameServers.
     */
    public int getNameServersCount() {
      return nameServers_.size();
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The nameServers at the given index.
     */
    public java.lang.String getNameServers(int index) {
      return nameServers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the nameServers at the given index.
     */
    public com.google.protobuf.ByteString getNameServersBytes(int index) {
      return nameServers_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The nameServers to set.
     * @return This builder for chaining.
     */
    public Builder setNameServers(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNameServersIsMutable();
      nameServers_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param value The nameServers to add.
     * @return This builder for chaining.
     */
    public Builder addNameServers(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNameServersIsMutable();
      nameServers_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param values The nameServers to add.
     * @return This builder for chaining.
     */
    public Builder addAllNameServers(java.lang.Iterable<java.lang.String> values) {
      ensureNameServersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nameServers_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNameServers() {
      nameServers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name servers that currently store the configuration of the domain.
     * </pre>
     *
     * <code>repeated string name_servers = 3;</code>
     *
     * @param value The bytes of the nameServers to add.
     * @return This builder for chaining.
     */
    public Builder addNameServersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNameServersIsMutable();
      nameServers_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int transferLockState_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is protected by a transfer lock. For a
     * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
     * go to its current registrar.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
     *
     * @return The enum numeric value on the wire for transferLockState.
     */
    @java.lang.Override
    public int getTransferLockStateValue() {
      return transferLockState_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is protected by a transfer lock. For a
     * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
     * go to its current registrar.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
     *
     * @param value The enum numeric value on the wire for transferLockState to set.
     * @return This builder for chaining.
     */
    public Builder setTransferLockStateValue(int value) {
      transferLockState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is protected by a transfer lock. For a
     * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
     * go to its current registrar.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
     *
     * @return The transferLockState.
     */
    @java.lang.Override
    public com.google.cloud.domains.v1alpha2.TransferLockState getTransferLockState() {
      com.google.cloud.domains.v1alpha2.TransferLockState result =
          com.google.cloud.domains.v1alpha2.TransferLockState.forNumber(transferLockState_);
      return result == null
          ? com.google.cloud.domains.v1alpha2.TransferLockState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is protected by a transfer lock. For a
     * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
     * go to its current registrar.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
     *
     * @param value The transferLockState to set.
     * @return This builder for chaining.
     */
    public Builder setTransferLockState(com.google.cloud.domains.v1alpha2.TransferLockState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      transferLockState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the domain is protected by a transfer lock. For a
     * transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
     * go to its current registrar.
     * </pre>
     *
     * <code>.google.cloud.domains.v1alpha2.TransferLockState transfer_lock_state = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransferLockState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      transferLockState_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> supportedPrivacy_ = java.util.Collections.emptyList();

    private void ensureSupportedPrivacyIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        supportedPrivacy_ = new java.util.ArrayList<java.lang.Integer>(supportedPrivacy_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @return A list containing the supportedPrivacy.
     */
    public java.util.List<com.google.cloud.domains.v1alpha2.ContactPrivacy>
        getSupportedPrivacyList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.domains.v1alpha2.ContactPrivacy>(
          supportedPrivacy_, supportedPrivacy_converter_);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @return The count of supportedPrivacy.
     */
    public int getSupportedPrivacyCount() {
      return supportedPrivacy_.size();
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedPrivacy at the given index.
     */
    public com.google.cloud.domains.v1alpha2.ContactPrivacy getSupportedPrivacy(int index) {
      return supportedPrivacy_converter_.convert(supportedPrivacy_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacy(
        int index, com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param value The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacy(com.google.cloud.domains.v1alpha2.ContactPrivacy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param values The supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacy(
        java.lang.Iterable<? extends com.google.cloud.domains.v1alpha2.ContactPrivacy> values) {
      ensureSupportedPrivacyIsMutable();
      for (com.google.cloud.domains.v1alpha2.ContactPrivacy value : values) {
        supportedPrivacy_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedPrivacy() {
      supportedPrivacy_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @return A list containing the enum numeric values on the wire for supportedPrivacy.
     */
    public java.util.List<java.lang.Integer> getSupportedPrivacyValueList() {
      return java.util.Collections.unmodifiableList(supportedPrivacy_);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of supportedPrivacy at the given index.
     */
    public int getSupportedPrivacyValue(int index) {
      return supportedPrivacy_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for supportedPrivacy to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedPrivacyValue(int index, int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param value The enum numeric value on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedPrivacyValue(int value) {
      ensureSupportedPrivacyIsMutable();
      supportedPrivacy_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Contact privacy options that the domain supports.
     * </pre>
     *
     * <code>repeated .google.cloud.domains.v1alpha2.ContactPrivacy supported_privacy = 5;</code>
     *
     * @param values The enum numeric values on the wire for supportedPrivacy to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedPrivacyValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSupportedPrivacyIsMutable();
      for (int value : values) {
        supportedPrivacy_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.type.Money yearlyPrice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        yearlyPriceBuilder_;
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     *
     * @return Whether the yearlyPrice field is set.
     */
    public boolean hasYearlyPrice() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     *
     * @return The yearlyPrice.
     */
    public com.google.type.Money getYearlyPrice() {
      if (yearlyPriceBuilder_ == null) {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      } else {
        return yearlyPriceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public Builder setYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        yearlyPrice_ = value;
      } else {
        yearlyPriceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public Builder setYearlyPrice(com.google.type.Money.Builder builderForValue) {
      if (yearlyPriceBuilder_ == null) {
        yearlyPrice_ = builderForValue.build();
      } else {
        yearlyPriceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public Builder mergeYearlyPrice(com.google.type.Money value) {
      if (yearlyPriceBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && yearlyPrice_ != null
            && yearlyPrice_ != com.google.type.Money.getDefaultInstance()) {
          getYearlyPriceBuilder().mergeFrom(value);
        } else {
          yearlyPrice_ = value;
        }
      } else {
        yearlyPriceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public Builder clearYearlyPrice() {
      bitField0_ = (bitField0_ & ~0x00000020);
      yearlyPrice_ = null;
      if (yearlyPriceBuilder_ != null) {
        yearlyPriceBuilder_.dispose();
        yearlyPriceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public com.google.type.Money.Builder getYearlyPriceBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getYearlyPriceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    public com.google.type.MoneyOrBuilder getYearlyPriceOrBuilder() {
      if (yearlyPriceBuilder_ != null) {
        return yearlyPriceBuilder_.getMessageOrBuilder();
      } else {
        return yearlyPrice_ == null ? com.google.type.Money.getDefaultInstance() : yearlyPrice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Price to transfer or renew the domain for one year.
     * </pre>
     *
     * <code>.google.type.Money yearly_price = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Money, com.google.type.Money.Builder, com.google.type.MoneyOrBuilder>
        getYearlyPriceFieldBuilder() {
      if (yearlyPriceBuilder_ == null) {
        yearlyPriceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Money,
                com.google.type.Money.Builder,
                com.google.type.MoneyOrBuilder>(
                getYearlyPrice(), getParentForChildren(), isClean());
        yearlyPrice_ = null;
      }
      return yearlyPriceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.domains.v1alpha2.TransferParameters)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.domains.v1alpha2.TransferParameters)
  private static final com.google.cloud.domains.v1alpha2.TransferParameters DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.domains.v1alpha2.TransferParameters();
  }

  public static com.google.cloud.domains.v1alpha2.TransferParameters getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransferParameters> PARSER =
      new com.google.protobuf.AbstractParser<TransferParameters>() {
        @java.lang.Override
        public TransferParameters parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransferParameters> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransferParameters> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.domains.v1alpha2.TransferParameters getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
