/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ZoneName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ZONE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/zones/{zone}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String zone;

    @Deprecated
    protected ZoneName() {
        this.project = null;
        this.location = null;
        this.zone = null;
    }

    private ZoneName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getZone() {
        return this.zone;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ZoneName of(String project, String location, String zone) {
        return ZoneName.newBuilder().setProject(project).setLocation(location).setZone(zone).build();
    }

    public static String format(String project, String location, String zone) {
        return ZoneName.newBuilder().setProject(project).setLocation(location).setZone(zone).build().toString();
    }

    public static ZoneName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ZONE.validatedMatch(formattedString, "ZoneName.parse: formattedString not in valid format");
        return ZoneName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("zone"));
    }

    public static List<ZoneName> parseList(List<String> formattedStrings) {
        ArrayList<ZoneName> list = new ArrayList<ZoneName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ZoneName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ZoneName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ZoneName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ZONE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ZoneName zoneName = this;
            synchronized (zoneName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ZONE.instantiate(new String[]{"project", this.project, "location", this.location, "zone", this.zone});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ZoneName that = (ZoneName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.zone, that.zone);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.zone);
    }

    public static class Builder {
        private String project;
        private String location;
        private String zone;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getZone() {
            return this.zone;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        private Builder(ZoneName zoneName) {
            this.project = zoneName.project;
            this.location = zoneName.location;
            this.zone = zoneName.zone;
        }

        public ZoneName build() {
            return new ZoneName(this);
        }
    }
}

