/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InterconnectAttachmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ZONE_INTERCONNECT_ATTACHMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/zones/{zone}/interconnectAttachments/{interconnect_attachment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String zone;
    private final String interconnectAttachment;

    @Deprecated
    protected InterconnectAttachmentName() {
        this.project = null;
        this.location = null;
        this.zone = null;
        this.interconnectAttachment = null;
    }

    private InterconnectAttachmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.zone = (String)Preconditions.checkNotNull((Object)builder.getZone());
        this.interconnectAttachment = (String)Preconditions.checkNotNull((Object)builder.getInterconnectAttachment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getZone() {
        return this.zone;
    }

    public String getInterconnectAttachment() {
        return this.interconnectAttachment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InterconnectAttachmentName of(String project, String location, String zone, String interconnectAttachment) {
        return InterconnectAttachmentName.newBuilder().setProject(project).setLocation(location).setZone(zone).setInterconnectAttachment(interconnectAttachment).build();
    }

    public static String format(String project, String location, String zone, String interconnectAttachment) {
        return InterconnectAttachmentName.newBuilder().setProject(project).setLocation(location).setZone(zone).setInterconnectAttachment(interconnectAttachment).build().toString();
    }

    public static InterconnectAttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ZONE_INTERCONNECT_ATTACHMENT.validatedMatch(formattedString, "InterconnectAttachmentName.parse: formattedString not in valid format");
        return InterconnectAttachmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("zone"), (String)matchMap.get("interconnect_attachment"));
    }

    public static List<InterconnectAttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<InterconnectAttachmentName> list = new ArrayList<InterconnectAttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InterconnectAttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InterconnectAttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InterconnectAttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ZONE_INTERCONNECT_ATTACHMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InterconnectAttachmentName interconnectAttachmentName = this;
            synchronized (interconnectAttachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.zone != null) {
                        fieldMapBuilder.put((Object)"zone", (Object)this.zone);
                    }
                    if (this.interconnectAttachment != null) {
                        fieldMapBuilder.put((Object)"interconnect_attachment", (Object)this.interconnectAttachment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ZONE_INTERCONNECT_ATTACHMENT.instantiate(new String[]{"project", this.project, "location", this.location, "zone", this.zone, "interconnect_attachment", this.interconnectAttachment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InterconnectAttachmentName that = (InterconnectAttachmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.zone, that.zone) && Objects.equals(this.interconnectAttachment, that.interconnectAttachment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.zone);
        h *= 1000003;
        return h ^= Objects.hashCode(this.interconnectAttachment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String zone;
        private String interconnectAttachment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getZone() {
            return this.zone;
        }

        public String getInterconnectAttachment() {
            return this.interconnectAttachment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder setInterconnectAttachment(String interconnectAttachment) {
            this.interconnectAttachment = interconnectAttachment;
            return this;
        }

        private Builder(InterconnectAttachmentName interconnectAttachmentName) {
            this.project = interconnectAttachmentName.project;
            this.location = interconnectAttachmentName.location;
            this.zone = interconnectAttachmentName.zone;
            this.interconnectAttachment = interconnectAttachmentName.interconnectAttachment;
        }

        public InterconnectAttachmentName build() {
            return new InterconnectAttachmentName(this);
        }
    }
}

