/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/enterpriseknowledgegraph/v1/service.proto

package com.google.cloud.enterpriseknowledgegraph.v1;

/**
 *
 *
 * <pre>
 * The desired input location and metadata.
 * </pre>
 *
 * Protobuf type {@code google.cloud.enterpriseknowledgegraph.v1.InputConfig}
 */
public final class InputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.enterpriseknowledgegraph.v1.InputConfig)
    InputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InputConfig.newBuilder() to construct.
  private InputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InputConfig() {
    bigqueryInputConfigs_ = java.util.Collections.emptyList();
    entityType_ = 0;
    previousResultBigqueryTable_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
        .internal_static_google_cloud_enterpriseknowledgegraph_v1_InputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
        .internal_static_google_cloud_enterpriseknowledgegraph_v1_InputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.class,
            com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of entities we will support. Currently, we only support people,
   * establishment, property, and product types. If the type is
   * unspecified, it will be generic type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType}
   */
  public enum EntityType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value.
     * </pre>
     *
     * <code>ENTITY_TYPE_UNSPECIFIED = 0;</code>
     */
    ENTITY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * People entity.
     * </pre>
     *
     * <code>PEOPLE = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    PEOPLE(1),
    /**
     *
     *
     * <pre>
     * Establishment entity.
     * </pre>
     *
     * <code>ESTABLISHMENT = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    ESTABLISHMENT(2),
    /**
     *
     *
     * <pre>
     * Property entity. e.g. real estate property.
     * </pre>
     *
     * <code>PROPERTY = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    PROPERTY(3),
    /**
     *
     *
     * <pre>
     * Product entity.
     * </pre>
     *
     * <code>PRODUCT = 4;</code>
     */
    PRODUCT(4),
    /**
     *
     *
     * <pre>
     * Organization entity.
     * </pre>
     *
     * <code>ORGANIZATION = 5;</code>
     */
    ORGANIZATION(5),
    /**
     *
     *
     * <pre>
     * Local Business entity.
     * </pre>
     *
     * <code>LOCAL_BUSINESS = 6;</code>
     */
    LOCAL_BUSINESS(6),
    /**
     *
     *
     * <pre>
     * Person entity.
     * </pre>
     *
     * <code>PERSON = 7;</code>
     */
    PERSON(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value.
     * </pre>
     *
     * <code>ENTITY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ENTITY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * People entity.
     * </pre>
     *
     * <code>PEOPLE = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int PEOPLE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Establishment entity.
     * </pre>
     *
     * <code>ESTABLISHMENT = 2 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int ESTABLISHMENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Property entity. e.g. real estate property.
     * </pre>
     *
     * <code>PROPERTY = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int PROPERTY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Product entity.
     * </pre>
     *
     * <code>PRODUCT = 4;</code>
     */
    public static final int PRODUCT_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Organization entity.
     * </pre>
     *
     * <code>ORGANIZATION = 5;</code>
     */
    public static final int ORGANIZATION_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Local Business entity.
     * </pre>
     *
     * <code>LOCAL_BUSINESS = 6;</code>
     */
    public static final int LOCAL_BUSINESS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Person entity.
     * </pre>
     *
     * <code>PERSON = 7;</code>
     */
    public static final int PERSON_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntityType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EntityType forNumber(int value) {
      switch (value) {
        case 0:
          return ENTITY_TYPE_UNSPECIFIED;
        case 1:
          return PEOPLE;
        case 2:
          return ESTABLISHMENT;
        case 3:
          return PROPERTY;
        case 4:
          return PRODUCT;
        case 5:
          return ORGANIZATION;
        case 6:
          return LOCAL_BUSINESS;
        case 7:
          return PERSON;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EntityType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EntityType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EntityType>() {
          public EntityType findValueByNumber(int number) {
            return EntityType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EntityType[] VALUES = values();

    public static EntityType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EntityType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType)
  }

  public static final int BIGQUERY_INPUT_CONFIGS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>
      bigqueryInputConfigs_;
  /**
   *
   *
   * <pre>
   * Set of input BigQuery tables.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>
      getBigqueryInputConfigsList() {
    return bigqueryInputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Set of input BigQuery tables.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder>
      getBigqueryInputConfigsOrBuilderList() {
    return bigqueryInputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Set of input BigQuery tables.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
   * </code>
   */
  @java.lang.Override
  public int getBigqueryInputConfigsCount() {
    return bigqueryInputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of input BigQuery tables.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig getBigqueryInputConfigs(
      int index) {
    return bigqueryInputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of input BigQuery tables.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder
      getBigqueryInputConfigsOrBuilder(int index) {
    return bigqueryInputConfigs_.get(index);
  }

  public static final int ENTITY_TYPE_FIELD_NUMBER = 2;
  private int entityType_ = 0;
  /**
   *
   *
   * <pre>
   * Entity type
   * </pre>
   *
   * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;</code>
   *
   * @return The enum numeric value on the wire for entityType.
   */
  @java.lang.Override
  public int getEntityTypeValue() {
    return entityType_;
  }
  /**
   *
   *
   * <pre>
   * Entity type
   * </pre>
   *
   * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;</code>
   *
   * @return The entityType.
   */
  @java.lang.Override
  public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType getEntityType() {
    com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType result =
        com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType.forNumber(entityType_);
    return result == null
        ? com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType.UNRECOGNIZED
        : result;
  }

  public static final int PREVIOUS_RESULT_BIGQUERY_TABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object previousResultBigqueryTable_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Provide the bigquery table containing the previous results if
   * cluster ID stability is desired. Format is
   * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
   * </pre>
   *
   * <code>
   * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The previousResultBigqueryTable.
   */
  @java.lang.Override
  public java.lang.String getPreviousResultBigqueryTable() {
    java.lang.Object ref = previousResultBigqueryTable_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      previousResultBigqueryTable_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Provide the bigquery table containing the previous results if
   * cluster ID stability is desired. Format is
   * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
   * </pre>
   *
   * <code>
   * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for previousResultBigqueryTable.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreviousResultBigqueryTableBytes() {
    java.lang.Object ref = previousResultBigqueryTable_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      previousResultBigqueryTable_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < bigqueryInputConfigs_.size(); i++) {
      output.writeMessage(1, bigqueryInputConfigs_.get(i));
    }
    if (entityType_
        != com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType
            .ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, entityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousResultBigqueryTable_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, previousResultBigqueryTable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < bigqueryInputConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, bigqueryInputConfigs_.get(i));
    }
    if (entityType_
        != com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType
            .ENTITY_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, entityType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(previousResultBigqueryTable_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, previousResultBigqueryTable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.enterpriseknowledgegraph.v1.InputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.enterpriseknowledgegraph.v1.InputConfig other =
        (com.google.cloud.enterpriseknowledgegraph.v1.InputConfig) obj;

    if (!getBigqueryInputConfigsList().equals(other.getBigqueryInputConfigsList())) return false;
    if (entityType_ != other.entityType_) return false;
    if (!getPreviousResultBigqueryTable().equals(other.getPreviousResultBigqueryTable()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBigqueryInputConfigsCount() > 0) {
      hash = (37 * hash) + BIGQUERY_INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryInputConfigsList().hashCode();
    }
    hash = (37 * hash) + ENTITY_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + entityType_;
    hash = (37 * hash) + PREVIOUS_RESULT_BIGQUERY_TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getPreviousResultBigqueryTable().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.enterpriseknowledgegraph.v1.InputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The desired input location and metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.enterpriseknowledgegraph.v1.InputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.enterpriseknowledgegraph.v1.InputConfig)
      com.google.cloud.enterpriseknowledgegraph.v1.InputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_InputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_InputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.class,
              com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.Builder.class);
    }

    // Construct using com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigqueryInputConfigsBuilder_ == null) {
        bigqueryInputConfigs_ = java.util.Collections.emptyList();
      } else {
        bigqueryInputConfigs_ = null;
        bigqueryInputConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      entityType_ = 0;
      previousResultBigqueryTable_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_InputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig getDefaultInstanceForType() {
      return com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig build() {
      com.google.cloud.enterpriseknowledgegraph.v1.InputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig buildPartial() {
      com.google.cloud.enterpriseknowledgegraph.v1.InputConfig result =
          new com.google.cloud.enterpriseknowledgegraph.v1.InputConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.enterpriseknowledgegraph.v1.InputConfig result) {
      if (bigqueryInputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          bigqueryInputConfigs_ = java.util.Collections.unmodifiableList(bigqueryInputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.bigqueryInputConfigs_ = bigqueryInputConfigs_;
      } else {
        result.bigqueryInputConfigs_ = bigqueryInputConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.enterpriseknowledgegraph.v1.InputConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.entityType_ = entityType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.previousResultBigqueryTable_ = previousResultBigqueryTable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.enterpriseknowledgegraph.v1.InputConfig) {
        return mergeFrom((com.google.cloud.enterpriseknowledgegraph.v1.InputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.enterpriseknowledgegraph.v1.InputConfig other) {
      if (other == com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.getDefaultInstance())
        return this;
      if (bigqueryInputConfigsBuilder_ == null) {
        if (!other.bigqueryInputConfigs_.isEmpty()) {
          if (bigqueryInputConfigs_.isEmpty()) {
            bigqueryInputConfigs_ = other.bigqueryInputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBigqueryInputConfigsIsMutable();
            bigqueryInputConfigs_.addAll(other.bigqueryInputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.bigqueryInputConfigs_.isEmpty()) {
          if (bigqueryInputConfigsBuilder_.isEmpty()) {
            bigqueryInputConfigsBuilder_.dispose();
            bigqueryInputConfigsBuilder_ = null;
            bigqueryInputConfigs_ = other.bigqueryInputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            bigqueryInputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBigqueryInputConfigsFieldBuilder()
                    : null;
          } else {
            bigqueryInputConfigsBuilder_.addAllMessages(other.bigqueryInputConfigs_);
          }
        }
      }
      if (other.entityType_ != 0) {
        setEntityTypeValue(other.getEntityTypeValue());
      }
      if (!other.getPreviousResultBigqueryTable().isEmpty()) {
        previousResultBigqueryTable_ = other.previousResultBigqueryTable_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig m =
                    input.readMessage(
                        com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.parser(),
                        extensionRegistry);
                if (bigqueryInputConfigsBuilder_ == null) {
                  ensureBigqueryInputConfigsIsMutable();
                  bigqueryInputConfigs_.add(m);
                } else {
                  bigqueryInputConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                entityType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                previousResultBigqueryTable_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>
        bigqueryInputConfigs_ = java.util.Collections.emptyList();

    private void ensureBigqueryInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        bigqueryInputConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>(
                bigqueryInputConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig,
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder,
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder>
        bigqueryInputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>
        getBigqueryInputConfigsList() {
      if (bigqueryInputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(bigqueryInputConfigs_);
      } else {
        return bigqueryInputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public int getBigqueryInputConfigsCount() {
      if (bigqueryInputConfigsBuilder_ == null) {
        return bigqueryInputConfigs_.size();
      } else {
        return bigqueryInputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig getBigqueryInputConfigs(
        int index) {
      if (bigqueryInputConfigsBuilder_ == null) {
        return bigqueryInputConfigs_.get(index);
      } else {
        return bigqueryInputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder setBigqueryInputConfigs(
        int index, com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig value) {
      if (bigqueryInputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.set(index, value);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder setBigqueryInputConfigs(
        int index,
        com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder builderForValue) {
      if (bigqueryInputConfigsBuilder_ == null) {
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder addBigqueryInputConfigs(
        com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig value) {
      if (bigqueryInputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.add(value);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder addBigqueryInputConfigs(
        int index, com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig value) {
      if (bigqueryInputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.add(index, value);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder addBigqueryInputConfigs(
        com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder builderForValue) {
      if (bigqueryInputConfigsBuilder_ == null) {
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder addBigqueryInputConfigs(
        int index,
        com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder builderForValue) {
      if (bigqueryInputConfigsBuilder_ == null) {
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder addAllBigqueryInputConfigs(
        java.lang.Iterable<
                ? extends com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig>
            values) {
      if (bigqueryInputConfigsBuilder_ == null) {
        ensureBigqueryInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bigqueryInputConfigs_);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder clearBigqueryInputConfigs() {
      if (bigqueryInputConfigsBuilder_ == null) {
        bigqueryInputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public Builder removeBigqueryInputConfigs(int index) {
      if (bigqueryInputConfigsBuilder_ == null) {
        ensureBigqueryInputConfigsIsMutable();
        bigqueryInputConfigs_.remove(index);
        onChanged();
      } else {
        bigqueryInputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder
        getBigqueryInputConfigsBuilder(int index) {
      return getBigqueryInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder
        getBigqueryInputConfigsOrBuilder(int index) {
      if (bigqueryInputConfigsBuilder_ == null) {
        return bigqueryInputConfigs_.get(index);
      } else {
        return bigqueryInputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder>
        getBigqueryInputConfigsOrBuilderList() {
      if (bigqueryInputConfigsBuilder_ != null) {
        return bigqueryInputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(bigqueryInputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder
        addBigqueryInputConfigsBuilder() {
      return getBigqueryInputConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder
        addBigqueryInputConfigsBuilder(int index) {
      return getBigqueryInputConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of input BigQuery tables.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig bigquery_input_configs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder>
        getBigqueryInputConfigsBuilderList() {
      return getBigqueryInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig,
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder,
            com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder>
        getBigqueryInputConfigsFieldBuilder() {
      if (bigqueryInputConfigsBuilder_ == null) {
        bigqueryInputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig,
                com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfig.Builder,
                com.google.cloud.enterpriseknowledgegraph.v1.BigQueryInputConfigOrBuilder>(
                bigqueryInputConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        bigqueryInputConfigs_ = null;
      }
      return bigqueryInputConfigsBuilder_;
    }

    private int entityType_ = 0;
    /**
     *
     *
     * <pre>
     * Entity type
     * </pre>
     *
     * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for entityType.
     */
    @java.lang.Override
    public int getEntityTypeValue() {
      return entityType_;
    }
    /**
     *
     *
     * <pre>
     * Entity type
     * </pre>
     *
     * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeValue(int value) {
      entityType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity type
     * </pre>
     *
     * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;
     * </code>
     *
     * @return The entityType.
     */
    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType getEntityType() {
      com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType result =
          com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType.forNumber(
              entityType_);
      return result == null
          ? com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Entity type
     * </pre>
     *
     * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;
     * </code>
     *
     * @param value The entityType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityType(
        com.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      entityType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entity type
     * </pre>
     *
     * <code>.google.cloud.enterpriseknowledgegraph.v1.InputConfig.EntityType entity_type = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      entityType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object previousResultBigqueryTable_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Provide the bigquery table containing the previous results if
     * cluster ID stability is desired. Format is
     * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
     * </pre>
     *
     * <code>
     * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The previousResultBigqueryTable.
     */
    public java.lang.String getPreviousResultBigqueryTable() {
      java.lang.Object ref = previousResultBigqueryTable_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        previousResultBigqueryTable_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Provide the bigquery table containing the previous results if
     * cluster ID stability is desired. Format is
     * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
     * </pre>
     *
     * <code>
     * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for previousResultBigqueryTable.
     */
    public com.google.protobuf.ByteString getPreviousResultBigqueryTableBytes() {
      java.lang.Object ref = previousResultBigqueryTable_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        previousResultBigqueryTable_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Provide the bigquery table containing the previous results if
     * cluster ID stability is desired. Format is
     * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
     * </pre>
     *
     * <code>
     * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The previousResultBigqueryTable to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousResultBigqueryTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      previousResultBigqueryTable_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Provide the bigquery table containing the previous results if
     * cluster ID stability is desired. Format is
     * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
     * </pre>
     *
     * <code>
     * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreviousResultBigqueryTable() {
      previousResultBigqueryTable_ = getDefaultInstance().getPreviousResultBigqueryTable();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Provide the bigquery table containing the previous results if
     * cluster ID stability is desired. Format is
     * `projects/&#42;&#47;datasets/&#42;&#47;tables/&#42;`.
     * </pre>
     *
     * <code>
     * string previous_result_bigquery_table = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for previousResultBigqueryTable to set.
     * @return This builder for chaining.
     */
    public Builder setPreviousResultBigqueryTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      previousResultBigqueryTable_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.enterpriseknowledgegraph.v1.InputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.enterpriseknowledgegraph.v1.InputConfig)
  private static final com.google.cloud.enterpriseknowledgegraph.v1.InputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.enterpriseknowledgegraph.v1.InputConfig();
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.InputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InputConfig> PARSER =
      new com.google.protobuf.AbstractParser<InputConfig>() {
        @java.lang.Override
        public InputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.enterpriseknowledgegraph.v1.InputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
