/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/enterpriseknowledgegraph/v1/service.proto

package com.google.cloud.enterpriseknowledgegraph.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [EnterpriseKnowledgeGraphService.Search][google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.Search].
 * </pre>
 *
 * Protobuf type {@code google.cloud.enterpriseknowledgegraph.v1.SearchRequest}
 */
public final class SearchRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.enterpriseknowledgegraph.v1.SearchRequest)
    SearchRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchRequest.newBuilder() to construct.
  private SearchRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchRequest() {
    parent_ = "";
    query_ = "";
    languages_ = com.google.protobuf.LazyStringArrayList.emptyList();
    types_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
        .internal_static_google_cloud_enterpriseknowledgegraph_v1_SearchRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
        .internal_static_google_cloud_enterpriseknowledgegraph_v1_SearchRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.class,
            com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Entity's parent resource.
   * Format:
   * `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Entity's parent resource.
   * Format:
   * `projects/{project}/locations/{location}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * Required. The literal query string for search.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The literal query string for search.
   * </pre>
   *
   * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList languages_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of language codes (defined in ISO 693) to run the query with,
   * e.g. 'en'.
   * </pre>
   *
   * <code>repeated string languages = 3;</code>
   *
   * @return A list containing the languages.
   */
  public com.google.protobuf.ProtocolStringList getLanguagesList() {
    return languages_;
  }
  /**
   *
   *
   * <pre>
   * The list of language codes (defined in ISO 693) to run the query with,
   * e.g. 'en'.
   * </pre>
   *
   * <code>repeated string languages = 3;</code>
   *
   * @return The count of languages.
   */
  public int getLanguagesCount() {
    return languages_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of language codes (defined in ISO 693) to run the query with,
   * e.g. 'en'.
   * </pre>
   *
   * <code>repeated string languages = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The languages at the given index.
   */
  public java.lang.String getLanguages(int index) {
    return languages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of language codes (defined in ISO 693) to run the query with,
   * e.g. 'en'.
   * </pre>
   *
   * <code>repeated string languages = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the languages at the given index.
   */
  public com.google.protobuf.ByteString getLanguagesBytes(int index) {
    return languages_.getByteString(index);
  }

  public static final int TYPES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList types_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Restricts returned entities with these types, e.g. Person
   * (as defined in http://schema.org/Person). If multiple types are specified,
   * returned entities will contain one or more of these types.
   * </pre>
   *
   * <code>repeated string types = 4;</code>
   *
   * @return A list containing the types.
   */
  public com.google.protobuf.ProtocolStringList getTypesList() {
    return types_;
  }
  /**
   *
   *
   * <pre>
   * Restricts returned entities with these types, e.g. Person
   * (as defined in http://schema.org/Person). If multiple types are specified,
   * returned entities will contain one or more of these types.
   * </pre>
   *
   * <code>repeated string types = 4;</code>
   *
   * @return The count of types.
   */
  public int getTypesCount() {
    return types_.size();
  }
  /**
   *
   *
   * <pre>
   * Restricts returned entities with these types, e.g. Person
   * (as defined in http://schema.org/Person). If multiple types are specified,
   * returned entities will contain one or more of these types.
   * </pre>
   *
   * <code>repeated string types = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The types at the given index.
   */
  public java.lang.String getTypes(int index) {
    return types_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Restricts returned entities with these types, e.g. Person
   * (as defined in http://schema.org/Person). If multiple types are specified,
   * returned entities will contain one or more of these types.
   * </pre>
   *
   * <code>repeated string types = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the types at the given index.
   */
  public com.google.protobuf.ByteString getTypesBytes(int index) {
    return types_.getByteString(index);
  }

  public static final int LIMIT_FIELD_NUMBER = 6;
  private com.google.protobuf.Int32Value limit_;
  /**
   *
   *
   * <pre>
   * Limits the number of entities to be returned.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 6;</code>
   *
   * @return Whether the limit field is set.
   */
  @java.lang.Override
  public boolean hasLimit() {
    return limit_ != null;
  }
  /**
   *
   *
   * <pre>
   * Limits the number of entities to be returned.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 6;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public com.google.protobuf.Int32Value getLimit() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }
  /**
   *
   *
   * <pre>
   * Limits the number of entities to be returned.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, query_);
    }
    for (int i = 0; i < languages_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, languages_.getRaw(i));
    }
    for (int i = 0; i < types_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, types_.getRaw(i));
    }
    if (limit_ != null) {
      output.writeMessage(6, getLimit());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, query_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languages_.size(); i++) {
        dataSize += computeStringSizeNoTag(languages_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLanguagesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < types_.size(); i++) {
        dataSize += computeStringSizeNoTag(types_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTypesList().size();
    }
    if (limit_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLimit());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest other =
        (com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getQuery().equals(other.getQuery())) return false;
    if (!getLanguagesList().equals(other.getLanguagesList())) return false;
    if (!getTypesList().equals(other.getTypesList())) return false;
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (!getLimit().equals(other.getLimit())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    if (getLanguagesCount() > 0) {
      hash = (37 * hash) + LANGUAGES_FIELD_NUMBER;
      hash = (53 * hash) + getLanguagesList().hashCode();
    }
    if (getTypesCount() > 0) {
      hash = (37 * hash) + TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getTypesList().hashCode();
    }
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [EnterpriseKnowledgeGraphService.Search][google.cloud.enterpriseknowledgegraph.v1.EnterpriseKnowledgeGraphService.Search].
   * </pre>
   *
   * Protobuf type {@code google.cloud.enterpriseknowledgegraph.v1.SearchRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.enterpriseknowledgegraph.v1.SearchRequest)
      com.google.cloud.enterpriseknowledgegraph.v1.SearchRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_SearchRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_SearchRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.class,
              com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.Builder.class);
    }

    // Construct using com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      query_ = "";
      languages_ = com.google.protobuf.LazyStringArrayList.emptyList();
      types_ = com.google.protobuf.LazyStringArrayList.emptyList();
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.enterpriseknowledgegraph.v1.ServiceProto
          .internal_static_google_cloud_enterpriseknowledgegraph_v1_SearchRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest getDefaultInstanceForType() {
      return com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest build() {
      com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest buildPartial() {
      com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest result =
          new com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        languages_.makeImmutable();
        result.languages_ = languages_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        types_.makeImmutable();
        result.types_ = types_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.limit_ = limitBuilder_ == null ? limit_ : limitBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest) {
        return mergeFrom((com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest other) {
      if (other == com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.languages_.isEmpty()) {
        if (languages_.isEmpty()) {
          languages_ = other.languages_;
          bitField0_ |= 0x00000004;
        } else {
          ensureLanguagesIsMutable();
          languages_.addAll(other.languages_);
        }
        onChanged();
      }
      if (!other.types_.isEmpty()) {
        if (types_.isEmpty()) {
          types_ = other.types_;
          bitField0_ |= 0x00000008;
        } else {
          ensureTypesIsMutable();
          types_.addAll(other.types_);
        }
        onChanged();
      }
      if (other.hasLimit()) {
        mergeLimit(other.getLimit());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLanguagesIsMutable();
                languages_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTypesIsMutable();
                types_.add(s);
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getLimitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Entity's parent resource.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Entity's parent resource.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Entity's parent resource.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Entity's parent resource.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Entity's parent resource.
     * Format:
     * `projects/{project}/locations/{location}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The literal query string for search.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The literal query string for search.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The literal query string for search.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The literal query string for search.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The literal query string for search.
     * </pre>
     *
     * <code>string query = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList languages_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLanguagesIsMutable() {
      if (!languages_.isModifiable()) {
        languages_ = new com.google.protobuf.LazyStringArrayList(languages_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @return A list containing the languages.
     */
    public com.google.protobuf.ProtocolStringList getLanguagesList() {
      languages_.makeImmutable();
      return languages_;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @return The count of languages.
     */
    public int getLanguagesCount() {
      return languages_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The languages at the given index.
     */
    public java.lang.String getLanguages(int index) {
      return languages_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languages at the given index.
     */
    public com.google.protobuf.ByteString getLanguagesBytes(int index) {
      return languages_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The languages to set.
     * @return This builder for chaining.
     */
    public Builder setLanguages(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguagesIsMutable();
      languages_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param value The languages to add.
     * @return This builder for chaining.
     */
    public Builder addLanguages(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguagesIsMutable();
      languages_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param values The languages to add.
     * @return This builder for chaining.
     */
    public Builder addAllLanguages(java.lang.Iterable<java.lang.String> values) {
      ensureLanguagesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languages_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguages() {
      languages_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of language codes (defined in ISO 693) to run the query with,
     * e.g. 'en'.
     * </pre>
     *
     * <code>repeated string languages = 3;</code>
     *
     * @param value The bytes of the languages to add.
     * @return This builder for chaining.
     */
    public Builder addLanguagesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguagesIsMutable();
      languages_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList types_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTypesIsMutable() {
      if (!types_.isModifiable()) {
        types_ = new com.google.protobuf.LazyStringArrayList(types_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @return A list containing the types.
     */
    public com.google.protobuf.ProtocolStringList getTypesList() {
      types_.makeImmutable();
      return types_;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @return The count of types.
     */
    public int getTypesCount() {
      return types_.size();
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The types at the given index.
     */
    public java.lang.String getTypes(int index) {
      return types_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the types at the given index.
     */
    public com.google.protobuf.ByteString getTypesBytes(int index) {
      return types_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The types to set.
     * @return This builder for chaining.
     */
    public Builder setTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param value The types to add.
     * @return This builder for chaining.
     */
    public Builder addTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTypesIsMutable();
      types_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param values The types to add.
     * @return This builder for chaining.
     */
    public Builder addAllTypes(java.lang.Iterable<java.lang.String> values) {
      ensureTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, types_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypes() {
      types_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts returned entities with these types, e.g. Person
     * (as defined in http://schema.org/Person). If multiple types are specified,
     * returned entities will contain one or more of these types.
     * </pre>
     *
     * <code>repeated string types = 4;</code>
     *
     * @param value The bytes of the types to add.
     * @return This builder for chaining.
     */
    public Builder addTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTypesIsMutable();
      types_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int32Value limit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        limitBuilder_;
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     *
     * @return Whether the limit field is set.
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     *
     * @return The limit.
     */
    public com.google.protobuf.Int32Value getLimit() {
      if (limitBuilder_ == null) {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      } else {
        return limitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limit_ = value;
      } else {
        limitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (limitBuilder_ == null) {
        limit_ = builderForValue.build();
      } else {
        limitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public Builder mergeLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && limit_ != null
            && limit_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
          getLimitBuilder().mergeFrom(value);
        } else {
          limit_ = value;
        }
      } else {
        limitBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000010);
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public com.google.protobuf.Int32Value.Builder getLimitBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getLimitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
      if (limitBuilder_ != null) {
        return limitBuilder_.getMessageOrBuilder();
      } else {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      }
    }
    /**
     *
     *
     * <pre>
     * Limits the number of entities to be returned.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getLimitFieldBuilder() {
      if (limitBuilder_ == null) {
        limitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getLimit(), getParentForChildren(), isClean());
        limit_ = null;
      }
      return limitBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.enterpriseknowledgegraph.v1.SearchRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.enterpriseknowledgegraph.v1.SearchRequest)
  private static final com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest();
  }

  public static com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchRequest>() {
        @java.lang.Override
        public SearchRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.enterpriseknowledgegraph.v1.SearchRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
