/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TriggerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TRIGGER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/triggers/{trigger}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String trigger;

    @Deprecated
    protected TriggerName() {
        this.project = null;
        this.location = null;
        this.trigger = null;
    }

    private TriggerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.trigger = (String)Preconditions.checkNotNull((Object)builder.getTrigger());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TriggerName of(String project, String location, String trigger) {
        return TriggerName.newBuilder().setProject(project).setLocation(location).setTrigger(trigger).build();
    }

    public static String format(String project, String location, String trigger) {
        return TriggerName.newBuilder().setProject(project).setLocation(location).setTrigger(trigger).build().toString();
    }

    public static TriggerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TRIGGER.validatedMatch(formattedString, "TriggerName.parse: formattedString not in valid format");
        return TriggerName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("trigger"));
    }

    public static List<TriggerName> parseList(List<String> formattedStrings) {
        ArrayList<TriggerName> list = new ArrayList<TriggerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TriggerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TriggerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TriggerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TRIGGER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TriggerName triggerName = this;
            synchronized (triggerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.trigger != null) {
                        fieldMapBuilder.put((Object)"trigger", (Object)this.trigger);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TRIGGER.instantiate(new String[]{"project", this.project, "location", this.location, "trigger", this.trigger});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TriggerName that = (TriggerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.trigger, that.trigger);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trigger);
    }

    public static class Builder {
        private String project;
        private String location;
        private String trigger;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTrigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        private Builder(TriggerName triggerName) {
            this.project = triggerName.project;
            this.location = triggerName.location;
            this.trigger = triggerName.trigger;
        }

        public TriggerName build() {
            return new TriggerName(this);
        }
    }
}

