/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GoogleApiSourceName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GOOGLE_API_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/googleApiSources/{google_api_source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String googleApiSource;

    @Deprecated
    protected GoogleApiSourceName() {
        this.project = null;
        this.location = null;
        this.googleApiSource = null;
    }

    private GoogleApiSourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.googleApiSource = (String)Preconditions.checkNotNull((Object)builder.getGoogleApiSource());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGoogleApiSource() {
        return this.googleApiSource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GoogleApiSourceName of(String project, String location, String googleApiSource) {
        return GoogleApiSourceName.newBuilder().setProject(project).setLocation(location).setGoogleApiSource(googleApiSource).build();
    }

    public static String format(String project, String location, String googleApiSource) {
        return GoogleApiSourceName.newBuilder().setProject(project).setLocation(location).setGoogleApiSource(googleApiSource).build().toString();
    }

    public static GoogleApiSourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GOOGLE_API_SOURCE.validatedMatch(formattedString, "GoogleApiSourceName.parse: formattedString not in valid format");
        return GoogleApiSourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("google_api_source"));
    }

    public static List<GoogleApiSourceName> parseList(List<String> formattedStrings) {
        ArrayList<GoogleApiSourceName> list = new ArrayList<GoogleApiSourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GoogleApiSourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GoogleApiSourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GoogleApiSourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GOOGLE_API_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GoogleApiSourceName googleApiSourceName = this;
            synchronized (googleApiSourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.googleApiSource != null) {
                        fieldMapBuilder.put((Object)"google_api_source", (Object)this.googleApiSource);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GOOGLE_API_SOURCE.instantiate(new String[]{"project", this.project, "location", this.location, "google_api_source", this.googleApiSource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GoogleApiSourceName that = (GoogleApiSourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.googleApiSource, that.googleApiSource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.googleApiSource);
    }

    public static class Builder {
        private String project;
        private String location;
        private String googleApiSource;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGoogleApiSource() {
            return this.googleApiSource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGoogleApiSource(String googleApiSource) {
            this.googleApiSource = googleApiSource;
            return this;
        }

        private Builder(GoogleApiSourceName googleApiSourceName) {
            this.project = googleApiSourceName.project;
            this.location = googleApiSourceName.location;
            this.googleApiSource = googleApiSourceName.googleApiSource;
        }

        public GoogleApiSourceName build() {
            return new GoogleApiSourceName(this);
        }
    }
}

