/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1;

import com.google.cloud.filestore.v1.CloudFilestoreServiceProto;
import com.google.cloud.filestore.v1.NetworkConfigOrBuilder;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class NetworkConfig
extends GeneratedMessageV3
implements NetworkConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NETWORK_FIELD_NUMBER = 1;
    private volatile Object network_ = "";
    public static final int MODES_FIELD_NUMBER = 3;
    private List<Integer> modes_;
    private static final Internal.ListAdapter.Converter<Integer, AddressMode> modes_converter_ = new Internal.ListAdapter.Converter<Integer, AddressMode>(){

        public AddressMode convert(Integer from) {
            AddressMode result = AddressMode.forNumber(from);
            return result == null ? AddressMode.UNRECOGNIZED : result;
        }
    };
    private int modesMemoizedSerializedSize;
    public static final int RESERVED_IP_RANGE_FIELD_NUMBER = 4;
    private volatile Object reservedIpRange_ = "";
    public static final int IP_ADDRESSES_FIELD_NUMBER = 5;
    private LazyStringList ipAddresses_;
    public static final int CONNECT_MODE_FIELD_NUMBER = 6;
    private int connectMode_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final NetworkConfig DEFAULT_INSTANCE = new NetworkConfig();
    private static final Parser<NetworkConfig> PARSER = new AbstractParser<NetworkConfig>(){

        public NetworkConfig parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = NetworkConfig.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private NetworkConfig(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private NetworkConfig() {
        this.network_ = "";
        this.modes_ = Collections.emptyList();
        this.reservedIpRange_ = "";
        this.ipAddresses_ = LazyStringArrayList.EMPTY;
        this.connectMode_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new NetworkConfig();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_NetworkConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NetworkConfig.class, Builder.class);
    }

    @Override
    public String getNetwork() {
        Object ref = this.network_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.network_ = s;
        return s;
    }

    @Override
    public ByteString getNetworkBytes() {
        Object ref = this.network_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.network_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<AddressMode> getModesList() {
        return new Internal.ListAdapter(this.modes_, modes_converter_);
    }

    @Override
    public int getModesCount() {
        return this.modes_.size();
    }

    @Override
    public AddressMode getModes(int index) {
        return (AddressMode)((Object)modes_converter_.convert((Object)this.modes_.get(index)));
    }

    @Override
    public List<Integer> getModesValueList() {
        return this.modes_;
    }

    @Override
    public int getModesValue(int index) {
        return this.modes_.get(index);
    }

    @Override
    public String getReservedIpRange() {
        Object ref = this.reservedIpRange_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.reservedIpRange_ = s;
        return s;
    }

    @Override
    public ByteString getReservedIpRangeBytes() {
        Object ref = this.reservedIpRange_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.reservedIpRange_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getIpAddressesList() {
        return this.ipAddresses_;
    }

    @Override
    public int getIpAddressesCount() {
        return this.ipAddresses_.size();
    }

    @Override
    public String getIpAddresses(int index) {
        return (String)this.ipAddresses_.get(index);
    }

    @Override
    public ByteString getIpAddressesBytes(int index) {
        return this.ipAddresses_.getByteString(index);
    }

    @Override
    public int getConnectModeValue() {
        return this.connectMode_;
    }

    @Override
    public ConnectMode getConnectMode() {
        ConnectMode result = ConnectMode.forNumber(this.connectMode_);
        return result == null ? ConnectMode.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.network_);
        }
        if (this.getModesList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.modesMemoizedSerializedSize);
        }
        for (i = 0; i < this.modes_.size(); ++i) {
            output.writeEnumNoTag(this.modes_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.reservedIpRange_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.reservedIpRange_);
        }
        for (i = 0; i < this.ipAddresses_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.ipAddresses_.getRaw(i));
        }
        if (this.connectMode_ != ConnectMode.CONNECT_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.connectMode_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.network_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.network_);
        }
        int dataSize = 0;
        for (i = 0; i < this.modes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.modes_.get(i));
        }
        size += dataSize;
        if (!this.getModesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.modesMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.reservedIpRange_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.reservedIpRange_);
        }
        dataSize = 0;
        for (i = 0; i < this.ipAddresses_.size(); ++i) {
            dataSize += NetworkConfig.computeStringSizeNoTag((Object)this.ipAddresses_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getIpAddressesList().size();
        if (this.connectMode_ != ConnectMode.CONNECT_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.connectMode_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetworkConfig)) {
            return super.equals(obj);
        }
        NetworkConfig other = (NetworkConfig)obj;
        if (!this.getNetwork().equals(other.getNetwork())) {
            return false;
        }
        if (!this.modes_.equals(other.modes_)) {
            return false;
        }
        if (!this.getReservedIpRange().equals(other.getReservedIpRange())) {
            return false;
        }
        if (!this.getIpAddressesList().equals(other.getIpAddressesList())) {
            return false;
        }
        if (this.connectMode_ != other.connectMode_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + NetworkConfig.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getNetwork().hashCode();
        if (this.getModesCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.modes_.hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getReservedIpRange().hashCode();
        if (this.getIpAddressesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getIpAddressesList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.connectMode_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static NetworkConfig parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data);
    }

    public static NetworkConfig parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NetworkConfig parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data);
    }

    public static NetworkConfig parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NetworkConfig parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data);
    }

    public static NetworkConfig parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (NetworkConfig)PARSER.parseFrom(data, extensionRegistry);
    }

    public static NetworkConfig parseFrom(InputStream input) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static NetworkConfig parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConfig parseDelimitedFrom(InputStream input) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static NetworkConfig parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static NetworkConfig parseFrom(CodedInputStream input) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static NetworkConfig parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (NetworkConfig)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return NetworkConfig.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(NetworkConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static NetworkConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<NetworkConfig> parser() {
        return PARSER;
    }

    public Parser<NetworkConfig> getParserForType() {
        return PARSER;
    }

    public NetworkConfig getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements NetworkConfigOrBuilder {
        private int bitField0_;
        private Object network_ = "";
        private List<Integer> modes_ = Collections.emptyList();
        private Object reservedIpRange_ = "";
        private LazyStringList ipAddresses_ = LazyStringArrayList.EMPTY;
        private int connectMode_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_NetworkConfig_fieldAccessorTable.ensureFieldAccessorsInitialized(NetworkConfig.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.network_ = "";
            this.modes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.reservedIpRange_ = "";
            this.ipAddresses_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFF7;
            this.connectMode_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CloudFilestoreServiceProto.internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
        }

        public NetworkConfig getDefaultInstanceForType() {
            return NetworkConfig.getDefaultInstance();
        }

        public NetworkConfig build() {
            NetworkConfig result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public NetworkConfig buildPartial() {
            NetworkConfig result = new NetworkConfig(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(NetworkConfig result) {
            if ((this.bitField0_ & 2) != 0) {
                this.modes_ = Collections.unmodifiableList(this.modes_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.modes_ = this.modes_;
            if ((this.bitField0_ & 8) != 0) {
                this.ipAddresses_ = this.ipAddresses_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.ipAddresses_ = this.ipAddresses_;
        }

        private void buildPartial0(NetworkConfig result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.network_ = this.network_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.reservedIpRange_ = this.reservedIpRange_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.connectMode_ = this.connectMode_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof NetworkConfig) {
                return this.mergeFrom((NetworkConfig)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(NetworkConfig other) {
            if (other == NetworkConfig.getDefaultInstance()) {
                return this;
            }
            if (!other.getNetwork().isEmpty()) {
                this.network_ = other.network_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.modes_.isEmpty()) {
                if (this.modes_.isEmpty()) {
                    this.modes_ = other.modes_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureModesIsMutable();
                    this.modes_.addAll(other.modes_);
                }
                this.onChanged();
            }
            if (!other.getReservedIpRange().isEmpty()) {
                this.reservedIpRange_ = other.reservedIpRange_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.ipAddresses_.isEmpty()) {
                if (this.ipAddresses_.isEmpty()) {
                    this.ipAddresses_ = other.ipAddresses_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureIpAddressesIsMutable();
                    this.ipAddresses_.addAll((Collection)other.ipAddresses_);
                }
                this.onChanged();
            }
            if (other.connectMode_ != 0) {
                this.setConnectModeValue(other.getConnectModeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 10: {
                            this.network_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block14;
                        }
                        case 24: {
                            int tmpRaw = input.readEnum();
                            this.ensureModesIsMutable();
                            this.modes_.add(tmpRaw);
                            continue block14;
                        }
                        case 26: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int tmpRaw = input.readEnum();
                                this.ensureModesIsMutable();
                                this.modes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block14;
                        }
                        case 34: {
                            this.reservedIpRange_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block14;
                        }
                        case 42: {
                            String s = input.readStringRequireUtf8();
                            this.ensureIpAddressesIsMutable();
                            this.ipAddresses_.add((Object)s);
                            continue block14;
                        }
                        case 48: {
                            this.connectMode_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block14;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getNetwork() {
            Object ref = this.network_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.network_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNetworkBytes() {
            Object ref = this.network_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.network_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setNetwork(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.network_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearNetwork() {
            this.network_ = NetworkConfig.getDefaultInstance().getNetwork();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNetworkBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NetworkConfig.checkByteStringIsUtf8((ByteString)value);
            this.network_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureModesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.modes_ = new ArrayList<Integer>(this.modes_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<AddressMode> getModesList() {
            return new Internal.ListAdapter(this.modes_, modes_converter_);
        }

        @Override
        public int getModesCount() {
            return this.modes_.size();
        }

        @Override
        public AddressMode getModes(int index) {
            return (AddressMode)((Object)modes_converter_.convert((Object)this.modes_.get(index)));
        }

        public Builder setModes(int index, AddressMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureModesIsMutable();
            this.modes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addModes(AddressMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureModesIsMutable();
            this.modes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllModes(Iterable<? extends AddressMode> values) {
            this.ensureModesIsMutable();
            for (AddressMode addressMode : values) {
                this.modes_.add(addressMode.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearModes() {
            this.modes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getModesValueList() {
            return Collections.unmodifiableList(this.modes_);
        }

        @Override
        public int getModesValue(int index) {
            return this.modes_.get(index);
        }

        public Builder setModesValue(int index, int value) {
            this.ensureModesIsMutable();
            this.modes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addModesValue(int value) {
            this.ensureModesIsMutable();
            this.modes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllModesValue(Iterable<Integer> values) {
            this.ensureModesIsMutable();
            for (int value : values) {
                this.modes_.add(value);
            }
            this.onChanged();
            return this;
        }

        @Override
        public String getReservedIpRange() {
            Object ref = this.reservedIpRange_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.reservedIpRange_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getReservedIpRangeBytes() {
            Object ref = this.reservedIpRange_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.reservedIpRange_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setReservedIpRange(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.reservedIpRange_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearReservedIpRange() {
            this.reservedIpRange_ = NetworkConfig.getDefaultInstance().getReservedIpRange();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setReservedIpRangeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NetworkConfig.checkByteStringIsUtf8((ByteString)value);
            this.reservedIpRange_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        private void ensureIpAddressesIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.ipAddresses_ = new LazyStringArrayList(this.ipAddresses_);
                this.bitField0_ |= 8;
            }
        }

        public ProtocolStringList getIpAddressesList() {
            return this.ipAddresses_.getUnmodifiableView();
        }

        @Override
        public int getIpAddressesCount() {
            return this.ipAddresses_.size();
        }

        @Override
        public String getIpAddresses(int index) {
            return (String)this.ipAddresses_.get(index);
        }

        @Override
        public ByteString getIpAddressesBytes(int index) {
            return this.ipAddresses_.getByteString(index);
        }

        public Builder setIpAddresses(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureIpAddressesIsMutable();
            this.ipAddresses_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addIpAddresses(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureIpAddressesIsMutable();
            this.ipAddresses_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllIpAddresses(Iterable<String> values) {
            this.ensureIpAddressesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.ipAddresses_);
            this.onChanged();
            return this;
        }

        public Builder clearIpAddresses() {
            this.ipAddresses_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder addIpAddressesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            NetworkConfig.checkByteStringIsUtf8((ByteString)value);
            this.ensureIpAddressesIsMutable();
            this.ipAddresses_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public int getConnectModeValue() {
            return this.connectMode_;
        }

        public Builder setConnectModeValue(int value) {
            this.connectMode_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public ConnectMode getConnectMode() {
            ConnectMode result = ConnectMode.forNumber(this.connectMode_);
            return result == null ? ConnectMode.UNRECOGNIZED : result;
        }

        public Builder setConnectMode(ConnectMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.connectMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearConnectMode() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.connectMode_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ConnectMode implements ProtocolMessageEnum
    {
        CONNECT_MODE_UNSPECIFIED(0),
        DIRECT_PEERING(1),
        PRIVATE_SERVICE_ACCESS(2),
        UNRECOGNIZED(-1);

        public static final int CONNECT_MODE_UNSPECIFIED_VALUE = 0;
        public static final int DIRECT_PEERING_VALUE = 1;
        public static final int PRIVATE_SERVICE_ACCESS_VALUE = 2;
        private static final Internal.EnumLiteMap<ConnectMode> internalValueMap;
        private static final ConnectMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ConnectMode valueOf(int value) {
            return ConnectMode.forNumber(value);
        }

        public static ConnectMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return CONNECT_MODE_UNSPECIFIED;
                }
                case 1: {
                    return DIRECT_PEERING;
                }
                case 2: {
                    return PRIVATE_SERVICE_ACCESS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ConnectMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ConnectMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ConnectMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NetworkConfig.getDescriptor().getEnumTypes().get(1);
        }

        public static ConnectMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ConnectMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ConnectMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ConnectMode>(){

                public ConnectMode findValueByNumber(int number) {
                    return ConnectMode.forNumber(number);
                }
            };
            VALUES = ConnectMode.values();
        }
    }

    public static enum AddressMode implements ProtocolMessageEnum
    {
        ADDRESS_MODE_UNSPECIFIED(0),
        MODE_IPV4(1),
        UNRECOGNIZED(-1);

        public static final int ADDRESS_MODE_UNSPECIFIED_VALUE = 0;
        public static final int MODE_IPV4_VALUE = 1;
        private static final Internal.EnumLiteMap<AddressMode> internalValueMap;
        private static final AddressMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AddressMode valueOf(int value) {
            return AddressMode.forNumber(value);
        }

        public static AddressMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return ADDRESS_MODE_UNSPECIFIED;
                }
                case 1: {
                    return MODE_IPV4;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AddressMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AddressMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AddressMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)NetworkConfig.getDescriptor().getEnumTypes().get(0);
        }

        public static AddressMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AddressMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AddressMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<AddressMode>(){

                public AddressMode findValueByNumber(int number) {
                    return AddressMode.forNumber(number);
                }
            };
            VALUES = AddressMode.values();
        }
    }
}

