/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

package com.google.cloud.filestore.v1;

/**
 *
 *
 * <pre>
 * A Filestore instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.filestore.v1.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.filestore.v1.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    description_ = "";
    state_ = 0;
    statusMessage_ = "";
    tier_ = 0;
    fileShares_ = java.util.Collections.emptyList();
    networks_ = java.util.Collections.emptyList();
    etag_ = "";
    kmsKeyName_ = "";
    suspensionReasons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.filestore.v1.Instance.class,
            com.google.cloud.filestore.v1.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The instance state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The instance is available for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * Work is being done on the instance. You can get further details from the
     * `statusMessage` field of the `Instance` resource.
     * </pre>
     *
     * <code>REPAIRING = 3;</code>
     */
    REPAIRING(3),
    /**
     *
     *
     * <pre>
     * The instance is shutting down.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The instance is experiencing an issue and might be unusable. You can get
     * further details from the `statusMessage` field of the `Instance`
     * resource.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    ERROR(6),
    /**
     *
     *
     * <pre>
     * The instance is restoring a backup to an existing file share and may be
     * unusable during this time.
     * </pre>
     *
     * <code>RESTORING = 7;</code>
     */
    RESTORING(7),
    /**
     *
     *
     * <pre>
     * The instance is suspended. You can get further details from
     * the `suspension_reasons` field of the `Instance` resource.
     * </pre>
     *
     * <code>SUSPENDED = 8;</code>
     */
    SUSPENDED(8),
    /**
     *
     *
     * <pre>
     * The instance is in the process of becoming suspended.
     * </pre>
     *
     * <code>SUSPENDING = 9;</code>
     */
    SUSPENDING(9),
    /**
     *
     *
     * <pre>
     * The instance is in the process of becoming active.
     * </pre>
     *
     * <code>RESUMING = 10;</code>
     */
    RESUMING(10),
    /**
     *
     *
     * <pre>
     * The instance is reverting to a snapshot.
     * </pre>
     *
     * <code>REVERTING = 12;</code>
     */
    REVERTING(12),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The instance is available for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Work is being done on the instance. You can get further details from the
     * `statusMessage` field of the `Instance` resource.
     * </pre>
     *
     * <code>REPAIRING = 3;</code>
     */
    public static final int REPAIRING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The instance is shutting down.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The instance is experiencing an issue and might be unusable. You can get
     * further details from the `statusMessage` field of the `Instance`
     * resource.
     * </pre>
     *
     * <code>ERROR = 6;</code>
     */
    public static final int ERROR_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The instance is restoring a backup to an existing file share and may be
     * unusable during this time.
     * </pre>
     *
     * <code>RESTORING = 7;</code>
     */
    public static final int RESTORING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The instance is suspended. You can get further details from
     * the `suspension_reasons` field of the `Instance` resource.
     * </pre>
     *
     * <code>SUSPENDED = 8;</code>
     */
    public static final int SUSPENDED_VALUE = 8;
    /**
     *
     *
     * <pre>
     * The instance is in the process of becoming suspended.
     * </pre>
     *
     * <code>SUSPENDING = 9;</code>
     */
    public static final int SUSPENDING_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The instance is in the process of becoming active.
     * </pre>
     *
     * <code>RESUMING = 10;</code>
     */
    public static final int RESUMING_VALUE = 10;
    /**
     *
     *
     * <pre>
     * The instance is reverting to a snapshot.
     * </pre>
     *
     * <code>REVERTING = 12;</code>
     */
    public static final int REVERTING_VALUE = 12;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return REPAIRING;
        case 4:
          return DELETING;
        case 6:
          return ERROR;
        case 7:
          return RESTORING;
        case 8:
          return SUSPENDED;
        case 9:
          return SUSPENDING;
        case 10:
          return RESUMING;
        case 12:
          return REVERTING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.Instance.State)
  }

  /**
   *
   *
   * <pre>
   * Available service tiers.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.Instance.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * STANDARD tier. BASIC_HDD is the preferred term for this tier.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    STANDARD(1),
    /**
     *
     *
     * <pre>
     * PREMIUM tier. BASIC_SSD is the preferred term for this tier.
     * </pre>
     *
     * <code>PREMIUM = 2;</code>
     */
    PREMIUM(2),
    /**
     *
     *
     * <pre>
     * BASIC instances offer a maximum capacity of 63.9 TB.
     * BASIC_HDD is an alias for STANDARD Tier, offering economical
     * performance backed by HDD.
     * </pre>
     *
     * <code>BASIC_HDD = 3;</code>
     */
    BASIC_HDD(3),
    /**
     *
     *
     * <pre>
     * BASIC instances offer a maximum capacity of 63.9 TB.
     * BASIC_SSD is an alias for PREMIUM Tier, and offers improved
     * performance backed by SSD.
     * </pre>
     *
     * <code>BASIC_SSD = 4;</code>
     */
    BASIC_SSD(4),
    /**
     *
     *
     * <pre>
     * HIGH_SCALE instances offer expanded capacity and performance scaling
     * capabilities.
     * </pre>
     *
     * <code>HIGH_SCALE_SSD = 5;</code>
     */
    HIGH_SCALE_SSD(5),
    /**
     *
     *
     * <pre>
     * ENTERPRISE instances offer the features and availability needed for
     * mission-critical workloads.
     * </pre>
     *
     * <code>ENTERPRISE = 6;</code>
     */
    ENTERPRISE(6),
    /**
     *
     *
     * <pre>
     * ZONAL instances offer expanded capacity and performance scaling
     * capabilities.
     * </pre>
     *
     * <code>ZONAL = 7;</code>
     */
    ZONAL(7),
    /**
     *
     *
     * <pre>
     * REGIONAL instances offer the features and availability needed for
     * mission-critical workloads.
     * </pre>
     *
     * <code>REGIONAL = 8;</code>
     */
    REGIONAL(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * STANDARD tier. BASIC_HDD is the preferred term for this tier.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    public static final int STANDARD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * PREMIUM tier. BASIC_SSD is the preferred term for this tier.
     * </pre>
     *
     * <code>PREMIUM = 2;</code>
     */
    public static final int PREMIUM_VALUE = 2;
    /**
     *
     *
     * <pre>
     * BASIC instances offer a maximum capacity of 63.9 TB.
     * BASIC_HDD is an alias for STANDARD Tier, offering economical
     * performance backed by HDD.
     * </pre>
     *
     * <code>BASIC_HDD = 3;</code>
     */
    public static final int BASIC_HDD_VALUE = 3;
    /**
     *
     *
     * <pre>
     * BASIC instances offer a maximum capacity of 63.9 TB.
     * BASIC_SSD is an alias for PREMIUM Tier, and offers improved
     * performance backed by SSD.
     * </pre>
     *
     * <code>BASIC_SSD = 4;</code>
     */
    public static final int BASIC_SSD_VALUE = 4;
    /**
     *
     *
     * <pre>
     * HIGH_SCALE instances offer expanded capacity and performance scaling
     * capabilities.
     * </pre>
     *
     * <code>HIGH_SCALE_SSD = 5;</code>
     */
    public static final int HIGH_SCALE_SSD_VALUE = 5;
    /**
     *
     *
     * <pre>
     * ENTERPRISE instances offer the features and availability needed for
     * mission-critical workloads.
     * </pre>
     *
     * <code>ENTERPRISE = 6;</code>
     */
    public static final int ENTERPRISE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * ZONAL instances offer expanded capacity and performance scaling
     * capabilities.
     * </pre>
     *
     * <code>ZONAL = 7;</code>
     */
    public static final int ZONAL_VALUE = 7;
    /**
     *
     *
     * <pre>
     * REGIONAL instances offer the features and availability needed for
     * mission-critical workloads.
     * </pre>
     *
     * <code>REGIONAL = 8;</code>
     */
    public static final int REGIONAL_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return STANDARD;
        case 2:
          return PREMIUM;
        case 3:
          return BASIC_HDD;
        case 4:
          return BASIC_SSD;
        case 5:
          return HIGH_SCALE_SSD;
        case 6:
          return ENTERPRISE;
        case 7:
          return ZONAL;
        case 8:
          return REGIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.Instance.getDescriptor().getEnumTypes().get(1);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.Instance.Tier)
  }

  /**
   *
   *
   * <pre>
   * SuspensionReason contains the possible reasons for a suspension.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.Instance.SuspensionReason}
   */
  public enum SuspensionReason implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    SUSPENSION_REASON_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The KMS key used by the instance is either revoked or denied access to.
     * </pre>
     *
     * <code>KMS_KEY_ISSUE = 1;</code>
     */
    KMS_KEY_ISSUE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>SUSPENSION_REASON_UNSPECIFIED = 0;</code>
     */
    public static final int SUSPENSION_REASON_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The KMS key used by the instance is either revoked or denied access to.
     * </pre>
     *
     * <code>KMS_KEY_ISSUE = 1;</code>
     */
    public static final int KMS_KEY_ISSUE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SuspensionReason valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SuspensionReason forNumber(int value) {
      switch (value) {
        case 0:
          return SUSPENSION_REASON_UNSPECIFIED;
        case 1:
          return KMS_KEY_ISSUE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SuspensionReason> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SuspensionReason>() {
              public SuspensionReason findValueByNumber(int number) {
                return SuspensionReason.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.Instance.getDescriptor().getEnumTypes().get(2);
    }

    private static final SuspensionReason[] VALUES = values();

    public static SuspensionReason valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SuspensionReason(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.Instance.SuspensionReason)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the instance, in the format
   * `projects/{project}/locations/{location}/instances/{instance}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the instance, in the format
   * `projects/{project}/locations/{location}/instances/{instance}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The description of the instance (2048 characters or less).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of the instance (2048 characters or less).
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The instance state.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.Instance.State getState() {
    com.google.cloud.filestore.v1.Instance.State result =
        com.google.cloud.filestore.v1.Instance.State.forNumber(state_);
    return result == null ? com.google.cloud.filestore.v1.Instance.State.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the instance state, if available.
   * </pre>
   *
   * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the instance state, if available.
   * </pre>
   *
   * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int TIER_FIELD_NUMBER = 8;
  private int tier_ = 0;
  /**
   *
   *
   * <pre>
   * The service tier of the instance.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
   *
   * @return The enum numeric value on the wire for tier.
   */
  @java.lang.Override
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * The service tier of the instance.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
   *
   * @return The tier.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.Instance.Tier getTier() {
    com.google.cloud.filestore.v1.Instance.Tier result =
        com.google.cloud.filestore.v1.Instance.Tier.forNumber(tier_);
    return result == null ? com.google.cloud.filestore.v1.Instance.Tier.UNRECOGNIZED : result;
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.filestore.v1.CloudFilestoreServiceProto
                .internal_static_google_cloud_filestore_v1_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FILE_SHARES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.filestore.v1.FileShareConfig> fileShares_;
  /**
   *
   *
   * <pre>
   * File system shares on the instance.
   * For this version, only a single file share is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.filestore.v1.FileShareConfig> getFileSharesList() {
    return fileShares_;
  }
  /**
   *
   *
   * <pre>
   * File system shares on the instance.
   * For this version, only a single file share is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.filestore.v1.FileShareConfigOrBuilder>
      getFileSharesOrBuilderList() {
    return fileShares_;
  }
  /**
   *
   *
   * <pre>
   * File system shares on the instance.
   * For this version, only a single file share is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
   */
  @java.lang.Override
  public int getFileSharesCount() {
    return fileShares_.size();
  }
  /**
   *
   *
   * <pre>
   * File system shares on the instance.
   * For this version, only a single file share is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.FileShareConfig getFileShares(int index) {
    return fileShares_.get(index);
  }
  /**
   *
   *
   * <pre>
   * File system shares on the instance.
   * For this version, only a single file share is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.FileShareConfigOrBuilder getFileSharesOrBuilder(int index) {
    return fileShares_.get(index);
  }

  public static final int NETWORKS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.filestore.v1.NetworkConfig> networks_;
  /**
   *
   *
   * <pre>
   * VPC networks to which the instance is connected.
   * For this version, only a single network is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.filestore.v1.NetworkConfig> getNetworksList() {
    return networks_;
  }
  /**
   *
   *
   * <pre>
   * VPC networks to which the instance is connected.
   * For this version, only a single network is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.filestore.v1.NetworkConfigOrBuilder>
      getNetworksOrBuilderList() {
    return networks_;
  }
  /**
   *
   *
   * <pre>
   * VPC networks to which the instance is connected.
   * For this version, only a single network is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
   */
  @java.lang.Override
  public int getNetworksCount() {
    return networks_.size();
  }
  /**
   *
   *
   * <pre>
   * VPC networks to which the instance is connected.
   * For this version, only a single network is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NetworkConfig getNetworks(int index) {
    return networks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * VPC networks to which the instance is connected.
   * For this version, only a single network is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NetworkConfigOrBuilder getNetworksOrBuilder(int index) {
    return networks_.get(index);
  }

  public static final int ETAG_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Server-specified ETag for the instance resource to prevent simultaneous
   * updates from overwriting each other.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Server-specified ETag for the instance resource to prevent simultaneous
   * updates from overwriting each other.
   * </pre>
   *
   * <code>string etag = 12;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 13;
  private com.google.protobuf.BoolValue satisfiesPzs_;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return satisfiesPzs_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getSatisfiesPzs() {
    return satisfiesPzs_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : satisfiesPzs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
    return satisfiesPzs_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 18;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * KMS key name used for data encryption.
   * </pre>
   *
   * <code>string kms_key_name = 14;</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * KMS key name used for data encryption.
   * </pre>
   *
   * <code>string kms_key_name = 14;</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUSPENSION_REASONS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> suspensionReasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.filestore.v1.Instance.SuspensionReason>
      suspensionReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.filestore.v1.Instance.SuspensionReason>() {
            public com.google.cloud.filestore.v1.Instance.SuspensionReason convert(
                java.lang.Integer from) {
              com.google.cloud.filestore.v1.Instance.SuspensionReason result =
                  com.google.cloud.filestore.v1.Instance.SuspensionReason.forNumber(from);
              return result == null
                  ? com.google.cloud.filestore.v1.Instance.SuspensionReason.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.filestore.v1.Instance.SuspensionReason>
      getSuspensionReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.filestore.v1.Instance.SuspensionReason>(
        suspensionReasons_, suspensionReasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of suspensionReasons.
   */
  @java.lang.Override
  public int getSuspensionReasonsCount() {
    return suspensionReasons_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The suspensionReasons at the given index.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.Instance.SuspensionReason getSuspensionReasons(int index) {
    return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for suspensionReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
    return suspensionReasons_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
   * state.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of suspensionReasons at the given index.
   */
  @java.lang.Override
  public int getSuspensionReasonsValue(int index) {
    return suspensionReasons_.get(index);
  }

  private int suspensionReasonsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (state_ != com.google.cloud.filestore.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, statusMessage_);
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (tier_ != com.google.cloud.filestore.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, tier_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    for (int i = 0; i < fileShares_.size(); i++) {
      output.writeMessage(10, fileShares_.get(i));
    }
    for (int i = 0; i < networks_.size(); i++) {
      output.writeMessage(11, networks_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, etag_);
    }
    if (satisfiesPzs_ != null) {
      output.writeMessage(13, getSatisfiesPzs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, kmsKeyName_);
    }
    if (getSuspensionReasonsList().size() > 0) {
      output.writeUInt32NoTag(122);
      output.writeUInt32NoTag(suspensionReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < suspensionReasons_.size(); i++) {
      output.writeEnumNoTag(suspensionReasons_.get(i));
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(18, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (state_ != com.google.cloud.filestore.v1.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, statusMessage_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (tier_ != com.google.cloud.filestore.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, tier_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    for (int i = 0; i < fileShares_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, fileShares_.get(i));
    }
    for (int i = 0; i < networks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, networks_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, etag_);
    }
    if (satisfiesPzs_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getSatisfiesPzs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, kmsKeyName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < suspensionReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(suspensionReasons_.get(i));
      }
      size += dataSize;
      if (!getSuspensionReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      suspensionReasonsMemoizedSerializedSize = dataSize;
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.filestore.v1.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.filestore.v1.Instance other = (com.google.cloud.filestore.v1.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (tier_ != other.tier_) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getFileSharesList().equals(other.getFileSharesList())) return false;
    if (!getNetworksList().equals(other.getNetworksList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (!getSatisfiesPzs().equals(other.getSatisfiesPzs())) return false;
    }
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!suspensionReasons_.equals(other.suspensionReasons_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getFileSharesCount() > 0) {
      hash = (37 * hash) + FILE_SHARES_FIELD_NUMBER;
      hash = (53 * hash) + getFileSharesList().hashCode();
    }
    if (getNetworksCount() > 0) {
      hash = (37 * hash) + NETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getNetworksList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + getSatisfiesPzs().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    if (getSuspensionReasonsCount() > 0) {
      hash = (37 * hash) + SUSPENSION_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + suspensionReasons_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Instance parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.filestore.v1.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Filestore instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.filestore.v1.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.filestore.v1.Instance)
      com.google.cloud.filestore.v1.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.filestore.v1.Instance.class,
              com.google.cloud.filestore.v1.Instance.Builder.class);
    }

    // Construct using com.google.cloud.filestore.v1.Instance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      state_ = 0;
      statusMessage_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      tier_ = 0;
      internalGetMutableLabels().clear();
      if (fileSharesBuilder_ == null) {
        fileShares_ = java.util.Collections.emptyList();
      } else {
        fileShares_ = null;
        fileSharesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (networksBuilder_ == null) {
        networks_ = java.util.Collections.emptyList();
      } else {
        networks_ = null;
        networksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      etag_ = "";
      satisfiesPzs_ = null;
      if (satisfiesPzsBuilder_ != null) {
        satisfiesPzsBuilder_.dispose();
        satisfiesPzsBuilder_ = null;
      }
      satisfiesPzi_ = false;
      kmsKeyName_ = "";
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance getDefaultInstanceForType() {
      return com.google.cloud.filestore.v1.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance build() {
      com.google.cloud.filestore.v1.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance buildPartial() {
      com.google.cloud.filestore.v1.Instance result =
          new com.google.cloud.filestore.v1.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.filestore.v1.Instance result) {
      if (fileSharesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          fileShares_ = java.util.Collections.unmodifiableList(fileShares_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.fileShares_ = fileShares_;
      } else {
        result.fileShares_ = fileSharesBuilder_.build();
      }
      if (networksBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          networks_ = java.util.Collections.unmodifiableList(networks_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.networks_ = networks_;
      } else {
        result.networks_ = networksBuilder_.build();
      }
      if (((bitField0_ & 0x00002000) != 0)) {
        suspensionReasons_ = java.util.Collections.unmodifiableList(suspensionReasons_);
        bitField0_ = (bitField0_ & ~0x00002000);
      }
      result.suspensionReasons_ = suspensionReasons_;
    }

    private void buildPartial0(com.google.cloud.filestore.v1.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tier_ = tier_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.satisfiesPzs_ =
            satisfiesPzsBuilder_ == null ? satisfiesPzs_ : satisfiesPzsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.filestore.v1.Instance) {
        return mergeFrom((com.google.cloud.filestore.v1.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.filestore.v1.Instance other) {
      if (other == com.google.cloud.filestore.v1.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (fileSharesBuilder_ == null) {
        if (!other.fileShares_.isEmpty()) {
          if (fileShares_.isEmpty()) {
            fileShares_ = other.fileShares_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureFileSharesIsMutable();
            fileShares_.addAll(other.fileShares_);
          }
          onChanged();
        }
      } else {
        if (!other.fileShares_.isEmpty()) {
          if (fileSharesBuilder_.isEmpty()) {
            fileSharesBuilder_.dispose();
            fileSharesBuilder_ = null;
            fileShares_ = other.fileShares_;
            bitField0_ = (bitField0_ & ~0x00000080);
            fileSharesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFileSharesFieldBuilder()
                    : null;
          } else {
            fileSharesBuilder_.addAllMessages(other.fileShares_);
          }
        }
      }
      if (networksBuilder_ == null) {
        if (!other.networks_.isEmpty()) {
          if (networks_.isEmpty()) {
            networks_ = other.networks_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureNetworksIsMutable();
            networks_.addAll(other.networks_);
          }
          onChanged();
        }
      } else {
        if (!other.networks_.isEmpty()) {
          if (networksBuilder_.isEmpty()) {
            networksBuilder_.dispose();
            networksBuilder_ = null;
            networks_ = other.networks_;
            bitField0_ = (bitField0_ & ~0x00000100);
            networksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNetworksFieldBuilder()
                    : null;
          } else {
            networksBuilder_.addAllMessages(other.networks_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasSatisfiesPzs()) {
        mergeSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.suspensionReasons_.isEmpty()) {
        if (suspensionReasons_.isEmpty()) {
          suspensionReasons_ = other.suspensionReasons_;
          bitField0_ = (bitField0_ & ~0x00002000);
        } else {
          ensureSuspensionReasonsIsMutable();
          suspensionReasons_.addAll(other.suspensionReasons_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
            case 50:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                tier_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 64
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.filestore.v1.FileShareConfig m =
                    input.readMessage(
                        com.google.cloud.filestore.v1.FileShareConfig.parser(), extensionRegistry);
                if (fileSharesBuilder_ == null) {
                  ensureFileSharesIsMutable();
                  fileShares_.add(m);
                } else {
                  fileSharesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.filestore.v1.NetworkConfig m =
                    input.readMessage(
                        com.google.cloud.filestore.v1.NetworkConfig.parser(), extensionRegistry);
                if (networksBuilder_ == null) {
                  ensureNetworksIsMutable();
                  networks_.add(m);
                } else {
                  networksBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getSatisfiesPzsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 114:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 114
            case 120:
              {
                int tmpRaw = input.readEnum();
                ensureSuspensionReasonsIsMutable();
                suspensionReasons_.add(tmpRaw);
                break;
              } // case 120
            case 122:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSuspensionReasonsIsMutable();
                  suspensionReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 122
            case 144:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 144
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the instance, in the format
     * `projects/{project}/locations/{location}/instances/{instance}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the instance, in the format
     * `projects/{project}/locations/{location}/instances/{instance}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the instance, in the format
     * `projects/{project}/locations/{location}/instances/{instance}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the instance, in the format
     * `projects/{project}/locations/{location}/instances/{instance}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the instance, in the format
     * `projects/{project}/locations/{location}/instances/{instance}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The description of the instance (2048 characters or less).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the instance (2048 characters or less).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of the instance (2048 characters or less).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the instance (2048 characters or less).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of the instance (2048 characters or less).
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance.State getState() {
      com.google.cloud.filestore.v1.Instance.State result =
          com.google.cloud.filestore.v1.Instance.State.forNumber(state_);
      return result == null ? com.google.cloud.filestore.v1.Instance.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.filestore.v1.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The instance state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the instance state, if available.
     * </pre>
     *
     * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the instance state, if available.
     * </pre>
     *
     * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the instance state, if available.
     * </pre>
     *
     * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the instance state, if available.
     * </pre>
     *
     * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the instance state, if available.
     * </pre>
     *
     * <code>string status_message = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * The service tier of the instance.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
     *
     * @return The enum numeric value on the wire for tier.
     */
    @java.lang.Override
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * The service tier of the instance.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
     *
     * @param value The enum numeric value on the wire for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierValue(int value) {
      tier_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service tier of the instance.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
     *
     * @return The tier.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance.Tier getTier() {
      com.google.cloud.filestore.v1.Instance.Tier result =
          com.google.cloud.filestore.v1.Instance.Tier.forNumber(tier_);
      return result == null ? com.google.cloud.filestore.v1.Instance.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The service tier of the instance.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(com.google.cloud.filestore.v1.Instance.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The service tier of the instance.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.Instance.Tier tier = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {
      bitField0_ = (bitField0_ & ~0x00000020);
      tier_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.util.List<com.google.cloud.filestore.v1.FileShareConfig> fileShares_ =
        java.util.Collections.emptyList();

    private void ensureFileSharesIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        fileShares_ =
            new java.util.ArrayList<com.google.cloud.filestore.v1.FileShareConfig>(fileShares_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.FileShareConfig,
            com.google.cloud.filestore.v1.FileShareConfig.Builder,
            com.google.cloud.filestore.v1.FileShareConfigOrBuilder>
        fileSharesBuilder_;

    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.FileShareConfig> getFileSharesList() {
      if (fileSharesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fileShares_);
      } else {
        return fileSharesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public int getFileSharesCount() {
      if (fileSharesBuilder_ == null) {
        return fileShares_.size();
      } else {
        return fileSharesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public com.google.cloud.filestore.v1.FileShareConfig getFileShares(int index) {
      if (fileSharesBuilder_ == null) {
        return fileShares_.get(index);
      } else {
        return fileSharesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder setFileShares(int index, com.google.cloud.filestore.v1.FileShareConfig value) {
      if (fileSharesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileSharesIsMutable();
        fileShares_.set(index, value);
        onChanged();
      } else {
        fileSharesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder setFileShares(
        int index, com.google.cloud.filestore.v1.FileShareConfig.Builder builderForValue) {
      if (fileSharesBuilder_ == null) {
        ensureFileSharesIsMutable();
        fileShares_.set(index, builderForValue.build());
        onChanged();
      } else {
        fileSharesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder addFileShares(com.google.cloud.filestore.v1.FileShareConfig value) {
      if (fileSharesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileSharesIsMutable();
        fileShares_.add(value);
        onChanged();
      } else {
        fileSharesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder addFileShares(int index, com.google.cloud.filestore.v1.FileShareConfig value) {
      if (fileSharesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileSharesIsMutable();
        fileShares_.add(index, value);
        onChanged();
      } else {
        fileSharesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder addFileShares(
        com.google.cloud.filestore.v1.FileShareConfig.Builder builderForValue) {
      if (fileSharesBuilder_ == null) {
        ensureFileSharesIsMutable();
        fileShares_.add(builderForValue.build());
        onChanged();
      } else {
        fileSharesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder addFileShares(
        int index, com.google.cloud.filestore.v1.FileShareConfig.Builder builderForValue) {
      if (fileSharesBuilder_ == null) {
        ensureFileSharesIsMutable();
        fileShares_.add(index, builderForValue.build());
        onChanged();
      } else {
        fileSharesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder addAllFileShares(
        java.lang.Iterable<? extends com.google.cloud.filestore.v1.FileShareConfig> values) {
      if (fileSharesBuilder_ == null) {
        ensureFileSharesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileShares_);
        onChanged();
      } else {
        fileSharesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder clearFileShares() {
      if (fileSharesBuilder_ == null) {
        fileShares_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        fileSharesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public Builder removeFileShares(int index) {
      if (fileSharesBuilder_ == null) {
        ensureFileSharesIsMutable();
        fileShares_.remove(index);
        onChanged();
      } else {
        fileSharesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public com.google.cloud.filestore.v1.FileShareConfig.Builder getFileSharesBuilder(int index) {
      return getFileSharesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public com.google.cloud.filestore.v1.FileShareConfigOrBuilder getFileSharesOrBuilder(
        int index) {
      if (fileSharesBuilder_ == null) {
        return fileShares_.get(index);
      } else {
        return fileSharesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.filestore.v1.FileShareConfigOrBuilder>
        getFileSharesOrBuilderList() {
      if (fileSharesBuilder_ != null) {
        return fileSharesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fileShares_);
      }
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public com.google.cloud.filestore.v1.FileShareConfig.Builder addFileSharesBuilder() {
      return getFileSharesFieldBuilder()
          .addBuilder(com.google.cloud.filestore.v1.FileShareConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public com.google.cloud.filestore.v1.FileShareConfig.Builder addFileSharesBuilder(int index) {
      return getFileSharesFieldBuilder()
          .addBuilder(index, com.google.cloud.filestore.v1.FileShareConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * File system shares on the instance.
     * For this version, only a single file share is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.FileShareConfig file_shares = 10;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.FileShareConfig.Builder>
        getFileSharesBuilderList() {
      return getFileSharesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.FileShareConfig,
            com.google.cloud.filestore.v1.FileShareConfig.Builder,
            com.google.cloud.filestore.v1.FileShareConfigOrBuilder>
        getFileSharesFieldBuilder() {
      if (fileSharesBuilder_ == null) {
        fileSharesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.filestore.v1.FileShareConfig,
                com.google.cloud.filestore.v1.FileShareConfig.Builder,
                com.google.cloud.filestore.v1.FileShareConfigOrBuilder>(
                fileShares_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        fileShares_ = null;
      }
      return fileSharesBuilder_;
    }

    private java.util.List<com.google.cloud.filestore.v1.NetworkConfig> networks_ =
        java.util.Collections.emptyList();

    private void ensureNetworksIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        networks_ = new java.util.ArrayList<com.google.cloud.filestore.v1.NetworkConfig>(networks_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.NetworkConfig,
            com.google.cloud.filestore.v1.NetworkConfig.Builder,
            com.google.cloud.filestore.v1.NetworkConfigOrBuilder>
        networksBuilder_;

    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.NetworkConfig> getNetworksList() {
      if (networksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(networks_);
      } else {
        return networksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public int getNetworksCount() {
      if (networksBuilder_ == null) {
        return networks_.size();
      } else {
        return networksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public com.google.cloud.filestore.v1.NetworkConfig getNetworks(int index) {
      if (networksBuilder_ == null) {
        return networks_.get(index);
      } else {
        return networksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder setNetworks(int index, com.google.cloud.filestore.v1.NetworkConfig value) {
      if (networksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworksIsMutable();
        networks_.set(index, value);
        onChanged();
      } else {
        networksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder setNetworks(
        int index, com.google.cloud.filestore.v1.NetworkConfig.Builder builderForValue) {
      if (networksBuilder_ == null) {
        ensureNetworksIsMutable();
        networks_.set(index, builderForValue.build());
        onChanged();
      } else {
        networksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder addNetworks(com.google.cloud.filestore.v1.NetworkConfig value) {
      if (networksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworksIsMutable();
        networks_.add(value);
        onChanged();
      } else {
        networksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder addNetworks(int index, com.google.cloud.filestore.v1.NetworkConfig value) {
      if (networksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworksIsMutable();
        networks_.add(index, value);
        onChanged();
      } else {
        networksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder addNetworks(
        com.google.cloud.filestore.v1.NetworkConfig.Builder builderForValue) {
      if (networksBuilder_ == null) {
        ensureNetworksIsMutable();
        networks_.add(builderForValue.build());
        onChanged();
      } else {
        networksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder addNetworks(
        int index, com.google.cloud.filestore.v1.NetworkConfig.Builder builderForValue) {
      if (networksBuilder_ == null) {
        ensureNetworksIsMutable();
        networks_.add(index, builderForValue.build());
        onChanged();
      } else {
        networksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder addAllNetworks(
        java.lang.Iterable<? extends com.google.cloud.filestore.v1.NetworkConfig> values) {
      if (networksBuilder_ == null) {
        ensureNetworksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networks_);
        onChanged();
      } else {
        networksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder clearNetworks() {
      if (networksBuilder_ == null) {
        networks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        networksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public Builder removeNetworks(int index) {
      if (networksBuilder_ == null) {
        ensureNetworksIsMutable();
        networks_.remove(index);
        onChanged();
      } else {
        networksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public com.google.cloud.filestore.v1.NetworkConfig.Builder getNetworksBuilder(int index) {
      return getNetworksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public com.google.cloud.filestore.v1.NetworkConfigOrBuilder getNetworksOrBuilder(int index) {
      if (networksBuilder_ == null) {
        return networks_.get(index);
      } else {
        return networksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public java.util.List<? extends com.google.cloud.filestore.v1.NetworkConfigOrBuilder>
        getNetworksOrBuilderList() {
      if (networksBuilder_ != null) {
        return networksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(networks_);
      }
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public com.google.cloud.filestore.v1.NetworkConfig.Builder addNetworksBuilder() {
      return getNetworksFieldBuilder()
          .addBuilder(com.google.cloud.filestore.v1.NetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public com.google.cloud.filestore.v1.NetworkConfig.Builder addNetworksBuilder(int index) {
      return getNetworksFieldBuilder()
          .addBuilder(index, com.google.cloud.filestore.v1.NetworkConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * VPC networks to which the instance is connected.
     * For this version, only a single network is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig networks = 11;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.NetworkConfig.Builder>
        getNetworksBuilderList() {
      return getNetworksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.NetworkConfig,
            com.google.cloud.filestore.v1.NetworkConfig.Builder,
            com.google.cloud.filestore.v1.NetworkConfigOrBuilder>
        getNetworksFieldBuilder() {
      if (networksBuilder_ == null) {
        networksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.filestore.v1.NetworkConfig,
                com.google.cloud.filestore.v1.NetworkConfig.Builder,
                com.google.cloud.filestore.v1.NetworkConfigOrBuilder>(
                networks_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        networks_ = null;
      }
      return networksBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Server-specified ETag for the instance resource to prevent simultaneous
     * updates from overwriting each other.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Server-specified ETag for the instance resource to prevent simultaneous
     * updates from overwriting each other.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Server-specified ETag for the instance resource to prevent simultaneous
     * updates from overwriting each other.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Server-specified ETag for the instance resource to prevent simultaneous
     * updates from overwriting each other.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Server-specified ETag for the instance resource to prevent simultaneous
     * updates from overwriting each other.
     * </pre>
     *
     * <code>string etag = 12;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue satisfiesPzs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        satisfiesPzsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The satisfiesPzs.
     */
    public com.google.protobuf.BoolValue getSatisfiesPzs() {
      if (satisfiesPzsBuilder_ == null) {
        return satisfiesPzs_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : satisfiesPzs_;
      } else {
        return satisfiesPzsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSatisfiesPzs(com.google.protobuf.BoolValue value) {
      if (satisfiesPzsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        satisfiesPzs_ = value;
      } else {
        satisfiesPzsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSatisfiesPzs(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (satisfiesPzsBuilder_ == null) {
        satisfiesPzs_ = builderForValue.build();
      } else {
        satisfiesPzsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSatisfiesPzs(com.google.protobuf.BoolValue value) {
      if (satisfiesPzsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && satisfiesPzs_ != null
            && satisfiesPzs_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getSatisfiesPzsBuilder().mergeFrom(value);
        } else {
          satisfiesPzs_ = value;
        }
      } else {
        satisfiesPzsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000400);
      satisfiesPzs_ = null;
      if (satisfiesPzsBuilder_ != null) {
        satisfiesPzsBuilder_.dispose();
        satisfiesPzsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.BoolValue.Builder getSatisfiesPzsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getSatisfiesPzsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
      if (satisfiesPzsBuilder_ != null) {
        return satisfiesPzsBuilder_.getMessageOrBuilder();
      } else {
        return satisfiesPzs_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : satisfiesPzs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getSatisfiesPzsFieldBuilder() {
      if (satisfiesPzsBuilder_ == null) {
        satisfiesPzsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getSatisfiesPzs(), getParentForChildren(), isClean());
        satisfiesPzs_ = null;
      }
      return satisfiesPzsBuilder_;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00000800);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key_name = 14;</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key_name = 14;</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key_name = 14;</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key_name = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key_name = 14;</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> suspensionReasons_ =
        java.util.Collections.emptyList();

    private void ensureSuspensionReasonsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        suspensionReasons_ = new java.util.ArrayList<java.lang.Integer>(suspensionReasons_);
        bitField0_ |= 0x00002000;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the suspensionReasons.
     */
    public java.util.List<com.google.cloud.filestore.v1.Instance.SuspensionReason>
        getSuspensionReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.filestore.v1.Instance.SuspensionReason>(
          suspensionReasons_, suspensionReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of suspensionReasons.
     */
    public int getSuspensionReasonsCount() {
      return suspensionReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The suspensionReasons at the given index.
     */
    public com.google.cloud.filestore.v1.Instance.SuspensionReason getSuspensionReasons(int index) {
      return suspensionReasons_converter_.convert(suspensionReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasons(
        int index, com.google.cloud.filestore.v1.Instance.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasons(
        com.google.cloud.filestore.v1.Instance.SuspensionReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasons(
        java.lang.Iterable<? extends com.google.cloud.filestore.v1.Instance.SuspensionReason>
            values) {
      ensureSuspensionReasonsIsMutable();
      for (com.google.cloud.filestore.v1.Instance.SuspensionReason value : values) {
        suspensionReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspensionReasons() {
      suspensionReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for suspensionReasons.
     */
    public java.util.List<java.lang.Integer> getSuspensionReasonsValueList() {
      return java.util.Collections.unmodifiableList(suspensionReasons_);
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of suspensionReasons at the given index.
     */
    public int getSuspensionReasonsValue(int index) {
      return suspensionReasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for suspensionReasons to set.
     * @return This builder for chaining.
     */
    public Builder setSuspensionReasonsValue(int index, int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addSuspensionReasonsValue(int value) {
      ensureSuspensionReasonsIsMutable();
      suspensionReasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Field indicates all the reasons the instance is in "SUSPENDED"
     * state.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.filestore.v1.Instance.SuspensionReason suspension_reasons = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The enum numeric values on the wire for suspensionReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllSuspensionReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSuspensionReasonsIsMutable();
      for (int value : values) {
        suspensionReasons_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.filestore.v1.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.filestore.v1.Instance)
  private static final com.google.cloud.filestore.v1.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.filestore.v1.Instance();
  }

  public static com.google.cloud.filestore.v1.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.filestore.v1.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
