/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

package com.google.cloud.filestore.v1;

/**
 *
 *
 * <pre>
 * NFS export options specifications.
 * </pre>
 *
 * Protobuf type {@code google.cloud.filestore.v1.NfsExportOptions}
 */
public final class NfsExportOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.filestore.v1.NfsExportOptions)
    NfsExportOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NfsExportOptions.newBuilder() to construct.
  private NfsExportOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NfsExportOptions() {
    ipRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
    accessMode_ = 0;
    squashMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NfsExportOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_NfsExportOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_NfsExportOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.filestore.v1.NfsExportOptions.class,
            com.google.cloud.filestore.v1.NfsExportOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The access mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.NfsExportOptions.AccessMode}
   */
  public enum AccessMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * AccessMode not set.
     * </pre>
     *
     * <code>ACCESS_MODE_UNSPECIFIED = 0;</code>
     */
    ACCESS_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The client can only read the file share.
     * </pre>
     *
     * <code>READ_ONLY = 1;</code>
     */
    READ_ONLY(1),
    /**
     *
     *
     * <pre>
     * The client can read and write the file share (default).
     * </pre>
     *
     * <code>READ_WRITE = 2;</code>
     */
    READ_WRITE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * AccessMode not set.
     * </pre>
     *
     * <code>ACCESS_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int ACCESS_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The client can only read the file share.
     * </pre>
     *
     * <code>READ_ONLY = 1;</code>
     */
    public static final int READ_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The client can read and write the file share (default).
     * </pre>
     *
     * <code>READ_WRITE = 2;</code>
     */
    public static final int READ_WRITE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AccessMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AccessMode forNumber(int value) {
      switch (value) {
        case 0:
          return ACCESS_MODE_UNSPECIFIED;
        case 1:
          return READ_ONLY;
        case 2:
          return READ_WRITE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AccessMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AccessMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AccessMode>() {
          public AccessMode findValueByNumber(int number) {
            return AccessMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.NfsExportOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final AccessMode[] VALUES = values();

    public static AccessMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AccessMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.NfsExportOptions.AccessMode)
  }

  /**
   *
   *
   * <pre>
   * The squash mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.NfsExportOptions.SquashMode}
   */
  public enum SquashMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * SquashMode not set.
     * </pre>
     *
     * <code>SQUASH_MODE_UNSPECIFIED = 0;</code>
     */
    SQUASH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The Root user has root access to the file share (default).
     * </pre>
     *
     * <code>NO_ROOT_SQUASH = 1;</code>
     */
    NO_ROOT_SQUASH(1),
    /**
     *
     *
     * <pre>
     * The Root user has squashed access to the anonymous uid/gid.
     * </pre>
     *
     * <code>ROOT_SQUASH = 2;</code>
     */
    ROOT_SQUASH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * SquashMode not set.
     * </pre>
     *
     * <code>SQUASH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SQUASH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The Root user has root access to the file share (default).
     * </pre>
     *
     * <code>NO_ROOT_SQUASH = 1;</code>
     */
    public static final int NO_ROOT_SQUASH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The Root user has squashed access to the anonymous uid/gid.
     * </pre>
     *
     * <code>ROOT_SQUASH = 2;</code>
     */
    public static final int ROOT_SQUASH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SquashMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SquashMode forNumber(int value) {
      switch (value) {
        case 0:
          return SQUASH_MODE_UNSPECIFIED;
        case 1:
          return NO_ROOT_SQUASH;
        case 2:
          return ROOT_SQUASH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SquashMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SquashMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SquashMode>() {
          public SquashMode findValueByNumber(int number) {
            return SquashMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.NfsExportOptions.getDescriptor().getEnumTypes().get(1);
    }

    private static final SquashMode[] VALUES = values();

    public static SquashMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SquashMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.NfsExportOptions.SquashMode)
  }

  public static final int IP_RANGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ipRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of either an IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
   * file share.
   * Overlapping IP ranges are not allowed, both within and across
   * NfsExportOptions. An error will be returned.
   * The limit is 64 IP ranges/addresses for each FileShareConfig among all
   * NfsExportOptions.
   * </pre>
   *
   * <code>repeated string ip_ranges = 1;</code>
   *
   * @return A list containing the ipRanges.
   */
  public com.google.protobuf.ProtocolStringList getIpRangesList() {
    return ipRanges_;
  }
  /**
   *
   *
   * <pre>
   * List of either an IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
   * file share.
   * Overlapping IP ranges are not allowed, both within and across
   * NfsExportOptions. An error will be returned.
   * The limit is 64 IP ranges/addresses for each FileShareConfig among all
   * NfsExportOptions.
   * </pre>
   *
   * <code>repeated string ip_ranges = 1;</code>
   *
   * @return The count of ipRanges.
   */
  public int getIpRangesCount() {
    return ipRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * List of either an IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
   * file share.
   * Overlapping IP ranges are not allowed, both within and across
   * NfsExportOptions. An error will be returned.
   * The limit is 64 IP ranges/addresses for each FileShareConfig among all
   * NfsExportOptions.
   * </pre>
   *
   * <code>repeated string ip_ranges = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The ipRanges at the given index.
   */
  public java.lang.String getIpRanges(int index) {
    return ipRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of either an IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
   * file share.
   * Overlapping IP ranges are not allowed, both within and across
   * NfsExportOptions. An error will be returned.
   * The limit is 64 IP ranges/addresses for each FileShareConfig among all
   * NfsExportOptions.
   * </pre>
   *
   * <code>repeated string ip_ranges = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipRanges at the given index.
   */
  public com.google.protobuf.ByteString getIpRangesBytes(int index) {
    return ipRanges_.getByteString(index);
  }

  public static final int ACCESS_MODE_FIELD_NUMBER = 2;
  private int accessMode_ = 0;
  /**
   *
   *
   * <pre>
   * Either READ_ONLY, for allowing only read requests on the exported
   * directory, or READ_WRITE, for allowing both read and write requests.
   * The default is READ_WRITE.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
   *
   * @return The enum numeric value on the wire for accessMode.
   */
  @java.lang.Override
  public int getAccessModeValue() {
    return accessMode_;
  }
  /**
   *
   *
   * <pre>
   * Either READ_ONLY, for allowing only read requests on the exported
   * directory, or READ_WRITE, for allowing both read and write requests.
   * The default is READ_WRITE.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
   *
   * @return The accessMode.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NfsExportOptions.AccessMode getAccessMode() {
    com.google.cloud.filestore.v1.NfsExportOptions.AccessMode result =
        com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.forNumber(accessMode_);
    return result == null
        ? com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.UNRECOGNIZED
        : result;
  }

  public static final int SQUASH_MODE_FIELD_NUMBER = 3;
  private int squashMode_ = 0;
  /**
   *
   *
   * <pre>
   * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
   * or ROOT_SQUASH, for not allowing root access. The default is
   * NO_ROOT_SQUASH.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
   *
   * @return The enum numeric value on the wire for squashMode.
   */
  @java.lang.Override
  public int getSquashModeValue() {
    return squashMode_;
  }
  /**
   *
   *
   * <pre>
   * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
   * or ROOT_SQUASH, for not allowing root access. The default is
   * NO_ROOT_SQUASH.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
   *
   * @return The squashMode.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NfsExportOptions.SquashMode getSquashMode() {
    com.google.cloud.filestore.v1.NfsExportOptions.SquashMode result =
        com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.forNumber(squashMode_);
    return result == null
        ? com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.UNRECOGNIZED
        : result;
  }

  public static final int ANON_UID_FIELD_NUMBER = 4;
  private long anonUid_ = 0L;
  /**
   *
   *
   * <pre>
   * An integer representing the anonymous user id with a default value of
   * 65534.
   * Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
   * returned if this field is specified for other squash_mode settings.
   * </pre>
   *
   * <code>int64 anon_uid = 4;</code>
   *
   * @return The anonUid.
   */
  @java.lang.Override
  public long getAnonUid() {
    return anonUid_;
  }

  public static final int ANON_GID_FIELD_NUMBER = 5;
  private long anonGid_ = 0L;
  /**
   *
   *
   * <pre>
   * An integer representing the anonymous group id with a default value of
   * 65534.
   * Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
   * returned if this field is specified for other squash_mode settings.
   * </pre>
   *
   * <code>int64 anon_gid = 5;</code>
   *
   * @return The anonGid.
   */
  @java.lang.Override
  public long getAnonGid() {
    return anonGid_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < ipRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, ipRanges_.getRaw(i));
    }
    if (accessMode_
        != com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.ACCESS_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, accessMode_);
    }
    if (squashMode_
        != com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.SQUASH_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, squashMode_);
    }
    if (anonUid_ != 0L) {
      output.writeInt64(4, anonUid_);
    }
    if (anonGid_ != 0L) {
      output.writeInt64(5, anonGid_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < ipRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(ipRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIpRangesList().size();
    }
    if (accessMode_
        != com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.ACCESS_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, accessMode_);
    }
    if (squashMode_
        != com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.SQUASH_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, squashMode_);
    }
    if (anonUid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, anonUid_);
    }
    if (anonGid_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, anonGid_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.filestore.v1.NfsExportOptions)) {
      return super.equals(obj);
    }
    com.google.cloud.filestore.v1.NfsExportOptions other =
        (com.google.cloud.filestore.v1.NfsExportOptions) obj;

    if (!getIpRangesList().equals(other.getIpRangesList())) return false;
    if (accessMode_ != other.accessMode_) return false;
    if (squashMode_ != other.squashMode_) return false;
    if (getAnonUid() != other.getAnonUid()) return false;
    if (getAnonGid() != other.getAnonGid()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIpRangesCount() > 0) {
      hash = (37 * hash) + IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getIpRangesList().hashCode();
    }
    hash = (37 * hash) + ACCESS_MODE_FIELD_NUMBER;
    hash = (53 * hash) + accessMode_;
    hash = (37 * hash) + SQUASH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + squashMode_;
    hash = (37 * hash) + ANON_UID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAnonUid());
    hash = (37 * hash) + ANON_GID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAnonGid());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.filestore.v1.NfsExportOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * NFS export options specifications.
   * </pre>
   *
   * Protobuf type {@code google.cloud.filestore.v1.NfsExportOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.filestore.v1.NfsExportOptions)
      com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NfsExportOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NfsExportOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.filestore.v1.NfsExportOptions.class,
              com.google.cloud.filestore.v1.NfsExportOptions.Builder.class);
    }

    // Construct using com.google.cloud.filestore.v1.NfsExportOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      ipRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      accessMode_ = 0;
      squashMode_ = 0;
      anonUid_ = 0L;
      anonGid_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NfsExportOptions_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NfsExportOptions getDefaultInstanceForType() {
      return com.google.cloud.filestore.v1.NfsExportOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NfsExportOptions build() {
      com.google.cloud.filestore.v1.NfsExportOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NfsExportOptions buildPartial() {
      com.google.cloud.filestore.v1.NfsExportOptions result =
          new com.google.cloud.filestore.v1.NfsExportOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.filestore.v1.NfsExportOptions result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        ipRanges_.makeImmutable();
        result.ipRanges_ = ipRanges_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.accessMode_ = accessMode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.squashMode_ = squashMode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.anonUid_ = anonUid_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.anonGid_ = anonGid_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.filestore.v1.NfsExportOptions) {
        return mergeFrom((com.google.cloud.filestore.v1.NfsExportOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.filestore.v1.NfsExportOptions other) {
      if (other == com.google.cloud.filestore.v1.NfsExportOptions.getDefaultInstance()) return this;
      if (!other.ipRanges_.isEmpty()) {
        if (ipRanges_.isEmpty()) {
          ipRanges_ = other.ipRanges_;
          bitField0_ |= 0x00000001;
        } else {
          ensureIpRangesIsMutable();
          ipRanges_.addAll(other.ipRanges_);
        }
        onChanged();
      }
      if (other.accessMode_ != 0) {
        setAccessModeValue(other.getAccessModeValue());
      }
      if (other.squashMode_ != 0) {
        setSquashModeValue(other.getSquashModeValue());
      }
      if (other.getAnonUid() != 0L) {
        setAnonUid(other.getAnonUid());
      }
      if (other.getAnonGid() != 0L) {
        setAnonGid(other.getAnonGid());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIpRangesIsMutable();
                ipRanges_.add(s);
                break;
              } // case 10
            case 16:
              {
                accessMode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                squashMode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                anonUid_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                anonGid_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList ipRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIpRangesIsMutable() {
      if (!ipRanges_.isModifiable()) {
        ipRanges_ = new com.google.protobuf.LazyStringArrayList(ipRanges_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @return A list containing the ipRanges.
     */
    public com.google.protobuf.ProtocolStringList getIpRangesList() {
      ipRanges_.makeImmutable();
      return ipRanges_;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @return The count of ipRanges.
     */
    public int getIpRangesCount() {
      return ipRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The ipRanges at the given index.
     */
    public java.lang.String getIpRanges(int index) {
      return ipRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipRanges at the given index.
     */
    public com.google.protobuf.ByteString getIpRangesBytes(int index) {
      return ipRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The ipRanges to set.
     * @return This builder for chaining.
     */
    public Builder setIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpRangesIsMutable();
      ipRanges_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param value The ipRanges to add.
     * @return This builder for chaining.
     */
    public Builder addIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpRangesIsMutable();
      ipRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param values The ipRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipRanges_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpRanges() {
      ipRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of either an IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
     * file share.
     * Overlapping IP ranges are not allowed, both within and across
     * NfsExportOptions. An error will be returned.
     * The limit is 64 IP ranges/addresses for each FileShareConfig among all
     * NfsExportOptions.
     * </pre>
     *
     * <code>repeated string ip_ranges = 1;</code>
     *
     * @param value The bytes of the ipRanges to add.
     * @return This builder for chaining.
     */
    public Builder addIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIpRangesIsMutable();
      ipRanges_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int accessMode_ = 0;
    /**
     *
     *
     * <pre>
     * Either READ_ONLY, for allowing only read requests on the exported
     * directory, or READ_WRITE, for allowing both read and write requests.
     * The default is READ_WRITE.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
     *
     * @return The enum numeric value on the wire for accessMode.
     */
    @java.lang.Override
    public int getAccessModeValue() {
      return accessMode_;
    }
    /**
     *
     *
     * <pre>
     * Either READ_ONLY, for allowing only read requests on the exported
     * directory, or READ_WRITE, for allowing both read and write requests.
     * The default is READ_WRITE.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
     *
     * @param value The enum numeric value on the wire for accessMode to set.
     * @return This builder for chaining.
     */
    public Builder setAccessModeValue(int value) {
      accessMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Either READ_ONLY, for allowing only read requests on the exported
     * directory, or READ_WRITE, for allowing both read and write requests.
     * The default is READ_WRITE.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
     *
     * @return The accessMode.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.NfsExportOptions.AccessMode getAccessMode() {
      com.google.cloud.filestore.v1.NfsExportOptions.AccessMode result =
          com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.forNumber(accessMode_);
      return result == null
          ? com.google.cloud.filestore.v1.NfsExportOptions.AccessMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Either READ_ONLY, for allowing only read requests on the exported
     * directory, or READ_WRITE, for allowing both read and write requests.
     * The default is READ_WRITE.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
     *
     * @param value The accessMode to set.
     * @return This builder for chaining.
     */
    public Builder setAccessMode(com.google.cloud.filestore.v1.NfsExportOptions.AccessMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      accessMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Either READ_ONLY, for allowing only read requests on the exported
     * directory, or READ_WRITE, for allowing both read and write requests.
     * The default is READ_WRITE.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.AccessMode access_mode = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessMode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      accessMode_ = 0;
      onChanged();
      return this;
    }

    private int squashMode_ = 0;
    /**
     *
     *
     * <pre>
     * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
     * or ROOT_SQUASH, for not allowing root access. The default is
     * NO_ROOT_SQUASH.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
     *
     * @return The enum numeric value on the wire for squashMode.
     */
    @java.lang.Override
    public int getSquashModeValue() {
      return squashMode_;
    }
    /**
     *
     *
     * <pre>
     * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
     * or ROOT_SQUASH, for not allowing root access. The default is
     * NO_ROOT_SQUASH.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
     *
     * @param value The enum numeric value on the wire for squashMode to set.
     * @return This builder for chaining.
     */
    public Builder setSquashModeValue(int value) {
      squashMode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
     * or ROOT_SQUASH, for not allowing root access. The default is
     * NO_ROOT_SQUASH.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
     *
     * @return The squashMode.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.NfsExportOptions.SquashMode getSquashMode() {
      com.google.cloud.filestore.v1.NfsExportOptions.SquashMode result =
          com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.forNumber(squashMode_);
      return result == null
          ? com.google.cloud.filestore.v1.NfsExportOptions.SquashMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
     * or ROOT_SQUASH, for not allowing root access. The default is
     * NO_ROOT_SQUASH.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
     *
     * @param value The squashMode to set.
     * @return This builder for chaining.
     */
    public Builder setSquashMode(com.google.cloud.filestore.v1.NfsExportOptions.SquashMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      squashMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
     * or ROOT_SQUASH, for not allowing root access. The default is
     * NO_ROOT_SQUASH.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NfsExportOptions.SquashMode squash_mode = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSquashMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      squashMode_ = 0;
      onChanged();
      return this;
    }

    private long anonUid_;
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous user id with a default value of
     * 65534.
     * Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_uid = 4;</code>
     *
     * @return The anonUid.
     */
    @java.lang.Override
    public long getAnonUid() {
      return anonUid_;
    }
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous user id with a default value of
     * 65534.
     * Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_uid = 4;</code>
     *
     * @param value The anonUid to set.
     * @return This builder for chaining.
     */
    public Builder setAnonUid(long value) {

      anonUid_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous user id with a default value of
     * 65534.
     * Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_uid = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnonUid() {
      bitField0_ = (bitField0_ & ~0x00000008);
      anonUid_ = 0L;
      onChanged();
      return this;
    }

    private long anonGid_;
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous group id with a default value of
     * 65534.
     * Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_gid = 5;</code>
     *
     * @return The anonGid.
     */
    @java.lang.Override
    public long getAnonGid() {
      return anonGid_;
    }
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous group id with a default value of
     * 65534.
     * Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_gid = 5;</code>
     *
     * @param value The anonGid to set.
     * @return This builder for chaining.
     */
    public Builder setAnonGid(long value) {

      anonGid_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An integer representing the anonymous group id with a default value of
     * 65534.
     * Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
     * returned if this field is specified for other squash_mode settings.
     * </pre>
     *
     * <code>int64 anon_gid = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnonGid() {
      bitField0_ = (bitField0_ & ~0x00000010);
      anonGid_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.filestore.v1.NfsExportOptions)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.filestore.v1.NfsExportOptions)
  private static final com.google.cloud.filestore.v1.NfsExportOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.filestore.v1.NfsExportOptions();
  }

  public static com.google.cloud.filestore.v1.NfsExportOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NfsExportOptions> PARSER =
      new com.google.protobuf.AbstractParser<NfsExportOptions>() {
        @java.lang.Override
        public NfsExportOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NfsExportOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NfsExportOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.filestore.v1.NfsExportOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
