/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.filestore.v1;

/**
 *
 *
 * <pre>
 * File share configuration for the instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.filestore.v1.FileShareConfig}
 */
public final class FileShareConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.filestore.v1.FileShareConfig)
    FileShareConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FileShareConfig.newBuilder() to construct.
  private FileShareConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FileShareConfig() {
    name_ = "";
    nfsExportOptions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FileShareConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_FileShareConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_FileShareConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.filestore.v1.FileShareConfig.class,
            com.google.cloud.filestore.v1.FileShareConfig.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_BACKUP(8),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 8:
          return SOURCE_BACKUP;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the file share. Must use 1-16 characters for the
   * basic service tier and 1-63 characters for all other service tiers.
   * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
   * start with a letter. Immutable.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the file share. Must use 1-16 characters for the
   * basic service tier and 1-63 characters for all other service tiers.
   * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
   * start with a letter. Immutable.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAPACITY_GB_FIELD_NUMBER = 2;
  private long capacityGb_ = 0L;
  /**
   *
   *
   * <pre>
   * File share capacity in gigabytes (GB).
   * Filestore defines 1 GB as 1024^3 bytes.
   * </pre>
   *
   * <code>int64 capacity_gb = 2;</code>
   *
   * @return The capacityGb.
   */
  @java.lang.Override
  public long getCapacityGb() {
    return capacityGb_;
  }

  public static final int SOURCE_BACKUP_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The resource name of the backup, in the format
   * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
   * that this file share has been restored from.
   * </pre>
   *
   * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the sourceBackup field is set.
   */
  public boolean hasSourceBackup() {
    return sourceCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The resource name of the backup, in the format
   * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
   * that this file share has been restored from.
   * </pre>
   *
   * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The sourceBackup.
   */
  public java.lang.String getSourceBackup() {
    java.lang.Object ref = "";
    if (sourceCase_ == 8) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (sourceCase_ == 8) {
        source_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the backup, in the format
   * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
   * that this file share has been restored from.
   * </pre>
   *
   * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for sourceBackup.
   */
  public com.google.protobuf.ByteString getSourceBackupBytes() {
    java.lang.Object ref = "";
    if (sourceCase_ == 8) {
      ref = source_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (sourceCase_ == 8) {
        source_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NFS_EXPORT_OPTIONS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.filestore.v1.NfsExportOptions> nfsExportOptions_;
  /**
   *
   *
   * <pre>
   * Nfs Export Options.
   * There is a limit of 10 export options per file share.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.filestore.v1.NfsExportOptions> getNfsExportOptionsList() {
    return nfsExportOptions_;
  }
  /**
   *
   *
   * <pre>
   * Nfs Export Options.
   * There is a limit of 10 export options per file share.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder>
      getNfsExportOptionsOrBuilderList() {
    return nfsExportOptions_;
  }
  /**
   *
   *
   * <pre>
   * Nfs Export Options.
   * There is a limit of 10 export options per file share.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
   */
  @java.lang.Override
  public int getNfsExportOptionsCount() {
    return nfsExportOptions_.size();
  }
  /**
   *
   *
   * <pre>
   * Nfs Export Options.
   * There is a limit of 10 export options per file share.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NfsExportOptions getNfsExportOptions(int index) {
    return nfsExportOptions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Nfs Export Options.
   * There is a limit of 10 export options per file share.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder getNfsExportOptionsOrBuilder(
      int index) {
    return nfsExportOptions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (capacityGb_ != 0L) {
      output.writeInt64(2, capacityGb_);
    }
    for (int i = 0; i < nfsExportOptions_.size(); i++) {
      output.writeMessage(7, nfsExportOptions_.get(i));
    }
    if (sourceCase_ == 8) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (capacityGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, capacityGb_);
    }
    for (int i = 0; i < nfsExportOptions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, nfsExportOptions_.get(i));
    }
    if (sourceCase_ == 8) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.filestore.v1.FileShareConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.filestore.v1.FileShareConfig other =
        (com.google.cloud.filestore.v1.FileShareConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (getCapacityGb() != other.getCapacityGb()) return false;
    if (!getNfsExportOptionsList().equals(other.getNfsExportOptionsList())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 8:
        if (!getSourceBackup().equals(other.getSourceBackup())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CAPACITY_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCapacityGb());
    if (getNfsExportOptionsCount() > 0) {
      hash = (37 * hash) + NFS_EXPORT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getNfsExportOptionsList().hashCode();
    }
    switch (sourceCase_) {
      case 8:
        hash = (37 * hash) + SOURCE_BACKUP_FIELD_NUMBER;
        hash = (53 * hash) + getSourceBackup().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.FileShareConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.filestore.v1.FileShareConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * File share configuration for the instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.filestore.v1.FileShareConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.filestore.v1.FileShareConfig)
      com.google.cloud.filestore.v1.FileShareConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_FileShareConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_FileShareConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.filestore.v1.FileShareConfig.class,
              com.google.cloud.filestore.v1.FileShareConfig.Builder.class);
    }

    // Construct using com.google.cloud.filestore.v1.FileShareConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      capacityGb_ = 0L;
      if (nfsExportOptionsBuilder_ == null) {
        nfsExportOptions_ = java.util.Collections.emptyList();
      } else {
        nfsExportOptions_ = null;
        nfsExportOptionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_FileShareConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.FileShareConfig getDefaultInstanceForType() {
      return com.google.cloud.filestore.v1.FileShareConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.FileShareConfig build() {
      com.google.cloud.filestore.v1.FileShareConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.FileShareConfig buildPartial() {
      com.google.cloud.filestore.v1.FileShareConfig result =
          new com.google.cloud.filestore.v1.FileShareConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.filestore.v1.FileShareConfig result) {
      if (nfsExportOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          nfsExportOptions_ = java.util.Collections.unmodifiableList(nfsExportOptions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.nfsExportOptions_ = nfsExportOptions_;
      } else {
        result.nfsExportOptions_ = nfsExportOptionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.filestore.v1.FileShareConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.capacityGb_ = capacityGb_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.filestore.v1.FileShareConfig result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.filestore.v1.FileShareConfig) {
        return mergeFrom((com.google.cloud.filestore.v1.FileShareConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.filestore.v1.FileShareConfig other) {
      if (other == com.google.cloud.filestore.v1.FileShareConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getCapacityGb() != 0L) {
        setCapacityGb(other.getCapacityGb());
      }
      if (nfsExportOptionsBuilder_ == null) {
        if (!other.nfsExportOptions_.isEmpty()) {
          if (nfsExportOptions_.isEmpty()) {
            nfsExportOptions_ = other.nfsExportOptions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureNfsExportOptionsIsMutable();
            nfsExportOptions_.addAll(other.nfsExportOptions_);
          }
          onChanged();
        }
      } else {
        if (!other.nfsExportOptions_.isEmpty()) {
          if (nfsExportOptionsBuilder_.isEmpty()) {
            nfsExportOptionsBuilder_.dispose();
            nfsExportOptionsBuilder_ = null;
            nfsExportOptions_ = other.nfsExportOptions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            nfsExportOptionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNfsExportOptionsFieldBuilder()
                    : null;
          } else {
            nfsExportOptionsBuilder_.addAllMessages(other.nfsExportOptions_);
          }
        }
      }
      switch (other.getSourceCase()) {
        case SOURCE_BACKUP:
          {
            sourceCase_ = 8;
            source_ = other.source_;
            onChanged();
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                capacityGb_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 58:
              {
                com.google.cloud.filestore.v1.NfsExportOptions m =
                    input.readMessage(
                        com.google.cloud.filestore.v1.NfsExportOptions.parser(), extensionRegistry);
                if (nfsExportOptionsBuilder_ == null) {
                  ensureNfsExportOptionsIsMutable();
                  nfsExportOptions_.add(m);
                } else {
                  nfsExportOptionsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                sourceCase_ = 8;
                source_ = s;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the file share. Must use 1-16 characters for the
     * basic service tier and 1-63 characters for all other service tiers.
     * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
     * start with a letter. Immutable.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the file share. Must use 1-16 characters for the
     * basic service tier and 1-63 characters for all other service tiers.
     * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
     * start with a letter. Immutable.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the file share. Must use 1-16 characters for the
     * basic service tier and 1-63 characters for all other service tiers.
     * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
     * start with a letter. Immutable.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the file share. Must use 1-16 characters for the
     * basic service tier and 1-63 characters for all other service tiers.
     * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
     * start with a letter. Immutable.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the file share. Must use 1-16 characters for the
     * basic service tier and 1-63 characters for all other service tiers.
     * Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
     * start with a letter. Immutable.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long capacityGb_;
    /**
     *
     *
     * <pre>
     * File share capacity in gigabytes (GB).
     * Filestore defines 1 GB as 1024^3 bytes.
     * </pre>
     *
     * <code>int64 capacity_gb = 2;</code>
     *
     * @return The capacityGb.
     */
    @java.lang.Override
    public long getCapacityGb() {
      return capacityGb_;
    }
    /**
     *
     *
     * <pre>
     * File share capacity in gigabytes (GB).
     * Filestore defines 1 GB as 1024^3 bytes.
     * </pre>
     *
     * <code>int64 capacity_gb = 2;</code>
     *
     * @param value The capacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setCapacityGb(long value) {

      capacityGb_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File share capacity in gigabytes (GB).
     * Filestore defines 1 GB as 1024^3 bytes.
     * </pre>
     *
     * <code>int64 capacity_gb = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000002);
      capacityGb_ = 0L;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the sourceBackup field is set.
     */
    @java.lang.Override
    public boolean hasSourceBackup() {
      return sourceCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The sourceBackup.
     */
    @java.lang.Override
    public java.lang.String getSourceBackup() {
      java.lang.Object ref = "";
      if (sourceCase_ == 8) {
        ref = source_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceCase_ == 8) {
          source_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for sourceBackup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceBackupBytes() {
      java.lang.Object ref = "";
      if (sourceCase_ == 8) {
        ref = source_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceCase_ == 8) {
          source_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The sourceBackup to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceCase_ = 8;
      source_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceBackup() {
      if (sourceCase_ == 8) {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
     * that this file share has been restored from.
     * </pre>
     *
     * <code>string source_backup = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for sourceBackup to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceCase_ = 8;
      source_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.filestore.v1.NfsExportOptions> nfsExportOptions_ =
        java.util.Collections.emptyList();

    private void ensureNfsExportOptionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        nfsExportOptions_ =
            new java.util.ArrayList<com.google.cloud.filestore.v1.NfsExportOptions>(
                nfsExportOptions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.NfsExportOptions,
            com.google.cloud.filestore.v1.NfsExportOptions.Builder,
            com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder>
        nfsExportOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.NfsExportOptions>
        getNfsExportOptionsList() {
      if (nfsExportOptionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nfsExportOptions_);
      } else {
        return nfsExportOptionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public int getNfsExportOptionsCount() {
      if (nfsExportOptionsBuilder_ == null) {
        return nfsExportOptions_.size();
      } else {
        return nfsExportOptionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public com.google.cloud.filestore.v1.NfsExportOptions getNfsExportOptions(int index) {
      if (nfsExportOptionsBuilder_ == null) {
        return nfsExportOptions_.get(index);
      } else {
        return nfsExportOptionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder setNfsExportOptions(
        int index, com.google.cloud.filestore.v1.NfsExportOptions value) {
      if (nfsExportOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.set(index, value);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder setNfsExportOptions(
        int index, com.google.cloud.filestore.v1.NfsExportOptions.Builder builderForValue) {
      if (nfsExportOptionsBuilder_ == null) {
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.set(index, builderForValue.build());
        onChanged();
      } else {
        nfsExportOptionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder addNfsExportOptions(com.google.cloud.filestore.v1.NfsExportOptions value) {
      if (nfsExportOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.add(value);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder addNfsExportOptions(
        int index, com.google.cloud.filestore.v1.NfsExportOptions value) {
      if (nfsExportOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.add(index, value);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder addNfsExportOptions(
        com.google.cloud.filestore.v1.NfsExportOptions.Builder builderForValue) {
      if (nfsExportOptionsBuilder_ == null) {
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.add(builderForValue.build());
        onChanged();
      } else {
        nfsExportOptionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder addNfsExportOptions(
        int index, com.google.cloud.filestore.v1.NfsExportOptions.Builder builderForValue) {
      if (nfsExportOptionsBuilder_ == null) {
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.add(index, builderForValue.build());
        onChanged();
      } else {
        nfsExportOptionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder addAllNfsExportOptions(
        java.lang.Iterable<? extends com.google.cloud.filestore.v1.NfsExportOptions> values) {
      if (nfsExportOptionsBuilder_ == null) {
        ensureNfsExportOptionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nfsExportOptions_);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder clearNfsExportOptions() {
      if (nfsExportOptionsBuilder_ == null) {
        nfsExportOptions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public Builder removeNfsExportOptions(int index) {
      if (nfsExportOptionsBuilder_ == null) {
        ensureNfsExportOptionsIsMutable();
        nfsExportOptions_.remove(index);
        onChanged();
      } else {
        nfsExportOptionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public com.google.cloud.filestore.v1.NfsExportOptions.Builder getNfsExportOptionsBuilder(
        int index) {
      return getNfsExportOptionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder getNfsExportOptionsOrBuilder(
        int index) {
      if (nfsExportOptionsBuilder_ == null) {
        return nfsExportOptions_.get(index);
      } else {
        return nfsExportOptionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder>
        getNfsExportOptionsOrBuilderList() {
      if (nfsExportOptionsBuilder_ != null) {
        return nfsExportOptionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nfsExportOptions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public com.google.cloud.filestore.v1.NfsExportOptions.Builder addNfsExportOptionsBuilder() {
      return getNfsExportOptionsFieldBuilder()
          .addBuilder(com.google.cloud.filestore.v1.NfsExportOptions.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public com.google.cloud.filestore.v1.NfsExportOptions.Builder addNfsExportOptionsBuilder(
        int index) {
      return getNfsExportOptionsFieldBuilder()
          .addBuilder(index, com.google.cloud.filestore.v1.NfsExportOptions.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Nfs Export Options.
     * There is a limit of 10 export options per file share.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NfsExportOptions nfs_export_options = 7;</code>
     */
    public java.util.List<com.google.cloud.filestore.v1.NfsExportOptions.Builder>
        getNfsExportOptionsBuilderList() {
      return getNfsExportOptionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.filestore.v1.NfsExportOptions,
            com.google.cloud.filestore.v1.NfsExportOptions.Builder,
            com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder>
        getNfsExportOptionsFieldBuilder() {
      if (nfsExportOptionsBuilder_ == null) {
        nfsExportOptionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.filestore.v1.NfsExportOptions,
                com.google.cloud.filestore.v1.NfsExportOptions.Builder,
                com.google.cloud.filestore.v1.NfsExportOptionsOrBuilder>(
                nfsExportOptions_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        nfsExportOptions_ = null;
      }
      return nfsExportOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.filestore.v1.FileShareConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.filestore.v1.FileShareConfig)
  private static final com.google.cloud.filestore.v1.FileShareConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.filestore.v1.FileShareConfig();
  }

  public static com.google.cloud.filestore.v1.FileShareConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FileShareConfig> PARSER =
      new com.google.protobuf.AbstractParser<FileShareConfig>() {
        @java.lang.Override
        public FileShareConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FileShareConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FileShareConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.filestore.v1.FileShareConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
