/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.filestore.v1;

/**
 *
 *
 * <pre>
 * A Filestore backup.
 * </pre>
 *
 * Protobuf type {@code google.cloud.filestore.v1.Backup}
 */
public final class Backup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.filestore.v1.Backup)
    BackupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Backup.newBuilder() to construct.
  private Backup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Backup() {
    name_ = "";
    description_ = "";
    state_ = 0;
    sourceInstance_ = "";
    sourceFileShare_ = "";
    sourceInstanceTier_ = 0;
    kmsKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Backup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_Backup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_Backup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.filestore.v1.Backup.class,
            com.google.cloud.filestore.v1.Backup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The backup state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.Backup.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Backup is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Backup has been taken and the operation is being finalized. At this
     * point, changes to the file share will not be reflected in the backup.
     * </pre>
     *
     * <code>FINALIZING = 2;</code>
     */
    FINALIZING(2),
    /**
     *
     *
     * <pre>
     * Backup is available for use.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    READY(3),
    /**
     *
     *
     * <pre>
     * Backup is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Backup is not valid and cannot be used for creating new instances or
     * restoring existing instances.
     * </pre>
     *
     * <code>INVALID = 5;</code>
     */
    INVALID(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Backup is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Backup has been taken and the operation is being finalized. At this
     * point, changes to the file share will not be reflected in the backup.
     * </pre>
     *
     * <code>FINALIZING = 2;</code>
     */
    public static final int FINALIZING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Backup is available for use.
     * </pre>
     *
     * <code>READY = 3;</code>
     */
    public static final int READY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Backup is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Backup is not valid and cannot be used for creating new instances or
     * restoring existing instances.
     * </pre>
     *
     * <code>INVALID = 5;</code>
     */
    public static final int INVALID_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return FINALIZING;
        case 3:
          return READY;
        case 4:
          return DELETING;
        case 5:
          return INVALID;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.Backup.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.Backup.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the backup, in the format
   * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the backup, in the format
   * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A description of the backup with 2048 characters or less.
   * Requests with longer descriptions will be rejected.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the backup with 2048 characters or less.
   * Requests with longer descriptions will be rejected.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The backup state.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The backup state.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.Backup.State getState() {
    com.google.cloud.filestore.v1.Backup.State result =
        com.google.cloud.filestore.v1.Backup.State.forNumber(state_);
    return result == null ? com.google.cloud.filestore.v1.Backup.State.UNRECOGNIZED : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the backup was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.filestore.v1.CloudFilestoreServiceProto
                .internal_static_google_cloud_filestore_v1_Backup_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CAPACITY_GB_FIELD_NUMBER = 6;
  private long capacityGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Capacity of the source file share when the backup was created.
   * </pre>
   *
   * <code>int64 capacity_gb = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The capacityGb.
   */
  @java.lang.Override
  public long getCapacityGb() {
    return capacityGb_;
  }

  public static final int STORAGE_BYTES_FIELD_NUMBER = 7;
  private long storageBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The size of the storage used by the backup. As backups share
   * storage, this number is expected to change with backup creation/deletion.
   * </pre>
   *
   * <code>int64 storage_bytes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The storageBytes.
   */
  @java.lang.Override
  public long getStorageBytes() {
    return storageBytes_;
  }

  public static final int SOURCE_INSTANCE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceInstance_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the source Filestore instance, in the format
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
   * used to create this backup.
   * </pre>
   *
   * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The sourceInstance.
   */
  @java.lang.Override
  public java.lang.String getSourceInstance() {
    java.lang.Object ref = sourceInstance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceInstance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the source Filestore instance, in the format
   * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
   * used to create this backup.
   * </pre>
   *
   * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for sourceInstance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceInstanceBytes() {
    java.lang.Object ref = sourceInstance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceInstance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FILE_SHARE_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceFileShare_ = "";
  /**
   *
   *
   * <pre>
   * Name of the file share in the source Filestore instance that the
   * backup is created from.
   * </pre>
   *
   * <code>string source_file_share = 9;</code>
   *
   * @return The sourceFileShare.
   */
  @java.lang.Override
  public java.lang.String getSourceFileShare() {
    java.lang.Object ref = sourceFileShare_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceFileShare_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the file share in the source Filestore instance that the
   * backup is created from.
   * </pre>
   *
   * <code>string source_file_share = 9;</code>
   *
   * @return The bytes for sourceFileShare.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceFileShareBytes() {
    java.lang.Object ref = sourceFileShare_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceFileShare_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_INSTANCE_TIER_FIELD_NUMBER = 10;
  private int sourceInstanceTier_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The service tier of the source Filestore instance that this
   * backup is created from.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for sourceInstanceTier.
   */
  @java.lang.Override
  public int getSourceInstanceTierValue() {
    return sourceInstanceTier_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The service tier of the source Filestore instance that this
   * backup is created from.
   * </pre>
   *
   * <code>
   * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The sourceInstanceTier.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.Instance.Tier getSourceInstanceTier() {
    com.google.cloud.filestore.v1.Instance.Tier result =
        com.google.cloud.filestore.v1.Instance.Tier.forNumber(sourceInstanceTier_);
    return result == null ? com.google.cloud.filestore.v1.Instance.Tier.UNRECOGNIZED : result;
  }

  public static final int DOWNLOAD_BYTES_FIELD_NUMBER = 11;
  private long downloadBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Amount of bytes that will be downloaded if the backup is
   * restored. This may be different than storage bytes, since sequential
   * backups of the same disk will share storage.
   * </pre>
   *
   * <code>int64 download_bytes = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The downloadBytes.
   */
  @java.lang.Override
  public long getDownloadBytes() {
    return downloadBytes_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 12;
  private com.google.protobuf.BoolValue satisfiesPzs_;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public com.google.protobuf.BoolValue getSatisfiesPzs() {
    return satisfiesPzs_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : satisfiesPzs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>
   * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
    return satisfiesPzs_ == null
        ? com.google.protobuf.BoolValue.getDefaultInstance()
        : satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 14;
  private boolean satisfiesPzi_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  public static final int KMS_KEY_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. KMS key name used for data encryption.
   * </pre>
   *
   * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. KMS key name used for data encryption.
   * </pre>
   *
   * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (state_ != com.google.cloud.filestore.v1.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (capacityGb_ != 0L) {
      output.writeInt64(6, capacityGb_);
    }
    if (storageBytes_ != 0L) {
      output.writeInt64(7, storageBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceInstance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sourceInstance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceFileShare_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, sourceFileShare_);
    }
    if (sourceInstanceTier_
        != com.google.cloud.filestore.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, sourceInstanceTier_);
    }
    if (downloadBytes_ != 0L) {
      output.writeInt64(11, downloadBytes_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getSatisfiesPzs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, kmsKey_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(14, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (state_ != com.google.cloud.filestore.v1.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (capacityGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, capacityGb_);
    }
    if (storageBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, storageBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceInstance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, sourceInstance_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceFileShare_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, sourceFileShare_);
    }
    if (sourceInstanceTier_
        != com.google.cloud.filestore.v1.Instance.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, sourceInstanceTier_);
    }
    if (downloadBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, downloadBytes_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getSatisfiesPzs());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, kmsKey_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.filestore.v1.Backup)) {
      return super.equals(obj);
    }
    com.google.cloud.filestore.v1.Backup other = (com.google.cloud.filestore.v1.Backup) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getCapacityGb() != other.getCapacityGb()) return false;
    if (getStorageBytes() != other.getStorageBytes()) return false;
    if (!getSourceInstance().equals(other.getSourceInstance())) return false;
    if (!getSourceFileShare().equals(other.getSourceFileShare())) return false;
    if (sourceInstanceTier_ != other.sourceInstanceTier_) return false;
    if (getDownloadBytes() != other.getDownloadBytes()) return false;
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (!getSatisfiesPzs().equals(other.getSatisfiesPzs())) return false;
    }
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + CAPACITY_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCapacityGb());
    hash = (37 * hash) + STORAGE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStorageBytes());
    hash = (37 * hash) + SOURCE_INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceInstance().hashCode();
    hash = (37 * hash) + SOURCE_FILE_SHARE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceFileShare().hashCode();
    hash = (37 * hash) + SOURCE_INSTANCE_TIER_FIELD_NUMBER;
    hash = (53 * hash) + sourceInstanceTier_;
    hash = (37 * hash) + DOWNLOAD_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDownloadBytes());
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + getSatisfiesPzs().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Backup parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Backup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.Backup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.filestore.v1.Backup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Filestore backup.
   * </pre>
   *
   * Protobuf type {@code google.cloud.filestore.v1.Backup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.filestore.v1.Backup)
      com.google.cloud.filestore.v1.BackupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Backup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Backup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.filestore.v1.Backup.class,
              com.google.cloud.filestore.v1.Backup.Builder.class);
    }

    // Construct using com.google.cloud.filestore.v1.Backup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getSatisfiesPzsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      capacityGb_ = 0L;
      storageBytes_ = 0L;
      sourceInstance_ = "";
      sourceFileShare_ = "";
      sourceInstanceTier_ = 0;
      downloadBytes_ = 0L;
      satisfiesPzs_ = null;
      if (satisfiesPzsBuilder_ != null) {
        satisfiesPzsBuilder_.dispose();
        satisfiesPzsBuilder_ = null;
      }
      satisfiesPzi_ = false;
      kmsKey_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_Backup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Backup getDefaultInstanceForType() {
      return com.google.cloud.filestore.v1.Backup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Backup build() {
      com.google.cloud.filestore.v1.Backup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.Backup buildPartial() {
      com.google.cloud.filestore.v1.Backup result = new com.google.cloud.filestore.v1.Backup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.filestore.v1.Backup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.capacityGb_ = capacityGb_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.storageBytes_ = storageBytes_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.sourceInstance_ = sourceInstance_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.sourceFileShare_ = sourceFileShare_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.sourceInstanceTier_ = sourceInstanceTier_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.downloadBytes_ = downloadBytes_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.satisfiesPzs_ =
            satisfiesPzsBuilder_ == null ? satisfiesPzs_ : satisfiesPzsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.filestore.v1.Backup) {
        return mergeFrom((com.google.cloud.filestore.v1.Backup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.filestore.v1.Backup other) {
      if (other == com.google.cloud.filestore.v1.Backup.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.getCapacityGb() != 0L) {
        setCapacityGb(other.getCapacityGb());
      }
      if (other.getStorageBytes() != 0L) {
        setStorageBytes(other.getStorageBytes());
      }
      if (!other.getSourceInstance().isEmpty()) {
        sourceInstance_ = other.sourceInstance_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getSourceFileShare().isEmpty()) {
        sourceFileShare_ = other.sourceFileShare_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.sourceInstanceTier_ != 0) {
        setSourceInstanceTierValue(other.getSourceInstanceTierValue());
      }
      if (other.getDownloadBytes() != 0L) {
        setDownloadBytes(other.getDownloadBytes());
      }
      if (other.hasSatisfiesPzs()) {
        mergeSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                capacityGb_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                storageBytes_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                sourceInstance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                sourceFileShare_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                sourceInstanceTier_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                downloadBytes_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getSatisfiesPzsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 112:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 112
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the backup, in the format
     * `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the backup with 2048 characters or less.
     * Requests with longer descriptions will be rejected.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The backup state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The backup state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The backup state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.Backup.State getState() {
      com.google.cloud.filestore.v1.Backup.State result =
          com.google.cloud.filestore.v1.Backup.State.forNumber(state_);
      return result == null ? com.google.cloud.filestore.v1.Backup.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The backup state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.filestore.v1.Backup.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The backup state.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Backup.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the backup was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private long capacityGb_;
    /**
     *
     *
     * <pre>
     * Output only. Capacity of the source file share when the backup was created.
     * </pre>
     *
     * <code>int64 capacity_gb = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The capacityGb.
     */
    @java.lang.Override
    public long getCapacityGb() {
      return capacityGb_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Capacity of the source file share when the backup was created.
     * </pre>
     *
     * <code>int64 capacity_gb = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The capacityGb to set.
     * @return This builder for chaining.
     */
    public Builder setCapacityGb(long value) {

      capacityGb_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Capacity of the source file share when the backup was created.
     * </pre>
     *
     * <code>int64 capacity_gb = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCapacityGb() {
      bitField0_ = (bitField0_ & ~0x00000020);
      capacityGb_ = 0L;
      onChanged();
      return this;
    }

    private long storageBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The size of the storage used by the backup. As backups share
     * storage, this number is expected to change with backup creation/deletion.
     * </pre>
     *
     * <code>int64 storage_bytes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The storageBytes.
     */
    @java.lang.Override
    public long getStorageBytes() {
      return storageBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the storage used by the backup. As backups share
     * storage, this number is expected to change with backup creation/deletion.
     * </pre>
     *
     * <code>int64 storage_bytes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The storageBytes to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytes(long value) {

      storageBytes_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The size of the storage used by the backup. As backups share
     * storage, this number is expected to change with backup creation/deletion.
     * </pre>
     *
     * <code>int64 storage_bytes = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytes() {
      bitField0_ = (bitField0_ & ~0x00000040);
      storageBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object sourceInstance_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the source Filestore instance, in the format
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
     * used to create this backup.
     * </pre>
     *
     * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The sourceInstance.
     */
    public java.lang.String getSourceInstance() {
      java.lang.Object ref = sourceInstance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceInstance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the source Filestore instance, in the format
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
     * used to create this backup.
     * </pre>
     *
     * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for sourceInstance.
     */
    public com.google.protobuf.ByteString getSourceInstanceBytes() {
      java.lang.Object ref = sourceInstance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the source Filestore instance, in the format
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
     * used to create this backup.
     * </pre>
     *
     * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The sourceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceInstance_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the source Filestore instance, in the format
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
     * used to create this backup.
     * </pre>
     *
     * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstance() {
      sourceInstance_ = getDefaultInstance().getSourceInstance();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the source Filestore instance, in the format
     * `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
     * used to create this backup.
     * </pre>
     *
     * <code>string source_instance = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for sourceInstance to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceInstance_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object sourceFileShare_ = "";
    /**
     *
     *
     * <pre>
     * Name of the file share in the source Filestore instance that the
     * backup is created from.
     * </pre>
     *
     * <code>string source_file_share = 9;</code>
     *
     * @return The sourceFileShare.
     */
    public java.lang.String getSourceFileShare() {
      java.lang.Object ref = sourceFileShare_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceFileShare_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the file share in the source Filestore instance that the
     * backup is created from.
     * </pre>
     *
     * <code>string source_file_share = 9;</code>
     *
     * @return The bytes for sourceFileShare.
     */
    public com.google.protobuf.ByteString getSourceFileShareBytes() {
      java.lang.Object ref = sourceFileShare_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceFileShare_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the file share in the source Filestore instance that the
     * backup is created from.
     * </pre>
     *
     * <code>string source_file_share = 9;</code>
     *
     * @param value The sourceFileShare to set.
     * @return This builder for chaining.
     */
    public Builder setSourceFileShare(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceFileShare_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the file share in the source Filestore instance that the
     * backup is created from.
     * </pre>
     *
     * <code>string source_file_share = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceFileShare() {
      sourceFileShare_ = getDefaultInstance().getSourceFileShare();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the file share in the source Filestore instance that the
     * backup is created from.
     * </pre>
     *
     * <code>string source_file_share = 9;</code>
     *
     * @param value The bytes for sourceFileShare to set.
     * @return This builder for chaining.
     */
    public Builder setSourceFileShareBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceFileShare_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int sourceInstanceTier_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The service tier of the source Filestore instance that this
     * backup is created from.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for sourceInstanceTier.
     */
    @java.lang.Override
    public int getSourceInstanceTierValue() {
      return sourceInstanceTier_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service tier of the source Filestore instance that this
     * backup is created from.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for sourceInstanceTier to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceTierValue(int value) {
      sourceInstanceTier_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service tier of the source Filestore instance that this
     * backup is created from.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The sourceInstanceTier.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.Instance.Tier getSourceInstanceTier() {
      com.google.cloud.filestore.v1.Instance.Tier result =
          com.google.cloud.filestore.v1.Instance.Tier.forNumber(sourceInstanceTier_);
      return result == null ? com.google.cloud.filestore.v1.Instance.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service tier of the source Filestore instance that this
     * backup is created from.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The sourceInstanceTier to set.
     * @return This builder for chaining.
     */
    public Builder setSourceInstanceTier(com.google.cloud.filestore.v1.Instance.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      sourceInstanceTier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service tier of the source Filestore instance that this
     * backup is created from.
     * </pre>
     *
     * <code>
     * .google.cloud.filestore.v1.Instance.Tier source_instance_tier = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceInstanceTier() {
      bitField0_ = (bitField0_ & ~0x00000200);
      sourceInstanceTier_ = 0;
      onChanged();
      return this;
    }

    private long downloadBytes_;
    /**
     *
     *
     * <pre>
     * Output only. Amount of bytes that will be downloaded if the backup is
     * restored. This may be different than storage bytes, since sequential
     * backups of the same disk will share storage.
     * </pre>
     *
     * <code>int64 download_bytes = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The downloadBytes.
     */
    @java.lang.Override
    public long getDownloadBytes() {
      return downloadBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Amount of bytes that will be downloaded if the backup is
     * restored. This may be different than storage bytes, since sequential
     * backups of the same disk will share storage.
     * </pre>
     *
     * <code>int64 download_bytes = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The downloadBytes to set.
     * @return This builder for chaining.
     */
    public Builder setDownloadBytes(long value) {

      downloadBytes_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Amount of bytes that will be downloaded if the backup is
     * restored. This may be different than storage bytes, since sequential
     * backups of the same disk will share storage.
     * </pre>
     *
     * <code>int64 download_bytes = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDownloadBytes() {
      bitField0_ = (bitField0_ & ~0x00000400);
      downloadBytes_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.BoolValue satisfiesPzs_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        satisfiesPzsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The satisfiesPzs.
     */
    public com.google.protobuf.BoolValue getSatisfiesPzs() {
      if (satisfiesPzsBuilder_ == null) {
        return satisfiesPzs_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : satisfiesPzs_;
      } else {
        return satisfiesPzsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSatisfiesPzs(com.google.protobuf.BoolValue value) {
      if (satisfiesPzsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        satisfiesPzs_ = value;
      } else {
        satisfiesPzsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSatisfiesPzs(com.google.protobuf.BoolValue.Builder builderForValue) {
      if (satisfiesPzsBuilder_ == null) {
        satisfiesPzs_ = builderForValue.build();
      } else {
        satisfiesPzsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSatisfiesPzs(com.google.protobuf.BoolValue value) {
      if (satisfiesPzsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && satisfiesPzs_ != null
            && satisfiesPzs_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
          getSatisfiesPzsBuilder().mergeFrom(value);
        } else {
          satisfiesPzs_ = value;
        }
      } else {
        satisfiesPzsBuilder_.mergeFrom(value);
      }
      if (satisfiesPzs_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00000800);
      satisfiesPzs_ = null;
      if (satisfiesPzsBuilder_ != null) {
        satisfiesPzsBuilder_.dispose();
        satisfiesPzsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.BoolValue.Builder getSatisfiesPzsBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getSatisfiesPzsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.BoolValueOrBuilder getSatisfiesPzsOrBuilder() {
      if (satisfiesPzsBuilder_ != null) {
        return satisfiesPzsBuilder_.getMessageOrBuilder();
      } else {
        return satisfiesPzs_ == null
            ? com.google.protobuf.BoolValue.getDefaultInstance()
            : satisfiesPzs_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>
     * .google.protobuf.BoolValue satisfies_pzs = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue,
            com.google.protobuf.BoolValue.Builder,
            com.google.protobuf.BoolValueOrBuilder>
        getSatisfiesPzsFieldBuilder() {
      if (satisfiesPzsBuilder_ == null) {
        satisfiesPzsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue,
                com.google.protobuf.BoolValue.Builder,
                com.google.protobuf.BoolValueOrBuilder>(
                getSatisfiesPzs(), getParentForChildren(), isClean());
        satisfiesPzs_ = null;
      }
      return satisfiesPzsBuilder_;
    }

    private boolean satisfiesPzi_;
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00001000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. KMS key name used for data encryption.
     * </pre>
     *
     * <code>string kms_key = 13 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.filestore.v1.Backup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.filestore.v1.Backup)
  private static final com.google.cloud.filestore.v1.Backup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.filestore.v1.Backup();
  }

  public static com.google.cloud.filestore.v1.Backup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Backup> PARSER =
      new com.google.protobuf.AbstractParser<Backup>() {
        @java.lang.Override
        public Backup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Backup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Backup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.filestore.v1.Backup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
