/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.filestore.v1;

/**
 *
 *
 * <pre>
 * Network configuration for the instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.filestore.v1.NetworkConfig}
 */
public final class NetworkConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.filestore.v1.NetworkConfig)
    NetworkConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NetworkConfig.newBuilder() to construct.
  private NetworkConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NetworkConfig() {
    network_ = "";
    modes_ = java.util.Collections.emptyList();
    reservedIpRange_ = "";
    ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    connectMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NetworkConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
        .internal_static_google_cloud_filestore_v1_NetworkConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.filestore.v1.NetworkConfig.class,
            com.google.cloud.filestore.v1.NetworkConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Internet protocol versions supported by Filestore.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.NetworkConfig.AddressMode}
   */
  public enum AddressMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Internet protocol not set.
     * </pre>
     *
     * <code>ADDRESS_MODE_UNSPECIFIED = 0;</code>
     */
    ADDRESS_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the IPv4 internet protocol.
     * </pre>
     *
     * <code>MODE_IPV4 = 1;</code>
     */
    MODE_IPV4(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Internet protocol not set.
     * </pre>
     *
     * <code>ADDRESS_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int ADDRESS_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the IPv4 internet protocol.
     * </pre>
     *
     * <code>MODE_IPV4 = 1;</code>
     */
    public static final int MODE_IPV4_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AddressMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AddressMode forNumber(int value) {
      switch (value) {
        case 0:
          return ADDRESS_MODE_UNSPECIFIED;
        case 1:
          return MODE_IPV4;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AddressMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AddressMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AddressMode>() {
          public AddressMode findValueByNumber(int number) {
            return AddressMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.NetworkConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final AddressMode[] VALUES = values();

    public static AddressMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AddressMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.NetworkConfig.AddressMode)
  }

  /**
   *
   *
   * <pre>
   * Available connection modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.filestore.v1.NetworkConfig.ConnectMode}
   */
  public enum ConnectMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    CONNECT_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Connect via direct peering to the Filestore service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    DIRECT_PEERING(1),
    /**
     *
     *
     * <pre>
     * Connect to your Filestore instance using Private Service
     * Access. Private services access provides an IP address range for multiple
     * Google Cloud services, including Filestore.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    PRIVATE_SERVICE_ACCESS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>CONNECT_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONNECT_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Connect via direct peering to the Filestore service.
     * </pre>
     *
     * <code>DIRECT_PEERING = 1;</code>
     */
    public static final int DIRECT_PEERING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Connect to your Filestore instance using Private Service
     * Access. Private services access provides an IP address range for multiple
     * Google Cloud services, including Filestore.
     * </pre>
     *
     * <code>PRIVATE_SERVICE_ACCESS = 2;</code>
     */
    public static final int PRIVATE_SERVICE_ACCESS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConnectMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONNECT_MODE_UNSPECIFIED;
        case 1:
          return DIRECT_PEERING;
        case 2:
          return PRIVATE_SERVICE_ACCESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConnectMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConnectMode>() {
          public ConnectMode findValueByNumber(int number) {
            return ConnectMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.filestore.v1.NetworkConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final ConnectMode[] VALUES = values();

    public static ConnectMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConnectMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.filestore.v1.NetworkConfig.ConnectMode)
  }

  public static final int NETWORK_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected.
   * </pre>
   *
   * <code>string network = 1;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the Google Compute Engine
   * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected.
   * </pre>
   *
   * <code>string network = 1;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> modes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.filestore.v1.NetworkConfig.AddressMode>
      modes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.filestore.v1.NetworkConfig.AddressMode>() {
            public com.google.cloud.filestore.v1.NetworkConfig.AddressMode convert(
                java.lang.Integer from) {
              com.google.cloud.filestore.v1.NetworkConfig.AddressMode result =
                  com.google.cloud.filestore.v1.NetworkConfig.AddressMode.forNumber(from);
              return result == null
                  ? com.google.cloud.filestore.v1.NetworkConfig.AddressMode.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Internet protocol versions for which the instance has IP addresses
   * assigned. For this version, only MODE_IPV4 is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
   *
   * @return A list containing the modes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.filestore.v1.NetworkConfig.AddressMode> getModesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.filestore.v1.NetworkConfig.AddressMode>(
        modes_, modes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Internet protocol versions for which the instance has IP addresses
   * assigned. For this version, only MODE_IPV4 is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
   *
   * @return The count of modes.
   */
  @java.lang.Override
  public int getModesCount() {
    return modes_.size();
  }
  /**
   *
   *
   * <pre>
   * Internet protocol versions for which the instance has IP addresses
   * assigned. For this version, only MODE_IPV4 is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The modes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NetworkConfig.AddressMode getModes(int index) {
    return modes_converter_.convert(modes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Internet protocol versions for which the instance has IP addresses
   * assigned. For this version, only MODE_IPV4 is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
   *
   * @return A list containing the enum numeric values on the wire for modes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getModesValueList() {
    return modes_;
  }
  /**
   *
   *
   * <pre>
   * Internet protocol versions for which the instance has IP addresses
   * assigned. For this version, only MODE_IPV4 is supported.
   * </pre>
   *
   * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of modes at the given index.
   */
  @java.lang.Override
  public int getModesValue(int index) {
    return modes_.get(index);
  }

  private int modesMemoizedSerializedSize;

  public static final int RESERVED_IP_RANGE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservedIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Optional, reserved_ip_range can have one of the following two types of
   * values.
   *
   * * CIDR range value when using DIRECT_PEERING connect mode.
   * * [Allocated IP address
   * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
   * when using PRIVATE_SERVICE_ACCESS connect mode.
   *
   * When the name of an allocated IP address range is specified, it must be one
   * of the ranges associated with the private service access connection.
   * When specified as a direct CIDR value, it must be a /29 CIDR block for
   * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
   * Enterprise tier in one of the [internal IP address
   * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
   * that identifies the range of IP addresses reserved for this instance. For
   * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
   * range you specify can't overlap with either existing subnets or assigned IP
   * address ranges for other Filestore instances in the selected VPC
   * network.
   * </pre>
   *
   * <code>string reserved_ip_range = 4;</code>
   *
   * @return The reservedIpRange.
   */
  @java.lang.Override
  public java.lang.String getReservedIpRange() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservedIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional, reserved_ip_range can have one of the following two types of
   * values.
   *
   * * CIDR range value when using DIRECT_PEERING connect mode.
   * * [Allocated IP address
   * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
   * when using PRIVATE_SERVICE_ACCESS connect mode.
   *
   * When the name of an allocated IP address range is specified, it must be one
   * of the ranges associated with the private service access connection.
   * When specified as a direct CIDR value, it must be a /29 CIDR block for
   * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
   * Enterprise tier in one of the [internal IP address
   * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
   * that identifies the range of IP addresses reserved for this instance. For
   * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
   * range you specify can't overlap with either existing subnets or assigned IP
   * address ranges for other Filestore instances in the selected VPC
   * network.
   * </pre>
   *
   * <code>string reserved_ip_range = 4;</code>
   *
   * @return The bytes for reservedIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservedIpRangeBytes() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservedIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IP_ADDRESSES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList ipAddresses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
   * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
   * </pre>
   *
   * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the ipAddresses.
   */
  public com.google.protobuf.ProtocolStringList getIpAddressesList() {
    return ipAddresses_;
  }
  /**
   *
   *
   * <pre>
   * Output only. IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
   * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
   * </pre>
   *
   * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of ipAddresses.
   */
  public int getIpAddressesCount() {
    return ipAddresses_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
   * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
   * </pre>
   *
   * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The ipAddresses at the given index.
   */
  public java.lang.String getIpAddresses(int index) {
    return ipAddresses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. IPv4 addresses in the format
   * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
   * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
   * </pre>
   *
   * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ipAddresses at the given index.
   */
  public com.google.protobuf.ByteString getIpAddressesBytes(int index) {
    return ipAddresses_.getByteString(index);
  }

  public static final int CONNECT_MODE_FIELD_NUMBER = 6;
  private int connectMode_ = 0;
  /**
   *
   *
   * <pre>
   * The network connect mode of the Filestore instance.
   * If not provided, the connect mode defaults to DIRECT_PEERING.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
   *
   * @return The enum numeric value on the wire for connectMode.
   */
  @java.lang.Override
  public int getConnectModeValue() {
    return connectMode_;
  }
  /**
   *
   *
   * <pre>
   * The network connect mode of the Filestore instance.
   * If not provided, the connect mode defaults to DIRECT_PEERING.
   * </pre>
   *
   * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
   *
   * @return The connectMode.
   */
  @java.lang.Override
  public com.google.cloud.filestore.v1.NetworkConfig.ConnectMode getConnectMode() {
    com.google.cloud.filestore.v1.NetworkConfig.ConnectMode result =
        com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.forNumber(connectMode_);
    return result == null
        ? com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, network_);
    }
    if (getModesList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(modesMemoizedSerializedSize);
    }
    for (int i = 0; i < modes_.size(); i++) {
      output.writeEnumNoTag(modes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reservedIpRange_);
    }
    for (int i = 0; i < ipAddresses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, ipAddresses_.getRaw(i));
    }
    if (connectMode_
        != com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.CONNECT_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, connectMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, network_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < modes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(modes_.get(i));
      }
      size += dataSize;
      if (!getModesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      modesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reservedIpRange_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ipAddresses_.size(); i++) {
        dataSize += computeStringSizeNoTag(ipAddresses_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIpAddressesList().size();
    }
    if (connectMode_
        != com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.CONNECT_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, connectMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.filestore.v1.NetworkConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.filestore.v1.NetworkConfig other =
        (com.google.cloud.filestore.v1.NetworkConfig) obj;

    if (!getNetwork().equals(other.getNetwork())) return false;
    if (!modes_.equals(other.modes_)) return false;
    if (!getReservedIpRange().equals(other.getReservedIpRange())) return false;
    if (!getIpAddressesList().equals(other.getIpAddressesList())) return false;
    if (connectMode_ != other.connectMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (getModesCount() > 0) {
      hash = (37 * hash) + MODES_FIELD_NUMBER;
      hash = (53 * hash) + modes_.hashCode();
    }
    hash = (37 * hash) + RESERVED_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getReservedIpRange().hashCode();
    if (getIpAddressesCount() > 0) {
      hash = (37 * hash) + IP_ADDRESSES_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddressesList().hashCode();
    }
    hash = (37 * hash) + CONNECT_MODE_FIELD_NUMBER;
    hash = (53 * hash) + connectMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.filestore.v1.NetworkConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.filestore.v1.NetworkConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Network configuration for the instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.filestore.v1.NetworkConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.filestore.v1.NetworkConfig)
      com.google.cloud.filestore.v1.NetworkConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NetworkConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.filestore.v1.NetworkConfig.class,
              com.google.cloud.filestore.v1.NetworkConfig.Builder.class);
    }

    // Construct using com.google.cloud.filestore.v1.NetworkConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      network_ = "";
      modes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      reservedIpRange_ = "";
      ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      connectMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.filestore.v1.CloudFilestoreServiceProto
          .internal_static_google_cloud_filestore_v1_NetworkConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NetworkConfig getDefaultInstanceForType() {
      return com.google.cloud.filestore.v1.NetworkConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NetworkConfig build() {
      com.google.cloud.filestore.v1.NetworkConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.filestore.v1.NetworkConfig buildPartial() {
      com.google.cloud.filestore.v1.NetworkConfig result =
          new com.google.cloud.filestore.v1.NetworkConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.filestore.v1.NetworkConfig result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        modes_ = java.util.Collections.unmodifiableList(modes_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.modes_ = modes_;
    }

    private void buildPartial0(com.google.cloud.filestore.v1.NetworkConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.reservedIpRange_ = reservedIpRange_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        ipAddresses_.makeImmutable();
        result.ipAddresses_ = ipAddresses_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.connectMode_ = connectMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.filestore.v1.NetworkConfig) {
        return mergeFrom((com.google.cloud.filestore.v1.NetworkConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.filestore.v1.NetworkConfig other) {
      if (other == com.google.cloud.filestore.v1.NetworkConfig.getDefaultInstance()) return this;
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.modes_.isEmpty()) {
        if (modes_.isEmpty()) {
          modes_ = other.modes_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureModesIsMutable();
          modes_.addAll(other.modes_);
        }
        onChanged();
      }
      if (!other.getReservedIpRange().isEmpty()) {
        reservedIpRange_ = other.reservedIpRange_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.ipAddresses_.isEmpty()) {
        if (ipAddresses_.isEmpty()) {
          ipAddresses_ = other.ipAddresses_;
          bitField0_ |= 0x00000008;
        } else {
          ensureIpAddressesIsMutable();
          ipAddresses_.addAll(other.ipAddresses_);
        }
        onChanged();
      }
      if (other.connectMode_ != 0) {
        setConnectModeValue(other.getConnectModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                int tmpRaw = input.readEnum();
                ensureModesIsMutable();
                modes_.add(tmpRaw);
                break;
              } // case 24
            case 26:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureModesIsMutable();
                  modes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 26
            case 34:
              {
                reservedIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIpAddressesIsMutable();
                ipAddresses_.add(s);
                break;
              } // case 42
            case 48:
              {
                connectMode_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the Google Compute Engine
     * [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected.
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> modes_ = java.util.Collections.emptyList();

    private void ensureModesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        modes_ = new java.util.ArrayList<java.lang.Integer>(modes_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @return A list containing the modes.
     */
    public java.util.List<com.google.cloud.filestore.v1.NetworkConfig.AddressMode> getModesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.filestore.v1.NetworkConfig.AddressMode>(
          modes_, modes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @return The count of modes.
     */
    public int getModesCount() {
      return modes_.size();
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The modes at the given index.
     */
    public com.google.cloud.filestore.v1.NetworkConfig.AddressMode getModes(int index) {
      return modes_converter_.convert(modes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The modes to set.
     * @return This builder for chaining.
     */
    public Builder setModes(
        int index, com.google.cloud.filestore.v1.NetworkConfig.AddressMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModesIsMutable();
      modes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param value The modes to add.
     * @return This builder for chaining.
     */
    public Builder addModes(com.google.cloud.filestore.v1.NetworkConfig.AddressMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureModesIsMutable();
      modes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param values The modes to add.
     * @return This builder for chaining.
     */
    public Builder addAllModes(
        java.lang.Iterable<? extends com.google.cloud.filestore.v1.NetworkConfig.AddressMode>
            values) {
      ensureModesIsMutable();
      for (com.google.cloud.filestore.v1.NetworkConfig.AddressMode value : values) {
        modes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModes() {
      modes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for modes.
     */
    public java.util.List<java.lang.Integer> getModesValueList() {
      return java.util.Collections.unmodifiableList(modes_);
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of modes at the given index.
     */
    public int getModesValue(int index) {
      return modes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for modes to set.
     * @return This builder for chaining.
     */
    public Builder setModesValue(int index, int value) {
      ensureModesIsMutable();
      modes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param value The enum numeric value on the wire for modes to add.
     * @return This builder for chaining.
     */
    public Builder addModesValue(int value) {
      ensureModesIsMutable();
      modes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Internet protocol versions for which the instance has IP addresses
     * assigned. For this version, only MODE_IPV4 is supported.
     * </pre>
     *
     * <code>repeated .google.cloud.filestore.v1.NetworkConfig.AddressMode modes = 3;</code>
     *
     * @param values The enum numeric values on the wire for modes to add.
     * @return This builder for chaining.
     */
    public Builder addAllModesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureModesIsMutable();
      for (int value : values) {
        modes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object reservedIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     *
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     *
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     * </pre>
     *
     * <code>string reserved_ip_range = 4;</code>
     *
     * @return The reservedIpRange.
     */
    public java.lang.String getReservedIpRange() {
      java.lang.Object ref = reservedIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservedIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     *
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     *
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     * </pre>
     *
     * <code>string reserved_ip_range = 4;</code>
     *
     * @return The bytes for reservedIpRange.
     */
    public com.google.protobuf.ByteString getReservedIpRangeBytes() {
      java.lang.Object ref = reservedIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservedIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     *
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     *
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     * </pre>
     *
     * <code>string reserved_ip_range = 4;</code>
     *
     * @param value The reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservedIpRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     *
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     *
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     * </pre>
     *
     * <code>string reserved_ip_range = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRange() {
      reservedIpRange_ = getDefaultInstance().getReservedIpRange();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional, reserved_ip_range can have one of the following two types of
     * values.
     *
     * * CIDR range value when using DIRECT_PEERING connect mode.
     * * [Allocated IP address
     * range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
     * when using PRIVATE_SERVICE_ACCESS connect mode.
     *
     * When the name of an allocated IP address range is specified, it must be one
     * of the ranges associated with the private service access connection.
     * When specified as a direct CIDR value, it must be a /29 CIDR block for
     * Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
     * Enterprise tier in one of the [internal IP address
     * ranges](https://www.arin.net/reference/research/statistics/address_filters/)
     * that identifies the range of IP addresses reserved for this instance. For
     * example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
     * range you specify can't overlap with either existing subnets or assigned IP
     * address ranges for other Filestore instances in the selected VPC
     * network.
     * </pre>
     *
     * <code>string reserved_ip_range = 4;</code>
     *
     * @param value The bytes for reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservedIpRange_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList ipAddresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIpAddressesIsMutable() {
      if (!ipAddresses_.isModifiable()) {
        ipAddresses_ = new com.google.protobuf.LazyStringArrayList(ipAddresses_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the ipAddresses.
     */
    public com.google.protobuf.ProtocolStringList getIpAddressesList() {
      ipAddresses_.makeImmutable();
      return ipAddresses_;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of ipAddresses.
     */
    public int getIpAddressesCount() {
      return ipAddresses_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The ipAddresses at the given index.
     */
    public java.lang.String getIpAddresses(int index) {
      return ipAddresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ipAddresses at the given index.
     */
    public com.google.protobuf.ByteString getIpAddressesBytes(int index) {
      return ipAddresses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The ipAddresses to set.
     * @return This builder for chaining.
     */
    public Builder setIpAddresses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpAddressesIsMutable();
      ipAddresses_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpAddresses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIpAddressesIsMutable();
      ipAddresses_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addAllIpAddresses(java.lang.Iterable<java.lang.String> values) {
      ensureIpAddressesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ipAddresses_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpAddresses() {
      ipAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. IPv4 addresses in the format
     * `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
     * `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
     * </pre>
     *
     * <code>repeated string ip_addresses = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the ipAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addIpAddressesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIpAddressesIsMutable();
      ipAddresses_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int connectMode_ = 0;
    /**
     *
     *
     * <pre>
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     *
     * @return The enum numeric value on the wire for connectMode.
     */
    @java.lang.Override
    public int getConnectModeValue() {
      return connectMode_;
    }
    /**
     *
     *
     * <pre>
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     *
     * @param value The enum numeric value on the wire for connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectModeValue(int value) {
      connectMode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     *
     * @return The connectMode.
     */
    @java.lang.Override
    public com.google.cloud.filestore.v1.NetworkConfig.ConnectMode getConnectMode() {
      com.google.cloud.filestore.v1.NetworkConfig.ConnectMode result =
          com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.forNumber(connectMode_);
      return result == null
          ? com.google.cloud.filestore.v1.NetworkConfig.ConnectMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     *
     * @param value The connectMode to set.
     * @return This builder for chaining.
     */
    public Builder setConnectMode(com.google.cloud.filestore.v1.NetworkConfig.ConnectMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      connectMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The network connect mode of the Filestore instance.
     * If not provided, the connect mode defaults to DIRECT_PEERING.
     * </pre>
     *
     * <code>.google.cloud.filestore.v1.NetworkConfig.ConnectMode connect_mode = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectMode() {
      bitField0_ = (bitField0_ & ~0x00000010);
      connectMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.filestore.v1.NetworkConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.filestore.v1.NetworkConfig)
  private static final com.google.cloud.filestore.v1.NetworkConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.filestore.v1.NetworkConfig();
  }

  public static com.google.cloud.filestore.v1.NetworkConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NetworkConfig> PARSER =
      new com.google.protobuf.AbstractParser<NetworkConfig>() {
        @java.lang.Override
        public NetworkConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NetworkConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NetworkConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.filestore.v1.NetworkConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
