/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CollectionGroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/collectionGroups/{collection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String collection;

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CollectionGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
    }

    public static CollectionGroupName of(String project, String database, String collection) {
        return CollectionGroupName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).build();
    }

    public static String format(String project, String database, String collection) {
        return CollectionGroupName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).build().toString();
    }

    public static CollectionGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CollectionGroupName.parse: formattedString not in valid format");
        return CollectionGroupName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("collection"));
    }

    public static List<CollectionGroupName> parseList(List<String> formattedStrings) {
        ArrayList<CollectionGroupName> list = new ArrayList<CollectionGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CollectionGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CollectionGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CollectionGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CollectionGroupName collectionGroupName = this;
            synchronized (collectionGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"database", (Object)this.database);
                    fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "database", this.database, "collection", this.collection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CollectionGroupName) {
            CollectionGroupName that = (CollectionGroupName)o;
            return this.project.equals(that.project) && this.database.equals(that.database) && this.collection.equals(that.collection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.database.hashCode();
        h *= 1000003;
        return h ^= this.collection.hashCode();
    }

    public static class Builder {
        private String project;
        private String database;
        private String collection;

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getCollection() {
            return this.collection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        private Builder() {
        }

        private Builder(CollectionGroupName collectionGroupName) {
            this.project = collectionGroupName.project;
            this.database = collectionGroupName.database;
            this.collection = collectionGroupName.collection;
        }

        public CollectionGroupName build() {
            return new CollectionGroupName(this);
        }
    }
}

