/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/operation.proto

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
 * [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1.FirestoreAdmin.ImportDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.ImportDocumentsMetadata}
 */
public final class ImportDocumentsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.ImportDocumentsMetadata)
    ImportDocumentsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsMetadata.newBuilder() to construct.
  private ImportDocumentsMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsMetadata() {
    operationState_ = 0;
    collectionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    inputUriPrefix_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportDocumentsMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              operationState_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.firestore.admin.v1.Progress.Builder subBuilder = null;
              if (progressDocuments_ != null) {
                subBuilder = progressDocuments_.toBuilder();
              }
              progressDocuments_ =
                  input.readMessage(
                      com.google.firestore.admin.v1.Progress.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(progressDocuments_);
                progressDocuments_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.firestore.admin.v1.Progress.Builder subBuilder = null;
              if (progressBytes_ != null) {
                subBuilder = progressBytes_.toBuilder();
              }
              progressBytes_ =
                  input.readMessage(
                      com.google.firestore.admin.v1.Progress.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(progressBytes_);
                progressBytes_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                collectionIds_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              collectionIds_.add(s);
              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              inputUriPrefix_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        collectionIds_ = collectionIds_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_ImportDocumentsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_ImportDocumentsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.ImportDocumentsMetadata.class,
            com.google.firestore.admin.v1.ImportDocumentsMetadata.Builder.class);
  }

  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int OPERATION_STATE_FIELD_NUMBER = 3;
  private int operationState_;
  /**
   *
   *
   * <pre>
   * The state of the import operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The enum numeric value on the wire for operationState.
   */
  @java.lang.Override
  public int getOperationStateValue() {
    return operationState_;
  }
  /**
   *
   *
   * <pre>
   * The state of the import operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The operationState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.OperationState getOperationState() {
    @SuppressWarnings("deprecation")
    com.google.firestore.admin.v1.OperationState result =
        com.google.firestore.admin.v1.OperationState.valueOf(operationState_);
    return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
  }

  public static final int PROGRESS_DOCUMENTS_FIELD_NUMBER = 4;
  private com.google.firestore.admin.v1.Progress progressDocuments_;
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   *
   * @return Whether the progressDocuments field is set.
   */
  @java.lang.Override
  public boolean hasProgressDocuments() {
    return progressDocuments_ != null;
  }
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   *
   * @return The progressDocuments.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressDocuments() {
    return progressDocuments_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressDocuments_;
  }
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
    return getProgressDocuments();
  }

  public static final int PROGRESS_BYTES_FIELD_NUMBER = 5;
  private com.google.firestore.admin.v1.Progress progressBytes_;
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   *
   * @return Whether the progressBytes field is set.
   */
  @java.lang.Override
  public boolean hasProgressBytes() {
    return progressBytes_ != null;
  }
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   *
   * @return The progressBytes.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressBytes() {
    return progressBytes_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressBytes_;
  }
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
    return getProgressBytes();
  }

  public static final int COLLECTION_IDS_FIELD_NUMBER = 6;
  private com.google.protobuf.LazyStringList collectionIds_;
  /**
   *
   *
   * <pre>
   * Which collection ids are being imported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @return A list containing the collectionIds.
   */
  public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
    return collectionIds_;
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being imported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @return The count of collectionIds.
   */
  public int getCollectionIdsCount() {
    return collectionIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being imported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  public java.lang.String getCollectionIds(int index) {
    return collectionIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being imported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
    return collectionIds_.getByteString(index);
  }

  public static final int INPUT_URI_PREFIX_FIELD_NUMBER = 7;
  private volatile java.lang.Object inputUriPrefix_;
  /**
   *
   *
   * <pre>
   * The location of the documents being imported.
   * </pre>
   *
   * <code>string input_uri_prefix = 7;</code>
   *
   * @return The inputUriPrefix.
   */
  @java.lang.Override
  public java.lang.String getInputUriPrefix() {
    java.lang.Object ref = inputUriPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUriPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The location of the documents being imported.
   * </pre>
   *
   * <code>string input_uri_prefix = 7;</code>
   *
   * @return The bytes for inputUriPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputUriPrefixBytes() {
    java.lang.Object ref = inputUriPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUriPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (startTime_ != null) {
      output.writeMessage(1, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, operationState_);
    }
    if (progressDocuments_ != null) {
      output.writeMessage(4, getProgressDocuments());
    }
    if (progressBytes_ != null) {
      output.writeMessage(5, getProgressBytes());
    }
    for (int i = 0; i < collectionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, collectionIds_.getRaw(i));
    }
    if (!getInputUriPrefixBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, inputUriPrefix_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operationState_);
    }
    if (progressDocuments_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProgressDocuments());
    }
    if (progressBytes_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProgressBytes());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < collectionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(collectionIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCollectionIdsList().size();
    }
    if (!getInputUriPrefixBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, inputUriPrefix_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.ImportDocumentsMetadata)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.ImportDocumentsMetadata other =
        (com.google.firestore.admin.v1.ImportDocumentsMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (operationState_ != other.operationState_) return false;
    if (hasProgressDocuments() != other.hasProgressDocuments()) return false;
    if (hasProgressDocuments()) {
      if (!getProgressDocuments().equals(other.getProgressDocuments())) return false;
    }
    if (hasProgressBytes() != other.hasProgressBytes()) return false;
    if (hasProgressBytes()) {
      if (!getProgressBytes().equals(other.getProgressBytes())) return false;
    }
    if (!getCollectionIdsList().equals(other.getCollectionIdsList())) return false;
    if (!getInputUriPrefix().equals(other.getInputUriPrefix())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + operationState_;
    if (hasProgressDocuments()) {
      hash = (37 * hash) + PROGRESS_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getProgressDocuments().hashCode();
    }
    if (hasProgressBytes()) {
      hash = (37 * hash) + PROGRESS_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + getProgressBytes().hashCode();
    }
    if (getCollectionIdsCount() > 0) {
      hash = (37 * hash) + COLLECTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionIdsList().hashCode();
    }
    hash = (37 * hash) + INPUT_URI_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getInputUriPrefix().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.firestore.admin.v1.ImportDocumentsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for [google.longrunning.Operation][google.longrunning.Operation] results from
   * [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1.FirestoreAdmin.ImportDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.ImportDocumentsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.ImportDocumentsMetadata)
      com.google.firestore.admin.v1.ImportDocumentsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ImportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ImportDocumentsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.ImportDocumentsMetadata.class,
              com.google.firestore.admin.v1.ImportDocumentsMetadata.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.ImportDocumentsMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      operationState_ = 0;

      if (progressDocumentsBuilder_ == null) {
        progressDocuments_ = null;
      } else {
        progressDocuments_ = null;
        progressDocumentsBuilder_ = null;
      }
      if (progressBytesBuilder_ == null) {
        progressBytes_ = null;
      } else {
        progressBytes_ = null;
        progressBytesBuilder_ = null;
      }
      collectionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      inputUriPrefix_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ImportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ImportDocumentsMetadata getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.ImportDocumentsMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ImportDocumentsMetadata build() {
      com.google.firestore.admin.v1.ImportDocumentsMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ImportDocumentsMetadata buildPartial() {
      com.google.firestore.admin.v1.ImportDocumentsMetadata result =
          new com.google.firestore.admin.v1.ImportDocumentsMetadata(this);
      int from_bitField0_ = bitField0_;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.operationState_ = operationState_;
      if (progressDocumentsBuilder_ == null) {
        result.progressDocuments_ = progressDocuments_;
      } else {
        result.progressDocuments_ = progressDocumentsBuilder_.build();
      }
      if (progressBytesBuilder_ == null) {
        result.progressBytes_ = progressBytes_;
      } else {
        result.progressBytes_ = progressBytesBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        collectionIds_ = collectionIds_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.collectionIds_ = collectionIds_;
      result.inputUriPrefix_ = inputUriPrefix_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.ImportDocumentsMetadata) {
        return mergeFrom((com.google.firestore.admin.v1.ImportDocumentsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.ImportDocumentsMetadata other) {
      if (other == com.google.firestore.admin.v1.ImportDocumentsMetadata.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.operationState_ != 0) {
        setOperationStateValue(other.getOperationStateValue());
      }
      if (other.hasProgressDocuments()) {
        mergeProgressDocuments(other.getProgressDocuments());
      }
      if (other.hasProgressBytes()) {
        mergeProgressBytes(other.getProgressBytes());
      }
      if (!other.collectionIds_.isEmpty()) {
        if (collectionIds_.isEmpty()) {
          collectionIds_ = other.collectionIds_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureCollectionIdsIsMutable();
          collectionIds_.addAll(other.collectionIds_);
        }
        onChanged();
      }
      if (!other.getInputUriPrefix().isEmpty()) {
        inputUriPrefix_ = other.inputUriPrefix_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.admin.v1.ImportDocumentsMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.firestore.admin.v1.ImportDocumentsMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int operationState_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the import operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The enum numeric value on the wire for operationState.
     */
    @java.lang.Override
    public int getOperationStateValue() {
      return operationState_;
    }
    /**
     *
     *
     * <pre>
     * The state of the import operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The enum numeric value on the wire for operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationStateValue(int value) {

      operationState_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the import operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The operationState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.OperationState getOperationState() {
      @SuppressWarnings("deprecation")
      com.google.firestore.admin.v1.OperationState result =
          com.google.firestore.admin.v1.OperationState.valueOf(operationState_);
      return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the import operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationState(com.google.firestore.admin.v1.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      operationState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the import operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationState() {

      operationState_ = 0;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Progress progressDocuments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressDocumentsBuilder_;
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     *
     * @return Whether the progressDocuments field is set.
     */
    public boolean hasProgressDocuments() {
      return progressDocumentsBuilder_ != null || progressDocuments_ != null;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     *
     * @return The progressDocuments.
     */
    public com.google.firestore.admin.v1.Progress getProgressDocuments() {
      if (progressDocumentsBuilder_ == null) {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      } else {
        return progressDocumentsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder setProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressDocuments_ = value;
        onChanged();
      } else {
        progressDocumentsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder setProgressDocuments(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressDocumentsBuilder_ == null) {
        progressDocuments_ = builderForValue.build();
        onChanged();
      } else {
        progressDocumentsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder mergeProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (progressDocuments_ != null) {
          progressDocuments_ =
              com.google.firestore.admin.v1.Progress.newBuilder(progressDocuments_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          progressDocuments_ = value;
        }
        onChanged();
      } else {
        progressDocumentsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder clearProgressDocuments() {
      if (progressDocumentsBuilder_ == null) {
        progressDocuments_ = null;
        onChanged();
      } else {
        progressDocuments_ = null;
        progressDocumentsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressDocumentsBuilder() {

      onChanged();
      return getProgressDocumentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
      if (progressDocumentsBuilder_ != null) {
        return progressDocumentsBuilder_.getMessageOrBuilder();
      } else {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressDocumentsFieldBuilder() {
      if (progressDocumentsBuilder_ == null) {
        progressDocumentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressDocuments(), getParentForChildren(), isClean());
        progressDocuments_ = null;
      }
      return progressDocumentsBuilder_;
    }

    private com.google.firestore.admin.v1.Progress progressBytes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressBytesBuilder_;
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     *
     * @return Whether the progressBytes field is set.
     */
    public boolean hasProgressBytes() {
      return progressBytesBuilder_ != null || progressBytes_ != null;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     *
     * @return The progressBytes.
     */
    public com.google.firestore.admin.v1.Progress getProgressBytes() {
      if (progressBytesBuilder_ == null) {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      } else {
        return progressBytesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder setProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressBytes_ = value;
        onChanged();
      } else {
        progressBytesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder setProgressBytes(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressBytesBuilder_ == null) {
        progressBytes_ = builderForValue.build();
        onChanged();
      } else {
        progressBytesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder mergeProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (progressBytes_ != null) {
          progressBytes_ =
              com.google.firestore.admin.v1.Progress.newBuilder(progressBytes_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          progressBytes_ = value;
        }
        onChanged();
      } else {
        progressBytesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder clearProgressBytes() {
      if (progressBytesBuilder_ == null) {
        progressBytes_ = null;
        onChanged();
      } else {
        progressBytes_ = null;
        progressBytesBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressBytesBuilder() {

      onChanged();
      return getProgressBytesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
      if (progressBytesBuilder_ != null) {
        return progressBytesBuilder_.getMessageOrBuilder();
      } else {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressBytesFieldBuilder() {
      if (progressBytesBuilder_ == null) {
        progressBytesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressBytes(), getParentForChildren(), isClean());
        progressBytes_ = null;
      }
      return progressBytesBuilder_;
    }

    private com.google.protobuf.LazyStringList collectionIds_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureCollectionIdsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        collectionIds_ = new com.google.protobuf.LazyStringArrayList(collectionIds_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return A list containing the collectionIds.
     */
    public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
      return collectionIds_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return The count of collectionIds.
     */
    public int getCollectionIdsCount() {
      return collectionIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The collectionIds at the given index.
     */
    public java.lang.String getCollectionIds(int index) {
      return collectionIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the collectionIds at the given index.
     */
    public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
      return collectionIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The collectionIds to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param value The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param values The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCollectionIds(java.lang.Iterable<java.lang.String> values) {
      ensureCollectionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, collectionIds_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionIds() {
      collectionIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being imported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param value The bytes of the collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object inputUriPrefix_ = "";
    /**
     *
     *
     * <pre>
     * The location of the documents being imported.
     * </pre>
     *
     * <code>string input_uri_prefix = 7;</code>
     *
     * @return The inputUriPrefix.
     */
    public java.lang.String getInputUriPrefix() {
      java.lang.Object ref = inputUriPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUriPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the documents being imported.
     * </pre>
     *
     * <code>string input_uri_prefix = 7;</code>
     *
     * @return The bytes for inputUriPrefix.
     */
    public com.google.protobuf.ByteString getInputUriPrefixBytes() {
      java.lang.Object ref = inputUriPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUriPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the documents being imported.
     * </pre>
     *
     * <code>string input_uri_prefix = 7;</code>
     *
     * @param value The inputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inputUriPrefix_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the documents being imported.
     * </pre>
     *
     * <code>string input_uri_prefix = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputUriPrefix() {

      inputUriPrefix_ = getDefaultInstance().getInputUriPrefix();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the documents being imported.
     * </pre>
     *
     * <code>string input_uri_prefix = 7;</code>
     *
     * @param value The bytes for inputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inputUriPrefix_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.ImportDocumentsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.ImportDocumentsMetadata)
  private static final com.google.firestore.admin.v1.ImportDocumentsMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.ImportDocumentsMetadata();
  }

  public static com.google.firestore.admin.v1.ImportDocumentsMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsMetadata>() {
        @java.lang.Override
        public ImportDocumentsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportDocumentsMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.ImportDocumentsMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
