/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FieldName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE_COLLECTION_FIELD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/collectionGroups/{collection}/fields/{field}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String collection;
    private final String field;

    @Deprecated
    protected FieldName() {
        this.project = null;
        this.database = null;
        this.collection = null;
        this.field = null;
    }

    private FieldName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.field = (String)Preconditions.checkNotNull((Object)builder.getField());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getField() {
        return this.field;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FieldName of(String project, String database, String collection, String field) {
        return FieldName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).setField(field).build();
    }

    public static String format(String project, String database, String collection, String field) {
        return FieldName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).setField(field).build().toString();
    }

    public static FieldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE_COLLECTION_FIELD.validatedMatch(formattedString, "FieldName.parse: formattedString not in valid format");
        return FieldName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("collection"), (String)matchMap.get("field"));
    }

    public static List<FieldName> parseList(List<String> formattedStrings) {
        ArrayList<FieldName> list = new ArrayList<FieldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FieldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FieldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FieldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE_COLLECTION_FIELD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FieldName fieldName = this;
            synchronized (fieldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.field != null) {
                        fieldMapBuilder.put((Object)"field", (Object)this.field);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE_COLLECTION_FIELD.instantiate(new String[]{"project", this.project, "database", this.database, "collection", this.collection, "field", this.field});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FieldName that = (FieldName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.field, that.field);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.field);
    }

    public static class Builder {
        private String project;
        private String database;
        private String collection;
        private String field;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getField() {
            return this.field;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        private Builder(FieldName fieldName) {
            this.project = fieldName.project;
            this.database = fieldName.database;
            this.collection = fieldName.collection;
            this.field = fieldName.field;
        }

        public FieldName build() {
            return new FieldName(this);
        }
    }
}

