/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/field.proto

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Represents a single field in the database.
 * Fields are grouped by their "Collection Group", which represent all
 * collections in the database with the same id.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.Field}
 */
public final class Field extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Field)
    FieldOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Field.newBuilder() to construct.
  private Field(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Field() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Field();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Field(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              com.google.firestore.admin.v1.Field.IndexConfig.Builder subBuilder = null;
              if (indexConfig_ != null) {
                subBuilder = indexConfig_.toBuilder();
              }
              indexConfig_ =
                  input.readMessage(
                      com.google.firestore.admin.v1.Field.IndexConfig.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(indexConfig_);
                indexConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.FieldProto
        .internal_static_google_firestore_admin_v1_Field_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.FieldProto
        .internal_static_google_firestore_admin_v1_Field_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.Field.class,
            com.google.firestore.admin.v1.Field.Builder.class);
  }

  public interface IndexConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.Field.IndexConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    java.util.List<com.google.firestore.admin.v1.Index> getIndexesList();
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    com.google.firestore.admin.v1.Index getIndexes(int index);
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    int getIndexesCount();
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    java.util.List<? extends com.google.firestore.admin.v1.IndexOrBuilder>
        getIndexesOrBuilderList();
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    com.google.firestore.admin.v1.IndexOrBuilder getIndexesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Output only. When true, the `Field`'s index configuration is set from the
     * configuration specified by the `ancestor_field`.
     * When false, the `Field`'s index configuration is defined explicitly.
     * </pre>
     *
     * <code>bool uses_ancestor_config = 2;</code>
     *
     * @return The usesAncestorConfig.
     */
    boolean getUsesAncestorConfig();

    /**
     *
     *
     * <pre>
     * Output only. Specifies the resource name of the `Field` from which this field's
     * index configuration is set (when `uses_ancestor_config` is true),
     * or from which it *would* be set if this field had no index configuration
     * (when `uses_ancestor_config` is false).
     * </pre>
     *
     * <code>string ancestor_field = 3;</code>
     *
     * @return The ancestorField.
     */
    java.lang.String getAncestorField();
    /**
     *
     *
     * <pre>
     * Output only. Specifies the resource name of the `Field` from which this field's
     * index configuration is set (when `uses_ancestor_config` is true),
     * or from which it *would* be set if this field had no index configuration
     * (when `uses_ancestor_config` is false).
     * </pre>
     *
     * <code>string ancestor_field = 3;</code>
     *
     * @return The bytes for ancestorField.
     */
    com.google.protobuf.ByteString getAncestorFieldBytes();

    /**
     *
     *
     * <pre>
     * Output only
     * When true, the `Field`'s index configuration is in the process of being
     * reverted. Once complete, the index config will transition to the same
     * state as the field specified by `ancestor_field`, at which point
     * `uses_ancestor_config` will be `true` and `reverting` will be `false`.
     * </pre>
     *
     * <code>bool reverting = 4;</code>
     *
     * @return The reverting.
     */
    boolean getReverting();
  }
  /**
   *
   *
   * <pre>
   * The index configuration for this field.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Field.IndexConfig}
   */
  public static final class IndexConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Field.IndexConfig)
      IndexConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IndexConfig.newBuilder() to construct.
    private IndexConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IndexConfig() {
      indexes_ = java.util.Collections.emptyList();
      ancestorField_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IndexConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IndexConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  indexes_ = new java.util.ArrayList<com.google.firestore.admin.v1.Index>();
                  mutable_bitField0_ |= 0x00000001;
                }
                indexes_.add(
                    input.readMessage(
                        com.google.firestore.admin.v1.Index.parser(), extensionRegistry));
                break;
              }
            case 16:
              {
                usesAncestorConfig_ = input.readBool();
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                ancestorField_ = s;
                break;
              }
            case 32:
              {
                reverting_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          indexes_ = java.util.Collections.unmodifiableList(indexes_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FieldProto
          .internal_static_google_firestore_admin_v1_Field_IndexConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FieldProto
          .internal_static_google_firestore_admin_v1_Field_IndexConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Field.IndexConfig.class,
              com.google.firestore.admin.v1.Field.IndexConfig.Builder.class);
    }

    public static final int INDEXES_FIELD_NUMBER = 1;
    private java.util.List<com.google.firestore.admin.v1.Index> indexes_;
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.firestore.admin.v1.Index> getIndexesList() {
      return indexes_;
    }
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.firestore.admin.v1.IndexOrBuilder>
        getIndexesOrBuilderList() {
      return indexes_;
    }
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    @java.lang.Override
    public int getIndexesCount() {
      return indexes_.size();
    }
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Index getIndexes(int index) {
      return indexes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The indexes supported for this field.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.IndexOrBuilder getIndexesOrBuilder(int index) {
      return indexes_.get(index);
    }

    public static final int USES_ANCESTOR_CONFIG_FIELD_NUMBER = 2;
    private boolean usesAncestorConfig_;
    /**
     *
     *
     * <pre>
     * Output only. When true, the `Field`'s index configuration is set from the
     * configuration specified by the `ancestor_field`.
     * When false, the `Field`'s index configuration is defined explicitly.
     * </pre>
     *
     * <code>bool uses_ancestor_config = 2;</code>
     *
     * @return The usesAncestorConfig.
     */
    @java.lang.Override
    public boolean getUsesAncestorConfig() {
      return usesAncestorConfig_;
    }

    public static final int ANCESTOR_FIELD_FIELD_NUMBER = 3;
    private volatile java.lang.Object ancestorField_;
    /**
     *
     *
     * <pre>
     * Output only. Specifies the resource name of the `Field` from which this field's
     * index configuration is set (when `uses_ancestor_config` is true),
     * or from which it *would* be set if this field had no index configuration
     * (when `uses_ancestor_config` is false).
     * </pre>
     *
     * <code>string ancestor_field = 3;</code>
     *
     * @return The ancestorField.
     */
    @java.lang.Override
    public java.lang.String getAncestorField() {
      java.lang.Object ref = ancestorField_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ancestorField_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the resource name of the `Field` from which this field's
     * index configuration is set (when `uses_ancestor_config` is true),
     * or from which it *would* be set if this field had no index configuration
     * (when `uses_ancestor_config` is false).
     * </pre>
     *
     * <code>string ancestor_field = 3;</code>
     *
     * @return The bytes for ancestorField.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAncestorFieldBytes() {
      java.lang.Object ref = ancestorField_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ancestorField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REVERTING_FIELD_NUMBER = 4;
    private boolean reverting_;
    /**
     *
     *
     * <pre>
     * Output only
     * When true, the `Field`'s index configuration is in the process of being
     * reverted. Once complete, the index config will transition to the same
     * state as the field specified by `ancestor_field`, at which point
     * `uses_ancestor_config` will be `true` and `reverting` will be `false`.
     * </pre>
     *
     * <code>bool reverting = 4;</code>
     *
     * @return The reverting.
     */
    @java.lang.Override
    public boolean getReverting() {
      return reverting_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < indexes_.size(); i++) {
        output.writeMessage(1, indexes_.get(i));
      }
      if (usesAncestorConfig_ != false) {
        output.writeBool(2, usesAncestorConfig_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ancestorField_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ancestorField_);
      }
      if (reverting_ != false) {
        output.writeBool(4, reverting_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < indexes_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, indexes_.get(i));
      }
      if (usesAncestorConfig_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, usesAncestorConfig_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ancestorField_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ancestorField_);
      }
      if (reverting_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, reverting_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.admin.v1.Field.IndexConfig)) {
        return super.equals(obj);
      }
      com.google.firestore.admin.v1.Field.IndexConfig other =
          (com.google.firestore.admin.v1.Field.IndexConfig) obj;

      if (!getIndexesList().equals(other.getIndexesList())) return false;
      if (getUsesAncestorConfig() != other.getUsesAncestorConfig()) return false;
      if (!getAncestorField().equals(other.getAncestorField())) return false;
      if (getReverting() != other.getReverting()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getIndexesCount() > 0) {
        hash = (37 * hash) + INDEXES_FIELD_NUMBER;
        hash = (53 * hash) + getIndexesList().hashCode();
      }
      hash = (37 * hash) + USES_ANCESTOR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUsesAncestorConfig());
      hash = (37 * hash) + ANCESTOR_FIELD_FIELD_NUMBER;
      hash = (53 * hash) + getAncestorField().hashCode();
      hash = (37 * hash) + REVERTING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReverting());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.admin.v1.Field.IndexConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field.
     * </pre>
     *
     * Protobuf type {@code google.firestore.admin.v1.Field.IndexConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Field.IndexConfig)
        com.google.firestore.admin.v1.Field.IndexConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.admin.v1.FieldProto
            .internal_static_google_firestore_admin_v1_Field_IndexConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.admin.v1.FieldProto
            .internal_static_google_firestore_admin_v1_Field_IndexConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.admin.v1.Field.IndexConfig.class,
                com.google.firestore.admin.v1.Field.IndexConfig.Builder.class);
      }

      // Construct using com.google.firestore.admin.v1.Field.IndexConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getIndexesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (indexesBuilder_ == null) {
          indexes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          indexesBuilder_.clear();
        }
        usesAncestorConfig_ = false;

        ancestorField_ = "";

        reverting_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.admin.v1.FieldProto
            .internal_static_google_firestore_admin_v1_Field_IndexConfig_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Field.IndexConfig getDefaultInstanceForType() {
        return com.google.firestore.admin.v1.Field.IndexConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Field.IndexConfig build() {
        com.google.firestore.admin.v1.Field.IndexConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.admin.v1.Field.IndexConfig buildPartial() {
        com.google.firestore.admin.v1.Field.IndexConfig result =
            new com.google.firestore.admin.v1.Field.IndexConfig(this);
        int from_bitField0_ = bitField0_;
        if (indexesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            indexes_ = java.util.Collections.unmodifiableList(indexes_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.indexes_ = indexes_;
        } else {
          result.indexes_ = indexesBuilder_.build();
        }
        result.usesAncestorConfig_ = usesAncestorConfig_;
        result.ancestorField_ = ancestorField_;
        result.reverting_ = reverting_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.admin.v1.Field.IndexConfig) {
          return mergeFrom((com.google.firestore.admin.v1.Field.IndexConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.admin.v1.Field.IndexConfig other) {
        if (other == com.google.firestore.admin.v1.Field.IndexConfig.getDefaultInstance())
          return this;
        if (indexesBuilder_ == null) {
          if (!other.indexes_.isEmpty()) {
            if (indexes_.isEmpty()) {
              indexes_ = other.indexes_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureIndexesIsMutable();
              indexes_.addAll(other.indexes_);
            }
            onChanged();
          }
        } else {
          if (!other.indexes_.isEmpty()) {
            if (indexesBuilder_.isEmpty()) {
              indexesBuilder_.dispose();
              indexesBuilder_ = null;
              indexes_ = other.indexes_;
              bitField0_ = (bitField0_ & ~0x00000001);
              indexesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getIndexesFieldBuilder()
                      : null;
            } else {
              indexesBuilder_.addAllMessages(other.indexes_);
            }
          }
        }
        if (other.getUsesAncestorConfig() != false) {
          setUsesAncestorConfig(other.getUsesAncestorConfig());
        }
        if (!other.getAncestorField().isEmpty()) {
          ancestorField_ = other.ancestorField_;
          onChanged();
        }
        if (other.getReverting() != false) {
          setReverting(other.getReverting());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.admin.v1.Field.IndexConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.firestore.admin.v1.Field.IndexConfig) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.firestore.admin.v1.Index> indexes_ =
          java.util.Collections.emptyList();

      private void ensureIndexesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          indexes_ = new java.util.ArrayList<com.google.firestore.admin.v1.Index>(indexes_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.admin.v1.Index,
              com.google.firestore.admin.v1.Index.Builder,
              com.google.firestore.admin.v1.IndexOrBuilder>
          indexesBuilder_;

      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public java.util.List<com.google.firestore.admin.v1.Index> getIndexesList() {
        if (indexesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(indexes_);
        } else {
          return indexesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public int getIndexesCount() {
        if (indexesBuilder_ == null) {
          return indexes_.size();
        } else {
          return indexesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public com.google.firestore.admin.v1.Index getIndexes(int index) {
        if (indexesBuilder_ == null) {
          return indexes_.get(index);
        } else {
          return indexesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder setIndexes(int index, com.google.firestore.admin.v1.Index value) {
        if (indexesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIndexesIsMutable();
          indexes_.set(index, value);
          onChanged();
        } else {
          indexesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder setIndexes(
          int index, com.google.firestore.admin.v1.Index.Builder builderForValue) {
        if (indexesBuilder_ == null) {
          ensureIndexesIsMutable();
          indexes_.set(index, builderForValue.build());
          onChanged();
        } else {
          indexesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder addIndexes(com.google.firestore.admin.v1.Index value) {
        if (indexesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIndexesIsMutable();
          indexes_.add(value);
          onChanged();
        } else {
          indexesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder addIndexes(int index, com.google.firestore.admin.v1.Index value) {
        if (indexesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIndexesIsMutable();
          indexes_.add(index, value);
          onChanged();
        } else {
          indexesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder addIndexes(com.google.firestore.admin.v1.Index.Builder builderForValue) {
        if (indexesBuilder_ == null) {
          ensureIndexesIsMutable();
          indexes_.add(builderForValue.build());
          onChanged();
        } else {
          indexesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder addIndexes(
          int index, com.google.firestore.admin.v1.Index.Builder builderForValue) {
        if (indexesBuilder_ == null) {
          ensureIndexesIsMutable();
          indexes_.add(index, builderForValue.build());
          onChanged();
        } else {
          indexesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder addAllIndexes(
          java.lang.Iterable<? extends com.google.firestore.admin.v1.Index> values) {
        if (indexesBuilder_ == null) {
          ensureIndexesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, indexes_);
          onChanged();
        } else {
          indexesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder clearIndexes() {
        if (indexesBuilder_ == null) {
          indexes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          indexesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public Builder removeIndexes(int index) {
        if (indexesBuilder_ == null) {
          ensureIndexesIsMutable();
          indexes_.remove(index);
          onChanged();
        } else {
          indexesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public com.google.firestore.admin.v1.Index.Builder getIndexesBuilder(int index) {
        return getIndexesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public com.google.firestore.admin.v1.IndexOrBuilder getIndexesOrBuilder(int index) {
        if (indexesBuilder_ == null) {
          return indexes_.get(index);
        } else {
          return indexesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public java.util.List<? extends com.google.firestore.admin.v1.IndexOrBuilder>
          getIndexesOrBuilderList() {
        if (indexesBuilder_ != null) {
          return indexesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(indexes_);
        }
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public com.google.firestore.admin.v1.Index.Builder addIndexesBuilder() {
        return getIndexesFieldBuilder()
            .addBuilder(com.google.firestore.admin.v1.Index.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public com.google.firestore.admin.v1.Index.Builder addIndexesBuilder(int index) {
        return getIndexesFieldBuilder()
            .addBuilder(index, com.google.firestore.admin.v1.Index.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The indexes supported for this field.
       * </pre>
       *
       * <code>repeated .google.firestore.admin.v1.Index indexes = 1;</code>
       */
      public java.util.List<com.google.firestore.admin.v1.Index.Builder> getIndexesBuilderList() {
        return getIndexesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.firestore.admin.v1.Index,
              com.google.firestore.admin.v1.Index.Builder,
              com.google.firestore.admin.v1.IndexOrBuilder>
          getIndexesFieldBuilder() {
        if (indexesBuilder_ == null) {
          indexesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.firestore.admin.v1.Index,
                  com.google.firestore.admin.v1.Index.Builder,
                  com.google.firestore.admin.v1.IndexOrBuilder>(
                  indexes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          indexes_ = null;
        }
        return indexesBuilder_;
      }

      private boolean usesAncestorConfig_;
      /**
       *
       *
       * <pre>
       * Output only. When true, the `Field`'s index configuration is set from the
       * configuration specified by the `ancestor_field`.
       * When false, the `Field`'s index configuration is defined explicitly.
       * </pre>
       *
       * <code>bool uses_ancestor_config = 2;</code>
       *
       * @return The usesAncestorConfig.
       */
      @java.lang.Override
      public boolean getUsesAncestorConfig() {
        return usesAncestorConfig_;
      }
      /**
       *
       *
       * <pre>
       * Output only. When true, the `Field`'s index configuration is set from the
       * configuration specified by the `ancestor_field`.
       * When false, the `Field`'s index configuration is defined explicitly.
       * </pre>
       *
       * <code>bool uses_ancestor_config = 2;</code>
       *
       * @param value The usesAncestorConfig to set.
       * @return This builder for chaining.
       */
      public Builder setUsesAncestorConfig(boolean value) {

        usesAncestorConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. When true, the `Field`'s index configuration is set from the
       * configuration specified by the `ancestor_field`.
       * When false, the `Field`'s index configuration is defined explicitly.
       * </pre>
       *
       * <code>bool uses_ancestor_config = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsesAncestorConfig() {

        usesAncestorConfig_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object ancestorField_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Specifies the resource name of the `Field` from which this field's
       * index configuration is set (when `uses_ancestor_config` is true),
       * or from which it *would* be set if this field had no index configuration
       * (when `uses_ancestor_config` is false).
       * </pre>
       *
       * <code>string ancestor_field = 3;</code>
       *
       * @return The ancestorField.
       */
      public java.lang.String getAncestorField() {
        java.lang.Object ref = ancestorField_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ancestorField_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the resource name of the `Field` from which this field's
       * index configuration is set (when `uses_ancestor_config` is true),
       * or from which it *would* be set if this field had no index configuration
       * (when `uses_ancestor_config` is false).
       * </pre>
       *
       * <code>string ancestor_field = 3;</code>
       *
       * @return The bytes for ancestorField.
       */
      public com.google.protobuf.ByteString getAncestorFieldBytes() {
        java.lang.Object ref = ancestorField_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ancestorField_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the resource name of the `Field` from which this field's
       * index configuration is set (when `uses_ancestor_config` is true),
       * or from which it *would* be set if this field had no index configuration
       * (when `uses_ancestor_config` is false).
       * </pre>
       *
       * <code>string ancestor_field = 3;</code>
       *
       * @param value The ancestorField to set.
       * @return This builder for chaining.
       */
      public Builder setAncestorField(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        ancestorField_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the resource name of the `Field` from which this field's
       * index configuration is set (when `uses_ancestor_config` is true),
       * or from which it *would* be set if this field had no index configuration
       * (when `uses_ancestor_config` is false).
       * </pre>
       *
       * <code>string ancestor_field = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAncestorField() {

        ancestorField_ = getDefaultInstance().getAncestorField();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the resource name of the `Field` from which this field's
       * index configuration is set (when `uses_ancestor_config` is true),
       * or from which it *would* be set if this field had no index configuration
       * (when `uses_ancestor_config` is false).
       * </pre>
       *
       * <code>string ancestor_field = 3;</code>
       *
       * @param value The bytes for ancestorField to set.
       * @return This builder for chaining.
       */
      public Builder setAncestorFieldBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        ancestorField_ = value;
        onChanged();
        return this;
      }

      private boolean reverting_;
      /**
       *
       *
       * <pre>
       * Output only
       * When true, the `Field`'s index configuration is in the process of being
       * reverted. Once complete, the index config will transition to the same
       * state as the field specified by `ancestor_field`, at which point
       * `uses_ancestor_config` will be `true` and `reverting` will be `false`.
       * </pre>
       *
       * <code>bool reverting = 4;</code>
       *
       * @return The reverting.
       */
      @java.lang.Override
      public boolean getReverting() {
        return reverting_;
      }
      /**
       *
       *
       * <pre>
       * Output only
       * When true, the `Field`'s index configuration is in the process of being
       * reverted. Once complete, the index config will transition to the same
       * state as the field specified by `ancestor_field`, at which point
       * `uses_ancestor_config` will be `true` and `reverting` will be `false`.
       * </pre>
       *
       * <code>bool reverting = 4;</code>
       *
       * @param value The reverting to set.
       * @return This builder for chaining.
       */
      public Builder setReverting(boolean value) {

        reverting_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only
       * When true, the `Field`'s index configuration is in the process of being
       * reverted. Once complete, the index config will transition to the same
       * state as the field specified by `ancestor_field`, at which point
       * `uses_ancestor_config` will be `true` and `reverting` will be `false`.
       * </pre>
       *
       * <code>bool reverting = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReverting() {

        reverting_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Field.IndexConfig)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Field.IndexConfig)
    private static final com.google.firestore.admin.v1.Field.IndexConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Field.IndexConfig();
    }

    public static com.google.firestore.admin.v1.Field.IndexConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IndexConfig> PARSER =
        new com.google.protobuf.AbstractParser<IndexConfig>() {
          @java.lang.Override
          public IndexConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IndexConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IndexConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IndexConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Field.IndexConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * A field name of the form
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
   * A field path may be a simple field name, e.g. `address` or a path to fields
   * within map_value , e.g. `address.city`,
   * or a special field path. The only valid special field is `*`, which
   * represents any field.
   * Field paths may be quoted using ` (backtick). The only character that needs
   * to be escaped within a quoted field path is the backtick character itself,
   * escaped using a backslash. Special characters in field paths that
   * must be quoted include: `*`, `.`,
   * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
   * Examples:
   * (Note: Comments here are written in markdown syntax, so there is an
   *  additional layer of backticks to represent a code block)
   * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
   * `city` in the field `address`.
   * `&#92;`*&#92;`` represents a field named `*`, not any field.
   * A special `Field` contains the default indexing settings for all fields.
   * This field's resource name is:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
   * Indexes defined on this `Field` will be applied to all fields which do not
   * have their own `Field` index configuration.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A field name of the form
   * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
   * A field path may be a simple field name, e.g. `address` or a path to fields
   * within map_value , e.g. `address.city`,
   * or a special field path. The only valid special field is `*`, which
   * represents any field.
   * Field paths may be quoted using ` (backtick). The only character that needs
   * to be escaped within a quoted field path is the backtick character itself,
   * escaped using a backslash. Special characters in field paths that
   * must be quoted include: `*`, `.`,
   * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
   * Examples:
   * (Note: Comments here are written in markdown syntax, so there is an
   *  additional layer of backticks to represent a code block)
   * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
   * `city` in the field `address`.
   * `&#92;`*&#92;`` represents a field named `*`, not any field.
   * A special `Field` contains the default indexing settings for all fields.
   * This field's resource name is:
   * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
   * Indexes defined on this `Field` will be applied to all fields which do not
   * have their own `Field` index configuration.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INDEX_CONFIG_FIELD_NUMBER = 2;
  private com.google.firestore.admin.v1.Field.IndexConfig indexConfig_;
  /**
   *
   *
   * <pre>
   * The index configuration for this field. If unset, field indexing will
   * revert to the configuration defined by the `ancestor_field`. To
   * explicitly remove all indexes for this field, specify an index config
   * with an empty list of indexes.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
   *
   * @return Whether the indexConfig field is set.
   */
  @java.lang.Override
  public boolean hasIndexConfig() {
    return indexConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The index configuration for this field. If unset, field indexing will
   * revert to the configuration defined by the `ancestor_field`. To
   * explicitly remove all indexes for this field, specify an index config
   * with an empty list of indexes.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
   *
   * @return The indexConfig.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Field.IndexConfig getIndexConfig() {
    return indexConfig_ == null
        ? com.google.firestore.admin.v1.Field.IndexConfig.getDefaultInstance()
        : indexConfig_;
  }
  /**
   *
   *
   * <pre>
   * The index configuration for this field. If unset, field indexing will
   * revert to the configuration defined by the `ancestor_field`. To
   * explicitly remove all indexes for this field, specify an index config
   * with an empty list of indexes.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Field.IndexConfigOrBuilder getIndexConfigOrBuilder() {
    return getIndexConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (indexConfig_ != null) {
      output.writeMessage(2, getIndexConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (indexConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getIndexConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.Field)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.Field other = (com.google.firestore.admin.v1.Field) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasIndexConfig() != other.hasIndexConfig()) return false;
    if (hasIndexConfig()) {
      if (!getIndexConfig().equals(other.getIndexConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasIndexConfig()) {
      hash = (37 * hash) + INDEX_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getIndexConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.Field parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Field parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Field parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Field parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.Field prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a single field in the database.
   * Fields are grouped by their "Collection Group", which represent all
   * collections in the database with the same id.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Field}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Field)
      com.google.firestore.admin.v1.FieldOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FieldProto
          .internal_static_google_firestore_admin_v1_Field_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FieldProto
          .internal_static_google_firestore_admin_v1_Field_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Field.class,
              com.google.firestore.admin.v1.Field.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.Field.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (indexConfigBuilder_ == null) {
        indexConfig_ = null;
      } else {
        indexConfig_ = null;
        indexConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.FieldProto
          .internal_static_google_firestore_admin_v1_Field_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Field getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.Field.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Field build() {
      com.google.firestore.admin.v1.Field result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Field buildPartial() {
      com.google.firestore.admin.v1.Field result = new com.google.firestore.admin.v1.Field(this);
      result.name_ = name_;
      if (indexConfigBuilder_ == null) {
        result.indexConfig_ = indexConfig_;
      } else {
        result.indexConfig_ = indexConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.Field) {
        return mergeFrom((com.google.firestore.admin.v1.Field) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.Field other) {
      if (other == com.google.firestore.admin.v1.Field.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasIndexConfig()) {
        mergeIndexConfig(other.getIndexConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.admin.v1.Field parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.admin.v1.Field) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A field name of the form
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
     * A field path may be a simple field name, e.g. `address` or a path to fields
     * within map_value , e.g. `address.city`,
     * or a special field path. The only valid special field is `*`, which
     * represents any field.
     * Field paths may be quoted using ` (backtick). The only character that needs
     * to be escaped within a quoted field path is the backtick character itself,
     * escaped using a backslash. Special characters in field paths that
     * must be quoted include: `*`, `.`,
     * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
     * Examples:
     * (Note: Comments here are written in markdown syntax, so there is an
     *  additional layer of backticks to represent a code block)
     * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
     * `city` in the field `address`.
     * `&#92;`*&#92;`` represents a field named `*`, not any field.
     * A special `Field` contains the default indexing settings for all fields.
     * This field's resource name is:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
     * Indexes defined on this `Field` will be applied to all fields which do not
     * have their own `Field` index configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A field name of the form
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
     * A field path may be a simple field name, e.g. `address` or a path to fields
     * within map_value , e.g. `address.city`,
     * or a special field path. The only valid special field is `*`, which
     * represents any field.
     * Field paths may be quoted using ` (backtick). The only character that needs
     * to be escaped within a quoted field path is the backtick character itself,
     * escaped using a backslash. Special characters in field paths that
     * must be quoted include: `*`, `.`,
     * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
     * Examples:
     * (Note: Comments here are written in markdown syntax, so there is an
     *  additional layer of backticks to represent a code block)
     * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
     * `city` in the field `address`.
     * `&#92;`*&#92;`` represents a field named `*`, not any field.
     * A special `Field` contains the default indexing settings for all fields.
     * This field's resource name is:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
     * Indexes defined on this `Field` will be applied to all fields which do not
     * have their own `Field` index configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A field name of the form
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
     * A field path may be a simple field name, e.g. `address` or a path to fields
     * within map_value , e.g. `address.city`,
     * or a special field path. The only valid special field is `*`, which
     * represents any field.
     * Field paths may be quoted using ` (backtick). The only character that needs
     * to be escaped within a quoted field path is the backtick character itself,
     * escaped using a backslash. Special characters in field paths that
     * must be quoted include: `*`, `.`,
     * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
     * Examples:
     * (Note: Comments here are written in markdown syntax, so there is an
     *  additional layer of backticks to represent a code block)
     * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
     * `city` in the field `address`.
     * `&#92;`*&#92;`` represents a field named `*`, not any field.
     * A special `Field` contains the default indexing settings for all fields.
     * This field's resource name is:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
     * Indexes defined on this `Field` will be applied to all fields which do not
     * have their own `Field` index configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field name of the form
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
     * A field path may be a simple field name, e.g. `address` or a path to fields
     * within map_value , e.g. `address.city`,
     * or a special field path. The only valid special field is `*`, which
     * represents any field.
     * Field paths may be quoted using ` (backtick). The only character that needs
     * to be escaped within a quoted field path is the backtick character itself,
     * escaped using a backslash. Special characters in field paths that
     * must be quoted include: `*`, `.`,
     * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
     * Examples:
     * (Note: Comments here are written in markdown syntax, so there is an
     *  additional layer of backticks to represent a code block)
     * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
     * `city` in the field `address`.
     * `&#92;`*&#92;`` represents a field named `*`, not any field.
     * A special `Field` contains the default indexing settings for all fields.
     * This field's resource name is:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
     * Indexes defined on this `Field` will be applied to all fields which do not
     * have their own `Field` index configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A field name of the form
     * `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_path}`
     * A field path may be a simple field name, e.g. `address` or a path to fields
     * within map_value , e.g. `address.city`,
     * or a special field path. The only valid special field is `*`, which
     * represents any field.
     * Field paths may be quoted using ` (backtick). The only character that needs
     * to be escaped within a quoted field path is the backtick character itself,
     * escaped using a backslash. Special characters in field paths that
     * must be quoted include: `*`, `.`,
     * ``` (backtick), `[`, `]`, as well as any ascii symbolic characters.
     * Examples:
     * (Note: Comments here are written in markdown syntax, so there is an
     *  additional layer of backticks to represent a code block)
     * `&#92;`address.city&#92;`` represents a field named `address.city`, not the map key
     * `city` in the field `address`.
     * `&#92;`*&#92;`` represents a field named `*`, not any field.
     * A special `Field` contains the default indexing settings for all fields.
     * This field's resource name is:
     * `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/&#42;`
     * Indexes defined on this `Field` will be applied to all fields which do not
     * have their own `Field` index configuration.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Field.IndexConfig indexConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Field.IndexConfig,
            com.google.firestore.admin.v1.Field.IndexConfig.Builder,
            com.google.firestore.admin.v1.Field.IndexConfigOrBuilder>
        indexConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     *
     * @return Whether the indexConfig field is set.
     */
    public boolean hasIndexConfig() {
      return indexConfigBuilder_ != null || indexConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     *
     * @return The indexConfig.
     */
    public com.google.firestore.admin.v1.Field.IndexConfig getIndexConfig() {
      if (indexConfigBuilder_ == null) {
        return indexConfig_ == null
            ? com.google.firestore.admin.v1.Field.IndexConfig.getDefaultInstance()
            : indexConfig_;
      } else {
        return indexConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public Builder setIndexConfig(com.google.firestore.admin.v1.Field.IndexConfig value) {
      if (indexConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        indexConfig_ = value;
        onChanged();
      } else {
        indexConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public Builder setIndexConfig(
        com.google.firestore.admin.v1.Field.IndexConfig.Builder builderForValue) {
      if (indexConfigBuilder_ == null) {
        indexConfig_ = builderForValue.build();
        onChanged();
      } else {
        indexConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public Builder mergeIndexConfig(com.google.firestore.admin.v1.Field.IndexConfig value) {
      if (indexConfigBuilder_ == null) {
        if (indexConfig_ != null) {
          indexConfig_ =
              com.google.firestore.admin.v1.Field.IndexConfig.newBuilder(indexConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          indexConfig_ = value;
        }
        onChanged();
      } else {
        indexConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public Builder clearIndexConfig() {
      if (indexConfigBuilder_ == null) {
        indexConfig_ = null;
        onChanged();
      } else {
        indexConfig_ = null;
        indexConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public com.google.firestore.admin.v1.Field.IndexConfig.Builder getIndexConfigBuilder() {

      onChanged();
      return getIndexConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    public com.google.firestore.admin.v1.Field.IndexConfigOrBuilder getIndexConfigOrBuilder() {
      if (indexConfigBuilder_ != null) {
        return indexConfigBuilder_.getMessageOrBuilder();
      } else {
        return indexConfig_ == null
            ? com.google.firestore.admin.v1.Field.IndexConfig.getDefaultInstance()
            : indexConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The index configuration for this field. If unset, field indexing will
     * revert to the configuration defined by the `ancestor_field`. To
     * explicitly remove all indexes for this field, specify an index config
     * with an empty list of indexes.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Field.IndexConfig index_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Field.IndexConfig,
            com.google.firestore.admin.v1.Field.IndexConfig.Builder,
            com.google.firestore.admin.v1.Field.IndexConfigOrBuilder>
        getIndexConfigFieldBuilder() {
      if (indexConfigBuilder_ == null) {
        indexConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Field.IndexConfig,
                com.google.firestore.admin.v1.Field.IndexConfig.Builder,
                com.google.firestore.admin.v1.Field.IndexConfigOrBuilder>(
                getIndexConfig(), getParentForChildren(), isClean());
        indexConfig_ = null;
      }
      return indexConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Field)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Field)
  private static final com.google.firestore.admin.v1.Field DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Field();
  }

  public static com.google.firestore.admin.v1.Field getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Field> PARSER =
      new com.google.protobuf.AbstractParser<Field>() {
        @java.lang.Override
        public Field parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Field(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Field> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Field> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.Field getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
