/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

package com.google.firestore.admin.v1;

public interface ImportDocumentsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.ImportDocumentsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Database to import into. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. Database to import into. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Which collection ids to import. Unspecified means all collections included
   * in the import.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return A list containing the collectionIds.
   */
  java.util.List<java.lang.String> getCollectionIdsList();
  /**
   *
   *
   * <pre>
   * Which collection ids to import. Unspecified means all collections included
   * in the import.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return The count of collectionIds.
   */
  int getCollectionIdsCount();
  /**
   *
   *
   * <pre>
   * Which collection ids to import. Unspecified means all collections included
   * in the import.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  java.lang.String getCollectionIds(int index);
  /**
   *
   *
   * <pre>
   * Which collection ids to import. Unspecified means all collections included
   * in the import.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  com.google.protobuf.ByteString getCollectionIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Location of the exported files.
   * This must match the output_uri_prefix of an ExportDocumentsResponse from
   * an export that has completed successfully.
   * See:
   * [google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix].
   * </pre>
   *
   * <code>string input_uri_prefix = 3;</code>
   *
   * @return The inputUriPrefix.
   */
  java.lang.String getInputUriPrefix();
  /**
   *
   *
   * <pre>
   * Location of the exported files.
   * This must match the output_uri_prefix of an ExportDocumentsResponse from
   * an export that has completed successfully.
   * See:
   * [google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix].
   * </pre>
   *
   * <code>string input_uri_prefix = 3;</code>
   *
   * @return The bytes for inputUriPrefix.
   */
  com.google.protobuf.ByteString getInputUriPrefixBytes();
}
