/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IndexName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE_COLLECTION_INDEX = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/collectionGroups/{collection}/indexes/{index}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;
    private final String collection;
    private final String index;

    @Deprecated
    protected IndexName() {
        this.project = null;
        this.database = null;
        this.collection = null;
        this.index = null;
    }

    private IndexName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.index = (String)Preconditions.checkNotNull((Object)builder.getIndex());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getIndex() {
        return this.index;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IndexName of(String project, String database, String collection, String index) {
        return IndexName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).setIndex(index).build();
    }

    public static String format(String project, String database, String collection, String index) {
        return IndexName.newBuilder().setProject(project).setDatabase(database).setCollection(collection).setIndex(index).build().toString();
    }

    public static IndexName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE_COLLECTION_INDEX.validatedMatch(formattedString, "IndexName.parse: formattedString not in valid format");
        return IndexName.of((String)matchMap.get("project"), (String)matchMap.get("database"), (String)matchMap.get("collection"), (String)matchMap.get("index"));
    }

    public static List<IndexName> parseList(List<String> formattedStrings) {
        ArrayList<IndexName> list = new ArrayList<IndexName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IndexName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IndexName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IndexName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE_COLLECTION_INDEX.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IndexName indexName = this;
            synchronized (indexName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.index != null) {
                        fieldMapBuilder.put((Object)"index", (Object)this.index);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE_COLLECTION_INDEX.instantiate(new String[]{"project", this.project, "database", this.database, "collection", this.collection, "index", this.index});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            IndexName that = (IndexName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.index, that.index);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.index);
    }

    public static class Builder {
        private String project;
        private String database;
        private String collection;
        private String index;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getIndex() {
            return this.index;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        private Builder(IndexName indexName) {
            this.project = indexName.project;
            this.database = indexName.database;
            this.collection = indexName.collection;
            this.index = indexName.index;
        }

        public IndexName build() {
            return new IndexName(this);
        }
    }
}

