/*
 * Decompiled with CFR 0.152.
 */
package com.google.firestore.admin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatabaseName
implements ResourceName {
    private static final PathTemplate PROJECT_DATABASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String database;

    @Deprecated
    protected DatabaseName() {
        this.project = null;
        this.database = null;
    }

    private DatabaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
    }

    public String getProject() {
        return this.project;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatabaseName of(String project, String database) {
        return DatabaseName.newBuilder().setProject(project).setDatabase(database).build();
    }

    public static String format(String project, String database) {
        return DatabaseName.newBuilder().setProject(project).setDatabase(database).build().toString();
    }

    public static DatabaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATABASE.validatedMatch(formattedString, "DatabaseName.parse: formattedString not in valid format");
        return DatabaseName.of((String)matchMap.get("project"), (String)matchMap.get("database"));
    }

    public static List<DatabaseName> parseList(List<String> formattedStrings) {
        ArrayList<DatabaseName> list = new ArrayList<DatabaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatabaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatabaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatabaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATABASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatabaseName databaseName = this;
            synchronized (databaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATABASE.instantiate(new String[]{"project", this.project, "database", this.database});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DatabaseName that = (DatabaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.database, that.database);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.database);
    }

    public static class Builder {
        private String project;
        private String database;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder(DatabaseName databaseName) {
            this.project = databaseName.project;
            this.database = databaseName.database;
        }

        public DatabaseName build() {
            return new DatabaseName(this);
        }
    }
}

