/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/operation.proto

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Metadata for [google.longrunning.Operation][google.longrunning.Operation]
 * results from
 * [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.ExportDocumentsMetadata}
 */
public final class ExportDocumentsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.ExportDocumentsMetadata)
    ExportDocumentsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportDocumentsMetadata.newBuilder() to construct.
  private ExportDocumentsMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportDocumentsMetadata() {
    operationState_ = 0;
    collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    outputUriPrefix_ = "";
    namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportDocumentsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_ExportDocumentsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_ExportDocumentsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.ExportDocumentsMetadata.class,
            com.google.firestore.admin.v1.ExportDocumentsMetadata.Builder.class);
  }

  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time this operation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time this operation completed. Will be unset if operation still in
   * progress.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int OPERATION_STATE_FIELD_NUMBER = 3;
  private int operationState_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the export operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The enum numeric value on the wire for operationState.
   */
  @java.lang.Override
  public int getOperationStateValue() {
    return operationState_;
  }
  /**
   *
   *
   * <pre>
   * The state of the export operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The operationState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.OperationState getOperationState() {
    com.google.firestore.admin.v1.OperationState result =
        com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
    return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
  }

  public static final int PROGRESS_DOCUMENTS_FIELD_NUMBER = 4;
  private com.google.firestore.admin.v1.Progress progressDocuments_;
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   *
   * @return Whether the progressDocuments field is set.
   */
  @java.lang.Override
  public boolean hasProgressDocuments() {
    return progressDocuments_ != null;
  }
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   *
   * @return The progressDocuments.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressDocuments() {
    return progressDocuments_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressDocuments_;
  }
  /**
   *
   *
   * <pre>
   * The progress, in documents, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
    return progressDocuments_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressDocuments_;
  }

  public static final int PROGRESS_BYTES_FIELD_NUMBER = 5;
  private com.google.firestore.admin.v1.Progress progressBytes_;
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   *
   * @return Whether the progressBytes field is set.
   */
  @java.lang.Override
  public boolean hasProgressBytes() {
    return progressBytes_ != null;
  }
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   *
   * @return The progressBytes.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressBytes() {
    return progressBytes_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressBytes_;
  }
  /**
   *
   *
   * <pre>
   * The progress, in bytes, of this operation.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
    return progressBytes_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressBytes_;
  }

  public static final int COLLECTION_IDS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList collectionIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Which collection ids are being exported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @return A list containing the collectionIds.
   */
  public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
    return collectionIds_;
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being exported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @return The count of collectionIds.
   */
  public int getCollectionIdsCount() {
    return collectionIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being exported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  public java.lang.String getCollectionIds(int index) {
    return collectionIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which collection ids are being exported.
   * </pre>
   *
   * <code>repeated string collection_ids = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
    return collectionIds_.getByteString(index);
  }

  public static final int OUTPUT_URI_PREFIX_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputUriPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Where the documents are being exported to.
   * </pre>
   *
   * <code>string output_uri_prefix = 7;</code>
   *
   * @return The outputUriPrefix.
   */
  @java.lang.Override
  public java.lang.String getOutputUriPrefix() {
    java.lang.Object ref = outputUriPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUriPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Where the documents are being exported to.
   * </pre>
   *
   * <code>string output_uri_prefix = 7;</code>
   *
   * @return The bytes for outputUriPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
    java.lang.Object ref = outputUriPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUriPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACE_IDS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList namespaceIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Which namespace ids are being exported.
   * </pre>
   *
   * <code>repeated string namespace_ids = 8;</code>
   *
   * @return A list containing the namespaceIds.
   */
  public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
    return namespaceIds_;
  }
  /**
   *
   *
   * <pre>
   * Which namespace ids are being exported.
   * </pre>
   *
   * <code>repeated string namespace_ids = 8;</code>
   *
   * @return The count of namespaceIds.
   */
  public int getNamespaceIdsCount() {
    return namespaceIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Which namespace ids are being exported.
   * </pre>
   *
   * <code>repeated string namespace_ids = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The namespaceIds at the given index.
   */
  public java.lang.String getNamespaceIds(int index) {
    return namespaceIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which namespace ids are being exported.
   * </pre>
   *
   * <code>repeated string namespace_ids = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the namespaceIds at the given index.
   */
  public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
    return namespaceIds_.getByteString(index);
  }

  public static final int SNAPSHOT_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp snapshotTime_;
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database that is being
   * exported. If unspecified, there are no guarantees about the consistency of
   * the documents being exported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
   *
   * @return Whether the snapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotTime() {
    return snapshotTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database that is being
   * exported. If unspecified, there are no guarantees about the consistency of
   * the documents being exported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
   *
   * @return The snapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSnapshotTime() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database that is being
   * exported. If unspecified, there are no guarantees about the consistency of
   * the documents being exported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (startTime_ != null) {
      output.writeMessage(1, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, operationState_);
    }
    if (progressDocuments_ != null) {
      output.writeMessage(4, getProgressDocuments());
    }
    if (progressBytes_ != null) {
      output.writeMessage(5, getProgressBytes());
    }
    for (int i = 0; i < collectionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, collectionIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, outputUriPrefix_);
    }
    for (int i = 0; i < namespaceIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, namespaceIds_.getRaw(i));
    }
    if (snapshotTime_ != null) {
      output.writeMessage(9, getSnapshotTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operationState_);
    }
    if (progressDocuments_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getProgressDocuments());
    }
    if (progressBytes_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getProgressBytes());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < collectionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(collectionIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCollectionIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, outputUriPrefix_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < namespaceIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(namespaceIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNamespaceIdsList().size();
    }
    if (snapshotTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSnapshotTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.ExportDocumentsMetadata)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.ExportDocumentsMetadata other =
        (com.google.firestore.admin.v1.ExportDocumentsMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (operationState_ != other.operationState_) return false;
    if (hasProgressDocuments() != other.hasProgressDocuments()) return false;
    if (hasProgressDocuments()) {
      if (!getProgressDocuments().equals(other.getProgressDocuments())) return false;
    }
    if (hasProgressBytes() != other.hasProgressBytes()) return false;
    if (hasProgressBytes()) {
      if (!getProgressBytes().equals(other.getProgressBytes())) return false;
    }
    if (!getCollectionIdsList().equals(other.getCollectionIdsList())) return false;
    if (!getOutputUriPrefix().equals(other.getOutputUriPrefix())) return false;
    if (!getNamespaceIdsList().equals(other.getNamespaceIdsList())) return false;
    if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
    if (hasSnapshotTime()) {
      if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + operationState_;
    if (hasProgressDocuments()) {
      hash = (37 * hash) + PROGRESS_DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getProgressDocuments().hashCode();
    }
    if (hasProgressBytes()) {
      hash = (37 * hash) + PROGRESS_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + getProgressBytes().hashCode();
    }
    if (getCollectionIdsCount() > 0) {
      hash = (37 * hash) + COLLECTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionIdsList().hashCode();
    }
    hash = (37 * hash) + OUTPUT_URI_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUriPrefix().hashCode();
    if (getNamespaceIdsCount() > 0) {
      hash = (37 * hash) + NAMESPACE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getNamespaceIdsList().hashCode();
    }
    if (hasSnapshotTime()) {
      hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.firestore.admin.v1.ExportDocumentsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for [google.longrunning.Operation][google.longrunning.Operation]
   * results from
   * [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.ExportDocumentsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.ExportDocumentsMetadata)
      com.google.firestore.admin.v1.ExportDocumentsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.ExportDocumentsMetadata.class,
              com.google.firestore.admin.v1.ExportDocumentsMetadata.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.ExportDocumentsMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      operationState_ = 0;
      progressDocuments_ = null;
      if (progressDocumentsBuilder_ != null) {
        progressDocumentsBuilder_.dispose();
        progressDocumentsBuilder_ = null;
      }
      progressBytes_ = null;
      if (progressBytesBuilder_ != null) {
        progressBytesBuilder_.dispose();
        progressBytesBuilder_ = null;
      }
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      outputUriPrefix_ = "";
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsMetadata getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.ExportDocumentsMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsMetadata build() {
      com.google.firestore.admin.v1.ExportDocumentsMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsMetadata buildPartial() {
      com.google.firestore.admin.v1.ExportDocumentsMetadata result =
          new com.google.firestore.admin.v1.ExportDocumentsMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.ExportDocumentsMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationState_ = operationState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.progressDocuments_ =
            progressDocumentsBuilder_ == null
                ? progressDocuments_
                : progressDocumentsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.progressBytes_ =
            progressBytesBuilder_ == null ? progressBytes_ : progressBytesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        collectionIds_.makeImmutable();
        result.collectionIds_ = collectionIds_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.outputUriPrefix_ = outputUriPrefix_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        namespaceIds_.makeImmutable();
        result.namespaceIds_ = namespaceIds_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.snapshotTime_ =
            snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.ExportDocumentsMetadata) {
        return mergeFrom((com.google.firestore.admin.v1.ExportDocumentsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.ExportDocumentsMetadata other) {
      if (other == com.google.firestore.admin.v1.ExportDocumentsMetadata.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.operationState_ != 0) {
        setOperationStateValue(other.getOperationStateValue());
      }
      if (other.hasProgressDocuments()) {
        mergeProgressDocuments(other.getProgressDocuments());
      }
      if (other.hasProgressBytes()) {
        mergeProgressBytes(other.getProgressBytes());
      }
      if (!other.collectionIds_.isEmpty()) {
        if (collectionIds_.isEmpty()) {
          collectionIds_ = other.collectionIds_;
          bitField0_ |= 0x00000020;
        } else {
          ensureCollectionIdsIsMutable();
          collectionIds_.addAll(other.collectionIds_);
        }
        onChanged();
      }
      if (!other.getOutputUriPrefix().isEmpty()) {
        outputUriPrefix_ = other.outputUriPrefix_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.namespaceIds_.isEmpty()) {
        if (namespaceIds_.isEmpty()) {
          namespaceIds_ = other.namespaceIds_;
          bitField0_ |= 0x00000080;
        } else {
          ensureNamespaceIdsIsMutable();
          namespaceIds_.addAll(other.namespaceIds_);
        }
        onChanged();
      }
      if (other.hasSnapshotTime()) {
        mergeSnapshotTime(other.getSnapshotTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                operationState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getProgressDocumentsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getProgressBytesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCollectionIdsIsMutable();
                collectionIds_.add(s);
                break;
              } // case 50
            case 58:
              {
                outputUriPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNamespaceIdsIsMutable();
                namespaceIds_.add(s);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time this operation completed. Will be unset if operation still in
     * progress.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int operationState_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the export operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The enum numeric value on the wire for operationState.
     */
    @java.lang.Override
    public int getOperationStateValue() {
      return operationState_;
    }
    /**
     *
     *
     * <pre>
     * The state of the export operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The enum numeric value on the wire for operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationStateValue(int value) {
      operationState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the export operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The operationState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.OperationState getOperationState() {
      com.google.firestore.admin.v1.OperationState result =
          com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
      return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the export operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationState(com.google.firestore.admin.v1.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      operationState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the export operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationState_ = 0;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Progress progressDocuments_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressDocumentsBuilder_;
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     *
     * @return Whether the progressDocuments field is set.
     */
    public boolean hasProgressDocuments() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     *
     * @return The progressDocuments.
     */
    public com.google.firestore.admin.v1.Progress getProgressDocuments() {
      if (progressDocumentsBuilder_ == null) {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      } else {
        return progressDocumentsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder setProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressDocuments_ = value;
      } else {
        progressDocumentsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder setProgressDocuments(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressDocumentsBuilder_ == null) {
        progressDocuments_ = builderForValue.build();
      } else {
        progressDocumentsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder mergeProgressDocuments(com.google.firestore.admin.v1.Progress value) {
      if (progressDocumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && progressDocuments_ != null
            && progressDocuments_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressDocumentsBuilder().mergeFrom(value);
        } else {
          progressDocuments_ = value;
        }
      } else {
        progressDocumentsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public Builder clearProgressDocuments() {
      bitField0_ = (bitField0_ & ~0x00000008);
      progressDocuments_ = null;
      if (progressDocumentsBuilder_ != null) {
        progressDocumentsBuilder_.dispose();
        progressDocumentsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressDocumentsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getProgressDocumentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressDocumentsOrBuilder() {
      if (progressDocumentsBuilder_ != null) {
        return progressDocumentsBuilder_.getMessageOrBuilder();
      } else {
        return progressDocuments_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressDocuments_;
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in documents, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_documents = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressDocumentsFieldBuilder() {
      if (progressDocumentsBuilder_ == null) {
        progressDocumentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressDocuments(), getParentForChildren(), isClean());
        progressDocuments_ = null;
      }
      return progressDocumentsBuilder_;
    }

    private com.google.firestore.admin.v1.Progress progressBytes_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressBytesBuilder_;
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     *
     * @return Whether the progressBytes field is set.
     */
    public boolean hasProgressBytes() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     *
     * @return The progressBytes.
     */
    public com.google.firestore.admin.v1.Progress getProgressBytes() {
      if (progressBytesBuilder_ == null) {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      } else {
        return progressBytesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder setProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressBytes_ = value;
      } else {
        progressBytesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder setProgressBytes(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressBytesBuilder_ == null) {
        progressBytes_ = builderForValue.build();
      } else {
        progressBytesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder mergeProgressBytes(com.google.firestore.admin.v1.Progress value) {
      if (progressBytesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && progressBytes_ != null
            && progressBytes_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressBytesBuilder().mergeFrom(value);
        } else {
          progressBytes_ = value;
        }
      } else {
        progressBytesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public Builder clearProgressBytes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      progressBytes_ = null;
      if (progressBytesBuilder_ != null) {
        progressBytesBuilder_.dispose();
        progressBytesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressBytesBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getProgressBytesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressBytesOrBuilder() {
      if (progressBytesBuilder_ != null) {
        return progressBytesBuilder_.getMessageOrBuilder();
      } else {
        return progressBytes_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressBytes_;
      }
    }
    /**
     *
     *
     * <pre>
     * The progress, in bytes, of this operation.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_bytes = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressBytesFieldBuilder() {
      if (progressBytesBuilder_ == null) {
        progressBytesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressBytes(), getParentForChildren(), isClean());
        progressBytes_ = null;
      }
      return progressBytesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList collectionIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCollectionIdsIsMutable() {
      if (!collectionIds_.isModifiable()) {
        collectionIds_ = new com.google.protobuf.LazyStringArrayList(collectionIds_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return A list containing the collectionIds.
     */
    public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
      collectionIds_.makeImmutable();
      return collectionIds_;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return The count of collectionIds.
     */
    public int getCollectionIdsCount() {
      return collectionIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The collectionIds at the given index.
     */
    public java.lang.String getCollectionIds(int index) {
      return collectionIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the collectionIds at the given index.
     */
    public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
      return collectionIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The collectionIds to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param value The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param values The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCollectionIds(java.lang.Iterable<java.lang.String> values) {
      ensureCollectionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, collectionIds_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionIds() {
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids are being exported.
     * </pre>
     *
     * <code>repeated string collection_ids = 6;</code>
     *
     * @param value The bytes of the collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object outputUriPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Where the documents are being exported to.
     * </pre>
     *
     * <code>string output_uri_prefix = 7;</code>
     *
     * @return The outputUriPrefix.
     */
    public java.lang.String getOutputUriPrefix() {
      java.lang.Object ref = outputUriPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUriPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Where the documents are being exported to.
     * </pre>
     *
     * <code>string output_uri_prefix = 7;</code>
     *
     * @return The bytes for outputUriPrefix.
     */
    public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
      java.lang.Object ref = outputUriPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUriPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Where the documents are being exported to.
     * </pre>
     *
     * <code>string output_uri_prefix = 7;</code>
     *
     * @param value The outputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputUriPrefix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the documents are being exported to.
     * </pre>
     *
     * <code>string output_uri_prefix = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputUriPrefix() {
      outputUriPrefix_ = getDefaultInstance().getOutputUriPrefix();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the documents are being exported to.
     * </pre>
     *
     * <code>string output_uri_prefix = 7;</code>
     *
     * @param value The bytes for outputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputUriPrefix_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList namespaceIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNamespaceIdsIsMutable() {
      if (!namespaceIds_.isModifiable()) {
        namespaceIds_ = new com.google.protobuf.LazyStringArrayList(namespaceIds_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @return A list containing the namespaceIds.
     */
    public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
      namespaceIds_.makeImmutable();
      return namespaceIds_;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @return The count of namespaceIds.
     */
    public int getNamespaceIdsCount() {
      return namespaceIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The namespaceIds at the given index.
     */
    public java.lang.String getNamespaceIds(int index) {
      return namespaceIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the namespaceIds at the given index.
     */
    public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
      return namespaceIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The namespaceIds to set.
     * @return This builder for chaining.
     */
    public Builder setNamespaceIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param value The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param values The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllNamespaceIds(java.lang.Iterable<java.lang.String> values) {
      ensureNamespaceIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namespaceIds_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespaceIds() {
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which namespace ids are being exported.
     * </pre>
     *
     * <code>repeated string namespace_ids = 8;</code>
     *
     * @param value The bytes of the namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp snapshotTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        snapshotTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      if (snapshotTimeBuilder_ == null) {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      } else {
        return snapshotTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotTime_ = value;
      } else {
        snapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (snapshotTimeBuilder_ == null) {
        snapshotTime_ = builderForValue.build();
      } else {
        snapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && snapshotTime_ != null
            && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSnapshotTimeBuilder().mergeFrom(value);
        } else {
          snapshotTime_ = value;
        }
      } else {
        snapshotTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public Builder clearSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSnapshotTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      if (snapshotTimeBuilder_ != null) {
        return snapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database that is being
     * exported. If unspecified, there are no guarantees about the consistency of
     * the documents being exported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSnapshotTimeFieldBuilder() {
      if (snapshotTimeBuilder_ == null) {
        snapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSnapshotTime(), getParentForChildren(), isClean());
        snapshotTime_ = null;
      }
      return snapshotTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.ExportDocumentsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.ExportDocumentsMetadata)
  private static final com.google.firestore.admin.v1.ExportDocumentsMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.ExportDocumentsMetadata();
  }

  public static com.google.firestore.admin.v1.ExportDocumentsMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportDocumentsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ExportDocumentsMetadata>() {
        @java.lang.Override
        public ExportDocumentsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportDocumentsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportDocumentsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.ExportDocumentsMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
