/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

// Protobuf Java Version: 3.25.2
package com.google.firestore.admin.v1;

public interface ExportDocumentsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.firestore.admin.v1.ExportDocumentsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Database to export. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. Database to export. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return A list containing the collectionIds.
   */
  java.util.List<java.lang.String> getCollectionIdsList();
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return The count of collectionIds.
   */
  int getCollectionIdsCount();
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  java.lang.String getCollectionIds(int index);
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  com.google.protobuf.ByteString getCollectionIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * The output URI. Currently only supports Google Cloud Storage URIs of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
   * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
   * Google Cloud Storage namespace path. When
   * choosing a name, be sure to consider Google Cloud Storage naming
   * guidelines: https://cloud.google.com/storage/docs/naming.
   * If the URI is a bucket (without a namespace path), a prefix will be
   * generated based on the start time.
   * </pre>
   *
   * <code>string output_uri_prefix = 3;</code>
   *
   * @return The outputUriPrefix.
   */
  java.lang.String getOutputUriPrefix();
  /**
   *
   *
   * <pre>
   * The output URI. Currently only supports Google Cloud Storage URIs of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
   * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
   * Google Cloud Storage namespace path. When
   * choosing a name, be sure to consider Google Cloud Storage naming
   * guidelines: https://cloud.google.com/storage/docs/naming.
   * If the URI is a bucket (without a namespace path), a prefix will be
   * generated based on the start time.
   * </pre>
   *
   * <code>string output_uri_prefix = 3;</code>
   *
   * @return The bytes for outputUriPrefix.
   */
  com.google.protobuf.ByteString getOutputUriPrefixBytes();

  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @return A list containing the namespaceIds.
   */
  java.util.List<java.lang.String> getNamespaceIdsList();
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @return The count of namespaceIds.
   */
  int getNamespaceIdsCount();
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The namespaceIds at the given index.
   */
  java.lang.String getNamespaceIds(int index);
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the namespaceIds at the given index.
   */
  com.google.protobuf.ByteString getNamespaceIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   *
   * @return Whether the snapshotTime field is set.
   */
  boolean hasSnapshotTime();
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   *
   * @return The snapshotTime.
   */
  com.google.protobuf.Timestamp getSnapshotTime();
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   */
  com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder();
}
