/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/database.proto

package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A Cloud Firestore Database.
 * Currently only one database is allowed per cloud project; this database
 * must have a `database_id` of '(default)'.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.Database}
 */
public final class Database extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database)
    DatabaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Database.newBuilder() to construct.
  private Database(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Database() {
    name_ = "";
    locationId_ = "";
    type_ = 0;
    concurrencyMode_ = 0;
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Database();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Database(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              locationId_ = s;
              break;
            }
          case 80:
            {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
          case 120:
            {
              int rawValue = input.readEnum();

              concurrencyMode_ = rawValue;
              break;
            }
          case 794:
            {
              java.lang.String s = input.readStringRequireUtf8();

              etag_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.Database.class,
            com.google.firestore.admin.v1.Database.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DatabaseType}
   */
  public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the database type is omitted.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    DATABASE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    FIRESTORE_NATIVE(1),
    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    DATASTORE_MODE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the database type is omitted.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    public static final int FIRESTORE_NATIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    public static final int DATASTORE_MODE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseType forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_TYPE_UNSPECIFIED;
        case 1:
          return FIRESTORE_NATIVE;
        case 2:
          return DATASTORE_MODE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
          public DatabaseType findValueByNumber(int number) {
            return DatabaseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(0);
    }

    private static final DatabaseType[] VALUES = values();

    public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DatabaseType)
  }

  /**
   *
   *
   * <pre>
   * The type of concurrency control mode for transactions.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.ConcurrencyMode}
   */
  public enum ConcurrencyMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    CONCURRENCY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This setting is available
     * for Cloud Firestore customers.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    OPTIMISTIC(1),
    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This setting is available
     * for Cloud Firestore customers.
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    PESSIMISTIC(2),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default. This is
     * the only available setting for Cloud Datastore customers.
     * This is the default setting for Cloud Datastore.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    OPTIMISTIC_WITH_ENTITY_GROUPS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONCURRENCY_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This setting is available
     * for Cloud Firestore customers.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    public static final int OPTIMISTIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This setting is available
     * for Cloud Firestore customers.
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    public static final int PESSIMISTIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default. This is
     * the only available setting for Cloud Datastore customers.
     * This is the default setting for Cloud Datastore.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    public static final int OPTIMISTIC_WITH_ENTITY_GROUPS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConcurrencyMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConcurrencyMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONCURRENCY_MODE_UNSPECIFIED;
        case 1:
          return OPTIMISTIC;
        case 2:
          return PESSIMISTIC;
        case 3:
          return OPTIMISTIC_WITH_ENTITY_GROUPS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>() {
              public ConcurrencyMode findValueByNumber(int number) {
                return ConcurrencyMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(1);
    }

    private static final ConcurrencyMode[] VALUES = values();

    public static ConcurrencyMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConcurrencyMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.ConcurrencyMode)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 9;
  private volatile java.lang.Object locationId_;
  /**
   *
   *
   * <pre>
   * The location of the database. Available databases are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The location of the database. Available databases are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 10;
  private int type_;
  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DatabaseType getType() {
    @SuppressWarnings("deprecation")
    com.google.firestore.admin.v1.Database.DatabaseType result =
        com.google.firestore.admin.v1.Database.DatabaseType.valueOf(type_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
        : result;
  }

  public static final int CONCURRENCY_MODE_FIELD_NUMBER = 15;
  private int concurrencyMode_;
  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The enum numeric value on the wire for concurrencyMode.
   */
  @java.lang.Override
  public int getConcurrencyModeValue() {
    return concurrencyMode_;
  }
  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The concurrencyMode.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
    @SuppressWarnings("deprecation")
    com.google.firestore.admin.v1.Database.ConcurrencyMode result =
        com.google.firestore.admin.v1.Database.ConcurrencyMode.valueOf(concurrencyMode_);
    return result == null
        ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
        : result;
  }

  public static final int ETAG_FIELD_NUMBER = 99;
  private volatile java.lang.Object etag_;
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, concurrencyMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, concurrencyMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.Database)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.Database other = (com.google.firestore.admin.v1.Database) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (type_ != other.type_) return false;
    if (concurrencyMode_ != other.concurrencyMode_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + CONCURRENCY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + concurrencyMode_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.Database prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Cloud Firestore Database.
   * Currently only one database is allowed per cloud project; this database
   * must have a `database_id` of '(default)'.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database)
      com.google.firestore.admin.v1.DatabaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.class,
              com.google.firestore.admin.v1.Database.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.Database.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      locationId_ = "";

      type_ = 0;

      concurrencyMode_ = 0;

      etag_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.Database.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database build() {
      com.google.firestore.admin.v1.Database result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database buildPartial() {
      com.google.firestore.admin.v1.Database result =
          new com.google.firestore.admin.v1.Database(this);
      result.name_ = name_;
      result.locationId_ = locationId_;
      result.type_ = type_;
      result.concurrencyMode_ = concurrencyMode_;
      result.etag_ = etag_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.Database) {
        return mergeFrom((com.google.firestore.admin.v1.Database) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.Database other) {
      if (other == com.google.firestore.admin.v1.Database.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.concurrencyMode_ != 0) {
        setConcurrencyModeValue(other.getConcurrencyModeValue());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.admin.v1.Database parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.admin.v1.Database) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * The location of the database. Available databases are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available databases are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available databases are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available databases are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {

      locationId_ = getDefaultInstance().getLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available databases are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationId_ = value;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DatabaseType getType() {
      @SuppressWarnings("deprecation")
      com.google.firestore.admin.v1.Database.DatabaseType result =
          com.google.firestore.admin.v1.Database.DatabaseType.valueOf(type_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.firestore.admin.v1.Database.DatabaseType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = 0;
      onChanged();
      return this;
    }

    private int concurrencyMode_ = 0;
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    @java.lang.Override
    public int getConcurrencyModeValue() {
      return concurrencyMode_;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The enum numeric value on the wire for concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyModeValue(int value) {

      concurrencyMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The concurrencyMode.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
      @SuppressWarnings("deprecation")
      com.google.firestore.admin.v1.Database.ConcurrencyMode result =
          com.google.firestore.admin.v1.Database.ConcurrencyMode.valueOf(concurrencyMode_);
      return result == null
          ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyMode(
        com.google.firestore.admin.v1.Database.ConcurrencyMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      concurrencyMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConcurrencyMode() {

      concurrencyMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      etag_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {

      etag_ = getDefaultInstance().getEtag();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      etag_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database)
  private static final com.google.firestore.admin.v1.Database DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database();
  }

  public static com.google.firestore.admin.v1.Database getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Database> PARSER =
      new com.google.protobuf.AbstractParser<Database>() {
        @java.lang.Override
        public Database parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Database(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Database> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Database> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
