/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/operation.proto

// Protobuf Java Version: 3.25.2
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * Metadata for the [long-running operation][google.longrunning.Operation] from
 * the [RestoreDatabase][google.firestore.admin.v1.RestoreDatabase] request.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.RestoreDatabaseMetadata}
 */
public final class RestoreDatabaseMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.RestoreDatabaseMetadata)
    RestoreDatabaseMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RestoreDatabaseMetadata.newBuilder() to construct.
  private RestoreDatabaseMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RestoreDatabaseMetadata() {
    operationState_ = 0;
    database_ = "";
    backup_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RestoreDatabaseMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_RestoreDatabaseMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.OperationProto
        .internal_static_google_firestore_admin_v1_RestoreDatabaseMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.RestoreDatabaseMetadata.class,
            com.google.firestore.admin.v1.RestoreDatabaseMetadata.Builder.class);
  }

  private int bitField0_;
  public static final int START_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time the restore was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the restore was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the restore was started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time the restore finished, unset for ongoing restores.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time the restore finished, unset for ongoing restores.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the restore finished, unset for ongoing restores.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int OPERATION_STATE_FIELD_NUMBER = 3;
  private int operationState_ = 0;
  /**
   *
   *
   * <pre>
   * The operation state of the restore.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The enum numeric value on the wire for operationState.
   */
  @java.lang.Override
  public int getOperationStateValue() {
    return operationState_;
  }
  /**
   *
   *
   * <pre>
   * The operation state of the restore.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
   *
   * @return The operationState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.OperationState getOperationState() {
    com.google.firestore.admin.v1.OperationState result =
        com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
    return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
  }

  public static final int DATABASE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";
  /**
   *
   *
   * <pre>
   * The name of the database being restored to.
   * </pre>
   *
   * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the database being restored to.
   * </pre>
   *
   * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backup_ = "";
  /**
   *
   *
   * <pre>
   * The name of the backup restoring from.
   * </pre>
   *
   * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The backup.
   */
  @java.lang.Override
  public java.lang.String getBackup() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the backup restoring from.
   * </pre>
   *
   * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for backup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupBytes() {
    java.lang.Object ref = backup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROGRESS_PERCENTAGE_FIELD_NUMBER = 8;
  private com.google.firestore.admin.v1.Progress progressPercentage_;
  /**
   *
   *
   * <pre>
   * How far along the restore is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
   *
   * @return Whether the progressPercentage field is set.
   */
  @java.lang.Override
  public boolean hasProgressPercentage() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * How far along the restore is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
   *
   * @return The progressPercentage.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Progress getProgressPercentage() {
    return progressPercentage_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressPercentage_;
  }
  /**
   *
   *
   * <pre>
   * How far along the restore is as an estimated percentage of remaining time.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.ProgressOrBuilder getProgressPercentageOrBuilder() {
    return progressPercentage_ == null
        ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
        : progressPercentage_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, operationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, database_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, backup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getProgressPercentage());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (operationState_
        != com.google.firestore.admin.v1.OperationState.OPERATION_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, operationState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, database_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, backup_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getProgressPercentage());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.RestoreDatabaseMetadata)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.RestoreDatabaseMetadata other =
        (com.google.firestore.admin.v1.RestoreDatabaseMetadata) obj;

    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (operationState_ != other.operationState_) return false;
    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getBackup().equals(other.getBackup())) return false;
    if (hasProgressPercentage() != other.hasProgressPercentage()) return false;
    if (hasProgressPercentage()) {
      if (!getProgressPercentage().equals(other.getProgressPercentage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + operationState_;
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    hash = (37 * hash) + BACKUP_FIELD_NUMBER;
    hash = (53 * hash) + getBackup().hashCode();
    if (hasProgressPercentage()) {
      hash = (37 * hash) + PROGRESS_PERCENTAGE_FIELD_NUMBER;
      hash = (53 * hash) + getProgressPercentage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.firestore.admin.v1.RestoreDatabaseMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the [long-running operation][google.longrunning.Operation] from
   * the [RestoreDatabase][google.firestore.admin.v1.RestoreDatabase] request.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.RestoreDatabaseMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.RestoreDatabaseMetadata)
      com.google.firestore.admin.v1.RestoreDatabaseMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_RestoreDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_RestoreDatabaseMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.RestoreDatabaseMetadata.class,
              com.google.firestore.admin.v1.RestoreDatabaseMetadata.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.RestoreDatabaseMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStartTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getProgressPercentageFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      operationState_ = 0;
      database_ = "";
      backup_ = "";
      progressPercentage_ = null;
      if (progressPercentageBuilder_ != null) {
        progressPercentageBuilder_.dispose();
        progressPercentageBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.OperationProto
          .internal_static_google_firestore_admin_v1_RestoreDatabaseMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.RestoreDatabaseMetadata getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.RestoreDatabaseMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.RestoreDatabaseMetadata build() {
      com.google.firestore.admin.v1.RestoreDatabaseMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.RestoreDatabaseMetadata buildPartial() {
      com.google.firestore.admin.v1.RestoreDatabaseMetadata result =
          new com.google.firestore.admin.v1.RestoreDatabaseMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.RestoreDatabaseMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.operationState_ = operationState_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.backup_ = backup_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.progressPercentage_ =
            progressPercentageBuilder_ == null
                ? progressPercentage_
                : progressPercentageBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.RestoreDatabaseMetadata) {
        return mergeFrom((com.google.firestore.admin.v1.RestoreDatabaseMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.RestoreDatabaseMetadata other) {
      if (other == com.google.firestore.admin.v1.RestoreDatabaseMetadata.getDefaultInstance())
        return this;
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.operationState_ != 0) {
        setOperationStateValue(other.getOperationStateValue());
      }
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getBackup().isEmpty()) {
        backup_ = other.backup_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasProgressPercentage()) {
        mergeProgressPercentage(other.getProgressPercentage());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                operationState_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                backup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 66:
              {
                input.readMessage(
                    getProgressPercentageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the restore was started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the restore finished, unset for ongoing restores.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int operationState_ = 0;
    /**
     *
     *
     * <pre>
     * The operation state of the restore.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The enum numeric value on the wire for operationState.
     */
    @java.lang.Override
    public int getOperationStateValue() {
      return operationState_;
    }
    /**
     *
     *
     * <pre>
     * The operation state of the restore.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The enum numeric value on the wire for operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationStateValue(int value) {
      operationState_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation state of the restore.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return The operationState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.OperationState getOperationState() {
      com.google.firestore.admin.v1.OperationState result =
          com.google.firestore.admin.v1.OperationState.forNumber(operationState_);
      return result == null ? com.google.firestore.admin.v1.OperationState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The operation state of the restore.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @param value The operationState to set.
     * @return This builder for chaining.
     */
    public Builder setOperationState(com.google.firestore.admin.v1.OperationState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      operationState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation state of the restore.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.OperationState operation_state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      operationState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * The name of the database being restored to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the database being restored to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the database being restored to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the database being restored to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the database being restored to.
     * </pre>
     *
     * <code>string database = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object backup_ = "";
    /**
     *
     *
     * <pre>
     * The name of the backup restoring from.
     * </pre>
     *
     * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The backup.
     */
    public java.lang.String getBackup() {
      java.lang.Object ref = backup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the backup restoring from.
     * </pre>
     *
     * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for backup.
     */
    public com.google.protobuf.ByteString getBackupBytes() {
      java.lang.Object ref = backup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the backup restoring from.
     * </pre>
     *
     * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backup_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the backup restoring from.
     * </pre>
     *
     * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackup() {
      backup_ = getDefaultInstance().getBackup();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the backup restoring from.
     * </pre>
     *
     * <code>string backup = 5 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for backup to set.
     * @return This builder for chaining.
     */
    public Builder setBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backup_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.firestore.admin.v1.Progress progressPercentage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        progressPercentageBuilder_;
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     *
     * @return Whether the progressPercentage field is set.
     */
    public boolean hasProgressPercentage() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     *
     * @return The progressPercentage.
     */
    public com.google.firestore.admin.v1.Progress getProgressPercentage() {
      if (progressPercentageBuilder_ == null) {
        return progressPercentage_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressPercentage_;
      } else {
        return progressPercentageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public Builder setProgressPercentage(com.google.firestore.admin.v1.Progress value) {
      if (progressPercentageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        progressPercentage_ = value;
      } else {
        progressPercentageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public Builder setProgressPercentage(
        com.google.firestore.admin.v1.Progress.Builder builderForValue) {
      if (progressPercentageBuilder_ == null) {
        progressPercentage_ = builderForValue.build();
      } else {
        progressPercentageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public Builder mergeProgressPercentage(com.google.firestore.admin.v1.Progress value) {
      if (progressPercentageBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && progressPercentage_ != null
            && progressPercentage_ != com.google.firestore.admin.v1.Progress.getDefaultInstance()) {
          getProgressPercentageBuilder().mergeFrom(value);
        } else {
          progressPercentage_ = value;
        }
      } else {
        progressPercentageBuilder_.mergeFrom(value);
      }
      if (progressPercentage_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public Builder clearProgressPercentage() {
      bitField0_ = (bitField0_ & ~0x00000020);
      progressPercentage_ = null;
      if (progressPercentageBuilder_ != null) {
        progressPercentageBuilder_.dispose();
        progressPercentageBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public com.google.firestore.admin.v1.Progress.Builder getProgressPercentageBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getProgressPercentageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    public com.google.firestore.admin.v1.ProgressOrBuilder getProgressPercentageOrBuilder() {
      if (progressPercentageBuilder_ != null) {
        return progressPercentageBuilder_.getMessageOrBuilder();
      } else {
        return progressPercentage_ == null
            ? com.google.firestore.admin.v1.Progress.getDefaultInstance()
            : progressPercentage_;
      }
    }
    /**
     *
     *
     * <pre>
     * How far along the restore is as an estimated percentage of remaining time.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Progress progress_percentage = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.admin.v1.Progress,
            com.google.firestore.admin.v1.Progress.Builder,
            com.google.firestore.admin.v1.ProgressOrBuilder>
        getProgressPercentageFieldBuilder() {
      if (progressPercentageBuilder_ == null) {
        progressPercentageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.admin.v1.Progress,
                com.google.firestore.admin.v1.Progress.Builder,
                com.google.firestore.admin.v1.ProgressOrBuilder>(
                getProgressPercentage(), getParentForChildren(), isClean());
        progressPercentage_ = null;
      }
      return progressPercentageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.RestoreDatabaseMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.RestoreDatabaseMetadata)
  private static final com.google.firestore.admin.v1.RestoreDatabaseMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.RestoreDatabaseMetadata();
  }

  public static com.google.firestore.admin.v1.RestoreDatabaseMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RestoreDatabaseMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RestoreDatabaseMetadata>() {
        @java.lang.Override
        public RestoreDatabaseMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RestoreDatabaseMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RestoreDatabaseMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.RestoreDatabaseMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
