/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.ExportDocumentsRequest}
 */
public final class ExportDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.ExportDocumentsRequest)
    ExportDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportDocumentsRequest.newBuilder() to construct.
  private ExportDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportDocumentsRequest() {
    name_ = "";
    collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    outputUriPrefix_ = "";
    namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_ExportDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_ExportDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.ExportDocumentsRequest.class,
            com.google.firestore.admin.v1.ExportDocumentsRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Database to export. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Database to export. Should be of the form:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLLECTION_IDS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList collectionIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return A list containing the collectionIds.
   */
  public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
    return collectionIds_;
  }
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @return The count of collectionIds.
   */
  public int getCollectionIdsCount() {
    return collectionIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The collectionIds at the given index.
   */
  public java.lang.String getCollectionIds(int index) {
    return collectionIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Which collection ids to export. Unspecified means all collections.
   * </pre>
   *
   * <code>repeated string collection_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the collectionIds at the given index.
   */
  public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
    return collectionIds_.getByteString(index);
  }

  public static final int OUTPUT_URI_PREFIX_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputUriPrefix_ = "";
  /**
   *
   *
   * <pre>
   * The output URI. Currently only supports Google Cloud Storage URIs of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
   * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
   * Google Cloud Storage namespace path. When
   * choosing a name, be sure to consider Google Cloud Storage naming
   * guidelines: https://cloud.google.com/storage/docs/naming.
   * If the URI is a bucket (without a namespace path), a prefix will be
   * generated based on the start time.
   * </pre>
   *
   * <code>string output_uri_prefix = 3;</code>
   *
   * @return The outputUriPrefix.
   */
  @java.lang.Override
  public java.lang.String getOutputUriPrefix() {
    java.lang.Object ref = outputUriPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUriPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The output URI. Currently only supports Google Cloud Storage URIs of the
   * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
   * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
   * Google Cloud Storage namespace path. When
   * choosing a name, be sure to consider Google Cloud Storage naming
   * guidelines: https://cloud.google.com/storage/docs/naming.
   * If the URI is a bucket (without a namespace path), a prefix will be
   * generated based on the start time.
   * </pre>
   *
   * <code>string output_uri_prefix = 3;</code>
   *
   * @return The bytes for outputUriPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
    java.lang.Object ref = outputUriPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUriPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMESPACE_IDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList namespaceIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @return A list containing the namespaceIds.
   */
  public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
    return namespaceIds_;
  }
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @return The count of namespaceIds.
   */
  public int getNamespaceIdsCount() {
    return namespaceIds_.size();
  }
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The namespaceIds at the given index.
   */
  public java.lang.String getNamespaceIds(int index) {
    return namespaceIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An empty list represents all namespaces. This is the preferred
   * usage for databases that don't use namespaces.
   *
   * An empty string element represents the default namespace. This should be
   * used if the database has data in non-default namespaces, but doesn't want
   * to include them. Each namespace in this list must be unique.
   * </pre>
   *
   * <code>repeated string namespace_ids = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the namespaceIds at the given index.
   */
  public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
    return namespaceIds_.getByteString(index);
  }

  public static final int SNAPSHOT_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp snapshotTime_;
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   *
   * @return Whether the snapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   *
   * @return The snapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSnapshotTime() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp that corresponds to the version of the database to be
   * exported. The timestamp must be in the past, rounded to the minute and not
   * older than
   * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
   * If specified, then the exported documents will represent a consistent view
   * of the database at the provided time. Otherwise, there are no guarantees
   * about the consistency of the exported documents.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < collectionIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, collectionIds_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputUriPrefix_);
    }
    for (int i = 0; i < namespaceIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, namespaceIds_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getSnapshotTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < collectionIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(collectionIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCollectionIdsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUriPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, outputUriPrefix_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < namespaceIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(namespaceIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getNamespaceIdsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSnapshotTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.ExportDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.ExportDocumentsRequest other =
        (com.google.firestore.admin.v1.ExportDocumentsRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCollectionIdsList().equals(other.getCollectionIdsList())) return false;
    if (!getOutputUriPrefix().equals(other.getOutputUriPrefix())) return false;
    if (!getNamespaceIdsList().equals(other.getNamespaceIdsList())) return false;
    if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
    if (hasSnapshotTime()) {
      if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getCollectionIdsCount() > 0) {
      hash = (37 * hash) + COLLECTION_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getCollectionIdsList().hashCode();
    }
    hash = (37 * hash) + OUTPUT_URI_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUriPrefix().hashCode();
    if (getNamespaceIdsCount() > 0) {
      hash = (37 * hash) + NAMESPACE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getNamespaceIdsList().hashCode();
    }
    if (hasSnapshotTime()) {
      hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.ExportDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.ExportDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.ExportDocumentsRequest)
      com.google.firestore.admin.v1.ExportDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.ExportDocumentsRequest.class,
              com.google.firestore.admin.v1.ExportDocumentsRequest.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.ExportDocumentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSnapshotTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      outputUriPrefix_ = "";
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ExportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsRequest getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.ExportDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsRequest build() {
      com.google.firestore.admin.v1.ExportDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ExportDocumentsRequest buildPartial() {
      com.google.firestore.admin.v1.ExportDocumentsRequest result =
          new com.google.firestore.admin.v1.ExportDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.ExportDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        collectionIds_.makeImmutable();
        result.collectionIds_ = collectionIds_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.outputUriPrefix_ = outputUriPrefix_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        namespaceIds_.makeImmutable();
        result.namespaceIds_ = namespaceIds_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.snapshotTime_ =
            snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.ExportDocumentsRequest) {
        return mergeFrom((com.google.firestore.admin.v1.ExportDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.ExportDocumentsRequest other) {
      if (other == com.google.firestore.admin.v1.ExportDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.collectionIds_.isEmpty()) {
        if (collectionIds_.isEmpty()) {
          collectionIds_ = other.collectionIds_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCollectionIdsIsMutable();
          collectionIds_.addAll(other.collectionIds_);
        }
        onChanged();
      }
      if (!other.getOutputUriPrefix().isEmpty()) {
        outputUriPrefix_ = other.outputUriPrefix_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.namespaceIds_.isEmpty()) {
        if (namespaceIds_.isEmpty()) {
          namespaceIds_ = other.namespaceIds_;
          bitField0_ |= 0x00000008;
        } else {
          ensureNamespaceIdsIsMutable();
          namespaceIds_.addAll(other.namespaceIds_);
        }
        onChanged();
      }
      if (other.hasSnapshotTime()) {
        mergeSnapshotTime(other.getSnapshotTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCollectionIdsIsMutable();
                collectionIds_.add(s);
                break;
              } // case 18
            case 26:
              {
                outputUriPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureNamespaceIdsIsMutable();
                namespaceIds_.add(s);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Database to export. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database to export. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database to export. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database to export. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database to export. Should be of the form:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList collectionIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCollectionIdsIsMutable() {
      if (!collectionIds_.isModifiable()) {
        collectionIds_ = new com.google.protobuf.LazyStringArrayList(collectionIds_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @return A list containing the collectionIds.
     */
    public com.google.protobuf.ProtocolStringList getCollectionIdsList() {
      collectionIds_.makeImmutable();
      return collectionIds_;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @return The count of collectionIds.
     */
    public int getCollectionIdsCount() {
      return collectionIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The collectionIds at the given index.
     */
    public java.lang.String getCollectionIds(int index) {
      return collectionIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the collectionIds at the given index.
     */
    public com.google.protobuf.ByteString getCollectionIdsBytes(int index) {
      return collectionIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The collectionIds to set.
     * @return This builder for chaining.
     */
    public Builder setCollectionIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param value The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param values The collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllCollectionIds(java.lang.Iterable<java.lang.String> values) {
      ensureCollectionIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, collectionIds_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCollectionIds() {
      collectionIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Which collection ids to export. Unspecified means all collections.
     * </pre>
     *
     * <code>repeated string collection_ids = 2;</code>
     *
     * @param value The bytes of the collectionIds to add.
     * @return This builder for chaining.
     */
    public Builder addCollectionIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCollectionIdsIsMutable();
      collectionIds_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object outputUriPrefix_ = "";
    /**
     *
     *
     * <pre>
     * The output URI. Currently only supports Google Cloud Storage URIs of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     * Google Cloud Storage namespace path. When
     * choosing a name, be sure to consider Google Cloud Storage naming
     * guidelines: https://cloud.google.com/storage/docs/naming.
     * If the URI is a bucket (without a namespace path), a prefix will be
     * generated based on the start time.
     * </pre>
     *
     * <code>string output_uri_prefix = 3;</code>
     *
     * @return The outputUriPrefix.
     */
    public java.lang.String getOutputUriPrefix() {
      java.lang.Object ref = outputUriPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUriPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The output URI. Currently only supports Google Cloud Storage URIs of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     * Google Cloud Storage namespace path. When
     * choosing a name, be sure to consider Google Cloud Storage naming
     * guidelines: https://cloud.google.com/storage/docs/naming.
     * If the URI is a bucket (without a namespace path), a prefix will be
     * generated based on the start time.
     * </pre>
     *
     * <code>string output_uri_prefix = 3;</code>
     *
     * @return The bytes for outputUriPrefix.
     */
    public com.google.protobuf.ByteString getOutputUriPrefixBytes() {
      java.lang.Object ref = outputUriPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUriPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The output URI. Currently only supports Google Cloud Storage URIs of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     * Google Cloud Storage namespace path. When
     * choosing a name, be sure to consider Google Cloud Storage naming
     * guidelines: https://cloud.google.com/storage/docs/naming.
     * If the URI is a bucket (without a namespace path), a prefix will be
     * generated based on the start time.
     * </pre>
     *
     * <code>string output_uri_prefix = 3;</code>
     *
     * @param value The outputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputUriPrefix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output URI. Currently only supports Google Cloud Storage URIs of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     * Google Cloud Storage namespace path. When
     * choosing a name, be sure to consider Google Cloud Storage naming
     * guidelines: https://cloud.google.com/storage/docs/naming.
     * If the URI is a bucket (without a namespace path), a prefix will be
     * generated based on the start time.
     * </pre>
     *
     * <code>string output_uri_prefix = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputUriPrefix() {
      outputUriPrefix_ = getDefaultInstance().getOutputUriPrefix();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The output URI. Currently only supports Google Cloud Storage URIs of the
     * form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
     * of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
     * Google Cloud Storage namespace path. When
     * choosing a name, be sure to consider Google Cloud Storage naming
     * guidelines: https://cloud.google.com/storage/docs/naming.
     * If the URI is a bucket (without a namespace path), a prefix will be
     * generated based on the start time.
     * </pre>
     *
     * <code>string output_uri_prefix = 3;</code>
     *
     * @param value The bytes for outputUriPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputUriPrefix_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList namespaceIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureNamespaceIdsIsMutable() {
      if (!namespaceIds_.isModifiable()) {
        namespaceIds_ = new com.google.protobuf.LazyStringArrayList(namespaceIds_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @return A list containing the namespaceIds.
     */
    public com.google.protobuf.ProtocolStringList getNamespaceIdsList() {
      namespaceIds_.makeImmutable();
      return namespaceIds_;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @return The count of namespaceIds.
     */
    public int getNamespaceIdsCount() {
      return namespaceIds_.size();
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The namespaceIds at the given index.
     */
    public java.lang.String getNamespaceIds(int index) {
      return namespaceIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the namespaceIds at the given index.
     */
    public com.google.protobuf.ByteString getNamespaceIdsBytes(int index) {
      return namespaceIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The namespaceIds to set.
     * @return This builder for chaining.
     */
    public Builder setNamespaceIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param value The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param values The namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllNamespaceIds(java.lang.Iterable<java.lang.String> values) {
      ensureNamespaceIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namespaceIds_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNamespaceIds() {
      namespaceIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An empty list represents all namespaces. This is the preferred
     * usage for databases that don't use namespaces.
     *
     * An empty string element represents the default namespace. This should be
     * used if the database has data in non-default namespaces, but doesn't want
     * to include them. Each namespace in this list must be unique.
     * </pre>
     *
     * <code>repeated string namespace_ids = 4;</code>
     *
     * @param value The bytes of the namespaceIds to add.
     * @return This builder for chaining.
     */
    public Builder addNamespaceIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureNamespaceIdsIsMutable();
      namespaceIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp snapshotTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        snapshotTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      if (snapshotTimeBuilder_ == null) {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      } else {
        return snapshotTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotTime_ = value;
      } else {
        snapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (snapshotTimeBuilder_ == null) {
        snapshotTime_ = builderForValue.build();
      } else {
        snapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && snapshotTime_ != null
            && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSnapshotTimeBuilder().mergeFrom(value);
        } else {
          snapshotTime_ = value;
        }
      } else {
        snapshotTimeBuilder_.mergeFrom(value);
      }
      if (snapshotTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public Builder clearSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getSnapshotTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      if (snapshotTimeBuilder_ != null) {
        return snapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp that corresponds to the version of the database to be
     * exported. The timestamp must be in the past, rounded to the minute and not
     * older than
     * [earliestVersionTime][google.firestore.admin.v1.Database.earliest_version_time].
     * If specified, then the exported documents will represent a consistent view
     * of the database at the provided time. Otherwise, there are no guarantees
     * about the consistency of the exported documents.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSnapshotTimeFieldBuilder() {
      if (snapshotTimeBuilder_ == null) {
        snapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSnapshotTime(), getParentForChildren(), isClean());
        snapshotTime_ = null;
      }
      return snapshotTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.ExportDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.ExportDocumentsRequest)
  private static final com.google.firestore.admin.v1.ExportDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.ExportDocumentsRequest();
  }

  public static com.google.firestore.admin.v1.ExportDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportDocumentsRequest>() {
        @java.lang.Override
        public ExportDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.ExportDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
