/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/firestore_admin.proto

// Protobuf Java Version: 3.25.3
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * The response for
 * [FirestoreAdmin.ListBackups][google.firestore.admin.v1.FirestoreAdmin.ListBackups].
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.ListBackupsResponse}
 */
public final class ListBackupsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.ListBackupsResponse)
    ListBackupsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListBackupsResponse.newBuilder() to construct.
  private ListBackupsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListBackupsResponse() {
    backups_ = java.util.Collections.emptyList();
    unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListBackupsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_ListBackupsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.FirestoreAdminProto
        .internal_static_google_firestore_admin_v1_ListBackupsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.ListBackupsResponse.class,
            com.google.firestore.admin.v1.ListBackupsResponse.Builder.class);
  }

  public static final int BACKUPS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.admin.v1.Backup> backups_;
  /**
   *
   *
   * <pre>
   * List of all backups for the project.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.admin.v1.Backup> getBackupsList() {
    return backups_;
  }
  /**
   *
   *
   * <pre>
   * List of all backups for the project.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.admin.v1.BackupOrBuilder>
      getBackupsOrBuilderList() {
    return backups_;
  }
  /**
   *
   *
   * <pre>
   * List of all backups for the project.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
   */
  @java.lang.Override
  public int getBackupsCount() {
    return backups_.size();
  }
  /**
   *
   *
   * <pre>
   * List of all backups for the project.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Backup getBackups(int index) {
    return backups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of all backups for the project.
   * </pre>
   *
   * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.BackupOrBuilder getBackupsOrBuilder(int index) {
    return backups_.get(index);
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList unreachable_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * List of locations that existing backups were not able to be fetched from.
   *
   * Instead of failing the entire requests when a single location is
   * unreachable, this response returns a partial result set and list of
   * locations unable to be reached here. The request can be retried against a
   * single location to get a concrete error.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * List of locations that existing backups were not able to be fetched from.
   *
   * Instead of failing the entire requests when a single location is
   * unreachable, this response returns a partial result set and list of
   * locations unable to be reached here. The request can be retried against a
   * single location to get a concrete error.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * List of locations that existing backups were not able to be fetched from.
   *
   * Instead of failing the entire requests when a single location is
   * unreachable, this response returns a partial result set and list of
   * locations unable to be reached here. The request can be retried against a
   * single location to get a concrete error.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of locations that existing backups were not able to be fetched from.
   *
   * Instead of failing the entire requests when a single location is
   * unreachable, this response returns a partial result set and list of
   * locations unable to be reached here. The request can be retried against a
   * single location to get a concrete error.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < backups_.size(); i++) {
      output.writeMessage(1, backups_.get(i));
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < backups_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, backups_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.ListBackupsResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.ListBackupsResponse other =
        (com.google.firestore.admin.v1.ListBackupsResponse) obj;

    if (!getBackupsList().equals(other.getBackupsList())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getBackupsCount() > 0) {
      hash = (37 * hash) + BACKUPS_FIELD_NUMBER;
      hash = (53 * hash) + getBackupsList().hashCode();
    }
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.ListBackupsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for
   * [FirestoreAdmin.ListBackups][google.firestore.admin.v1.FirestoreAdmin.ListBackups].
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.ListBackupsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.ListBackupsResponse)
      com.google.firestore.admin.v1.ListBackupsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ListBackupsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ListBackupsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.ListBackupsResponse.class,
              com.google.firestore.admin.v1.ListBackupsResponse.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.ListBackupsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (backupsBuilder_ == null) {
        backups_ = java.util.Collections.emptyList();
      } else {
        backups_ = null;
        backupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.FirestoreAdminProto
          .internal_static_google_firestore_admin_v1_ListBackupsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ListBackupsResponse getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.ListBackupsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ListBackupsResponse build() {
      com.google.firestore.admin.v1.ListBackupsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.ListBackupsResponse buildPartial() {
      com.google.firestore.admin.v1.ListBackupsResponse result =
          new com.google.firestore.admin.v1.ListBackupsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.firestore.admin.v1.ListBackupsResponse result) {
      if (backupsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          backups_ = java.util.Collections.unmodifiableList(backups_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.backups_ = backups_;
      } else {
        result.backups_ = backupsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.admin.v1.ListBackupsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        unreachable_.makeImmutable();
        result.unreachable_ = unreachable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.ListBackupsResponse) {
        return mergeFrom((com.google.firestore.admin.v1.ListBackupsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.ListBackupsResponse other) {
      if (other == com.google.firestore.admin.v1.ListBackupsResponse.getDefaultInstance())
        return this;
      if (backupsBuilder_ == null) {
        if (!other.backups_.isEmpty()) {
          if (backups_.isEmpty()) {
            backups_ = other.backups_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureBackupsIsMutable();
            backups_.addAll(other.backups_);
          }
          onChanged();
        }
      } else {
        if (!other.backups_.isEmpty()) {
          if (backupsBuilder_.isEmpty()) {
            backupsBuilder_.dispose();
            backupsBuilder_ = null;
            backups_ = other.backups_;
            bitField0_ = (bitField0_ & ~0x00000001);
            backupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBackupsFieldBuilder()
                    : null;
          } else {
            backupsBuilder_.addAllMessages(other.backups_);
          }
        }
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ |= 0x00000002;
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.admin.v1.Backup m =
                    input.readMessage(
                        com.google.firestore.admin.v1.Backup.parser(), extensionRegistry);
                if (backupsBuilder_ == null) {
                  ensureBackupsIsMutable();
                  backups_.add(m);
                } else {
                  backupsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.firestore.admin.v1.Backup> backups_ =
        java.util.Collections.emptyList();

    private void ensureBackupsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        backups_ = new java.util.ArrayList<com.google.firestore.admin.v1.Backup>(backups_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.admin.v1.Backup,
            com.google.firestore.admin.v1.Backup.Builder,
            com.google.firestore.admin.v1.BackupOrBuilder>
        backupsBuilder_;

    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public java.util.List<com.google.firestore.admin.v1.Backup> getBackupsList() {
      if (backupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(backups_);
      } else {
        return backupsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public int getBackupsCount() {
      if (backupsBuilder_ == null) {
        return backups_.size();
      } else {
        return backupsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public com.google.firestore.admin.v1.Backup getBackups(int index) {
      if (backupsBuilder_ == null) {
        return backups_.get(index);
      } else {
        return backupsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder setBackups(int index, com.google.firestore.admin.v1.Backup value) {
      if (backupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackupsIsMutable();
        backups_.set(index, value);
        onChanged();
      } else {
        backupsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder setBackups(
        int index, com.google.firestore.admin.v1.Backup.Builder builderForValue) {
      if (backupsBuilder_ == null) {
        ensureBackupsIsMutable();
        backups_.set(index, builderForValue.build());
        onChanged();
      } else {
        backupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder addBackups(com.google.firestore.admin.v1.Backup value) {
      if (backupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackupsIsMutable();
        backups_.add(value);
        onChanged();
      } else {
        backupsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder addBackups(int index, com.google.firestore.admin.v1.Backup value) {
      if (backupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBackupsIsMutable();
        backups_.add(index, value);
        onChanged();
      } else {
        backupsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder addBackups(com.google.firestore.admin.v1.Backup.Builder builderForValue) {
      if (backupsBuilder_ == null) {
        ensureBackupsIsMutable();
        backups_.add(builderForValue.build());
        onChanged();
      } else {
        backupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder addBackups(
        int index, com.google.firestore.admin.v1.Backup.Builder builderForValue) {
      if (backupsBuilder_ == null) {
        ensureBackupsIsMutable();
        backups_.add(index, builderForValue.build());
        onChanged();
      } else {
        backupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder addAllBackups(
        java.lang.Iterable<? extends com.google.firestore.admin.v1.Backup> values) {
      if (backupsBuilder_ == null) {
        ensureBackupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, backups_);
        onChanged();
      } else {
        backupsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder clearBackups() {
      if (backupsBuilder_ == null) {
        backups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        backupsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public Builder removeBackups(int index) {
      if (backupsBuilder_ == null) {
        ensureBackupsIsMutable();
        backups_.remove(index);
        onChanged();
      } else {
        backupsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public com.google.firestore.admin.v1.Backup.Builder getBackupsBuilder(int index) {
      return getBackupsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public com.google.firestore.admin.v1.BackupOrBuilder getBackupsOrBuilder(int index) {
      if (backupsBuilder_ == null) {
        return backups_.get(index);
      } else {
        return backupsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public java.util.List<? extends com.google.firestore.admin.v1.BackupOrBuilder>
        getBackupsOrBuilderList() {
      if (backupsBuilder_ != null) {
        return backupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(backups_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public com.google.firestore.admin.v1.Backup.Builder addBackupsBuilder() {
      return getBackupsFieldBuilder()
          .addBuilder(com.google.firestore.admin.v1.Backup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public com.google.firestore.admin.v1.Backup.Builder addBackupsBuilder(int index) {
      return getBackupsFieldBuilder()
          .addBuilder(index, com.google.firestore.admin.v1.Backup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all backups for the project.
     * </pre>
     *
     * <code>repeated .google.firestore.admin.v1.Backup backups = 1;</code>
     */
    public java.util.List<com.google.firestore.admin.v1.Backup.Builder> getBackupsBuilderList() {
      return getBackupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.admin.v1.Backup,
            com.google.firestore.admin.v1.Backup.Builder,
            com.google.firestore.admin.v1.BackupOrBuilder>
        getBackupsFieldBuilder() {
      if (backupsBuilder_ == null) {
        backupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.admin.v1.Backup,
                com.google.firestore.admin.v1.Backup.Builder,
                com.google.firestore.admin.v1.BackupOrBuilder>(
                backups_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        backups_ = null;
      }
      return backupsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList unreachable_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureUnreachableIsMutable() {
      if (!unreachable_.isModifiable()) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      unreachable_.makeImmutable();
      return unreachable_;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of locations that existing backups were not able to be fetched from.
     *
     * Instead of failing the entire requests when a single location is
     * unreachable, this response returns a partial result set and list of
     * locations unable to be reached here. The request can be retried against a
     * single location to get a concrete error.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.ListBackupsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.ListBackupsResponse)
  private static final com.google.firestore.admin.v1.ListBackupsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.ListBackupsResponse();
  }

  public static com.google.firestore.admin.v1.ListBackupsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListBackupsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListBackupsResponse>() {
        @java.lang.Override
        public ListBackupsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListBackupsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListBackupsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.ListBackupsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
