/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/admin/v1/database.proto

// Protobuf Java Version: 3.25.3
package com.google.firestore.admin.v1;

/**
 *
 *
 * <pre>
 * A Cloud Firestore Database.
 * </pre>
 *
 * Protobuf type {@code google.firestore.admin.v1.Database}
 */
public final class Database extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.admin.v1.Database)
    DatabaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Database.newBuilder() to construct.
  private Database(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Database() {
    name_ = "";
    uid_ = "";
    locationId_ = "";
    type_ = 0;
    concurrencyMode_ = 0;
    pointInTimeRecoveryEnablement_ = 0;
    appEngineIntegrationMode_ = 0;
    keyPrefix_ = "";
    deleteProtectionState_ = 0;
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Database();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.admin.v1.DatabaseProto
        .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.admin.v1.Database.class,
            com.google.firestore.admin.v1.Database.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   *
   * Mode changes are only allowed if the database is empty.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DatabaseType}
   */
  public enum DatabaseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. This value is used if the database type is omitted.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    DATABASE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    FIRESTORE_NATIVE(1),
    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    DATASTORE_MODE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. This value is used if the database type is omitted.
     * </pre>
     *
     * <code>DATABASE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int DATABASE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Firestore Native Mode
     * </pre>
     *
     * <code>FIRESTORE_NATIVE = 1;</code>
     */
    public static final int FIRESTORE_NATIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Firestore in Datastore Mode.
     * </pre>
     *
     * <code>DATASTORE_MODE = 2;</code>
     */
    public static final int DATASTORE_MODE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DatabaseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DatabaseType forNumber(int value) {
      switch (value) {
        case 0:
          return DATABASE_TYPE_UNSPECIFIED;
        case 1:
          return FIRESTORE_NATIVE;
        case 2:
          return DATASTORE_MODE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DatabaseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DatabaseType>() {
          public DatabaseType findValueByNumber(int number) {
            return DatabaseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(0);
    }

    private static final DatabaseType[] VALUES = values();

    public static DatabaseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DatabaseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DatabaseType)
  }

  /**
   *
   *
   * <pre>
   * The type of concurrency control mode for transactions.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.ConcurrencyMode}
   */
  public enum ConcurrencyMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    CONCURRENCY_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    OPTIMISTIC(1),
    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     *
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    PESSIMISTIC(2),
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default.
     *
     * This is the only available mode for Cloud Datastore.
     *
     * This mode is also available for Cloud Firestore with Datastore Mode but
     * is not recommended.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    OPTIMISTIC_WITH_ENTITY_GROUPS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>CONCURRENCY_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int CONCURRENCY_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     * </pre>
     *
     * <code>OPTIMISTIC = 1;</code>
     */
    public static final int OPTIMISTIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use pessimistic concurrency control by default. This mode is available
     * for Cloud Firestore databases.
     *
     * This is the default setting for Cloud Firestore.
     * </pre>
     *
     * <code>PESSIMISTIC = 2;</code>
     */
    public static final int PESSIMISTIC_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Use optimistic concurrency control with entity groups by default.
     *
     * This is the only available mode for Cloud Datastore.
     *
     * This mode is also available for Cloud Firestore with Datastore Mode but
     * is not recommended.
     * </pre>
     *
     * <code>OPTIMISTIC_WITH_ENTITY_GROUPS = 3;</code>
     */
    public static final int OPTIMISTIC_WITH_ENTITY_GROUPS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConcurrencyMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConcurrencyMode forNumber(int value) {
      switch (value) {
        case 0:
          return CONCURRENCY_MODE_UNSPECIFIED;
        case 1:
          return OPTIMISTIC;
        case 2:
          return PESSIMISTIC;
        case 3:
          return OPTIMISTIC_WITH_ENTITY_GROUPS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConcurrencyMode>() {
              public ConcurrencyMode findValueByNumber(int number) {
                return ConcurrencyMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(1);
    }

    private static final ConcurrencyMode[] VALUES = values();

    public static ConcurrencyMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConcurrencyMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.ConcurrencyMode)
  }

  /**
   *
   *
   * <pre>
   * Point In Time Recovery feature enablement.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement}
   */
  public enum PointInTimeRecoveryEnablement implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED = 0;</code>
     */
    POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Reads are supported on selected versions of the data from within the past
     * 7 days:
     *
     * * Reads against any timestamp within the past hour
     * * Reads against 1-minute snapshots beyond 1 hour and within 7 days
     *
     * `version_retention_period` and `earliest_version_time` can be
     * used to determine the supported versions.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLED = 1;</code>
     */
    POINT_IN_TIME_RECOVERY_ENABLED(1),
    /**
     *
     *
     * <pre>
     * Reads are supported on any version of the data from within the past 1
     * hour.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_DISABLED = 2;</code>
     */
    POINT_IN_TIME_RECOVERY_DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED = 0;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Reads are supported on selected versions of the data from within the past
     * 7 days:
     *
     * * Reads against any timestamp within the past hour
     * * Reads against 1-minute snapshots beyond 1 hour and within 7 days
     *
     * `version_retention_period` and `earliest_version_time` can be
     * used to determine the supported versions.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_ENABLED = 1;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Reads are supported on any version of the data from within the past 1
     * hour.
     * </pre>
     *
     * <code>POINT_IN_TIME_RECOVERY_DISABLED = 2;</code>
     */
    public static final int POINT_IN_TIME_RECOVERY_DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointInTimeRecoveryEnablement valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PointInTimeRecoveryEnablement forNumber(int value) {
      switch (value) {
        case 0:
          return POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED;
        case 1:
          return POINT_IN_TIME_RECOVERY_ENABLED;
        case 2:
          return POINT_IN_TIME_RECOVERY_DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PointInTimeRecoveryEnablement>() {
              public PointInTimeRecoveryEnablement findValueByNumber(int number) {
                return PointInTimeRecoveryEnablement.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(2);
    }

    private static final PointInTimeRecoveryEnablement[] VALUES = values();

    public static PointInTimeRecoveryEnablement valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PointInTimeRecoveryEnablement(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement)
  }

  /**
   *
   *
   * <pre>
   * The type of App Engine integration mode.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.AppEngineIntegrationMode}
   */
  public enum AppEngineIntegrationMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED = 0;</code>
     */
    APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If an App Engine application exists in the same region as this database,
     * App Engine configuration will impact this database. This includes
     * disabling of the application &amp; database, as well as disabling writes to
     * the database.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    ENABLED(1),
    /**
     *
     *
     * <pre>
     * App Engine has no effect on the ability of this database to serve
     * requests.
     *
     * This is the default setting for databases created with the Firestore API.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    DISABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not used.
     * </pre>
     *
     * <code>APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If an App Engine application exists in the same region as this database,
     * App Engine configuration will impact this database. This includes
     * disabling of the application &amp; database, as well as disabling writes to
     * the database.
     * </pre>
     *
     * <code>ENABLED = 1;</code>
     */
    public static final int ENABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * App Engine has no effect on the ability of this database to serve
     * requests.
     *
     * This is the default setting for databases created with the Firestore API.
     * </pre>
     *
     * <code>DISABLED = 2;</code>
     */
    public static final int DISABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AppEngineIntegrationMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AppEngineIntegrationMode forNumber(int value) {
      switch (value) {
        case 0:
          return APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED;
        case 1:
          return ENABLED;
        case 2:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AppEngineIntegrationMode>() {
              public AppEngineIntegrationMode findValueByNumber(int number) {
                return AppEngineIntegrationMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(3);
    }

    private static final AppEngineIntegrationMode[] VALUES = values();

    public static AppEngineIntegrationMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AppEngineIntegrationMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.AppEngineIntegrationMode)
  }

  /**
   *
   *
   * <pre>
   * The delete protection state of the database.
   * </pre>
   *
   * Protobuf enum {@code google.firestore.admin.v1.Database.DeleteProtectionState}
   */
  public enum DeleteProtectionState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default value. Delete protection type is not specified
     * </pre>
     *
     * <code>DELETE_PROTECTION_STATE_UNSPECIFIED = 0;</code>
     */
    DELETE_PROTECTION_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Delete protection is disabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_DISABLED = 1;</code>
     */
    DELETE_PROTECTION_DISABLED(1),
    /**
     *
     *
     * <pre>
     * Delete protection is enabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_ENABLED = 2;</code>
     */
    DELETE_PROTECTION_ENABLED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default value. Delete protection type is not specified
     * </pre>
     *
     * <code>DELETE_PROTECTION_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int DELETE_PROTECTION_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Delete protection is disabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_DISABLED = 1;</code>
     */
    public static final int DELETE_PROTECTION_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Delete protection is enabled
     * </pre>
     *
     * <code>DELETE_PROTECTION_ENABLED = 2;</code>
     */
    public static final int DELETE_PROTECTION_ENABLED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeleteProtectionState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DeleteProtectionState forNumber(int value) {
      switch (value) {
        case 0:
          return DELETE_PROTECTION_STATE_UNSPECIFIED;
        case 1:
          return DELETE_PROTECTION_DISABLED;
        case 2:
          return DELETE_PROTECTION_ENABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DeleteProtectionState>() {
              public DeleteProtectionState findValueByNumber(int number) {
                return DeleteProtectionState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.firestore.admin.v1.Database.getDescriptor().getEnumTypes().get(4);
    }

    private static final DeleteProtectionState[] VALUES = values();

    public static DeleteProtectionState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeleteProtectionState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.firestore.admin.v1.Database.DeleteProtectionState)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the Database.
   * Format: `projects/{project}/databases/{database}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The system-generated UUID4 for this Database.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The system-generated UUID4 for this Database.
   * </pre>
   *
   * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was created. Databases
   * created before 2016 do not populate create_time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp at which this database was most recently
   * updated. Note this only includes updates to the database resource and not
   * data contained by the database.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationId_ = "";
  /**
   *
   *
   * <pre>
   * The location of the database. Available locations are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The location of the database. Available locations are listed at
   * https://cloud.google.com/firestore/docs/locations.
   * </pre>
   *
   * <code>string location_id = 9;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 10;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the database.
   * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
   * information about how to choose.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DatabaseType getType() {
    com.google.firestore.admin.v1.Database.DatabaseType result =
        com.google.firestore.admin.v1.Database.DatabaseType.forNumber(type_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
        : result;
  }

  public static final int CONCURRENCY_MODE_FIELD_NUMBER = 15;
  private int concurrencyMode_ = 0;
  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The enum numeric value on the wire for concurrencyMode.
   */
  @java.lang.Override
  public int getConcurrencyModeValue() {
    return concurrencyMode_;
  }
  /**
   *
   *
   * <pre>
   * The concurrency control mode to use for this database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
   *
   * @return The concurrencyMode.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
    com.google.firestore.admin.v1.Database.ConcurrencyMode result =
        com.google.firestore.admin.v1.Database.ConcurrencyMode.forNumber(concurrencyMode_);
    return result == null
        ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
        : result;
  }

  public static final int VERSION_RETENTION_PERIOD_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration versionRetentionPeriod_;
  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionRetentionPeriod field is set.
   */
  @java.lang.Override
  public boolean hasVersionRetentionPeriod() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionRetentionPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getVersionRetentionPeriod() {
    return versionRetentionPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : versionRetentionPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The period during which past versions of data are retained in
   * the database.
   *
   * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
   * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
   * a `read_time` within this window, and will read the state of the database
   * at that time.
   *
   * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
   * the retention period is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getVersionRetentionPeriodOrBuilder() {
    return versionRetentionPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : versionRetentionPeriod_;
  }

  public static final int EARLIEST_VERSION_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp earliestVersionTime_;
  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestVersionTime field is set.
   */
  @java.lang.Override
  public boolean hasEarliestVersionTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestVersionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEarliestVersionTime() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The earliest timestamp at which older versions of the data can
   * be read from the database. See [version_retention_period] above; this field
   * is populated with `now - version_retention_period`.
   *
   * This value is continuously updated, and becomes stale the moment it is
   * queried. If you are using this value to recover data, make sure to account
   * for the time from the moment when the value is queried to the moment when
   * you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }

  public static final int POINT_IN_TIME_RECOVERY_ENABLEMENT_FIELD_NUMBER = 21;
  private int pointInTimeRecoveryEnablement_ = 0;
  /**
   *
   *
   * <pre>
   * Whether to enable the PITR feature on this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
   * </code>
   *
   * @return The enum numeric value on the wire for pointInTimeRecoveryEnablement.
   */
  @java.lang.Override
  public int getPointInTimeRecoveryEnablementValue() {
    return pointInTimeRecoveryEnablement_;
  }
  /**
   *
   *
   * <pre>
   * Whether to enable the PITR feature on this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
   * </code>
   *
   * @return The pointInTimeRecoveryEnablement.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
      getPointInTimeRecoveryEnablement() {
    com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement result =
        com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.forNumber(
            pointInTimeRecoveryEnablement_);
    return result == null
        ? com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.UNRECOGNIZED
        : result;
  }

  public static final int APP_ENGINE_INTEGRATION_MODE_FIELD_NUMBER = 19;
  private int appEngineIntegrationMode_ = 0;
  /**
   *
   *
   * <pre>
   * The App Engine integration mode to use for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
   * </code>
   *
   * @return The enum numeric value on the wire for appEngineIntegrationMode.
   */
  @java.lang.Override
  public int getAppEngineIntegrationModeValue() {
    return appEngineIntegrationMode_;
  }
  /**
   *
   *
   * <pre>
   * The App Engine integration mode to use for this database.
   * </pre>
   *
   * <code>
   * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
   * </code>
   *
   * @return The appEngineIntegrationMode.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
      getAppEngineIntegrationMode() {
    com.google.firestore.admin.v1.Database.AppEngineIntegrationMode result =
        com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.forNumber(
            appEngineIntegrationMode_);
    return result == null
        ? com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.UNRECOGNIZED
        : result;
  }

  public static final int KEY_PREFIX_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyPrefix_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The key_prefix for this database. This key_prefix is used, in
   * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
   * the application id that is returned from the Cloud Datastore APIs in Google
   * App Engine first generation runtimes.
   *
   * This value may be empty in which case the appid to use for URL-encoded keys
   * is the project_id (eg: foo instead of v~foo).
   * </pre>
   *
   * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The keyPrefix.
   */
  @java.lang.Override
  public java.lang.String getKeyPrefix() {
    java.lang.Object ref = keyPrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyPrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The key_prefix for this database. This key_prefix is used, in
   * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
   * the application id that is returned from the Cloud Datastore APIs in Google
   * App Engine first generation runtimes.
   *
   * This value may be empty in which case the appid to use for URL-encoded keys
   * is the project_id (eg: foo instead of v~foo).
   * </pre>
   *
   * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for keyPrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyPrefixBytes() {
    java.lang.Object ref = keyPrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyPrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_PROTECTION_STATE_FIELD_NUMBER = 22;
  private int deleteProtectionState_ = 0;
  /**
   *
   *
   * <pre>
   * State of delete protection for the database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
   * </code>
   *
   * @return The enum numeric value on the wire for deleteProtectionState.
   */
  @java.lang.Override
  public int getDeleteProtectionStateValue() {
    return deleteProtectionState_;
  }
  /**
   *
   *
   * <pre>
   * State of delete protection for the database.
   * </pre>
   *
   * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
   * </code>
   *
   * @return The deleteProtectionState.
   */
  @java.lang.Override
  public com.google.firestore.admin.v1.Database.DeleteProtectionState getDeleteProtectionState() {
    com.google.firestore.admin.v1.Database.DeleteProtectionState result =
        com.google.firestore.admin.v1.Database.DeleteProtectionState.forNumber(
            deleteProtectionState_);
    return result == null
        ? com.google.firestore.admin.v1.Database.DeleteProtectionState.UNRECOGNIZED
        : result;
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 99;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(15, concurrencyMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(17, getVersionRetentionPeriod());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(18, getEarliestVersionTime());
    }
    if (appEngineIntegrationMode_
        != com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
            .APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(19, appEngineIntegrationMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, keyPrefix_);
    }
    if (pointInTimeRecoveryEnablement_
        != com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
            .POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(21, pointInTimeRecoveryEnablement_);
    }
    if (deleteProtectionState_
        != com.google.firestore.admin.v1.Database.DeleteProtectionState
            .DELETE_PROTECTION_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(22, deleteProtectionState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, locationId_);
    }
    if (type_
        != com.google.firestore.admin.v1.Database.DatabaseType.DATABASE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, type_);
    }
    if (concurrencyMode_
        != com.google.firestore.admin.v1.Database.ConcurrencyMode.CONCURRENCY_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, concurrencyMode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(17, getVersionRetentionPeriod());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(18, getEarliestVersionTime());
    }
    if (appEngineIntegrationMode_
        != com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
            .APP_ENGINE_INTEGRATION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, appEngineIntegrationMode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, keyPrefix_);
    }
    if (pointInTimeRecoveryEnablement_
        != com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
            .POINT_IN_TIME_RECOVERY_ENABLEMENT_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(21, pointInTimeRecoveryEnablement_);
    }
    if (deleteProtectionState_
        != com.google.firestore.admin.v1.Database.DeleteProtectionState
            .DELETE_PROTECTION_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(22, deleteProtectionState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.admin.v1.Database)) {
      return super.equals(obj);
    }
    com.google.firestore.admin.v1.Database other = (com.google.firestore.admin.v1.Database) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (type_ != other.type_) return false;
    if (concurrencyMode_ != other.concurrencyMode_) return false;
    if (hasVersionRetentionPeriod() != other.hasVersionRetentionPeriod()) return false;
    if (hasVersionRetentionPeriod()) {
      if (!getVersionRetentionPeriod().equals(other.getVersionRetentionPeriod())) return false;
    }
    if (hasEarliestVersionTime() != other.hasEarliestVersionTime()) return false;
    if (hasEarliestVersionTime()) {
      if (!getEarliestVersionTime().equals(other.getEarliestVersionTime())) return false;
    }
    if (pointInTimeRecoveryEnablement_ != other.pointInTimeRecoveryEnablement_) return false;
    if (appEngineIntegrationMode_ != other.appEngineIntegrationMode_) return false;
    if (!getKeyPrefix().equals(other.getKeyPrefix())) return false;
    if (deleteProtectionState_ != other.deleteProtectionState_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + CONCURRENCY_MODE_FIELD_NUMBER;
    hash = (53 * hash) + concurrencyMode_;
    if (hasVersionRetentionPeriod()) {
      hash = (37 * hash) + VERSION_RETENTION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getVersionRetentionPeriod().hashCode();
    }
    if (hasEarliestVersionTime()) {
      hash = (37 * hash) + EARLIEST_VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEarliestVersionTime().hashCode();
    }
    hash = (37 * hash) + POINT_IN_TIME_RECOVERY_ENABLEMENT_FIELD_NUMBER;
    hash = (53 * hash) + pointInTimeRecoveryEnablement_;
    hash = (37 * hash) + APP_ENGINE_INTEGRATION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + appEngineIntegrationMode_;
    hash = (37 * hash) + KEY_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getKeyPrefix().hashCode();
    hash = (37 * hash) + DELETE_PROTECTION_STATE_FIELD_NUMBER;
    hash = (53 * hash) + deleteProtectionState_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.admin.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.admin.v1.Database prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Cloud Firestore Database.
   * </pre>
   *
   * Protobuf type {@code google.firestore.admin.v1.Database}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.admin.v1.Database)
      com.google.firestore.admin.v1.DatabaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.admin.v1.Database.class,
              com.google.firestore.admin.v1.Database.Builder.class);
    }

    // Construct using com.google.firestore.admin.v1.Database.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getVersionRetentionPeriodFieldBuilder();
        getEarliestVersionTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      locationId_ = "";
      type_ = 0;
      concurrencyMode_ = 0;
      versionRetentionPeriod_ = null;
      if (versionRetentionPeriodBuilder_ != null) {
        versionRetentionPeriodBuilder_.dispose();
        versionRetentionPeriodBuilder_ = null;
      }
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      pointInTimeRecoveryEnablement_ = 0;
      appEngineIntegrationMode_ = 0;
      keyPrefix_ = "";
      deleteProtectionState_ = 0;
      etag_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.admin.v1.DatabaseProto
          .internal_static_google_firestore_admin_v1_Database_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
      return com.google.firestore.admin.v1.Database.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database build() {
      com.google.firestore.admin.v1.Database result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.admin.v1.Database buildPartial() {
      com.google.firestore.admin.v1.Database result =
          new com.google.firestore.admin.v1.Database(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.admin.v1.Database result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.locationId_ = locationId_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.concurrencyMode_ = concurrencyMode_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.versionRetentionPeriod_ =
            versionRetentionPeriodBuilder_ == null
                ? versionRetentionPeriod_
                : versionRetentionPeriodBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.earliestVersionTime_ =
            earliestVersionTimeBuilder_ == null
                ? earliestVersionTime_
                : earliestVersionTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pointInTimeRecoveryEnablement_ = pointInTimeRecoveryEnablement_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.appEngineIntegrationMode_ = appEngineIntegrationMode_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.keyPrefix_ = keyPrefix_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.deleteProtectionState_ = deleteProtectionState_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.admin.v1.Database) {
        return mergeFrom((com.google.firestore.admin.v1.Database) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.admin.v1.Database other) {
      if (other == com.google.firestore.admin.v1.Database.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.concurrencyMode_ != 0) {
        setConcurrencyModeValue(other.getConcurrencyModeValue());
      }
      if (other.hasVersionRetentionPeriod()) {
        mergeVersionRetentionPeriod(other.getVersionRetentionPeriod());
      }
      if (other.hasEarliestVersionTime()) {
        mergeEarliestVersionTime(other.getEarliestVersionTime());
      }
      if (other.pointInTimeRecoveryEnablement_ != 0) {
        setPointInTimeRecoveryEnablementValue(other.getPointInTimeRecoveryEnablementValue());
      }
      if (other.appEngineIntegrationMode_ != 0) {
        setAppEngineIntegrationModeValue(other.getAppEngineIntegrationModeValue());
      }
      if (!other.getKeyPrefix().isEmpty()) {
        keyPrefix_ = other.keyPrefix_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.deleteProtectionState_ != 0) {
        setDeleteProtectionStateValue(other.getDeleteProtectionStateValue());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 74:
              {
                locationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            case 80:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 80
            case 120:
              {
                concurrencyMode_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 120
            case 138:
              {
                input.readMessage(
                    getVersionRetentionPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getEarliestVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 146
            case 152:
              {
                appEngineIntegrationMode_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 152
            case 162:
              {
                keyPrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 162
            case 168:
              {
                pointInTimeRecoveryEnablement_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 168
            case 176:
              {
                deleteProtectionState_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 176
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the Database.
     * Format: `projects/{project}/databases/{database}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The system-generated UUID4 for this Database.
     * </pre>
     *
     * <code>string uid = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was created. Databases
     * created before 2016 do not populate create_time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp at which this database was most recently
     * updated. Note this only includes updates to the database resource and not
     * data contained by the database.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {
      locationId_ = getDefaultInstance().getLocationId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location of the database. Available locations are listed at
     * https://cloud.google.com/firestore/docs/locations.
     * </pre>
     *
     * <code>string location_id = 9;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DatabaseType getType() {
      com.google.firestore.admin.v1.Database.DatabaseType result =
          com.google.firestore.admin.v1.Database.DatabaseType.forNumber(type_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DatabaseType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.firestore.admin.v1.Database.DatabaseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the database.
     * See https://cloud.google.com/datastore/docs/firestore-or-datastore for
     * information about how to choose.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DatabaseType type = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      type_ = 0;
      onChanged();
      return this;
    }

    private int concurrencyMode_ = 0;
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The enum numeric value on the wire for concurrencyMode.
     */
    @java.lang.Override
    public int getConcurrencyModeValue() {
      return concurrencyMode_;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The enum numeric value on the wire for concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyModeValue(int value) {
      concurrencyMode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return The concurrencyMode.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.ConcurrencyMode getConcurrencyMode() {
      com.google.firestore.admin.v1.Database.ConcurrencyMode result =
          com.google.firestore.admin.v1.Database.ConcurrencyMode.forNumber(concurrencyMode_);
      return result == null
          ? com.google.firestore.admin.v1.Database.ConcurrencyMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @param value The concurrencyMode to set.
     * @return This builder for chaining.
     */
    public Builder setConcurrencyMode(
        com.google.firestore.admin.v1.Database.ConcurrencyMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      concurrencyMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The concurrency control mode to use for this database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.ConcurrencyMode concurrency_mode = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConcurrencyMode() {
      bitField0_ = (bitField0_ & ~0x00000040);
      concurrencyMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration versionRetentionPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        versionRetentionPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the versionRetentionPeriod field is set.
     */
    public boolean hasVersionRetentionPeriod() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionRetentionPeriod.
     */
    public com.google.protobuf.Duration getVersionRetentionPeriod() {
      if (versionRetentionPeriodBuilder_ == null) {
        return versionRetentionPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : versionRetentionPeriod_;
      } else {
        return versionRetentionPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionRetentionPeriod(com.google.protobuf.Duration value) {
      if (versionRetentionPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionRetentionPeriod_ = value;
      } else {
        versionRetentionPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setVersionRetentionPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (versionRetentionPeriodBuilder_ == null) {
        versionRetentionPeriod_ = builderForValue.build();
      } else {
        versionRetentionPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeVersionRetentionPeriod(com.google.protobuf.Duration value) {
      if (versionRetentionPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && versionRetentionPeriod_ != null
            && versionRetentionPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getVersionRetentionPeriodBuilder().mergeFrom(value);
        } else {
          versionRetentionPeriod_ = value;
        }
      } else {
        versionRetentionPeriodBuilder_.mergeFrom(value);
      }
      if (versionRetentionPeriod_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearVersionRetentionPeriod() {
      bitField0_ = (bitField0_ & ~0x00000080);
      versionRetentionPeriod_ = null;
      if (versionRetentionPeriodBuilder_ != null) {
        versionRetentionPeriodBuilder_.dispose();
        versionRetentionPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getVersionRetentionPeriodBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getVersionRetentionPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getVersionRetentionPeriodOrBuilder() {
      if (versionRetentionPeriodBuilder_ != null) {
        return versionRetentionPeriodBuilder_.getMessageOrBuilder();
      } else {
        return versionRetentionPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : versionRetentionPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period during which past versions of data are retained in
     * the database.
     *
     * Any [read][google.firestore.v1.GetDocumentRequest.read_time]
     * or [query][google.firestore.v1.ListDocumentsRequest.read_time] can specify
     * a `read_time` within this window, and will read the state of the database
     * at that time.
     *
     * If the PITR feature is enabled, the retention period is 7 days. Otherwise,
     * the retention period is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration version_retention_period = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getVersionRetentionPeriodFieldBuilder() {
      if (versionRetentionPeriodBuilder_ == null) {
        versionRetentionPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getVersionRetentionPeriod(), getParentForChildren(), isClean());
        versionRetentionPeriod_ = null;
      }
      return versionRetentionPeriodBuilder_;
    }

    private com.google.protobuf.Timestamp earliestVersionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        earliestVersionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the earliestVersionTime field is set.
     */
    public boolean hasEarliestVersionTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The earliestVersionTime.
     */
    public com.google.protobuf.Timestamp getEarliestVersionTime() {
      if (earliestVersionTimeBuilder_ == null) {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      } else {
        return earliestVersionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        earliestVersionTime_ = value;
      } else {
        earliestVersionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = builderForValue.build();
      } else {
        earliestVersionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && earliestVersionTime_ != null
            && earliestVersionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEarliestVersionTimeBuilder().mergeFrom(value);
        } else {
          earliestVersionTime_ = value;
        }
      } else {
        earliestVersionTimeBuilder_.mergeFrom(value);
      }
      if (earliestVersionTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEarliestVersionTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEarliestVersionTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEarliestVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
      if (earliestVersionTimeBuilder_ != null) {
        return earliestVersionTimeBuilder_.getMessageOrBuilder();
      } else {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The earliest timestamp at which older versions of the data can
     * be read from the database. See [version_retention_period] above; this field
     * is populated with `now - version_retention_period`.
     *
     * This value is continuously updated, and becomes stale the moment it is
     * queried. If you are using this value to recover data, make sure to account
     * for the time from the moment when the value is queried to the moment when
     * you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEarliestVersionTimeFieldBuilder() {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEarliestVersionTime(), getParentForChildren(), isClean());
        earliestVersionTime_ = null;
      }
      return earliestVersionTimeBuilder_;
    }

    private int pointInTimeRecoveryEnablement_ = 0;
    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return The enum numeric value on the wire for pointInTimeRecoveryEnablement.
     */
    @java.lang.Override
    public int getPointInTimeRecoveryEnablementValue() {
      return pointInTimeRecoveryEnablement_;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @param value The enum numeric value on the wire for pointInTimeRecoveryEnablement to set.
     * @return This builder for chaining.
     */
    public Builder setPointInTimeRecoveryEnablementValue(int value) {
      pointInTimeRecoveryEnablement_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return The pointInTimeRecoveryEnablement.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement
        getPointInTimeRecoveryEnablement() {
      com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement result =
          com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.forNumber(
              pointInTimeRecoveryEnablement_);
      return result == null
          ? com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @param value The pointInTimeRecoveryEnablement to set.
     * @return This builder for chaining.
     */
    public Builder setPointInTimeRecoveryEnablement(
        com.google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      pointInTimeRecoveryEnablement_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to enable the PITR feature on this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.PointInTimeRecoveryEnablement point_in_time_recovery_enablement = 21;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPointInTimeRecoveryEnablement() {
      bitField0_ = (bitField0_ & ~0x00000200);
      pointInTimeRecoveryEnablement_ = 0;
      onChanged();
      return this;
    }

    private int appEngineIntegrationMode_ = 0;
    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return The enum numeric value on the wire for appEngineIntegrationMode.
     */
    @java.lang.Override
    public int getAppEngineIntegrationModeValue() {
      return appEngineIntegrationMode_;
    }
    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @param value The enum numeric value on the wire for appEngineIntegrationMode to set.
     * @return This builder for chaining.
     */
    public Builder setAppEngineIntegrationModeValue(int value) {
      appEngineIntegrationMode_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return The appEngineIntegrationMode.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.AppEngineIntegrationMode
        getAppEngineIntegrationMode() {
      com.google.firestore.admin.v1.Database.AppEngineIntegrationMode result =
          com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.forNumber(
              appEngineIntegrationMode_);
      return result == null
          ? com.google.firestore.admin.v1.Database.AppEngineIntegrationMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @param value The appEngineIntegrationMode to set.
     * @return This builder for chaining.
     */
    public Builder setAppEngineIntegrationMode(
        com.google.firestore.admin.v1.Database.AppEngineIntegrationMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      appEngineIntegrationMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The App Engine integration mode to use for this database.
     * </pre>
     *
     * <code>
     * .google.firestore.admin.v1.Database.AppEngineIntegrationMode app_engine_integration_mode = 19;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppEngineIntegrationMode() {
      bitField0_ = (bitField0_ & ~0x00000400);
      appEngineIntegrationMode_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object keyPrefix_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application id that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The keyPrefix.
     */
    public java.lang.String getKeyPrefix() {
      java.lang.Object ref = keyPrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyPrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application id that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for keyPrefix.
     */
    public com.google.protobuf.ByteString getKeyPrefixBytes() {
      java.lang.Object ref = keyPrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyPrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application id that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The keyPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyPrefix_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application id that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyPrefix() {
      keyPrefix_ = getDefaultInstance().getKeyPrefix();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The key_prefix for this database. This key_prefix is used, in
     * combination with the project id ("&lt;key prefix&gt;~&lt;project id&gt;") to construct
     * the application id that is returned from the Cloud Datastore APIs in Google
     * App Engine first generation runtimes.
     *
     * This value may be empty in which case the appid to use for URL-encoded keys
     * is the project_id (eg: foo instead of v~foo).
     * </pre>
     *
     * <code>string key_prefix = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for keyPrefix to set.
     * @return This builder for chaining.
     */
    public Builder setKeyPrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyPrefix_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private int deleteProtectionState_ = 0;
    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return The enum numeric value on the wire for deleteProtectionState.
     */
    @java.lang.Override
    public int getDeleteProtectionStateValue() {
      return deleteProtectionState_;
    }
    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @param value The enum numeric value on the wire for deleteProtectionState to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteProtectionStateValue(int value) {
      deleteProtectionState_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return The deleteProtectionState.
     */
    @java.lang.Override
    public com.google.firestore.admin.v1.Database.DeleteProtectionState getDeleteProtectionState() {
      com.google.firestore.admin.v1.Database.DeleteProtectionState result =
          com.google.firestore.admin.v1.Database.DeleteProtectionState.forNumber(
              deleteProtectionState_);
      return result == null
          ? com.google.firestore.admin.v1.Database.DeleteProtectionState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @param value The deleteProtectionState to set.
     * @return This builder for chaining.
     */
    public Builder setDeleteProtectionState(
        com.google.firestore.admin.v1.Database.DeleteProtectionState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      deleteProtectionState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of delete protection for the database.
     * </pre>
     *
     * <code>.google.firestore.admin.v1.Database.DeleteProtectionState delete_protection_state = 22;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeleteProtectionState() {
      bitField0_ = (bitField0_ & ~0x00001000);
      deleteProtectionState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 99;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.admin.v1.Database)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.admin.v1.Database)
  private static final com.google.firestore.admin.v1.Database DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.admin.v1.Database();
  }

  public static com.google.firestore.admin.v1.Database getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Database> PARSER =
      new com.google.protobuf.AbstractParser<Database>() {
        @java.lang.Override
        public Database parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Database> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Database> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.admin.v1.Database getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
