/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A request for [Firestore.Listen][google.firestore.v1.Firestore.Listen]
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.ListenRequest}
 */
public final class ListenRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.ListenRequest)
    ListenRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListenRequest.newBuilder() to construct.
  private ListenRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListenRequest() {
    database_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListenRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListenRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              database_ = s;
              break;
            }
          case 18:
            {
              com.google.firestore.v1.Target.Builder subBuilder = null;
              if (targetChangeCase_ == 2) {
                subBuilder = ((com.google.firestore.v1.Target) targetChange_).toBuilder();
              }
              targetChange_ =
                  input.readMessage(com.google.firestore.v1.Target.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1.Target) targetChange_);
                targetChange_ = subBuilder.buildPartial();
              }
              targetChangeCase_ = 2;
              break;
            }
          case 24:
            {
              targetChangeCase_ = 3;
              targetChange_ = input.readInt32();
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListenRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListenRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.ListenRequest.class,
            com.google.firestore.v1.ListenRequest.Builder.class);
  }

  private int targetChangeCase_ = 0;
  private java.lang.Object targetChange_;

  public enum TargetChangeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ADD_TARGET(2),
    REMOVE_TARGET(3),
    TARGETCHANGE_NOT_SET(0);
    private final int value;

    private TargetChangeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetChangeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetChangeCase forNumber(int value) {
      switch (value) {
        case 2:
          return ADD_TARGET;
        case 3:
          return REMOVE_TARGET;
        case 0:
          return TARGETCHANGE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetChangeCase getTargetChangeCase() {
    return TargetChangeCase.forNumber(targetChangeCase_);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;
  private volatile java.lang.Object database_;
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The database.
   */
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for database.
   */
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADD_TARGET_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A target to add to this stream.
   * </pre>
   *
   * <code>.google.firestore.v1.Target add_target = 2;</code>
   *
   * @return Whether the addTarget field is set.
   */
  public boolean hasAddTarget() {
    return targetChangeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A target to add to this stream.
   * </pre>
   *
   * <code>.google.firestore.v1.Target add_target = 2;</code>
   *
   * @return The addTarget.
   */
  public com.google.firestore.v1.Target getAddTarget() {
    if (targetChangeCase_ == 2) {
      return (com.google.firestore.v1.Target) targetChange_;
    }
    return com.google.firestore.v1.Target.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A target to add to this stream.
   * </pre>
   *
   * <code>.google.firestore.v1.Target add_target = 2;</code>
   */
  public com.google.firestore.v1.TargetOrBuilder getAddTargetOrBuilder() {
    if (targetChangeCase_ == 2) {
      return (com.google.firestore.v1.Target) targetChange_;
    }
    return com.google.firestore.v1.Target.getDefaultInstance();
  }

  public static final int REMOVE_TARGET_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The ID of a target to remove from this stream.
   * </pre>
   *
   * <code>int32 remove_target = 3;</code>
   *
   * @return The removeTarget.
   */
  public int getRemoveTarget() {
    if (targetChangeCase_ == 3) {
      return (java.lang.Integer) targetChange_;
    }
    return 0;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.firestore.v1.FirestoreProto
                .internal_static_google_firestore_v1_ListenRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this target change.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this target change.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this target change.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this target change.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getDatabaseBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    if (targetChangeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.Target) targetChange_);
    }
    if (targetChangeCase_ == 3) {
      output.writeInt32(3, (int) ((java.lang.Integer) targetChange_));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDatabaseBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    if (targetChangeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.Target) targetChange_);
    }
    if (targetChangeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              3, (int) ((java.lang.Integer) targetChange_));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.ListenRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.ListenRequest other = (com.google.firestore.v1.ListenRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getTargetChangeCase().equals(other.getTargetChangeCase())) return false;
    switch (targetChangeCase_) {
      case 2:
        if (!getAddTarget().equals(other.getAddTarget())) return false;
        break;
      case 3:
        if (getRemoveTarget() != other.getRemoveTarget()) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (targetChangeCase_) {
      case 2:
        hash = (37 * hash) + ADD_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getAddTarget().hashCode();
        break;
      case 3:
        hash = (37 * hash) + REMOVE_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getRemoveTarget();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.ListenRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request for [Firestore.Listen][google.firestore.v1.Firestore.Listen]
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.ListenRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.ListenRequest)
      com.google.firestore.v1.ListenRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.ListenRequest.class,
              com.google.firestore.v1.ListenRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.ListenRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      database_ = "";

      internalGetMutableLabels().clear();
      targetChangeCase_ = 0;
      targetChange_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.ListenRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenRequest build() {
      com.google.firestore.v1.ListenRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenRequest buildPartial() {
      com.google.firestore.v1.ListenRequest result =
          new com.google.firestore.v1.ListenRequest(this);
      int from_bitField0_ = bitField0_;
      result.database_ = database_;
      if (targetChangeCase_ == 2) {
        if (addTargetBuilder_ == null) {
          result.targetChange_ = targetChange_;
        } else {
          result.targetChange_ = addTargetBuilder_.build();
        }
      }
      if (targetChangeCase_ == 3) {
        result.targetChange_ = targetChange_;
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.targetChangeCase_ = targetChangeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.ListenRequest) {
        return mergeFrom((com.google.firestore.v1.ListenRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.ListenRequest other) {
      if (other == com.google.firestore.v1.ListenRequest.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      switch (other.getTargetChangeCase()) {
        case ADD_TARGET:
          {
            mergeAddTarget(other.getAddTarget());
            break;
          }
        case REMOVE_TARGET:
          {
            setRemoveTarget(other.getRemoveTarget());
            break;
          }
        case TARGETCHANGE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1.ListenRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1.ListenRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int targetChangeCase_ = 0;
    private java.lang.Object targetChange_;

    public TargetChangeCase getTargetChangeCase() {
      return TargetChangeCase.forNumber(targetChangeCase_);
    }

    public Builder clearTargetChange() {
      targetChangeCase_ = 0;
      targetChange_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      database_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {

      database_ = getDefaultInstance().getDatabase();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      database_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target,
            com.google.firestore.v1.Target.Builder,
            com.google.firestore.v1.TargetOrBuilder>
        addTargetBuilder_;
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     *
     * @return Whether the addTarget field is set.
     */
    public boolean hasAddTarget() {
      return targetChangeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     *
     * @return The addTarget.
     */
    public com.google.firestore.v1.Target getAddTarget() {
      if (addTargetBuilder_ == null) {
        if (targetChangeCase_ == 2) {
          return (com.google.firestore.v1.Target) targetChange_;
        }
        return com.google.firestore.v1.Target.getDefaultInstance();
      } else {
        if (targetChangeCase_ == 2) {
          return addTargetBuilder_.getMessage();
        }
        return com.google.firestore.v1.Target.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public Builder setAddTarget(com.google.firestore.v1.Target value) {
      if (addTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetChange_ = value;
        onChanged();
      } else {
        addTargetBuilder_.setMessage(value);
      }
      targetChangeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public Builder setAddTarget(com.google.firestore.v1.Target.Builder builderForValue) {
      if (addTargetBuilder_ == null) {
        targetChange_ = builderForValue.build();
        onChanged();
      } else {
        addTargetBuilder_.setMessage(builderForValue.build());
      }
      targetChangeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public Builder mergeAddTarget(com.google.firestore.v1.Target value) {
      if (addTargetBuilder_ == null) {
        if (targetChangeCase_ == 2
            && targetChange_ != com.google.firestore.v1.Target.getDefaultInstance()) {
          targetChange_ =
              com.google.firestore.v1.Target.newBuilder(
                      (com.google.firestore.v1.Target) targetChange_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetChange_ = value;
        }
        onChanged();
      } else {
        if (targetChangeCase_ == 2) {
          addTargetBuilder_.mergeFrom(value);
        }
        addTargetBuilder_.setMessage(value);
      }
      targetChangeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public Builder clearAddTarget() {
      if (addTargetBuilder_ == null) {
        if (targetChangeCase_ == 2) {
          targetChangeCase_ = 0;
          targetChange_ = null;
          onChanged();
        }
      } else {
        if (targetChangeCase_ == 2) {
          targetChangeCase_ = 0;
          targetChange_ = null;
        }
        addTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public com.google.firestore.v1.Target.Builder getAddTargetBuilder() {
      return getAddTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    public com.google.firestore.v1.TargetOrBuilder getAddTargetOrBuilder() {
      if ((targetChangeCase_ == 2) && (addTargetBuilder_ != null)) {
        return addTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetChangeCase_ == 2) {
          return (com.google.firestore.v1.Target) targetChange_;
        }
        return com.google.firestore.v1.Target.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target to add to this stream.
     * </pre>
     *
     * <code>.google.firestore.v1.Target add_target = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target,
            com.google.firestore.v1.Target.Builder,
            com.google.firestore.v1.TargetOrBuilder>
        getAddTargetFieldBuilder() {
      if (addTargetBuilder_ == null) {
        if (!(targetChangeCase_ == 2)) {
          targetChange_ = com.google.firestore.v1.Target.getDefaultInstance();
        }
        addTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Target,
                com.google.firestore.v1.Target.Builder,
                com.google.firestore.v1.TargetOrBuilder>(
                (com.google.firestore.v1.Target) targetChange_, getParentForChildren(), isClean());
        targetChange_ = null;
      }
      targetChangeCase_ = 2;
      onChanged();
      ;
      return addTargetBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The ID of a target to remove from this stream.
     * </pre>
     *
     * <code>int32 remove_target = 3;</code>
     *
     * @return The removeTarget.
     */
    public int getRemoveTarget() {
      if (targetChangeCase_ == 3) {
        return (java.lang.Integer) targetChange_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The ID of a target to remove from this stream.
     * </pre>
     *
     * <code>int32 remove_target = 3;</code>
     *
     * @param value The removeTarget to set.
     * @return This builder for chaining.
     */
    public Builder setRemoveTarget(int value) {
      targetChangeCase_ = 3;
      targetChange_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of a target to remove from this stream.
     * </pre>
     *
     * <code>int32 remove_target = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRemoveTarget() {
      if (targetChangeCase_ == 3) {
        targetChangeCase_ = 0;
        targetChange_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this target change.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.ListenRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.ListenRequest)
  private static final com.google.firestore.v1.ListenRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.ListenRequest();
  }

  public static com.google.firestore.v1.ListenRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListenRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListenRequest>() {
        @java.lang.Override
        public ListenRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListenRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListenRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListenRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.ListenRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
