/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for [Firestore.Write][google.firestore.v1.Firestore.Write].
 * The first request creates a stream, or resumes an existing one from a token.
 * When creating a new stream, the server replies with a response containing
 * only an ID and a token, to use in the next request.
 * When resuming a stream, the server first streams any responses later than the
 * given token, then a response containing only an up-to-date token, to use in
 * the next request.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.WriteRequest}
 */
public final class WriteRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.WriteRequest)
    WriteRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WriteRequest.newBuilder() to construct.
  private WriteRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteRequest() {
    database_ = "";
    streamId_ = "";
    writes_ = java.util.Collections.emptyList();
    streamToken_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WriteRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              database_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              streamId_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                writes_ = new java.util.ArrayList<com.google.firestore.v1.Write>();
                mutable_bitField0_ |= 0x00000001;
              }
              writes_.add(
                  input.readMessage(com.google.firestore.v1.Write.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              streamToken_ = input.readBytes();
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        writes_ = java.util.Collections.unmodifiableList(writes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_WriteRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_WriteRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.WriteRequest.class,
            com.google.firestore.v1.WriteRequest.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;
  private volatile java.lang.Object database_;
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * This is only required in the first message.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * This is only required in the first message.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STREAM_ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object streamId_;
  /**
   *
   *
   * <pre>
   * The ID of the write stream to resume.
   * This may only be set in the first message. When left empty, a new write
   * stream will be created.
   * </pre>
   *
   * <code>string stream_id = 2;</code>
   *
   * @return The streamId.
   */
  @java.lang.Override
  public java.lang.String getStreamId() {
    java.lang.Object ref = streamId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      streamId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The ID of the write stream to resume.
   * This may only be set in the first message. When left empty, a new write
   * stream will be created.
   * </pre>
   *
   * <code>string stream_id = 2;</code>
   *
   * @return The bytes for streamId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStreamIdBytes() {
    java.lang.Object ref = streamId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      streamId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WRITES_FIELD_NUMBER = 3;
  private java.util.List<com.google.firestore.v1.Write> writes_;
  /**
   *
   *
   * <pre>
   * The writes to apply.
   * Always executed atomically and in order.
   * This must be empty on the first request.
   * This may be empty on the last request.
   * This must not be empty on all other requests.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.Write> getWritesList() {
    return writes_;
  }
  /**
   *
   *
   * <pre>
   * The writes to apply.
   * Always executed atomically and in order.
   * This must be empty on the first request.
   * This may be empty on the last request.
   * This must not be empty on all other requests.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.v1.WriteOrBuilder> getWritesOrBuilderList() {
    return writes_;
  }
  /**
   *
   *
   * <pre>
   * The writes to apply.
   * Always executed atomically and in order.
   * This must be empty on the first request.
   * This may be empty on the last request.
   * This must not be empty on all other requests.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 3;</code>
   */
  @java.lang.Override
  public int getWritesCount() {
    return writes_.size();
  }
  /**
   *
   *
   * <pre>
   * The writes to apply.
   * Always executed atomically and in order.
   * This must be empty on the first request.
   * This may be empty on the last request.
   * This must not be empty on all other requests.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Write getWrites(int index) {
    return writes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The writes to apply.
   * Always executed atomically and in order.
   * This must be empty on the first request.
   * This may be empty on the last request.
   * This must not be empty on all other requests.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.WriteOrBuilder getWritesOrBuilder(int index) {
    return writes_.get(index);
  }

  public static final int STREAM_TOKEN_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString streamToken_;
  /**
   *
   *
   * <pre>
   * A stream token that was previously sent by the server.
   * The client should set this field to the token from the most recent
   * [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
   * received responses up to this token. After sending this token, earlier
   * tokens may not be used anymore.
   * The server may close the stream if there are too many unacknowledged
   * responses.
   * Leave this field unset when creating a new stream. To resume a stream at
   * a specific point, set this field and the `stream_id` field.
   * Leave this field unset when creating a new stream.
   * </pre>
   *
   * <code>bytes stream_token = 4;</code>
   *
   * @return The streamToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStreamToken() {
    return streamToken_;
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.firestore.v1.FirestoreProto
                .internal_static_google_firestore_v1_WriteRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this write request.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this write request.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this write request.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this write request.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getDatabaseBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    if (!getStreamIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, streamId_);
    }
    for (int i = 0; i < writes_.size(); i++) {
      output.writeMessage(3, writes_.get(i));
    }
    if (!streamToken_.isEmpty()) {
      output.writeBytes(4, streamToken_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDatabaseBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    if (!getStreamIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, streamId_);
    }
    for (int i = 0; i < writes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, writes_.get(i));
    }
    if (!streamToken_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, streamToken_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.WriteRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.WriteRequest other = (com.google.firestore.v1.WriteRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getStreamId().equals(other.getStreamId())) return false;
    if (!getWritesList().equals(other.getWritesList())) return false;
    if (!getStreamToken().equals(other.getStreamToken())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    hash = (37 * hash) + STREAM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getStreamId().hashCode();
    if (getWritesCount() > 0) {
      hash = (37 * hash) + WRITES_FIELD_NUMBER;
      hash = (53 * hash) + getWritesList().hashCode();
    }
    hash = (37 * hash) + STREAM_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getStreamToken().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.WriteRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.WriteRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.WriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.WriteRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Firestore.Write][google.firestore.v1.Firestore.Write].
   * The first request creates a stream, or resumes an existing one from a token.
   * When creating a new stream, the server replies with a response containing
   * only an ID and a token, to use in the next request.
   * When resuming a stream, the server first streams any responses later than the
   * given token, then a response containing only an up-to-date token, to use in
   * the next request.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.WriteRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.WriteRequest)
      com.google.firestore.v1.WriteRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_WriteRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_WriteRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.WriteRequest.class,
              com.google.firestore.v1.WriteRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.WriteRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWritesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      database_ = "";

      streamId_ = "";

      if (writesBuilder_ == null) {
        writes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        writesBuilder_.clear();
      }
      streamToken_ = com.google.protobuf.ByteString.EMPTY;

      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_WriteRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.WriteRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.WriteRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.WriteRequest build() {
      com.google.firestore.v1.WriteRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.WriteRequest buildPartial() {
      com.google.firestore.v1.WriteRequest result = new com.google.firestore.v1.WriteRequest(this);
      int from_bitField0_ = bitField0_;
      result.database_ = database_;
      result.streamId_ = streamId_;
      if (writesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          writes_ = java.util.Collections.unmodifiableList(writes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.writes_ = writes_;
      } else {
        result.writes_ = writesBuilder_.build();
      }
      result.streamToken_ = streamToken_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.WriteRequest) {
        return mergeFrom((com.google.firestore.v1.WriteRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.WriteRequest other) {
      if (other == com.google.firestore.v1.WriteRequest.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        onChanged();
      }
      if (!other.getStreamId().isEmpty()) {
        streamId_ = other.streamId_;
        onChanged();
      }
      if (writesBuilder_ == null) {
        if (!other.writes_.isEmpty()) {
          if (writes_.isEmpty()) {
            writes_ = other.writes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureWritesIsMutable();
            writes_.addAll(other.writes_);
          }
          onChanged();
        }
      } else {
        if (!other.writes_.isEmpty()) {
          if (writesBuilder_.isEmpty()) {
            writesBuilder_.dispose();
            writesBuilder_ = null;
            writes_ = other.writes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            writesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWritesFieldBuilder()
                    : null;
          } else {
            writesBuilder_.addAllMessages(other.writes_);
          }
        }
      }
      if (other.getStreamToken() != com.google.protobuf.ByteString.EMPTY) {
        setStreamToken(other.getStreamToken());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1.WriteRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1.WriteRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * This is only required in the first message.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * This is only required in the first message.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * This is only required in the first message.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      database_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * This is only required in the first message.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {

      database_ = getDefaultInstance().getDatabase();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * This is only required in the first message.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      database_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object streamId_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the write stream to resume.
     * This may only be set in the first message. When left empty, a new write
     * stream will be created.
     * </pre>
     *
     * <code>string stream_id = 2;</code>
     *
     * @return The streamId.
     */
    public java.lang.String getStreamId() {
      java.lang.Object ref = streamId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        streamId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the write stream to resume.
     * This may only be set in the first message. When left empty, a new write
     * stream will be created.
     * </pre>
     *
     * <code>string stream_id = 2;</code>
     *
     * @return The bytes for streamId.
     */
    public com.google.protobuf.ByteString getStreamIdBytes() {
      java.lang.Object ref = streamId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        streamId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the write stream to resume.
     * This may only be set in the first message. When left empty, a new write
     * stream will be created.
     * </pre>
     *
     * <code>string stream_id = 2;</code>
     *
     * @param value The streamId to set.
     * @return This builder for chaining.
     */
    public Builder setStreamId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      streamId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the write stream to resume.
     * This may only be set in the first message. When left empty, a new write
     * stream will be created.
     * </pre>
     *
     * <code>string stream_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStreamId() {

      streamId_ = getDefaultInstance().getStreamId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ID of the write stream to resume.
     * This may only be set in the first message. When left empty, a new write
     * stream will be created.
     * </pre>
     *
     * <code>string stream_id = 2;</code>
     *
     * @param value The bytes for streamId to set.
     * @return This builder for chaining.
     */
    public Builder setStreamIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      streamId_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.firestore.v1.Write> writes_ =
        java.util.Collections.emptyList();

    private void ensureWritesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        writes_ = new java.util.ArrayList<com.google.firestore.v1.Write>(writes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Write,
            com.google.firestore.v1.Write.Builder,
            com.google.firestore.v1.WriteOrBuilder>
        writesBuilder_;

    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public java.util.List<com.google.firestore.v1.Write> getWritesList() {
      if (writesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(writes_);
      } else {
        return writesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public int getWritesCount() {
      if (writesBuilder_ == null) {
        return writes_.size();
      } else {
        return writesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public com.google.firestore.v1.Write getWrites(int index) {
      if (writesBuilder_ == null) {
        return writes_.get(index);
      } else {
        return writesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder setWrites(int index, com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.set(index, value);
        onChanged();
      } else {
        writesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder setWrites(int index, com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.set(index, builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder addWrites(com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.add(value);
        onChanged();
      } else {
        writesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder addWrites(int index, com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.add(index, value);
        onChanged();
      } else {
        writesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder addWrites(com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.add(builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder addWrites(int index, com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.add(index, builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder addAllWrites(
        java.lang.Iterable<? extends com.google.firestore.v1.Write> values) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, writes_);
        onChanged();
      } else {
        writesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder clearWrites() {
      if (writesBuilder_ == null) {
        writes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        writesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public Builder removeWrites(int index) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.remove(index);
        onChanged();
      } else {
        writesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public com.google.firestore.v1.Write.Builder getWritesBuilder(int index) {
      return getWritesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public com.google.firestore.v1.WriteOrBuilder getWritesOrBuilder(int index) {
      if (writesBuilder_ == null) {
        return writes_.get(index);
      } else {
        return writesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public java.util.List<? extends com.google.firestore.v1.WriteOrBuilder>
        getWritesOrBuilderList() {
      if (writesBuilder_ != null) {
        return writesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(writes_);
      }
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public com.google.firestore.v1.Write.Builder addWritesBuilder() {
      return getWritesFieldBuilder().addBuilder(com.google.firestore.v1.Write.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public com.google.firestore.v1.Write.Builder addWritesBuilder(int index) {
      return getWritesFieldBuilder()
          .addBuilder(index, com.google.firestore.v1.Write.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The writes to apply.
     * Always executed atomically and in order.
     * This must be empty on the first request.
     * This may be empty on the last request.
     * This must not be empty on all other requests.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 3;</code>
     */
    public java.util.List<com.google.firestore.v1.Write.Builder> getWritesBuilderList() {
      return getWritesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Write,
            com.google.firestore.v1.Write.Builder,
            com.google.firestore.v1.WriteOrBuilder>
        getWritesFieldBuilder() {
      if (writesBuilder_ == null) {
        writesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1.Write,
                com.google.firestore.v1.Write.Builder,
                com.google.firestore.v1.WriteOrBuilder>(
                writes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        writes_ = null;
      }
      return writesBuilder_;
    }

    private com.google.protobuf.ByteString streamToken_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * A stream token that was previously sent by the server.
     * The client should set this field to the token from the most recent
     * [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
     * received responses up to this token. After sending this token, earlier
     * tokens may not be used anymore.
     * The server may close the stream if there are too many unacknowledged
     * responses.
     * Leave this field unset when creating a new stream. To resume a stream at
     * a specific point, set this field and the `stream_id` field.
     * Leave this field unset when creating a new stream.
     * </pre>
     *
     * <code>bytes stream_token = 4;</code>
     *
     * @return The streamToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStreamToken() {
      return streamToken_;
    }
    /**
     *
     *
     * <pre>
     * A stream token that was previously sent by the server.
     * The client should set this field to the token from the most recent
     * [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
     * received responses up to this token. After sending this token, earlier
     * tokens may not be used anymore.
     * The server may close the stream if there are too many unacknowledged
     * responses.
     * Leave this field unset when creating a new stream. To resume a stream at
     * a specific point, set this field and the `stream_id` field.
     * Leave this field unset when creating a new stream.
     * </pre>
     *
     * <code>bytes stream_token = 4;</code>
     *
     * @param value The streamToken to set.
     * @return This builder for chaining.
     */
    public Builder setStreamToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      streamToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A stream token that was previously sent by the server.
     * The client should set this field to the token from the most recent
     * [WriteResponse][google.firestore.v1.WriteResponse] it has received. This acknowledges that the client has
     * received responses up to this token. After sending this token, earlier
     * tokens may not be used anymore.
     * The server may close the stream if there are too many unacknowledged
     * responses.
     * Leave this field unset when creating a new stream. To resume a stream at
     * a specific point, set this field and the `stream_id` field.
     * Leave this field unset when creating a new stream.
     * </pre>
     *
     * <code>bytes stream_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStreamToken() {

      streamToken_ = getDefaultInstance().getStreamToken();
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this write request.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.WriteRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.WriteRequest)
  private static final com.google.firestore.v1.WriteRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.WriteRequest();
  }

  public static com.google.firestore.v1.WriteRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteRequest> PARSER =
      new com.google.protobuf.AbstractParser<WriteRequest>() {
        @java.lang.Override
        public WriteRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WriteRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WriteRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.WriteRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
