/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.RunQueryRequest}
 */
public final class RunQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.RunQueryRequest)
    RunQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunQueryRequest.newBuilder() to construct.
  private RunQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunQueryRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunQueryRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RunQueryRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              com.google.firestore.v1.StructuredQuery.Builder subBuilder = null;
              if (queryTypeCase_ == 2) {
                subBuilder = ((com.google.firestore.v1.StructuredQuery) queryType_).toBuilder();
              }
              queryType_ =
                  input.readMessage(
                      com.google.firestore.v1.StructuredQuery.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1.StructuredQuery) queryType_);
                queryType_ = subBuilder.buildPartial();
              }
              queryTypeCase_ = 2;
              break;
            }
          case 42:
            {
              consistencySelectorCase_ = 5;
              consistencySelector_ = input.readBytes();
              break;
            }
          case 50:
            {
              com.google.firestore.v1.TransactionOptions.Builder subBuilder = null;
              if (consistencySelectorCase_ == 6) {
                subBuilder =
                    ((com.google.firestore.v1.TransactionOptions) consistencySelector_).toBuilder();
              }
              consistencySelector_ =
                  input.readMessage(
                      com.google.firestore.v1.TransactionOptions.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.firestore.v1.TransactionOptions) consistencySelector_);
                consistencySelector_ = subBuilder.buildPartial();
              }
              consistencySelectorCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (consistencySelectorCase_ == 7) {
                subBuilder = ((com.google.protobuf.Timestamp) consistencySelector_).toBuilder();
              }
              consistencySelector_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Timestamp) consistencySelector_);
                consistencySelector_ = subBuilder.buildPartial();
              }
              consistencySelectorCase_ = 7;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.RunQueryRequest.class,
            com.google.firestore.v1.RunQueryRequest.Builder.class);
  }

  private int queryTypeCase_ = 0;
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCTURED_QUERY(2),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return STRUCTURED_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  private int consistencySelectorCase_ = 0;
  private java.lang.Object consistencySelector_;

  public enum ConsistencySelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(5),
    NEW_TRANSACTION(6),
    READ_TIME(7),
    CONSISTENCYSELECTOR_NOT_SET(0);
    private final int value;

    private ConsistencySelectorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencySelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencySelectorCase forNumber(int value) {
      switch (value) {
        case 5:
          return TRANSACTION;
        case 6:
          return NEW_TRANSACTION;
        case 7:
          return READ_TIME;
        case 0:
          return CONSISTENCYSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencySelectorCase getConsistencySelectorCase() {
    return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource name. In the format:
   * `projects/{project_id}/databases/{database_id}/documents` or
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * For example:
   * `projects/my-project/databases/my-database/documents` or
   * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STRUCTURED_QUERY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   *
   * @return Whether the structuredQuery field is set.
   */
  @java.lang.Override
  public boolean hasStructuredQuery() {
    return queryTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   *
   * @return The structuredQuery.
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
    if (queryTypeCase_ == 2) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }

  public static final int TRANSACTION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Reads documents in a transaction.
   * </pre>
   *
   * <code>bytes transaction = 5;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencySelectorCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Reads documents in a transaction.
   * </pre>
   *
   * <code>bytes transaction = 5;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.protobuf.ByteString) consistencySelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int NEW_TRANSACTION_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   *
   * @return Whether the newTransaction field is set.
   */
  @java.lang.Override
  public boolean hasNewTransaction() {
    return consistencySelectorCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   *
   * @return The newTransaction.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions getNewTransaction() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
    if (consistencySelectorCase_ == 6) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int READ_TIME_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   * This may not be older than 270 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencySelectorCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   * This may not be older than 270 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   * This may not be older than 270 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (queryTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    if (consistencySelectorCase_ == 5) {
      output.writeBytes(5, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      output.writeMessage(6, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (queryTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    if (consistencySelectorCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              5, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.RunQueryRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.RunQueryRequest other = (com.google.firestore.v1.RunQueryRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 2:
        if (!getStructuredQuery().equals(other.getStructuredQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
    switch (consistencySelectorCase_) {
      case 5:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 6:
        if (!getNewTransaction().equals(other.getNewTransaction())) return false;
        break;
      case 7:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (queryTypeCase_) {
      case 2:
        hash = (37 * hash) + STRUCTURED_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getStructuredQuery().hashCode();
        break;
      case 0:
      default:
    }
    switch (consistencySelectorCase_) {
      case 5:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 6:
        hash = (37 * hash) + NEW_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNewTransaction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.RunQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.RunQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.RunQueryRequest)
      com.google.firestore.v1.RunQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.RunQueryRequest.class,
              com.google.firestore.v1.RunQueryRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.RunQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      queryTypeCase_ = 0;
      queryType_ = null;
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.RunQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryRequest build() {
      com.google.firestore.v1.RunQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryRequest buildPartial() {
      com.google.firestore.v1.RunQueryRequest result =
          new com.google.firestore.v1.RunQueryRequest(this);
      result.parent_ = parent_;
      if (queryTypeCase_ == 2) {
        if (structuredQueryBuilder_ == null) {
          result.queryType_ = queryType_;
        } else {
          result.queryType_ = structuredQueryBuilder_.build();
        }
      }
      if (consistencySelectorCase_ == 5) {
        result.consistencySelector_ = consistencySelector_;
      }
      if (consistencySelectorCase_ == 6) {
        if (newTransactionBuilder_ == null) {
          result.consistencySelector_ = consistencySelector_;
        } else {
          result.consistencySelector_ = newTransactionBuilder_.build();
        }
      }
      if (consistencySelectorCase_ == 7) {
        if (readTimeBuilder_ == null) {
          result.consistencySelector_ = consistencySelector_;
        } else {
          result.consistencySelector_ = readTimeBuilder_.build();
        }
      }
      result.queryTypeCase_ = queryTypeCase_;
      result.consistencySelectorCase_ = consistencySelectorCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.RunQueryRequest) {
        return mergeFrom((com.google.firestore.v1.RunQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.RunQueryRequest other) {
      if (other == com.google.firestore.v1.RunQueryRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      switch (other.getQueryTypeCase()) {
        case STRUCTURED_QUERY:
          {
            mergeStructuredQuery(other.getStructuredQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConsistencySelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case NEW_TRANSACTION:
          {
            mergeNewTransaction(other.getNewTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1.RunQueryRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1.RunQueryRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private int consistencySelectorCase_ = 0;
    private java.lang.Object consistencySelector_;

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public Builder clearConsistencySelector() {
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        structuredQueryBuilder_;
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return Whether the structuredQuery field is set.
     */
    @java.lang.Override
    public boolean hasStructuredQuery() {
      return queryTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return The structuredQuery.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 2) {
          return structuredQueryBuilder_.getMessage();
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder setStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder setStructuredQuery(
        com.google.firestore.v1.StructuredQuery.Builder builderForValue) {
      if (structuredQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder mergeStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2
            && queryType_ != com.google.firestore.v1.StructuredQuery.getDefaultInstance()) {
          queryType_ =
              com.google.firestore.v1.StructuredQuery.newBuilder(
                      (com.google.firestore.v1.StructuredQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 2) {
          structuredQueryBuilder_.mergeFrom(value);
        }
        structuredQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public Builder clearStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 2) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        structuredQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    public com.google.firestore.v1.StructuredQuery.Builder getStructuredQueryBuilder() {
      return getStructuredQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
      if ((queryTypeCase_ == 2) && (structuredQueryBuilder_ != null)) {
        return structuredQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 2) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        getStructuredQueryFieldBuilder() {
      if (structuredQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 2)) {
          queryType_ = com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        }
        structuredQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.StructuredQuery,
                com.google.firestore.v1.StructuredQuery.Builder,
                com.google.firestore.v1.StructuredQueryOrBuilder>(
                (com.google.firestore.v1.StructuredQuery) queryType_,
                getParentForChildren(),
                isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 2;
      onChanged();
      ;
      return structuredQueryBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencySelectorCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencySelectorCase_ == 5) {
        return (com.google.protobuf.ByteString) consistencySelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencySelectorCase_ = 5;
      consistencySelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencySelectorCase_ == 5) {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        newTransactionBuilder_;
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     *
     * @return Whether the newTransaction field is set.
     */
    @java.lang.Override
    public boolean hasNewTransaction() {
      return consistencySelectorCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     *
     * @return The newTransaction.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions getNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 6) {
          return newTransactionBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder setNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder setNewTransaction(
        com.google.firestore.v1.TransactionOptions.Builder builderForValue) {
      if (newTransactionBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder mergeNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6
            && consistencySelector_
                != com.google.firestore.v1.TransactionOptions.getDefaultInstance()) {
          consistencySelector_ =
              com.google.firestore.v1.TransactionOptions.newBuilder(
                      (com.google.firestore.v1.TransactionOptions) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 6) {
          newTransactionBuilder_.mergeFrom(value);
        }
        newTransactionBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public Builder clearNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 6) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        newTransactionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    public com.google.firestore.v1.TransactionOptions.Builder getNewTransactionBuilder() {
      return getNewTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
      if ((consistencySelectorCase_ == 6) && (newTransactionBuilder_ != null)) {
        return newTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 6) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        getNewTransactionFieldBuilder() {
      if (newTransactionBuilder_ == null) {
        if (!(consistencySelectorCase_ == 6)) {
          consistencySelector_ = com.google.firestore.v1.TransactionOptions.getDefaultInstance();
        }
        newTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TransactionOptions,
                com.google.firestore.v1.TransactionOptions.Builder,
                com.google.firestore.v1.TransactionOptionsOrBuilder>(
                (com.google.firestore.v1.TransactionOptions) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 6;
      onChanged();
      ;
      return newTransactionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 7) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7
            && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencySelector_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 7) {
          readTimeBuilder_.mergeFrom(value);
        }
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencySelectorCase_ == 7) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     * This may not be older than 270 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencySelectorCase_ == 7)) {
          consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 7;
      onChanged();
      ;
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.RunQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.RunQueryRequest)
  private static final com.google.firestore.v1.RunQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.RunQueryRequest();
  }

  public static com.google.firestore.v1.RunQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunQueryRequest>() {
        @java.lang.Override
        public RunQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RunQueryRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RunQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.RunQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
