/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A specification of a set of documents to listen to.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.Target}
 */
public final class Target extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.Target)
    TargetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Target.newBuilder() to construct.
  private Target(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Target() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Target();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Target(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              com.google.firestore.v1.Target.QueryTarget.Builder subBuilder = null;
              if (targetTypeCase_ == 2) {
                subBuilder = ((com.google.firestore.v1.Target.QueryTarget) targetType_).toBuilder();
              }
              targetType_ =
                  input.readMessage(
                      com.google.firestore.v1.Target.QueryTarget.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1.Target.QueryTarget) targetType_);
                targetType_ = subBuilder.buildPartial();
              }
              targetTypeCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.firestore.v1.Target.DocumentsTarget.Builder subBuilder = null;
              if (targetTypeCase_ == 3) {
                subBuilder =
                    ((com.google.firestore.v1.Target.DocumentsTarget) targetType_).toBuilder();
              }
              targetType_ =
                  input.readMessage(
                      com.google.firestore.v1.Target.DocumentsTarget.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.firestore.v1.Target.DocumentsTarget) targetType_);
                targetType_ = subBuilder.buildPartial();
              }
              targetTypeCase_ = 3;
              break;
            }
          case 34:
            {
              resumeTypeCase_ = 4;
              resumeType_ = input.readBytes();
              break;
            }
          case 40:
            {
              targetId_ = input.readInt32();
              break;
            }
          case 48:
            {
              once_ = input.readBool();
              break;
            }
          case 90:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (resumeTypeCase_ == 11) {
                subBuilder = ((com.google.protobuf.Timestamp) resumeType_).toBuilder();
              }
              resumeType_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Timestamp) resumeType_);
                resumeType_ = subBuilder.buildPartial();
              }
              resumeTypeCase_ = 11;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_Target_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_Target_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.Target.class, com.google.firestore.v1.Target.Builder.class);
  }

  public interface DocumentsTargetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.Target.DocumentsTarget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return A list containing the documents.
     */
    java.util.List<java.lang.String> getDocumentsList();
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return The count of documents.
     */
    int getDocumentsCount();
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The documents at the given index.
     */
    java.lang.String getDocuments(int index);
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the documents at the given index.
     */
    com.google.protobuf.ByteString getDocumentsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * A target specified by a set of documents names.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Target.DocumentsTarget}
   */
  public static final class DocumentsTarget extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.Target.DocumentsTarget)
      DocumentsTargetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DocumentsTarget.newBuilder() to construct.
    private DocumentsTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DocumentsTarget() {
      documents_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DocumentsTarget();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DocumentsTarget(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  documents_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                documents_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          documents_ = documents_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_DocumentsTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_DocumentsTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Target.DocumentsTarget.class,
              com.google.firestore.v1.Target.DocumentsTarget.Builder.class);
    }

    public static final int DOCUMENTS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList documents_;
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return A list containing the documents.
     */
    public com.google.protobuf.ProtocolStringList getDocumentsList() {
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return The count of documents.
     */
    public int getDocumentsCount() {
      return documents_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The documents at the given index.
     */
    public java.lang.String getDocuments(int index) {
      return documents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of
     * the given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the documents at the given index.
     */
    public com.google.protobuf.ByteString getDocumentsBytes(int index) {
      return documents_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < documents_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, documents_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < documents_.size(); i++) {
          dataSize += computeStringSizeNoTag(documents_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDocumentsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.Target.DocumentsTarget)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.Target.DocumentsTarget other =
          (com.google.firestore.v1.Target.DocumentsTarget) obj;

      if (!getDocumentsList().equals(other.getDocumentsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDocumentsCount() > 0) {
        hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.DocumentsTarget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.v1.Target.DocumentsTarget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of documents names.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.Target.DocumentsTarget}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.Target.DocumentsTarget)
        com.google.firestore.v1.Target.DocumentsTargetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_DocumentsTarget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_DocumentsTarget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.Target.DocumentsTarget.class,
                com.google.firestore.v1.Target.DocumentsTarget.Builder.class);
      }

      // Construct using com.google.firestore.v1.Target.DocumentsTarget.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        documents_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_DocumentsTarget_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.DocumentsTarget getDefaultInstanceForType() {
        return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.DocumentsTarget build() {
        com.google.firestore.v1.Target.DocumentsTarget result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.DocumentsTarget buildPartial() {
        com.google.firestore.v1.Target.DocumentsTarget result =
            new com.google.firestore.v1.Target.DocumentsTarget(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          documents_ = documents_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.documents_ = documents_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.Target.DocumentsTarget) {
          return mergeFrom((com.google.firestore.v1.Target.DocumentsTarget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1.Target.DocumentsTarget other) {
        if (other == com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance())
          return this;
        if (!other.documents_.isEmpty()) {
          if (documents_.isEmpty()) {
            documents_ = other.documents_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDocumentsIsMutable();
            documents_.addAll(other.documents_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1.Target.DocumentsTarget parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.firestore.v1.Target.DocumentsTarget) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList documents_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureDocumentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          documents_ = new com.google.protobuf.LazyStringArrayList(documents_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @return A list containing the documents.
       */
      public com.google.protobuf.ProtocolStringList getDocumentsList() {
        return documents_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @return The count of documents.
       */
      public int getDocumentsCount() {
        return documents_.size();
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The documents at the given index.
       */
      public java.lang.String getDocuments(int index) {
        return documents_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the documents at the given index.
       */
      public com.google.protobuf.ByteString getDocumentsBytes(int index) {
        return documents_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The documents to set.
       * @return This builder for chaining.
       */
      public Builder setDocuments(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param value The documents to add.
       * @return This builder for chaining.
       */
      public Builder addDocuments(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDocumentsIsMutable();
        documents_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param values The documents to add.
       * @return This builder for chaining.
       */
      public Builder addAllDocuments(java.lang.Iterable<java.lang.String> values) {
        ensureDocumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDocuments() {
        documents_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The names of the documents to retrieve. In the format:
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * The request will fail if any of the document is not a child resource of
       * the given `database`. Duplicate names will be elided.
       * </pre>
       *
       * <code>repeated string documents = 2;</code>
       *
       * @param value The bytes of the documents to add.
       * @return This builder for chaining.
       */
      public Builder addDocumentsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDocumentsIsMutable();
        documents_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.Target.DocumentsTarget)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.Target.DocumentsTarget)
    private static final com.google.firestore.v1.Target.DocumentsTarget DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.Target.DocumentsTarget();
    }

    public static com.google.firestore.v1.Target.DocumentsTarget getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DocumentsTarget> PARSER =
        new com.google.protobuf.AbstractParser<DocumentsTarget>() {
          @java.lang.Override
          public DocumentsTarget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DocumentsTarget(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DocumentsTarget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DocumentsTarget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.Target.DocumentsTarget getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QueryTargetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.Target.QueryTarget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The parent.
     */
    java.lang.String getParent();
    /**
     *
     *
     * <pre>
     * The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The bytes for parent.
     */
    com.google.protobuf.ByteString getParentBytes();

    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return Whether the structuredQuery field is set.
     */
    boolean hasStructuredQuery();
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return The structuredQuery.
     */
    com.google.firestore.v1.StructuredQuery getStructuredQuery();
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder();

    public com.google.firestore.v1.Target.QueryTarget.QueryTypeCase getQueryTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A target specified by a query.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Target.QueryTarget}
   */
  public static final class QueryTarget extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.Target.QueryTarget)
      QueryTargetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QueryTarget.newBuilder() to construct.
    private QueryTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QueryTarget() {
      parent_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QueryTarget();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private QueryTarget(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                parent_ = s;
                break;
              }
            case 18:
              {
                com.google.firestore.v1.StructuredQuery.Builder subBuilder = null;
                if (queryTypeCase_ == 2) {
                  subBuilder = ((com.google.firestore.v1.StructuredQuery) queryType_).toBuilder();
                }
                queryType_ =
                    input.readMessage(
                        com.google.firestore.v1.StructuredQuery.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom((com.google.firestore.v1.StructuredQuery) queryType_);
                  queryType_ = subBuilder.buildPartial();
                }
                queryTypeCase_ = 2;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_QueryTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_QueryTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Target.QueryTarget.class,
              com.google.firestore.v1.Target.QueryTarget.Builder.class);
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public enum QueryTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STRUCTURED_QUERY(2),
      QUERYTYPE_NOT_SET(0);
      private final int value;

      private QueryTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static QueryTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static QueryTypeCase forNumber(int value) {
        switch (value) {
          case 2:
            return STRUCTURED_QUERY;
          case 0:
            return QUERYTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object parent_;
    /**
     *
     *
     * <pre>
     * The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The parent.
     */
    @java.lang.Override
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The parent resource name. In the format:
     * `projects/{project_id}/databases/{database_id}/documents` or
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * For example:
     * `projects/my-project/databases/my-database/documents` or
     * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The bytes for parent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STRUCTURED_QUERY_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return Whether the structuredQuery field is set.
     */
    @java.lang.Override
    public boolean hasStructuredQuery() {
      return queryTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     *
     * @return The structuredQuery.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
      if (queryTypeCase_ == 2) {
        return (com.google.firestore.v1.StructuredQuery) queryType_;
      }
      return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
      if (queryTypeCase_ == 2) {
        return (com.google.firestore.v1.StructuredQuery) queryType_;
      }
      return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
      }
      if (queryTypeCase_ == 2) {
        output.writeMessage(2, (com.google.firestore.v1.StructuredQuery) queryType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
      }
      if (queryTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.firestore.v1.StructuredQuery) queryType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.Target.QueryTarget)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.Target.QueryTarget other =
          (com.google.firestore.v1.Target.QueryTarget) obj;

      if (!getParent().equals(other.getParent())) return false;
      if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
      switch (queryTypeCase_) {
        case 2:
          if (!getStructuredQuery().equals(other.getStructuredQuery())) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARENT_FIELD_NUMBER;
      hash = (53 * hash) + getParent().hashCode();
      switch (queryTypeCase_) {
        case 2:
          hash = (37 * hash) + STRUCTURED_QUERY_FIELD_NUMBER;
          hash = (53 * hash) + getStructuredQuery().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.Target.QueryTarget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.firestore.v1.Target.QueryTarget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.Target.QueryTarget}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.Target.QueryTarget)
        com.google.firestore.v1.Target.QueryTargetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_QueryTarget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_QueryTarget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.Target.QueryTarget.class,
                com.google.firestore.v1.Target.QueryTarget.Builder.class);
      }

      // Construct using com.google.firestore.v1.Target.QueryTarget.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        parent_ = "";

        queryTypeCase_ = 0;
        queryType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.FirestoreProto
            .internal_static_google_firestore_v1_Target_QueryTarget_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.QueryTarget getDefaultInstanceForType() {
        return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.QueryTarget build() {
        com.google.firestore.v1.Target.QueryTarget result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.Target.QueryTarget buildPartial() {
        com.google.firestore.v1.Target.QueryTarget result =
            new com.google.firestore.v1.Target.QueryTarget(this);
        result.parent_ = parent_;
        if (queryTypeCase_ == 2) {
          if (structuredQueryBuilder_ == null) {
            result.queryType_ = queryType_;
          } else {
            result.queryType_ = structuredQueryBuilder_.build();
          }
        }
        result.queryTypeCase_ = queryTypeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.Target.QueryTarget) {
          return mergeFrom((com.google.firestore.v1.Target.QueryTarget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1.Target.QueryTarget other) {
        if (other == com.google.firestore.v1.Target.QueryTarget.getDefaultInstance()) return this;
        if (!other.getParent().isEmpty()) {
          parent_ = other.parent_;
          onChanged();
        }
        switch (other.getQueryTypeCase()) {
          case STRUCTURED_QUERY:
            {
              mergeStructuredQuery(other.getStructuredQuery());
              break;
            }
          case QUERYTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.firestore.v1.Target.QueryTarget parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.firestore.v1.Target.QueryTarget) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int queryTypeCase_ = 0;
      private java.lang.Object queryType_;

      public QueryTypeCase getQueryTypeCase() {
        return QueryTypeCase.forNumber(queryTypeCase_);
      }

      public Builder clearQueryType() {
        queryTypeCase_ = 0;
        queryType_ = null;
        onChanged();
        return this;
      }

      private java.lang.Object parent_ = "";
      /**
       *
       *
       * <pre>
       * The parent resource name. In the format:
       * `projects/{project_id}/databases/{database_id}/documents` or
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * For example:
       * `projects/my-project/databases/my-database/documents` or
       * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
       * </pre>
       *
       * <code>string parent = 1;</code>
       *
       * @return The parent.
       */
      public java.lang.String getParent() {
        java.lang.Object ref = parent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The parent resource name. In the format:
       * `projects/{project_id}/databases/{database_id}/documents` or
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * For example:
       * `projects/my-project/databases/my-database/documents` or
       * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
       * </pre>
       *
       * <code>string parent = 1;</code>
       *
       * @return The bytes for parent.
       */
      public com.google.protobuf.ByteString getParentBytes() {
        java.lang.Object ref = parent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The parent resource name. In the format:
       * `projects/{project_id}/databases/{database_id}/documents` or
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * For example:
       * `projects/my-project/databases/my-database/documents` or
       * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
       * </pre>
       *
       * <code>string parent = 1;</code>
       *
       * @param value The parent to set.
       * @return This builder for chaining.
       */
      public Builder setParent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        parent_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The parent resource name. In the format:
       * `projects/{project_id}/databases/{database_id}/documents` or
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * For example:
       * `projects/my-project/databases/my-database/documents` or
       * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
       * </pre>
       *
       * <code>string parent = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParent() {

        parent_ = getDefaultInstance().getParent();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The parent resource name. In the format:
       * `projects/{project_id}/databases/{database_id}/documents` or
       * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
       * For example:
       * `projects/my-project/databases/my-database/documents` or
       * `projects/my-project/databases/my-database/documents/chatrooms/my-chatroom`
       * </pre>
       *
       * <code>string parent = 1;</code>
       *
       * @param value The bytes for parent to set.
       * @return This builder for chaining.
       */
      public Builder setParentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        parent_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1.StructuredQuery,
              com.google.firestore.v1.StructuredQuery.Builder,
              com.google.firestore.v1.StructuredQueryOrBuilder>
          structuredQueryBuilder_;
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       *
       * @return Whether the structuredQuery field is set.
       */
      @java.lang.Override
      public boolean hasStructuredQuery() {
        return queryTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       *
       * @return The structuredQuery.
       */
      @java.lang.Override
      public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
        if (structuredQueryBuilder_ == null) {
          if (queryTypeCase_ == 2) {
            return (com.google.firestore.v1.StructuredQuery) queryType_;
          }
          return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        } else {
          if (queryTypeCase_ == 2) {
            return structuredQueryBuilder_.getMessage();
          }
          return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      public Builder setStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
        if (structuredQueryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryType_ = value;
          onChanged();
        } else {
          structuredQueryBuilder_.setMessage(value);
        }
        queryTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      public Builder setStructuredQuery(
          com.google.firestore.v1.StructuredQuery.Builder builderForValue) {
        if (structuredQueryBuilder_ == null) {
          queryType_ = builderForValue.build();
          onChanged();
        } else {
          structuredQueryBuilder_.setMessage(builderForValue.build());
        }
        queryTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      public Builder mergeStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
        if (structuredQueryBuilder_ == null) {
          if (queryTypeCase_ == 2
              && queryType_ != com.google.firestore.v1.StructuredQuery.getDefaultInstance()) {
            queryType_ =
                com.google.firestore.v1.StructuredQuery.newBuilder(
                        (com.google.firestore.v1.StructuredQuery) queryType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            queryType_ = value;
          }
          onChanged();
        } else {
          if (queryTypeCase_ == 2) {
            structuredQueryBuilder_.mergeFrom(value);
          }
          structuredQueryBuilder_.setMessage(value);
        }
        queryTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      public Builder clearStructuredQuery() {
        if (structuredQueryBuilder_ == null) {
          if (queryTypeCase_ == 2) {
            queryTypeCase_ = 0;
            queryType_ = null;
            onChanged();
          }
        } else {
          if (queryTypeCase_ == 2) {
            queryTypeCase_ = 0;
            queryType_ = null;
          }
          structuredQueryBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      public com.google.firestore.v1.StructuredQuery.Builder getStructuredQueryBuilder() {
        return getStructuredQueryFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      @java.lang.Override
      public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
        if ((queryTypeCase_ == 2) && (structuredQueryBuilder_ != null)) {
          return structuredQueryBuilder_.getMessageOrBuilder();
        } else {
          if (queryTypeCase_ == 2) {
            return (com.google.firestore.v1.StructuredQuery) queryType_;
          }
          return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A structured query.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredQuery structured_query = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1.StructuredQuery,
              com.google.firestore.v1.StructuredQuery.Builder,
              com.google.firestore.v1.StructuredQueryOrBuilder>
          getStructuredQueryFieldBuilder() {
        if (structuredQueryBuilder_ == null) {
          if (!(queryTypeCase_ == 2)) {
            queryType_ = com.google.firestore.v1.StructuredQuery.getDefaultInstance();
          }
          structuredQueryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1.StructuredQuery,
                  com.google.firestore.v1.StructuredQuery.Builder,
                  com.google.firestore.v1.StructuredQueryOrBuilder>(
                  (com.google.firestore.v1.StructuredQuery) queryType_,
                  getParentForChildren(),
                  isClean());
          queryType_ = null;
        }
        queryTypeCase_ = 2;
        onChanged();
        ;
        return structuredQueryBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.Target.QueryTarget)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.Target.QueryTarget)
    private static final com.google.firestore.v1.Target.QueryTarget DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.Target.QueryTarget();
    }

    public static com.google.firestore.v1.Target.QueryTarget getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryTarget> PARSER =
        new com.google.protobuf.AbstractParser<QueryTarget>() {
          @java.lang.Override
          public QueryTarget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new QueryTarget(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<QueryTarget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryTarget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.Target.QueryTarget getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int targetTypeCase_ = 0;
  private java.lang.Object targetType_;

  public enum TargetTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    QUERY(2),
    DOCUMENTS(3),
    TARGETTYPE_NOT_SET(0);
    private final int value;

    private TargetTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return QUERY;
        case 3:
          return DOCUMENTS;
        case 0:
          return TARGETTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetTypeCase getTargetTypeCase() {
    return TargetTypeCase.forNumber(targetTypeCase_);
  }

  private int resumeTypeCase_ = 0;
  private java.lang.Object resumeType_;

  public enum ResumeTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RESUME_TOKEN(4),
    READ_TIME(11),
    RESUMETYPE_NOT_SET(0);
    private final int value;

    private ResumeTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResumeTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResumeTypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return RESUME_TOKEN;
        case 11:
          return READ_TIME;
        case 0:
          return RESUMETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResumeTypeCase getResumeTypeCase() {
    return ResumeTypeCase.forNumber(resumeTypeCase_);
  }

  public static final int QUERY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A target specified by a query.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return targetTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A target specified by a query.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.firestore.v1.Target.QueryTarget getQuery() {
    if (targetTypeCase_ == 2) {
      return (com.google.firestore.v1.Target.QueryTarget) targetType_;
    }
    return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A target specified by a query.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Target.QueryTargetOrBuilder getQueryOrBuilder() {
    if (targetTypeCase_ == 2) {
      return (com.google.firestore.v1.Target.QueryTarget) targetType_;
    }
    return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
  }

  public static final int DOCUMENTS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A target specified by a set of document names.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
   *
   * @return Whether the documents field is set.
   */
  @java.lang.Override
  public boolean hasDocuments() {
    return targetTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A target specified by a set of document names.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
   *
   * @return The documents.
   */
  @java.lang.Override
  public com.google.firestore.v1.Target.DocumentsTarget getDocuments() {
    if (targetTypeCase_ == 3) {
      return (com.google.firestore.v1.Target.DocumentsTarget) targetType_;
    }
    return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A target specified by a set of document names.
   * </pre>
   *
   * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Target.DocumentsTargetOrBuilder getDocumentsOrBuilder() {
    if (targetTypeCase_ == 3) {
      return (com.google.firestore.v1.Target.DocumentsTarget) targetType_;
    }
    return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
  }

  public static final int RESUME_TOKEN_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
   * Using a resume token with a different target is unsupported and may fail.
   * </pre>
   *
   * <code>bytes resume_token = 4;</code>
   *
   * @return Whether the resumeToken field is set.
   */
  @java.lang.Override
  public boolean hasResumeToken() {
    return resumeTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
   * Using a resume token with a different target is unsupported and may fail.
   * </pre>
   *
   * <code>bytes resume_token = 4;</code>
   *
   * @return The resumeToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResumeToken() {
    if (resumeTypeCase_ == 4) {
      return (com.google.protobuf.ByteString) resumeType_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int READ_TIME_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Start listening after a specific `read_time`.
   * The client must know the state of matching documents at this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 11;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return resumeTypeCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Start listening after a specific `read_time`.
   * The client must know the state of matching documents at this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 11;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (resumeTypeCase_ == 11) {
      return (com.google.protobuf.Timestamp) resumeType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Start listening after a specific `read_time`.
   * The client must know the state of matching documents at this time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (resumeTypeCase_ == 11) {
      return (com.google.protobuf.Timestamp) resumeType_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TARGET_ID_FIELD_NUMBER = 5;
  private int targetId_;
  /**
   *
   *
   * <pre>
   * The target ID that identifies the target on the stream. Must be a positive
   * number and non-zero.
   * </pre>
   *
   * <code>int32 target_id = 5;</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public int getTargetId() {
    return targetId_;
  }

  public static final int ONCE_FIELD_NUMBER = 6;
  private boolean once_;
  /**
   *
   *
   * <pre>
   * If the target should be removed once it is current and consistent.
   * </pre>
   *
   * <code>bool once = 6;</code>
   *
   * @return The once.
   */
  @java.lang.Override
  public boolean getOnce() {
    return once_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (targetTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.Target.QueryTarget) targetType_);
    }
    if (targetTypeCase_ == 3) {
      output.writeMessage(3, (com.google.firestore.v1.Target.DocumentsTarget) targetType_);
    }
    if (resumeTypeCase_ == 4) {
      output.writeBytes(4, (com.google.protobuf.ByteString) resumeType_);
    }
    if (targetId_ != 0) {
      output.writeInt32(5, targetId_);
    }
    if (once_ != false) {
      output.writeBool(6, once_);
    }
    if (resumeTypeCase_ == 11) {
      output.writeMessage(11, (com.google.protobuf.Timestamp) resumeType_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (targetTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.Target.QueryTarget) targetType_);
    }
    if (targetTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.firestore.v1.Target.DocumentsTarget) targetType_);
    }
    if (resumeTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              4, (com.google.protobuf.ByteString) resumeType_);
    }
    if (targetId_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, targetId_);
    }
    if (once_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, once_);
    }
    if (resumeTypeCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.protobuf.Timestamp) resumeType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.Target)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.Target other = (com.google.firestore.v1.Target) obj;

    if (getTargetId() != other.getTargetId()) return false;
    if (getOnce() != other.getOnce()) return false;
    if (!getTargetTypeCase().equals(other.getTargetTypeCase())) return false;
    switch (targetTypeCase_) {
      case 2:
        if (!getQuery().equals(other.getQuery())) return false;
        break;
      case 3:
        if (!getDocuments().equals(other.getDocuments())) return false;
        break;
      case 0:
      default:
    }
    if (!getResumeTypeCase().equals(other.getResumeTypeCase())) return false;
    switch (resumeTypeCase_) {
      case 4:
        if (!getResumeToken().equals(other.getResumeToken())) return false;
        break;
      case 11:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId();
    hash = (37 * hash) + ONCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOnce());
    switch (targetTypeCase_) {
      case 2:
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getDocuments().hashCode();
        break;
      case 0:
      default:
    }
    switch (resumeTypeCase_) {
      case 4:
        hash = (37 * hash) + RESUME_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getResumeToken().hashCode();
        break;
      case 11:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.Target parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Target parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Target parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Target parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Target parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.Target parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.Target parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Target parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Target parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Target parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.Target parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.Target parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.Target prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A specification of a set of documents to listen to.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.Target}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.Target)
      com.google.firestore.v1.TargetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.Target.class, com.google.firestore.v1.Target.Builder.class);
    }

    // Construct using com.google.firestore.v1.Target.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      targetId_ = 0;

      once_ = false;

      targetTypeCase_ = 0;
      targetType_ = null;
      resumeTypeCase_ = 0;
      resumeType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_Target_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.Target getDefaultInstanceForType() {
      return com.google.firestore.v1.Target.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.Target build() {
      com.google.firestore.v1.Target result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.Target buildPartial() {
      com.google.firestore.v1.Target result = new com.google.firestore.v1.Target(this);
      if (targetTypeCase_ == 2) {
        if (queryBuilder_ == null) {
          result.targetType_ = targetType_;
        } else {
          result.targetType_ = queryBuilder_.build();
        }
      }
      if (targetTypeCase_ == 3) {
        if (documentsBuilder_ == null) {
          result.targetType_ = targetType_;
        } else {
          result.targetType_ = documentsBuilder_.build();
        }
      }
      if (resumeTypeCase_ == 4) {
        result.resumeType_ = resumeType_;
      }
      if (resumeTypeCase_ == 11) {
        if (readTimeBuilder_ == null) {
          result.resumeType_ = resumeType_;
        } else {
          result.resumeType_ = readTimeBuilder_.build();
        }
      }
      result.targetId_ = targetId_;
      result.once_ = once_;
      result.targetTypeCase_ = targetTypeCase_;
      result.resumeTypeCase_ = resumeTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.Target) {
        return mergeFrom((com.google.firestore.v1.Target) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.Target other) {
      if (other == com.google.firestore.v1.Target.getDefaultInstance()) return this;
      if (other.getTargetId() != 0) {
        setTargetId(other.getTargetId());
      }
      if (other.getOnce() != false) {
        setOnce(other.getOnce());
      }
      switch (other.getTargetTypeCase()) {
        case QUERY:
          {
            mergeQuery(other.getQuery());
            break;
          }
        case DOCUMENTS:
          {
            mergeDocuments(other.getDocuments());
            break;
          }
        case TARGETTYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getResumeTypeCase()) {
        case RESUME_TOKEN:
          {
            setResumeToken(other.getResumeToken());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case RESUMETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.firestore.v1.Target parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.firestore.v1.Target) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int targetTypeCase_ = 0;
    private java.lang.Object targetType_;

    public TargetTypeCase getTargetTypeCase() {
      return TargetTypeCase.forNumber(targetTypeCase_);
    }

    public Builder clearTargetType() {
      targetTypeCase_ = 0;
      targetType_ = null;
      onChanged();
      return this;
    }

    private int resumeTypeCase_ = 0;
    private java.lang.Object resumeType_;

    public ResumeTypeCase getResumeTypeCase() {
      return ResumeTypeCase.forNumber(resumeTypeCase_);
    }

    public Builder clearResumeType() {
      resumeTypeCase_ = 0;
      resumeType_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target.QueryTarget,
            com.google.firestore.v1.Target.QueryTarget.Builder,
            com.google.firestore.v1.Target.QueryTargetOrBuilder>
        queryBuilder_;
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     *
     * @return Whether the query field is set.
     */
    @java.lang.Override
    public boolean hasQuery() {
      return targetTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public com.google.firestore.v1.Target.QueryTarget getQuery() {
      if (queryBuilder_ == null) {
        if (targetTypeCase_ == 2) {
          return (com.google.firestore.v1.Target.QueryTarget) targetType_;
        }
        return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
      } else {
        if (targetTypeCase_ == 2) {
          return queryBuilder_.getMessage();
        }
        return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    public Builder setQuery(com.google.firestore.v1.Target.QueryTarget value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetType_ = value;
        onChanged();
      } else {
        queryBuilder_.setMessage(value);
      }
      targetTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    public Builder setQuery(com.google.firestore.v1.Target.QueryTarget.Builder builderForValue) {
      if (queryBuilder_ == null) {
        targetType_ = builderForValue.build();
        onChanged();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      targetTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    public Builder mergeQuery(com.google.firestore.v1.Target.QueryTarget value) {
      if (queryBuilder_ == null) {
        if (targetTypeCase_ == 2
            && targetType_ != com.google.firestore.v1.Target.QueryTarget.getDefaultInstance()) {
          targetType_ =
              com.google.firestore.v1.Target.QueryTarget.newBuilder(
                      (com.google.firestore.v1.Target.QueryTarget) targetType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetType_ = value;
        }
        onChanged();
      } else {
        if (targetTypeCase_ == 2) {
          queryBuilder_.mergeFrom(value);
        }
        queryBuilder_.setMessage(value);
      }
      targetTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    public Builder clearQuery() {
      if (queryBuilder_ == null) {
        if (targetTypeCase_ == 2) {
          targetTypeCase_ = 0;
          targetType_ = null;
          onChanged();
        }
      } else {
        if (targetTypeCase_ == 2) {
          targetTypeCase_ = 0;
          targetType_ = null;
        }
        queryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    public com.google.firestore.v1.Target.QueryTarget.Builder getQueryBuilder() {
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Target.QueryTargetOrBuilder getQueryOrBuilder() {
      if ((targetTypeCase_ == 2) && (queryBuilder_ != null)) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        if (targetTypeCase_ == 2) {
          return (com.google.firestore.v1.Target.QueryTarget) targetType_;
        }
        return com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target specified by a query.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.QueryTarget query = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target.QueryTarget,
            com.google.firestore.v1.Target.QueryTarget.Builder,
            com.google.firestore.v1.Target.QueryTargetOrBuilder>
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        if (!(targetTypeCase_ == 2)) {
          targetType_ = com.google.firestore.v1.Target.QueryTarget.getDefaultInstance();
        }
        queryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Target.QueryTarget,
                com.google.firestore.v1.Target.QueryTarget.Builder,
                com.google.firestore.v1.Target.QueryTargetOrBuilder>(
                (com.google.firestore.v1.Target.QueryTarget) targetType_,
                getParentForChildren(),
                isClean());
        targetType_ = null;
      }
      targetTypeCase_ = 2;
      onChanged();
      ;
      return queryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target.DocumentsTarget,
            com.google.firestore.v1.Target.DocumentsTarget.Builder,
            com.google.firestore.v1.Target.DocumentsTargetOrBuilder>
        documentsBuilder_;
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     *
     * @return Whether the documents field is set.
     */
    @java.lang.Override
    public boolean hasDocuments() {
      return targetTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     *
     * @return The documents.
     */
    @java.lang.Override
    public com.google.firestore.v1.Target.DocumentsTarget getDocuments() {
      if (documentsBuilder_ == null) {
        if (targetTypeCase_ == 3) {
          return (com.google.firestore.v1.Target.DocumentsTarget) targetType_;
        }
        return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
      } else {
        if (targetTypeCase_ == 3) {
          return documentsBuilder_.getMessage();
        }
        return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    public Builder setDocuments(com.google.firestore.v1.Target.DocumentsTarget value) {
      if (documentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetType_ = value;
        onChanged();
      } else {
        documentsBuilder_.setMessage(value);
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    public Builder setDocuments(
        com.google.firestore.v1.Target.DocumentsTarget.Builder builderForValue) {
      if (documentsBuilder_ == null) {
        targetType_ = builderForValue.build();
        onChanged();
      } else {
        documentsBuilder_.setMessage(builderForValue.build());
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    public Builder mergeDocuments(com.google.firestore.v1.Target.DocumentsTarget value) {
      if (documentsBuilder_ == null) {
        if (targetTypeCase_ == 3
            && targetType_ != com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance()) {
          targetType_ =
              com.google.firestore.v1.Target.DocumentsTarget.newBuilder(
                      (com.google.firestore.v1.Target.DocumentsTarget) targetType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetType_ = value;
        }
        onChanged();
      } else {
        if (targetTypeCase_ == 3) {
          documentsBuilder_.mergeFrom(value);
        }
        documentsBuilder_.setMessage(value);
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    public Builder clearDocuments() {
      if (documentsBuilder_ == null) {
        if (targetTypeCase_ == 3) {
          targetTypeCase_ = 0;
          targetType_ = null;
          onChanged();
        }
      } else {
        if (targetTypeCase_ == 3) {
          targetTypeCase_ = 0;
          targetType_ = null;
        }
        documentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    public com.google.firestore.v1.Target.DocumentsTarget.Builder getDocumentsBuilder() {
      return getDocumentsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.Target.DocumentsTargetOrBuilder getDocumentsOrBuilder() {
      if ((targetTypeCase_ == 3) && (documentsBuilder_ != null)) {
        return documentsBuilder_.getMessageOrBuilder();
      } else {
        if (targetTypeCase_ == 3) {
          return (com.google.firestore.v1.Target.DocumentsTarget) targetType_;
        }
        return com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A target specified by a set of document names.
     * </pre>
     *
     * <code>.google.firestore.v1.Target.DocumentsTarget documents = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Target.DocumentsTarget,
            com.google.firestore.v1.Target.DocumentsTarget.Builder,
            com.google.firestore.v1.Target.DocumentsTargetOrBuilder>
        getDocumentsFieldBuilder() {
      if (documentsBuilder_ == null) {
        if (!(targetTypeCase_ == 3)) {
          targetType_ = com.google.firestore.v1.Target.DocumentsTarget.getDefaultInstance();
        }
        documentsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Target.DocumentsTarget,
                com.google.firestore.v1.Target.DocumentsTarget.Builder,
                com.google.firestore.v1.Target.DocumentsTargetOrBuilder>(
                (com.google.firestore.v1.Target.DocumentsTarget) targetType_,
                getParentForChildren(),
                isClean());
        targetType_ = null;
      }
      targetTypeCase_ = 3;
      onChanged();
      ;
      return documentsBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
     * Using a resume token with a different target is unsupported and may fail.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return Whether the resumeToken field is set.
     */
    public boolean hasResumeToken() {
      return resumeTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
     * Using a resume token with a different target is unsupported and may fail.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return The resumeToken.
     */
    public com.google.protobuf.ByteString getResumeToken() {
      if (resumeTypeCase_ == 4) {
        return (com.google.protobuf.ByteString) resumeType_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
     * Using a resume token with a different target is unsupported and may fail.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @param value The resumeToken to set.
     * @return This builder for chaining.
     */
    public Builder setResumeToken(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      resumeTypeCase_ = 4;
      resumeType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A resume token from a prior [TargetChange][google.firestore.v1.TargetChange] for an identical target.
     * Using a resume token with a different target is unsupported and may fail.
     * </pre>
     *
     * <code>bytes resume_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResumeToken() {
      if (resumeTypeCase_ == 4) {
        resumeTypeCase_ = 0;
        resumeType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return resumeTypeCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (resumeTypeCase_ == 11) {
          return (com.google.protobuf.Timestamp) resumeType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (resumeTypeCase_ == 11) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resumeType_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      resumeTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        resumeType_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      resumeTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (resumeTypeCase_ == 11
            && resumeType_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          resumeType_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) resumeType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resumeType_ = value;
        }
        onChanged();
      } else {
        if (resumeTypeCase_ == 11) {
          readTimeBuilder_.mergeFrom(value);
        }
        readTimeBuilder_.setMessage(value);
      }
      resumeTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (resumeTypeCase_ == 11) {
          resumeTypeCase_ = 0;
          resumeType_ = null;
          onChanged();
        }
      } else {
        if (resumeTypeCase_ == 11) {
          resumeTypeCase_ = 0;
          resumeType_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((resumeTypeCase_ == 11) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (resumeTypeCase_ == 11) {
          return (com.google.protobuf.Timestamp) resumeType_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Start listening after a specific `read_time`.
     * The client must know the state of matching documents at this time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(resumeTypeCase_ == 11)) {
          resumeType_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) resumeType_, getParentForChildren(), isClean());
        resumeType_ = null;
      }
      resumeTypeCase_ = 11;
      onChanged();
      ;
      return readTimeBuilder_;
    }

    private int targetId_;
    /**
     *
     *
     * <pre>
     * The target ID that identifies the target on the stream. Must be a positive
     * number and non-zero.
     * </pre>
     *
     * <code>int32 target_id = 5;</code>
     *
     * @return The targetId.
     */
    @java.lang.Override
    public int getTargetId() {
      return targetId_;
    }
    /**
     *
     *
     * <pre>
     * The target ID that identifies the target on the stream. Must be a positive
     * number and non-zero.
     * </pre>
     *
     * <code>int32 target_id = 5;</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(int value) {

      targetId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target ID that identifies the target on the stream. Must be a positive
     * number and non-zero.
     * </pre>
     *
     * <code>int32 target_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {

      targetId_ = 0;
      onChanged();
      return this;
    }

    private boolean once_;
    /**
     *
     *
     * <pre>
     * If the target should be removed once it is current and consistent.
     * </pre>
     *
     * <code>bool once = 6;</code>
     *
     * @return The once.
     */
    @java.lang.Override
    public boolean getOnce() {
      return once_;
    }
    /**
     *
     *
     * <pre>
     * If the target should be removed once it is current and consistent.
     * </pre>
     *
     * <code>bool once = 6;</code>
     *
     * @param value The once to set.
     * @return This builder for chaining.
     */
    public Builder setOnce(boolean value) {

      once_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the target should be removed once it is current and consistent.
     * </pre>
     *
     * <code>bool once = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnce() {

      once_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.Target)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.Target)
  private static final com.google.firestore.v1.Target DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.Target();
  }

  public static com.google.firestore.v1.Target getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Target> PARSER =
      new com.google.protobuf.AbstractParser<Target>() {
        @java.lang.Override
        public Target parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Target(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Target> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Target> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.Target getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
