/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/common.proto

// Protobuf Java Version: 3.25.2
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * Options for creating a new transaction.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.TransactionOptions}
 */
public final class TransactionOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.TransactionOptions)
    TransactionOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransactionOptions.newBuilder() to construct.
  private TransactionOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransactionOptions() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransactionOptions();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.CommonProto
        .internal_static_google_firestore_v1_TransactionOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.CommonProto
        .internal_static_google_firestore_v1_TransactionOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.TransactionOptions.class,
            com.google.firestore.v1.TransactionOptions.Builder.class);
  }

  public interface ReadWriteOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.TransactionOptions.ReadWrite)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An optional transaction to retry.
     * </pre>
     *
     * <code>bytes retry_transaction = 1;</code>
     *
     * @return The retryTransaction.
     */
    com.google.protobuf.ByteString getRetryTransaction();
  }
  /**
   *
   *
   * <pre>
   * Options for a transaction that can be used to read and write documents.
   *
   * Firestore does not allow 3rd party auth requests to create read-write.
   * transactions.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.TransactionOptions.ReadWrite}
   */
  public static final class ReadWrite extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.TransactionOptions.ReadWrite)
      ReadWriteOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReadWrite.newBuilder() to construct.
    private ReadWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadWrite() {
      retryTransaction_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadWrite();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_ReadWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_ReadWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.TransactionOptions.ReadWrite.class,
              com.google.firestore.v1.TransactionOptions.ReadWrite.Builder.class);
    }

    public static final int RETRY_TRANSACTION_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString retryTransaction_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * An optional transaction to retry.
     * </pre>
     *
     * <code>bytes retry_transaction = 1;</code>
     *
     * @return The retryTransaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRetryTransaction() {
      return retryTransaction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!retryTransaction_.isEmpty()) {
        output.writeBytes(1, retryTransaction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!retryTransaction_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, retryTransaction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.TransactionOptions.ReadWrite)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.TransactionOptions.ReadWrite other =
          (com.google.firestore.v1.TransactionOptions.ReadWrite) obj;

      if (!getRetryTransaction().equals(other.getRetryTransaction())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RETRY_TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getRetryTransaction().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1.TransactionOptions.ReadWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options for a transaction that can be used to read and write documents.
     *
     * Firestore does not allow 3rd party auth requests to create read-write.
     * transactions.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.TransactionOptions.ReadWrite}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.TransactionOptions.ReadWrite)
        com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.TransactionOptions.ReadWrite.class,
                com.google.firestore.v1.TransactionOptions.ReadWrite.Builder.class);
      }

      // Construct using com.google.firestore.v1.TransactionOptions.ReadWrite.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        retryTransaction_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadWrite_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
        return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadWrite build() {
        com.google.firestore.v1.TransactionOptions.ReadWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadWrite buildPartial() {
        com.google.firestore.v1.TransactionOptions.ReadWrite result =
            new com.google.firestore.v1.TransactionOptions.ReadWrite(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.v1.TransactionOptions.ReadWrite result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.retryTransaction_ = retryTransaction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.TransactionOptions.ReadWrite) {
          return mergeFrom((com.google.firestore.v1.TransactionOptions.ReadWrite) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1.TransactionOptions.ReadWrite other) {
        if (other == com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance())
          return this;
        if (other.getRetryTransaction() != com.google.protobuf.ByteString.EMPTY) {
          setRetryTransaction(other.getRetryTransaction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  retryTransaction_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString retryTransaction_ =
          com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * An optional transaction to retry.
       * </pre>
       *
       * <code>bytes retry_transaction = 1;</code>
       *
       * @return The retryTransaction.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRetryTransaction() {
        return retryTransaction_;
      }
      /**
       *
       *
       * <pre>
       * An optional transaction to retry.
       * </pre>
       *
       * <code>bytes retry_transaction = 1;</code>
       *
       * @param value The retryTransaction to set.
       * @return This builder for chaining.
       */
      public Builder setRetryTransaction(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryTransaction_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An optional transaction to retry.
       * </pre>
       *
       * <code>bytes retry_transaction = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRetryTransaction() {
        bitField0_ = (bitField0_ & ~0x00000001);
        retryTransaction_ = getDefaultInstance().getRetryTransaction();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.TransactionOptions.ReadWrite)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.TransactionOptions.ReadWrite)
    private static final com.google.firestore.v1.TransactionOptions.ReadWrite DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.TransactionOptions.ReadWrite();
    }

    public static com.google.firestore.v1.TransactionOptions.ReadWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadWrite> PARSER =
        new com.google.protobuf.AbstractParser<ReadWrite>() {
          @java.lang.Override
          public ReadWrite parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReadOnlyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.TransactionOptions.ReadOnly)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return Whether the readTime field is set.
     */
    boolean hasReadTime();
    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return The readTime.
     */
    com.google.protobuf.Timestamp getReadTime();
    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder();

    com.google.firestore.v1.TransactionOptions.ReadOnly.ConsistencySelectorCase
        getConsistencySelectorCase();
  }
  /**
   *
   *
   * <pre>
   * Options for a transaction that can only be used to read documents.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.TransactionOptions.ReadOnly}
   */
  public static final class ReadOnly extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.TransactionOptions.ReadOnly)
      ReadOnlyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReadOnly.newBuilder() to construct.
    private ReadOnly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReadOnly() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReadOnly();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_ReadOnly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_ReadOnly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.TransactionOptions.ReadOnly.class,
              com.google.firestore.v1.TransactionOptions.ReadOnly.Builder.class);
    }

    private int consistencySelectorCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object consistencySelector_;

    public enum ConsistencySelectorCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      READ_TIME(2),
      CONSISTENCYSELECTOR_NOT_SET(0);
      private final int value;

      private ConsistencySelectorCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ConsistencySelectorCase valueOf(int value) {
        return forNumber(value);
      }

      public static ConsistencySelectorCase forNumber(int value) {
        switch (value) {
          case 2:
            return READ_TIME;
          case 0:
            return CONSISTENCYSELECTOR_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public static final int READ_TIME_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (consistencySelectorCase_ == 2) {
        return (com.google.protobuf.Timestamp) consistencySelector_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Reads documents at the given time.
     *
     * This must be a microsecond precision timestamp within the past one
     * hour, or if Point-in-Time Recovery is enabled, can additionally be a
     * whole minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (consistencySelectorCase_ == 2) {
        return (com.google.protobuf.Timestamp) consistencySelector_;
      }
      return com.google.protobuf.Timestamp.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (consistencySelectorCase_ == 2) {
        output.writeMessage(2, (com.google.protobuf.Timestamp) consistencySelector_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (consistencySelectorCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.protobuf.Timestamp) consistencySelector_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.TransactionOptions.ReadOnly)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.TransactionOptions.ReadOnly other =
          (com.google.firestore.v1.TransactionOptions.ReadOnly) obj;

      if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
      switch (consistencySelectorCase_) {
        case 2:
          if (!getReadTime().equals(other.getReadTime())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (consistencySelectorCase_) {
        case 2:
          hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getReadTime().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1.TransactionOptions.ReadOnly prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options for a transaction that can only be used to read documents.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.TransactionOptions.ReadOnly}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.TransactionOptions.ReadOnly)
        com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadOnly_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.TransactionOptions.ReadOnly.class,
                com.google.firestore.v1.TransactionOptions.ReadOnly.Builder.class);
      }

      // Construct using com.google.firestore.v1.TransactionOptions.ReadOnly.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (readTimeBuilder_ != null) {
          readTimeBuilder_.clear();
        }
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.CommonProto
            .internal_static_google_firestore_v1_TransactionOptions_ReadOnly_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
        return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadOnly build() {
        com.google.firestore.v1.TransactionOptions.ReadOnly result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.TransactionOptions.ReadOnly buildPartial() {
        com.google.firestore.v1.TransactionOptions.ReadOnly result =
            new com.google.firestore.v1.TransactionOptions.ReadOnly(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.firestore.v1.TransactionOptions.ReadOnly result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.firestore.v1.TransactionOptions.ReadOnly result) {
        result.consistencySelectorCase_ = consistencySelectorCase_;
        result.consistencySelector_ = this.consistencySelector_;
        if (consistencySelectorCase_ == 2 && readTimeBuilder_ != null) {
          result.consistencySelector_ = readTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.TransactionOptions.ReadOnly) {
          return mergeFrom((com.google.firestore.v1.TransactionOptions.ReadOnly) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.firestore.v1.TransactionOptions.ReadOnly other) {
        if (other == com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance())
          return this;
        switch (other.getConsistencySelectorCase()) {
          case READ_TIME:
            {
              mergeReadTime(other.getReadTime());
              break;
            }
          case CONSISTENCYSELECTOR_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                  consistencySelectorCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int consistencySelectorCase_ = 0;
      private java.lang.Object consistencySelector_;

      public ConsistencySelectorCase getConsistencySelectorCase() {
        return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
      }

      public Builder clearConsistencySelector() {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          readTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       *
       * @return Whether the readTime field is set.
       */
      @java.lang.Override
      public boolean hasReadTime() {
        return consistencySelectorCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       *
       * @return The readTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getReadTime() {
        if (readTimeBuilder_ == null) {
          if (consistencySelectorCase_ == 2) {
            return (com.google.protobuf.Timestamp) consistencySelector_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        } else {
          if (consistencySelectorCase_ == 2) {
            return readTimeBuilder_.getMessage();
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      public Builder setReadTime(com.google.protobuf.Timestamp value) {
        if (readTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          consistencySelector_ = value;
          onChanged();
        } else {
          readTimeBuilder_.setMessage(value);
        }
        consistencySelectorCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (readTimeBuilder_ == null) {
          consistencySelector_ = builderForValue.build();
          onChanged();
        } else {
          readTimeBuilder_.setMessage(builderForValue.build());
        }
        consistencySelectorCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
        if (readTimeBuilder_ == null) {
          if (consistencySelectorCase_ == 2
              && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            consistencySelector_ =
                com.google.protobuf.Timestamp.newBuilder(
                        (com.google.protobuf.Timestamp) consistencySelector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            consistencySelector_ = value;
          }
          onChanged();
        } else {
          if (consistencySelectorCase_ == 2) {
            readTimeBuilder_.mergeFrom(value);
          } else {
            readTimeBuilder_.setMessage(value);
          }
        }
        consistencySelectorCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      public Builder clearReadTime() {
        if (readTimeBuilder_ == null) {
          if (consistencySelectorCase_ == 2) {
            consistencySelectorCase_ = 0;
            consistencySelector_ = null;
            onChanged();
          }
        } else {
          if (consistencySelectorCase_ == 2) {
            consistencySelectorCase_ = 0;
            consistencySelector_ = null;
          }
          readTimeBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
        return getReadTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
        if ((consistencySelectorCase_ == 2) && (readTimeBuilder_ != null)) {
          return readTimeBuilder_.getMessageOrBuilder();
        } else {
          if (consistencySelectorCase_ == 2) {
            return (com.google.protobuf.Timestamp) consistencySelector_;
          }
          return com.google.protobuf.Timestamp.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Reads documents at the given time.
       *
       * This must be a microsecond precision timestamp within the past one
       * hour, or if Point-in-Time Recovery is enabled, can additionally be a
       * whole minute timestamp within the past 7 days.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp read_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getReadTimeFieldBuilder() {
        if (readTimeBuilder_ == null) {
          if (!(consistencySelectorCase_ == 2)) {
            consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
          }
          readTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  (com.google.protobuf.Timestamp) consistencySelector_,
                  getParentForChildren(),
                  isClean());
          consistencySelector_ = null;
        }
        consistencySelectorCase_ = 2;
        onChanged();
        return readTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.TransactionOptions.ReadOnly)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.TransactionOptions.ReadOnly)
    private static final com.google.firestore.v1.TransactionOptions.ReadOnly DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.TransactionOptions.ReadOnly();
    }

    public static com.google.firestore.v1.TransactionOptions.ReadOnly getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReadOnly> PARSER =
        new com.google.protobuf.AbstractParser<ReadOnly>() {
          @java.lang.Override
          public ReadOnly parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReadOnly> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReadOnly> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadOnly getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_ONLY(2),
    READ_WRITE(3),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 2:
          return READ_ONLY;
        case 3:
          return READ_WRITE;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int READ_ONLY_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The transaction can only be used for read operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return Whether the readOnly field is set.
   */
  @java.lang.Override
  public boolean hasReadOnly() {
    return modeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The transaction can only be used for read operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   *
   * @return The readOnly.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions.ReadOnly getReadOnly() {
    if (modeCase_ == 2) {
      return (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The transaction can only be used for read operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_;
    }
    return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
  }

  public static final int READ_WRITE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The transaction can be used for both read and write operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
   *
   * @return Whether the readWrite field is set.
   */
  @java.lang.Override
  public boolean hasReadWrite() {
    return modeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The transaction can be used for both read and write operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
   *
   * @return The readWrite.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions.ReadWrite getReadWrite() {
    if (modeCase_ == 3) {
      return (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The transaction can be used for both read and write operations.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
    if (modeCase_ == 3) {
      return (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_;
    }
    return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      output.writeMessage(3, (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_);
    }
    if (modeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.TransactionOptions)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.TransactionOptions other =
        (com.google.firestore.v1.TransactionOptions) obj;

    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 2:
        if (!getReadOnly().equals(other.getReadOnly())) return false;
        break;
      case 3:
        if (!getReadWrite().equals(other.getReadWrite())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (modeCase_) {
      case 2:
        hash = (37 * hash) + READ_ONLY_FIELD_NUMBER;
        hash = (53 * hash) + getReadOnly().hashCode();
        break;
      case 3:
        hash = (37 * hash) + READ_WRITE_FIELD_NUMBER;
        hash = (53 * hash) + getReadWrite().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TransactionOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.TransactionOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.TransactionOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options for creating a new transaction.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.TransactionOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.TransactionOptions)
      com.google.firestore.v1.TransactionOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.TransactionOptions.class,
              com.google.firestore.v1.TransactionOptions.Builder.class);
    }

    // Construct using com.google.firestore.v1.TransactionOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (readOnlyBuilder_ != null) {
        readOnlyBuilder_.clear();
      }
      if (readWriteBuilder_ != null) {
        readWriteBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.CommonProto
          .internal_static_google_firestore_v1_TransactionOptions_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions getDefaultInstanceForType() {
      return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions build() {
      com.google.firestore.v1.TransactionOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions buildPartial() {
      com.google.firestore.v1.TransactionOptions result =
          new com.google.firestore.v1.TransactionOptions(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.TransactionOptions result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.TransactionOptions result) {
      result.modeCase_ = modeCase_;
      result.mode_ = this.mode_;
      if (modeCase_ == 2 && readOnlyBuilder_ != null) {
        result.mode_ = readOnlyBuilder_.build();
      }
      if (modeCase_ == 3 && readWriteBuilder_ != null) {
        result.mode_ = readWriteBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.TransactionOptions) {
        return mergeFrom((com.google.firestore.v1.TransactionOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.TransactionOptions other) {
      if (other == com.google.firestore.v1.TransactionOptions.getDefaultInstance()) return this;
      switch (other.getModeCase()) {
        case READ_ONLY:
          {
            mergeReadOnly(other.getReadOnly());
            break;
          }
        case READ_WRITE:
          {
            mergeReadWrite(other.getReadWrite());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getReadOnlyFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getReadWriteFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions.ReadOnly,
            com.google.firestore.v1.TransactionOptions.ReadOnly.Builder,
            com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder>
        readOnlyBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return Whether the readOnly field is set.
     */
    @java.lang.Override
    public boolean hasReadOnly() {
      return modeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     *
     * @return The readOnly.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadOnly getReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return readOnlyBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(com.google.firestore.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder setReadOnly(
        com.google.firestore.v1.TransactionOptions.ReadOnly.Builder builderForValue) {
      if (readOnlyBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readOnlyBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder mergeReadOnly(com.google.firestore.v1.TransactionOptions.ReadOnly value) {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2
            && mode_ != com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance()) {
          mode_ =
              com.google.firestore.v1.TransactionOptions.ReadOnly.newBuilder(
                      (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          readOnlyBuilder_.mergeFrom(value);
        } else {
          readOnlyBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public Builder clearReadOnly() {
      if (readOnlyBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        readOnlyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    public com.google.firestore.v1.TransactionOptions.ReadOnly.Builder getReadOnlyBuilder() {
      return getReadOnlyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder getReadOnlyOrBuilder() {
      if ((modeCase_ == 2) && (readOnlyBuilder_ != null)) {
        return readOnlyBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_;
        }
        return com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction can only be used for read operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadOnly read_only = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions.ReadOnly,
            com.google.firestore.v1.TransactionOptions.ReadOnly.Builder,
            com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder>
        getReadOnlyFieldBuilder() {
      if (readOnlyBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ = com.google.firestore.v1.TransactionOptions.ReadOnly.getDefaultInstance();
        }
        readOnlyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TransactionOptions.ReadOnly,
                com.google.firestore.v1.TransactionOptions.ReadOnly.Builder,
                com.google.firestore.v1.TransactionOptions.ReadOnlyOrBuilder>(
                (com.google.firestore.v1.TransactionOptions.ReadOnly) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      return readOnlyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions.ReadWrite,
            com.google.firestore.v1.TransactionOptions.ReadWrite.Builder,
            com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder>
        readWriteBuilder_;
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     *
     * @return Whether the readWrite field is set.
     */
    @java.lang.Override
    public boolean hasReadWrite() {
      return modeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     *
     * @return The readWrite.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadWrite getReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 3) {
          return (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      } else {
        if (modeCase_ == 3) {
          return readWriteBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    public Builder setReadWrite(com.google.firestore.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        readWriteBuilder_.setMessage(value);
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    public Builder setReadWrite(
        com.google.firestore.v1.TransactionOptions.ReadWrite.Builder builderForValue) {
      if (readWriteBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        readWriteBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    public Builder mergeReadWrite(com.google.firestore.v1.TransactionOptions.ReadWrite value) {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 3
            && mode_ != com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance()) {
          mode_ =
              com.google.firestore.v1.TransactionOptions.ReadWrite.newBuilder(
                      (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 3) {
          readWriteBuilder_.mergeFrom(value);
        } else {
          readWriteBuilder_.setMessage(value);
        }
      }
      modeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    public Builder clearReadWrite() {
      if (readWriteBuilder_ == null) {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 3) {
          modeCase_ = 0;
          mode_ = null;
        }
        readWriteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    public com.google.firestore.v1.TransactionOptions.ReadWrite.Builder getReadWriteBuilder() {
      return getReadWriteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder getReadWriteOrBuilder() {
      if ((modeCase_ == 3) && (readWriteBuilder_ != null)) {
        return readWriteBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 3) {
          return (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_;
        }
        return com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The transaction can be used for both read and write operations.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions.ReadWrite read_write = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions.ReadWrite,
            com.google.firestore.v1.TransactionOptions.ReadWrite.Builder,
            com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder>
        getReadWriteFieldBuilder() {
      if (readWriteBuilder_ == null) {
        if (!(modeCase_ == 3)) {
          mode_ = com.google.firestore.v1.TransactionOptions.ReadWrite.getDefaultInstance();
        }
        readWriteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TransactionOptions.ReadWrite,
                com.google.firestore.v1.TransactionOptions.ReadWrite.Builder,
                com.google.firestore.v1.TransactionOptions.ReadWriteOrBuilder>(
                (com.google.firestore.v1.TransactionOptions.ReadWrite) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 3;
      onChanged();
      return readWriteBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.TransactionOptions)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.TransactionOptions)
  private static final com.google.firestore.v1.TransactionOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.TransactionOptions();
  }

  public static com.google.firestore.v1.TransactionOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransactionOptions> PARSER =
      new com.google.protobuf.AbstractParser<TransactionOptions>() {
        @java.lang.Override
        public TransactionOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransactionOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransactionOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
