/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.2
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The response for [Firestore.Listen][google.firestore.v1.Firestore.Listen].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.ListenResponse}
 */
public final class ListenResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.ListenResponse)
    ListenResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListenResponse.newBuilder() to construct.
  private ListenResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListenResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListenResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListenResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_ListenResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.ListenResponse.class,
            com.google.firestore.v1.ListenResponse.Builder.class);
  }

  private int responseTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object responseType_;

  public enum ResponseTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TARGET_CHANGE(2),
    DOCUMENT_CHANGE(3),
    DOCUMENT_DELETE(4),
    DOCUMENT_REMOVE(6),
    FILTER(5),
    RESPONSETYPE_NOT_SET(0);
    private final int value;

    private ResponseTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResponseTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return TARGET_CHANGE;
        case 3:
          return DOCUMENT_CHANGE;
        case 4:
          return DOCUMENT_DELETE;
        case 6:
          return DOCUMENT_REMOVE;
        case 5:
          return FILTER;
        case 0:
          return RESPONSETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResponseTypeCase getResponseTypeCase() {
    return ResponseTypeCase.forNumber(responseTypeCase_);
  }

  public static final int TARGET_CHANGE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Targets have changed.
   * </pre>
   *
   * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
   *
   * @return Whether the targetChange field is set.
   */
  @java.lang.Override
  public boolean hasTargetChange() {
    return responseTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Targets have changed.
   * </pre>
   *
   * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
   *
   * @return The targetChange.
   */
  @java.lang.Override
  public com.google.firestore.v1.TargetChange getTargetChange() {
    if (responseTypeCase_ == 2) {
      return (com.google.firestore.v1.TargetChange) responseType_;
    }
    return com.google.firestore.v1.TargetChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Targets have changed.
   * </pre>
   *
   * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TargetChangeOrBuilder getTargetChangeOrBuilder() {
    if (responseTypeCase_ == 2) {
      return (com.google.firestore.v1.TargetChange) responseType_;
    }
    return com.google.firestore.v1.TargetChange.getDefaultInstance();
  }

  public static final int DOCUMENT_CHANGE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has changed.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
   *
   * @return Whether the documentChange field is set.
   */
  @java.lang.Override
  public boolean hasDocumentChange() {
    return responseTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has changed.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
   *
   * @return The documentChange.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentChange getDocumentChange() {
    if (responseTypeCase_ == 3) {
      return (com.google.firestore.v1.DocumentChange) responseType_;
    }
    return com.google.firestore.v1.DocumentChange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has changed.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentChangeOrBuilder getDocumentChangeOrBuilder() {
    if (responseTypeCase_ == 3) {
      return (com.google.firestore.v1.DocumentChange) responseType_;
    }
    return com.google.firestore.v1.DocumentChange.getDefaultInstance();
  }

  public static final int DOCUMENT_DELETE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been deleted.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
   *
   * @return Whether the documentDelete field is set.
   */
  @java.lang.Override
  public boolean hasDocumentDelete() {
    return responseTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been deleted.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
   *
   * @return The documentDelete.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentDelete getDocumentDelete() {
    if (responseTypeCase_ == 4) {
      return (com.google.firestore.v1.DocumentDelete) responseType_;
    }
    return com.google.firestore.v1.DocumentDelete.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been deleted.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentDeleteOrBuilder getDocumentDeleteOrBuilder() {
    if (responseTypeCase_ == 4) {
      return (com.google.firestore.v1.DocumentDelete) responseType_;
    }
    return com.google.firestore.v1.DocumentDelete.getDefaultInstance();
  }

  public static final int DOCUMENT_REMOVE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been removed from a target
   * (because it is no longer relevant to that target).
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
   *
   * @return Whether the documentRemove field is set.
   */
  @java.lang.Override
  public boolean hasDocumentRemove() {
    return responseTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been removed from a target
   * (because it is no longer relevant to that target).
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
   *
   * @return The documentRemove.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentRemove getDocumentRemove() {
    if (responseTypeCase_ == 6) {
      return (com.google.firestore.v1.DocumentRemove) responseType_;
    }
    return com.google.firestore.v1.DocumentRemove.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A [Document][google.firestore.v1.Document] has been removed from a target
   * (because it is no longer relevant to that target).
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentRemoveOrBuilder getDocumentRemoveOrBuilder() {
    if (responseTypeCase_ == 6) {
      return (com.google.firestore.v1.DocumentRemove) responseType_;
    }
    return com.google.firestore.v1.DocumentRemove.getDefaultInstance();
  }

  public static final int FILTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A filter to apply to the set of documents previously returned for the
   * given target.
   *
   * Returned when documents may have been removed from the given target, but
   * the exact documents are unknown.
   * </pre>
   *
   * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return responseTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A filter to apply to the set of documents previously returned for the
   * given target.
   *
   * Returned when documents may have been removed from the given target, but
   * the exact documents are unknown.
   * </pre>
   *
   * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.firestore.v1.ExistenceFilter getFilter() {
    if (responseTypeCase_ == 5) {
      return (com.google.firestore.v1.ExistenceFilter) responseType_;
    }
    return com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A filter to apply to the set of documents previously returned for the
   * given target.
   *
   * Returned when documents may have been removed from the given target, but
   * the exact documents are unknown.
   * </pre>
   *
   * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.ExistenceFilterOrBuilder getFilterOrBuilder() {
    if (responseTypeCase_ == 5) {
      return (com.google.firestore.v1.ExistenceFilter) responseType_;
    }
    return com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (responseTypeCase_ == 2) {
      output.writeMessage(2, (com.google.firestore.v1.TargetChange) responseType_);
    }
    if (responseTypeCase_ == 3) {
      output.writeMessage(3, (com.google.firestore.v1.DocumentChange) responseType_);
    }
    if (responseTypeCase_ == 4) {
      output.writeMessage(4, (com.google.firestore.v1.DocumentDelete) responseType_);
    }
    if (responseTypeCase_ == 5) {
      output.writeMessage(5, (com.google.firestore.v1.ExistenceFilter) responseType_);
    }
    if (responseTypeCase_ == 6) {
      output.writeMessage(6, (com.google.firestore.v1.DocumentRemove) responseType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (responseTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.firestore.v1.TargetChange) responseType_);
    }
    if (responseTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.firestore.v1.DocumentChange) responseType_);
    }
    if (responseTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.firestore.v1.DocumentDelete) responseType_);
    }
    if (responseTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.firestore.v1.ExistenceFilter) responseType_);
    }
    if (responseTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.firestore.v1.DocumentRemove) responseType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.ListenResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.ListenResponse other = (com.google.firestore.v1.ListenResponse) obj;

    if (!getResponseTypeCase().equals(other.getResponseTypeCase())) return false;
    switch (responseTypeCase_) {
      case 2:
        if (!getTargetChange().equals(other.getTargetChange())) return false;
        break;
      case 3:
        if (!getDocumentChange().equals(other.getDocumentChange())) return false;
        break;
      case 4:
        if (!getDocumentDelete().equals(other.getDocumentDelete())) return false;
        break;
      case 6:
        if (!getDocumentRemove().equals(other.getDocumentRemove())) return false;
        break;
      case 5:
        if (!getFilter().equals(other.getFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (responseTypeCase_) {
      case 2:
        hash = (37 * hash) + TARGET_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getTargetChange().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DOCUMENT_CHANGE_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentChange().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DOCUMENT_DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentDelete().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DOCUMENT_REMOVE_FIELD_NUMBER;
        hash = (53 * hash) + getDocumentRemove().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.ListenResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.ListenResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for [Firestore.Listen][google.firestore.v1.Firestore.Listen].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.ListenResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.ListenResponse)
      com.google.firestore.v1.ListenResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.ListenResponse.class,
              com.google.firestore.v1.ListenResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1.ListenResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (targetChangeBuilder_ != null) {
        targetChangeBuilder_.clear();
      }
      if (documentChangeBuilder_ != null) {
        documentChangeBuilder_.clear();
      }
      if (documentDeleteBuilder_ != null) {
        documentDeleteBuilder_.clear();
      }
      if (documentRemoveBuilder_ != null) {
        documentRemoveBuilder_.clear();
      }
      if (filterBuilder_ != null) {
        filterBuilder_.clear();
      }
      responseTypeCase_ = 0;
      responseType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_ListenResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenResponse getDefaultInstanceForType() {
      return com.google.firestore.v1.ListenResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenResponse build() {
      com.google.firestore.v1.ListenResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.ListenResponse buildPartial() {
      com.google.firestore.v1.ListenResponse result =
          new com.google.firestore.v1.ListenResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.ListenResponse result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.ListenResponse result) {
      result.responseTypeCase_ = responseTypeCase_;
      result.responseType_ = this.responseType_;
      if (responseTypeCase_ == 2 && targetChangeBuilder_ != null) {
        result.responseType_ = targetChangeBuilder_.build();
      }
      if (responseTypeCase_ == 3 && documentChangeBuilder_ != null) {
        result.responseType_ = documentChangeBuilder_.build();
      }
      if (responseTypeCase_ == 4 && documentDeleteBuilder_ != null) {
        result.responseType_ = documentDeleteBuilder_.build();
      }
      if (responseTypeCase_ == 6 && documentRemoveBuilder_ != null) {
        result.responseType_ = documentRemoveBuilder_.build();
      }
      if (responseTypeCase_ == 5 && filterBuilder_ != null) {
        result.responseType_ = filterBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.ListenResponse) {
        return mergeFrom((com.google.firestore.v1.ListenResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.ListenResponse other) {
      if (other == com.google.firestore.v1.ListenResponse.getDefaultInstance()) return this;
      switch (other.getResponseTypeCase()) {
        case TARGET_CHANGE:
          {
            mergeTargetChange(other.getTargetChange());
            break;
          }
        case DOCUMENT_CHANGE:
          {
            mergeDocumentChange(other.getDocumentChange());
            break;
          }
        case DOCUMENT_DELETE:
          {
            mergeDocumentDelete(other.getDocumentDelete());
            break;
          }
        case DOCUMENT_REMOVE:
          {
            mergeDocumentRemove(other.getDocumentRemove());
            break;
          }
        case FILTER:
          {
            mergeFilter(other.getFilter());
            break;
          }
        case RESPONSETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getTargetChangeFieldBuilder().getBuilder(), extensionRegistry);
                responseTypeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDocumentChangeFieldBuilder().getBuilder(), extensionRegistry);
                responseTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDocumentDeleteFieldBuilder().getBuilder(), extensionRegistry);
                responseTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                responseTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getDocumentRemoveFieldBuilder().getBuilder(), extensionRegistry);
                responseTypeCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int responseTypeCase_ = 0;
    private java.lang.Object responseType_;

    public ResponseTypeCase getResponseTypeCase() {
      return ResponseTypeCase.forNumber(responseTypeCase_);
    }

    public Builder clearResponseType() {
      responseTypeCase_ = 0;
      responseType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TargetChange,
            com.google.firestore.v1.TargetChange.Builder,
            com.google.firestore.v1.TargetChangeOrBuilder>
        targetChangeBuilder_;
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     *
     * @return Whether the targetChange field is set.
     */
    @java.lang.Override
    public boolean hasTargetChange() {
      return responseTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     *
     * @return The targetChange.
     */
    @java.lang.Override
    public com.google.firestore.v1.TargetChange getTargetChange() {
      if (targetChangeBuilder_ == null) {
        if (responseTypeCase_ == 2) {
          return (com.google.firestore.v1.TargetChange) responseType_;
        }
        return com.google.firestore.v1.TargetChange.getDefaultInstance();
      } else {
        if (responseTypeCase_ == 2) {
          return targetChangeBuilder_.getMessage();
        }
        return com.google.firestore.v1.TargetChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    public Builder setTargetChange(com.google.firestore.v1.TargetChange value) {
      if (targetChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseType_ = value;
        onChanged();
      } else {
        targetChangeBuilder_.setMessage(value);
      }
      responseTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    public Builder setTargetChange(com.google.firestore.v1.TargetChange.Builder builderForValue) {
      if (targetChangeBuilder_ == null) {
        responseType_ = builderForValue.build();
        onChanged();
      } else {
        targetChangeBuilder_.setMessage(builderForValue.build());
      }
      responseTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    public Builder mergeTargetChange(com.google.firestore.v1.TargetChange value) {
      if (targetChangeBuilder_ == null) {
        if (responseTypeCase_ == 2
            && responseType_ != com.google.firestore.v1.TargetChange.getDefaultInstance()) {
          responseType_ =
              com.google.firestore.v1.TargetChange.newBuilder(
                      (com.google.firestore.v1.TargetChange) responseType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          responseType_ = value;
        }
        onChanged();
      } else {
        if (responseTypeCase_ == 2) {
          targetChangeBuilder_.mergeFrom(value);
        } else {
          targetChangeBuilder_.setMessage(value);
        }
      }
      responseTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    public Builder clearTargetChange() {
      if (targetChangeBuilder_ == null) {
        if (responseTypeCase_ == 2) {
          responseTypeCase_ = 0;
          responseType_ = null;
          onChanged();
        }
      } else {
        if (responseTypeCase_ == 2) {
          responseTypeCase_ = 0;
          responseType_ = null;
        }
        targetChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    public com.google.firestore.v1.TargetChange.Builder getTargetChangeBuilder() {
      return getTargetChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TargetChangeOrBuilder getTargetChangeOrBuilder() {
      if ((responseTypeCase_ == 2) && (targetChangeBuilder_ != null)) {
        return targetChangeBuilder_.getMessageOrBuilder();
      } else {
        if (responseTypeCase_ == 2) {
          return (com.google.firestore.v1.TargetChange) responseType_;
        }
        return com.google.firestore.v1.TargetChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Targets have changed.
     * </pre>
     *
     * <code>.google.firestore.v1.TargetChange target_change = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TargetChange,
            com.google.firestore.v1.TargetChange.Builder,
            com.google.firestore.v1.TargetChangeOrBuilder>
        getTargetChangeFieldBuilder() {
      if (targetChangeBuilder_ == null) {
        if (!(responseTypeCase_ == 2)) {
          responseType_ = com.google.firestore.v1.TargetChange.getDefaultInstance();
        }
        targetChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TargetChange,
                com.google.firestore.v1.TargetChange.Builder,
                com.google.firestore.v1.TargetChangeOrBuilder>(
                (com.google.firestore.v1.TargetChange) responseType_,
                getParentForChildren(),
                isClean());
        responseType_ = null;
      }
      responseTypeCase_ = 2;
      onChanged();
      return targetChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentChange,
            com.google.firestore.v1.DocumentChange.Builder,
            com.google.firestore.v1.DocumentChangeOrBuilder>
        documentChangeBuilder_;
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     *
     * @return Whether the documentChange field is set.
     */
    @java.lang.Override
    public boolean hasDocumentChange() {
      return responseTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     *
     * @return The documentChange.
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentChange getDocumentChange() {
      if (documentChangeBuilder_ == null) {
        if (responseTypeCase_ == 3) {
          return (com.google.firestore.v1.DocumentChange) responseType_;
        }
        return com.google.firestore.v1.DocumentChange.getDefaultInstance();
      } else {
        if (responseTypeCase_ == 3) {
          return documentChangeBuilder_.getMessage();
        }
        return com.google.firestore.v1.DocumentChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    public Builder setDocumentChange(com.google.firestore.v1.DocumentChange value) {
      if (documentChangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseType_ = value;
        onChanged();
      } else {
        documentChangeBuilder_.setMessage(value);
      }
      responseTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    public Builder setDocumentChange(
        com.google.firestore.v1.DocumentChange.Builder builderForValue) {
      if (documentChangeBuilder_ == null) {
        responseType_ = builderForValue.build();
        onChanged();
      } else {
        documentChangeBuilder_.setMessage(builderForValue.build());
      }
      responseTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    public Builder mergeDocumentChange(com.google.firestore.v1.DocumentChange value) {
      if (documentChangeBuilder_ == null) {
        if (responseTypeCase_ == 3
            && responseType_ != com.google.firestore.v1.DocumentChange.getDefaultInstance()) {
          responseType_ =
              com.google.firestore.v1.DocumentChange.newBuilder(
                      (com.google.firestore.v1.DocumentChange) responseType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          responseType_ = value;
        }
        onChanged();
      } else {
        if (responseTypeCase_ == 3) {
          documentChangeBuilder_.mergeFrom(value);
        } else {
          documentChangeBuilder_.setMessage(value);
        }
      }
      responseTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    public Builder clearDocumentChange() {
      if (documentChangeBuilder_ == null) {
        if (responseTypeCase_ == 3) {
          responseTypeCase_ = 0;
          responseType_ = null;
          onChanged();
        }
      } else {
        if (responseTypeCase_ == 3) {
          responseTypeCase_ = 0;
          responseType_ = null;
        }
        documentChangeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    public com.google.firestore.v1.DocumentChange.Builder getDocumentChangeBuilder() {
      return getDocumentChangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentChangeOrBuilder getDocumentChangeOrBuilder() {
      if ((responseTypeCase_ == 3) && (documentChangeBuilder_ != null)) {
        return documentChangeBuilder_.getMessageOrBuilder();
      } else {
        if (responseTypeCase_ == 3) {
          return (com.google.firestore.v1.DocumentChange) responseType_;
        }
        return com.google.firestore.v1.DocumentChange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has changed.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentChange document_change = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentChange,
            com.google.firestore.v1.DocumentChange.Builder,
            com.google.firestore.v1.DocumentChangeOrBuilder>
        getDocumentChangeFieldBuilder() {
      if (documentChangeBuilder_ == null) {
        if (!(responseTypeCase_ == 3)) {
          responseType_ = com.google.firestore.v1.DocumentChange.getDefaultInstance();
        }
        documentChangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentChange,
                com.google.firestore.v1.DocumentChange.Builder,
                com.google.firestore.v1.DocumentChangeOrBuilder>(
                (com.google.firestore.v1.DocumentChange) responseType_,
                getParentForChildren(),
                isClean());
        responseType_ = null;
      }
      responseTypeCase_ = 3;
      onChanged();
      return documentChangeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentDelete,
            com.google.firestore.v1.DocumentDelete.Builder,
            com.google.firestore.v1.DocumentDeleteOrBuilder>
        documentDeleteBuilder_;
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     *
     * @return Whether the documentDelete field is set.
     */
    @java.lang.Override
    public boolean hasDocumentDelete() {
      return responseTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     *
     * @return The documentDelete.
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentDelete getDocumentDelete() {
      if (documentDeleteBuilder_ == null) {
        if (responseTypeCase_ == 4) {
          return (com.google.firestore.v1.DocumentDelete) responseType_;
        }
        return com.google.firestore.v1.DocumentDelete.getDefaultInstance();
      } else {
        if (responseTypeCase_ == 4) {
          return documentDeleteBuilder_.getMessage();
        }
        return com.google.firestore.v1.DocumentDelete.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    public Builder setDocumentDelete(com.google.firestore.v1.DocumentDelete value) {
      if (documentDeleteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseType_ = value;
        onChanged();
      } else {
        documentDeleteBuilder_.setMessage(value);
      }
      responseTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    public Builder setDocumentDelete(
        com.google.firestore.v1.DocumentDelete.Builder builderForValue) {
      if (documentDeleteBuilder_ == null) {
        responseType_ = builderForValue.build();
        onChanged();
      } else {
        documentDeleteBuilder_.setMessage(builderForValue.build());
      }
      responseTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    public Builder mergeDocumentDelete(com.google.firestore.v1.DocumentDelete value) {
      if (documentDeleteBuilder_ == null) {
        if (responseTypeCase_ == 4
            && responseType_ != com.google.firestore.v1.DocumentDelete.getDefaultInstance()) {
          responseType_ =
              com.google.firestore.v1.DocumentDelete.newBuilder(
                      (com.google.firestore.v1.DocumentDelete) responseType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          responseType_ = value;
        }
        onChanged();
      } else {
        if (responseTypeCase_ == 4) {
          documentDeleteBuilder_.mergeFrom(value);
        } else {
          documentDeleteBuilder_.setMessage(value);
        }
      }
      responseTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    public Builder clearDocumentDelete() {
      if (documentDeleteBuilder_ == null) {
        if (responseTypeCase_ == 4) {
          responseTypeCase_ = 0;
          responseType_ = null;
          onChanged();
        }
      } else {
        if (responseTypeCase_ == 4) {
          responseTypeCase_ = 0;
          responseType_ = null;
        }
        documentDeleteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    public com.google.firestore.v1.DocumentDelete.Builder getDocumentDeleteBuilder() {
      return getDocumentDeleteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentDeleteOrBuilder getDocumentDeleteOrBuilder() {
      if ((responseTypeCase_ == 4) && (documentDeleteBuilder_ != null)) {
        return documentDeleteBuilder_.getMessageOrBuilder();
      } else {
        if (responseTypeCase_ == 4) {
          return (com.google.firestore.v1.DocumentDelete) responseType_;
        }
        return com.google.firestore.v1.DocumentDelete.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been deleted.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentDelete document_delete = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentDelete,
            com.google.firestore.v1.DocumentDelete.Builder,
            com.google.firestore.v1.DocumentDeleteOrBuilder>
        getDocumentDeleteFieldBuilder() {
      if (documentDeleteBuilder_ == null) {
        if (!(responseTypeCase_ == 4)) {
          responseType_ = com.google.firestore.v1.DocumentDelete.getDefaultInstance();
        }
        documentDeleteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentDelete,
                com.google.firestore.v1.DocumentDelete.Builder,
                com.google.firestore.v1.DocumentDeleteOrBuilder>(
                (com.google.firestore.v1.DocumentDelete) responseType_,
                getParentForChildren(),
                isClean());
        responseType_ = null;
      }
      responseTypeCase_ = 4;
      onChanged();
      return documentDeleteBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentRemove,
            com.google.firestore.v1.DocumentRemove.Builder,
            com.google.firestore.v1.DocumentRemoveOrBuilder>
        documentRemoveBuilder_;
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     *
     * @return Whether the documentRemove field is set.
     */
    @java.lang.Override
    public boolean hasDocumentRemove() {
      return responseTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     *
     * @return The documentRemove.
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentRemove getDocumentRemove() {
      if (documentRemoveBuilder_ == null) {
        if (responseTypeCase_ == 6) {
          return (com.google.firestore.v1.DocumentRemove) responseType_;
        }
        return com.google.firestore.v1.DocumentRemove.getDefaultInstance();
      } else {
        if (responseTypeCase_ == 6) {
          return documentRemoveBuilder_.getMessage();
        }
        return com.google.firestore.v1.DocumentRemove.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    public Builder setDocumentRemove(com.google.firestore.v1.DocumentRemove value) {
      if (documentRemoveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseType_ = value;
        onChanged();
      } else {
        documentRemoveBuilder_.setMessage(value);
      }
      responseTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    public Builder setDocumentRemove(
        com.google.firestore.v1.DocumentRemove.Builder builderForValue) {
      if (documentRemoveBuilder_ == null) {
        responseType_ = builderForValue.build();
        onChanged();
      } else {
        documentRemoveBuilder_.setMessage(builderForValue.build());
      }
      responseTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    public Builder mergeDocumentRemove(com.google.firestore.v1.DocumentRemove value) {
      if (documentRemoveBuilder_ == null) {
        if (responseTypeCase_ == 6
            && responseType_ != com.google.firestore.v1.DocumentRemove.getDefaultInstance()) {
          responseType_ =
              com.google.firestore.v1.DocumentRemove.newBuilder(
                      (com.google.firestore.v1.DocumentRemove) responseType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          responseType_ = value;
        }
        onChanged();
      } else {
        if (responseTypeCase_ == 6) {
          documentRemoveBuilder_.mergeFrom(value);
        } else {
          documentRemoveBuilder_.setMessage(value);
        }
      }
      responseTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    public Builder clearDocumentRemove() {
      if (documentRemoveBuilder_ == null) {
        if (responseTypeCase_ == 6) {
          responseTypeCase_ = 0;
          responseType_ = null;
          onChanged();
        }
      } else {
        if (responseTypeCase_ == 6) {
          responseTypeCase_ = 0;
          responseType_ = null;
        }
        documentRemoveBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    public com.google.firestore.v1.DocumentRemove.Builder getDocumentRemoveBuilder() {
      return getDocumentRemoveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.DocumentRemoveOrBuilder getDocumentRemoveOrBuilder() {
      if ((responseTypeCase_ == 6) && (documentRemoveBuilder_ != null)) {
        return documentRemoveBuilder_.getMessageOrBuilder();
      } else {
        if (responseTypeCase_ == 6) {
          return (com.google.firestore.v1.DocumentRemove) responseType_;
        }
        return com.google.firestore.v1.DocumentRemove.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A [Document][google.firestore.v1.Document] has been removed from a target
     * (because it is no longer relevant to that target).
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentRemove document_remove = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentRemove,
            com.google.firestore.v1.DocumentRemove.Builder,
            com.google.firestore.v1.DocumentRemoveOrBuilder>
        getDocumentRemoveFieldBuilder() {
      if (documentRemoveBuilder_ == null) {
        if (!(responseTypeCase_ == 6)) {
          responseType_ = com.google.firestore.v1.DocumentRemove.getDefaultInstance();
        }
        documentRemoveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentRemove,
                com.google.firestore.v1.DocumentRemove.Builder,
                com.google.firestore.v1.DocumentRemoveOrBuilder>(
                (com.google.firestore.v1.DocumentRemove) responseType_,
                getParentForChildren(),
                isClean());
        responseType_ = null;
      }
      responseTypeCase_ = 6;
      onChanged();
      return documentRemoveBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ExistenceFilter,
            com.google.firestore.v1.ExistenceFilter.Builder,
            com.google.firestore.v1.ExistenceFilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     *
     * @return Whether the filter field is set.
     */
    @java.lang.Override
    public boolean hasFilter() {
      return responseTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public com.google.firestore.v1.ExistenceFilter getFilter() {
      if (filterBuilder_ == null) {
        if (responseTypeCase_ == 5) {
          return (com.google.firestore.v1.ExistenceFilter) responseType_;
        }
        return com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
      } else {
        if (responseTypeCase_ == 5) {
          return filterBuilder_.getMessage();
        }
        return com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    public Builder setFilter(com.google.firestore.v1.ExistenceFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseType_ = value;
        onChanged();
      } else {
        filterBuilder_.setMessage(value);
      }
      responseTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    public Builder setFilter(com.google.firestore.v1.ExistenceFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        responseType_ = builderForValue.build();
        onChanged();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      responseTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    public Builder mergeFilter(com.google.firestore.v1.ExistenceFilter value) {
      if (filterBuilder_ == null) {
        if (responseTypeCase_ == 5
            && responseType_ != com.google.firestore.v1.ExistenceFilter.getDefaultInstance()) {
          responseType_ =
              com.google.firestore.v1.ExistenceFilter.newBuilder(
                      (com.google.firestore.v1.ExistenceFilter) responseType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          responseType_ = value;
        }
        onChanged();
      } else {
        if (responseTypeCase_ == 5) {
          filterBuilder_.mergeFrom(value);
        } else {
          filterBuilder_.setMessage(value);
        }
      }
      responseTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    public Builder clearFilter() {
      if (filterBuilder_ == null) {
        if (responseTypeCase_ == 5) {
          responseTypeCase_ = 0;
          responseType_ = null;
          onChanged();
        }
      } else {
        if (responseTypeCase_ == 5) {
          responseTypeCase_ = 0;
          responseType_ = null;
        }
        filterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    public com.google.firestore.v1.ExistenceFilter.Builder getFilterBuilder() {
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.ExistenceFilterOrBuilder getFilterOrBuilder() {
      if ((responseTypeCase_ == 5) && (filterBuilder_ != null)) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        if (responseTypeCase_ == 5) {
          return (com.google.firestore.v1.ExistenceFilter) responseType_;
        }
        return com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A filter to apply to the set of documents previously returned for the
     * given target.
     *
     * Returned when documents may have been removed from the given target, but
     * the exact documents are unknown.
     * </pre>
     *
     * <code>.google.firestore.v1.ExistenceFilter filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ExistenceFilter,
            com.google.firestore.v1.ExistenceFilter.Builder,
            com.google.firestore.v1.ExistenceFilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        if (!(responseTypeCase_ == 5)) {
          responseType_ = com.google.firestore.v1.ExistenceFilter.getDefaultInstance();
        }
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.ExistenceFilter,
                com.google.firestore.v1.ExistenceFilter.Builder,
                com.google.firestore.v1.ExistenceFilterOrBuilder>(
                (com.google.firestore.v1.ExistenceFilter) responseType_,
                getParentForChildren(),
                isClean());
        responseType_ = null;
      }
      responseTypeCase_ = 5;
      onChanged();
      return filterBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.ListenResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.ListenResponse)
  private static final com.google.firestore.v1.ListenResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.ListenResponse();
  }

  public static com.google.firestore.v1.ListenResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListenResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListenResponse>() {
        @java.lang.Override
        public ListenResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListenResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListenResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.ListenResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
