/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/bloom_filter.proto

// Protobuf Java Version: 3.25.3
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * A bloom filter (https://en.wikipedia.org/wiki/Bloom_filter).
 *
 * The bloom filter hashes the entries with MD5 and treats the resulting 128-bit
 * hash as 2 distinct 64-bit hash values, interpreted as unsigned integers
 * using 2's complement encoding.
 *
 * These two hash values, named `h1` and `h2`, are then used to compute the
 * `hash_count` hash values using the formula, starting at `i=0`:
 *
 *     h(i) = h1 + (i * h2)
 *
 * These resulting values are then taken modulo the number of bits in the bloom
 * filter to get the bits of the bloom filter to test for the given entry.
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.BloomFilter}
 */
public final class BloomFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.BloomFilter)
    BloomFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BloomFilter.newBuilder() to construct.
  private BloomFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BloomFilter() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BloomFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.BloomFilterProto
        .internal_static_google_firestore_v1_BloomFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.BloomFilterProto
        .internal_static_google_firestore_v1_BloomFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.BloomFilter.class,
            com.google.firestore.v1.BloomFilter.Builder.class);
  }

  private int bitField0_;
  public static final int BITS_FIELD_NUMBER = 1;
  private com.google.firestore.v1.BitSequence bits_;
  /**
   *
   *
   * <pre>
   * The bloom filter data.
   * </pre>
   *
   * <code>.google.firestore.v1.BitSequence bits = 1;</code>
   *
   * @return Whether the bits field is set.
   */
  @java.lang.Override
  public boolean hasBits() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The bloom filter data.
   * </pre>
   *
   * <code>.google.firestore.v1.BitSequence bits = 1;</code>
   *
   * @return The bits.
   */
  @java.lang.Override
  public com.google.firestore.v1.BitSequence getBits() {
    return bits_ == null ? com.google.firestore.v1.BitSequence.getDefaultInstance() : bits_;
  }
  /**
   *
   *
   * <pre>
   * The bloom filter data.
   * </pre>
   *
   * <code>.google.firestore.v1.BitSequence bits = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.BitSequenceOrBuilder getBitsOrBuilder() {
    return bits_ == null ? com.google.firestore.v1.BitSequence.getDefaultInstance() : bits_;
  }

  public static final int HASH_COUNT_FIELD_NUMBER = 2;
  private int hashCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of hashes used by the algorithm.
   * </pre>
   *
   * <code>int32 hash_count = 2;</code>
   *
   * @return The hashCount.
   */
  @java.lang.Override
  public int getHashCount() {
    return hashCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getBits());
    }
    if (hashCount_ != 0) {
      output.writeInt32(2, hashCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getBits());
    }
    if (hashCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, hashCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.BloomFilter)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.BloomFilter other = (com.google.firestore.v1.BloomFilter) obj;

    if (hasBits() != other.hasBits()) return false;
    if (hasBits()) {
      if (!getBits().equals(other.getBits())) return false;
    }
    if (getHashCount() != other.getHashCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBits()) {
      hash = (37 * hash) + BITS_FIELD_NUMBER;
      hash = (53 * hash) + getBits().hashCode();
    }
    hash = (37 * hash) + HASH_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getHashCount();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BloomFilter parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BloomFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BloomFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.BloomFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A bloom filter (https://en.wikipedia.org/wiki/Bloom_filter).
   *
   * The bloom filter hashes the entries with MD5 and treats the resulting 128-bit
   * hash as 2 distinct 64-bit hash values, interpreted as unsigned integers
   * using 2's complement encoding.
   *
   * These two hash values, named `h1` and `h2`, are then used to compute the
   * `hash_count` hash values using the formula, starting at `i=0`:
   *
   *     h(i) = h1 + (i * h2)
   *
   * These resulting values are then taken modulo the number of bits in the bloom
   * filter to get the bits of the bloom filter to test for the given entry.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.BloomFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.BloomFilter)
      com.google.firestore.v1.BloomFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.BloomFilterProto
          .internal_static_google_firestore_v1_BloomFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.BloomFilterProto
          .internal_static_google_firestore_v1_BloomFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.BloomFilter.class,
              com.google.firestore.v1.BloomFilter.Builder.class);
    }

    // Construct using com.google.firestore.v1.BloomFilter.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBitsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bits_ = null;
      if (bitsBuilder_ != null) {
        bitsBuilder_.dispose();
        bitsBuilder_ = null;
      }
      hashCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.BloomFilterProto
          .internal_static_google_firestore_v1_BloomFilter_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.BloomFilter getDefaultInstanceForType() {
      return com.google.firestore.v1.BloomFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.BloomFilter build() {
      com.google.firestore.v1.BloomFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.BloomFilter buildPartial() {
      com.google.firestore.v1.BloomFilter result = new com.google.firestore.v1.BloomFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.BloomFilter result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bits_ = bitsBuilder_ == null ? bits_ : bitsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.hashCount_ = hashCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.BloomFilter) {
        return mergeFrom((com.google.firestore.v1.BloomFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.BloomFilter other) {
      if (other == com.google.firestore.v1.BloomFilter.getDefaultInstance()) return this;
      if (other.hasBits()) {
        mergeBits(other.getBits());
      }
      if (other.getHashCount() != 0) {
        setHashCount(other.getHashCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getBitsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                hashCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.firestore.v1.BitSequence bits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.BitSequence,
            com.google.firestore.v1.BitSequence.Builder,
            com.google.firestore.v1.BitSequenceOrBuilder>
        bitsBuilder_;
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     *
     * @return Whether the bits field is set.
     */
    public boolean hasBits() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     *
     * @return The bits.
     */
    public com.google.firestore.v1.BitSequence getBits() {
      if (bitsBuilder_ == null) {
        return bits_ == null ? com.google.firestore.v1.BitSequence.getDefaultInstance() : bits_;
      } else {
        return bitsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public Builder setBits(com.google.firestore.v1.BitSequence value) {
      if (bitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bits_ = value;
      } else {
        bitsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public Builder setBits(com.google.firestore.v1.BitSequence.Builder builderForValue) {
      if (bitsBuilder_ == null) {
        bits_ = builderForValue.build();
      } else {
        bitsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public Builder mergeBits(com.google.firestore.v1.BitSequence value) {
      if (bitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && bits_ != null
            && bits_ != com.google.firestore.v1.BitSequence.getDefaultInstance()) {
          getBitsBuilder().mergeFrom(value);
        } else {
          bits_ = value;
        }
      } else {
        bitsBuilder_.mergeFrom(value);
      }
      if (bits_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public Builder clearBits() {
      bitField0_ = (bitField0_ & ~0x00000001);
      bits_ = null;
      if (bitsBuilder_ != null) {
        bitsBuilder_.dispose();
        bitsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public com.google.firestore.v1.BitSequence.Builder getBitsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getBitsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    public com.google.firestore.v1.BitSequenceOrBuilder getBitsOrBuilder() {
      if (bitsBuilder_ != null) {
        return bitsBuilder_.getMessageOrBuilder();
      } else {
        return bits_ == null ? com.google.firestore.v1.BitSequence.getDefaultInstance() : bits_;
      }
    }
    /**
     *
     *
     * <pre>
     * The bloom filter data.
     * </pre>
     *
     * <code>.google.firestore.v1.BitSequence bits = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.BitSequence,
            com.google.firestore.v1.BitSequence.Builder,
            com.google.firestore.v1.BitSequenceOrBuilder>
        getBitsFieldBuilder() {
      if (bitsBuilder_ == null) {
        bitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.BitSequence,
                com.google.firestore.v1.BitSequence.Builder,
                com.google.firestore.v1.BitSequenceOrBuilder>(
                getBits(), getParentForChildren(), isClean());
        bits_ = null;
      }
      return bitsBuilder_;
    }

    private int hashCount_;
    /**
     *
     *
     * <pre>
     * The number of hashes used by the algorithm.
     * </pre>
     *
     * <code>int32 hash_count = 2;</code>
     *
     * @return The hashCount.
     */
    @java.lang.Override
    public int getHashCount() {
      return hashCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of hashes used by the algorithm.
     * </pre>
     *
     * <code>int32 hash_count = 2;</code>
     *
     * @param value The hashCount to set.
     * @return This builder for chaining.
     */
    public Builder setHashCount(int value) {

      hashCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of hashes used by the algorithm.
     * </pre>
     *
     * <code>int32 hash_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHashCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      hashCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.BloomFilter)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.BloomFilter)
  private static final com.google.firestore.v1.BloomFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.BloomFilter();
  }

  public static com.google.firestore.v1.BloomFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BloomFilter> PARSER =
      new com.google.protobuf.AbstractParser<BloomFilter>() {
        @java.lang.Override
        public BloomFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BloomFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BloomFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.BloomFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
