/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.4
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The response for
 * [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.RunQueryResponse}
 */
public final class RunQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.RunQueryResponse)
    RunQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunQueryResponse.newBuilder() to construct.
  private RunQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunQueryResponse() {
    transaction_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_RunQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.RunQueryResponse.class,
            com.google.firestore.v1.RunQueryResponse.Builder.class);
  }

  private int bitField0_;
  private int continuationSelectorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object continuationSelector_;

  public enum ContinuationSelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DONE(6),
    CONTINUATIONSELECTOR_NOT_SET(0);
    private final int value;

    private ContinuationSelectorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContinuationSelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ContinuationSelectorCase forNumber(int value) {
      switch (value) {
        case 6:
          return DONE;
        case 0:
          return CONTINUATIONSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ContinuationSelectorCase getContinuationSelectorCase() {
    return ContinuationSelectorCase.forNumber(continuationSelectorCase_);
  }

  public static final int TRANSACTION_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The transaction that was started as part of this request.
   * Can only be set in the first response, and only if
   * [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction]
   * was set in the request. If set, no other fields will be set in this
   * response.
   * </pre>
   *
   * <code>bytes transaction = 2;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    return transaction_;
  }

  public static final int DOCUMENT_FIELD_NUMBER = 1;
  private com.google.firestore.v1.Document document_;
  /**
   *
   *
   * <pre>
   * A query result, not set when reporting partial progress.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1;</code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * A query result, not set when reporting partial progress.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1;</code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.firestore.v1.Document getDocument() {
    return document_ == null ? com.google.firestore.v1.Document.getDefaultInstance() : document_;
  }
  /**
   *
   *
   * <pre>
   * A query result, not set when reporting partial progress.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null ? com.google.firestore.v1.Document.getDefaultInstance() : document_;
  }

  public static final int READ_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * The time at which the document was read. This may be monotonically
   * increasing; in this case, the previous documents in the result stream are
   * guaranteed not to have changed between their `read_time` and this one.
   *
   * If the query returns no results, a response with `read_time` and no
   * `document` will be sent, and this represents the time at which the query
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which the document was read. This may be monotonically
   * increasing; in this case, the previous documents in the result stream are
   * guaranteed not to have changed between their `read_time` and this one.
   *
   * If the query returns no results, a response with `read_time` and no
   * `document` will be sent, and this represents the time at which the query
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the document was read. This may be monotonically
   * increasing; in this case, the previous documents in the result stream are
   * guaranteed not to have changed between their `read_time` and this one.
   *
   * If the query returns no results, a response with `read_time` and no
   * `document` will be sent, and this represents the time at which the query
   * was run.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  public static final int SKIPPED_RESULTS_FIELD_NUMBER = 4;
  private int skippedResults_ = 0;
  /**
   *
   *
   * <pre>
   * The number of results that have been skipped due to an offset between
   * the last response and the current response.
   * </pre>
   *
   * <code>int32 skipped_results = 4;</code>
   *
   * @return The skippedResults.
   */
  @java.lang.Override
  public int getSkippedResults() {
    return skippedResults_;
  }

  public static final int DONE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * If present, Firestore has completely finished the request and no more
   * documents will be returned.
   * </pre>
   *
   * <code>bool done = 6;</code>
   *
   * @return Whether the done field is set.
   */
  @java.lang.Override
  public boolean hasDone() {
    return continuationSelectorCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * If present, Firestore has completely finished the request and no more
   * documents will be returned.
   * </pre>
   *
   * <code>bool done = 6;</code>
   *
   * @return The done.
   */
  @java.lang.Override
  public boolean getDone() {
    if (continuationSelectorCase_ == 6) {
      return (java.lang.Boolean) continuationSelector_;
    }
    return false;
  }

  public static final int EXPLAIN_METRICS_FIELD_NUMBER = 11;
  private com.google.firestore.v1.ExplainMetrics explainMetrics_;
  /**
   *
   *
   * <pre>
   * Query explain metrics. This is only present when the
   * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
   * is provided, and it is sent only once with the last response in the stream.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
   *
   * @return Whether the explainMetrics field is set.
   */
  @java.lang.Override
  public boolean hasExplainMetrics() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Query explain metrics. This is only present when the
   * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
   * is provided, and it is sent only once with the last response in the stream.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
   *
   * @return The explainMetrics.
   */
  @java.lang.Override
  public com.google.firestore.v1.ExplainMetrics getExplainMetrics() {
    return explainMetrics_ == null
        ? com.google.firestore.v1.ExplainMetrics.getDefaultInstance()
        : explainMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Query explain metrics. This is only present when the
   * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
   * is provided, and it is sent only once with the last response in the stream.
   * </pre>
   *
   * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.ExplainMetricsOrBuilder getExplainMetricsOrBuilder() {
    return explainMetrics_ == null
        ? com.google.firestore.v1.ExplainMetrics.getDefaultInstance()
        : explainMetrics_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getDocument());
    }
    if (!transaction_.isEmpty()) {
      output.writeBytes(2, transaction_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getReadTime());
    }
    if (skippedResults_ != 0) {
      output.writeInt32(4, skippedResults_);
    }
    if (continuationSelectorCase_ == 6) {
      output.writeBool(6, (boolean) ((java.lang.Boolean) continuationSelector_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getExplainMetrics());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
    }
    if (!transaction_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, transaction_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReadTime());
    }
    if (skippedResults_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, skippedResults_);
    }
    if (continuationSelectorCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              6, (boolean) ((java.lang.Boolean) continuationSelector_));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExplainMetrics());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.RunQueryResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.RunQueryResponse other = (com.google.firestore.v1.RunQueryResponse) obj;

    if (!getTransaction().equals(other.getTransaction())) return false;
    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (getSkippedResults() != other.getSkippedResults()) return false;
    if (hasExplainMetrics() != other.hasExplainMetrics()) return false;
    if (hasExplainMetrics()) {
      if (!getExplainMetrics().equals(other.getExplainMetrics())) return false;
    }
    if (!getContinuationSelectorCase().equals(other.getContinuationSelectorCase())) return false;
    switch (continuationSelectorCase_) {
      case 6:
        if (getDone() != other.getDone()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
    hash = (53 * hash) + getTransaction().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (37 * hash) + SKIPPED_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + getSkippedResults();
    if (hasExplainMetrics()) {
      hash = (37 * hash) + EXPLAIN_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getExplainMetrics().hashCode();
    }
    switch (continuationSelectorCase_) {
      case 6:
        hash = (37 * hash) + DONE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDone());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.RunQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.RunQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for
   * [Firestore.RunQuery][google.firestore.v1.Firestore.RunQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.RunQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.RunQueryResponse)
      com.google.firestore.v1.RunQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.RunQueryResponse.class,
              com.google.firestore.v1.RunQueryResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1.RunQueryResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDocumentFieldBuilder();
        getReadTimeFieldBuilder();
        getExplainMetricsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      transaction_ = com.google.protobuf.ByteString.EMPTY;
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      skippedResults_ = 0;
      explainMetrics_ = null;
      if (explainMetricsBuilder_ != null) {
        explainMetricsBuilder_.dispose();
        explainMetricsBuilder_ = null;
      }
      continuationSelectorCase_ = 0;
      continuationSelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_RunQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryResponse getDefaultInstanceForType() {
      return com.google.firestore.v1.RunQueryResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryResponse build() {
      com.google.firestore.v1.RunQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.RunQueryResponse buildPartial() {
      com.google.firestore.v1.RunQueryResponse result =
          new com.google.firestore.v1.RunQueryResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.RunQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.transaction_ = transaction_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.skippedResults_ = skippedResults_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.explainMetrics_ =
            explainMetricsBuilder_ == null ? explainMetrics_ : explainMetricsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.RunQueryResponse result) {
      result.continuationSelectorCase_ = continuationSelectorCase_;
      result.continuationSelector_ = this.continuationSelector_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.RunQueryResponse) {
        return mergeFrom((com.google.firestore.v1.RunQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.RunQueryResponse other) {
      if (other == com.google.firestore.v1.RunQueryResponse.getDefaultInstance()) return this;
      if (other.getTransaction() != com.google.protobuf.ByteString.EMPTY) {
        setTransaction(other.getTransaction());
      }
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      if (other.getSkippedResults() != 0) {
        setSkippedResults(other.getSkippedResults());
      }
      if (other.hasExplainMetrics()) {
        mergeExplainMetrics(other.getExplainMetrics());
      }
      switch (other.getContinuationSelectorCase()) {
        case DONE:
          {
            setDone(other.getDone());
            break;
          }
        case CONTINUATIONSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                transaction_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                skippedResults_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 48:
              {
                continuationSelector_ = input.readBool();
                continuationSelectorCase_ = 6;
                break;
              } // case 48
            case 90:
              {
                input.readMessage(getExplainMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int continuationSelectorCase_ = 0;
    private java.lang.Object continuationSelector_;

    public ContinuationSelectorCase getContinuationSelectorCase() {
      return ContinuationSelectorCase.forNumber(continuationSelectorCase_);
    }

    public Builder clearContinuationSelector() {
      continuationSelectorCase_ = 0;
      continuationSelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Can only be set in the first response, and only if
     * [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction]
     * was set in the request. If set, no other fields will be set in this
     * response.
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @return The transaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTransaction() {
      return transaction_;
    }
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Can only be set in the first response, and only if
     * [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction]
     * was set in the request. If set, no other fields will be set in this
     * response.
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transaction_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The transaction that was started as part of this request.
     * Can only be set in the first response, and only if
     * [RunQueryRequest.new_transaction][google.firestore.v1.RunQueryRequest.new_transaction]
     * was set in the request. If set, no other fields will be set in this
     * response.
     * </pre>
     *
     * <code>bytes transaction = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000001);
      transaction_ = getDefaultInstance().getTransaction();
      onChanged();
      return this;
    }

    private com.google.firestore.v1.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     *
     * @return Whether the document field is set.
     */
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     *
     * @return The document.
     */
    public com.google.firestore.v1.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.firestore.v1.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public Builder setDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public Builder setDocument(com.google.firestore.v1.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public Builder mergeDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && document_ != null
            && document_ != com.google.firestore.v1.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      if (document_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000002);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public com.google.firestore.v1.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.firestore.v1.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * A query result, not set when reporting partial progress.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Document,
                com.google.firestore.v1.Document.Builder,
                com.google.firestore.v1.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
      } else {
        readTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && readTime_ != null
            && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReadTimeBuilder().mergeFrom(value);
        } else {
          readTime_ = value;
        }
      } else {
        readTimeBuilder_.mergeFrom(value);
      }
      if (readTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder clearReadTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the document was read. This may be monotonically
     * increasing; in this case, the previous documents in the result stream are
     * guaranteed not to have changed between their `read_time` and this one.
     *
     * If the query returns no results, a response with `read_time` and no
     * `document` will be sent, and this represents the time at which the query
     * was run.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    private int skippedResults_;
    /**
     *
     *
     * <pre>
     * The number of results that have been skipped due to an offset between
     * the last response and the current response.
     * </pre>
     *
     * <code>int32 skipped_results = 4;</code>
     *
     * @return The skippedResults.
     */
    @java.lang.Override
    public int getSkippedResults() {
      return skippedResults_;
    }
    /**
     *
     *
     * <pre>
     * The number of results that have been skipped due to an offset between
     * the last response and the current response.
     * </pre>
     *
     * <code>int32 skipped_results = 4;</code>
     *
     * @param value The skippedResults to set.
     * @return This builder for chaining.
     */
    public Builder setSkippedResults(int value) {

      skippedResults_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of results that have been skipped due to an offset between
     * the last response and the current response.
     * </pre>
     *
     * <code>int32 skipped_results = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkippedResults() {
      bitField0_ = (bitField0_ & ~0x00000008);
      skippedResults_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If present, Firestore has completely finished the request and no more
     * documents will be returned.
     * </pre>
     *
     * <code>bool done = 6;</code>
     *
     * @return Whether the done field is set.
     */
    public boolean hasDone() {
      return continuationSelectorCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * If present, Firestore has completely finished the request and no more
     * documents will be returned.
     * </pre>
     *
     * <code>bool done = 6;</code>
     *
     * @return The done.
     */
    public boolean getDone() {
      if (continuationSelectorCase_ == 6) {
        return (java.lang.Boolean) continuationSelector_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * If present, Firestore has completely finished the request and no more
     * documents will be returned.
     * </pre>
     *
     * <code>bool done = 6;</code>
     *
     * @param value The done to set.
     * @return This builder for chaining.
     */
    public Builder setDone(boolean value) {

      continuationSelectorCase_ = 6;
      continuationSelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, Firestore has completely finished the request and no more
     * documents will be returned.
     * </pre>
     *
     * <code>bool done = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDone() {
      if (continuationSelectorCase_ == 6) {
        continuationSelectorCase_ = 0;
        continuationSelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.firestore.v1.ExplainMetrics explainMetrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ExplainMetrics,
            com.google.firestore.v1.ExplainMetrics.Builder,
            com.google.firestore.v1.ExplainMetricsOrBuilder>
        explainMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     *
     * @return Whether the explainMetrics field is set.
     */
    public boolean hasExplainMetrics() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     *
     * @return The explainMetrics.
     */
    public com.google.firestore.v1.ExplainMetrics getExplainMetrics() {
      if (explainMetricsBuilder_ == null) {
        return explainMetrics_ == null
            ? com.google.firestore.v1.ExplainMetrics.getDefaultInstance()
            : explainMetrics_;
      } else {
        return explainMetricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public Builder setExplainMetrics(com.google.firestore.v1.ExplainMetrics value) {
      if (explainMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explainMetrics_ = value;
      } else {
        explainMetricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public Builder setExplainMetrics(
        com.google.firestore.v1.ExplainMetrics.Builder builderForValue) {
      if (explainMetricsBuilder_ == null) {
        explainMetrics_ = builderForValue.build();
      } else {
        explainMetricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public Builder mergeExplainMetrics(com.google.firestore.v1.ExplainMetrics value) {
      if (explainMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && explainMetrics_ != null
            && explainMetrics_ != com.google.firestore.v1.ExplainMetrics.getDefaultInstance()) {
          getExplainMetricsBuilder().mergeFrom(value);
        } else {
          explainMetrics_ = value;
        }
      } else {
        explainMetricsBuilder_.mergeFrom(value);
      }
      if (explainMetrics_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public Builder clearExplainMetrics() {
      bitField0_ = (bitField0_ & ~0x00000020);
      explainMetrics_ = null;
      if (explainMetricsBuilder_ != null) {
        explainMetricsBuilder_.dispose();
        explainMetricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public com.google.firestore.v1.ExplainMetrics.Builder getExplainMetricsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getExplainMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    public com.google.firestore.v1.ExplainMetricsOrBuilder getExplainMetricsOrBuilder() {
      if (explainMetricsBuilder_ != null) {
        return explainMetricsBuilder_.getMessageOrBuilder();
      } else {
        return explainMetrics_ == null
            ? com.google.firestore.v1.ExplainMetrics.getDefaultInstance()
            : explainMetrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query explain metrics. This is only present when the
     * [RunQueryRequest.explain_options][google.firestore.v1.RunQueryRequest.explain_options]
     * is provided, and it is sent only once with the last response in the stream.
     * </pre>
     *
     * <code>.google.firestore.v1.ExplainMetrics explain_metrics = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.ExplainMetrics,
            com.google.firestore.v1.ExplainMetrics.Builder,
            com.google.firestore.v1.ExplainMetricsOrBuilder>
        getExplainMetricsFieldBuilder() {
      if (explainMetricsBuilder_ == null) {
        explainMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.ExplainMetrics,
                com.google.firestore.v1.ExplainMetrics.Builder,
                com.google.firestore.v1.ExplainMetricsOrBuilder>(
                getExplainMetrics(), getParentForChildren(), isClean());
        explainMetrics_ = null;
      }
      return explainMetricsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.RunQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.RunQueryResponse)
  private static final com.google.firestore.v1.RunQueryResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.RunQueryResponse();
  }

  public static com.google.firestore.v1.RunQueryResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<RunQueryResponse>() {
        @java.lang.Override
        public RunQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RunQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.RunQueryResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
