/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.5
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.BatchGetDocumentsRequest}
 */
public final class BatchGetDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.BatchGetDocumentsRequest)
    BatchGetDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchGetDocumentsRequest.newBuilder() to construct.
  private BatchGetDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchGetDocumentsRequest() {
    database_ = "";
    documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchGetDocumentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchGetDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchGetDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.BatchGetDocumentsRequest.class,
            com.google.firestore.v1.BatchGetDocumentsRequest.Builder.class);
  }

  private int bitField0_;
  private int consistencySelectorCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object consistencySelector_;

  public enum ConsistencySelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(4),
    NEW_TRANSACTION(5),
    READ_TIME(7),
    CONSISTENCYSELECTOR_NOT_SET(0);
    private final int value;

    private ConsistencySelectorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConsistencySelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConsistencySelectorCase forNumber(int value) {
      switch (value) {
        case 4:
          return TRANSACTION;
        case 5:
          return NEW_TRANSACTION;
        case 7:
          return READ_TIME;
        case 0:
          return CONSISTENCYSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConsistencySelectorCase getConsistencySelectorCase() {
    return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCUMENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList documents_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The names of the documents to retrieve. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * The request will fail if any of the document is not a child resource of the
   * given `database`. Duplicate names will be elided.
   * </pre>
   *
   * <code>repeated string documents = 2;</code>
   *
   * @return A list containing the documents.
   */
  public com.google.protobuf.ProtocolStringList getDocumentsList() {
    return documents_;
  }
  /**
   *
   *
   * <pre>
   * The names of the documents to retrieve. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * The request will fail if any of the document is not a child resource of the
   * given `database`. Duplicate names will be elided.
   * </pre>
   *
   * <code>repeated string documents = 2;</code>
   *
   * @return The count of documents.
   */
  public int getDocumentsCount() {
    return documents_.size();
  }
  /**
   *
   *
   * <pre>
   * The names of the documents to retrieve. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * The request will fail if any of the document is not a child resource of the
   * given `database`. Duplicate names will be elided.
   * </pre>
   *
   * <code>repeated string documents = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The documents at the given index.
   */
  public java.lang.String getDocuments(int index) {
    return documents_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The names of the documents to retrieve. In the format:
   * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
   * The request will fail if any of the document is not a child resource of the
   * given `database`. Duplicate names will be elided.
   * </pre>
   *
   * <code>repeated string documents = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the documents at the given index.
   */
  public com.google.protobuf.ByteString getDocumentsBytes(int index) {
    return documents_.getByteString(index);
  }

  public static final int MASK_FIELD_NUMBER = 3;
  private com.google.firestore.v1.DocumentMask mask_;
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field will
   * not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   *
   * @return Whether the mask field is set.
   */
  @java.lang.Override
  public boolean hasMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field will
   * not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   *
   * @return The mask.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMask getMask() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If a document has a field that is not present in this mask, that field will
   * not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }

  public static final int TRANSACTION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Reads documents in a transaction.
   * </pre>
   *
   * <code>bytes transaction = 4;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return consistencySelectorCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Reads documents in a transaction.
   * </pre>
   *
   * <code>bytes transaction = 4;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (consistencySelectorCase_ == 4) {
      return (com.google.protobuf.ByteString) consistencySelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int NEW_TRANSACTION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   *
   * @return Whether the newTransaction field is set.
   */
  @java.lang.Override
  public boolean hasNewTransaction() {
    return consistencySelectorCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   *
   * @return The newTransaction.
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptions getNewTransaction() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Starts a new transaction and reads the documents.
   * Defaults to a read-only transaction.
   * The new transaction ID will be returned as the first response in the
   * stream.
   * </pre>
   *
   * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
    if (consistencySelectorCase_ == 5) {
      return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
    }
    return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
  }

  public static final int READ_TIME_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return consistencySelectorCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Reads documents as they were at the given time.
   *
   * This must be a microsecond precision timestamp within the past one hour,
   * or if Point-in-Time Recovery is enabled, can additionally be a whole
   * minute timestamp within the past 7 days.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    if (consistencySelectorCase_ == 7) {
      return (com.google.protobuf.Timestamp) consistencySelector_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < documents_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, documents_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMask());
    }
    if (consistencySelectorCase_ == 4) {
      output.writeBytes(4, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 5) {
      output.writeMessage(5, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < documents_.size(); i++) {
        dataSize += computeStringSizeNoTag(documents_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDocumentsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMask());
    }
    if (consistencySelectorCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              4, (com.google.protobuf.ByteString) consistencySelector_);
    }
    if (consistencySelectorCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.firestore.v1.TransactionOptions) consistencySelector_);
    }
    if (consistencySelectorCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Timestamp) consistencySelector_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.BatchGetDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.BatchGetDocumentsRequest other =
        (com.google.firestore.v1.BatchGetDocumentsRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getDocumentsList().equals(other.getDocumentsList())) return false;
    if (hasMask() != other.hasMask()) return false;
    if (hasMask()) {
      if (!getMask().equals(other.getMask())) return false;
    }
    if (!getConsistencySelectorCase().equals(other.getConsistencySelectorCase())) return false;
    switch (consistencySelectorCase_) {
      case 4:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 5:
        if (!getNewTransaction().equals(other.getNewTransaction())) return false;
        break;
      case 7:
        if (!getReadTime().equals(other.getReadTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getDocumentsCount() > 0) {
      hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentsList().hashCode();
    }
    if (hasMask()) {
      hash = (37 * hash) + MASK_FIELD_NUMBER;
      hash = (53 * hash) + getMask().hashCode();
    }
    switch (consistencySelectorCase_) {
      case 4:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 5:
        hash = (37 * hash) + NEW_TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getNewTransaction().hashCode();
        break;
      case 7:
        hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getReadTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.BatchGetDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.BatchGetDocuments][google.firestore.v1.Firestore.BatchGetDocuments].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.BatchGetDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.BatchGetDocumentsRequest)
      com.google.firestore.v1.BatchGetDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.BatchGetDocumentsRequest.class,
              com.google.firestore.v1.BatchGetDocumentsRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.BatchGetDocumentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      if (newTransactionBuilder_ != null) {
        newTransactionBuilder_.clear();
      }
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.clear();
      }
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchGetDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.BatchGetDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsRequest build() {
      com.google.firestore.v1.BatchGetDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchGetDocumentsRequest buildPartial() {
      com.google.firestore.v1.BatchGetDocumentsRequest result =
          new com.google.firestore.v1.BatchGetDocumentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.BatchGetDocumentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        documents_.makeImmutable();
        result.documents_ = documents_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.mask_ = maskBuilder_ == null ? mask_ : maskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.BatchGetDocumentsRequest result) {
      result.consistencySelectorCase_ = consistencySelectorCase_;
      result.consistencySelector_ = this.consistencySelector_;
      if (consistencySelectorCase_ == 5 && newTransactionBuilder_ != null) {
        result.consistencySelector_ = newTransactionBuilder_.build();
      }
      if (consistencySelectorCase_ == 7 && readTimeBuilder_ != null) {
        result.consistencySelector_ = readTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.BatchGetDocumentsRequest) {
        return mergeFrom((com.google.firestore.v1.BatchGetDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.BatchGetDocumentsRequest other) {
      if (other == com.google.firestore.v1.BatchGetDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.documents_.isEmpty()) {
        if (documents_.isEmpty()) {
          documents_ = other.documents_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDocumentsIsMutable();
          documents_.addAll(other.documents_);
        }
        onChanged();
      }
      if (other.hasMask()) {
        mergeMask(other.getMask());
      }
      switch (other.getConsistencySelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case NEW_TRANSACTION:
          {
            mergeNewTransaction(other.getNewTransaction());
            break;
          }
        case READ_TIME:
          {
            mergeReadTime(other.getReadTime());
            break;
          }
        case CONSISTENCYSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDocumentsIsMutable();
                documents_.add(s);
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                consistencySelector_ = input.readBytes();
                consistencySelectorCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getNewTransactionFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 5;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                consistencySelectorCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int consistencySelectorCase_ = 0;
    private java.lang.Object consistencySelector_;

    public ConsistencySelectorCase getConsistencySelectorCase() {
      return ConsistencySelectorCase.forNumber(consistencySelectorCase_);
    }

    public Builder clearConsistencySelector() {
      consistencySelectorCase_ = 0;
      consistencySelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList documents_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDocumentsIsMutable() {
      if (!documents_.isModifiable()) {
        documents_ = new com.google.protobuf.LazyStringArrayList(documents_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return A list containing the documents.
     */
    public com.google.protobuf.ProtocolStringList getDocumentsList() {
      documents_.makeImmutable();
      return documents_;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return The count of documents.
     */
    public int getDocumentsCount() {
      return documents_.size();
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The documents at the given index.
     */
    public java.lang.String getDocuments(int index) {
      return documents_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the documents at the given index.
     */
    public com.google.protobuf.ByteString getDocumentsBytes(int index) {
      return documents_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The documents to set.
     * @return This builder for chaining.
     */
    public Builder setDocuments(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDocumentsIsMutable();
      documents_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param value The documents to add.
     * @return This builder for chaining.
     */
    public Builder addDocuments(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDocumentsIsMutable();
      documents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param values The documents to add.
     * @return This builder for chaining.
     */
    public Builder addAllDocuments(java.lang.Iterable<java.lang.String> values) {
      ensureDocumentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDocuments() {
      documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The names of the documents to retrieve. In the format:
     * `projects/{project_id}/databases/{database_id}/documents/{document_path}`.
     * The request will fail if any of the document is not a child resource of the
     * given `database`. Duplicate names will be elided.
     * </pre>
     *
     * <code>repeated string documents = 2;</code>
     *
     * @param value The bytes of the documents to add.
     * @return This builder for chaining.
     */
    public Builder addDocumentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDocumentsIsMutable();
      documents_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.firestore.v1.DocumentMask mask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        maskBuilder_;
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     *
     * @return Whether the mask field is set.
     */
    public boolean hasMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     *
     * @return The mask.
     */
    public com.google.firestore.v1.DocumentMask getMask() {
      if (maskBuilder_ == null) {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      } else {
        return maskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mask_ = value;
      } else {
        maskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask.Builder builderForValue) {
      if (maskBuilder_ == null) {
        mask_ = builderForValue.build();
      } else {
        maskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder mergeMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && mask_ != null
            && mask_ != com.google.firestore.v1.DocumentMask.getDefaultInstance()) {
          getMaskBuilder().mergeFrom(value);
        } else {
          mask_ = value;
        }
      } else {
        maskBuilder_.mergeFrom(value);
      }
      if (mask_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder clearMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public com.google.firestore.v1.DocumentMask.Builder getMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
      if (maskBuilder_ != null) {
        return maskBuilder_.getMessageOrBuilder();
      } else {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If a document has a field that is not present in this mask, that field will
     * not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        getMaskFieldBuilder() {
      if (maskBuilder_ == null) {
        maskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentMask,
                com.google.firestore.v1.DocumentMask.Builder,
                com.google.firestore.v1.DocumentMaskOrBuilder>(
                getMask(), getParentForChildren(), isClean());
        mask_ = null;
      }
      return maskBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return consistencySelectorCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (consistencySelectorCase_ == 4) {
        return (com.google.protobuf.ByteString) consistencySelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      consistencySelectorCase_ = 4;
      consistencySelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents in a transaction.
     * </pre>
     *
     * <code>bytes transaction = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (consistencySelectorCase_ == 4) {
        consistencySelectorCase_ = 0;
        consistencySelector_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        newTransactionBuilder_;
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     *
     * @return Whether the newTransaction field is set.
     */
    @java.lang.Override
    public boolean hasNewTransaction() {
      return consistencySelectorCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     *
     * @return The newTransaction.
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptions getNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 5) {
          return newTransactionBuilder_.getMessage();
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder setNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder setNewTransaction(
        com.google.firestore.v1.TransactionOptions.Builder builderForValue) {
      if (newTransactionBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        newTransactionBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder mergeNewTransaction(com.google.firestore.v1.TransactionOptions value) {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5
            && consistencySelector_
                != com.google.firestore.v1.TransactionOptions.getDefaultInstance()) {
          consistencySelector_ =
              com.google.firestore.v1.TransactionOptions.newBuilder(
                      (com.google.firestore.v1.TransactionOptions) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 5) {
          newTransactionBuilder_.mergeFrom(value);
        } else {
          newTransactionBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public Builder clearNewTransaction() {
      if (newTransactionBuilder_ == null) {
        if (consistencySelectorCase_ == 5) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 5) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        newTransactionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    public com.google.firestore.v1.TransactionOptions.Builder getNewTransactionBuilder() {
      return getNewTransactionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.TransactionOptionsOrBuilder getNewTransactionOrBuilder() {
      if ((consistencySelectorCase_ == 5) && (newTransactionBuilder_ != null)) {
        return newTransactionBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 5) {
          return (com.google.firestore.v1.TransactionOptions) consistencySelector_;
        }
        return com.google.firestore.v1.TransactionOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starts a new transaction and reads the documents.
     * Defaults to a read-only transaction.
     * The new transaction ID will be returned as the first response in the
     * stream.
     * </pre>
     *
     * <code>.google.firestore.v1.TransactionOptions new_transaction = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.TransactionOptions,
            com.google.firestore.v1.TransactionOptions.Builder,
            com.google.firestore.v1.TransactionOptionsOrBuilder>
        getNewTransactionFieldBuilder() {
      if (newTransactionBuilder_ == null) {
        if (!(consistencySelectorCase_ == 5)) {
          consistencySelector_ = com.google.firestore.v1.TransactionOptions.getDefaultInstance();
        }
        newTransactionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.TransactionOptions,
                com.google.firestore.v1.TransactionOptions.Builder,
                com.google.firestore.v1.TransactionOptionsOrBuilder>(
                (com.google.firestore.v1.TransactionOptions) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 5;
      onChanged();
      return newTransactionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return Whether the readTime field is set.
     */
    @java.lang.Override
    public boolean hasReadTime() {
      return consistencySelectorCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return The readTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (consistencySelectorCase_ == 7) {
          return readTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consistencySelector_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        consistencySelector_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7
            && consistencySelector_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          consistencySelector_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) consistencySelector_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consistencySelector_ = value;
        }
        onChanged();
      } else {
        if (consistencySelectorCase_ == 7) {
          readTimeBuilder_.mergeFrom(value);
        } else {
          readTimeBuilder_.setMessage(value);
        }
      }
      consistencySelectorCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
          onChanged();
        }
      } else {
        if (consistencySelectorCase_ == 7) {
          consistencySelectorCase_ = 0;
          consistencySelector_ = null;
        }
        readTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if ((consistencySelectorCase_ == 7) && (readTimeBuilder_ != null)) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        if (consistencySelectorCase_ == 7) {
          return (com.google.protobuf.Timestamp) consistencySelector_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Reads documents as they were at the given time.
     *
     * This must be a microsecond precision timestamp within the past one hour,
     * or if Point-in-Time Recovery is enabled, can additionally be a whole
     * minute timestamp within the past 7 days.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        if (!(consistencySelectorCase_ == 7)) {
          consistencySelector_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) consistencySelector_,
                getParentForChildren(),
                isClean());
        consistencySelector_ = null;
      }
      consistencySelectorCase_ = 7;
      onChanged();
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.BatchGetDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.BatchGetDocumentsRequest)
  private static final com.google.firestore.v1.BatchGetDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.BatchGetDocumentsRequest();
  }

  public static com.google.firestore.v1.BatchGetDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchGetDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchGetDocumentsRequest>() {
        @java.lang.Override
        public BatchGetDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchGetDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchGetDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.BatchGetDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
