/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

// Protobuf Java Version: 3.25.5
package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.BatchWrite][google.firestore.v1.Firestore.BatchWrite].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.BatchWriteRequest}
 */
public final class BatchWriteRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.BatchWriteRequest)
    BatchWriteRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchWriteRequest.newBuilder() to construct.
  private BatchWriteRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchWriteRequest() {
    database_ = "";
    writes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchWriteRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchWriteRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_BatchWriteRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.BatchWriteRequest.class,
            com.google.firestore.v1.BatchWriteRequest.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";

  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The database name. In the format:
   * `projects/{project_id}/databases/{database_id}`.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WRITES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.v1.Write> writes_;

  /**
   *
   *
   * <pre>
   * The writes to apply.
   *
   * Method does not apply writes atomically and does not guarantee ordering.
   * Each write succeeds or fails independently. You cannot write to the same
   * document more than once per request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.Write> getWritesList() {
    return writes_;
  }

  /**
   *
   *
   * <pre>
   * The writes to apply.
   *
   * Method does not apply writes atomically and does not guarantee ordering.
   * Each write succeeds or fails independently. You cannot write to the same
   * document more than once per request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.v1.WriteOrBuilder> getWritesOrBuilderList() {
    return writes_;
  }

  /**
   *
   *
   * <pre>
   * The writes to apply.
   *
   * Method does not apply writes atomically and does not guarantee ordering.
   * Each write succeeds or fails independently. You cannot write to the same
   * document more than once per request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 2;</code>
   */
  @java.lang.Override
  public int getWritesCount() {
    return writes_.size();
  }

  /**
   *
   *
   * <pre>
   * The writes to apply.
   *
   * Method does not apply writes atomically and does not guarantee ordering.
   * Each write succeeds or fails independently. You cannot write to the same
   * document more than once per request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Write getWrites(int index) {
    return writes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The writes to apply.
   *
   * Method does not apply writes atomically and does not guarantee ordering.
   * Each write succeeds or fails independently. You cannot write to the same
   * document more than once per request.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Write writes = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.WriteOrBuilder getWritesOrBuilder(int index) {
    return writes_.get(index);
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.firestore.v1.FirestoreProto
                .internal_static_google_firestore_v1_BatchWriteRequest_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels associated with this batch write.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels associated with this batch write.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels associated with this batch write.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels associated with this batch write.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < writes_.size(); i++) {
      output.writeMessage(2, writes_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    for (int i = 0; i < writes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, writes_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.BatchWriteRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.BatchWriteRequest other =
        (com.google.firestore.v1.BatchWriteRequest) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getWritesList().equals(other.getWritesList())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getWritesCount() > 0) {
      hash = (37 * hash) + WRITES_FIELD_NUMBER;
      hash = (53 * hash) + getWritesList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.BatchWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.BatchWriteRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.BatchWrite][google.firestore.v1.Firestore.BatchWrite].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.BatchWriteRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.BatchWriteRequest)
      com.google.firestore.v1.BatchWriteRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchWriteRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchWriteRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.BatchWriteRequest.class,
              com.google.firestore.v1.BatchWriteRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.BatchWriteRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      if (writesBuilder_ == null) {
        writes_ = java.util.Collections.emptyList();
      } else {
        writes_ = null;
        writesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_BatchWriteRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchWriteRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.BatchWriteRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchWriteRequest build() {
      com.google.firestore.v1.BatchWriteRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.BatchWriteRequest buildPartial() {
      com.google.firestore.v1.BatchWriteRequest result =
          new com.google.firestore.v1.BatchWriteRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.firestore.v1.BatchWriteRequest result) {
      if (writesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          writes_ = java.util.Collections.unmodifiableList(writes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.writes_ = writes_;
      } else {
        result.writes_ = writesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.v1.BatchWriteRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.BatchWriteRequest) {
        return mergeFrom((com.google.firestore.v1.BatchWriteRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.BatchWriteRequest other) {
      if (other == com.google.firestore.v1.BatchWriteRequest.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (writesBuilder_ == null) {
        if (!other.writes_.isEmpty()) {
          if (writes_.isEmpty()) {
            writes_ = other.writes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureWritesIsMutable();
            writes_.addAll(other.writes_);
          }
          onChanged();
        }
      } else {
        if (!other.writes_.isEmpty()) {
          if (writesBuilder_.isEmpty()) {
            writesBuilder_.dispose();
            writesBuilder_ = null;
            writes_ = other.writes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            writesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWritesFieldBuilder()
                    : null;
          } else {
            writesBuilder_.addAllMessages(other.writes_);
          }
        }
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.firestore.v1.Write m =
                    input.readMessage(com.google.firestore.v1.Write.parser(), extensionRegistry);
                if (writesBuilder_ == null) {
                  ensureWritesIsMutable();
                  writes_.add(m);
                } else {
                  writesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";

    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The database name. In the format:
     * `projects/{project_id}/databases/{database_id}`.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.firestore.v1.Write> writes_ =
        java.util.Collections.emptyList();

    private void ensureWritesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        writes_ = new java.util.ArrayList<com.google.firestore.v1.Write>(writes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Write,
            com.google.firestore.v1.Write.Builder,
            com.google.firestore.v1.WriteOrBuilder>
        writesBuilder_;

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public java.util.List<com.google.firestore.v1.Write> getWritesList() {
      if (writesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(writes_);
      } else {
        return writesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public int getWritesCount() {
      if (writesBuilder_ == null) {
        return writes_.size();
      } else {
        return writesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public com.google.firestore.v1.Write getWrites(int index) {
      if (writesBuilder_ == null) {
        return writes_.get(index);
      } else {
        return writesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder setWrites(int index, com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.set(index, value);
        onChanged();
      } else {
        writesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder setWrites(int index, com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.set(index, builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder addWrites(com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.add(value);
        onChanged();
      } else {
        writesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder addWrites(int index, com.google.firestore.v1.Write value) {
      if (writesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWritesIsMutable();
        writes_.add(index, value);
        onChanged();
      } else {
        writesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder addWrites(com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.add(builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder addWrites(int index, com.google.firestore.v1.Write.Builder builderForValue) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.add(index, builderForValue.build());
        onChanged();
      } else {
        writesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder addAllWrites(
        java.lang.Iterable<? extends com.google.firestore.v1.Write> values) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, writes_);
        onChanged();
      } else {
        writesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder clearWrites() {
      if (writesBuilder_ == null) {
        writes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        writesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public Builder removeWrites(int index) {
      if (writesBuilder_ == null) {
        ensureWritesIsMutable();
        writes_.remove(index);
        onChanged();
      } else {
        writesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public com.google.firestore.v1.Write.Builder getWritesBuilder(int index) {
      return getWritesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public com.google.firestore.v1.WriteOrBuilder getWritesOrBuilder(int index) {
      if (writesBuilder_ == null) {
        return writes_.get(index);
      } else {
        return writesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public java.util.List<? extends com.google.firestore.v1.WriteOrBuilder>
        getWritesOrBuilderList() {
      if (writesBuilder_ != null) {
        return writesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(writes_);
      }
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public com.google.firestore.v1.Write.Builder addWritesBuilder() {
      return getWritesFieldBuilder().addBuilder(com.google.firestore.v1.Write.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public com.google.firestore.v1.Write.Builder addWritesBuilder(int index) {
      return getWritesFieldBuilder()
          .addBuilder(index, com.google.firestore.v1.Write.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The writes to apply.
     *
     * Method does not apply writes atomically and does not guarantee ordering.
     * Each write succeeds or fails independently. You cannot write to the same
     * document more than once per request.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Write writes = 2;</code>
     */
    public java.util.List<com.google.firestore.v1.Write.Builder> getWritesBuilderList() {
      return getWritesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Write,
            com.google.firestore.v1.Write.Builder,
            com.google.firestore.v1.WriteOrBuilder>
        getWritesFieldBuilder() {
      if (writesBuilder_ == null) {
        writesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1.Write,
                com.google.firestore.v1.Write.Builder,
                com.google.firestore.v1.WriteOrBuilder>(
                writes_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        writes_ = null;
      }
      return writesBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels associated with this batch write.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.BatchWriteRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.BatchWriteRequest)
  private static final com.google.firestore.v1.BatchWriteRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.BatchWriteRequest();
  }

  public static com.google.firestore.v1.BatchWriteRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchWriteRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchWriteRequest>() {
        @java.lang.Override
        public BatchWriteRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchWriteRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchWriteRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.BatchWriteRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
